---
title: "Uppy 0.12: Responsive. Cancel. Feedback. Refreshed ES6 server"
date: 2016-12-07
author: arturi
published: true
---

Hello! Here’s what’s new in Uppy 0.12.

## Dashboard: local mode and multipart uploads support in UI

Prior to this release, we’ve optimized the Dashboard for usage with multiple “acquire plugins”, say Webcam + Google Drive. But sometimes all you need is “local disk” with drag & drop support, nice file previews and progress. And now the Dashboard UI works great with that use case out of the box. When you don’t add (.use) any acquire plugins, it looks like this:

<figure class="wide"><img src="/images/blog/0.12/uppy-dashboard-local.jpg"></figure>

Also (prior to this release), we’ve built the Dashboard to work well with [tus resumable uploads](http://tus.io). That’s why you can pause and resume individual uploads, as well as all at once. But if you use an endpoint that is not yet ready for the future and upload resumability (here’s [how](https://github.com/tus/tus-node-server) to [fix that](https://github.com/tus/tusd), by the way), the Dashboard UI will show regular “cancel” buttons instead of pause/resume.

Dashboard is gradually becoming more mobile friendly too, but we’ll be saving some of that stuff for the next release.

## Server

Uppy server has undergone a quite a few changes, including the build setup:

- We are using ES2015, transpiling to ES5 with Babel.
- Added linting, lint-staged, pre-commit all that good stuff.
- Added `npm run release` command that publishes releases for us.
- Google Drive is working again on the Uppy Server side.
- Refactoring, error handling and more minor improvements.

<!-- more -->

## And

- The website now features a video demo of Uppy in action, check it out: http://uppy.io.
- Fixed a bug where the Webcam would continue to be active (green light on) even after the picture was taken — all good now.
- Improved import/require support for ES2015 and CommonJS modules. Basically, we don’t recommend ES2015 spread imports as a default option just yet — no tree shaking in Browserify and Webpack 1. Both `import DragDrop from 'uppy/lib/plugin/DragDrop'` and `const DragDrop = require('uppy/lib/plugin/DragDrop')` are now supported. We’ve added `add-module-exports` babel plugin that replaces `export default` with `module.exports` for backwards compatibility.
- Optimized dependencies a little: removed the ones we don’t use, upgraded some that we do.

## Release Notes

Here is the full list of changes for version 0.12:

- meta: write 0.12 release blog post (@arturi)
- core: figure out import/require for core and plugins — just don’t use spread for plugins (@arturi)
- meta: create a demo GIF, showcasing Uppy Dashboard for the main page, like https://zeit.co/blog/next (@arturi)
- meta: update Readme, update screenshot (@arturi)
- server: add pre-commit and lint-staged (@arturi)
- server: re-do build setup: building at `deploy` and `prepublish` when typing `npm run release:patch` 0.0.1 -> 0.0.2 (@ifedapoolarewaju)
- server: re-do build setup: es6 `src` -> es5 `lib` (use plugin packs from Uppy)
- server: re-do build setup: `eslint --fix ./src` via http://standardjs.com (@ifedapoolarewaju)
- server: re-do build setup: `babel-node` or `babel-require` could do realtime transpiling for development (how does that hook in with e.g. `nodemon`?) (@ifedapoolarewaju)
- server: refacor: remove/reduce file redundancy (@ifedapoolarewaju)
- server: error handling: 404 and 401 error handler (@ifedapoolarewaju)
- server: bug fix: failing google drive (@ifedapoolarewaju)
- webcam: stop using the webcam (green light off) after the picture is taken / tab is hidden (@arturi)
- core: allow usage without `new`, start renaming `Core()` to `Uppy()` in examples (@arturi)
- core: api — consider [Yosh’s feedback and proposals](https://gist.github.com/yoshuawuyts/b5e5b3e7aacbee85a3e61b8a626709ab), come up with follow up questions (@arturi)
- dashboard: local mode — no acquire plugins / external services, just DnD. ActionBrowseTagline component (@arturi)
- dashboard: only show pause/resume when tus is used (@arturi)
- dashboard: cancel uploads button for multipart (@arturi)
- dashboard: responsive design — stage 1 (@arturi)
- meta: write 0.11 release blog post (@arturi)

The Uppy Team
