---
title: "Uppy 0.10: Getting together, the future, Google Drive UI, exposed events"
date: 2016-09-28
author: arturi
published: true
---

Hi! Another month has passed and we have just released a new version of Uppy. Here’s what we’ve been up to.

## Thinking about the future 🔮

We have been spending quite a lot of time thinking about Uppy's future and the direction in which we would like to take this project.  Our primary concern is making Uppy as flexible as possible as well as compatible with popular libraries, such as React and React Native.  We also want to make it easy to port Uppy to any environments or ecosystems that are not officially supported.

We have done a lot of research. We created [prototypes of Uppy React components](https://github.com/hedgerh/uppy-react) and  we also created a new module that we like to call "Uppy Base." [`uppy-base`](https://github.com/hedgerh/uppy-base) is a thin module containing reusable functionality from some of our plugins that can be used in any ecosystem or environment, without being opinionated about the UI.

<!-- more -->

Finally, we are also discussing using [Redux](https://github.com/reactjs/redux) as the internal state management store within Uppy.  You can see some drafts under the [`src/experimental` folder](https://github.com/transloadit/uppy/tree/master/src/experimental).

Have a look at the [Uppy Base repository here](https://github.com/hedgerh/uppy-base).

Check out [our Uppy React wrapper and components](https://github.com/hedgerh/uppy-react), which are built on top of Uppy Base.

Finally, we have played a bit with [CSS Modules](https://github.com/css-modules) and [CSJS](https://github.com/rtsao/csjs).  We have also tried generating preview thumbnails in Web Workers, as well as with [Pica library](https://github.com/nodeca/pica).

We would love to hear feedback on all of this.  Please join our discussion at: <https://github.com/transloadit/uppy/issues/116>

You are, of course, more than welcome to chime in on other issues or to open new ones!

## Dashboard: refreshed look and new features

In an attempt to be brave and keep things simple, we have removed the dashed border from inside the Dashboard, rewritten its layout with flexbox, and tried out a new [blend-in-with-the-background-and-blur](https://cloud.githubusercontent.com/assets/1199054/18763191/35d31ddc-80da-11e6-9a2c-c46388857135.png) mode.

<img alt="Refreshed Dashboard UI" src="/images/blog/0.10/dashboard-sep-27-2016.jpg">

Uppy now also has the option to render the Dashboard inline on the page, instead of the default full modal dialog. To try it out, set `inline: true` in options, like this: `uppy.use(Dashboard, {target: '.myContainer', inline: true})`.

We have also added a circular progress bar that shows total upload progress, combined with a pause all / resume all button, and an info panel that shows speed, ETA and status for all uploads currently in progress. So you'll have something fun and useful to look at while you are waiting!

<img alt="Dashboard UI with global pause/resume buttons and a status bar — progress speed & ETA" src="/images/blog/0.10/dashboard-pause-resume-sep-27-2016.jpg">

Be sure not to miss out on the new Copy Link button that appears after a successful upload, right where the edit button usually is. We know, that’s pretty exciting! And it gets even better: when you click on it, the link is copied to your clipboard. Or, in less capable browsers, a window pops up with a text link, so you can copy it yourself. Bananas!

## Google Drive UI improved

The UI for Google Drive has received a fresh new redesign.  Check it out!

<img alt="The redesigned file browser UI for Google Drive" src="/images/blog/0.10/google-drive-ui-sep-27-2016.jpg">

## Listen to events

We have finally begun to expose events on the `uppy` instance, so you can now subscribe to them and use them in your app. For example, in order to display an image in your UI after it has been successfully uploaded:

``` javascript
uppy.on('core:upload-success', (id, url) => {
  var img = new Image()
  img.width = 300
  img.alt = id
  img.src = url
  document.body.appendChild(img)
})
```

There is also `core:upload-progress` to track progress and `core:success` for when all uploads are complete. The [event documentation](https://github.com/transloadit/uppy/#api) is quite small right now, we’ll be adding more once we sort out the API.

## But wait, there’s more!

* i18n strings now extend default en_US dictionary: if a certain string is not available in a language, the English string will be displayed.
* Updated readme: improved usage docs and CDN links. Check out [the new usage section](https://github.com/transloadit/uppy/#usage) for yourself. Import, require or script tag? In any case, we’ve got your back.
* Capabilities: we have added `capabilities` to the state.  For example, if 'tus' resumable uploader is used, `capabilities.resumable === true` is added to the state, so it is easy to check what upload capabilities are available. More to come.

## Release Notes

Here is the full list of changes for version 0.10.0:

- core: expose some events/APIs/callbacks to the user: `onFileUploaded`, `onFileSelected`, `onAllUploaded`, `addFile` (or `parseFile`), open modal... (@arturi, @hedgerh)
- core: how would Uppy work without the UI, if one wants to Uppy to just add files and upload, while rendering preview and UI by themselves #116 — discussion Part 1 (@arturi, @hedgerh)
- core: refactor towards react compatibility as discussed in https://github.com/transloadit/uppy/issues/110 (@hedgerh)
- core: CSS modules? allow bundling of CSS in JS for simple use in NPM? See #120#issuecomment-242455042, try https://github.com/rtsao/csjs — verdict: not yet, try again later (@arturi, @hedgerh)
- core: try Web Workers and FileReaderSync for image resizing again — still slow, probably message payload between webworker and regular thread is huge (@arturi)
- core: i18n strings should extend default en_US dictionary — if a certain string in not available in German, English should be displayed (@arturi)
- dashboard: refactor to smaller components, pass props down (@arturi)
- dashboard: option to render Dashboard inline instead of a modal dialog (@arturi)
- dashboard: global circular progress bar, try out different designs for total upload speed and ETA (@arturi)
- dashboard: show total upload speed and ETA, for all files (@arturi)
- dashboard: copy link to uploaded file button, cross-browser (@arturi) (http://i.imgur.com/b1Io34n.png) (@arturi)
- dashobard: refreshed design and grand refactor (@arturi)
- dashboard: improve file paste the best we can http://stackoverflow.com/a/22940020 (@arturi)
- provider: abstract google drive into provider plugin for reuse (@hedgerh)
- google drive: improve UI (@hedgerh)
- tus: add `resumable` capability flag (@arturi)
- tus: start fixing pause/resume issues and race conditions (@arturi)
- test: working Uppy example on Require Bin — latest version straight from NPM http://requirebin.com/?gist=54e076cccc929cc567cb0aba38815105 (@arturi @account)
- meta: update readme docs, add unpkg CDN links (https://unpkg.com/uppy/dist/uppy.min.css) (@arturi)
- meta: write 0.10 release blog post (@arturi)

We’ll see you in about a month!

The Uppy Team
