---
title: "Uppy 0.16: Transloadit!"
date: 2017-05-24
author: ife
---

Hello there! Missed us much? :) We're chomping at the bits, at least, to tell you about our latest release. This one has been in the works longer than usual, but then again, it's also way cooler than usual, so let's get right to it.

<!-- more -->

## Transloadit integration beta

Yes, you read that right! We now have an easily integrable [Transloadit](https://transloadit.com) plugin. It was a big push indeed and we owe a big debt of thanks to [Renée](https://github.com/goto-bus-stop) for going fully beast mode on this. The plugin is still in beta, but it works - and it's awesome. That said, of course it is entirely optional: if you don't use Transloadit, you don't have to bundle the plugin.

<video alt="Demo video showing the Transloadit upload plugin in action." muted autoplay loop>
  <source src="/images/blog/0.16/transloadit.webm" type="video/webm">
  <source src="/images/blog/0.16/transloadit.mp4" type="video/mp4">
</video>

The Transloadit plugin for Uppy handles creating an "Assembly" (a file conversion job) before uploading files, and can optionally wait for file conversions to complete before showing the uploads as successful, as shown above. Listen for the `core:success` event to respond to upload completion, just like you would without the Transloadit plugin.

We'll be adding decent documentation to the Uppy website soon, but [here](https://gist.github.com/kvz/8ae07aa8c063c8e55abbc1580b50c8a4#file-uppy-demo-js-L117-L147) is a quick code sample of how a Transloadit plugin integration would look like already.

## More work on high-level React components

Since the last release, we've been exploring possibilities for an official set of React components. Initially, we'll be providing component wrappers for the existing Uppy UI plugins, such as the [Dashboard](/examples/dashboard) and [DragDrop](/examples/dragdrop) plugins. They aren't ready yet, but if you'd like to follow along with development, check out the work that has been done so far in pull request [#170](https://github.com/transloadit/uppy/pull/170)!

## DOM element in `target:` option, `uppy.close()` for tearing down an Uppy instance

While laying the groundwork for the React component integrations, Uppy has also become a bit friendlier towards being integrated with other frameworks and in single-page apps. The `target:` option in each plugin used to work only with CSS selectors, which was difficult to use if the plugin should be mounted on a dynamically generated element. In 0.16, either a query selector or an actual DOM element can be passed in.

The new `.close()` method on the Uppy instance cleans up all of Uppy's event handlers and DOM elements. Useful when navigating away from a page with an Uppy uploader in a single-page app, or when unmounting a React component that contains an Uppy instance!

## Server time!

We got everything covered - front-to-back-end - so you can be sure we also got some things going on the server side.

- parallelizing downloading/uploading remote files: start uploading chunks right away, while still downloading the file on disk. Even though the server may download files relatively faster, it is good to know that you don't have to wait out the download before the upload begins. 
- Image thumbnails are now also shown for remote files.
- Automated tests have been added using the test library, [jest](https://facebook.github.io/jest/).
- Remote files are now deleted from local disk immediately after a successful upload.

## And

Multiple necessary chores (the kind you don’t like to talk about at parties), such as:

- Replacing `babel-preset-es2015-loose` by the standard es2015 preset with `loose` option
- Merging the Tus10 plugin options with `tus-js-client` options
- We reviewed the uppy-server README to be more elaborate when getting started.
- The Service logo is now visible on the corresponding file in the Dashboard. For example if a file is being uploaded from Google Drive you would see a Google Drive logo easily identifying where the file is from. Take a look!

<img src="/images/blog/0.16/service-logos.png">

## Release Notes

Here is the full list of changes for version 0.16:
- uploaders: make sure uploads retry/resume if started when offline or disconnected, retry when back online / failed https://github.com/transloadit/uppy/pull/135 (@arturi, @ifedapoolarewaju)
- transloadit: add basic (beta) version of Transloadit plugin (@goto-bus-stop, @kvz, @tim-kos / #28)
- transloadit: emit an upload event w/ tl data when a file upload is complete (#191 @goto-bus-stop)
- webcam: implement reading audio+video from webcam (@goto-bus-stop / #175)
- webcam: Make the webcam video fill the available space as much as possible (@goto-bus-stop / #190)
- tus: Merge tus-js-client options with uppy-tus. Hence, enable custom headers support (@goto-bus-stop)
- multipart/tus: Remove Promise.all() calls with unused results (@goto-bus-stop / #121)
- dashboard: fix Dashboard modal close button position (@goto-bus-stop / #171)
- core: pass through errors (@goto-bus-stop / #185)
- core: accept a DOM element in `target:` option (@goto-bus-stop / #169)
- core: Remove the last few potentially buggy uses of `document.querySelector` (@goto-bus-stop)
- dashboard: Fix dashboard width when multiple instances exist (@goto-bus-stop / #184)
- dashboard: add service logo / name to the selected file in file list (@arturi)
- server: begin adding automated tests, maybe try https://facebook.github.io/jest (@ifedapoolarewaju)
- server: add image preview / thumbnail for remote files, if its in the API of services (@ifedapoolarewaju)
- server: research parallelizing downloading/uploading remote files: start uploading chunks right away, while still storing the file on disk (@ifedapoolarewaju)
- server: delete file from local disk after upload is successful (@ifedapoolarewaju)
- website: try on a Github ribbon http://tholman.com/github-corners/ (@arturi / #150)
- website: different meta description for pages and post (@arturi)
- server: well-documented README (@ifedapoolarewaju)
- react: [WIP] High-level React Components (@goto-bus-stop / #170)
- core: add `uppy.close()` for tearing down an Uppy instance (@goto-bus-stop / #182)
- core: replace `babel-preset-es2015-loose` by standard es2015 preset with `loose` option (@goto-bus-stop / #174)

Enjoy!

The Uppy Team
