---
title: "Privacy Policy"
type: page
layout: page
permalink: /privacy-policy/
---

Uppy is an open source file uploader, developed by the team at [Transloadit Ltd.](https://transloadit.com) and [open source contributors on GitHub](https://github.com/transloadit/uppy/graphs/contributors).

In order to demonstrate Uppy file uploader and Transloadit's file encoding service on this website, we capture and store information about you.

## Who is responsible for data protection?

Since we are operating with a staff of less than ten people, we do not have an external data officer. Responsible for data protection are our founders Tim Koschützki and Kevin van Zonneveld. You can reach them at <a href="mailto:founders@transloadit.com">founders@transloadit.com</a>.

## What data is collected?

We receive the following **data** from you:

1. IP addresses
2. Request headers
3. Data entered on our website
4. The browser session (identified through a cookie)
5. Information used to analyze usage of our platform (through cookies from Google Analytics. More on cookies is explained below)
6. Files you can optionally upload in example demos. Those files are stored temporarily for 24–72 hours, on uppy.io, tus.io or transloadit.com servers, and then deleted. See also Transloadit’s Privacy Policy: https://transloadit.com/legal/privacy/.

All data that passes through demos is only used for demo purposes, and never sold or otherwise given away.

Since we do not store data on data subjects, migration or deletion tools are not applicable.

## Third-party services

We use the following third-party services which also store data about you:

| supplier              | subject                 | data                                     | encryption    | anonymized  | discarded  |
| :-------------------- | :---------------------- | :--------------------------------------- | :-----------: | :---------: | :--------: | :-------: |
| Transloadit           | end user (data subject) | browser identifiers                      |               |             | instantly  |           |
| Transloadit           | end user (data subject) | test files                      |               |             | in 24h  |           |
| Tus.io               | end user (data subject) | test files                      |               |             | in 72h  |           |
| Google Analytics      | customer (business)     | browser identifiers                      |               | ✅                      |           |

- **anonymized**: Any data that can be used to identify the 'data subject' is scrubbed
- **discarded**: Data is destroyed

## Your information and your rights

If you are based within the EEA (European Economic Area) or within another jurisdiction that has similar data protection laws, under certain circumstances, you have the following rights:

1. the right to be told how we use your information and obtain access to your information;
1. the right to have your information rectified or erased, or to place restrictions on processing your information;
1. the right to object to the processing of your information, e.g., for direct marketing purposes or where the processing is based on our legitimate interests;
1. the right to have any information you provided to us on an automated basis returned to you in a structured, commonly-used and machine-readable format, or sent directly to another company, where technically feasible (“data portability”);
1. where the processing of your information is based on your consent, the right to withdraw that consent is subject to legal or contractual restrictions;
1. the right to object to any decisions based on the automated processing of your personal data, including profiling; and
1. the right to lodge a complaint with the supervisory authority responsible for data protection matters (e.g., in the UK, the Information Commissioner’s Office).

If you request a copy of your information, you may be required to pay a statutory fee.

If you withdraw your consent to the use of your personal information for purposes set out in our Privacy Policy, we may not be able to provide you with access to (parts of) our website, applications, and services.

## Changes to our privacy policy

We may change this privacy policy from time to time. Nevertheless, we will not reduce your rights under this privacy policy. We will always update the privacy policy on our website, so please try to read it when you visit the website (the ‘last updated’ reference tells you when we last updated this privacy policy).

## Cookies, analytics and traffic data

Cookies are small text files that are transferred from our website and stored on your device. We use cookies to help us provide you with a personalized service, and to help make our website and service better for you.

Our cookies may be session cookies (temporary cookies that identify and track users within our websites) which are deleted when you close your browser, or persistent cookies (cookies that enable our website to “remember” who you are and to remember your preferences within our website) which will stay on your computer or device after you close your browser).

We use the following different types of cookies:

### Performance cookies and analytics technologies

Performance cookies collect information about how visitors and users use our website. These cookies register, for example, which functionality our visitors use most often, or if they receive error messages from certain areas of our website. These cookies don't collect information that can be used to identify a visitor or user. All information collected by these cookies is aggregated and therefore anonymous. We only use these cookies to improve how our website works.

### Functionality cookies

Functionality cookies allow our website to remember the choices you make (such as your user name, language or the region you are in) and provide enhanced and more personal features. These cookies can also be used to remember changes you have made to text size, fonts and other parts of web pages that you can customize. They may also be used to provide services you have asked for. The information collected by these cookies may be anonymized. They cannot track your browsing activity on other websites.

### IP Address and traffic data

We keep a record of the traffic data that is logged automatically by our servers, such as your Internet Protocol (IP) address, device information, the website that you visited before ours and the website you visit after leaving our site. We also collect some site, application and service statistics, such as access rates, page hits and page views. We are not able to identify any individual from traffic data or site statistics.

#### Google Analytics

Our platform uses Google Analytics, which uses cookies. The information created through these cookies about your usage of uppy.io will be transmitted to a Google server in the United States of America and stored there. When you are located in one of the states of the European Union, your IP address will be anonymized on our platform prior to transmitting it. We use the code "ga('set', 'anonymizeIp', true);" to ensure an anonymous way of saving IP addresses (so-called IP-masking).

Google will use this information to analyze your usage of our platform and to create reports about the activities on our platform. The IP address that will be sent to Google as a result of Google Analytics will not be connected to any other data on Google.

You can avoid any cookies being saved by changing the settings in your browser accordingly. Please be aware that if you choose to do so, you might not be able to make full use of our website and all of its features. You can also prevent the analysis of your browsing behavior on our platform through Google Analytics by installing the following browser plugin: http://tools.google.com/dlpage/gaoptout.

Google, Inc. (“Google”) head quarters are located at "1600 Amphitheatre Parkway Mountain View, California 94043, USA".
Their privacy policy is located here: https://policies.google.com/privacy.

## How to disable cookies

You may be able to configure your browser or our website to restrict cookies or block all cookies, if you wish. If you disable cookies, you may find that this affects your ability to use certain parts of our website. For more information about cookies and instructions on how to adjust your browser settings to accept, delete or reject cookies, see the [allaboutcookies.org](http://allaboutcookies.org) website.

## Data Processing Addendum (DPA)

If you require a countersigned copy of our DPA, please  <a href="mailto:hello@transloadit.com?subject=I+request+a+countersigned+copy+of+your+DPA" onclick="Intercom('showNewMessage', 'Hi, I\'d like to request a countersigned copy of your DPA'); return false;">reach out to support</a>.

## Last Updated

This privacy policy was last updated on Nov 29, 2019.
