---
title: "Uppy 1.7: A Small One"
date: 2020-01-10
author: renee
published: true
image: "https://uppy.io/images/blog/1.7/cat-video-screen.jpg"
---

Uppy 1.7 was released last December! This release added Hebrew translations, a recording length timer for the `@uppy/webcam` plugin, and a collection of improvements to Companion.

<!--more-->

## showRecordingLength: true

When recording audio or video using the `@uppy/webcam` plugin, this new option contributed by [@dominiceden](https://github.com/dominiceden) shows a timer in the bottom right, so your users can see how long they’ve been recording for.

<video alt="Demo video showing Uppy Webcam video recording timer" muted autoplay loop>
  <source src="/images/blog/1.7/cat-video-timer.webm" type="video/webm">
  <source src="/images/blog/1.7/cat-video-timer.mp4" type="video/mp4">
</video>

## Companion

The past months we’ve made some incremental improvements to Companion. We patched an issue where Companion could sometimes output remote provider authentication tokens into logs.

We now run Companion tests on Node.js 6 on each commit, in addition to Node.js 10, to make sure that we don’t break compatibility in a minor release. Node.js 6 support will be dropped in a future major release, and we recommend you upgrade soon if you are still using it.

Uploading files from remote providers with the `@uppy/aws-s3-multipart` plugin now uses the correct file name in your S3 bucket by default, instead of the temporary filename that Companion uses internally.

The `getKey()` option for S3 now has a [`metadata`](https://uppy.io/docs/companion/#s3-getKey-req-filename-metadata) parameter, so you can use file metadata from the client to determine the name of files in S3.

## Locales

The new Hebrew locale is available as:
```js
require('@uppy/locales/lib/he_IL')
```

Thanks to [@YehudaKremer](https://github.com/YehudaKremer) for the contribution!

In 1.7, we also fixed the naming of the Galician locale. The locale names follow a `country_LANGUAGE` format. Previously, we used `es_GL` for Galician, which was intended to mean “Galician in Spain”, but which _actually_ means “Spanish in Greenland”! The correct way to refer to Galician is as `gl_ES`:
```js
require('@uppy/locales/lib/gl_ES')
```
The old `es_GL` name is now an alias for `gl_ES`. It will be removed in a future major release, so we recommend updating your code if you were using the old name. If you do it now, the migration will be easier once 2.0 comes around :smile:

## Misc

- @uppy/aws-s3: add some tests (@bambii7, #1934)
- @uppy/companion: add onedrive domain validation for the demo deployment (@ifedapoolarewaju, #1959)
- @uppy/companion: change demo deployment type to stable API (@kiloreux, #1938)
- @uppy/companion: rename uppy occurrences to companion (@ifedapoolarewaju, #1926)
- @uppy/companion: upgrade `helmet` (@goto-bus-stop, [6b006ac](https://github.com/transloadit/uppy/commit/6b006ac42c20062c37bdcaf6a77e07b304da7957))
- @uppy/core: make `uppy.on()` work better with IntelliSense (@bambii7, #1923)
- @uppy/dashboard: hide top bar cancel button when `hideCancelButton: true` (@goto-bus-stop, #1955)
- @uppy/thumbnail-generator: add webp to the list of supported types (@arturi, #1961)
- @uppy/thumbnail-generator: vendor exif-js source in Uppy (@mskelton, #1940)
- docs: FB and OneDrive are not yet in the CDN bundle (@goto-bus-stop, [61b54b9](https://github.com/transloadit/uppy/commit/61b54b914dd437d2e60362c4ece1429943b32555))
- docs: add `companionHeaders` to s3-multipart docs (@goto-bus-stop, [a6e44a9](https://github.com/transloadit/uppy/commit/a6e44a953114e385466dcce884d37e433f030549))
- docs: add reset-progress event to docs (@bambii7, #1922)
- docs: make Robodog naming more consistent (@goto-bus-stop, #1935)
- docs: make react sample code more standalone (@uxitten, #1864)
- examples: remove `UPPYSERVER_` references (@goto-bus-stop, [e74690e](https://github.com/transloadit/uppy/commit/e74690e20cc0a1afd9156ce03b1ca6a5358cc7d9))
- website: add facebook to dashboard example (@ifedapoolarewaju, #1930)
- website: add plugin versions (@arturi, #1952)
- website: enable onedrive on the website example (@ifedapoolarewaju, #1975)

As always, you can find the full list of changes and package versions, as well as future plans, in our [changelog](https://github.com/transloadit/uppy/blob/master/CHANGELOG.md).
