---
title: "Uppy 0.15: Spring cleanup"
date: 2017-03-15
author: arturi
published: true
---

Spring is in the air and Uppy is feeling particularly full of life. In this post about Uppy 0.15, we have some exciting stories about `babel-plugin-yo-yoify`, progress event throttling, and new friends.

<!-- more -->

## Yo-yoify for NPM-installed Uppy

In [`0.14`](http://localhost:4000/blog/2017/02/0.14/), we added `yo-yoify` transform to give Uppy some extra speed and eliminate `Function.caller` issues. As it turned out, we [forgot](https://github.com/transloadit/uppy/issues/158) about our Babel-transpiled `lib` version of Uppy that gets published to NPM 🙀. We then spent some time creating a standalone version of `yo-yoify` that would be able to parse `yo-yo` template strings before Babel-transpilation, only to discover that there already is a [`babel-plugin-yo-yoify`](https://www.npmjs.com/package/babel-plugin-yo-yoify) that not only does precisely that, but also frees us from jumping through a lot of unnecessary hoops. It did [have](https://github.com/goto-bus-stop/babel-plugin-yo-yoify/issues/9) [a few](https://github.com/goto-bus-stop/babel-plugin-yo-yoify/pull/8) [issues](https://github.com/goto-bus-stop/babel-plugin-yo-yoify/issues/11) at first, but luckily our friend [Renée](https://github.com/goto-bus-stop) was available to colaborate with us on this. Renée has also agreed to join Uppy for a while to help us with other pressing issues. So, silver linings — bugs can sometimes lead to new friends and wonderful beginnings. We are very excited about what this all means for Uppy in the months to come.

Uppy from NPM is now good to go and the issue has been completely resolved. You can update at: https://www.npmjs.com/package/uppy. And yeah, if you use `yo-yo`, give [`babel-plugin-yo-yoify`](https://www.npmjs.com/package/babel-plugin-yo-yoify) a try.

## Pause & Resume Remote Uploads

Just like with “local” uploads, Uppy can now pause and resume remote uploads from Google Drive or Dropbox (handled on the backend by `uppy-server` + `tus`). 🎉

## Progress Throttling

While working on pausing remote uploads with `uppy-server`, Ife discovered a strange bug: uppy-client would hang during the upload, after which the progress would immediately jump to 100%. After some solid Sherlock Holmesing, we found what was causing it: uploads were happening too fast. This was leading to progress events being sent very, very often (like 300 / second), which trashed the interface rendering loop. We have solved this by [adding throttling in tus-js-client](https://github.com/tus/tus-js-client/commit/9940f27b2361fd7e10ba58b09b60d82422183bbb) (thanks Marius!) and [uppy-server](https://github.com/transloadit/uppy-server/commit/936ad48e92631c45d123664900b9aabcf7a190fa) (thanks Ife!). I would also very much like to take this opportunity to thank myself for [fixing](https://github.com/transloadit/uppy/commit/1d5f4404546420442deabc94df84bd3ec0677eec) [it](https://github.com/transloadit/uppy/commit/db32c6f4fd85420532f27f04920dbaf6d126ea9b) in uppy-client too! :innocent:

To prevent “jumping” progress, numbers and text in StatusBar are now only updated once a second. Plus, we have switched to [`prettier-bytes`](https://www.npmjs.com/package/prettier-bytes), which adds some nice number rounding. Smooth as butter!

TL;DR Uppy was simply too fast at uploading, so we had to shorten the leash a bit!

## Informer coming at you in full-color mode

Informer will now be able to change the way it looks depending on the `type` argument:

```js
// (`'informer'`, `text`, `type`, `duration`)
uppy.emit('informer', 'Connected!', 'success', 3000)
```

<img src="/images/blog/0.15/informer.png">

This supports the following `type`s: `info`, `warning`, `error`, `success`, all with their own colors!

## Some other things

- Multipart now treats all 2xx responses as successful and returns xhr object in `core:upload-success` event callback.
- That progress circle that you can see on each file in Dashboard has been improved on the inside: precise `circleLength` and `stroke-dasharray/stroke-dashoffset` calculation.
- Uppy-server returns uploaded file urls and sizes for remote uploads (from Google Drive & Dropbox).
- Provider plugins now have a loading screen, error screen and logout link. Breadcrumbs are also working again.

## Release Notes

Here is the full list of changes for version 0.15:

- build: update dependencies and eslint-plugin-standard, nodemon --> onchange, because simpler and better options (@arturi)
- build: fix `Function.caller` issue in `lib` which gets published to NPM package, add babel-plugin-yo-yoify (@arturi #158 #163)
- provider: show error view for things like not being able to connect to uppy server, should this be happening when uppy-server is unavailable http://i.imgur.com/cYJakc9.png (@arturi, @ifedapoolarewaju)
- provider: loading indicator while files from GoogleDrive / Dropbox are loading (@arturi, @ifedapoolarewaju)
- provider: logout link/button (@arturi, @ifedapoolarewaju)
- provider: fix breadcrumbs (@ifedapoolarewaju)
- server: refactor local/remote uploads in tus, allow for pause/resume with remote upload (@arturi, @ifedapoolarewaju)
- server: throttle progress updates sent through websockets, sometimes it can be overwhelming when uploads are getting this fast (@ifedapoolarewaju)
- server: pass file size from Google Drive / Dropbox (@ifedapoolarewaju)
- server: return uploaded file urls (from Google Drive / Dropbox) (@ifedapoolarewaju)
- server: research having less permissions, smaller auth expiration time for security (@ifedapoolarewaju)
- dashboard: basic React component (@arturi)
- core: experiment with `nanoraf` and `requestAnimationFrame` (@arturi)
- core: add throttling of progress updates (@arturi)
- dashobard: fix Missing `file.progress.bytesTotal` property  (@arturi #152)
- dashboard: switch to prettier-bytes for more user-friendly progress updates (@arturi)
- dashboard: fix `updateDashboardElWidth()` not firing in time, causing container width to be 0 (@arturi)
- multipart: treat all 2xx responses as successful, return xhr object in `core:upload-success` (@arturi #156 #154)
- dashboard: throttle StatusBar numbers, so they update only once a second (@arturi, @acconut)
- dashboard: add titles to pause/resume/cancel in StatusBar (@arturi)
- dashboard: precise `circleLength` and `stroke-dasharray/stroke-dashoffset` calculation for progress circles on FileItem (@arturi)
- dashboard: don’t show per-file detailed progress by default — too much noise (@arturi)
- website: blog post and images cleanup (@arturi)

Enjoy!

The Uppy Team
