export function KhojLogoType({ className }: { className?: string }) {
    const classes = className ?? "fill-zinc-950 dark:fill-zinc-300";
    return (
        <svg
            width="70"
            height="auto"
            viewBox="0 0 442 200"
            className={`${classes}`}
            xmlns="http://www.w3.org/2000/svg"
        >
            <g clipPath="url(#clip0_45_75)">
                <path
                    d="M57.9394 93.0404L67.5396 49.1063C68.7987 49.5268 71.7365 51.9442 74.7267 51.9442C78.5039 51.9442 79.2383 47.4246 86.1631 45.7955C91.6715 44.4817 96.3404 45.4276 99.0684 47.6349C99.0684 47.6349 99.6979 53.6259 101.167 55.4127C102.531 57.0418 104.629 56.4637 104.629 56.4637C107.672 70.8106 114.072 100.661 115.279 105.233C116.8 110.961 110.924 114.114 108.669 119.369C106.413 124.625 94.242 126.884 87.0549 127.62C79.8679 128.356 59.723 119.632 57.9394 117.215C56.1557 114.797 55.3688 109.857 55.1065 105.18C54.8442 101.449 56.8902 95.5104 57.9394 93.0404Z"
                    fill="#FAE80B"
                />
                <path
                    d="M57.9394 92.9879L62.2936 74.8046C63.5526 75.2251 66.9626 73.4383 71.4742 69.0764C74.1497 66.4488 79.8678 58.8812 86.0582 55.3601C90.5698 52.785 94.924 54.204 97.5995 56.4112C97.5995 56.4112 100.013 57.6199 102.846 57.6199C104.944 57.6199 104.629 56.4112 104.629 56.4112C107.672 70.7581 114.072 100.608 115.279 105.18C116.8 110.908 110.924 114.062 108.669 119.317C106.413 124.572 94.242 126.832 87.0549 127.568C79.8679 128.303 59.723 119.58 57.9394 117.162C56.1557 114.745 55.3688 109.805 55.1065 105.128C54.8442 101.449 56.8902 95.5104 57.9394 92.9879Z"
                    fill="#FFCC09"
                />
                <path
                    d="M69.3233 123.731C58.9886 121.104 55.8934 109.069 55.6311 103.393C58.7787 106.599 67.12 112.8 75.1464 111.959C85.2188 110.908 92.7207 106.862 100.852 100.503C108.983 94.1966 114.544 97.1921 114.544 106.809C114.544 116.426 107.619 118.108 105.521 122.47C103.423 126.884 82.281 127.042 69.3233 123.731Z"
                    fill="#FBA719"
                />
                <path d="M217.018 30.3459C218.946 32.2774 217.886 40.2931 217.886 45.315C217.886 48.4054 218.368 51.0129 218.368 53.4273C218.368 56.0348 217.886 58.5458 217.886 60.9602C218.368 62.9882 217.886 70.6177 218.946 71.1006C220.489 72.1629 222.031 66.9478 222.513 66.465C224.056 62.9883 222.995 65.1129 224.923 60.9602C226.948 57.0006 229.069 52.8479 230.611 49.9506C231.961 46.8602 234.082 42.4177 235.624 38.7479C237.167 36.3335 238.227 31.6979 240.637 29.7664C242.18 28.2212 247.193 28.2212 251.821 28.2212C255.291 28.7041 258.858 28.7041 259.919 30.6356C261.268 33.726 255.773 41.8383 254.231 45.2184C252.303 49.3712 250.76 51.8821 248.736 55.3588C248.254 56.4211 248.254 57.3869 247.675 58.9321C245.747 63.954 243.24 67.3341 240.637 72.5492C239.577 74.4807 238.709 76.9917 237.167 79.1163C236.106 82.0136 234.564 84.6211 234.564 86.6492C234.564 89.5464 236.588 93.6992 237.649 95.6307C241.12 102.294 244.687 108.861 248.157 115.911C248.639 117.264 248.639 118.809 249.7 120.354C251.242 124.313 253.267 127.404 255.677 132.426C257.219 135.999 261.172 142.566 260.304 145.463C258.762 149.037 254.616 148.071 250.182 148.071C244.687 148.071 240.541 148.071 238.709 147.009C236.685 145.463 235.142 139.959 233.6 137.061C230.129 128.949 228.587 124.313 224.634 115.911C223.574 112.821 222.031 109.731 220.489 107.316C218.464 104.709 218.464 112.821 217.886 116.394C217.886 120.837 217.886 124.313 217.886 126.342C217.886 132.909 219.428 144.015 216.536 147.009C213.451 149.616 198.894 149.037 196.773 145.463C196.291 143.532 196.773 137.544 196.773 132.426C197.255 127.404 196.773 124.313 196.773 119.871C196.291 108.861 196.291 98.7211 196.291 87.7115C196.291 83.5588 197.351 79.5992 196.773 76.5088C196.773 74.4807 196.291 73.0321 196.291 71.004C196.291 69.4588 196.773 68.3965 196.773 66.8513C196.773 63.3746 196.291 59.8013 196.291 56.3246C196.291 52.7513 196.773 49.2746 196.773 46.1842C196.773 41.7417 195.423 36.237 196.291 32.5671C196.773 31.0219 198.315 29.6698 198.894 29.0904C199.376 29.0904 199.376 29.0904 199.954 28.6075C203.811 27.2554 214.994 27.7384 217.018 30.3459Z" />
                <path d="M327.788 29.863C328.849 30.3459 328.849 32.2774 329.331 34.3054C329.813 38.265 329.331 46.3773 329.331 51.0129C328.849 58.5458 329.331 66.465 329.331 72.1629C329.331 82.1102 329.331 97.2724 329.331 105.868C329.331 114.946 329.331 127.5 328.849 138.22C328.849 142.663 329.331 146.14 327.306 147.685C324.896 149.23 310.628 149.23 308.796 147.685C306.772 145.657 307.736 139.09 307.736 134.647C307.736 132.619 307.736 130.687 307.736 128.659C307.736 119.002 307.254 109.924 307.736 98.9143C307.736 96.3067 308.218 93.4094 307.736 92.3471C306.193 90.8019 302.241 91.8642 299.156 91.8642C297.131 91.8642 292.6 90.319 290.576 92.3471C288.648 94.9546 289.515 102.005 289.515 106.447C289.515 117.457 289.997 123.155 289.997 134.647C289.997 140.635 290.479 145.657 287.587 147.685C284.502 149.713 272.451 149.23 270.427 147.202C267.342 144.305 267.824 132.619 267.824 125.569C267.824 103.936 268.884 87.9047 268.306 68.5896C268.306 64.63 268.788 60.4773 268.788 57.58C268.788 55.552 268.306 53.4273 267.728 50.5301C267.728 48.9849 268.21 46.9568 268.21 45.4116C268.692 39.9068 267.728 32.8568 268.692 30.8288C270.716 27.9315 286.334 27.352 288.744 30.4424C290.768 33.3397 289.226 39.4239 289.226 42.9972C288.744 46.9568 289.226 52.0752 289.226 57.58C289.226 59.1252 289.226 62.0225 289.226 64.6301C289.226 67.0444 289.226 70.6177 289.708 71.68C290.768 73.2252 295.878 73.2252 298.288 73.2252C300.313 73.2252 305.808 73.7081 306.868 72.1629C307.929 70.6177 307.929 62.0225 307.929 59.1253C307.929 51.013 307.929 46.3773 307.929 38.265C307.929 35.3677 307.447 32.2774 308.411 30.3459C309.471 28.3178 311.881 28.8006 313.906 28.3178C315.737 28.3178 325.764 27.2555 327.788 29.863Z" />
                <path d="M371.652 26.1931C379.75 25.7102 387.752 28.2212 392.765 30.6356C394.308 31.6979 397.778 35.2712 398.742 36.8164C401.345 40.2931 402.888 42.8041 403.755 47.3431C404.237 48.4054 404.816 48.8883 404.816 49.3711C404.816 49.854 404.816 50.4335 404.816 51.3993C405.298 53.8136 406.358 56.4211 406.84 57.9664C406.84 59.8979 406.84 61.4431 406.84 63.4711C406.84 65.0163 407.322 66.3684 407.322 67.9136C408.383 76.9916 407.804 87.7115 407.322 97.6587C407.322 104.226 407.322 110.696 406.262 116.781C405.201 122.961 403.659 129.529 402.309 132.909C401.827 133.971 400.285 136.482 399.224 137.544L398.742 138.027C397.2 140.442 394.308 142.47 391.223 144.594C389.68 145.463 389.198 145.946 387.752 146.526C386.21 147.009 384.667 147.009 382.064 147.588C380.714 147.588 379.172 148.65 377.629 148.65C374.159 149.133 369.531 149.133 367.121 149.133C364.036 148.65 360.469 147.588 357.481 146.043C356.999 146.043 356.42 145.174 356.42 145.174C354.878 144.691 352.853 143.629 351.986 143.146C349.961 141.6 347.358 138.51 345.816 136.579C342.345 130.591 339.838 121.416 339.26 112.821C338.778 106.254 338.778 97.6588 338.778 92.154C338.296 88.0012 338.778 83.5588 339.26 79.5992C339.26 73.9013 339.26 67.9136 339.742 62.8917C340.224 60.2841 340.803 57.8698 341.285 55.8417C341.285 52.7513 341.285 50.3369 341.767 47.7294C343.309 43.287 346.78 35.6575 350.347 32.5671C351.407 32.0842 352.757 31.0219 354.299 30.1527C358.445 28.1246 364.422 26.5795 370.978 26H371.652V26.1931ZM361.53 59.8979C359.987 72.6458 360.469 86.1663 361.048 99.3005C361.53 109.441 362.108 124.893 366.736 128.563C366.736 129.046 368.085 129.625 369.146 130.108C373.291 131.46 376.665 130.591 379.75 128.563C380.811 127.5 382.161 125.955 382.643 124.99C384.185 122.575 385.245 115.525 385.728 110.89C385.728 106.93 385.728 101.908 386.21 96.3067C386.21 85.2971 385.728 74.0944 384.667 64.6301C384.185 58.0629 383.607 52.0753 381.582 48.9849C380.232 46.9568 378.111 45.4116 376.087 44.8322C373.677 43.963 372.616 44.8322 371.652 44.8322H371.17C364.615 45.7979 362.59 52.365 361.53 59.8979Z" />
                <path d="M439.426 28.2212C441.836 30.6356 441.45 89.4499 441.45 96.9827C440.968 113.497 440.968 125.183 440.968 142.759C440.968 145.85 441.45 147.395 441.45 149.423C441.45 153.383 440.39 159.37 440.968 165.454C440.968 171.442 441.45 178.878 439.908 182.259C438.847 186.701 434.798 191.916 430.846 194.33C426.893 196.938 420.241 197.904 412.336 197.421C407.226 196.938 401.153 196.359 399.128 193.268C398.646 191.916 398.646 187.763 398.646 184.866C398.646 180.713 398.646 177.816 400.189 176.754C403.274 175.209 409.829 180.23 414.746 178.782C416.77 178.299 418.891 176.174 419.855 172.601C420.241 169.704 419.855 165.455 419.855 161.978C419.855 158.887 420.241 156.473 420.241 153.383C420.241 147.395 420.241 140.828 420.241 134.84C420.241 127.307 419.373 120.257 419.373 113.497C419.373 104.033 419.855 47.3431 419.855 38.7479C419.855 32.7602 417.831 28.8006 422.266 26.676C425.833 25.6136 436.823 25.6137 439.426 28.2212Z" />
                <path d="M46.6374 143.679C43.5946 143.679 41.2864 142.838 39.6601 141.104C36.7223 138.004 37.5092 133.379 37.5617 133.169C37.719 132.275 52.3031 43.8816 53.667 35.2104C54.9261 27.1698 64.0542 25.383 68.7232 25.5932L68.6183 28.7464C68.5658 28.7464 65.733 28.6413 62.8476 29.5347C59.2803 30.6383 57.2344 32.6878 56.7622 35.6834C55.4507 44.3546 40.8142 132.801 40.6568 133.694C40.6568 133.747 40.1322 137.005 41.9684 138.95C43.2799 140.316 45.4832 140.789 48.6308 140.368L48.9981 143.469C48.2112 143.627 47.4243 143.679 46.6374 143.679Z" />
                <path d="M106.023 33.371H102.928C102.98 33.2133 102.98 33.0031 102.98 32.8455V15.2403C102.98 13.506 101.564 12.0871 99.8324 12.0871H89.4977C90.8616 10.8784 91.7535 9.09161 91.7535 7.09461C91.7535 3.41592 88.7632 0.42041 85.091 0.42041C81.4188 0.42041 78.4285 3.41592 78.4285 7.09461C78.4285 9.09161 79.2679 10.8784 80.6843 12.0871H70.8217C69.0905 12.0871 67.6741 13.506 67.6741 15.2403V32.8455C67.6741 33.0557 67.6741 33.2133 67.7265 33.371H64.0543C61.5887 33.371 59.5427 35.4205 59.5427 37.8905C59.5427 40.4131 61.5887 42.4101 64.0543 42.4101H106.075C108.541 42.4101 110.587 40.3605 110.587 37.8905C110.534 35.368 108.541 33.371 106.023 33.371ZM85.0385 3.52103C86.9795 3.52103 88.5534 5.0976 88.5534 7.04205C88.5534 8.98651 86.9795 10.5631 85.0385 10.5631C83.0975 10.5631 81.5237 8.98651 81.5237 7.04205C81.5237 5.0976 83.0975 3.52103 85.0385 3.52103Z" />
                <path d="M123.177 143.679C122.443 143.679 121.656 143.627 120.816 143.522L121.184 140.421C124.331 140.841 126.535 140.316 127.846 139.002C129.682 137.058 129.158 133.799 129.158 133.799C129 132.906 114.364 44.4596 113.052 35.7884C112.58 32.7929 110.534 30.7433 106.967 29.6397C104.082 28.7463 101.249 28.8514 101.196 28.8514L101.091 25.6983C105.76 25.4881 114.941 27.2749 116.147 35.3154C117.459 43.9866 132.095 132.38 132.253 133.274C132.305 133.431 133.092 138.056 130.154 141.157C128.528 142.786 126.22 143.679 123.177 143.679Z" />
                <path d="M122.443 151.142L122.39 129.805C122.39 124.76 109.642 120.031 109.642 120.031H109.433C105.026 124.34 97.5765 127.44 85.2483 127.44C72.9201 127.44 65.5231 124.34 61.064 120.031H60.8541C60.8541 120.031 48.1063 124.76 48.1063 129.805C48.1063 134.85 48.1063 151.142 48.1063 151.142C48.1063 151.142 42.1782 154.978 42.1782 159.445C42.1782 163.912 42.1782 167.17 42.1782 167.17C42.1782 167.17 47.2144 178.154 85.2483 178.154H85.3007C123.335 178.154 128.371 167.17 128.371 167.17C128.371 167.17 128.371 163.912 128.371 159.445C128.371 154.978 122.443 151.142 122.443 151.142Z" />
                <path d="M117.931 87.658C116.725 85.2406 113.42 80.5108 112.056 78.5664L103.924 41.1488L101.091 41.7795L112.738 95.2256L112.79 95.3833C112.79 95.4358 113.262 96.8547 113.63 99.062C113.052 99.5875 112.37 100.06 111.584 100.533C108.331 102.478 96.7897 105.894 85.3009 108.994C73.8645 105.894 62.3756 102.478 59.1231 100.533C58.2837 100.008 57.5493 99.4824 56.9197 98.9043C57.287 96.7496 57.7066 95.3833 57.7591 95.3307V95.2782L69.4053 41.5167L66.5725 40.886L58.3362 79.0394C56.8148 81.194 53.877 85.4508 52.7754 87.7106C51.8311 89.6025 50.7819 94.5424 54.0344 98.8518C53.2475 103.739 52.9852 111.78 57.7591 118.401C62.7953 125.391 72.0284 128.912 85.2484 128.912C98.4685 128.912 107.702 125.391 112.738 118.401C117.459 111.832 117.249 103.949 116.515 99.062C120.03 94.6475 118.928 89.6025 117.931 87.658ZM116.095 88.604C116.725 89.9178 117.459 92.9658 115.99 96.0139C115.78 95.2256 115.623 94.7526 115.571 94.5424L113.262 83.9793C114.364 85.661 115.518 87.4478 116.095 88.604ZM54.664 88.604C55.1886 87.5529 56.1328 86.0289 57.182 84.4523L54.9787 94.4899C54.9262 94.6475 54.7689 95.068 54.6115 95.6986C53.4049 92.7556 54.0869 89.8652 54.664 88.604ZM56.6574 101.374C57.0771 101.69 57.6017 102.005 58.0739 102.32C61.1166 104.16 70.9792 107.155 81.3139 110.045C70.5595 112.936 60.8543 115.301 59.4378 115.669C56.5525 110.939 56.2902 105.473 56.6574 101.374ZM85.3009 125.969C73.6546 125.969 65.4184 123.131 60.8018 117.508C64.1068 116.72 74.5465 114.092 85.3533 111.149C95.9504 114.039 106.338 116.615 109.8 117.508C105.183 123.131 96.9471 125.969 85.3009 125.969ZM111.111 115.669C109.17 115.196 99.7275 112.831 89.3403 110.045C99.7275 107.155 109.59 104.107 112.685 102.268C113.157 102.005 113.525 101.742 113.944 101.427C114.311 105.526 113.997 110.991 111.111 115.669Z" />
                <path d="M39.188 44.7224C38.8733 44.7224 38.611 44.6173 38.3487 44.4597L24.2893 34.5797C23.6073 34.1068 23.4499 33.2134 23.922 32.5302C24.3942 31.847 25.286 31.6893 25.968 32.1623L40.0274 42.0422C40.7094 42.5152 40.8668 43.4086 40.3946 44.0918C40.0799 44.5122 39.6602 44.7224 39.188 44.7224Z" />
                <path d="M18.8334 80.6685L1.67885 80.6159C0.891941 80.6159 0.209961 79.9853 0.209961 79.1445C0.209961 78.3036 0.83948 77.673 1.67885 77.673L18.8334 77.7255C19.6203 77.7255 20.3023 78.3562 20.3023 79.197C20.3023 80.0379 19.6203 80.6685 18.8334 80.6685Z" />
                <path d="M13.2726 128.754C12.8004 128.754 12.3283 128.544 12.066 128.071C11.6463 127.388 11.8562 126.495 12.4857 126.074L26.9123 116.825C27.5943 116.404 28.4861 116.562 28.9058 117.245C29.3255 117.928 29.1157 118.822 28.4861 119.242L14.0595 128.492C13.8497 128.649 13.5874 128.754 13.2726 128.754Z" />
                <path d="M130.889 43.6188C130.417 43.6188 129.997 43.4086 129.682 42.9881C129.21 42.305 129.368 41.4116 130.05 40.9386L144.109 31.0587C144.738 30.5857 145.683 30.7433 146.155 31.4265C146.627 32.1097 146.47 33.0031 145.788 33.4761L131.728 43.356C131.466 43.5137 131.204 43.6188 130.889 43.6188Z" />
                <path d="M151.244 79.5649C150.457 79.5649 149.775 78.9343 149.775 78.0934C149.775 77.3051 150.404 76.6219 151.244 76.6219L168.398 76.5694C169.185 76.5694 169.867 77.2 169.867 78.0409C169.867 78.8292 169.238 79.5123 168.398 79.5123L151.244 79.5649Z" />
                <path d="M156.804 127.598C156.542 127.598 156.28 127.546 156.017 127.388L141.591 118.139C140.909 117.718 140.699 116.825 141.171 116.142C141.591 115.458 142.483 115.248 143.165 115.721L157.591 124.97C158.273 125.391 158.483 126.284 158.011 126.967C157.749 127.388 157.277 127.598 156.804 127.598Z" />
            </g>
            <defs>
                <clipPath id="clip0_45_75">
                    <rect width="442" height="200" fill="currentColor" />
                </clipPath>
            </defs>
        </svg>
    );
}

export function KhojLogo({ className }: { className?: string }) {
    const classes = className ?? "fill-zinc-950 dark:fill-zinc-300";
    return (
        <svg
            width="200"
            height="200"
            viewBox="0 0 200 200"
            className={`${classes}`}
            xmlns="http://www.w3.org/2000/svg"
        >
            <g clipPath="url(#clip0_45_75)">
                <path
                    d="M57.9394 93.0404L67.5396 49.1063C68.7987 49.5268 71.7365 51.9442 74.7267 51.9442C78.5039 51.9442 79.2383 47.4246 86.1631 45.7955C91.6715 44.4817 96.3404 45.4276 99.0684 47.6349C99.0684 47.6349 99.6979 53.6259 101.167 55.4127C102.531 57.0418 104.629 56.4637 104.629 56.4637C107.672 70.8106 114.072 100.661 115.279 105.233C116.8 110.961 110.924 114.114 108.669 119.369C106.413 124.625 94.242 126.884 87.0549 127.62C79.8679 128.356 59.723 119.632 57.9394 117.215C56.1557 114.797 55.3688 109.857 55.1065 105.18C54.8442 101.449 56.8902 95.5104 57.9394 93.0404Z"
                    fill="#FAE80B"
                />
                <path
                    d="M57.9394 92.9879L62.2936 74.8046C63.5526 75.2251 66.9626 73.4383 71.4742 69.0764C74.1497 66.4488 79.8678 58.8812 86.0582 55.3601C90.5698 52.785 94.924 54.204 97.5995 56.4112C97.5995 56.4112 100.013 57.6199 102.846 57.6199C104.944 57.6199 104.629 56.4112 104.629 56.4112C107.672 70.7581 114.072 100.608 115.279 105.18C116.8 110.908 110.924 114.062 108.669 119.317C106.413 124.572 94.242 126.832 87.0549 127.568C79.8679 128.303 59.723 119.58 57.9394 117.162C56.1557 114.745 55.3688 109.805 55.1065 105.128C54.8442 101.449 56.8902 95.5104 57.9394 92.9879Z"
                    fill="#FFCC09"
                />
                <path
                    d="M69.3233 123.731C58.9886 121.104 55.8934 109.069 55.6311 103.393C58.7787 106.599 67.12 112.8 75.1464 111.959C85.2188 110.908 92.7207 106.862 100.852 100.503C108.983 94.1966 114.544 97.1921 114.544 106.809C114.544 116.426 107.619 118.108 105.521 122.47C103.423 126.884 82.281 127.042 69.3233 123.731Z"
                    fill="#FBA719"
                />
                <path d="M46.6374 143.679C43.5946 143.679 41.2864 142.838 39.6601 141.104C36.7223 138.004 37.5092 133.379 37.5617 133.169C37.719 132.275 52.3031 43.8816 53.667 35.2104C54.9261 27.1698 64.0542 25.383 68.7232 25.5932L68.6183 28.7464C68.5658 28.7464 65.733 28.6413 62.8476 29.5347C59.2803 30.6383 57.2344 32.6878 56.7622 35.6834C55.4507 44.3546 40.8142 132.801 40.6568 133.694C40.6568 133.747 40.1322 137.005 41.9684 138.95C43.2799 140.316 45.4832 140.789 48.6308 140.368L48.9981 143.469C48.2112 143.627 47.4243 143.679 46.6374 143.679Z" />
                <path d="M106.023 33.371H102.928C102.98 33.2133 102.98 33.0031 102.98 32.8455V15.2403C102.98 13.506 101.564 12.0871 99.8324 12.0871H89.4977C90.8616 10.8784 91.7535 9.09161 91.7535 7.09461C91.7535 3.41592 88.7632 0.42041 85.091 0.42041C81.4188 0.42041 78.4285 3.41592 78.4285 7.09461C78.4285 9.09161 79.2679 10.8784 80.6843 12.0871H70.8217C69.0905 12.0871 67.6741 13.506 67.6741 15.2403V32.8455C67.6741 33.0557 67.6741 33.2133 67.7265 33.371H64.0543C61.5887 33.371 59.5427 35.4205 59.5427 37.8905C59.5427 40.4131 61.5887 42.4101 64.0543 42.4101H106.075C108.541 42.4101 110.587 40.3605 110.587 37.8905C110.534 35.368 108.541 33.371 106.023 33.371ZM85.0385 3.52103C86.9795 3.52103 88.5534 5.0976 88.5534 7.04205C88.5534 8.98651 86.9795 10.5631 85.0385 10.5631C83.0975 10.5631 81.5237 8.98651 81.5237 7.04205C81.5237 5.0976 83.0975 3.52103 85.0385 3.52103Z" />
                <path d="M123.177 143.679C122.443 143.679 121.656 143.627 120.816 143.522L121.184 140.421C124.331 140.841 126.535 140.316 127.846 139.002C129.682 137.058 129.158 133.799 129.158 133.799C129 132.906 114.364 44.4596 113.052 35.7884C112.58 32.7929 110.534 30.7433 106.967 29.6397C104.082 28.7463 101.249 28.8514 101.196 28.8514L101.091 25.6983C105.76 25.4881 114.941 27.2749 116.147 35.3154C117.459 43.9866 132.095 132.38 132.253 133.274C132.305 133.431 133.092 138.056 130.154 141.157C128.528 142.786 126.22 143.679 123.177 143.679Z" />
                <path d="M122.443 151.142L122.39 129.805C122.39 124.76 109.642 120.031 109.642 120.031H109.433C105.026 124.34 97.5765 127.44 85.2483 127.44C72.9201 127.44 65.5231 124.34 61.064 120.031H60.8541C60.8541 120.031 48.1063 124.76 48.1063 129.805C48.1063 134.85 48.1063 151.142 48.1063 151.142C48.1063 151.142 42.1782 154.978 42.1782 159.445C42.1782 163.912 42.1782 167.17 42.1782 167.17C42.1782 167.17 47.2144 178.154 85.2483 178.154H85.3007C123.335 178.154 128.371 167.17 128.371 167.17C128.371 167.17 128.371 163.912 128.371 159.445C128.371 154.978 122.443 151.142 122.443 151.142Z" />
                <path d="M117.931 87.658C116.725 85.2406 113.42 80.5108 112.056 78.5664L103.924 41.1488L101.091 41.7795L112.738 95.2256L112.79 95.3833C112.79 95.4358 113.262 96.8547 113.63 99.062C113.052 99.5875 112.37 100.06 111.584 100.533C108.331 102.478 96.7897 105.894 85.3009 108.994C73.8645 105.894 62.3756 102.478 59.1231 100.533C58.2837 100.008 57.5493 99.4824 56.9197 98.9043C57.287 96.7496 57.7066 95.3833 57.7591 95.3307V95.2782L69.4053 41.5167L66.5725 40.886L58.3362 79.0394C56.8148 81.194 53.877 85.4508 52.7754 87.7106C51.8311 89.6025 50.7819 94.5424 54.0344 98.8518C53.2475 103.739 52.9852 111.78 57.7591 118.401C62.7953 125.391 72.0284 128.912 85.2484 128.912C98.4685 128.912 107.702 125.391 112.738 118.401C117.459 111.832 117.249 103.949 116.515 99.062C120.03 94.6475 118.928 89.6025 117.931 87.658ZM116.095 88.604C116.725 89.9178 117.459 92.9658 115.99 96.0139C115.78 95.2256 115.623 94.7526 115.571 94.5424L113.262 83.9793C114.364 85.661 115.518 87.4478 116.095 88.604ZM54.664 88.604C55.1886 87.5529 56.1328 86.0289 57.182 84.4523L54.9787 94.4899C54.9262 94.6475 54.7689 95.068 54.6115 95.6986C53.4049 92.7556 54.0869 89.8652 54.664 88.604ZM56.6574 101.374C57.0771 101.69 57.6017 102.005 58.0739 102.32C61.1166 104.16 70.9792 107.155 81.3139 110.045C70.5595 112.936 60.8543 115.301 59.4378 115.669C56.5525 110.939 56.2902 105.473 56.6574 101.374ZM85.3009 125.969C73.6546 125.969 65.4184 123.131 60.8018 117.508C64.1068 116.72 74.5465 114.092 85.3533 111.149C95.9504 114.039 106.338 116.615 109.8 117.508C105.183 123.131 96.9471 125.969 85.3009 125.969ZM111.111 115.669C109.17 115.196 99.7275 112.831 89.3403 110.045C99.7275 107.155 109.59 104.107 112.685 102.268C113.157 102.005 113.525 101.742 113.944 101.427C114.311 105.526 113.997 110.991 111.111 115.669Z" />
                <path d="M39.188 44.7224C38.8733 44.7224 38.611 44.6173 38.3487 44.4597L24.2893 34.5797C23.6073 34.1068 23.4499 33.2134 23.922 32.5302C24.3942 31.847 25.286 31.6893 25.968 32.1623L40.0274 42.0422C40.7094 42.5152 40.8668 43.4086 40.3946 44.0918C40.0799 44.5122 39.6602 44.7224 39.188 44.7224Z" />
                <path d="M18.8334 80.6685L1.67885 80.6159C0.891941 80.6159 0.209961 79.9853 0.209961 79.1445C0.209961 78.3036 0.83948 77.673 1.67885 77.673L18.8334 77.7255C19.6203 77.7255 20.3023 78.3562 20.3023 79.197C20.3023 80.0379 19.6203 80.6685 18.8334 80.6685Z" />
                <path d="M13.2726 128.754C12.8004 128.754 12.3283 128.544 12.066 128.071C11.6463 127.388 11.8562 126.495 12.4857 126.074L26.9123 116.825C27.5943 116.404 28.4861 116.562 28.9058 117.245C29.3255 117.928 29.1157 118.822 28.4861 119.242L14.0595 128.492C13.8497 128.649 13.5874 128.754 13.2726 128.754Z" />
                <path d="M130.889 43.6188C130.417 43.6188 129.997 43.4086 129.682 42.9881C129.21 42.305 129.368 41.4116 130.05 40.9386L144.109 31.0587C144.738 30.5857 145.683 30.7433 146.155 31.4265C146.627 32.1097 146.47 33.0031 145.788 33.4761L131.728 43.356C131.466 43.5137 131.204 43.6188 130.889 43.6188Z" />
                <path d="M151.244 79.5649C150.457 79.5649 149.775 78.9343 149.775 78.0934C149.775 77.3051 150.404 76.6219 151.244 76.6219L168.398 76.5694C169.185 76.5694 169.867 77.2 169.867 78.0409C169.867 78.8292 169.238 79.5123 168.398 79.5123L151.244 79.5649Z" />
                <path d="M156.804 127.598C156.542 127.598 156.28 127.546 156.017 127.388L141.591 118.139C140.909 117.718 140.699 116.825 141.171 116.142C141.591 115.458 142.483 115.248 143.165 115.721L157.591 124.97C158.273 125.391 158.483 126.284 158.011 126.967C157.749 127.388 157.277 127.598 156.804 127.598Z" />
            </g>
            <defs>
                <clipPath id="clip0_45_75">
                    <rect width="200" height="200" fill="currentColor" />
                </clipPath>
            </defs>
        </svg>
    );
}

export function KhojSearchLogo({ className }: { className?: string }) {
    const classes = className ?? "w-6 h-6";
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            version="1.1"
            viewBox="0 0 27 27"
            fill="none"
            className={classes}
        >
            <path
                d="m 18.562765,17.147843 c 1.380497,-1.679442 2.307667,-4.013099 2.307667,-6.330999 C 20.870432,5.3951476 16.353958,1 10.782674,1 5.2113555,1 0.69491525,5.3951476 0.69491525,10.816844 c 0,5.421663 4.51644025,9.816844 10.08775875,9.816844 2.381867,0 4.570922,-0.803307 6.296712,-2.14673 0.508475,-0.508475 4.514633,4.192839 4.514633,4.192839 1.036377,1.008544 2.113087,-0.02559 1.07671,-1.034139 z m -7.780091,1.925408 c -4.3394583,0 -8.6708434,-4.033489 -8.6708434,-8.256407 0,-4.2229187 4.3313851,-8.2564401 8.6708434,-8.2564401 4.339458,0 8.670809,4.2369112 8.670809,8.4598301 0,4.222918 -4.331351,8.053017 -8.670809,8.053017 z"
                fill="currentColor"
                fillRule="evenodd"
                clipRule="evenodd"
                fillOpacity="1"
                strokeWidth="1.10519"
                strokeDasharray="none"
            />
            <path
                d="m 13.337351,9.3402647 0.05184,2.1532893"
                stroke="currentColor"
                strokeWidth="1.95702"
                strokeLinecap="round"
            />
            <path
                d="M 8.431347,9.2809457 8.483191,11.434235"
                stroke="currentColor"
                strokeWidth="1.95701"
                strokeLinecap="round"
            />
        </svg>
    );
}

export function KhojAutomationLogo({ className }: { className?: string }) {
    const classes = className ?? "w-6 h-6";
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            version="1.1"
            viewBox="0 0 27 27"
            fill="none"
            className={classes}
        >
            <path
                d="m 20.503667,19.512812 c 1.498791,-1.721309 2.505409,-4.113142 2.505409,-6.488822 0,-5.556853 -4.903485,-10.0615654 -10.952165,-10.0615654 -6.0487172,0 -10.9521652,4.5047124 -10.9521652,10.0615654 0,5.556818 4.903448,10.061562 10.9521652,10.061562 2.585967,0 4.962599,-0.823331 6.836268,-2.200243 z m -8.446756,1.973405 c -4.7113005,0 -9.4138363,-4.134038 -9.4138363,-8.462227 0,-4.3281914 4.7025358,-8.4622628 9.4138363,-8.4622628 4.711301,0 9.4138,4.3425313 9.4138,8.6707228 0,4.328187 -4.702499,8.253767 -9.4138,8.253767 z"
                fill="currentColor"
                fillRule="evenodd"
                clipRule="evenodd"
                fillOpacity="1"
                strokeWidth="1.16584"
                strokeDasharray="none"
            />
            <path
                d="m 14.703831,11.557853 0.0553,2.175599"
                stroke="currentColor"
                strokeWidth="2.03174"
                strokeLinecap="round"
            />
            <path
                d="m 9.470316,11.497919 0.055305,2.175598"
                stroke="currentColor"
                strokeWidth="2.03172"
                strokeLinecap="round"
            />
            <path
                d="m 13.921987,2.0293778 c -1.700446,0.00578 -2.945437,0.011553 -3.53279,0.01733"
                stroke="currentColor"
                strokeWidth="1.69465"
                strokeLinecap="round"
            />
            <path
                d="m 21.395697,5.8423397 -1.28226,1.167146"
                stroke="currentColor"
                strokeWidth="2.03172"
                strokeLinecap="round"
            />
        </svg>
    );
}

export function KhojAgentLogo({ className }: { className?: string }) {
    const classes = className ?? "w-6 h-6";
    // Icon Source: AI by Palash Jain from <a href="https://thenounproject.com/browse/icons/term/ai/" target="_blank" title="AI Icons">Noun Project</a> (CC BY 3.0)
    return (
        <svg
            xmlns="http://www.w3.org/2000/svg"
            version="1.1"
            viewBox="0 0 64 64"
            fill="none"
            className={classes}
        >
            <path
                d="m 30.065286,2.6838408 c 0,-1.0516338 -0.536857,-0.2904639 -1.602626,-0.2904639 -1.065769,0 -2.256759,-0.7611699 -2.256759,0.2904639 v 4.7442407 c 0,0.019613 2.9e-4,0.03913 8.68e-4,0.058553 C 12.904724,8.2984689 2.0847457,17.487997 2.0847457,31.229969 c 0,3.541245 0.7282659,6.446979 2.1822891,8.775946 1.4616456,2.341058 3.5599931,3.944353 6.0242102,5.03229 4.798181,2.118273 11.240941,2.377047 17.844348,2.377047 6.603408,0 13.046168,-0.258774 17.844349,-2.377047 2.464217,-1.087937 4.562564,-2.691232 6.02421,-5.03229 1.454023,-2.328967 2.182289,-5.234701 2.182289,-8.775946 0,-13.741972 -10.819978,-22.9315001 -24.122023,-23.7433349 5.78e-4,-0.019422 8.68e-4,-0.03894 8.68e-4,-0.058553 z m -1.929693,8.5525432 c -12.474689,0 -22.1914625,8.103305 -22.1914625,19.993585 0,3.031408 0.6216504,5.19719 1.6087846,6.778396 0.9796083,1.568926 2.4136592,2.714368 4.3145029,3.553622 3.932038,1.735919 9.549855,2.044963 16.268175,2.044963 6.718321,0 12.336138,-0.309044 16.268176,-2.044963 1.900843,-0.839254 3.334894,-1.984696 4.314503,-3.553622 0.987134,-1.581206 1.608784,-3.746988 1.608784,-6.778396 0,-11.89028 -9.716773,-19.993585 -22.191463,-19.993585 z M 16.557439,22.66129 c 1.065769,0 1.929692,0.852488 1.929692,1.904151 v 5.712452 c 0,1.051663 -0.863923,1.904151 -1.929692,1.904151 -1.065769,0 -1.929692,-0.852488 -1.929692,-1.904151 v -5.712452 c 0,-1.051663 0.863923,-1.904151 1.929692,-1.904151 z m 22.191463,0 c 1.065769,0 1.929692,0.852488 1.929692,1.904151 v 5.712452 c 0,1.051663 -0.863923,1.904151 -1.929692,1.904151 -1.065769,0 -1.929693,-0.852488 -1.929693,-1.904151 v -5.712452 c 0,-1.051663 0.863924,-1.904151 1.929693,-1.904151 z M 8.2209746,53.949727 c 6.4574264,-1.16515 13.1131284,-1.774098 19.9146184,-1.774098 6.801587,0 13.457289,0.608948 19.914716,1.774098 1.048305,0.189177 2.053578,-0.496127 2.245293,-1.530557 0.191715,-1.034525 -0.502781,-2.026492 -1.551087,-2.215575 -6.685419,-1.206374 -13.573456,-1.836268 -20.608922,-1.836268 -7.035465,0 -13.923502,0.629894 -20.6088253,1.836268 -1.0484018,0.189083 -1.7428981,1.18105 -1.5511832,2.215575 0.1917149,1.03443 1.1969882,1.719734 2.2453901,1.530557 z"
                fill="currentColor"
                fillRule="evenodd"
                clipRule="evenodd"
            />
        </svg>
    );
}
