---
sidebar_position: 1
---

# Overview

Khoj supports a variety of features, including search and chat with a wide range of data sources and interfaces.

#### [Search](/features/search)
  - **Local**: Your personal data stays local. All search and indexing is done on your machine when you [self-host](/get-started/setup)
  - **Incremental**: Incremental search for a fast, search-as-you-type experience

#### [Chat](/features/chat)
  - **Faster answers**: Find answers faster, smoother than search. No need to manually scan through your notes to find answers.
  - **Iterative discovery**: Iteratively explore and (re-)discover your notes
  - **Assisted creativity**: Smoothly weave across answers retrieval and content generation
  - **Works online or offline**: Chat using online or offline AI chat models

#### General
  - **Cloud or Self-Host**: Use [cloud](https://app.khoj.dev/login) to use Khoj anytime from anywhere or [self-host](/get-started/setup) for privacy
  - **Natural**: Advanced natural language understanding using Transformer based ML Models
  - **Pluggable**: Modular architecture makes it easy to plug in new data sources, frontends and ML models
  - **Multiple Sources**: Index your Org-mode, Markdown, PDF, plaintext files, Github repos and Notion pages
  - **Multiple Interfaces**: Interact from your Web Browser, Emacs, Obsidian, Desktop app or even Whatsapp

### Supported Interfaces
Khoj is available as a [Desktop app](/clients/desktop), [Emacs package](/clients/emacs), [Obsidian plugin](/clients/obsidian), [Web app](/clients/web) and a [Whatsapp AI](https://khoj.dev/whatsapp).

![](/img/khoj_clients.svg ':size=400px')

### Supported Data Sources
Khoj can understand your word, PDF, org-mode, markdown, plaintext files, [Github projects](/data-sources/github_integration) and [Notion pages](/data-sources/notion_integration).


![](/img/khoj_datasources.svg ':size=200px')
