# Generated by Django 5.0.8 on 2024-10-18 00:41

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    dependencies = [
        ("database", "0068_alter_agent_output_modes"),
    ]

    operations = [
        migrations.CreateModel(
            name="WebScraper",
            fields=[
                ("id", models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("created_at", models.DateTimeField(auto_now_add=True)),
                ("updated_at", models.DateTimeField(auto_now=True)),
                (
                    "name",
                    models.CharField(
                        blank=True,
                        default=None,
                        help_text="Friendly name. If not set, it will be set to the type of the scraper.",
                        max_length=200,
                        null=True,
                        unique=True,
                    ),
                ),
                (
                    "type",
                    models.CharField(
                        choices=[
                            ("Firecrawl", "Firecrawl"),
                            ("Olostep", "Olostep"),
                            ("Jina", "Jina"),
                            ("Direct", "Direct"),
                        ],
                        default="Jina",
                        max_length=20,
                    ),
                ),
                (
                    "api_key",
                    models.CharField(
                        blank=True,
                        default=None,
                        help_text="API key of the web scraper. Only set if scraper service requires an API key. Default is set from env var.",
                        max_length=200,
                        null=True,
                    ),
                ),
                (
                    "api_url",
                    models.URLField(
                        blank=True,
                        default=None,
                        help_text="API URL of the web scraper. Only set if scraper service on non-default URL.",
                        null=True,
                    ),
                ),
                (
                    "priority",
                    models.IntegerField(
                        blank=True,
                        default=None,
                        help_text="Priority of the web scraper. Lower numbers run first.",
                        null=True,
                        unique=True,
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="serverchatsettings",
            name="web_scraper",
            field=models.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="web_scraper",
                to="database.webscraper",
            ),
        ),
    ]
