﻿using Grand.Domain.Configuration;

namespace Grand.Domain.Common;

public class AddressSettings : ISettings
{
    /// <summary>
    ///     Gets or sets a value indicating whether 'Name' is enabled
    /// </summary>
    public bool NameEnabled { get; set; }

    /// <summary>
    ///     Gets or sets a value indicating whether 'Company' is enabled
    /// </summary>
    public bool CompanyEnabled { get; set; }

    /// <summary>
    ///     Gets or sets a value indicating whether 'Company' is required
    /// </summary>
    public bool CompanyRequired { get; set; }

    /// <summary>
    ///     Gets or sets a value indicating whether 'Vat number' is enabled
    /// </summary>
    public bool VatNumberEnabled { get; set; }

    /// <summary>
    ///     Gets or sets a value indicating whether 'Vat number' is required
    /// </summary>
    public bool VatNumberRequired { get; set; }

    /// <summary>
    ///     Gets or sets a value indicating whether 'Street address' is enabled
    /// </summary>
    public bool StreetAddressEnabled { get; set; }

    /// <summary>
    ///     Gets or sets a value indicating whether 'Street address' is required
    /// </summary>
    public bool StreetAddressRequired { get; set; }

    /// <summary>
    ///     Gets or sets a value indicating whether 'Street address 2' is enabled
    /// </summary>
    public bool StreetAddress2Enabled { get; set; }

    /// <summary>
    ///     Gets or sets a value indicating whether 'Street address 2' is required
    /// </summary>
    public bool StreetAddress2Required { get; set; }

    /// <summary>
    ///     Gets or sets a value indicating whether 'Zip / postal code' is enabled
    /// </summary>
    public bool ZipPostalCodeEnabled { get; set; }

    /// <summary>
    ///     Gets or sets a value indicating whether 'Zip / postal code' is required
    /// </summary>
    public bool ZipPostalCodeRequired { get; set; }

    /// <summary>
    ///     Gets or sets a value indicating whether 'City' is enabled
    /// </summary>
    public bool CityEnabled { get; set; }

    /// <summary>
    ///     Gets or sets a value indicating whether 'City' is required
    /// </summary>
    public bool CityRequired { get; set; }

    /// <summary>
    ///     Gets or sets a value indicating whether 'Country' is enabled
    /// </summary>
    public bool CountryEnabled { get; set; }

    /// <summary>
    ///     Gets or sets a value indicating whether 'State / province' is enabled
    /// </summary>
    public bool StateProvinceEnabled { get; set; }

    /// <summary>
    ///     Gets or sets a value indicating whether 'Phone number' is enabled
    /// </summary>
    public bool PhoneEnabled { get; set; }

    /// <summary>
    ///     Gets or sets a value indicating whether 'Phone number' is required
    /// </summary>
    public bool PhoneRequired { get; set; }

    /// <summary>
    ///     Gets or sets a value indicating whether 'Fax number' is enabled
    /// </summary>
    public bool FaxEnabled { get; set; }

    /// <summary>
    ///     Gets or sets a value indicating whether 'Fax number' is required
    /// </summary>
    public bool FaxRequired { get; set; }

    /// <summary>
    ///     Gets or sets a value indicating whether 'Note' is enabled
    /// </summary>
    public bool NoteEnabled { get; set; }

    /// <summary>
    ///     Gets or sets a value indicating whether 'AddressType' is enabled
    /// </summary>
    public bool AddressTypeEnabled { get; set; }

    /// <summary>
    ///     Gets or sets a value indicating whether users are allowed to change their email on the address
    /// </summary>
    public bool DisallowUsersToChangeEmail { get; set; }
}