﻿using Grand.Web.Common.Page;
using Microsoft.AspNetCore.Razor.TagHelpers;

namespace Grand.Web.Common.TagHelpers;

[HtmlTargetElement("meta-keywords", TagStructure = TagStructure.WithoutEndTag)]
[HtmlTargetElement("meta-keywords", Attributes = PartAttributeName)]
public class MetaKeywordsTagHelper : TagHelper
{
    private const string PartAttributeName = "asp-part";

    private readonly IPageHeadBuilder _pageHeadBuilder;

    public MetaKeywordsTagHelper(IPageHeadBuilder pageHeadBuilder)
    {
        _pageHeadBuilder = pageHeadBuilder;
    }

    [HtmlAttributeName(PartAttributeName)] public string Attribute { get; set; }

    public override Task ProcessAsync(TagHelperContext context, TagHelperOutput output)
    {
        if (!string.IsNullOrEmpty(Attribute)) _pageHeadBuilder.AppendMetaKeywordParts(Attribute);
        output.TagName = "meta";
        output.Attributes.Add("name", "keywords");
        output.Attributes.Add("content", _pageHeadBuilder.GenerateMetaKeywords());
        return Task.CompletedTask;
    }
}