﻿using Grand.Infrastructure.ModelBinding;
using Grand.Infrastructure.Models;
using Grand.Web.Admin.Models.Common;
using Grand.Web.Admin.Models.Discounts;
using Grand.Web.Common.Models;
using Microsoft.AspNetCore.Mvc.Rendering;
using System.ComponentModel.DataAnnotations;

namespace Grand.Web.Admin.Models.Vendors;

public class VendorModel : BaseEntityModel, ILocalizedModel<VendorLocalizedModel>
{
    public VendorModel()
    {
        if (PageSize < 1) PageSize = 5;
        Locales = new List<VendorLocalizedModel>();
        AssociatedCustomers = new List<AssociatedCustomerInfo>();
        Address = new AddressModel();
        AvailableStores = new List<SelectListItem>();
    }

    [GrandResourceDisplayName("Admin.Vendors.Fields.Name")]

    public string Name { get; set; }

    [GrandResourceDisplayName("Admin.Vendors.Fields.Email")]

    public string Email { get; set; }

    [GrandResourceDisplayName("Admin.Vendors.Fields.Description")]

    public string Description { get; set; }

    [UIHint("Picture")]
    [GrandResourceDisplayName("Admin.Vendors.Fields.Picture")]
    public string PictureId { get; set; }

    [GrandResourceDisplayName("Admin.Vendors.Fields.Store")]
    public string StoreId { get; set; }

    public List<SelectListItem> AvailableStores { get; set; }

    [GrandResourceDisplayName("Admin.Vendors.Fields.AdminComment")]

    public string AdminComment { get; set; }

    [GrandResourceDisplayName("Admin.Vendors.Fields.Active")]
    public bool Active { get; set; }

    [GrandResourceDisplayName("Admin.Vendors.Fields.DisplayOrder")]
    public int DisplayOrder { get; set; }

    [GrandResourceDisplayName("Admin.Vendors.Fields.AllowCustomerReviews")]
    public bool AllowCustomerReviews { get; set; }

    [GrandResourceDisplayName("Admin.Vendors.Fields.MetaKeywords")]

    public string MetaKeywords { get; set; }

    [GrandResourceDisplayName("Admin.Vendors.Fields.MetaDescription")]

    public string MetaDescription { get; set; }

    [GrandResourceDisplayName("Admin.Vendors.Fields.MetaTitle")]

    public string MetaTitle { get; set; }

    [GrandResourceDisplayName("Admin.Vendors.Fields.SeName")]

    public string SeName { get; set; }

    [GrandResourceDisplayName("Admin.Vendors.Fields.PageSize")]
    public int PageSize { get; set; }

    [GrandResourceDisplayName("Admin.Vendors.Fields.AllowCustomersToSelectPageSize")]
    public bool AllowCustomersToSelectPageSize { get; set; }

    [GrandResourceDisplayName("Admin.Vendors.Fields.PageSizeOptions")]
    public string PageSizeOptions { get; set; }

    [GrandResourceDisplayName("Admin.Vendors.Fields.AssociatedCustomerEmails")]
    public IList<AssociatedCustomerInfo> AssociatedCustomers { get; set; }

    public AddressModel Address { get; set; }

    //vendor notes
    [GrandResourceDisplayName("Admin.Vendors.VendorNotes.Fields.Note")]

    public string AddVendorNoteMessage { get; set; }

    public List<DiscountModel> AvailableDiscounts { get; set; }
    public string[] SelectedDiscountIds { get; set; }

    [GrandResourceDisplayName("Admin.Vendors.Fields.Commission")]
    public double? Commission { get; set; }

    public IList<VendorLocalizedModel> Locales { get; set; }

    #region Nested classes

    public class AssociatedCustomerInfo : BaseEntityModel
    {
        public string Email { get; set; }
    }


    public class VendorNote : BaseEntityModel
    {
        public string VendorId { get; set; }

        [GrandResourceDisplayName("Admin.Vendors.VendorNotes.Fields.Note")]
        public string Note { get; set; }

        [GrandResourceDisplayName("Admin.Vendors.VendorNotes.Fields.CreatedOn")]
        public DateTime CreatedOn { get; set; }
    }

    #endregion
}

public class VendorLocalizedModel : ILocalizedModelLocal, ISlugModelLocal
{
    [GrandResourceDisplayName("Admin.Vendors.Fields.Name")]

    public string Name { get; set; }

    [GrandResourceDisplayName("Admin.Vendors.Fields.Description")]

    public string Description { get; set; }

    [GrandResourceDisplayName("Admin.Vendors.Fields.MetaKeywords")]

    public string MetaKeywords { get; set; }

    [GrandResourceDisplayName("Admin.Vendors.Fields.MetaDescription")]

    public string MetaDescription { get; set; }

    [GrandResourceDisplayName("Admin.Vendors.Fields.MetaTitle")]

    public string MetaTitle { get; set; }

    public string LanguageId { get; set; }

    [GrandResourceDisplayName("Admin.Vendors.Fields.SeName")]

    public string SeName { get; set; }
}