﻿using Grand.Business.Core.Interfaces.Checkout.Payments;
using Grand.Business.Core.Queries.Checkout.Orders;
using Grand.Domain.Payments;
using MediatR;

namespace Grand.Business.Checkout.Queries.Handlers.Orders;

public class CanRefundQueryHandler : IRequestHandler<CanRefundQuery, bool>
{
    private readonly IPaymentService _paymentService;

    public CanRefundQueryHandler(IPaymentService paymentService)
    {
        _paymentService = paymentService;
    }

    public async Task<bool> Handle(CanRefundQuery request, CancellationToken cancellationToken)
    {
        var paymentTransaction = request.PaymentTransaction;
        ArgumentNullException.ThrowIfNull(paymentTransaction);

        if (paymentTransaction.TransactionAmount == 0)
            return false;

        if (paymentTransaction.RefundedAmount > 0)
            return false;

        //if (order.OrderStatus == OrderStatus.Cancelled)
        //    return false;
        return paymentTransaction.TransactionStatus is TransactionStatus.Paid or TransactionStatus.PartialPaid
                   or TransactionStatus.PartiallyRefunded &&
               await _paymentService.SupportRefund(paymentTransaction.PaymentMethodSystemName);
    }
}