﻿using AutoMapper;
using Grand.Business.Core.Extensions;
using Grand.Domain.Catalog;
using Grand.Infrastructure.Mapper;
using Grand.Web.Admin.Models.Catalog;

namespace Grand.Web.Admin.Mapper;

public class CollectionProfile : Profile, IAutoMapperProfile
{
    public CollectionProfile()
    {
        CreateMap<Collection, CollectionModel>()
            .ForMember(dest => dest.Locales, mo => mo.Ignore())
            .ForMember(dest => dest.AvailableCollectionLayouts, mo => mo.Ignore())
            .ForMember(dest => dest.AvailableDiscounts, mo => mo.Ignore())
            .ForMember(dest => dest.SelectedDiscountIds, mo => mo.Ignore())
            .ForMember(dest => dest.SeName, mo => mo.MapFrom(src => src.GetSeName("", true)))
            .ForMember(dest => dest.AvailableSortOptions, mo => mo.Ignore());

        CreateMap<CollectionModel, Collection>()
            .ForMember(dest => dest.Id, mo => mo.Ignore())
            .ForMember(dest => dest.LimitedToStores, mo => mo.MapFrom(x => x.Stores != null && x.Stores.Any()))
            .ForMember(dest => dest.LimitedToGroups,
                mo => mo.MapFrom(x => x.CustomerGroups != null && x.CustomerGroups.Any()))
            .ForMember(dest => dest.Locales, mo => mo.Ignore())
            .ForMember(dest => dest.CreatedOnUtc, mo => mo.Ignore())
            .ForMember(dest => dest.UpdatedOnUtc, mo => mo.Ignore())
            .ForMember(dest => dest.AppliedDiscounts, mo => mo.Ignore());
    }

    public int Order => 0;
}