﻿using Grand.Business.Core.Interfaces.Common.Configuration;
using Grand.Business.Core.Interfaces.Common.Localization;
using Grand.Infrastructure.Plugins;

namespace Widgets.FacebookPixel;

public class FacebookPixelPlugin(
    ISettingService settingService,
    IPluginTranslateResource pluginTranslateResource)
    : BasePlugin, IPlugin
{

    /// <summary>
    ///     Gets a configuration page URL
    /// </summary>
    public override string ConfigurationUrl()
    {
        return FacebookPixelDefaults.ConfigurationUrl;
    }

    public override async Task Install()
    {
        var settings = new FacebookPixelSettings {
            PixelId = "000000000000000",
            PixelScript = @"<!-- Facebook Pixel Code -->
                                    <script>
                                      !function(f,b,e,v,n,t,s)
                                      {if(f.fbq)return;n=f.fbq=function(){n.callMethod?
                                      n.callMethod.apply(n,arguments):n.queue.push(arguments)};
                                      if(!f._fbq)f._fbq=n;n.push=n;n.loaded=!0;n.version='2.0';
                                      n.queue=[];t=b.createElement(e);t.async=!0;
                                      t.src=v;s=b.getElementsByTagName(e)[0];
                                      s.parentNode.insertBefore(t,s)}(window, document,'script',
                                      'https://connect.facebook.net/en_US/fbevents.js');
                                      fbq('init', '{PIXELID}');
                                      fbq('track', 'PageView');
                                    </script>
                                    <noscript>
                                      <img height='1' width='1' style='display:none'
                                           src='https://www.facebook.com/tr?id={PIXELID}&ev=PageView&noscript=1'/>
                                    </noscript>
                                <!-- End Facebook Pixel Code -->",
            AddToCartScript =
                "<script> fbq('track', 'AddToCart', {contents: [{ id: '{PRODUCTID}', quantity: {QTY} }], content_name: '{PRODUCTNAME}', content_type: 'product', value: {AMOUNT}, currency: '{CURRENCY}'}); </script>",
            DetailsOrderScript =
                "<script> fbq('track', 'Purchase', {currency: '{CURRENCY}', value: {AMOUNT}}); </script>",
            ConsentName = "Facebook pixel",
            ConsentDescription = "Allows us to identifies visitors from Facebook"
        };
        await settingService.SaveSetting(settings);

        await pluginTranslateResource.AddOrUpdatePluginTranslateResource("Widgets.FacebookPixel.FriendlyName", "Facebook Pixel");
        await pluginTranslateResource.AddOrUpdatePluginTranslateResource("Widgets.FacebookPixel.PixelId", "Pixel Id");
        await pluginTranslateResource.AddOrUpdatePluginTranslateResource("Widgets.FacebookPixel.PixelId.Hint", "Enter Facebook Pixel ID.");
        await pluginTranslateResource.AddOrUpdatePluginTranslateResource("Widgets.FacebookPixel.PixelScript", "Facebook Pixel Code");
        await pluginTranslateResource.AddOrUpdatePluginTranslateResource("Widgets.FacebookPixel.PixelScript.Hint",
            "Paste the facebook pixel code generated by Facebook here. {PIXELID} will be dynamically replaced.");
        await pluginTranslateResource.AddOrUpdatePluginTranslateResource("Widgets.FacebookPixel.AddToCartScript", "Facebook Event - Add to cart");
        await pluginTranslateResource.AddOrUpdatePluginTranslateResource("Widgets.FacebookPixel.AddToCartScript.Hint",
            "Paste the event add to cart pixel code. {PRODUCTNAME}, {PRODUCTID}, {QTY}, {AMOUNT}, {CURRENCY} will be dynamically replaced.");
        await pluginTranslateResource.AddOrUpdatePluginTranslateResource("Widgets.FacebookPixel.DetailsOrderScript", "Facebook Event - Purchase");
        await pluginTranslateResource.AddOrUpdatePluginTranslateResource("Widgets.FacebookPixel.DetailsOrderScript.Hint",
            "Paste the event purchase pixel code. {AMOUNT} and {CURRENCY} will be dynamically replaced.");
        await pluginTranslateResource.AddOrUpdatePluginTranslateResource("Widgets.FacebookPixel.AllowToDisableConsentCookie", "Allow disabling consent cookie");
        await pluginTranslateResource.AddOrUpdatePluginTranslateResource("Widgets.FacebookPixel.AllowToDisableConsentCookie.Hint", "Get or set the value to disable consent cookie");
        await pluginTranslateResource.AddOrUpdatePluginTranslateResource("Widgets.FacebookPixel.ConsentDefaultState", "Consent default state");
        await pluginTranslateResource.AddOrUpdatePluginTranslateResource("Widgets.FacebookPixel.ConsentDefaultState.Hint", "Get or set the value to consent default state");
        await pluginTranslateResource.AddOrUpdatePluginTranslateResource("Widgets.FacebookPixel.ConsentName", "Consent cookie name");
        await pluginTranslateResource.AddOrUpdatePluginTranslateResource("Widgets.FacebookPixel.ConsentName.Hint", "Get or set the value to consent cookie name");
        await pluginTranslateResource.AddOrUpdatePluginTranslateResource("Widgets.FacebookPixel.ConsentDescription", "Consent cookie description");
        await pluginTranslateResource.AddOrUpdatePluginTranslateResource("Widgets.FacebookPixel.ConsentDescription.Hint", "Get or set the value to consent cookie description");

        await base.Install();
    }

    /// <summary>
    ///     Uninstall plugin
    /// </summary>
    public override async Task Uninstall()
    {
        //settings
        await settingService.DeleteSetting<FacebookPixelSettings>();

        //locales
        await pluginTranslateResource.DeletePluginTranslationResource("Widgets.FacebookPixel.PixelId");
        await pluginTranslateResource.DeletePluginTranslationResource("Widgets.FacebookPixel.PixelId.Hint");
        await pluginTranslateResource.DeletePluginTranslationResource("Widgets.FacebookPixel.PixelScript");
        await pluginTranslateResource.DeletePluginTranslationResource("Widgets.FacebookPixel.PixelScript.Hint");
        await pluginTranslateResource.DeletePluginTranslationResource("Widgets.FacebookPixel.AddToCartScript");
        await pluginTranslateResource.DeletePluginTranslationResource("Widgets.FacebookPixel.AddToCartScript.Hint");
        await pluginTranslateResource.DeletePluginTranslationResource("Widgets.FacebookPixel.DetailsOrderScript");
        await pluginTranslateResource.DeletePluginTranslationResource("Widgets.FacebookPixel.DetailsOrderScript.Hint");
        await pluginTranslateResource.DeletePluginTranslationResource("Widgets.FacebookPixel.AllowToDisableConsentCookie");
        await pluginTranslateResource.DeletePluginTranslationResource("Widgets.FacebookPixel.AllowToDisableConsentCookie.Hint");
        await pluginTranslateResource.DeletePluginTranslationResource("Widgets.FacebookPixel.ConsentDefaultState");
        await pluginTranslateResource.DeletePluginTranslationResource("Widgets.FacebookPixel.ConsentDefaultState.Hint");
        await pluginTranslateResource.DeletePluginTranslationResource("Widgets.FacebookPixel.ConsentName");
        await pluginTranslateResource.DeletePluginTranslationResource("Widgets.FacebookPixel.ConsentName.Hint");
        await pluginTranslateResource.DeletePluginTranslationResource("Widgets.FacebookPixel.ConsentDescription");
        await pluginTranslateResource.DeletePluginTranslationResource("Widgets.FacebookPixel.ConsentDescription.Hint");

        await base.Uninstall();
    }
}