using Grand.Domain.Localization;
using Grand.Domain.Stores;

namespace Grand.Domain.Directory;

/// <summary>
///     Represents a currency
/// </summary>
public class Currency : BaseEntity, ITranslationEntity, IStoreLinkEntity
{
    /// <summary>
    ///     Gets or sets the name
    /// </summary>
    public string Name { get; set; }

    /// <summary>
    ///     Gets or sets the currency code
    /// </summary>
    public string CurrencyCode { get; set; }

    /// <summary>
    ///     Gets or sets the rate
    /// </summary>
    public double Rate { get; set; }

    /// <summary>
    ///     Gets or sets the display locale
    /// </summary>
    public string DisplayLocale { get; set; }

    /// <summary>
    ///     Gets or sets the custom formatting
    /// </summary>
    public string CustomFormatting { get; set; }

    /// <summary>
    ///     Gets or sets a value indicating whether the entity is published
    /// </summary>
    public bool Published { get; set; }

    /// <summary>
    ///     Gets or sets the display order
    /// </summary>
    public int DisplayOrder { get; set; }

    /// <summary>
    ///     Gets or sets the rounding type identifier
    /// </summary>
    public RoundingType RoundingTypeId { get; set; }

    /// <summary>
    ///     Gets or sets the Midpoint rounding identifier
    /// </summary>
    public MidpointRounding MidpointRoundId { get; set; }

    /// <summary>
    ///     Gets or sets the number of double places (for RoundPrice)
    /// </summary>
    public int NumberDecimal { get; set; } = 2;

    /// <summary>
    ///     Gets or sets a value indicating whether the entity is limited/restricted to certain stores
    /// </summary>
    public bool LimitedToStores { get; set; }

    public IList<string> Stores { get; set; } = new List<string>();

    /// <summary>
    ///     Gets or sets the collection of locales
    /// </summary>
    public IList<TranslationEntity> Locales { get; set; } = new List<TranslationEntity>();
}