﻿using Grand.Infrastructure.ModelBinding;
using Grand.Infrastructure.Models;
using Microsoft.AspNetCore.Mvc.Rendering;
using System.ComponentModel.DataAnnotations;

namespace Grand.Web.Admin.Models.Catalog;

public class ProductReviewListModel : BaseModel
{
    [GrandResourceDisplayName("Admin.Catalog.ProductReviews.List.CreatedOnFrom")]
    [UIHint("DateNullable")]
    public DateTime? CreatedOnFrom { get; set; }

    [GrandResourceDisplayName("Admin.Catalog.ProductReviews.List.CreatedOnTo")]
    [UIHint("DateNullable")]
    public DateTime? CreatedOnTo { get; set; }

    [GrandResourceDisplayName("Admin.Catalog.ProductReviews.List.SearchText")]

    public string SearchText { get; set; }

    [GrandResourceDisplayName("Admin.Catalog.ProductReviews.List.SearchStore")]
    public string SearchStoreId { get; set; }

    [GrandResourceDisplayName("Admin.Catalog.ProductReviews.List.SearchProduct")]
    public string SearchProductId { get; set; }

    public IList<SelectListItem> AvailableStores { get; set; } = new List<SelectListItem>();
}