﻿using Grand.Business.Marketing.Services.Courses;
using Grand.Data;
using Grand.Domain.Courses;
using Grand.Infrastructure.Events;
using MediatR;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using Moq;

namespace Grand.Business.Marketing.Tests.Services.Courses;

[TestClass]
public class CourseActionServiceTests
{
    private Mock<IRepository<CourseAction>> _courseActionRepository;
    private CourseActionService _courseActionService;
    private Mock<IMediator> _mediatorMock;

    [TestInitialize]
    public void Init()
    {
        _courseActionRepository = new Mock<IRepository<CourseAction>>();
        _mediatorMock = new Mock<IMediator>();
        _courseActionService = new CourseActionService(_courseActionRepository.Object, _mediatorMock.Object);
    }

    [TestMethod]
    public void InsertAsync_NullArgument_ThrowExcepiton()
    {
        Assert.ThrowsExceptionAsync<ArgumentNullException>(async () => await _courseActionService.InsertAsync(null),
            "courseAction");
    }

    [TestMethod]
    public async Task InsertAsync_NullArgument_InvokeRepository()
    {
        await _courseActionService.InsertAsync(new CourseAction());
        _courseActionRepository.Verify(c => c.InsertAsync(It.IsAny<CourseAction>()), Times.Once);
        _mediatorMock.Verify(c => c.Publish(It.IsAny<EntityInserted<CourseAction>>(), default), Times.Once);
    }

    [TestMethod]
    public void Update_NullArgument_ThrowExcepiton()
    {
        Assert.ThrowsExceptionAsync<ArgumentNullException>(async () => await _courseActionService.Update(null),
            "courseAction");
    }


    [TestMethod]
    public async Task Update_ValidArgument_InvokeRepository()
    {
        await _courseActionService.Update(new CourseAction());
        _courseActionRepository.Verify(c => c.UpdateAsync(It.IsAny<CourseAction>()), Times.Once);
        _mediatorMock.Verify(c => c.Publish(It.IsAny<EntityUpdated<CourseAction>>(), default), Times.Once);
    }
}