﻿using Grand.Business.Core.Utilities.Authentication;
using Grand.Domain.Customers;
using Grand.Domain.Localization;

namespace Grand.Business.Core.Interfaces.Authentication;

public interface ITwoFactorAuthenticationService
{
    Task<bool> AuthenticateTwoFactor(string secretKey, string token, Customer customer,
        TwoFactorAuthenticationType twoFactorAuthenticationType);

    Task<TwoFactorCodeSetup> GenerateCodeSetup(string secretKey, Customer customer, Language language,
        TwoFactorAuthenticationType twoFactorAuthenticationType);
}