using Grand.Business.Core.Interfaces.Common.Directory;
using Grand.Domain;

namespace Grand.Business.Core.Extensions;

public static class UserFieldExtensions
{
    /// <summary>
    ///     Get an user field of an entity
    /// </summary>
    /// <typeparam name="TPropType">Property type</typeparam>
    /// <param name="entity">Entity</param>
    /// <param name="userFieldService">UserFieldService</param>
    /// <param name="key">Key</param>
    /// <param name="storeId">Load a value specific for a certain store; pass 0 to load a value shared for all stores</param>
    /// <returns>Attribute</returns>
    public static async Task<TPropType> GetUserField<TPropType>(this BaseEntity entity,
        IUserFieldService userFieldService, string key, string storeId = "")
    {
        ArgumentNullException.ThrowIfNull(entity);

        return await userFieldService.GetFieldsForEntity<TPropType>(entity, key, storeId);
    }
}