﻿using Grand.Business.Core.Interfaces.Marketing.Courses;
using Grand.Infrastructure.Extensions;
using Grand.Domain.Courses;
using Grand.Data;
using MediatR;

namespace Grand.Business.Marketing.Services.Courses
{
    public class CourseLevelService : ICourseLevelService
    {
        private readonly IRepository<CourseLevel> _courseLevelRepository;
        private readonly IMediator _mediator;

        public CourseLevelService(IRepository<CourseLevel> courseLevelRepository, IMediator mediator)
        {
            _courseLevelRepository = courseLevelRepository;
            _mediator = mediator;
        }

        public virtual async Task Delete(CourseLevel courseLevel)
        {
            ArgumentNullException.ThrowIfNull(courseLevel);

            await _courseLevelRepository.DeleteAsync(courseLevel);

            //event notification
            await _mediator.EntityDeleted(courseLevel);
        }

        public virtual async Task<IList<CourseLevel>> GetAll()
        {
            var query = from l in _courseLevelRepository.Table
                        orderby l.DisplayOrder
                        select l;

            return await Task.FromResult(query.ToList());
        }

        public virtual Task<CourseLevel> GetById(string id)
        {
            return _courseLevelRepository.GetByIdAsync(id);
        }

        public virtual async Task<CourseLevel> Insert(CourseLevel courseLevel)
        {
            ArgumentNullException.ThrowIfNull(courseLevel);

            await _courseLevelRepository.InsertAsync(courseLevel);

            //event notification
            await _mediator.EntityInserted(courseLevel);

            return courseLevel;
        }

        public virtual async Task<CourseLevel> Update(CourseLevel courseLevel)
        {
            ArgumentNullException.ThrowIfNull(courseLevel);

            await _courseLevelRepository.UpdateAsync(courseLevel);

            //event notification
            await _mediator.EntityUpdated(courseLevel);

            return courseLevel;
        }
    }
}
