﻿using Grand.Api.DTOs.Common;
using Grand.Api.Queries.Models.Common;
using Grand.Data;
using MediatR;

namespace Grand.Api.Queries.Handlers.Common
{
    public class GetLayoutQueryHandler : IRequestHandler<GetLayoutQuery, IQueryable<LayoutDto>>
    {
        private readonly IDatabaseContext _dbContext;

        public GetLayoutQueryHandler(IDatabaseContext dbContext)
        {
            _dbContext = dbContext;
        }

        public async Task<IQueryable<LayoutDto>> Handle(GetLayoutQuery request, CancellationToken cancellationToken)
        {
            var query = _dbContext.Table<LayoutDto>(request.LayoutName);

            if (string.IsNullOrEmpty(request.Id))
                return query;
            return await Task.FromResult(query.Where(x => x.Id == request.Id));

        }
    }
}
