# Awesome Blazor [![Awesome](https://awesome.re/badge-flat2.svg)](https://awesome.re)
[<img src="https://adrientorris.github.io/wwwroot/images/blazor/logo-blazor.png" align="right" width="170">](https://dotnet.microsoft.com/apps/aspnet/web-apps/client)

> A collection of awesome Blazor resources.

Blazor is a .NET web framework using C#/Razor and HTML that runs in the browser with WebAssembly.

Contributions are always welcome! Please take a look at the [contribution guidelines](https://github.com/AdrienTorris/awesome-blazor/blob/master/CONTRIBUTING.md) pages first. Thanks to all [contributors](https://github.com/AdrienTorris/awesome-blazor/graphs/contributors), you're awesome and wouldn't be possible without you!

If you need to search on this list you can try this great website: [Awesome Blazor Browser](https://jsakamoto.github.io/awesome-blazor-browser/).
Thanks @jsakamoto for this! [Source code](https://github.com/jsakamoto/awesome-blazor-browser) ![stars](https://img.shields.io/github/stars/jsakamoto/awesome-blazor-browser?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/jsakamoto/awesome-blazor-browser?style=flat-square&cacheSeconds=86400).

## Special event: "Blazor WebAssembly 3.2 Release Party!". [Over]
[<img src="https://pbs.twimg.com/media/EY9FPm1UcAAR4cj?format=jpg&name=medium" align="center" width="100%">](https://www.youtube.com/watch?v=onI2_Q0wrdM&list=PL1rZQsJPBU2St9-Mz1Kaa7rofciyrwWVx&index=0)
- ASP.NET Community Standup - Blazor WebAssembly 3.2 Release Party!

## Contents
* [Introduction](#introduction)
* [General](#general)
* [Sample Projects](#sample-projects)
* [Tutorials](#tutorials)
* [Libraries & Extensions](#libraries--extensions)
* [Videos](#videos)
* [Articles](#articles)
* [Podcasts](#podcasts)
* [Presentations slides](#presentations-slides)
* [Tooling](#tooling)
* [Books](#books)
* [E-Books](#e-books)
* [Courses](#courses)
* [Community](#community)
* [Other Languages](#other-languages)

## Introduction

### What is Blazor?

Blazor is a .NET web framework to build client web apps with C#.

Blazor lets you build interactive web UIs using C# instead of JavaScript. Blazor apps are composed of reusable web UI components implemented using C#, HTML, and CSS. Both client and server code is written in C#, allowing you to share code and libraries.
More information on the [official Blazor website](https://blazor.net).

### Get started

To get started with Blazor, follow the instructions in the [Blazor Get Started](https://docs.microsoft.com/aspnet/core/blazor/get-started) documentation.

## General
* [ASP.NET Blog's archives](https://devblogs.microsoft.com/aspnet/category/blazor/) - Archives of the ASP.NET blog about Blazor.
* [Blazor](https://dotnet.microsoft.com/apps/aspnet/web-apps/client) - Official website of Blazor, from Microsoft.
* [Blazor bites](https://chrissainty.com/blazor-bites/) - Blazor bites series by Chris Sainty.
* [Blazor-Dev gallery on .NET Foundation](https://dotnet.myget.org/gallery/blazor-dev) - Daily builds of the 'dev' branch of Blazor.
* [Blazor Extensions](https://github.com/BlazorExtensions) - Curated extensions for Microsoft ASP.Net Core Blazor.
* [Blazor University](http://blazor-university.com/) - Unofficial documentation website.
* [Demo](https://blazor-demo.github.io/) - Official basic demo website.
* [Documentation](https://docs.microsoft.com/en-us/aspnet/core/blazor) - Official documentation, by Microsoft.
* [eShopOnBlazor](https://github.com/dotnet-architecture/eShopOnBlazor) - ![GitHub stars](https://img.shields.io/github/stars/dotnet-architecture/eShopOnBlazor?style=flat-square&cacheSeconds=604800&logo=microsoft) ![last commit](https://img.shields.io/github/last-commit/dotnet-architecture/eShopOnBlazor?style=flat-square&cacheSeconds=86400) Migration of a traditional ASP.NET Web Forms app to Blazor, sample by Microsoft Architecture.
* [FAQ](https://github.com/aspnet/Blazor/wiki/FAQ) - FAQ.
* [GitHub repository](https://github.com/aspnet/Blazor) - ![GitHub stars](https://img.shields.io/github/stars/aspnet/Blazor?style=flat-square&cacheSeconds=604800&logo=microsoft) ![last commit](https://img.shields.io/github/last-commit/aspnet/Blazor?style=flat-square&cacheSeconds=86400) The official Blazor repository.
* ['Hello World' sample](https://github.com/dodyg/practical-aspnetcore/tree/master/projects/blazor) - 'Hello World' sample.
* [Introduction to ASP.NET Core](https://docs.microsoft.com/en-us/aspnet/core/) - Introduction to ASP.NET Core.
* [Study Blazor](https://studyblazor.com) - Blazor tutorial for beginners, in simple and easy steps starting from basics to advanced concepts with more code snippets.
* [Workshop](https://github.com/dotnet-presentations/blazor-workshop/) - ![GitHub stars](https://img.shields.io/github/stars/dotnet-presentations/blazor-workshop?style=flat-square&cacheSeconds=604800&logo=microsoft) ![last commit](https://img.shields.io/github/last-commit/aspnet/Blazor?style=flat-square&cacheSeconds=86400) Build a complete Blazor app and learn about the various Blazor framework features along the way.

## Sample Projects
### Authentication
* [BlazorBoilerplate](https://github.com/enkodellc/blazorboilerplate) - ![stars](https://img.shields.io/github/stars/enkodellc/blazorboilerplate?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/enkodellc/blazorboilerplate?style=flat-square&cacheSeconds=86400) Real World Admin Dashboard / Starter kit with IdentityServer4 Material Design. [Demo](https://blazorboilerplate.com).
* [BlazorWithIdentity](https://github.com/stavroskasidis/BlazorWithIdentity) - ![stars](https://img.shields.io/github/stars/stavroskasidis/BlazorWithIdentity?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/stavroskasidis/BlazorWithIdentity?style=flat-square&cacheSeconds=86400) A sample project showcasing a Blazor app using EF Core with Identity authentication.
* [Authentication with client-side Blazor](https://github.com/chrissainty/AuthenticationWithClientSideBlazor) - ![stars](https://img.shields.io/github/stars/chrissainty/AuthenticationWithClientSideBlazor?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/chrissainty/AuthenticationWithClientSideBlazor?style=flat-square&cacheSeconds=86400) Authentication with client-side Blazor using WebAPI and ASP.NET Core Identity. [Blog post](https://chrissainty.com/securing-your-blazor-apps-authentication-with-clientside-blazor-using-webapi-aspnet-core-identity/).
* [BlazorAuthenticationSample](https://github.com/christiansparre/BlazorAuthenticationSample) - ![stars](https://img.shields.io/github/stars/christiansparre/BlazorAuthenticationSample?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/christiansparre/BlazorAuthenticationSample?style=flat-square&cacheSeconds=86400) A sample showing some of the ASP.NET Core Blazor authentication features (also some testing...).
* [Blazor.Msal](https://github.com/cradle77/Blazor.Msal) - ![stars](https://img.shields.io/github/stars/cradle77/Blazor.Msal?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/cradle77/Blazor.Msal?style=flat-square&cacheSeconds=86400) Sample implementation for MSAL in Blazor, it shows how to integrate a Single Page Web Application made in Blazor WebAssembly with Azure Active Directory. It allows to authenticate the user and then acquire an access token to make a secure call to an external API. The code internally uses [MSAL.js](https://docs.microsoft.com/en-us/azure/active-directory/develop/msal-overview) to implement the OpenID Connect and OAuth2 flows.
* [Blazor.OpenId](https://github.com/jbomhold3/Blazor.Openid) - ![stars](https://img.shields.io/github/stars/jbomhold3/Blazor.Openid?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/jbomhold3/Blazor.Openid?style=flat-square&cacheSeconds=86400) Easy authentication and client refresh using OpenId.
* [Blorc.OpenIdConnect](https://github.com/WildGums/Blorc.OpenIdConnect) - ![last commit](https://img.shields.io/github/last-commit/WildGums/Blorc.OpenIdConnect?style=flat-square&cacheSeconds=86400) The right way to use OpenID Connect on Blazor.
* [BlazorGraphApi](https://github.com/wmgdev/BlazorGraphApi) - ![last commit](https://img.shields.io/github/last-commit/wmgdev/BlazorGraphApi?style=flat-square&cacheSeconds=86400) Blazor Server App with AD Authentication, that calls the MS Graph API on-behalf of the signed-in user using [Microsoft.Identity.Web](https://github.com/AzureAD/microsoft-identity-web).
### Cloud
* [BlazorAzure.WebApp](https://github.com/gpeipman/BlazorDemo/tree/master/BlazorAzure.WebApp) - ![stars](https://img.shields.io/github/stars/gpeipman/BlazorDemo?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/gpeipman/BlazorDemo?style=flat-square&cacheSeconds=86400) Blazor Azure web app.
* [BlazorAzure.Functions](https://github.com/gpeipman/BlazorDemo/tree/master/BlazorAzure.Functions) - ![stars](https://img.shields.io/github/stars/gpeipman/BlazorDemo?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/gpeipman/BlazorDemo?style=flat-square&cacheSeconds=86400) Azure function with Blazor.
* [BlazorFile2Azure](https://github.com/daltskin/BlazorFile2Azure) - ![stars](https://img.shields.io/github/stars/daltskin/BlazorFile2Azure?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/daltskin/BlazorFile2Azure?style=flat-square&cacheSeconds=86400) Upload a file from Blazor WebAssembly to Azure Blob Storage.
* [Blazor WASM Deployment](https://github.com/timheuer/blazor-deploy-sample/) - ![last commit](https://img.shields.io/github/last-commit/timheuer/blazor-deploy-sample?style=flat-square&cacheSeconds=86400) Sample repo for showing Actions to deploy a Blazor app to Azure services.
### CMS
* [Blogifier](https://github.com/blogifierdotnet/Blogifier) - ![GitHub stars](https://img.shields.io/github/stars/blogifierdotnet/Blogifier?style=flat-square&cacheSeconds=864000) ![GitHub stars](https://img.shields.io/github/last-commit/blogifierdotnet/Blogifier?style=flat-square&cacheSeconds=604800) ASP.NET Core Blogging application with Blazor Admin Dashboard. [Demo](http://blogifier.net/blog).
* [BlogCore](https://github.com/thangchung/blog-core) - ![GitHub stars](https://img.shields.io/github/stars/thangchung/blog-core?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/thangchung/blog-core?style=flat-square&cacheSeconds=86400) Modern CMS on Domain-driven Design and Clean Architecture patterns.
* [RapidCMS](https://github.com/ThomasBleijendaal/RapidCMS) - ![stars](https://img.shields.io/github/stars/ThomasBleijendaal/RapidCMS?style=flat-square&cacheSeconds=864000) ![stars](https://img.shields.io/github/last-commit/ThomasBleijendaal/RapidCMS?style=flat-square&cacheSeconds=604800) A code-first, extensible Blazor app that generates a CMS for your own database.
* [WordDaze](https://github.com/chrissainty/worddaze) - ![stars](https://img.shields.io/github/stars/chrissainty/worddaze?style=flat-square&cacheSeconds=864000) ![last commit](https://img.shields.io/github/last-commit/chrissainty/worddaze?style=flat-square&cacheSeconds=604800) Blogging application written using Blazor with a WebAPI backend.
* [AcBlog](https://github.com/acblog/acblog) - ![stars](https://img.shields.io/github/stars/acblog/acblog?style=flat-square&cacheSeconds=864000) ![Last commit](https://img.shields.io/github/last-commit/acblog/acblog?style=flat-square&cacheSeconds=604800) A blogging PWA that can be hosted as a full static website. [GitHub Pages Demo](https://acblog.github.io).
### Games
* [AsteroidsWasm](https://github.com/aesalazar/AsteroidsWasm) - ![stars](https://img.shields.io/github/stars/aesalazar/AsteroidsWasm?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/aesalazar/AsteroidsWasm?style=flat-square&cacheSeconds=86400) Collection of applications based on a single C# .NET Standard project running in:  Blazor Client (WebAssembly), Blazor Server, Electron, WPF, WinForms, Xamarin. [Demo](https://aesalazar.github.io/AsteroidsWasm/).
* [Trains.NET](https://github.com/davidwengier/Trains.NET) - ![stars](https://img.shields.io/github/stars/davidwengier/Trains.NET?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/davidwengier/Trains.NET?style=flat-square&cacheSeconds=86400) 2D game built with .NET and C#.
* [Flappy Blazor Bird](https://github.com/ctrl-alt-d/FlappyBlazorBird) - ![stars](https://img.shields.io/github/stars/ctrl-alt-d/FlappyBlazorBird?style=flat-square&cacheSeconds=604800) ![last-commit](https://img.shields.io/github/last-commit/ctrl-alt-d/FlappyBlazorBird?style=flat-square&cacheSeconds=86400) Blazor Flappy Bird's port. [[Wasm Demo]](http://flappyblazorbird.ctrl-alt-d.net) | [[Multiplayer Demo]](http://flappyparty.ctrl-alt-d.net/).
* [Blagario](https://github.com/ctrl-alt-d/Blagario) - ![GitHub stars](https://img.shields.io/github/stars/ctrl-alt-d/Blagario?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/ctrl-alt-d/Blagario?style=flat-square&cacheSeconds=86400) Experimental lab to test Blazor server side as multiplayer game engine.
* [DiabloBlazor](https://github.com/n-stefan/diabloblazor) - ![stars](https://img.shields.io/github/stars/n-stefan/diabloblazor?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/n-stefan/diabloblazor?style=flat-square&cacheSeconds=86400) Blazor port of DiabloWeb, making it a double WebAssembly app: a WebAssembly (C#) PWA hosting a WebAssembly (C++) game. [Demo](https://n-stefan.github.io/diabloblazor).
* [BlazorPong](https://github.com/MACEL94/BlazorPong) - ![last commit](https://img.shields.io/github/last-commit/MACEL94/BlazorPong?style=flat-square&cacheSeconds=86400) Pong in Blazor server side using SignalR Core. [Demo](https://blazorpong-dev-as.azurewebsites.net).
* [BlazorConnectFour](https://github.com/exceptionnotfound/BlazorConnectFour) - ![last commit](https://img.shields.io/github/last-commit/exceptionnotfound/BlazorConnectFour?style=flat-square&cacheSeconds=86400) Classic childhood game ConnectFour in Blazor.
* [Memory Game Wasm/PWA](https://github.com/HillPhelmuth/MemoryEtcWasm) - ![last commit](https://img.shields.io/github/last-commit/HillPhelmuth/MemoryEtcWasm?style=flat-square&cacheSeconds=86400) Simple Memory game with PWA support. [Demo](https://memoryetcwasmserver20200329202745.azurewebsites.net/).
### Hybrid experiments
* [Blazor + Electron](https://aka.ms/blazorelectron) - Host Razor Components inside an Electron shell. This allows for modern, high-performance cross-platform desktop apps built with .NET and web technologies.
* [Blazor + WebWindow](https://aka.ms/webwindow) - [WebWindow](https://www.nuget.org/packages/WebWindow) is like Electron, but without bundling Node.js or Chromium, and without most of the APIs. [WebWindow source code](https://github.com/SteveSandersonMS/WebWindow). [Blazor + WebWindow sample here](https://github.com/SteveSandersonMS/WebWindow/tree/master/samples/BlazorDesktopApp).
* [BlazorPoint](https://github.com/smjltd/BlazorPoint) - ![last commit](https://img.shields.io/github/last-commit/smjltd/BlazorPoint?style=flat-square&cacheSeconds=86000) Sample App to help you get started with hosting Blazor on SharePoint Pages, completely Client Side. 
### Logging
* [Logging.Samples](https://github.com/akovac35/Logging.Samples) - ![last-commit](https://img.shields.io/github/last-commit/akovac35/Logging.Samples?style=flat-square&cacheSeconds=86000) Samples for .NET Core and ASP.NET Core logging using various logger frameworks.
### Machine Learning
* [Scalable sentiment analysis](https://github.com/dotnet/machinelearning-samples/tree/master/samples/csharp/end-to-end-apps/ScalableSentimentAnalysisBlazorWebApp) - ![stars](https://img.shields.io/github/stars/dotnet/machinelearning-samples?style=flat-square&cacheSeconds=604800) ![last-commit](https://img.shields.io/github/last-commit/dotnet/machinelearning-samples?style=flat-square&cacheSeconds=86000) A sample ables to make sentiment analysis prediction/detection of what the user is writing in a very UI interactive app (Blazor based) in the client side and running an ML.NET model (Sentiment analysis based on binary-classification) in the server side.
* [optimizer.ml](https://github.com/jameschch/LeanParameterOptimization) - ![stars](https://img.shields.io/github/stars/jameschch/LeanParameterOptimization?style=flat-square&cacheSeconds=604800) ![last-commit](https://img.shields.io/github/last-commit/jameschch/LeanParameterOptimization?style=flat-square&cacheSeconds=86000) A "server-less" general purpose optimization suite for algorithm parameters. Also provides offline optimization of [Quantconnect Lean](https://github.com/QuantConnect/Lean) trading algorithms. [Demo (https://optimizer.ml)](https://optimizer.ml).
* [Baseball Machine Learning Workbench](https://github.com/bartczernicki/MachineLearning-BaseballPrediction-BlazorApp) - ![stars](https://img.shields.io/github/stars/bartczernicki/MachineLearning-BaseballPrediction-BlazorApp?style=flat-square&cacheSeconds=604800) ![last-commit](https://img.shields.io/github/last-commit/bartczernicki/MachineLearning-BaseballPrediction-BlazorApp?style=flat-square&cacheSeconds=86000) A web application that showcases performing what-if analysis using in-memory Machine Learning models. [Live demo](https://baseballmlworkbench-v1.azurewebsites.net).
* [PropertyPrices](https://github.com/jameschch/PropertyPrices) - ![last-commit](https://img.shields.io/github/last-commit/jameschch/PropertyPrices?style=flat-square&cacheSeconds=86000) A blazor front-end site that provides analysis and ensemble learning predictions (through SharpLearning) of property prices in the UK. [Demo (https://propertyprices.org.uk)](https://propertyprices.org.uk).
* [BlazorML5](https://github.com/sps014/BlazorML5) - ![last-commit](https://img.shields.io/github/last-commit/sps014/BlazorML5?style=flat-square&cacheSeconds=86000) ML5 Machine Learning for Blazor with JSInterop mechanism.
### Mobile
* [Mobile Blazor Bindings](https://aka.ms/mobileblazorbindings) - Experimental Mobile Blazor Bindings - Build native mobile apps with Blazor.
### ToDos
* [Minimal ToDo by David Fowler](https://github.com/davidfowl/Todos/tree/davidfowl/todo-blazor/TodoBlazor) - ![stars](https://img.shields.io/github/stars/davidfowl/Todos?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/davidfowl/Todos?style=flat-square&cacheSeconds=86000) Minimal ToDo backend API implementation by David Fowler from Microsoft.
* [Bolero.TodoMVC](https://github.com/fsbolero/TodoMVC) - ![GitHub stars](https://img.shields.io/github/stars/fsbolero/TodoMVC?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/fsbolero/TodoMVC?style=flat-square&cacheSeconds=86000) A TodoMVC clone using Bolero.
### Others
* [Flight Finder](https://github.com/aspnet/samples/tree/master/samples/aspnetcore/blazor) - ![GitHub stars](https://img.shields.io/github/stars/aspnet/samples?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/aspnet/samples?style=flat-square&cacheSeconds=86000&logo=microsoft) Flight Finder.
* [Oqtane Framework](https://github.com/oqtane/oqtane.framework) - ![GitHub stars](https://img.shields.io/github/stars/oqtane/oqtane.framework?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/oqtane/oqtane.framework?style=flat-square&cacheSeconds=86000) Modular Application Framework for Blazor.
* [BlazorDesktop](https://github.com/steveSandersonMS/BlazorDesktop) - ![GitHub stars](https://img.shields.io/github/stars/steveSandersonMS/BlazorDesktop?style=flat-square&cacheSeconds=604800&logo=microsoft) ![last commit](https://img.shields.io/github/last-commit/steveSandersonMS/BlazorDesktop?style=flat-square&cacheSeconds=86000) Native desktop Blazor app which not using Electron, by Steve Sanderson.
* [BlazorFileReader](https://github.com/Tewr/BlazorFileReader) - ![GitHub stars](https://img.shields.io/github/stars/Tewr/BlazorFileReader?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/Tewr/BlazorFileReader?style=flat-square&cacheSeconds=86000) Read-only File streams in Blazor. [Demo](https://tewr.github.io/BlazorFileReader/).
* [BlazorElectronExperiment](https://github.com/SteveSandersonMS/BlazorElectronExperiment.Sample) - ![GitHub stars](https://img.shields.io/github/stars/SteveSandersonMS/BlazorElectronExperiment.Sample?style=flat-square&cacheSeconds=604800&logo=microsoft) ![last commit](https://img.shields.io/github/last-commit/SteveSandersonMS/BlazorElectronExperiment.Sample?style=flat-square&cacheSeconds=604800) ![Status](https://img.shields.io/static/v1?label=status&message=archived&color=lightgrey) Exploring how a Blazor could be used to build a cross-platform desktop application using [Electron](https://electronjs.org/).
* [Toss.Blazor](https://github.com/RemiBou/Toss.Blazor) - ![GitHub stars](https://img.shields.io/github/stars/RemiBou/Toss.Blazor?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/RemiBou/Toss.Blazor?style=flat-square&cacheSeconds=86000) Twitter-like web application using Blazor.
* [BlazorChatSample](https://github.com/conficient/blazorchatsample) - ![stars](https://img.shields.io/github/stars/conficient/blazorchatsample?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/conficient/blazorchatsample?style=flat-square&cacheSeconds=86000) Blazor chat demo using SignalR JS client with interop.
* [eShopOnBlazor](https://github.com/dotnet-architecture/eShopOnBlazor) - ![GitHub stars](https://img.shields.io/github/stars/dotnet-architecture/eShopOnBlazor?style=flat-square&cacheSeconds=604800&logo=microsoft) ![last commit](https://img.shields.io/github/last-commit/dotnet-architecture/eShopOnBlazor?style=flat-square&cacheSeconds=86000) Migration of a traditional ASP.NET Web Forms app to Blazor.
* [Blazor contacts](https://github.com/bradwellsb/blazor-contacts) - ![stars](https://img.shields.io/github/stars/bradwellsb/blazor-contacts?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/bradwellsb/blazor-contacts?style=flat-square&cacheSeconds=86000) A project template for OData API, IdentityServer4 auth, and server-side Blazor.
* [BlazorCRUD](https://github.com/thbst16/BlazorCrud) - ![GitHub stars](https://img.shields.io/github/stars/thbst16/BlazorCrud?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/thbst16/BlazorCrud?style=flat-square&cacheSeconds=86400) Sample line of business application that illustrates key features of Blazor. [Demo](https://becksblazor.azurewebsites.net/).
* [BlazeDown](https://github.com/EdCharbeneau/BlazeDown) - ![GitHub stars](https://img.shields.io/github/stars/EdCharbeneau/BlazeDown?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/EdCharbeneau/BlazeDown?style=flat-square&cacheSeconds=86000) BlazeDown, online Markdown editor. [Demo](https://edcharbeneau.com/BlazeDown/).
* [Money](https://github.com/maraf/Money) - ![stars](https://img.shields.io/github/stars/maraf/Money?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/maraf/Money?style=flat-square&cacheSeconds=86000) A money manager implemented using CQRS+ES. [Demo](https://app.money.neptuo.com/).
* [Runny](https://github.com/Suchiman/Runny) - ![GitHub stars](https://img.shields.io/github/stars/Suchiman/Runny?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/Suchiman/Runny?style=flat-square&cacheSeconds=86000) Prototype of running roslyn in the browser via Blazor. [Demo](https://runny.azurewebsites.net/).
* [Blazor Weather](https://github.com/danroth27/BlazorWeather) - ![GitHub stars](https://img.shields.io/github/stars/danroth27/BlazorWeather?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/danroth27/BlazorWeather?style=flat-square&cacheSeconds=86000) A Blazor Weather sample app that shows the current weather for your current location and a collection of pinned locations. Demonstrated at .NET Conf 2019 by Daniel Roth. [Demo](https://aka.ms/blazorweather).
* [NethereumBlazor](https://github.com/Nethereum/NethereumBlazor) - ![GitHub stars](https://img.shields.io/github/stars/Nethereum/NethereumBlazor?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/Nethereum/NethereumBlazor?style=flat-square&cacheSeconds=86000) Ethereum blockchain explorer and simple wallet.
* [BlazorGrpc](https://github.com/razfriman/BlazorGrpc) - ![GitHub stars](https://img.shields.io/github/stars/razfriman/BlazorGrpc?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/razfriman/BlazorGrpc?style=flat-square&cacheSeconds=86000) Sample project that demonstrates how you can use the power of Blazor, ASP.NET Core, and gRPC to create a web application which can communicate with a backend that uses gRPC.
* [Gitter](https://github.com/Blazored/Gitter) - ![GitHub stars](https://img.shields.io/github/stars/Blazored/Gitter?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/Blazored/Gitter?style=flat-square&cacheSeconds=86000) A Blazor Gitter client.
* [Return](https://github.com/Sebazzz/Return) - ![GitHub stars](https://img.shields.io/github/stars/Sebazzz/Return?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/Sebazzz/Return?style=flat-square&cacheSeconds=86000) Realtime retrospective tool built in ASP.NET Core and Blazor.
* [BlazePort](https://github.com/EdCharbeneau/BlazePort) - ![GitHub stars](https://img.shields.io/github/stars/EdCharbeneau/BlazePort?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/EdCharbeneau/BlazePort?style=flat-square&cacheSeconds=86000) A futuristic ride share app for space travel written in full stack .NET with Blazor.
* [BlazorGraphExample](https://github.com/jburman/BlazorGraphExample) - ![stars](https://img.shields.io/github/stars/jburman/BlazorGraphExample?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/jburman/BlazorGraphExample?style=flat-square&cacheSeconds=86000) Example application for connecting to Graph API from Blazor.
* [BlazorDynamicList](https://github.com/conficient/BlazorDynamicList) - ![GitHub stars](https://img.shields.io/github/stars/conficient/BlazorDynamicList?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/conficient/BlazorDynamicList?style=flat-square&cacheSeconds=86000) Dynamic component binding for a generic list. [Demo](https://blazordynamiclist.azurewebsites.net/).
* [Blazor FIRE Calculators](https://github.com/bradwellsb/blazor-fire-calculators) - ![GitHub stars](https://img.shields.io/github/stars/bradwellsb/blazor-fire-calculators?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/bradwellsb/blazor-fire-calculators?style=flat-square&cacheSeconds=86000) Client-side financial calculators built using Blazor WebAssembly. Demonstrates custom number formatting and offline Progressive Web App (PWA) functionality. [Demo](https://fire.wellsb.com/).
* [Try F# on WebAssembly](https://github.com/fsbolero/TryFSharpOnWasm) - ![GitHub stars](https://img.shields.io/github/stars/fsbolero/TryFSharpOnWasm?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/fsbolero/TryFSharpOnWasm?style=flat-square&cacheSeconds=86000) The F# compiler running in WebAssembly with Bolero.
* [StarshipTraveler](https://github.com/rstropek/StarshipTraveler) - ![GitHub stars](https://img.shields.io/github/stars/rstropek/StarshipTraveler?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/rstropek/StarshipTraveler?style=flat-square&cacheSeconds=86000) A starship traveler demo app built with Blazor for the DevOne 2019 conference.
* [Blazor + Sitecore](https://github.com/GoranHalvarsson/SitecoreBlazor) - ![GitHub stars](https://img.shields.io/github/stars/GoranHalvarsson/SitecoreBlazor?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/GoranHalvarsson/SitecoreBlazor?style=flat-square&cacheSeconds=86000) Example of dynamic pages and routes with SiteCore and [Helix](https://helix.sitecore.net/). 
* [BlazorServerTree](https://github.com/ctrl-alt-d/BlazorServerTree) - ![GitHub stars](https://img.shields.io/github/stars/ctrl-alt-d/BlazorServerTree?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/ctrl-alt-d/BlazorServerTree?style=flat-square&cacheSeconds=86000) A simple Server-Side Blazor sample app to deal with hierarchical data.
* [BlazorBinding](https://github.com/SQL-MisterMagoo/BlazorBinding) - ![GitHub stars](https://img.shields.io/github/stars/SQL-MisterMagoo/BlazorBinding?style=flat-square&cacheSeconds=604800) ![GitHub stars](https://img.shields.io/github/last-commit/SQL-MisterMagoo/BlazorBinding?style=flat-square&cacheSeconds=86000) Sample Blazor App demonstrating various data binding scenarios.
* [WebSocketPage](https://github.com/Lupusa87/BlazorWebSocketHelper) - ![stars](https://img.shields.io/github/stars/Lupusa87/BlazorWebSocketHelper?style=flat-square&cacheSeconds=604800) ![last-commit](https://img.shields.io/github/last-commit/Lupusa87/BlazorWebSocketHelper?style=flat-square&cacheSeconds=86000) Web Socket in Blazor. [demo](https://lupblazordemos.z13.web.core.windows.net/WebSocketPage).
* [C# Minifer](https://github.com/atifaziz/CSharpMinifierDemo) ![last-commit](https://img.shields.io/github/last-commit/atifaziz/CSharpMinifierDemo?style=flat-square&cacheSeconds=86000) A client-side Blazor application demonstrating live minification of C# code using the [C# Minifier](https://github.com/atifaziz/CSharpMinifier) library. [Demo](https://atifaziz.github.io/CSharpMinifierDemo/).
* [BlazorPages](https://github.com/fernandreu/blazor-pages) - ![last-commit](https://img.shields.io/github/last-commit/fernandreu/blazor-pages?style=flat-square&cacheSeconds=86000) A sample client-side Blazor app showcasing automatic deployment to GitHub Pages via Azure Pipelines.
* [Pattern Maker](https://github.com/sapsari/website-blazor-demo) - ![last-commit](https://img.shields.io/github/last-commit/sapsari/website-blazor-demo?style=flat-square&cacheSeconds=86000) C# code transformation demo that uses Roslyn and Monaco Editor. [Demo](https://patternmaker.netlify.com/).
* [Tulsa .NET User Group website](https://github.com/devsgarage/tulsa-dnug-website) - ![Last commit](https://img.shields.io/github/last-commit/devsgarage/tulsa-dnug-website?style=flat-square&cacheSeconds=86000) Tulsa .NET User Group website.
* [Planning Poker](https://github.com/duracellko/planningpoker4azure) &ndash; ![Last commit](https://img.shields.io/github/last-commit/duracellko/planningpoker4azure?style=flat-square&cacheSeconds=86000) An app to play Planning Poker for distributed teams. The app is implemented using Blazor and shows how to switch between client-side and server-side mode with a configuration change. [Demo](http://planningpoker.duracellko.net).
* [Gjallarhorn](https://github.com/haavamoa/Gjallarhorn) - ![Last commit](https://img.shields.io/github/last-commit/haavamoa/Gjallarhorn?style=flat-square&cacheSeconds=86000) Compare packages on different NuGet-sources. Demonstrating Client-Side Blazor MVVM-style. 
* [C# Regex Tester online](https://github.com/lsvhome/regex-tester) - ![Last commit](https://img.shields.io/github/last-commit/lsvhome/regex-tester?style=flat-square&cacheSeconds=86000) Online tool for verify .Net regex syntax. ([Demo](https://lsvhome.github.io/regex-tester/)).
* [Blazor Tour of Heroes](https://github.com/georgemathieson/blazor-tour-of-heroes) - Blazor Tour of Heroes, using [Blazor-State](https://github.com/TimeWarpEngineering/blazor-state)(State Management architecture utilizing the MediatR pipeline) for the Redux style state.
* [Blazor.Console](https://github.com/ardacetinkaya/Blazor.Console) - ![last commit](https://img.shields.io/github/last-commit/ardacetinkaya/Blazor.Console?style=flat-square&cacheSeconds=86000) A simple component to mock CLI for ASP.NET Core 3.0 Blazor applications to execute some custom commands for an application.
* [Cognitive Services Explorer](https://github.com/jernejk/CognitiveServices.Explorer) - ![last commit](https://img.shields.io/github/last-commit/jernejk/CognitiveServices.Explorer?style=flat-square&cacheSeconds=86000) PWA enabled app used to showcase what Cognitive Services can do, built-in client-side Blazor. [Demo](https://jernejk.github.io/CognitiveServices.Explorer/).
* [Blazor Wake-on-LAN](https://github.com/georg-jung/BlazorWoL) - ![Last commit](https://img.shields.io/github/last-commit/georg-jung/BlazorWoL?style=flat-square&cacheSeconds=86000) Wake-on-LAN app for local networks. Blazor Server + EF Core + DI + CI.
* [BlazorOCR](https://github.com/daltskin/BlazorOCR) - ![Last commit](https://img.shields.io/github/last-commit/daltskin/BlazorOCR?style=flat-square&cacheSeconds=86000) A Blazor WebAssembly application for reading receipts.
* [Dcidr](https://github.com/timplourde/dcidr-blazor) - ![Last commit](https://img.shields.io/github/last-commit/timplourde/dcidr-blazor?style=flat-square&cacheSeconds=86000) Blazor WebAssembly decision-making app with PWA (offline), localstorage, and Excel export. [Demo](https://dcidr.z20.web.core.windows.net/).
* [BlazorForum](https://github.com/ElliottBrand/BlazorForum) - ![Last commit](https://img.shields.io/github/last-commit/ElliottBrand/BlazorForum?style=flat-square&cacheSeconds=86000) Forum application built with Blazor.
* [Blazor + Umbraco Heartcore](https://github.com/umbraco/Umbraco.Headless.Client.Net/tree/master/samples/Umbraco.Headless.Client.Samples.BlazorServer) - ![Last commit](https://img.shields.io/github/last-commit/umbraco/Umbraco.Headless.Client.Net?style=flat-square&cacheSeconds=86000) Example of using [Umbraco Heartcore](https://umbraco.com/products/umbraco-heartcore/) with Blazor.
* [BlazorGrpcWebCodeFirst](https://github.com/hakenr/BlazorGrpcWebCodeFirst) - ![last commit](https://img.shields.io/github/last-commit/hakenr/BlazorGrpcWebCodeFirst?style=flat-square&cacheSeconds=86000) Sample project that demonstrates how you can use gRPC-Web with Blazor WebAssembly hosted on ASP.NET Core. Publish and consume your services without having to create .proto files - with the code-first approach.
* [GTAVehicles](https://github.com/mytatuo/GTAVehicles) - ![last commit](https://img.shields.io/github/last-commit/mytatuo/GTAVehicles?style=flat-square&cacheSeconds=86000) Sample app to manage GTA vehicles. [Demo](https://gtavehicles.azurewebsites.net/).
* [BlazingWaffles](https://github.com/gbiellem/BlazingWaffles) - ![last commit](https://img.shields.io/github/last-commit/gbiellem/BlazingWaffles?style=flat-square&cacheSeconds=86000) A Blazor app that wraps [Waffle Generator](https://github.com/SimonCropp/WaffleGenerator). The generator outputs readable gibberish that can be used in place of Lorum Ipsum. [Demo](http://wafflegen.azurewebsites.net/).
* [Cærostris](https://github.com/tresoneur/Caerostris) - ![last commit](https://img.shields.io/github/last-commit/tresoneur/Caerostris?style=flat-square&cacheSeconds=86000) A Blazor Spotify client.

## Tutorials
* [Blazor workshop](https://github.com/dotnet-presentations/blazor-workshop/) - ![GitHub stars](https://img.shields.io/github/stars/dotnet-presentations/blazor-workshop?style=flat-square&cacheSeconds=604800&logo=microsoft) Blazor app building workshop by [.NET Foundation](https://www.dotnetfoundation.org/), Blazzing Pizza.
* [Creating Outlook Calendar Client from scratch](https://www.youtube.com/watch?v=5ouXHtzKL5o&list=PLFJQnCcZXWjv89uDubYW7NniK8mEl4sWQ) - May, 2020 - In this course you'll see how to develop a calendar application from scratch (design, structing and logic) then make it integrated with Microsoft Outlook so our events on the calendar being synced with Outlook. [Source code](https://github.com/aksoftware98/BlazorOutlookCalendar) ![stars](https://img.shields.io/github/stars/aksoftware98/BlazorOutlookCalendar?style=flat-square&cacheSeconds=604800) ![last-commit](https://img.shields.io/github/last-commit/aksoftware98/BlazorOutlookCalendar?style=flat-square&cacheSeconds=86000).
* [PlannerApp full client-side project with Blazor WebAssembly](https://www.youtube.com/playlist?list=PLFJQnCcZXWjtftgq0KID4oHk6wfJrRL1r) - March 2020 - Video tutorial that covers how to build a full client-side application using Blazor WebAssembly, The back-end is already done and hosted on Azure so we will take advantage of that to teach you how to develop full application from scratch. [Source code](https://github.com/aksoftware98/plannerapp_blazor).
* [Build an Authenticated Web App in C# with Blazor](https://morioh.com/p/97a53fe40f2e) - March, 2020 - Build an Authenticated Web App in C# with Blazor and [octa.com](https://www.okta.com) service.
* [Building an Application with Blazorade Bootstrap](https://mikaberglund.com/2020/02/17/building-an-application-with-blazorade-bootstrap-part-3/) - February 17, 2020 - Building an Application with Blazorade Bootstrap. [Part 3](https://mikaberglund.com/2020/02/17/building-an-application-with-blazorade-bootstrap-part-3/). [Part 2](https://mikaberglund.com/2020/01/08/building-an-application-with-blazor-bootstrap-part-2/). [Part 1](https://mikaberglund.com/2020/01/05/building-an-application-with-blazor-bootstrap-part-1/). [Source code](https://github.com/MikaBerglund/Blazor-Bootstrap-Demo).
* [Creating a step-by-step end-to-end database Client-Side (WebAssembly) Blazor application](http://blazorhelpwebsite.com/Blog/tabid/61/EntryId/4371/Creating-A-Step-By-Step-End-To-End-Database-Client-Side-Web-Assembly-Blazor-Application.aspx) - February 15, 2020 - This post covers how a list of Weather forecasts can be added to the database by each user. A user will only have the ability to see their own forecasts.
* [Getting started with Blorc.PatternFly](https://medium.com/patternfly/getting-started-with-blorc-patternfly-tutorial-cc71fed4bef6) - January 7, 2020 - Getting started with Blorc.PatternFly. What is Blorc.PatternFly? Standing for Blazor, Orc, and PatternFly, Blorc.PatternFly is a library with the ultimate goal of wrapping all PatternFly components and making them available as Blazor components. [Source code](https://github.com/alexfdezsauco/Blorc.PatternFly.QuickStart).
* [Archives](https://github.com/AdrienTorris/awesome-blazor/tree/master/Archives) - [2019](https://github.com/AdrienTorris/awesome-blazor/blob/master/Archives/2019.md#tutorials), [2018](https://github.com/AdrienTorris/awesome-blazor/blob/master/Archives/2018.md#tutorials).

## Libraries & Extensions
### Components
*Reusable components like buttons, inputs, grids and more.*
* [MatBlazor](https://github.com/SamProf/MatBlazor) - ![GitHub stars](https://img.shields.io/github/stars/SamProf/MatBlazor?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/SamProf/MatBlazor?style=flat-square&cacheSeconds=86400) Material Design components for Blazor. ([Demo](https://www.matblazor.com/)).
* [Ant Design Blazor](https://github.com/ant-design-blazor/ant-design-blazor) - ![GitHub stars](https://img.shields.io/github/stars/ant-design-blazor/ant-design-blazor?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/ant-design-blazor/ant-design-blazor?style=flat-square&cacheSeconds=86400) A set of enterprise-class UI components based on Ant Design and Blazor. ([Docs as Demo](https://ant-design-blazor.github.io/)).
* [Blazorise](https://github.com/stsrki/Blazorise) - ![GitHub stars](https://img.shields.io/github/stars/stsrki/Blazorise?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/stsrki/Blazorise?style=flat-square&cacheSeconds=86400) Components for Blazor with support for Bootstrap, Bulma, AntDesign and Material CSS. ([Bootstrap Demo](https://bootstrapdemo.blazorise.com/)), ([Bulma Demo](https://bulmademo.blazorise.com/)), ([AntDesign Demo](https://antdesigndemo.blazorise.com/)), ([Material Demo](https://materialdemo.blazorise.com/)).
* [BlazorStrap](https://github.com/chanan/BlazorStrap) - ![GitHub stars](https://img.shields.io/github/stars/chanan/BlazorStrap?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/chanan/BlazorStrap?style=flat-square&cacheSeconds=86400) Material Design components for Blazor. Bootstrap 4 components for Blazor ([Demo](https://chanan.github.io/BlazorStrap/)).
* [Radzen.Blazor](https://github.com/akorchev/razor.radzen.com) - ![GitHub stars](https://img.shields.io/github/stars/akorchev/razor.radzen.com?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/akorchev/razor.radzen.com?style=flat-square&cacheSeconds=86400) Native UI components for Blazor. DataGrid, DataList, Tabs, Dialog and more. ([Demo](https://razor.radzen.com/)).
* [Canvas](https://github.com/BlazorExtensions/Canvas) - ![GitHub stars](https://img.shields.io/github/stars/BlazorExtensions/Canvas?style=flat-square&cacheSeconds=604800&logo=microsoft) ![last commit](https://img.shields.io/github/last-commit/BlazorExtensions/Canvas?style=flat-square&cacheSeconds=86400) Material Design components for Blazor. HTML5 Canvas API implementation for Microsoft Blazor.
* [ChartJs.Blazor](https://github.com/mariusmuntean/ChartJs.Blazor) - ![GitHub stars](https://img.shields.io/github/stars/mariusmuntean/ChartJs.Blazor?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/akorchev/razor.radzen.com?style=flat-square&cacheSeconds=86400) Brings [ChartJs](https://github.com/chartjs/Chart.js) charts to Blazor.
* [ComponentOne Blazor UI Components](https://www.grapecity.com/componentone/blazor-ui-controls) - External link. A fast datagrid, listview, input and other native Blazor components for server and client-side apps.
* [DevExpress Blazor UI Components](https://github.com/DevExpress/RazorComponents) - ![stars](https://img.shields.io/github/stars/DevExpress/RazorComponents?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/DevExpress/RazorComponents?style=flat-square&cacheSeconds=86400) A set of native UI Blazor components (including a Data Grid, Pivot Grid, Scheduler, and Charts) for both Blazor server-side and Blazor client-side platforms.
* [BlazorFluentUI](https://github.com/BlazorFluentUI/BlazorFluentUI) - ![stars](https://img.shields.io/github/stars/BlazorFluentUI/BlazorFluentUI?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/BlazorFluentUI/BlazorFluentUI?style=flat-square&cacheSeconds=86400) Simple port of FluenUI/Office Fabric React components and style to Blazor. [Client-side demo (WebAssembly)](https://www.blazorfluentui.net/). [Server-side demo (SignalR)](https://blazorfluentui.azurewebsites.net/).
* [BlazorContextMenu](https://github.com/stavroskasidis/BlazorContextMenu) - ![GitHub stars](https://img.shields.io/github/stars/stavroskasidis/BlazorContextMenu?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/stavroskasidis/BlazorContextMenu?style=flat-square&cacheSeconds=86400) Material Design components for Blazor. A context menu component for Blazor ([Demo](https://blazor-context-menu-demo.azurewebsites.net/)).
* [Blazored.Modal](https://github.com/Blazored/Modal) - ![GitHub stars](https://img.shields.io/github/stars/Blazored/Modal?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/Blazored/Modal?style=flat-square&cacheSeconds=86400) A JavaScript free modal library for Blazor and Razor Components applications.
* [Blazor.FlexGrid](https://github.com/Mewriick/Blazor.FlexGrid) - ![GitHub stars](https://img.shields.io/github/stars/Mewriick/Blazor.FlexGrid?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/Mewriick/Blazor.FlexGrid?style=flat-square&cacheSeconds=86400) GridView component for Blazor.
* [Grid.Blazor](https://github.com/gustavnavar/Grid.Blazor) - ![GitHub stars](https://img.shields.io/github/stars/gustavnavar/Grid.Blazor?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/gustavnavar/Grid.Blazor?style=flat-square&cacheSeconds=86400) Grid component with CRUD forms for Blazor and ASP.NET MVC, supporting filtering, sorting, searching, paging, subgrids and others ([Demo](http://gridblazor.azurewebsites.net)).
* [BlazorMaterial](https://github.com/BlazorExtensions/BlazorMaterial) - ![GitHub stars](https://img.shields.io/github/stars/BlazorExtensions/BlazorMaterial?style=flat-square&cacheSeconds=604800&logo=microsoft) ![last commit](https://img.shields.io/github/last-commit/BlazorExtensions/BlazorMaterial?style=flat-square&cacheSeconds=86400) Blazor components implementing Google's Material components for web.
* [BlazorWebFormsComponents](https://github.com/FritzAndFriends/BlazorWebFormsComponents) - ![stars](https://img.shields.io/github/stars/FritzAndFriends/BlazorWebFormsComponents?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/FritzAndFriends/BlazorWebFormsComponents?style=flat-square&cacheSeconds=604800) A collection of Blazor components that emulate the web forms components of the same name.
* [bUnit - a testing library for Blazor components](https://github.com/egil/bunit) - ![stars](https://img.shields.io/github/stars/egil/bunit?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/egil/bunit?style=flat-square&cacheSeconds=86400) A testing library for Blazor Components. You can easily define components under test in C# or Razor syntax and verify outcome using semantic HTML diffing/comparison logic. You can easily interact with and inspect components, trigger event handlers, provide cascading values, inject services, mock IJsRuntime, and perform snapshot testing.
* [Blazored.Toast](https://github.com/Blazored/Toast) - ![GitHub stars](https://img.shields.io/github/stars/Blazored/Toast?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/Blazored/Toast?style=flat-square&cacheSeconds=86400) A JavaScript free toast library for Blazor and Razor Component applications.
* [BlazorInputFile](https://github.com/SteveSandersonMS/BlazorInputFile) - ![GitHub stars](https://img.shields.io/github/stars/SteveSandersonMS/BlazorInputFile?style=flat-square&cacheSeconds=604800&logo=microsoft) ![last commit](https://img.shields.io/github/last-commit/SteveSandersonMS/BlazorInputFile?style=flat-square&cacheSeconds=86400) A file input component for Blazor applications, by Steve Sanderson.
* [Syncfusion Blazor UI Components](https://github.com/syncfusion/ej2-aspnet-core-blazor-samples) - ![GitHub stars](https://img.shields.io/github/stars/syncfusion/ej2-aspnet-core-blazor-samples?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/syncfusion/ej2-aspnet-core-blazor-samples?style=flat-square&cacheSeconds=86400) Robust UI components including [Data Grid](https://ej2.syncfusion.com/aspnet-core-razor-components/Grid/DefaultFunctionalities), [Charts](https://ej2.syncfusion.com/aspnet-core-razor-components/Charts/polar), [Scheduler](https://ej2.syncfusion.com/aspnet-core-razor-components/Schedule/TimelineResourceGroup), [Inputs](https://ej2.syncfusion.com/aspnet-core-razor-components/TextBox/DefaultFunctionalities) and several [Editor](https://ej2.syncfusion.com/aspnet-core-razor-components/RichTextEditor/DefaultFunctionalities) components.
* [Blazored.Typeahead](https://github.com/Blazored/Typeahead) - ![GitHub stars](https://img.shields.io/github/stars/Blazored/Typeahead?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/Blazored/Typeahead?style=flat-square&cacheSeconds=86400) Auto-complete textbox with local and remote data source, for both Client-side and Server-Side Blazor.
* [Sotsera.Blazor.Toaster](https://github.com/sotsera/sotsera.blazor.toaster) - ![GitHub stars](https://img.shields.io/github/stars/sotsera/sotsera.blazor.toaster?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/sotsera/sotsera.blazor.toaster?style=flat-square&cacheSeconds=86400) A Blazor port of Toastr.js. [Demo](https://blazor-toaster.sotsera.com/).
* [BlazorStyled](https://github.com/chanan/BlazorStyled) - ![GitHub stars](https://img.shields.io/github/stars/chanan/BlazorStyled?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/chanan/BlazorStyled?style=flat-square&cacheSeconds=86400) CSS in Blazor Components ([Demo](https://chanan.github.io/BlazorStyled)).
* [Blazor LoadingBar](https://github.com/jsakamoto/Toolbelt.Blazor.LoadingBar) - ![GitHub stars](https://img.shields.io/github/stars/jsakamoto/Toolbelt.Blazor.LoadingBar?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/jsakamoto/Toolbelt.Blazor.LoadingBar?style=flat-square&cacheSeconds=86400) Loading bar UI for Client-Side Blazor application.
* [Blazored.Menu](https://github.com/Blazored/Menu) - ![stars](https://img.shields.io/github/stars/Blazored/Menu?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/Blazored/Menu?style=flat-square&cacheSeconds=86400) A JavaScript free menu library for Blazor and Razor Components applications.
* [Blazor-DragDrop](https://github.com/Postlagerkarte/blazor-dragdrop) - ![GitHub stars](https://img.shields.io/github/stars/Postlagerkarte/blazor-dragdrop?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/Postlagerkarte/blazor-dragdrop?style=flat-square&cacheSeconds=86400) Easy-to-use Drag and Drop library for Blazor.
* [BlazorTable](https://github.com/IvanJosipovic/BlazorTable) - ![stars](https://img.shields.io/github/stars/IvanJosipovic/BlazorTable?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/IvanJosipovic/BlazorTable?style=flat-square&cacheSeconds=86400) A Table Control for Blazor with sorting, paging, filtering and more ([Demo](https://BlazorTable.netlify.com)).
* [Blazor-Charts](https://github.com/Misfits-Rebels-Outcasts/Blazor-Charts) - ![GitHub stars](https://img.shields.io/github/stars/Misfits-Rebels-Outcasts/Blazor-Charts?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/Misfits-Rebels-Outcasts/Blazor-Charts?style=flat-square&cacheSeconds=86400) SVG charts for Blazor.
* [NodaTimePicker](https://github.com/nheath99/NodaTimePicker) - ![GitHub stars](https://img.shields.io/github/stars/nheath99/NodaTimePicker?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/nheath99/NodaTimePicker?style=flat-square&cacheSeconds=86400) A Date/Time picker component library for Blazor using NodaTime. [Demo](https://nodatimepicker.z13.web.core.windows.net/).
* [BlazorDateRangePicker](https://github.com/jdtcn/BlazorDateRangePicker) - ![stars](https://img.shields.io/github/stars/jdtcn/BlazorDateRangePicker?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/jdtcn/BlazorDateRangePicker?style=flat-square&cacheSeconds=86400) A date range picker component library for Blazor. [Demo](https://BlazorDateRangePicker.azurewebsites.net/).
* [BlazorGoogleMaps](https://github.com/rungwiroon/BlazorGoogleMaps) - ![GitHub stars](https://img.shields.io/github/stars/rungwiroon/BlazorGoogleMaps?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/rungwiroon/BlazorGoogleMaps?style=flat-square&cacheSeconds=86400) Blazor interop for GoogleMap library.
* [Blazor.SignaturePad](https://github.com/Mobsites/Blazor.SignaturePad) - ![GitHub stars](https://img.shields.io/github/stars/Mobsites/Blazor.SignaturePad?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/Mobsites/Blazor.SignaturePad?style=flat-square&cacheSeconds=86400) A Blazor component library that utilizes Szymon Nowak's javascript library Signature Pad to implement smooth signature drawing on a HTML5 canvas.
* [Flexor](https://github.com/DerekChasse/Flexor) - ![last commit](https://img.shields.io/github/last-commit/DerekChasse/Flexor?style=flat-square&cacheSeconds=86400) Highly configurable components which let you take full advantage of Flexbox CSS.([Demo](http://flexor.azurewebsites.net/)).
* [Blazor-Dom-Confetti](https://github.com/ctrl-alt-d/blazor-dom-confetti) - ![last commit](https://img.shields.io/github/last-commit/ctrl-alt-d/blazor-dom-confetti?style=flat-square&cacheSeconds=86400) Celebrate success with dom 🎉confetti🎉 on Blazor projects. Two versions, dom-confetti wrapper and native blazor 100% JS free.
* [BlazorQuery](https://github.com/kevinjpetersen/BlazorQuery) - ![last commit](https://img.shields.io/github/last-commit/kevinjpetersen/BlazorQuery?style=flat-square&cacheSeconds=86400) jQuery for Blazor (Blazor Library that wraps jQuery completely in C# for use in Blazor).
* [Telerik UI for Blazor](https://www.telerik.com/blazor-ui) - External link (telerik.com). A native set of UI components for Blazor, including grid, charting, and calendar components.
* [TwitterShareButton](https://github.com/jsakamoto/Toolbelt.Blazor.TwitterShareButton) - ![last commit](https://img.shields.io/github/last-commit/jsakamoto/Toolbelt.Blazor.TwitterShareButton?style=flat-square&cacheSeconds=86400) A Tweet Button component for Blazor.
* [Blazor.LoadingIndicator](https://github.com/h3x4d3c1m4l/Blazor.LoadingIndicator) - ![last commit](https://img.shields.io/github/last-commit/h3x4d3c1m4l/Blazor.LoadingIndicator?style=flat-square&cacheSeconds=86400) Simple to use loading indicator helper library.
* [BlazorTypography](https://github.com/chanan/BlazorTypography) - ![last commit](https://img.shields.io/github/last-commit/chanan/BlazorTypography?style=flat-square&cacheSeconds=86400) A powerful toolkit for building websites with beautiful design ([Demo](https://chanan.github.io/BlazorTypography/)).
* [Razor.SweetAlert2](https://github.com/Basaingeal/Razor.SweetAlert2) - ![last commit](https://img.shields.io/github/last-commit/Basaingeal/Razor.SweetAlert2?style=flat-square&cacheSeconds=86400) Blazor component implementing the popular SweetAlert2 JavaScript Library. 
* [Blazor.SpinKit](https://github.com/faso/Faso.Blazor.SpinKit) - ![last commit](https://img.shields.io/github/last-commit/faso/Faso.Blazor.SpinKit?style=flat-square&cacheSeconds=86400) Blazor components for [SpinKit](https://tobiasahlin.com/spinkit/) spinners.
* [Blorc.PatternFly](https://github.com/WildGums/Blorc.PatternFly) - ![stars](https://img.shields.io/github/stars/WildGums/Blorc.PatternFly?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/WildGums/Blorc.PatternFly?style=flat-square&cacheSeconds=86400) Blazor wrappers for [PatternFly](https://www.patternfly.org). To view the latest develop branch in action, visit the [demo](http://blorc-patternfly.wildgums.com/) app.
* [Head Element Helper](https://github.com/jsakamoto/Toolbelt.Blazor.HeadElement) - ![last commit](https://img.shields.io/github/last-commit/jsakamoto/Toolbelt.Blazor.HeadElement?style=flat-square&cacheSeconds=86400) `<Title>` and `<Meta>` components for changing the document titile and meta elements, with server-side prerendering support for SEO/OGP. ([Demo](https://demo-blazor-headelement.azurewebsites.net/)).
* [Localized Data Annotations Validator](https://github.com/jsakamoto/Toolbelt.Blazor.LocalizedDataAnnotationsValidator/) - ![last commit](https://img.shields.io/github/last-commit/jsakamoto/Toolbelt.Blazor.LocalizedDataAnnotationsValidator?style=flat-square&cacheSeconds=86400) The data annotations validator for Blazor to localize validation error messages. ([Demo](https://demo-blazor-localized-data-annotations-validator.azurewebsites.net/)).
* [BlazorWebFormsComponents](https://github.com/FritzAndFriends/BlazorWebFormsComponents) - ![last commit](https://img.shields.io/github/last-commit/FritzAndFriends/BlazorWebFormsComponents?style=flat-square&cacheSeconds=86400) A collection of Blazor components that emulate the web forms components of the same name.
* [BlazorSize](https://github.com/EdCharbeneau/BlazorSize) - ![last commit](https://img.shields.io/github/last-commit/EdCharbeneau/BlazorSize?style=flat-square&cacheSeconds=86400) BlazorSize is a JavaScript interop library for Blazor that is used to detect the Browser's current size, change in size, and test media queries.
* [LiquidTechnologies.Blazor.ModalDialog](https://github.com/LiquidTechnologies/blazor-modal-dialog) - ![last commit](https://img.shields.io/github/last-commit/LiquidTechnologies/blazor-modal-dialog?style=flat-square&cacheSeconds=86400) Turns Blazor components into Modal Dialogs, allows values to be returned from the dialogs (var result = await ShowDialogAsync(...)), includes simple MessageBox and data capture dialogs (for Blazor Client & Server).
* [GG.Net Data Visualization](https://github.com/pablofrommars/GGNet) - ![last commit](https://img.shields.io/github/last-commit/pablofrommars/GGNet?style=flat-square&cacheSeconds=86400) Interactive and flexible charts for Blazor Web Apps. Taking its inspiration from the highly popular ggpplot2 R package, GG.Net provides natively rich features for your Data Analysis Workflow. Build publication quality charts with just a few lines of code. [Website](https://pablofrommars.github.io/).
* [BlazorMonaco](https://github.com/serdarciplak/BlazorMonaco) - ![last commit](https://img.shields.io/github/last-commit/serdarciplak/BlazorMonaco?style=flat-square&cacheSeconds=86400) Blazor component for Microsoft's [Monaco Editor](https://github.com/Microsoft/monaco-editor) which powers Visual Studio Code. ([Demo](https://serdarciplak.github.io/BlazorMonaco/)).
* [BlazorContentEditable](https://github.com/austineric/BlazorContentEditable) - ![last commit](https://img.shields.io/github/last-commit/austineric/blazorcontenteditable?style=flat-square&cacheSeconds=86400) Provides contenteditable functionality for Blazor. ([Demo](https://austineric.github.io/BlazorContentEditable/)).
* [DnetOverlay](https://github.com/amuste/DnetOverlay) - ![last commit](https://img.shields.io/github/last-commit/amuste/DnetOverlay?style=flat-square&cacheSeconds=86400) Agular CDK Overlay implementation for Blazor.
* [Table.Net](https://github.com/pablofrommars/TableNet) - ![last commit](https://img.shields.io/github/last-commit/pablofrommars/TableNet?style=flat-square&cacheSeconds=86400) Interactive and flexible Data Tables for Blazor Web Apps.
* [Blazor-Sparkline](https://github.com/Misfits-Rebels-Outcasts/Blazor-Sparkline) - ![last commit](https://img.shields.io/github/last-commit/Misfits-Rebels-Outcasts/Blazor-Sparkline?style=flat-square&cacheSeconds=86400) Sparkline Charts for Blazor using Fonts.
* [Blazor-ApexCharts](https://github.com/joadan/Blazor-ApexCharts) - ![last commit](https://img.shields.io/github/last-commit/joadan/Blazor-ApexCharts?style=flat-square&cacheSeconds=86400) Blazor wrapper for ApexCharts. [Demo](https://joadan.github.io/Blazor-ApexCharts/basic-charts).
* [BlazorCss](https://github.com/tomlm/BlazorCss) - ![last commit](https://img.shields.io/github/last-commit/tomlm/BlazorCss?style=flat-square&cacheSeconds=604800) CSS Helper for BlazorStyled which provides auto complete CSS styles.
* [BlazorCssGrid](https://github.com/tomlm/BlazorCssGrid) - ![last commit](https://img.shields.io/github/last-commit/tomlm/BlazorCssGrid?style=flat-square&cacheSeconds=604800) Css Helper for defining Grid SPA layouts in BlazorStyled.
* [MComponents](https://github.com/manureini/MComponents) - ![last commit](https://img.shields.io/github/last-commit/manureini/MComponents?style=flat-square&cacheSeconds=86400) Open Source MIT Blazor Components: Grid, Select, Wizard etc.
### Tools & Utilities
*Libraries and extensions for state management, cookies, local storage and other specific tools.*
* [Blazor-Redux](https://github.com/torhovland/blazor-redux) - ![GitHub stars](https://img.shields.io/github/stars/torhovland/blazor-redux?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/torhovland/blazor-redux?style=flat-square&cacheSeconds=86400) Connecting a Redux state store with Blazor.
* [Fluxor](https://github.com/mrpmorris/fluxor) - ![GitHub stars](https://img.shields.io/github/stars/mrpmorris/fluxor?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/mrpmorris/fluxor?style=flat-square&cacheSeconds=86400) Zero boilerplate Flux/Redux library for DotNet. Formerly [Blazor-Fluxor](https://github.com/mrpmorris/blazor-fluxor) ![GitHub stars](https://img.shields.io/github/stars/mrpmorris/blazor-fluxor?style=flat-square&cacheSeconds=604800).
* [SignalR](https://github.com/BlazorExtensions/SignalR) - ![GitHub stars](https://img.shields.io/github/stars/BlazorExtensions/SignalR?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/BlazorExtensions/SignalR?style=flat-square&cacheSeconds=86400) SignalR Core implementation for Blazor. It uses the JavaScript client.
* [Blazored.LocalStorage](https://github.com/Blazored/LocalStorage) - ![GitHub stars](https://img.shields.io/github/stars/Blazored/LocalStorage?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/Blazored/LocalStorage?style=flat-square&cacheSeconds=86400) A library to provide access to local storage in Blazor applications.
* [Storage](https://github.com/BlazorExtensions/Storage) - ![GitHub stars](https://img.shields.io/github/stars/BlazorExtensions/Storage?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/BlazorExtensions/Storage?style=flat-square&cacheSeconds=86400) HTML5 Storage API implementation for Microsoft Blazor.
* [Blazor-State](https://github.com/TimeWarpEngineering/blazor-state) - ![GitHub stars](https://img.shields.io/github/stars/TimeWarpEngineering/blazor-state?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/TimeWarpEngineering/blazor-state?style=flat-square&cacheSeconds=86400) Manage client side state in Blazor using MediatR pipeline.
* [bUnit - a testing library for Blazor components](https://github.com/egil/bunit) - ![GitHub stars](https://img.shields.io/github/stars/egil/bunit?style=flat-square&cacheSeconds=604800&logo=microsoft) ![last commit](https://img.shields.io/github/last-commit/egil/bunit?style=flat-square&cacheSeconds=86400) A testing library for Blazor Components. You can easily define components under test in C# or Razor syntax and verify outcome using semantic HTML diffing/comparison logic. You can easily interact with and inspect components, trigger event handlers, provide cascading values, inject services, mock IJsRuntime, and perform snapshot testing. 
* [Logging](https://github.com/BlazorExtensions/Logging) - ![GitHub stars](https://img.shields.io/github/stars/BlazorExtensions/Logging?style=flat-square&cacheSeconds=604800&logo=microsoft) ![last commit](https://img.shields.io/github/last-commit/BlazorExtensions/Logging?style=flat-square&cacheSeconds=86400) Microsoft Extension Logging implementation for Blazor.
* [BlazorStorage](https://github.com/cloudcrate/BlazorStorage) - ![GitHub stars](https://img.shields.io/github/stars/cloudcrate/BlazorStorage?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/cloudcrate/BlazorStorage?style=flat-square&cacheSeconds=86400) Local and session storage support for Blazor.
* [Blazor.Auth0](https://github.com/Pegazux/Blazor.Auth0) - ![GitHub stars](https://img.shields.io/github/stars/Pegazux/Blazor.Auth0?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/Pegazux/Blazor.Auth0?style=flat-square&cacheSeconds=86400) The library for using [Auth0](https://auth0.com/) in Blazor applications.
* [BlazorDB](https://github.com/chanan/BlazorDB) - ![GitHub stars](https://img.shields.io/github/stars/chanan/BlazorDB?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/chanan/BlazorDB?style=flat-square&cacheSeconds=86400) In-memory, persisted to local storage, database for Blazor.
* [TextCopy](https://github.com/CopyText/TextCopy) - ![GitHub stars](https://img.shields.io/github/stars/CopyText/TextCopy?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/CopyText/TextCopy?style=flat-square&cacheSeconds=86400) A cross platform package to copy text to and from the clipboard. [Supports Blazor](https://github.com/CopyText/TextCopy#blazor-webassembly) via the [Clipboard Browser API](https://developer.mozilla.org/en-US/docs/Web/API/Clipboard).
* [CssBuilder](https://github.com/EdCharbeneau/CssBuilder) - ![GitHub stars](https://img.shields.io/github/stars/EdCharbeneau/CssBuilder?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/EdCharbeneau/CssBuilder?style=flat-square&cacheSeconds=86400) CssBuilder is a Builder pattern for CSS classes to be used with Razor Components.
* [BlazorSignalR](https://github.com/csnewman/BlazorSignalR) - ![GitHub stars](https://img.shields.io/github/stars/csnewman/BlazorSignalR?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/csnewman/BlazorSignalR?style=flat-square&cacheSeconds=86400) SignalR Core .NET client library for Blazor. It uses the C# client.
* [Notifications](https://github.com/BlazorExtensions/Notifications) - ![GitHub stars](https://img.shields.io/github/stars/BlazorExtensions/Notifications?style=flat-square&cacheSeconds=604800&logo=microsoft) ![last commit](https://img.shields.io/github/last-commit/BlazorExtensions/Notifications?style=flat-square&cacheSeconds=86400) HTML5 Notifications API implementation for Microsoft Blazor.
* [Blazor.Polyfill](https://github.com/Daddoon/Blazor.Polyfill) - ![GitHub stars](https://img.shields.io/github/stars/Daddoon/Blazor.Polyfill?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/Daddoon/Blazor.Polyfill?style=flat-square&cacheSeconds=86400) Polyfills for Blazor (for Internet Explorer 11 support and some other browsers).
* [Blazor I18n/Localization Text](https://github.com/jsakamoto/Toolbelt.Blazor.I18nText) - ![GitHub stars](https://img.shields.io/github/stars/jsakamoto/Toolbelt.Blazor.I18nText?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/jsakamoto/Toolbelt.Blazor.I18nText?style=flat-square&cacheSeconds=86400) Localizing contents text in Blazor ([Demo](https://jsakamoto.github.io/Toolbelt.Blazor.I18nText/)).
* [Blazor.Geolocation](https://github.com/AspNetMonsters/Blazor.Geolocation) - ![GitHub stars](https://img.shields.io/github/stars/AspNetMonsters/Blazor.Geolocation?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/AspNetMonsters/Blazor.Geolocation?style=flat-square&cacheSeconds=86400) Blazor interop for browser Geolocation APIs.
* [Blazored.Localisation](https://github.com/Blazored/Localisation) - ![GitHub stars](https://img.shields.io/github/stars/Blazored/Localisation?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/Blazored/Localisation?style=flat-square&cacheSeconds=86400) A library to provide localisation in client-side Blazor applications.
* [EmbeddedBlazorContent](https://github.com/SamProf/EmbeddedBlazorContent) - ![GitHub stars](https://img.shields.io/github/stars/SamProf/EmbeddedBlazorContent?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/SamProf/EmbeddedBlazorContent?style=flat-square&cacheSeconds=86400) Library to load embedded content files (js and css) from Blazor libraries in server-side Blazor mode.
* [BlazorGoogleMaps](https://github.com/rungwiroon/BlazorGoogleMaps) - ![stars](https://img.shields.io/github/stars/rungwiroon/BlazorGoogleMaps?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/rungwiroon/BlazorGoogleMaps?style=flat-square&cacheSeconds=86400) Blazor interop for GoogleMap library.
* [Blazor.Payments](https://github.com/philipblaquiere/Blazor.Payments) - ![GitHub stars](https://img.shields.io/github/stars/philipblaquiere/Blazor.Payments?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/philipblaquiere/Blazor.Payments?style=flat-square&cacheSeconds=86400) Blazor Web Agent port of the Web Payment API standard developed by W3C.
* [Blazor SVG Helper](https://github.com/Lupusa87/BlazorSvgHelper) - ![stars](https://img.shields.io/github/stars/Lupusa87/BlazorSvgHelper?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/Lupusa87/BlazorSvgHelper?style=flat-square&cacheSeconds=86400) Create SVG elements with children (circle, rectangle, image, text, and others) and render with RenderTreeBuilder.
* [Cortex.Net](https://github.com/jspuij/Cortex.Net) - ![GitHub stars](https://img.shields.io/github/stars/jspuij/Cortex.Net?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/jspuij/Cortex.Net?style=flat-square&cacheSeconds=86400) State management like MobX for .NET and Blazor. [Documentation](https://jspuij.github.io/Cortex.Net.Docs/pages/index.html).
* [Blazor Analytics](https://github.com/isc30/blazor-analytics) - Blazor extensions for Analytics.
* [BlazorPrettyCode](https://github.com/chanan/BlazorPrettyCode) - Blazor Code Component for documentation sites. [Demo](https://chanan.github.io/BlazorPrettyCode/).
* [Blazor.EventAggregator](https://github.com/mikoskinen/Blazor.EventAggregator) - Lightweight Event Aggregator for Blazor (Razor Components).
* [Blazor Gamepad](https://github.com/jsakamoto/Toolbelt.Blazor.Gamepad) - Provides gamepad API access for Blazor.
* [Blazor Hotkeys](https://github.com/jsakamoto/Toolbelt.Blazor.Hotkeys) - A library to provide configuration-centric keyboard shortcuts for Blazor.
* [BlazorRealm](https://dworthen.github.io/BlazorRealm/docs/quickstart.html) - Redux state management for Blazor.
* [Blazor.LocalFiles](https://github.com/jburman/W8lessLabs.Blazor.LocalFiles) - Open files in your browser and load into Blazor.
* [Blazor.Sensors](https://github.com/AspNetMonsters/Blazor.Sensors) - Blazor interop for browser sensor APIs.
* [Rudder](https://github.com/kjeske/rudder) - Efficient state container for Blazor with concepts similar to the ones in redux, including reducers and sagas.
* [BlazorIntersectionObserver](https://github.com/ljbc1994/BlazorIntersectionObserver) - A Blazor wrapper for the Intersection Observer API.
* [Blazor.SpeechSynthesis](https://github.com/jsakamoto/Toolbelt.Blazor.SpeechSynthesis) - A library to provide Speech Synthesis API access for Blazor.
* [Blazor BarCode](https://barcoderesource.com/blazorbarcode.shtml) &ndash; A barcode library for Blazor using barcode fonts.
* [BlazorState.Redux](https://github.com/BerserkerDotNet/BlazorState.Redux) - Develop Blazor apps with Redux.
* [BlazorLeaflet](https://github.com/Mehigh17/BlazorLeaflet) - BlazorLeaflet is a wrapper offering easy-to-use Blazor components that expose the Leaflet API in C#.
* [Simple logging server](https://github.com/shawty/simpleloggingserver) - An ultra simple remote log message server written in Blazor and .NET Core 3.
* [Howler.Blazor](https://github.com/StefH/Howler.Blazor) - A Blazor JSInterop wrapper for Howler.js, an audio library.
* [DataJuggler.Blazor.FileUpload](https://github.com/DataJuggler/BlazorFileUpload) - Wrapper for Steve Sanderson's BlazorFileInput component.
* [Cortex.Net](https://github.com/jspuij/Cortex.Net) - State management like MobX for .NET and Blazor.
* [Blazor.LazyStyleSheet](https://github.com/excubo-ag/Blazor.LazyStyleSheet) - ![last commit](https://img.shields.io/github/last-commit/excubo-ag/Blazor.LazyStyleSheet?style=flat-square&cacheSeconds=86400) Lazy loading for CSS style sheets.
* [Blazor.ScriptInjection](https://github.com/excubo-ag/Blazor.ScriptInjection) - ![last commit](https://img.shields.io/github/last-commit/excubo-ag/Blazor.ScriptInjection?style=flat-square&cacheSeconds=86400) Smart script tags in Blazor components, ideal for lazy loading of javascript files.
* [DnetIndexedDb](https://github.com/amuste/DnetIndexedDb) - ![last commit](https://img.shields.io/github/last-commit/amuste/DnetIndexedDb?style=flat-square&cacheSeconds=86400) Blazor Library for IndexedDB DOM API.
* [PkcsExtensions.Blazor](https://github.com/harrison314/PkcsExtensions.Blazor) - ![last commit](https://img.shields.io/github/last-commit/harrison314/PkcsExtensions.Blazor?style=flat-square&cacheSeconds=86400) A library to provide crypto and digital signature functionality for Blazor WebAssembly and light WebCrypto interop.
### Others
* [Blazor Extensions Home](https://github.com/BlazorExtensions/Home) - ![GitHub stars](https://img.shields.io/github/stars/BlazorExtensions/Home?style=flat-square&cacheSeconds=604800&logo=microsoft) Home for Blazor Extensions.
* [Bolero](https://github.com/fsbolero/Bolero) - ![GitHub stars](https://img.shields.io/github/stars/fsbolero/Bolero?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/fsbolero/Bolero?style=flat-square&cacheSeconds=86400) Blazor for F# with hot reloaded templates, type-safe endpoints and routing, remoting, and much more.
* [BlazorMobile](https://github.com/Daddoon/BlazorMobile) - ![GitHub stars](https://img.shields.io/github/stars/Daddoon/BlazorMobile?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/Daddoon/BlazorMobile?style=flat-square&cacheSeconds=86400) Launch Blazor as a mobile application on iOS, Android & UWP.
* [NObservable](https://github.com/kekekeks/NObservable) - ![GitHub stars](https://img.shields.io/github/stars/kekekeks/NObservable?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/kekekeks/NObservable?style=flat-square&cacheSeconds=86400) MobX-like observables and component instrumentation.
* [BlazorFabric](https://github.com/limefrogyank/BlazorFabric) - ![GitHub stars](https://img.shields.io/github/stars/limefrogyank/BlazorFabric?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/limefrogyank/BlazorFabric?style=flat-square&cacheSeconds=86400) Blazor port of Microsoft UI Fabric with fluent design. ([Demo](https://blazorfabric.azurewebsites.net/)).
* [Blazor-Dashboard](https://github.com/Misfits-Rebels-Outcasts/Blazor-Dashboard) - ![GitHub stars](https://img.shields.io/github/stars/Misfits-Rebels-Outcasts/Blazor-Dashboard?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/Misfits-Rebels-Outcasts/Blazor-Dashboard?style=flat-square&cacheSeconds=86400) Admin Dashboard Template Theme for Blazor.
* [BlazorEmbedLibrary](https://github.com/SQL-MisterMagoo/BlazorEmbedLibrary) - ![GitHub stars](https://img.shields.io/github/stars/SQL-MisterMagoo/BlazorEmbedLibrary?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/SQL-MisterMagoo/BlazorEmbedLibrary?style=flat-square&cacheSeconds=86400) Provides Blazor-style embedded static content files for Razor Components projects.
* [BlazorWebView](https://github.com/jspuij/BlazorWebView) - ![GitHub stars](https://img.shields.io/github/stars/jspuij/BlazorWebView?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/jspuij/BlazorWebView?style=flat-square&cacheSeconds=86400) Blazor WebView control for WPF, Android, macOS, iOS. Run Blazor on .NET Core and Mono natively inside a Webview. [Documentation](https://jspuij.github.io/BlazorWebView.Docs/pages/index.html).
* [WebSocketHelper](https://github.com/Lupusa87/BlazorWebSocketHelper) - ![stars](https://img.shields.io/github/stars/Lupusa87/BlazorWebSocketHelper?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/Lupusa87/BlazorWebSocketHelper?style=flat-square&cacheSeconds=86400) Helper for Web Socket in Blazor.
* [BlazorLazyLoading](https://github.com/isc30/blazor-lazy-loading) - ![GitHub stars](https://img.shields.io/github/stars/isc30/blazor-lazy-loading?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/isc30/blazor-lazy-loading?style=flat-square&cacheSeconds=86400) Production ready lazy loading implementation. Full lazy loading support for WASM and Server (pages, components, dlls) with abstractions to implement modularization if you wish (custom endpoints, custom manifests, etc).
* [BlazorLazyLoad](https://github.com/MarekPokornyOva/BlazorLazyLoad) - ![stars](https://img.shields.io/github/stars/MarekPokornyOva/BlazorLazyLoad?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/MarekPokornyOva/BlazorLazyLoad?style=flat-square&cacheSeconds=86400) BlazorLazyLoad is a implementation of assembly lazy load feature in Blazor WASM application on both page and component level.
* [SpotifyService](https://github.com/tresoneur/SpotifyService) - ![stars](https://img.shields.io/github/stars/tresoneur/SpotifyService?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/tresoneur/SpotifyService?style=flat-square&cacheSeconds=86000) A high-level Spotify API library for Blazor WebAssembly projects that enables Spotify playback in the browser, manages OAuth 2.0 authorization, provides easy access to the Spotify Web API and uses IndexedDB caching.
* [Bionic](https://bionicframework.github.io/Documentation/) - An Ionic CLI clone for Blazor projects.
* [BlazorFileSaver](https://github.com/IvanJosipovic/BlazorFileSaver) - Blazor Component wrapper for FileSaver.js ([Demo](https://blazorfilesaver.netlify.com)).
* [Blazor.DynamicJavascriptRuntime.Evaluator](https://github.com/jameschch/Blazor.DynamicJavascriptRuntime.Evaluator) - Execute dynamic object expressions as Javascript in Blazor client-side apps.
* [Blazor.AdaptiveCards](https://github.com/mikoskinen/Blazor.AdaptiveCards) - Adaptive Cards for Blazor. [Documentation](https://adaptivecardsblazor.com/).

## Videos
* [Blazor WebAssembly 3.2 Release Party!](https://www.youtube.com/watch?v=onI2_Q0wrdM&list=PL1rZQsJPBU2St9-Mz1Kaa7rofciyrwWVx&index=0) - ![duration](https://img.shields.io/badge/Duration:%20-84%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=microsoft) May 26, 2020 - ASP.NET Community Standup - Blazor WebAssembly 3.2 Release Party!
* [Modern Web UI with Blazor WebAssembly](https://channel9.msdn.com/Events/Build/2020/BOD104) - ![duration](https://img.shields.io/badge/Duration:%20-45%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=microsoft) May 19, 2020 - Modern web development is here with Blazor! Be productive building beautiful interactive UI with .NET and C# that runs on any device via WebAssembly. PWAs, authentication, debugging and more. Video by Steve Sanderson from Microsoft.
* [Blazor WASM authentication](https://www.twitch.tv/videos/614895872) - ![duration](https://img.shields.io/badge/Duration:%20-99%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=twitch) May 8, 2020 - Blazor WASM authentication, by Ed Charbeneau.
* [Blazor Tutorial : Deploy to Azure App Services](https://www.youtube.com/watch?v=CFAE4_dwzAs&feature=youtu.be) - May 5, 2020 - Blazor Tutorial : Deploy to Azure App Services, by Curious Drive.
* [Blazor StateHasChanged: E-book samples, code-behind, and office hours](https://www.twitch.tv/videos/608126510) - May 1, 2020 - Blazor StateHasChanged: E-book samples, code-behind, and office hours.
* [Trains.NET - Lets pretend to be designers](https://www.twitch.tv/videos/599185198) - April 22, 2020 - Building a 2D game with .NET and C#, let's draw things with Blazor. [Trains.NET's Source code](https://github.com/davidwengier/Trains.NET).
* [Trains.NET - From SkiaSharp to HTML Canvas, and hopefully published to a website somewhere](https://www.twitch.tv/videos/592596855) - April 15, 2020 - Building a 2D game with .NET and C#, let's draw things with Blazor. [Trains.NET's Source code](https://github.com/davidwengier/Trains.NET).
* [Trains.NET - Let's draw things with Blazor](https://www.twitch.tv/videos/588019981) - April 10, 2020 - Building a 2D game with .NET and C#, let's draw things with Blazor. [Trains.NET's Source code](https://github.com/davidwengier/Trains.NET).
* [Trains.NET - Experimenting with Blazor](https://www.twitch.tv/videos/586349468) - April 8, 2020 - Building a 2D game with .NET and C#, experimenting with Blazor. [Trains.NET's Source code](https://github.com/davidwengier/Trains.NET).
* [Carl Franklin's Blazor Desk Show with Dan Roth](https://www.youtube.com/watch?v=xxIkh6GZdaM) - ![duration](https://img.shields.io/badge/Duration:%20-121%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) March 26, 2020 - Video of Carl Franklin (from .NET Rocks!) about architecture best practices, how to make and consume generic components, how to call JavaScript to enhance your apps, and how to implement authentication and authorization. This video also covers how to monitor the traffic going back and forth between the browser and the server, measure your app's memory footprint, and how to optimize it. It also introduces some exciting Blazor controls including a data grid and appointment scheduling component.
* [Quarantined Coding! with Ed Charbeneau](https://www.twitch.tv/videos/575953710) - March 26, 2020 - Ed Charbeneau about Blazor for CodeItLive.
* [Create a Blazor Server App and Add Syncfusion Blazor Components](https://www.youtube.com/watch?v=cQZYzOlTm0Q) - March 24, 2020 - Learn to create a new Blazor Server App and add Blazor Components of Syncfusion to it using Visual Studio 2019 and Visual Studio Code.
* [Minimal March - Linux and Blazor. PRs, Finishing the FormView, C#, HTML, and !coffee](https://www.twitch.tv/videos/572751843) - March 22, 2020 - Minimal March - Linux and Blazor. PRs, Finishing the FormView, C#, HTML, and !coffee, by Csharpfritz.
* [Blazor StateHasChanged: Hot take on hot questions](https://www.twitch.tv/videos/571259404) - March 20, 2020 - Blazor StateHasChanged: Hot take on hot questions, by Ed Charbeneau.
* [Minimal March - Linux and Blazor. PRs, Finishing the FormView, C#, HTML, and !coffee](https://www.twitch.tv/videos/571161098) - March 20, 2020 - Minimal March - Linux and Blazor. PRs, Finishing the FormView, C#, HTML, and !coffee, by Csharpfritz.
* [Minimal March - Linux and Blazor. PRs, Finishing the FormView, C#, HTML, and !coffee](https://www.twitch.tv/videos/570365905) - March 19, 2020 - Minimal March - Linux and Blazor. PRs, Finishing the FormView, C#, HTML, and !coffee, by Csharpfritz.
* [Minimal March - Linux and Blazor. PRs, Finishing the FormView, C#, HTML, and !coffee](https://www.twitch.tv/videos/569662576) - March 18, 2020 - Minimal March - Linux and Blazor. PRs, Finishing the FormView, C#, HTML, and !coffee, by Csharpfritz.
* [Building Chat App using Blazor WebAssembly](https://www.twitch.tv/curiousdrive/clip/BashfulSpeedyPuddingHeyGirl) - March 6, 2020 - Building Chat App using Blazor WebAssembly, day 10 by Curious Drive.
* [Blazor Tutorial : Event Handling](https://www.youtube.com/watch?v=wxU6wWTT4mQ&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-12%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) March 4, 2020 - Episode about event handling by Curious Drive.
* [Build your first Blazor app with Carl Franklin](https://www.youtube.com/watch?v=hAB4fHy6Cfo&feature=youtu.be) - ![duration](https://img.shields.io/badge/Duration:%20-71%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) March 3, 2020 - Build your first Blazor app with Carl Franklin, by DevExpress.
* [Blazor, GitHub CLI, Excel? and more](https://www.twitch.tv/videos/557921454) - ![duration](https://img.shields.io/badge/Duration:%20-106%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=twitch) February 26, 2020 - Blazor, GitHub CLI, Excel? and more by Michael Crump on Twitch.
* [Ed Charbeneau talks about Blazor components on CsharpFritz](https://www.twitch.tv/videos/544128754) - ![duration](https://img.shields.io/badge/Duration:%20-152%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) February 25, 2020 - Ed Charbeneau talks about Blazor components contributes BlazorComponentUtilities to our project.
* [Deep Dive on Server-Side Blazor](https://www.youtube.com/watch?v=JrA1cv5jvFA) - ![duration](https://img.shields.io/badge/Duration:%20-60%20min-%230094FF?style=flat-square&cacheSeconds=maxAge&logo=youtube) February 24, 2020 - Talk by Carl Franklin at the NDC London, "Deep Dive on Server-Side Blazor". Blazor has arrived on the server with .NET Core 3. In this demo-filled session, Carl shows you how you can integrate authentication, data access with Entity Framework Core, API endpoints, File Uploads, and SignalR to create a great experience for your users.
* [Deploying Blazor WebAssembly Backend](https://www.twitch.tv/videos/555713221) - February 21, 2020 - Deploying Blazor WebAssembly Backend, on Twitch.
* [Blazor Tutorial : Templated Components | Html Table](https://www.youtube.com/watch?v=BBFF2l1FlE0&feature=youtu.be) - February 20, 2020 - Blazor Tutorial : Templated Components | Html Table by CuriousDrive. [Source code](https://github.com/CuriousDrive/BookStores). 
* [Is Blazor the new Silverlight?](https://www.youtube.com/watch?v=s9Nkry1l5Tg&feature=youtu.be) - February 19, 2020 - Very short video (2min) by Carl Franklin from the [Blazor Road Show](http://www.blazorroadshow.com) who speaks about "Is Blazor the new Silverlight?".
* [Blazor Tutorial : Procedural Logic | Authentication & Authorization in C#](https://www.youtube.com/watch?v=EdnrUGmECS4&feature=youtu.be) - February 18, 2020 - Blazor Tutorial : Procedural Logic | Authentication & Authorization in C#, by Curious Drive. [Source code](https://github.com/CuriousDrive/BookStores).
* [Open Source C#, Blazor, and the DataBinder](https://www.twitch.tv/videos/552921602) - February 16, 2020 - Open Source C#, Blazor, and the DataBinder, by Jeffrey Fritz. [BlazorWebFormsComponents](https://github.com/FritzAndFriends/BlazorWebFormsComponents).
* [Coding with Squirrel - and Blazor !coffee](https://www.twitch.tv/videos/551829522) - February 14, 2020 - Coding with Squirrel, and Blazor !coffee, by Jeffrey Fritz. [BlazorWebFormsComponents](https://github.com/FritzAndFriends/BlazorWebFormsComponents).
* [Blazor TreeView GridLines and starting the FormView component](https://www.twitch.tv/videos/551327880) - February 13, 2020 - Blazor TreeView GridLines and starting the FormView component, by Jeffrey Fritz.
* [Blazor TreeView images and checkboxes](https://www.twitch.tv/videos/550829401) - February 12, 2020 - Blazor TreeView images and checkboxes, by Jeffrey Fritz. [BlazorWebFormsComponents](https://github.com/FritzAndFriends/BlazorWebFormsComponents).
* [How To Create a Blazor Component](https://www.youtube.com/watch?v=ijIjg2XAVK8) - February 11, 2020 - This video covers how to create a Blazor component for a Blazor application. Create a template and write C# code to connect the component with the application.
* [Ed Charbeneau of Progress: Why I'm Excited About Blazor in 2020](https://www.youtube.com/watch?v=rAiBaedDWpY) - February 10, 2020 - Ed Charbeneau of Progress talks about the technologies he's excited to learn more about in 2020 including Blazor.
* [Blazor Tutorial: Role-based Authorization](https://www.youtube.com/watch?v=rk5uIA6s574&feature=youtu.be) - February 7, 2020 - Blazor Tutorial: Role-based Authorization. [Source code](https://github.com/CuriousDrive/BookStores).
* [Blazor Tutorial: Register User & Generate JWT](https://www.youtube.com/watch?v=kGbdWtxFhRI) - February 5, 2020 - Blazor Tutorial : Register User & Generate JWT.
* [Live from Stockholm - Pages, JavaScript, C# and Blazor components](https://www.twitch.tv/videos/546707126) - February 4, 2020 - Live from Stockholm - Pages, JavaScript, C# and Blazor components, by Jeffrey Fritz.
* [Live from Stockholm - MasterPages, Layouts, Blazor components and your pull-requests](https://www.twitch.tv/videos/545753950) - February 2, 2020 - Live from Stockholm - MasterPages, Layouts, Blazor components and your pull-requests, by Jeffrey Fritz.
* [Build modern data-driven Web Apps with Microsoft Blazor and Dapper](https://www.youtube.com/watch?v=W9xUUk_H_Ng) - February 2, 2020 - Build modern data-driven Web Apps with Microsoft Blazor and Dapper.
* [Blazor, a new framework for browser-based .NET apps](https://www.youtube.com/watch?v=Khn7sDUSEJM&feature=youtu.be) - January 29, 2020 - "Blazor, a new framework for browser-based .NET apps" session by Steve Sanderson at the [NDC London 2020](https://ndc-london.com/talk/blazor-a-new-framework-for-browser-based-net-apps-1/).
* [Blazor in more depth](https://www.youtube.com/watch?v=QnBYmTpugz0) - January 28, 2020 - Blazor in more depth by Steve Sanderson and Ryan Nowak at the [NDC London 2020](https://ndc-london.com/talk/blazor-in-more-depth/).
* [How to use BlazorStyled with Blazor to dynamically change CSS](https://youtu.be/frtetHgfdIo) - January 22, 2029 - I show how to install BlazorStyled for SSB and how I built a ProgressBar and Sprite Component to do simple animaitons.
* [Blazor Tutorial : HttpClient | Login User](https://www.youtube.com/watch?v=X6cBnOhaYhk&feature=youtu.be) - January 21, 2020 - This video covers how we can use HttpClient in your Blazor app to make API calls to login user into the system. [Source code](https://github.com/CuriousDrive/BlazorApp).
* [Let's add some auth to Blazor](https://www.twitch.tv/videos/533986300) - January 17, 2020 - Let's add some auth to Blazor, on Twitch.
* [Blazor Means Business](https://www.youtube.com/watch?v=0CS2xat4dBg) - January 16, 2020 - "Blazor Means Business" by Paul Schroeder at the Chicago .NET User Group.
* [Microsoft, Google and Cookie Authentication and Authorization](https://www.youtube.com/watch?v=v2OsI7qJdoc) - January 15, 2020 - This video by Microsoft covers how you can use authentication and authorization within your Blazor application.
* [Adding content management using Kentico Kontent](https://www.youtube.com/watch?v=DqdiYXg8gRs) - January 15, 2020 - Adding content management using Kentico Kontent to a Blazor app.
* [.NET Conf session: Blazor for Web Form and C# Developers](https://channel9.msdn.com/Events/dotnetConf/Focus-on-Blazor/Blazor-for-Web-Form-and-C-Developers) - January 14, 2020 - "Blazor for Web Form and C# Developers" by Jeff Fritz, session of the .NET Conf "Focus on Blazor". This session covers how you can use Blazor within your Web Form applications.
* [.NET Conf session: Build Serverless Apps with Blazor](https://channel9.msdn.com/Events/dotnetConf/Focus-on-Blazor/Build-Serverless-Apps-with-Blazor) - January 14, 2020 - "Build Serverless Apps with Blazor" by Daria Grigoriu and Fabio Cavalcante, session of the .NET Conf "Focus on Blazor". This session covers how you can build serverless Blazor applications.
* [.NET Conf session: Scaling Blazor Server Apps with Azure](https://channel9.msdn.com/Events/dotnetConf/Focus-on-Blazor/Scaling-Blazor-Server-Apps-with-Azure) - January 14, 2020 - "Scaling Blazor Server Apps with Azure" by Ryan Nowak, session of the .NET Conf "Focus on Blazor". This session covers how you can scale your Blazor applications with Azure.
* [.NET Conf session: Microsoft, Google and Cookie Authentication and Authorization](https://channel9.msdn.com/Events/dotnetConf/Focus-on-Blazor/Microsoft-Google-and-Cookie-Authentication-and-Authorization) - January 14, 2020 - "Microsoft, Google and Cookie Authentication and Authorization" by Michael Washington, session of the .NET Conf "Focus on Blazor". This session covers how you can use authentication and authorization within your Blazor application.
* [.NET Conf session: Authoring Custom Components](https://channel9.msdn.com/Events/dotnetConf/Focus-on-Blazor/Authoring-Custom-Components) - January 14, 2020 - "Authoring Custom Components" by Ed Charbeneau, session of the .NET Conf "Focus on Blazor". This session covers how you can create custom Blazor components.
* [.NET Conf session: Mobile Blazor Bindings - Using Blazor to build mobile apps](https://channel9.msdn.com/Events/dotnetConf/Focus-on-Blazor/Mobile-Blazor-Bindings-Using-Blazor-to-build-mobile-apps) - January 14, 2020 - "Mobile Blazor Bindings - Using Blazor to build mobile apps" by Eilon Lipton, session of the .NET Conf "Focus on Blazor". This session covers how you can use Blazor to build great mobile applications.
* [.NET Conf session: Testing Blazor Components](https://channel9.msdn.com/Events/dotnetConf/Focus-on-Blazor/Testing-Blazor-Components) - January 14, 2020 - "Testing Blazor Components" by Egil Hansen, session of the .NET Conf "Focus on Blazor". This session covers different ways to test the Blazor components.
* [.NET Conf session: JavaScript Two-Way Interop](https://channel9.msdn.com/Events/dotnetConf/Focus-on-Blazor/JavaScript-Two-Way-Interop) - January 14, 2020 - "JavaScript Two-Way Interop" by Javier Calvarro Nelson, session of the .NET Conf "Focus on Blazor". This session covers cover how you can use custom JavaScript within your Blazor components.
* [.NET Conf session: State Management in Blazor Apps](https://channel9.msdn.com/Events/dotnetConf/Focus-on-Blazor/State-Management-in-Blazor-Apps) - January 14, 2020 - "State Management in Blazor Apps" by Jeremy Likness, session of the .NET Conf "Focus on Blazor". This session covers how you can enable statement management within your Blazor applications.
* [.NET Conf session: Create a great UX with Blazor](https://channel9.msdn.com/Events/dotnetConf/Focus-on-Blazor/Create-a-great-UX-with-Blazor) - January 14, 2020 - "Create a great UX with Blazor" by Jimmy Engstrom, session of the .NET Conf "Focus on Blazor". This session covers how we can create a great UX flow with Blazor.
* [.NET Conf session: Routing A-Z](https://channel9.msdn.com/Events/dotnetConf/Focus-on-Blazor/Routing-A-Z) - January 14, 2020 - "Routing A-Z" by Chris Sainty, session of the .NET Conf "Focus on Blazor". This session covers how routing works within Blazor and its components.
* [.NET Conf session: Welcome to Blazor](https://channel9.msdn.com/Events/dotnetConf/Focus-on-Blazor/Welcome-to-Blazor) - January 14, 2020 - "Welcome to Blazor" by Dan Roth, session of the .NET Conf "Focus on Blazor".
* [.NET Conf "Focus on Blazor"](https://www.youtube.com/watch?v=fgneZz-4Foc) - Video of the complete event. 8 hours of great information about Blazor, enjoy!
* [.NET Conf: Focus on Blazor Teaser](https://channel9.msdn.com/Shows/Visual-Studio-Toolbox/NET-Conf-Focus-on-Blazor-Teaser) - January 9, 2020 - In this episode, Robert is joined by Daniel Roth, who provides a look at the upcoming (Tuesday January 14) .NET Conf: Focus on Blazor. This is a free, one-day livestream event that features speakers from the community and .NET product teams that are working on building web apps with C# and Blazor. He also gives a nice overview of Blazor.
* [Create new Blazor CRUD application with Radzen](https://www.youtube.com/watch?v=rTVspBBuAz4) - January 7, 2020 - How to create new Blazor CRUD application from Microsoft SQL Server database using Radzen.
* [Blazor Forms with Validation - Part IV](https://www.youtube.com/watch?v=SzlsRdV5z_8) - January 1, 2020 - This video will show you how to include a radio button, checkbox, and select/dropdown in a blazor form.  There are a couple of options when working with the select and this video takes you through them.
* [Blazor Forms with Validation - Part III](https://www.youtube.com/watch?v=fAwba0bpiSs) - January 1, 2020 - This video shows you how to add validation messages at the field level instead of or in addition to at the form level.
* [Archives](https://github.com/AdrienTorris/awesome-blazor/tree/master/Archives) - [2019](https://github.com/AdrienTorris/awesome-blazor/blob/master/Archives/2019.md#videos), [2018](https://github.com/AdrienTorris/awesome-blazor/blob/master/Archives/2018.md#videos), [2017](https://github.com/AdrienTorris/awesome-blazor/blob/master/Archives/2017.md#videos).

## Articles
* [The best samples to teach yourself Blazor](https://medium.com/young-coder/the-best-samples-to-teach-yourself-blazor-4d29cec607f5) - May 27, 2020 - The best samples to teach yourself Blazor. Now that Microsoft’s C#-in-a-browser platform is an official release, it’s safe to dig in.
* [Announcing Experimental Mobile Blazor Bindings May update](https://devblogs.microsoft.com/aspnet/announcing-experimental-mobile-blazor-bindings-may-update/) - May 26, 2020 - Announcing Experimental Mobile Blazor Bindings May update.
* [Blazor news from Build 2020](https://chrissainty.com/blazor-news-from-build-2020/) - May 26, 2020 - Blazor news from Build 2020.
* [Azure AD Secured Serverless Cosmos DB from Blazor WebAssembly](https://blog.jeremylikness.com/blog/azure-ad-secured-serverless-cosmosdb-from-blazor-webassembly) - May 25, 2020 - Azure AD Secured Serverless Cosmos DB from Blazor WebAssembly, an authentic look at static sites with dynamic attitudes.
* [Realtime update with Blazor Wasm Signalr and Mediatr](https://remibou.github.io/Realtime-update-with-Blazor-WASM-SignalR-and-MediatR/) - May 24, 2020 - Realtime update with Blazor Wasm Signalr and Mediatr.
* [How to create Blazor components with custom JavaScript and CSS in the components library and properly consume them from WebAssembly application](https://romansimuta.com/posts/how-to-create-blazor-components-with-custom-javascript-and-css-in-the-components-library-and-properly-consume-them-from-webassembly-application/) - May 24, 2020 - How to create Blazor components with custom JavaScript and CSS in the components library and properly consume them from WebAssembly application.
* [Next for Blazor: AOT for 'Massive Speed Gains'](https://visualstudiomagazine.com/articles/2020/05/22/blazor-future.aspx) - May 23, 2020 - Next for Blazor: AOT for 'Massive Speed Gains', from Visual Studio Magazine.
* [Microsoft Build 2020 – Highlights](https://csharp.christiannagel.com/2020/05/21/build2020/) - May 21, 2020 - This Microsoft Build 2020 conference was very different from all the previous ones as a digital experience event because of the COVID-19 Coronavirus. Microsoft made it a great experience – with announcements on Microsoft Azure, .NET 5, Windows, and more.
* [Hosting Blazor WebAssembly in Azure Static Web Apps (Preview)](https://timheuer.com/blog/hosting-blazor-in-azure-static-web-apps/) - May 19, 2020 - Hosting Blazor WebAssembly in Azure Static Web Apps (Preview).
* [Blazor WebAssembly 3.2.0 now available](https://devblogs.microsoft.com/aspnet/blazor-webassembly-3-2-0-now-available/) - May 19, 2020 - Blazor WebAssembly 3.2.0 now available.
* [Using three.js with ASP.NET Core Blazor Server application](https://romansimuta.com/posts/using-three-js-with-asp-net-core-blazor-server-application/) - May 19, 2020 - Using three.js with ASP.NET Core Blazor Server application. [Source code](https://github.com/simutaroman/Blazor3D) ![last commit](https://img.shields.io/github/last-commit/simutaroman/Blazor3D?style=flat-square&cacheSeconds=86400).
* [Blazor finally complete as WebAssembly joins server-side component](https://visualstudiomagazine.com/articles/2020/05/19/blazor-webassembly-3-2.aspx) - May 19, 2020 - Blazor finally complete as WebAssembly joins server-side component.
* [EF Core and Cosmos DB with Blazor WebAssembly](https://blog.jeremylikness.com/blog/ef-core-and-cosmosdb-with-blazor-webassembly) - May 14, 2020 - EF Core and Cosmos DB with Blazor WebAssembly.
* [Blazor interview questions and answer](https://tutorialslink.com/Articles/Blazor-Interview-Questions-and-Answer/1413) - May 14, 2020 - Blazor interview questions and answer.
* [Building a Progressive Web App with Blazor](https://devblogs.microsoft.com/visualstudio/building-a-progressive-web-app-with-blazor/) - May 13, 2020 - Building a Progressive Web App with Blazor.
* [Telerik UI for Blazor: 40+ Native Components with Telerik R2 2020 Release](https://www.telerik.com/blogs/telerik-ui-for-blazor-40-native-components-telerik-r2-2020-release) - May 13, 2020 - Telerik UI for Blazor: 40+ Native Components with Telerik R2 2020 Release.
* [Unit Testing Blazor Components with bUnit and JustMock](https://www.telerik.com/blogs/unit-testing-blazor-components-bunit-justmock) - May 11, 2020 - Unit Testing Blazor Components with bUnit and JustMock.
* [Auto saving form data in Blazor](https://chrissainty.com/auto-saving-form-data-in-blazor/) - May 5, 2020 - Auto saving form data in Blazor.
* [Attach Blazor to Azure IoT Edge routing, showing live message feed](https://sandervandevelde.wordpress.com/2020/05/03/attach-blazor-to-azure-iot-edge-routing-showing-live-message-feed/) - May 3, 2020 - Attach Blazor to Azure IoT Edge routing, showing live message feed.
* [Blazor WebAssembly 3.2.0 Release Candidate now available](https://devblogs.microsoft.com/aspnet/blazor-webassembly-3-2-0-release-candidate-now-available) - April 30, 2020 - Blazor WebAssembly 3.2.0 Release Candidate now available. The Blazor WebAssembly Release Candidate is here! This release contains all of the features and improvements that we expect to release for the upcoming Blazor WebAssembly release. There are no more breaking changes planned at this point.
* [Quickly transform any mockup or design into a working Blazor prototype](https://jonhilton.net/build-anything-using-blazor-components/) - April 29, 2020 - Quickly transform any mockup or design into a working Blazor prototype.
* [Copy to Clipboard in Blazor](https://chrissainty.com/copy-to-clipboard-in-blazor/) - April 29, 2020 - Copy to Clipboard in Blazor.
* [Stripe customer credit card payment with Blazor](https://wellsb.com/csharp/aspnet/stripe-customer-credit-card-payment-with-blazor/) - April 27, 2020 - In the [previous tutorial](https://wellsb.com/csharp/aspnet/stripe-connect-express-and-blazor/), you learned how to link a Stripe Connect account with a local user store in a Blazor application. If, instead, you need a way to collect payment information from your customers, this tutorial will help you understand the Stripe customer flow. [Source code](https://github.com/bradwellsb/blazor-stripe).
* [Blazor WebAssembly 3.2.0 Preview 5 release now available](https://devblogs.microsoft.com/aspnet/blazor-webassembly-3-2-0-preview-5-release-now-available/) - April 23, 2020 - Blazor WebAssembly 3.2.0 Preview 5 release now available.
* [CSS is hard, Blazor and Tailwind CSS makes it easier](https://jonhilton.net/re-usable-components-with-blazor-and-tailwind-css/) - April 22, 2020 - CSS is hard, Blazor and Tailwind CSS makes it easier.
* [Telerik UI for Blazor 2.11.0](https://www.telerik.com/blogs/telerik-ui-for-blazor-2-11-0-grid-features-scheduler-improvements-wasm-3-2-0-preview-4-more) - April 22, 2020 - Telerik UI for Blazor 2.11.0: New Grid Features, Scheduler Improvements, Wasm 3.2.0 Preview 4 and More.
* [Mobile Blazor Bindings - Navigation and Xamarin Essentials](https://chrissainty.com/mobile-blazor-bindings-xamarin-essentials/) - April 21, 2020 - Mobile Blazor Bindings - Navigation and Xamarin Essentials.
* [Playing audio files in a Blazor application](http://www.appvnext.com/blog/2020/4/20/playing-audio-files-in-a-blazor-application) - April 20, 2020 - Playing audio files in a Blazor application.
* [Stripe Connect Express and Blazor](https://wellsb.com/csharp/aspnet/stripe-connect-express-and-blazor/) - April 20, 2020 - Stripe Connect Express and Blazor. [Source code](https://github.com/bradwellsb/blazor-stripe).
* [Blazor WebAssembly 3.2.0 Preview 4 release now available](https://devblogs.microsoft.com/aspnet/blazor-webassembly-3-2-0-preview-4-release-now-available/) - April 16, 2020 - Blazor WebAssembly 3.2.0 Preview 4 release now available.
* [Debugging problems persist in Blazor WebAssembly 3.2 Preview 4](https://visualstudiomagazine.com/articles/2020/04/16/blazor-preview-4.aspx) - April 16, 2020 - Debugging problems persist in Blazor WebAssembly 3.2 Preview 4.
* [Mobile Blazor Bindings - State Management and Data](https://chrissainty.com/mobile-blazor-bindings-state-management-and-data/) - April 14, 2020 - Mobile Blazor Bindings - State Management and Data.
* [Stripe.NET Create Stripe Webhooks Receiver](https://wellsb.com/csharp/aspnet/stripe-net-create-stripe-webhooks-receiver/) - April 13, 2020 - Stripe.NET Create Stripe Webhooks Receiver.
* [Blazor: Handling 404s with IIS](https://medium.com/@jonny.ollifflee/blazor-handling-404s-with-iis-666920a4a60) - April 9, 2020 - Blazor: Handling 404s with IIS.
* [Top 3 Blazor Extensions for Visual Studio Code](https://visualstudiomagazine.com/articles/2020/04/08/vs-code-blazor.aspx) - April 8, 2020 - Some developers prefer to create applications with Microsoft's open-source Blazor tooling from within the open-source, cross-platform Visual Studio Code editor. Here are the top tools in the VS Code Marketplace for those folk, as measured by the number of installations.
* [Mobile Blazor Bindings - Layout and Styling](https://chrissainty.com/mobile-blazor-bindings-layout-and-styling/) - April 7, 2020 - Second post in the series: Mobile Blazor Bindings for Web Developers by Chris Sainty.
* [Securing Blazor WebAssembly with Identity Server 4](https://levelup.gitconnected.com/securing-blazor-webassembly-with-identity-server-4-ee44aa1687ef) - April 6, 2020 - Securing Blazor WebAssembly with Identity Server 4.
* [Mobile Blazor Bindings - Getting Started](https://chrissainty.com/getting-started-with-mobile-blazor-bindings/) - April 1, 2020 - Introduction by Chris Sainty to the Mobile Blazor Bindings (MBB) project, what it is, why you might be interesting in trying it, what is and isn't available and we'll finish with creating our first app.
* [Routing in Blazor Apps](https://devblogs.microsoft.com/premier-developer/routing-in-blazor-apps/) - March 30, 2020 - In this post, App Dev Manager Billy Sun compares routing of popular web frameworks and Blazor.
* [Updating JSON Validate to Blazor 3.2.0 Preview 3](https://dev.to/marcusturewicz/updating-json-validate-to-blazor-3-2-0-preview-3-59oa) - March 29, 2020 - Updating JSON Validate to Blazor 3.2.0 Preview 3.
* [Blazor WebAssembly Marches On to GA: Now Debug from Visual Studio, VS Code](https://visualstudiomagazine.com/articles/2020/03/27/blazor-debugging.aspx) - March 27, 2020 - Blazor WebAssembly Marches On to GA: Now Debug from Visual Studio, VS Code, on Visual Studio Magazine.
* [Blazor WebAssembly 3.2.0 Preview 3 release now available](https://devblogs.microsoft.com/aspnet/blazor-webassembly-3-2-0-preview-3-release-now-available/) - March 26, 2020 - Official post from Microsoft, by Dan Roth. Blazor WebAssembly 3.2.0 Preview 3 release now available.
* [Adventures with Blazor: my first component, a busy button](http://www.mattruma.com/adventures-with-blazor-my-first-component-a-busy-button/) - March 26, 2020 - Adventures with Blazor: my first component, a busy button.
* [Mocking Injected Types in Blazor](https://magenic.com/thinking/mocking-injected-types-in-blazor) - March 26, 2020 - Mocking Injected Types in Blazor.
* [Working with Query Strings in Blazor](https://chrissainty.com/working-with-query-strings-in-blazor/) - March 25, 2020 - This post covers how to deal with Query Strings in Blazor.
* [Why you should use Blazor over JavaScript Frameworks](https://www.telerik.com/blogs/why-you-should-use-blazor-over-javascript-frameworks-to-build-your-single-page-application) - March 24, 2020 - Why you should use Blazor over JavaScript Frameworks to build your single-page application.
* [Replacing AJAX calls in Razor Pages with Razor Components and Blazor](https://andrewlock.net/replacing-ajax-calls-in-razor-pages-using-razor-components-and-blazor/) - March 24, 2020 - Replacing AJAX calls in Razor Pages with Razor Components and Blazor.
* [Introduction to .NET 5 for ASP.NET Developers](http://www.binaryintellect.net/articles/567c6c06-a2aa-44da-a443-78dafedebe65.aspx) - March 23, 2020 - Introduction to .NET 5 for ASP.NET Developers.
* [How To Keep Js Object Reference In Blazor](https://remibou.github.io/How-to-keep-js-object-reference-in-Blazor/) - March 21, 2020 - How to keep Javascript object reference in Blazor on .NET side?
* [Using Highcharts with Blazor](http://engstromjimmy.se/post/2020-03-21-UsingHighchartsWithBlazor) - March 21, 2020 - Using Highcharts with Blazor.
* [CSS live reloading on Blazor](https://dev.to/j_sakamoto/css-live-reloading-on-blazor-27nc) - March 20, 2020 - CSS live reloading on Blazor.
* [Unifying .NET 5 arrives in Preview 1](https://visualstudiomagazine.com/articles/2020/03/17/net-5-preview.aspx) - March 17, 2020 - Microsoft released .NET 5 Preview 1, the first iteration of what will become one framework to handle all .NET development projects.
* [Blazor - Reload the browser on disconnect](http://engstromjimmy.se/post/2020-03-14-ReloadBlazor%20-%20Copy) - March 14, 2020 - Blazor - Reload the browser on disconnect.
* [The Open Source Project that Wants to Reboot Silverlight](https://medium.com/young-coder/the-open-source-project-that-wants-to-reboot-silverlight-74817b430ee7) - March 13, 2020 - OpenSilver uses impressive tech to run Microsoft’s stone-dead app platform, Silverlight.
* [Blazor WebAssembly 3.2.0 Preview 2 release now available](https://devblogs.microsoft.com/aspnet/blazor-webassembly-3-2-0-preview-2-release-now-available/) - March 11, 2020 - Blazor WebAssembly 3.2.0 Preview 2 release now available, by Daniel Roth from Microsoft.
* [Blazor WebAssembly tackles progressive web apps](https://visualstudiomagazine.com/articles/2020/03/11/blazor-pwa.aspx) - March 11, 2020 - Blazor WebAssembly tackles progressive web apps, by David Ramel for Visual Studio Magazine.
* [New Blazor and CSLA .NET Book](https://blog.lhotka.net/2020/03/11/New-Blazor-and-CSLA-Book) - March 11, 2020 - New Blazor and CSLA .NET Book. [Link to buy it](https://store.lhotka.net/using-csla-5-blazor-and-webassembly).
* [Blazor Shopping Cart Sample using Local Storage to Persist State](http://www.appvnext.com/blog/2020/3/7/blazor-shopping-cart-sample-using-local-storage-to-persist-state) - March 10, 2020 - Blazor Shopping Cart Sample using Local Storage to Persist State, by Carl Franklin.
* [Open Source Silverlight replacement powered by WebAssembly debuts](https://visualstudiomagazine.com/articles/2020/03/09/opensilver.aspx) - March 9, 2020 - Open Source Silverlight replacement powered by WebAssembly debuts.
* [Event Aggregator for Blazor updated to 2.0.0](https://mikaelkoskinen.net/post/blazor-eventaggregator-2-0-0-auto-refresh) - March 8, 2020 - Event Aggregator for Blazor updated to 2.0.0.
* [Blazor WASM Debugging Planned for Visual Studio](https://visualstudiomagazine.com/articles/2020/03/03/vs-roadmap.aspx?m=1) - March 3, 2020 - Blazor WASM Debugging Planned for Visual Studio, on Visual Studio Magazine.
* [Integrating Tailwind CSS with Blazor using Gulp - Part 2](https://chrissainty.com/integrating-tailwind-css-with-blazor-using-gulp-part-2/) - March 3, 2020 - Integrating Tailwind CSS with Blazor using Gulp - Part 2.
* [What's the Difference Between Blazor vs Razor](https://www.telerik.com/blogs/difference-between-blazor-vs-razor) - March 2, 2020 - What is Razor? How does it relate to Blazor, and which should you be using? Learn the difference between Blazor and Razor and how to use them in your web applications.
* [Re-Using Angular Components In A Blazor WebAssembly Application Using Angular Elements](https://www.thinktecture.com/en/blazor/integration-angular-elements-web-components) - March 2, 2020 - Re-Using Angular Components In A Blazor WebAssembly Application Using Angular Elements - Web Components Custom Elements.
* [How to send callback method to JSInterop in Blazor?](https://remibou.github.io/How-to-send-callback-to-JS-Interop-in-Blazor/) - February 29, 2020 - How to send callback method to JSInterop in Blazor?
* [Yet another way to changing the page title in Blazor, and more](https://dev.to/j_sakamoto/yet-another-way-to-changing-the-page-title-in-blazor-and-more-43k) - February 2020, 27 - Yet another way to changing the page title in Blazor, and more.
* [GitHub Project Provides 300-Plus Samples of ASP.NET Core/Blazor Fundamentals](https://visualstudiomagazine.com/articles/2020/02/27/aspnet-core-fundamentals.aspx) - February 27, 2020 - A GitHub project providing more than 300 code samples to illustrate ASP.NET Core fundamentals has amassed more than 4,100 stars.
* [What’s behind the hype about Blazor?](https://stackoverflow.blog/2020/02/26/whats-behind-the-hype-about-blazor/) - February 26, 2020 - Blazor is a new client-side UI framework from the ASP.NET team. Its big selling point is the ability to write rich web UI experiences using HTML, CSS, and C# instead of JavaScript—something a lot of developers have been dreaming of. By Chris Sainty.
* [Use Blazor and C# to host a static website in Azure Storage](https://dev.to/azure/use-blazor-and-c-to-host-a-static-website-in-azure-storage-b1d) - February 24, 2020 - Use Blazor and C# to host a static website in Azure Storage by Michael Crump.
* [From WebForms to Blazor?](https://jonhilton.net/migrate-webforms-to-blazor/) - February 24, 2020 - From WebForms to Blazor?.
* [Blazor live reload preview](https://medium.com/@MartinPocius/blazor-live-reload-preview-4505015fd589) - February 23, 2020 - In react we have hot module replacement this feature allows us to change code and see changes immediately in your browser. We can make a similar feature in blazor using Roslyn compiler. Compiling down razor components in runtime and serving with WebSockets on every file change using file watcher. [Source code](https://github.com/martasp/BlazorLiveReload).
* [TeeChart for .NET with Razor and Blazor under Net.Core 3](http://steema.com/wp/blog/2020/02/20/teechart-for-net-with-razor-and-blazor-under-net-core-3/) - February 20, 2020 - TeeChart for .NET with Razor and Blazor under Net.Core 3.
* [Hundreds of practical ASP.NET Core samples to learn the fundamentals](https://www.hanselman.com/blog/HundredsOfPracticalASPNETCoreSamplesToLearnTheFundamentals.aspx) - February 19, 2020 - Hundreds of practical ASP.NET Core samples to learn the fundamentals, and there are great samples about Blazor.
* [Is Blazor For Everyone?](http://www.appvnext.com/blog/2020/2/18/is-blazor-for-everyone) - February 18, 2020 - Is Blazor For Everyone?, by Carl Franklin.
* [Hosting a Blazor App in WinUI 3 with WebView2 and call a Blazor Component Method from WinUI](https://www.thomasclaudiushuber.com/2020/02/18/hosting-blazor-app-in-winui-3-with-webview-2-and-call-blazor-component-method-from-winui/) - February 18, 2020 - Hosting a Blazor App in WinUI 3 with WebView2 and call a Blazor Component Method from WinUI.
* [Running Your ASP.NET Core Blazor WebAssembly Application As A Progressive Web App (PWA)](https://www.thinktecture.com/en/blazor/progressive-web-apps-pwa) - February 18, 2020 - Running Your ASP.NET Core Blazor WebAssembly Application As A Progressive Web App (PWA).
* [Integrating Tailwind CSS with Blazor using Gulp - Part 1](https://chrissainty.com/integrating-tailwind-css-with-blazor-using-gulp-part-1/) - February 18, 2020 - Integrating Tailwind CSS with Blazor using Gulp - Part 1.
* [Dashboard for Blazor - How to use Web Dashboard within your Blazor Apps](https://community.devexpress.com/blogs/analytics/archive/2020/02/17/dashboard-for-blazor-how-to-use-web-dashboard-within-your-blazor-apps.aspx) - February 17, 2020 - Dashboard for Blazor - How to use Web Dashboard within your Blazor Apps, by DevExpress. This post covers how to integrate the [HTML JavaScript Dashboard](https://docs.devexpress.com/Dashboard/119108/designer-and-viewer-applications/web-dashboard/html-javascript-dashboard-control) into a Blazor applications and focus on integration details and create a sample dashboard application as well.
* [Creating a multi-language translator using Blazor and Azure Cognitive Services](https://www.c-sharpcorner.com/article/creating-a-multi-language-translator-using-blazor-and-azure-cognitive-services/) - February 17, 2020 - Creating a multi-language translator using Blazor and Azure Cognitive Services.
* [Initializing Web Components in Blazor via JS Interop](https://www.thomasclaudiushuber.com/2020/02/14/initializing-web-components-in-blazor-via-js-interop/) - February 14, 2020 - Initializing Web Components in Blazor via JS Interop. [Source code](https://github.com/thomasclaudiushuber/Blazor-Using-Custom-Web-Component).
* [Blazor WebAssembly Rest Client](https://christianfindlay.com/2020/02/14/blazor-webassembly-rest-client/) - February 14, 2020 - This article focuses on client-side rendering and explains how to use [RestClient.Net](https://github.com/MelbourneDeveloper/RestClient.Net) to make calls to a RESTful API. [Source code](https://github.com/MelbourneDeveloper/RestClient.Net/tree/master/RestClient.Net.Samples.Blazor).
* [Mono: From Xamarin to WebAssembly, Blazor, and .NET 5 - Q&A with Miguel de Icaza](https://www.infoq.com/articles/mono-xamarin-webassembly-net5/) - February 13, 2020 - Mono: From Xamarin to WebAssembly, Blazor, and .NET 5 - Q&A with Miguel de Icaza.
* [Profiling in Blazor](https://remibou.github.io/Profiling-in-Blazor/) - February 12, 2020 - How to profile a production Blazor client-side app?
* [Microsoft Blazor Enables Native App Development in C# and .NET](https://www.semaphore-software.com/blog/microsoft-blazor-enables-native-app-development-in-c-and-net/) - February 12, 2020 - Microsoft Blazor Enables Native App Development in C# and .NET.
* [Rider 2019.3.2 is available](https://blog.jetbrains.com/dotnet/2020/02/12/rider-2019-3-2/) - February 12, 2020 - Rider 2019.3.2 by JetBrains is available, with improved Blazor support.
* [Tinkering with client-side Blazor and the AWS SDK for .NET](https://matteo.tech.blog/2020/02/11/tinkering-with-client-side-blazor-and-the-aws-sdk-for-net/amp/) - February 11, 2020 - Tinkering with client-side Blazor and the AWS SDK for .NET.
* [Why Blazor, via WebAssembly, is the future](https://www.linkedin.com/pulse/why-blazor-via-webassembly-future-akash-limbani/) - February 11, 2020 - Why Blazor, via WebAssembly, is the future.
* [Announcing Experimental Mobile Blazor Bindings February update](https://devblogs.microsoft.com/aspnet/mobile-blazor-bindings-feb-2020-update/) - February 10, 2020 - Announcing Experimental Mobile Blazor Bindings February update.
* [Experimental Mobile Blazor Bindings gets new components](https://visualstudiomagazine.com/articles/2020/02/10/blazor-mobile-update.aspx) - February 10, 2020 - Experimental Mobile Blazor Bindings gets new components.
* [Blazor by Example - A spot of refactoring](https://jonhilton.net/blazor-traffic-light-refactor/) - February 10, 2020 - Blazor by Example - A spot of refactoring. [Source code](https://github.com/jonhilt/BlazorExamples/).
* [Multi-Language Translator Using Blazor And Azure Cognitive Services](https://ankitsharmablogs.com/multi-language-translator-using-blazor-and-azure-cognitive-services/) - February 10, 2020 - Multi-Language Translator Using Blazor And Azure Cognitive Services.
* [Mobile Blazor Bindings – Getting Started + Why You Should Care](https://www.dylanberry.com/2020/02/05/mobile-blazor-bindings-getting-started-why-you-should-care/) - February 5, 2020 - Mobile Blazor Bindings – Getting Started + Why You Should Care.
* [Fragment Routing with Blazor](https://chrissainty.com/fragment-routing-with-blazor/) - February 4, 2020 - Fragment routing, or linking, is the term given when linking to a specific element on a page, say a header for example. This technique is often used in FAQ pages or technical documentation and links using this technique look like this, www.mysite.com/faq#some-header. This post covers how to do this with Blazor.
* [Blazor WebAssembly, Monaco and Antlr – Building the AutoStep Editor as a Blazor App](https://alistairevans.co.uk/2020/02/03/blazor-webassembly-monaco-and-antlr-building-the-autostep-editor-as-a-blazor-app/) - February 3, 2020 - Blazor WebAssembly, Monaco and Antlr – Building the AutoStep Editor as a Blazor App.
* [Blazor by Example - Build a simple traffic light](https://jonhilton.net/blazor-traffic-light/) - February 3, 2020 - Blazor by Example - Build a simple traffic light. [Source code](https://github.com/jonhilt/BlazorExamples/tree/0c620bd5183086c03bc1820d2331e6894099100b).
* [Intro to Blazor and Creating a Blazor App from Scratch](https://www.roundthecode.com/dotnet/intro-to-blazor-and-creating-a-blazor-app-from-scratch) - February 3, 2020 - Intro to Blazor and Creating a Blazor App from Scratch. [Source code](https://github.com/RoundTheCode/RoundTheCode.Blazor/releases/tag/CreateBlazor).
* [Reuse Blazor WASM UI in Blazor Server](http://www.appvnext.com/blog/2020/2/2/reuse-blazor-wasm-ui-in-blazor-server) - February 2, 2020 - Reuse Blazor WASM UI in Blazor Server using a technique showed by Steve Sanderson at the NDC London.
* [Containerizing Blazor Apps](https://www.pluralsight.com/tech-blog/containerizing-blazor-apps/) - January 31, 2020 - Containerizing Blazor Apps.
* [Building experimental hybrid Blazor WebAssembly application](https://gunnarpeipman.com/blazor-hybrid-application-experimental/) - January 30, 2020 - Building experimental hybrid Blazor WebAssembly application, by Gunnar Peipman.
* [Telerik UI for Blazor 2.7.0](https://www.telerik.com/blogs/telerik-ui-for-blazor-270-multiselect-grid-webassembly-more) - January 30, 2020 - Telerik UI for Blazor 2.7.0 - MultiSelect, New Grid Features, WebAssembly Support and More.
* [Microsoft Blazor to become mainstream in 2020](https://jaxenter.com/blazor-2020-167525.html) - January 29, 2020 - Microsoft Blazor to become mainstream in 2020.
* [What's New in Third-Party Blazor Tooling](https://visualstudiomagazine.com/articles/2020/01/29/blazor-tooling.aspx) - January 29, 2020 - What's New in Third-Party Blazor Tooling.
* [Exploring WebWindow examples for Blazor on desktop](https://gunnarpeipman.com/blazor-on-desktop-webwindow-experiment) - January 29, 2020 - Exploring WebWindow examples for Blazor on desktop.
* [Test Your Jsinterop Code With Cypress](https://remibou.github.io/Test-your-JSInterop-code-with-cypress/) - January 29, 2020 - Test your JSInterop code with cypress.io.
* [Blazor WebAssembly 3.2.0 Preview 1 release now available](https://devblogs.microsoft.com/aspnet/blazor-webassembly-3-2-0-preview-1-release-now-available/) - January 28, 2020 - Blazor WebAssembly 3.2.0 Preview 1 release now available.
* [How to implement plug-in on C# Blazor for native JavaScript application](https://www.c-sharpcorner.com/article/how-to-implement-plug-in-on-c-sharp-blazor-for-native-javascript-application-open-ap/) - January 28, 2020 - How to implement plug-in on C# Blazor for native JavaScript application. Open API Scheme Diagram For Draw.io.
* [Blazor by Example - Build a simple markdown editor](https://jonhilton.net/blazor-markdown-editor/) - January 27, 2020 - Blazor by Example - Build a simple markdown editor.
* [Suppressing Events in Blazor and ASP.NET Core Version 3.1](https://visualstudiomagazine.com/articles/2020/01/27/suppressing-events-blazor.aspx) - January 27, 2020 - ASP.NET Core Version 3.1 adds some new features for managing events in Blazor. You may think you'll never need them, but there may be a time when you'll be glad to know about at least one of them.
* [Getting Started with Blazor Server Apps in Visual Studio for Mac](https://devblogs.microsoft.com/visualstudio/getting-started-with-blazor-server-apps-in-visual-studio-for-mac/) - January 22, 2020 - Getting Started with Blazor Server Apps in Visual Studio for Mac.
* [Blazor's Future: gRPC Is Key](https://visualstudiomagazine.com/articles/2020/01/17/blazor-future.aspx) - January 21, 2020 - Blazor's Future: gRPC Is Key, by the Visual Studio Magazine.
* [Embedding Power BI in Blazor](http://blazorhelpwebsite.com/Blog/tabid/61/EntryId/4373/Embedding-Power-BI-in-Blazor.aspx) - January 21, 2020 - You can embed Power BI reports into a Server Side Blazor Application. This method allows you to display a Power BI report without requiring the user to have a Power BI account.
* [Avoiding Parking Fines with Blazor and Geolocation](https://dev.to/ondrabus/avoiding-parking-fines-with-blazor-and-geolocation-572o) - January 20, 2020 - Avoiding Parking Fines with Blazor and Geolocation. [Source code](https://github.com/ondrabus/dont-park-here-client).
* [6 Blazor component libraries to speed up your development](https://jonhilton.net/blazor-component-libraries/) - January 20, 2020 - 6 Blazor component libraries to speed up your development.
* [Using NSwag to Generate Blazor Server Client for an ASP.NET Core 3.1 API](https://elanderson.net/2020/01/using-nswag-to-generate-blazor-server-client-for-an-asp-net-core-3-1-api/) - January 19, 2020 - Using NSwag to Generate Blazor Server Client for an ASP.NET Core 3.1 API.
* [The Future of Blazor is Native Apps](https://medium.com/young-coder/the-future-of-blazor-is-native-apps-9f4a510acdd5) - January 18, 2020 - Microsoft imagines a future where Blazor runs on desktop and mobile — without WebAssembly.
* [Should I Peek Blazor?](https://remibou.github.io/Should-I-peek-Blazor/) - January 16, 2020 - Should I Peek Blazor?
* [Web developers: Microsoft Blazor lets you build native iOS, Android apps in C#, .NET](https://www.zdnet.com/article/web-developers-microsoft-blazor-lets-you-build-native-ios-android-apps-in-c-net/) - January 16, 2020 - Microsoft offers a new tool for building native iOS and Android apps in programming language C# and .NET.
* [Using gRPC-Web with Blazor WebAssembly](https://blog.stevensanderson.com/2020/01/15/2020-01-15-grpc-web-in-blazor-webassembly/) - January 15, 2020 - gRPC-Web is a convenient, high-performance alternative to JSON-over-HTTP for single-page applications, by Steve Sanderson.
* [Announcements from .NET Conf: Focus on Blazor](https://gunnarpeipman.com/focus-on-blazor-announcements/) - January 15, 2019 - Announcements from .NET Conf: Focus on Blazor.
* [Announcing Experimental Mobile Blazor Bindings](https://devblogs.microsoft.com/aspnet/mobile-blazor-bindings-experiment/) - January 14, 2020 - Announcing Experimental Mobile Blazor Bindings.
* [Blazor State Management](https://blog.jeremylikness.com/blog/blazor-state-management) - January 14, 2020 - Blazor State Management, don't forget to add memory to your Blazor apps.
* [Blazor Azure AD B2C Custom URL](https://wellsb.com/csharp/aspnet/blazor-azure-ad-b2c-custom-url/) - January 13, 2020 - Blazor Azure AD B2C Custom URL.
* [OData API, EF Core, and Blazor](https://wellsb.com/csharp/aspnet/odata-api-ef-core-blazor/) - January 7, 2020 - Learn how to configure an OData API, integrate it with Entity Framework Core, and call the API from a server-side Blazor front-end targeting .NET Core 3.1.
* [Integrating Blazor Components into Existing Asp.Net Core MVC Applications](https://medium.com/@waelkdouh/integrating-blazor-components-into-existing-asp-net-core-mvc-applications-b1a2aec4ac1f) - January 7, 2020 - Integrating Blazor Components into Existing Asp.Net Core MVC Applications.
* [What’s Old is New Again – Web Forms meets Blazor](https://jeffreyfritz.com/2020/01/whats-old-is-new-again-web-forms-meets-blazor/) - January 6, 2020 - What’s Old is New Again – Web Forms meets Blazor.
* [Re-Using Angular components in a Blazor WebAssembly application using Angular Elements](https://www.thinktecture.com/blazor/integrations/angular-elements-web-components/) - January 2, 2020 - Re-Using Angular components in a Blazor WebAssembly application using Angular Elements - Web Components custom elements, FTW!
* [Display spinner on each API call automatically in Blazor](https://bipinpaul.com/posts/display-spinner-on-each-api-call-automatically-in-blazor) - January 2, 2020 - Display spinner on each API call automatically in Blazor. [Source code here](https://github.com/iAmBipinPaul/BlazorDisplaySpinnerAutomatically).
* [gRPC With Blazor, C# And .Net Core](https://www.c-sharpcorner.com/article/grpc-with-c-sharp-net-core-calling-grpc-service-with-blazor-server-side-applicati/) - January 2, 2020 - gRPC With Blazor, C# And .Net Core.
* [Archives](https://github.com/AdrienTorris/awesome-blazor/tree/master/Archives) - [2019](https://github.com/AdrienTorris/awesome-blazor/blob/master/Archives/2019.md#articles), [2018](https://github.com/AdrienTorris/awesome-blazor/blob/master/Archives/2018.md#articles), [2017](https://github.com/AdrienTorris/awesome-blazor/blob/master/Archives/2017.md#articles).
  
## Podcasts
* [Michael Washington on the State of Blazor](http://azuredevopspodcast.clear-measure.com/michael-washington-on-the-state-of-blazor-episode-88) - May 11, 2020 - In this episode of Azure DevOps Podcast, Jeffrey Palermo is speaking with Michael Washington about Blazor in-depth. They discuss the current state of Blazor; Oqtane, a modular application framework for Blazor; server-side Blazor apps; Radzen, a low-code, RAD solution; his books on the topic of Blazor; and his advice, tips, recommendations, and resources for Blazor as well.
* [Blazor with guest Carl Franklin](https://weeklydevtips.com/episodes/blazor-with-guest-carl-franklin) - March 9, 2020 - Carl Franklin is the guest to Weekly Dev Tips. Carl Franklin and Steve Smith (aka Ardalis) discuss Blazor in general and look at how to create a generic object picker control for Blazor.
* [Podcast: Occam’s Blazor](https://stackoverflow.blog/2020/01/14/podcast-occams-blazor/) - January 14, 2020 - Podcast by Stack Overflow.
* [.NET Core 3 Launch with Scott Hunter](https://www.dotnetrocks.com/?show=1654) - September 26, 2019 - .NET Rocks Podcast, episode 1654: .NET Core 3 Launch with Scott Hunter.
* [Moving from Web Forms to Blazor with Jeff Fritz](https://www.dotnetrocks.com/default.aspx?ShowNum=1652) - September 12, 2019 - .NET Rocks Podcast, episode 1652: Moving from Web Forms to Blazor with Jeff Fritz.
* [Blazor with Daniel Roth](https://devchat.tv/adventures-in-dotnet/net-003-blazor-with-daniel-roth/) - September 03, 2019 - Daniel Roth starts by introducing Web Assembly and how this changed web development. Blazor allows full-stack development through .NET with C#. The panel asks Dan about Blazor's capabilities and future. Dan shares Blazor’s origin story.
* [What is WebAssembly](https://cynicaldeveloper.com/podcast/122/) - September 02, 2019 - What is WebAssembly, episode 122 of the Cynical Developer podcast.
* [Building Applications using Server-Side Blazor with Shaun Walker](https://www.dotnetrocks.com/default.aspx?ShowNum=1649) - August 22, 2019 - .NET Rocks! podcast, episode 1649: Building Applications using Server-Side Blazor with Shaun Walker.
* [Daniel Roth on Blazor](http://azuredevopspodcast.clear-measure.com/daniel-roth-on-blazor-devops-episode-47) - July 29, 2019 - Azure DevOps Podcast, Episode 47: Daniel Roth on Blazor DevOps. 
* [Blazor with Ed Charbeneau](http://codingafterwork.se/2019/07/17/episode-43-blazor-with-ed-charbeneau/) - July 17, 2019 - Coding After Work podcast, Episode 43 – Blazor with Ed Charbeneau.
* [MS Dev Show - Blazor with Ed Charbeneau](https://msdevshow.com/2019/06/blazor-with-ed-charbeneau/) - June 24, 2019 - MS Dev Show - Blazor with Ed Charbeneau.
* [.NET Core Show Podcast, Episode 27 - Blazored with Chris Sainty](https://dotnetcore.show/episode-27-blazroed-with-chris-sainty/) - June 14, 2019 - .NET Core Show Podcast, Episode 27 - Blazored with Chris Sainty.
* [Blazor with Ed Charbeneau](https://6figuredev.com/podcast/episode-095-blazor-with-ed-charbeneau/) - June 10, 2018 - The 6 Figure Developer Podcast, Episode 095 – Blazor with Ed Charbeneau.
* [Blazor - You Want To Run .NET Where?!](https://dotnetcore.show/episode-25-blazor-you-want-to-run-net-where/) - May 17, 2019 - .NET Core Show - Episode 25 - Blazor - You Want To Run .NET Where?!
* [The Cynical Developer - Blazor](https://cynicaldeveloper.com/podcast/108) - February 18, 2019 - Episode 108 of The Cynical Developer - Blazor.
* [Blazor in 2019 with Steve Sanderson and Dan Roth](https://player.fm/series/net-rocks-2353294/blazor-in-2019-with-steve-sanderson-and-dan-roth) - February 14, 2019 - .NET Rocks, Blazor in 2019 with Steve Sanderson and Dan Roth.
* [Archives](https://github.com/AdrienTorris/awesome-blazor/tree/master/Archives) - [2018](https://github.com/AdrienTorris/awesome-blazor/blob/master/Archives/2018.md#podcasts), [2017](https://github.com/AdrienTorris/awesome-blazor/blob/master/Archives/2017.md#podcasts).

## Presentations slides
* [Blazor, a new framework for browser-based .NET apps](https://github.com/SteveSandersonMS/presentation-2020-01-NDCLondon) - January 29, 2020 - Source code of the session by Steve Sanderson at the NDC London, "Blazor, a new framework for browser-based .NET apps".
* [Blazor in more depth](https://github.com/SteveSandersonMS/presentation-2020-01-NdcBlazorComponentLibraries) - January 28, 2020 - Blazor in more depth by Steve Sanderson and Ryan Nowak at the NDC London 2020. [Presentation of Steve Sanderson](https://github.com/SteveSandersonMS/presentation-2020-01-NdcBlazorComponentLibraries). [Presentation of Ryan Nowak](https://github.com/rynowak/Presentations/tree/master/2020/NDCLondon/blazor).
* [Authoring custom components - .NET Conf "Focus on Blazor"](https://github.com/EdCharbeneau/DotnetConfBlazor) - January 14, 2020 - Slides and demo of the presentation by Ed Charbeneau at the .NET Conf "Focus on Blazor".
* [Routing A-Z - .NET Conf "Focus on Blazor"](https://github.com/chrissainty/Talks-DotNetConf-01-2020) - January 14, 2020 - Slides and demo of the presentation by Chris Sainty at the .NET Conf "Focus on Blazor" about routing.
* [Blazor, a new framework for browser-based .NET apps](https://github.com/SteveSandersonMS/presentation-2019-06-NDCOslo) - ![GitHub stars](https://img.shields.io/github/stars/SteveSandersonMS/presentation-2019-06-NDCOslo?style=flat-square&cacheSeconds=604800) June 20, 2019 - Blazor, a new framework for browser-based .NET apps, by Steve Sanderson at the NDC Oslo.
* [Hidden gems in ASP.Core and .NET Core 3.0](https://speakerdeck.com/davidfowl/hidden-gems-in-asp-dot-core-and-net-core-3-dot-0) - June 19, 2019 - Hidden gems in ASP.Core and .NET Core 3.0, by David Fowler and Damian Edwards at the NDC Oslo.
* [Meet the production-ready Blazor aka Razor Components](https://codecamp.ro/timisoaraSpring) - May 25, 2019 - Slides: [PPTX](https://codecampro.blob.core.windows.net/sessions-upload/1306-CCBlazor.pptx).
* [Iowa .NET User Group – Blazor: C# Running in the Browser via WebAssembly](https://scottsauber.com/2019/05/02/iowa-net-user-group-blazor-c-running-in-the-browser-via-webassembly/) - May 2, 2019 - Slides: [PDF](https://scottsauber.files.wordpress.com/2019/05/blazor.pdf) or [PPTX](https://scottsauber.files.wordpress.com/2019/05/blazor.pptx). Code: [Blazor ToDoMVC](https://github.com/scottsauber/BlazorToDoMVC) ![GitHub stars](https://img.shields.io/github/stars/scottsauber/BlazorToDoMVC?style=flat-square&cacheSeconds=604800) and [Blazor on Electron](https://github.com/SteveSandersonMS/BlazorElectronExperiment.Sample) ![GitHub stars](https://img.shields.io/github/stars/SteveSandersonMS/BlazorElectronExperiment.Sample?style=flat-square&cacheSeconds=604800).
* [WebAssembly, C#, and Blazor at CodeStock 2019](https://blog.jeremylikness.com/presentation-webassembly-c-and-blazor-at-codestock-2019-ab2f8636356) - April 16, 2019 - Slides: [PDF](https://jlikme.blob.core.windows.net/presentations/ATaleOfShortLinks.pdf). Demo's source code: [GitHub](https://github.com/JeremyLikness/blazor-wasm) ![GitHub stars](https://img.shields.io/github/stars/JeremyLikness/blazor-wasm?style=flat-square&cacheSeconds=604800).
* [Archives](https://github.com/AdrienTorris/awesome-blazor/tree/master/Archives) - [2018](https://github.com/AdrienTorris/awesome-blazor/blob/master/Archives/2018.md#presentations-slides).

## Tooling
* [Blazor Dev Server with CSS Live Reloader](https://github.com/jsakamoto/Toolbelt.Blazor.DevServer.WithCssLiveReloader) - ![GitHub stars](https://img.shields.io/github/stars/jsakamoto/Toolbelt.Blazor.DevServer.WithCssLiveReloader?style=flat-square&cacheSeconds=604800) ![GitHub last commit](https://img.shields.io/github/last-commit/jsakamoto/Toolbelt.Blazor.DevServer.WithCssLiveReloader?style=flat-square&cacheSeconds=86000) Alternative Blazor Dev Server to be available CSS live reloading.
* [BlazorFiddle](https://blazorfiddle.com) - Blazor .Net Developer Playground and Code Editor in the Browser.
* [Blazor Minimum Project Templates](https://github.com/jsakamoto/BlazorMinimumTemplates) - ![GitHub stars](https://img.shields.io/github/stars/jsakamoto/BlazorMinimumTemplates?style=flat-square&cacheSeconds=604800) ![GitHub last commit](https://img.shields.io/github/last-commit/jsakamoto/BlazorMinimumTemplates?style=flat-square&cacheSeconds=86000) A project templates package of Blazor apps without JavaScript and CSS libraries.
* [Blazor Snippets Visual Studio Code extension](https://marketplace.visualstudio.com/items?itemName=ScottSauber.blazorsnippets) - A Visual Studio Code extension that offers Blazor and Razor snippets.
* [BlazorSourceMangler](https://github.com/Lupusa87/BlazorSourceMangler) - ![GitHub stars](https://img.shields.io/github/stars/Lupusa87/BlazorSourceMangler?style=flat-square&cacheSeconds=604800) ![GitHub last commit](https://img.shields.io/github/last-commit/Lupusa87/BlazorSourceMangler?style=flat-square&cacheSeconds=86000) A console app to mangle Blazor DLLs. Check this [YouTube video](https://www.youtube.com/watch?v=nlXax81b1UE) for more details. You can also check this [Blazor TODO app](https://lupblazortodo.z20.web.core.windows.net/) to see result of this app (downloaded blazortodos.dll is mangled and decompilation shows uglyfied code).
* [.NET Core](https://www.microsoft.com/net/download/dotnet-core) - .NET Core.
* [Razor+ Visual Studio Code extension](https://marketplace.visualstudio.com/items?itemName=austincummings.razor-plus) - A Visual Studio Code extension that offers improved Razor support.
* [Visual Studio](https://www.visualstudio.com/vs/preview) - Latest preview of Visual Studio.
* [Visual Studio Code](https://code.visualstudio.com/) - Visual Studio Code, free, open source and cross-platform code editor.

## Books
* [Blazor Revealed](https://www.apress.com/gp/book/9781484243428) - Blazor Revealed, Building Web Applications in .NET(Published February, 2019).
* [Blazor Quick Start Guide: Build web applications using Blazor, EF Core, and SQL Server](https://www.amazon.in/gp/product/178934414X/ref=awesome_blazor) - Blazor Quick Start Guide: Build web applications using Blazor, EF Core, and SQL Server (Published October 31, 2018).

## E-Books
* [Blazor Succinctly](https://www.syncfusion.com/ebooks/blazor-succinctly) - April 16, 2020 - A free e-book for starting with the Blazor framework.
* [Blazor, A Beginners Guide](https://www.telerik.com/campaigns/blazor/wp-beginners-guide-ebook) - March 18, 2020 - A free e-book for getting started with the Blazor framework. [Examples source code](https://github.com/EdCharbeneau/BlazorBookExamples).
* [Blazor for ASP.NET Web Forms developers](https://dotnet.microsoft.com/learn/aspnet/architecture#blazor-for-web-forms-devs-ebook-swim) - Blazor for ASP.NET Web Forms developers, a free e-book from Microsoft.
* [Using CSLA 5: Blazor and WebAssembly](https://store.lhotka.net/using-csla-5-blazor-and-webassembly) - This book covers the new Blazor UI framework, including how to create server-side and client-side WebAssembly projects, how to implement authentication and authorization, and how to use data binding. It then covers how CSLA .NET supports Blazor, including walking through a complete sample app.
* [An Introduction to Building Applications with Blazor](https://www.amazon.com/Introduction-Building-Applications-Blazor-applications-ebook/dp/B07WPQTT6H) - August 24, 2019 - An Introduction to Building Applications with Blazor: How to get started creating applications using this exciting easy to use Microsoft C# framework
* [Archives](https://github.com/AdrienTorris/awesome-blazor/tree/master/Archives) - [2018](https://github.com/AdrienTorris/awesome-blazor/blob/master/Archives/2018.md#e-books).

## Courses
* [Programming in Blazor - ASP.NET Core 3.1](https://www.udemy.com/course/programming-in-blazor-aspnet-core) - Create interactive web applications with C#, on Udemy.
* [Creating Blazor Components](https://www.pluralsight.com/courses/creating-blazor-components) - December, 2019 - Building a Blazor app is building components. This course is essential for gaining a good understanding of components. On Pluralsight.
* [Authentication and Authorization in Blazor Applications](https://www.pluralsight.com/courses/authentication-authorization-blazor-applications) - December, 2019 - Learn how to secure your Blazor application using a variety of best practice techniques for authentication and authorization. On Pluralsight.
* [Blazor: Getting Started](https://www.pluralsight.com/courses/getting-started-blazor) - December, 2019 - Learn how to build your first application in a hands-on way using Blazor, Microsoft's solution to use C# to write interactive web UIs without JavaScript. On Pluralsight.
* [Blazor In-Depth Workshop (Blaze Invaders)](https://www.csharpacademy.com/courseinfo/2ccff0ac-4d3e-4d25-9368-6c1474640de5) - December 2019 - Blazor In-Depth Workshop (Blaze Invaders), on C# Academy. Learn serious Blazor concepts while building a working browser based game.
* [Blazor and Razor Components in a nutshell](https://www.udemy.com/course/blazor-and-razor-components-in-a-nutshell/) - October 2019 - Learn how to use a framework that allows you to run your compiled code directly in the browser on top of WebAssembly, a course on Udemy.
* [Blazor on ASP.NET Core 3.0](https://www.skillshare.com/site/join?teacherRef=102575464&t=Blazor-on-ASP.NET-Core-3.0&sku=1662883580) - October 2019 - Blazor on ASP.NET Core 3.0, a course on SkillShare.
* [Blazor First Look on LinkedIn Learning](https://www.linkedin.com/learning/blazor-first-look) - Blazor First Look on LinkedIn Learning. [Source code](https://github.com/Dedac/Beam) ![GitHub stars](https://img.shields.io/github/stars/Dedac/Beam?style=flat-square&cacheSeconds=604800).
* [Free Blazor Training Course](https://www.devexpress.com/support/training/blazor/) - DevExpress Blazor free training course [Source code](https://github.com/DevExpress/blazor-training-samples) ![GitHub stars](https://img.shields.io/github/stars/DevExpress/blazor-training-samples?style=flat-square&cacheSeconds=604800).
  
## Community
* [Awesome Blazor on Twitter](https://twitter.com/awesomeblazor) - This repository's Twitter feed.
* [Gitter](https://gitter.im/aspnet/Blazor) - Blazor discussion on Gitter.
* [Learn Blazor](https://learn-blazor.com/) - Community documentation on Blazor.
* [LightSwitch Help Website](https://lightswitchhelpwebsite.com/Blog/tabid/61/tagid/66/Blazor.aspx) - Blogs and code samples primarily covering server-side Blazor (Razor Components).
* [Practical samples of Blazor](https://github.com/dodyg/practical-aspnetcore/tree/master/projects/blazor) - Practical samples of Blazor.
* [Practical samples of Blazor Server-Side](https://github.com/dodyg/practical-aspnetcore/tree/master/projects/blazor-ss) - Practical samples of Blazor Server-Side.
* [Stack Overflow](https://stackoverflow.com/questions/tagged/blazor) - Blazor questions feed on Stack Overflow.
* [Twitter](https://twitter.com/hashtag/blazor) - Hashtag on Twitter.
* [WebAssemblyMan](https://www.webassemblyman.com/) - Man page for Blazor and WebAssembly.

## Other Languages
* [Blaze of Code](https://blazeofcode.com/) - [Portuguese] Blog about Blazor.
* [Blazor.ru](https://blazor.ru/) - [Russian] Old official documentation website translated in Russian.
* [DevApps.be's podcast #44](http://devapps.be/podcast/blazor-webassembly/) - [French] DevApps.be's podcast #44: "Blazor et WebAssembly vont-ils tuer JavaScript ?".
* [DevApps.be's podcast #47](http://devapps.be/podcast/47-typescript-uno-angular-docfx/) - [French] DevApps.be's podcast #47: "Actualités : TypeScript, Uno, Angular, DocFX, Database".
* [Modern web apps with Blazor](https://media.aspitalia.com/events/VS2019-Blazor.media) - [Italian] Video about Blazor.
* [Playlist - Programando en Blazor](https://www.youtube.com/playlist?list=PL0kIvpOlieSNdIPZbn-mO15YIjRHY2wI9) - [Spanish] Series of videos about Blazor.
* [Insights from the oracle](http://blog.ppedv.de/?tag=Blazor) - [German] Blog about Blazor.

## License

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, Adrien Torris has waived all copyright and related or neighboring rights to this work.
