# Archives of 2018

## Contents
* [Sample Projects](#sample-projects)
* [Tutorials](#tutorials)
* [Libraries & Extensions](#libraries--extensions)
* [Videos](#videos)
* [Articles](#articles)
* [Podcasts](#podcasts)
* [Presentations slides](#presentations-slides)
* [E-Books](#e-books)

## Sample Projects
* [Blangular](https://github.com/danroth27/Blangular) - Blazor + Angular, by Daniel Roth.
* [BlazorAzureSignalRService](https://github.com/danroth27/BlazorAzureSignalRService) - Blazor + Azure SignalR Service.
* [ASP.NET Core Blazor CRUD](https://code.msdn.microsoft.com/vstudio/ASPNET-Core-Blazor-122b108a) - ASP.NET Core Blazor Master/Detail CRUD with Filtering and Sorting using EF.
* [BlazorNasaImages](https://github.com/ncarandini/BlazorNasaImages) - A sample Blazor app that fetches the Nasa Astronomy Picture of the Day.
* [BlazorPong](https://github.com/ctrl-alt-d/blazorpong) - 8 bits pong with blazor and signalR. Warning: Blazor Pong is not finished and is stopped with a knowed SignalR issue with Blazor, more info [here](https://github.com/AdrienTorris/awesome-blazor/pull/19).
* [Demo](https://github.com/blazor-demo/blazor-demo.github.io) - Code of the official demo website.
* [TrendTv](https://github.com/MattMarked/TrendTv) - Fetch video list from YouTube and "zap" in real time between trending videos, filtered by country or category.
* [VocaDB lyrics](https://github.com/riipah/vocadb-lyrics-blazor-proto) - VocaDB lyrics display Blazor proto. [Demo](https://lyrics-proto.vocadb.net/).
* [Blazor.DataDrivenLayout](https://github.com/hutchcodes/Blazor.DataDrivenLayout) - Two example of how to do data driven layouts in Server-side Blazor.
* [BlazorPass](https://github.com/ebekker/BlazorPass) - Blazor UI and ASP.NET Core API to manage Active Directory credentials.
* [Blazor Sushi](https://github.com/lohithgn/blazor-sushi) - Kendo UI Sushi SPA recreated in Blazor.
* [RSS Reader](https://github.com/lohithgn/blazor-rss-reader) - RSS Reader built using Blazor.
* [BlazorGeolocation](https://github.com/EdCharbeneau/BlazorGeolocation) - An example of using Geolocation with Blazor.
* [FMRL](https://github.com/ebekker/FMRL) - Ephemeral Message Service. Messages sent are encrypted, securely transferred, and automatically deleted when they are retrieved.
* [Do](https://github.com/jamie-lord/do) - To Do app.
* [Blazor Contoso University](https://github.com/lohithgn/blazor-contoso-university) - Contoso University in Blazor.
* [Hacker News Clone](https://github.com/lohithgn/blazor-hackernews-clone) - Hacker News Clone. [Demo](http://blazorhackernews.surge.sh/).
* [Randify](https://github.com/tinyioda/Randify) - Spotify Playlist randomizer.
* [Realworld](https://github.com/torhovland/blazor-realworld-example-app) - Blazor realworld example app. [Demo](http://blazor-realworld.azurewebsites.net/).
* [RxBlazor](https://github.com/bmsantos/RxBlazor) - Rx.NET based MessageService demo for Blazor Framework.
* [BlazorChat](https://github.com/danroth27/BlazorChat) - Real-time chat app using ASP.NET Core and Blazor, from Daniel Roth.
* [MatchingGame.Blazor](https://github.com/danroth27/MatchingGame.Blazor) - A sample by Dan Roth.
* [BlazorClipboard](https://github.com/danroth27/BlazorClipboard) - Clipboard API for Blazor.
* [Blazorships](https://github.com/bjorndaniel/Blazorships) - Blazorships, a Blazor implementation of Battleship using SignalR.
* [Calamari Blog](https://github.com/thewebchameleon/calamari-blog-blazor) - A simple blog and portfolio site running on Squidex.
* [Quick CMS](https://github.com/robertsundstrom/quick-cms) - Personal blog engine.
* [Blazume](https://github.com/Amine-Smahi/Blazume) - A simple portfolio/Resume template using Blazor.

## Tutorials
* [Data Driven Layout](https://github.com/hutchcodes/Blazor.DataDrivenLayout) - September 24, 2018 - Two ways of driving the layout based on data in the page.
* [ASP.NET Core Blazor CRUD](https://code.msdn.microsoft.com/vstudio/ASPNET-Core-Blazor-122b108a) - August 20, 2018 - A master/detail HTML CRUD example with sorting and filtering using Entity Framework and Web API.
* [Blazing Chuck](https://davidpine.net/blog/blazing-chuck/) - August 18, 2018 - An example Blazor app that displays random "nerdy" Chuck Norris jokes. [Demo](http://ievangelistblazingchuck.azurewebsites.net/).
* [Blazor + Sitecore](https://visionsincode.wordpress.com/2018/06/30/time-travel-into-the-future-blazor-sitecore-helix/) - June 30, 2018 - Time travel into the future – Blazor + Sitecore + Helix.
* [Blazor Bricks](https://www.codeproject.com/Articles/1241210/WebAssembly-with-Blazor) - May 11, 2018 - A bricks game developed with C# and Blazor.
* [A Nicer Looking Blazor Loading Page](http://lightswitchhelpwebsite.com/Blog/tabid/61/EntryId/4315/A-Nicer-Looking-Blazor-Loading-Page.aspx) - October 14, 2018 - Customize the Blazor loading page using [SpinKit](https://github.com/tobiasahlin/SpinKit).

## Libraries & Extensions
* [Toastr](https://github.com/BlazorExtensions/Toastr) - A Blazor port of Toastr.js.
* [Trail](https://nuget.org/packages/Trail) - DSL for writing Blazor markup in F# (with an [adapter](https://nuget.org/packages/Trail.BlazorRedux) for working with BlazorRedux).
* [BlazorSplit](https://github.com/BlazorComponents/BlazorSplit) - Resizeable split views ([Demo](https://blazorcomponents.github.io/BlazorSplit/)).
* [Elmah.Io.Blazor](https://github.com/elmahio/Elmah.Io.Blazor) - Logs from Blazor to elmah.io using Microsoft.Extensions.Logging.
* [BlazorOfficeUIFabric](https://github.com/BlazorExtensions/BlazorOfficeUIFabric) - ![GitHub stars](https://img.shields.io/github/stars/BlazorExtensions/BlazorOfficeUIFabric?style=flat-square&cacheSeconds=604800) ![last commit](https://img.shields.io/github/last-commit/BlazorExtensions/BlazorOfficeUIFabric?style=flat-square&cacheSeconds=86400) Microsoft Office Fabric UI port for Blazor.

## Videos
* [What's up with Server Side Blazor?](https://www.youtube.com/watch?v=9QRKjUoA9iY) - December 14, 2018 - ASP.NET Monsters #121: What's up with Server Side Blazor?
* [Razor Components deep dive 1](https://www.youtube.com/watch?v=UzEW0X8a010) - December 5, 2018 - Razor Components deep dive 1, from Edward Charbeneau.
* [Blazor, a New .NET Single Page Application Framework](https://www.youtube.com/watch?v=qrf3OrLHeFI) - November 28, 2018 - Steve Sanderson - Blazor, a New .NET Single Page Application Framework | Øredev 2018.
* [Cascading Parameters in Blazor 0.7.0](https://www.youtube.com/watch?v=J_QZKgBSJBw) - November 24, 2018 - Cascading Parameters in Blazor 0.7.0, by Edward Charbeneau.
* [Blazor File Inputs](https://www.youtube.com/watch?v=-IuZQeZ10Uw) - November 19, 2018 - Blazor File Inputs, by Edward Charbeneau.
* [Visual Studio Toolbox: Blazor Part 2](https://channel9.msdn.com/Shows/Visual-Studio-Toolbox/Blazor-Part-2) - November 8, 2018 - Visual Studio Toolbox: Blazor Part 2.
* [Visual Studio Toolbox: Blazor Part 1](https://blogs.msdn.microsoft.com/robertgreen/2018/11/06/visual-studio-toolbox-blazor-part-1/) - November 6, 2018 - Visual Studio Toolbox: Blazor Part 1.
* [The Blazor Show](https://www.youtube.com/watch?v=wwi55L6Qb18&list=PL1rZQsJPBU2StolNg0aqvQswETPcYnNKL&index=0) - October 9, 2018 - ASP.NET Community Standup - The Blazor Show!
* [Developing amazing web apps with ASP.NET Core](https://myignite.techcommunity.microsoft.com/sessions/65901) - September 28, 2018 - Microsoft Ignite 2018: Developing amazing web apps with ASP.NET Core, by Daniel Roth.
* [Blazor StateHasChanged](https://www.twitch.tv/videos/315855936) - September 28, 2018 - Blazor-Fluxor, Bionic and some live demos of building Blazor Component Templates with Blazor 0.6.0.
* [Blazor StateHasChanged](https://www.twitch.tv/videos/313447722) - September 22, 2018 - Blazor 0.6.0 Templates, Razor Components, Hosting with Azure Static Websites, and some live demos using Blazor Interop and Geolocation services.
* [A fistful of Blazor; Its .NET in the browser](https://www.youtube.com/watch?v=5ztMNdCZrRY) - September 21, 2018 - A fistful of Blazor; Its .NET in the browser by William Tulloch at the NDC Sydney.
* [Blazor: Modern Web development with .NET and WebAssembly](https://channel9.msdn.com/Events/dotnetConf/2018/S207) - September 13, 2018 - Blazor: Modern Web development with .NET and WebAssembly during the .NET Conf 2018.
* [What's New in ASP.NET Core?](https://channel9.msdn.com/Events/dotnetConf/2018/S104) - August 11, 2018 - What's New in ASP.NET Core? (31:30).
* [ASP.NET Community Standup - Aug 7, 2018 - Meet the MVC Team!](https://youtu.be/7Eh_l7jEcCo?t=47m35s) - August 7, 2018 - ASP.NET Community Standup - Aug 7, 2018 - Meet the MVC Team!
* [Bionic - Ionic CLI clone for Blazor](https://www.youtube.com/watch?v=_YRR6L2Pzks) - July 8, 2018 - Bionic - Ionic CLI clone for Blazor ([NuGet package](https://www.nuget.org/packages/Bionic)).
* [ASP.NET Community Standup - Meet the Blazor team!](https://www.youtube.com/watch?v=CWuIz9khK-o) - June 12, 2018 - ASP.NET Community Standup - June 12, 2018 - Meet the Blazor team.
* [Blazor, a new .NET SPA framework](https://www.youtube.com/watch?v=JU-6pAxqAa4) - May 7, 2018 - Presentation of Blazor by Steve Sanderson at the NDC Minnesota.
* [.NET Overview & Roadmap](https://channel9.msdn.com/Events/Build/2018/BRK2100) - May 7, 2018 - .NET Overview & Roadmap (at 1:14:00).
* [What's new in Web Development with ASP.NET Core 2.1](https://channel9.msdn.com/Events/Build/2018/BRK2151) - May 6, 2018 - What's new in Web Development with ASP.NET Core 2.1 (Blazor part starts at 1:08:57).
* [Develop ASP.NET Blazor Apps in a Docker Container](https://www.youtube.com/watch?v=jGyFKH5y6LA) - April 26, 2018 - Develop ASP.NET Blazor Apps in a Docker Container, from Coding Blocks.
* [ASP.NET Community Standup - Blazor Update with Dan Roth and Steve Sanderson](https://www.youtube.com/watch?v=_b_fUq5DU0U) - April 3, 2018 - ASP.NET Community Standup - Blazor Update with Dan Roth and Steve Sanderson.
* [WebAssembly and Blazor - .NET Concept of the Week - Episode 9](https://www.youtube.com/watch?v=5HSKDGHijdI) - March 4, 2018 - WebAssembly and Blazor - .NET Concept of the Week - Episode 9.
* [Exploring ASP.NET Blazor](https://www.youtube.com/watch?v=VGotz89_iTY) - Feb 10, 2018 - Exploring ASP.NET Blazor! with Jeffrey T. Fritz.
* [ASP.NET Community Standup](https://www.youtube.com/watch?v=Ta_qXpXQqGQ) - Feb 6, 2018 - ASP.NET Community Standup - Blazor Update.

## Articles
* [Blazor StateHasChanged()](https://edcharbeneau.com/blazor-statehaschanged-113018) - December 14, 2018 - Blazor StateHasChanged().
* [Create Blazor Nuget Package With Azure Devops](https://remibou.github.io/Create-Blazor-Nuget-package-with-Azure-DevOps/) - December 14, 2018 - Create Blazor Nuget Package With Azure Devops.
* [How To Publish A Blazor Component To Nuget Gallery](https://medium.com/swlh/how-to-publish-a-blazor-component-to-nuget-gallery-850d6d1dd37d?WT.mc_id=link-twitter-jeliknes) - December 10, 2018 - How To Publish A Blazor Component To Nuget Gallery.
* [An Ad Hoc Approach to Passing Elements from Blazor to JavaScript](https://visualstudiomagazine.com/blogs/tool-tracker/2018/11/an-ad-hoc-approach.aspx?ajs_uid=5801H8419578J3Z) - December 6, 2018 - An Ad Hoc Approach to Passing Elements from Blazor to JavaScript.
* [Architecting Blazor (and Integrating JavaScript)](https://visualstudiomagazine.com/articles/2018/11/01/architecting-blazor.aspx) - December 4, 2018 - Architecting Blazor (and Integrating JavaScript), from the Visual Studio Magazine.
* [Simple localisation in Blazor](https://chrissainty.com/simple-localisation-in-blazor) - December 3, 2018 - Simple localisation in Blazor.
* [BlazorGrid – A Reusable Grid Component For Blazor](https://ankitsharmablogs.com/blazorgrid-reusable-grid-component-for-blazor/) - December 2, 2018 - BlazorGrid – A Reusable Grid Component For Blazor
* [Visual Studio Code gears up for Blazor](https://visualstudiomagazine.com/articles/2018/11/30/vs-code-blazor.aspx) - November 30, 2018 - Visual Studio Code gears up for Blazor.
* [Validate Request With Recaptcha On A Blazor App And Mediatr](https://remibou.github.io/Validate-request-with-reCaptcha-on-a-Blazor-app-and-MediatR/) - November 24, 2018 - Validate Request With Recaptcha On A Blazor App And Mediatr.
* [Validation Controls using Blazor - Basic Validation Controls](http://www.hishambinateya.com/part1-validation-controls-using-blazor-basic-validation-controls) - November 20, 2018 - Part I: Validation Controls using Blazor - Basic Validation Controls.
* [Blazor StateHasChanged()](https://edcharbeneau.com/blazor-statehaschanged-111618) - November 16, 2018 - Blazor StateHasChanged().
* [Share Blazor Components with Shared Class Libraries](https://daveabrock.com/2018/11/11/using-blazor-shared-libraries/) - November 11, 2018 - Share Blazor Components with Shared Class Libraries.
* [Adding Blazor to existing HTML+JavaScript pages](https://visualstudiomagazine.com/articles/2018/10/01/adding-blazor.aspx) - November 2, 2018 - Adding Blazor to existing HTML+JavaScript pages.
* [Blazor: Working with Events](https://visualstudiomagazine.com/articles/2018/10/01/blazor-event-handling.aspx) - October 31, 2018 - Blazor: Working with Events, by Visual Studio Magazine.
* [Implementing server side CosmosDB pagination in a Blazor Web App](https://chapsas.com/implementing-skiptake-server-side-cosmosdb-pagination-in-a-blazor-web-app/) - October 31, 2018 - Implementing server side CosmosDB pagination in a Blazor Web App (Part 1: Page Number and Page Size).
* [Blazor Q&A with Microsoft's Daniel Roth](https://www.telerik.com/blogs/blazor-qa-with-microsofts-daniel-roth) - October 25, 2018 - Blazor Q&A with Microsoft's Daniel Roth.
* [Building offline Blazor application](https://gunnarpeipman.com/aspnet/offline-blazor-application) - October 24, 2018 - Building offline Blazor application.
* [Service lifetimes in Blazor](https://chrissainty.com/service-lifetimes-in-blazor/) - October 22, 2018 - Service lifetimes in Blazor.
* [Pages in ASP .NET Core: Razor, Blazor and MVC Views](https://wakeupandcode.com/pages-in-asp-net-core-razor-blazor-and-mvc-views/) - October 21, 2018 - Pages in ASP .NET Core: Razor, Blazor and MVC Views.
* [Server-side Blazor applications](https://gunnarpeipman.com/aspnet/server-side-blazor/) - October 19, 2018 - Server-side Blazor applications.
* [Building a blogging app with Blazor: adding authentication](https://chrissainty.com/building-a-blogging-app-with-blazor-adding-authentication/) - October 15, 2018 - Building a blogging app with Blazor: adding authentication.
* [Get Started with Blazor and WebAssembly](https://developer.okta.com/blog/2018/10/15/blazor-and-web-assembly) - October 15, 2018 - Get Started with Blazor and WebAssembly.
* [An overview of Razor Components (server-side Blazor)](http://danpatrascu.com/an-overview-of-razor-components-server-side-blazor/) - October 15, 2018 - An overview of Razor Components (server-side Blazor).
* [A nicer looking Blazor loading page](http://lightswitchhelpwebsite.com/Blog/tabid/61/EntryId/4315/A-Nicer-Looking-Blazor-Loading-Page.aspx) - October 14, 2018 - A nicer looking Blazor loading page.
* [Deploying a Blazor Application on Azure](https://dzone.com/articles/deploying-a-blazor-application-on-azure) - October 12, 2018 - Deploying a Blazor Application on Azure.
* [A Blazor Tip You Should Almost Certainly Ignore](https://visualstudiomagazine.com/blogs/tool-tracker/2018/10/blazor-tip.aspx) - October 10, 2018 - A Blazor Tip You Should Almost Certainly Ignore.
* [Rendering Medical Images using Blazor and fo-dicom](https://maherjendoubi.io/blazor-dicom/) - October 7, 2018 - Rendering Medical Images using Blazor and fo-dicom.
* [Building Blazor apps with SignalR Core](https://dotnetthoughts.net/building-blazor-apps-with-signalr/) - October 3, 2018 - Building Blazor apps with SignalR Core.
* [Server-Side Blazor to ship in .NET Core 3.0](https://visualstudiomagazine.com/articles/2018/10/03/blazor-update.aspx) - October 3, 2018 - Server-Side Blazor to ship in .NET Core 3.0.
* [Blazor 0.6.0 experimental release now available](https://blogs.msdn.microsoft.com/webdev/2018/10/02/blazor-0-6-0-experimental-release-now-available/) - October 2, 2018 - Blazor 0.6.0 experimental release now available.
* [Integrating JavaScript and C# in the Browser: Beyond the Basics with Blazor](https://visualstudiomagazine.com/articles/2018/09/01/integrating-javascript-csharp.aspx) - October 1, 2018 - Integrating JavaScript and C# in the Browser: Beyond the Basics with Blazor.
* [Cutting Edge - Blazor at Work: Events, Binding and Composition](https://msdn.microsoft.com/magazine/mt830361) - October 1, 2018 - Cutting Edge - Blazor at Work: Events, Binding and Composition.
* [Work with Cassandra API in Cosmos DB](https://www.c-sharpcorner.com/article/blazor-work-with-cassandra-api-in-cosmos-db/) - October 1, 2018 - Work with Cassandra API in Cosmos DB.
* [Blazor - .NET in the browser](https://www.dotnetcurry.com/dotnet/1460/blazor-getting-started) - September 27, 2018 - Blazor - .NET in the browser.
* [Building a blogging app with Blazor: Editing & Deleting Posts](https://chrissainty.com/building-a-blogging-app-with-blazor-editing-deleting-posts/) - September 24, 2018 - Building a blogging app with Blazor: Editing & Deleting Posts.
* [Data Driven Layout in Server-side Blazor](https://hutchcodes.net/2018/09/data-driven-layout-in-razor-components/) - September 24, 2018 - Data Driven Layout in Server-side Blazor.
* [Building a blogging app with Blazor: add post](https://chrissainty.com/building-a-blogging-app-with-blazor-add-post/) - September 18, 2018 - Building a blogging app with Blazor: add post.
* [Dependency Injection Lifetimes in Blazor](https://hutchcodes.net/2018/09/dependency-injection-lifetimes-in-razor-components/) - September 17, 2018 - Dependency Injection Lifetimes in Blazor.
* [How to Consume Web APIs in Blazor](https://visualstudiomagazine.com/articles/2018/09/07/blazor-apis.aspx) - September 13, 2018 - How to Consume Web APIs in Blazor.
* [Integrating Stripe Payment In With Blazor And Aspnet Core](https://remibou.github.io/Integrating-Stripe-payment-in-with-Blazor-and-ASPNET-Core/) - September 11, 2018 - Integrating Stripe Payment In With Blazor And Aspnet Core.
* [Working with the Blazor JavaScript Interop](https://blog.logrocket.com/working-with-the-blazor-javascript-interop-3c2a8d0eb56c) - September 5, 2018 - Working with the Blazor JavaScript Interop.
* [Cutting Edge - Never Mind JavaScript, Here’s Blazor](https://msdn.microsoft.com/magazine/mt829756) - September 4, 2018 - Cutting Edge - Never Mind JavaScript, Here’s Blazor, published on Microsoft Magazine.
* [Web Development - C# in the Browser with Blazor](https://msdn.microsoft.com/fr-fr/magazine/mt829752) - September 4, 2018 - Web Development - C# in the Browser with Blazor, published on Microsoft Magazine.
* [Building a blogging app with Blazor: Listing Posts](https://chrissainty.com/building-a-blogging-app-with-blazor-listing-posts/) - September 3, 2018 - Building a blogging app with Blazor: Listing Posts.
* [Blazor: .NET in the browser](https://dncmagazine.blob.core.windows.net/edition38/DNCMag-Issue38.pdf) - September 1, 2018 - Blazor: .NET in the browser, from DNC Magazine.
* [Integrating Blazor and JavaScript Code](https://visualstudiomagazine.com/articles/2018/08/01/integrating-blazor-javascript.aspx) - August 27, 2018 - Integrating Blazor and JavaScript Code.
* [Building a blogging app with Blazor: Getting Setup](https://chrissainty.com/building-a-blogging-app-with-blazor-getting-setup/) - August 27, 2018 - Building a blogging app with Blazor: Getting Setup.
* [Client side validation with Blazor and System.DataAnnotation](https://remibou.github.io/Client-side-validation-with-Blazor-and-Data-Annotations/) - August 23, 2018 - Client side validation with Blazor and System.DataAnnotation.
* [Writing a Blazor app](https://davidpine.net/blog/blazing-chuck/) - August 20, 2018 - Writing a Blazor app.
* [Localizing DateTime (and numbers) in Blazor](https://remibou.github.io/Localizing-DateTime-in-Blazor/) - August 17, 2018 - Localizing DateTime (and numbers) in Blazor.
* [Introduction to Server-side Blazor aka Razor Components](https://chrissainty.com/introduction-to-server-side-blazor-aka-razor-components/) - August 11, 2018 - Introduction to Server-side Blazor aka Razor Components.
* [I18n With Blazor And Aspnet Core](https://remibou.github.io/I18n-with-Blazor-and-ASPNET-Core/) - August 11, 2018 - Internationalizing a Blazor App with ASPNET Core as backend service.
* [WebAssembly](https://davidpine.net/blog/webassembly-interview/) - August 5, 2018 - Interview with Steve Sanderson (Talking Blazor).
* [Web Assembly and Blazor: Re-assembling the Web](https://weblog.west-wind.com/posts/2018/Jul/31/Web-Assembly-and-Blazor-Reassembling-the-Web) - July 31, 2018 - Web Assembly and Blazor: Re-assembling the Web.
* [Understanding Server-Side Blazor](https://www.c-sharpcorner.com/article/understanding-server-side-blazor/) - July 29, 2018 - Understanding Server-Side Blazor.
* [Blazor 0.5.0 experimental release now available](https://blogs.msdn.microsoft.com/webdev/2018/07/25/blazor-0-5-0-experimental-release-now-available/) - July 25, 2018 - Blazor 0.5.0 experimental release now available.
* [CSRF protection with ASPNET Core and Blazor](https://remibou.github.io/CSRF-protection-with-ASPNET-Core-and-Blazor-Week-29/) - July 22, 2018 - CSRF protection with ASPNET Core and Blazor.
* [Blazor for Knockout.js Developers](https://blog.usejournal.com/blazor-for-knockout-js-developers-bfeefaacffc3) - July 20, 2018 - A brief comparison between two of Steve Sanderson’s Creations.
* [Uploading a file in a Blazor app](https://remibou.github.io/Upload-file-with-Blazor/) - July 12, 2018 - Uploading a file in a Blazor app.
* [Adding search to Blazor applications](https://gunnarpeipman.com/search2/blazor-search/) - July 11, 2018 - Adding search to Blazor applications.
* [SPA framework on .Net via WebAssembly](https://koukia.ca/blazor-spa-framework-on-net-via-webassembly-b7a0046e7f21) - July 10, 2018 - SPA framework on .Net via WebAssembly.
* [ASP.NET Core Blazor CRUD](https://code.msdn.microsoft.com/vstudio/ASPNET-Core-Blazor-122b108a) - July 9, 2018 - ASP.NET Core Blazor Master/Detail CRUD with Filtering and Sorting using EF.
* [Improved Cascading Dropdowns With Blazor](https://www.mikesdotnetting.com/article/320/improved-cascading-dropdowns-with-blazor) - July 5, 2018 - Improved Cascading Dropdowns With Blazor.
* [Hosting a Blazor App in Azure Storage Static Websites](https://anthonychu.ca/post/blazor-azure-storage-static-websites/) - June 28, 2018 - Hosting a Blazor App in Azure Storage Static Websites.
* [Implementing Google OAuth with Blazor](https://remibou.github.io/Google-OAuth-with-Blazor-ASPNET-Core-Week-26/) - June 28, 2018 - Implementing Google OAuth with Blazor (0.4) and ASPNET Core 2.1.1.
* [Web Assembly, Blazor and the future of Web Development](https://medium.com/@ZombieCodeKill/web-assembly-blazor-and-the-future-of-web-development-c240fbe5e5be) - June 25, 208 - Web Assembly, Blazor and the future of Web Development.
* [Hosting Blazor on Netlify](https://mattferderer.com/host-blazor-on-netlify) - Hosting Blazor on Netlify.
* [Who is Blazor for Exactly?](https://wildermuth.com/2018/06/13/Who-is-Blazor-for-Exactly) - June 13, 208 - Who is Blazor for Exactly?
* [Blazor 0.4.0 experimental release now available](https://blogs.msdn.microsoft.com/webdev/2018/06/07/blazor-0-4-0-experimental-release-now-available/) - June 7, 2018 - Blazor 0.4.0 experimental release now available.
* [Blazor Update Boosts .NET/JavaScript Interoperability](https://visualstudiomagazine.com/articles/2018/06/08/blazor-0-4-0.aspx) - June 8, 2018 - Blazor Update Boosts .NET/JavaScript Interoperability.
* [An Introduction to Blazor](https://remibou.github.io/An-Introduction-to-Blazor-Week-22/) - June 5, 2018 - An Introduction to Blazor.
* [Creating an SPA Using Razor Pages With Blazor](https://medium.freecodecamp.org/how-to-create-a-single-page-application-using-razor-pages-with-blazor-9d010fd6be45) - June 4, 2018 - Creating an SPA Using Razor Pages With Blazor ([Article on FreeCodeCamp](https://medium.freecodecamp.org/how-to-create-a-single-page-application-using-razor-pages-with-blazor-9d010fd6be45) - [Article on DZone](https://dzone.com/articles/creating-an-spa-using-razor-pages-with-blazor)).
* [Cascading DropDownList in Blazor Using EF Core](http://ankitsharmablogs.com/cascading-dropdownlist-in-blazor-using-ef-core/) - May 14, 2018 - Creating a cascading dropdown list in Blazor using Entity Framework Core database first approach.
* [Deploying a Blazor Application on IIS](http://ankitsharmablogs.com/deploying-a-blazor-application-on-iis/) - May 14, 2018 - Deploying an ASP.NET Core hosted Blazor application with the help of IIS 10 on a Windows 10 machine.
* [Blazor Steals the Show in VSLive!](https://visualstudiomagazine.com/articles/2018/05/03/vslive-austin.aspx) - May 3, 2018 - Blazor Steals the Show in VSLive! .NET Keynote.
* [Blazor 0.3.0 experimental release now available](https://blogs.msdn.microsoft.com/webdev/2018/05/02/blazor-0-3-0-experimental-release-now-available/) - May 2, 2018 - Blazor 0.3.0 experimental release now available.
* [Blazor, Razor, WebAssembly, and Mono](https://daveaglick.com/posts/blazor-razor-webassembly-and-mono) - April 24, 2018 - Blazor, Razor, WebAssembly, and Mono, How the pieces fit together.
* [BlazeDown with Blazor](http://edcharbeneau.com/blazedown-with-blazor) - April 20, 2018 - BlazeDown with Blazor (Blazor + Markdown = BlazeDown!).
* [Blazor 0.2.0 release now available](https://blogs.msdn.microsoft.com/webdev/2018/04/17/blazor-0-2-0-release-now-available/) - April 18, 2018 - Blazor 0.2.0 release now available.
* [ASP.NET Core – CRUD Using Blazor And Entity Framework Core](http://ankitsharmablogs.com/asp-net-core-crud-using-blazor-and-entity-framework-core/) - April 9, 2018 - Creating a web application using Blazor with the help of Entity Framework Core.
* [Using C# await against JS Promises in Blazor](https://joonasw.net/view/csharp-await-and-js-promises-in-blazor) - April 7, 2018 - Using C# await against JS Promises in Blazor.
* [Create a CRUD App using Blazor and ASP.NET Core](http://www.talkingdotnet.com/create-a-crud-app-using-blazor-and-asp-net-core/) - April 5, 2018 - Create a CRUD App using Blazor and ASP.NET Core.
* [Blazor – You Want To Run .NET Where?!](https://dotnetcore.gaprogman.com/2018/04/05/blazor-you-want-to-run-net-where/) - April 5, 2018 - Blazor – You Want To Run .NET Where?!
* [Blazor introduction](https://maherjendoubi.io/blazor-introduction/) - March 30, 2018 - Blazor introduction.
* [What is Blazor and why is it so exciting?](https://chrissainty.com/what-is-blazor-and-why-is-it-so-exciting/) - March 24, 2018 - What is Blazor and why is it so exciting?
* ['Death to JavaScript!' Blazor, for .NET Web Apps Using WebAssembly, Goes Alpha](https://visualstudiomagazine.com/articles/2018/03/23/blazor-alpha.aspx) - March 23, 2018 - 'Death to JavaScript!' Blazor, for .NET Web Apps Using WebAssembly, Goes Alpha.
* [Get started building .NET web apps that run in the browser with Blazor](https://blogs.msdn.microsoft.com/webdev/2018/03/22/get-started-building-net-web-apps-in-the-browser-with-blazor/) - March 22, 2018 - Get started building .NET web apps that run in the browser with Blazor.
* [Blazor and .NET Core hosting – the future’s bright](http://blog.tdwright.co.uk/2018/03/05/blazor-and-net-core-hosting-the-futures-bright) - March 5, 2018 - Blazor and .NET Core hosting – the future’s bright.
* [Building SPAs with C#](http://danpatrascu.com/building-spas-with-c/) - February 13, 2018 - Building SPAs with C#.
* [Blazor: a web UI framework running C# and .NET in the browser](https://www.oxfordcc.co.uk/blog/blazor-a-web-ui-framework-running-csharp-and-dotnet-in-the-browser) - February 8, 2018 - Blazor: a web UI framework running C# and .NET in the browser.
* [A new experiment: Browser-based web apps with .NET and Blazor](https://blogs.msdn.microsoft.com/webdev/2018/02/06/blazor-experimental-project/) - February 6, 2018 - A new experiment: Browser-based web apps with .NET and Blazor.
* [Blazor: a technical introduction](http://blog.stevensanderson.com/2018/02/06/blazor-intro/) - February 6, 2018 - Blazor: a technical introduction.

## Podcasts
* [SDN Cast #118 - With Rainer Stropek and Serverside Blazor!](https://www.youtube.com/watch?v=S66mK_30gPE) - November 8, 2018 - Weekly SDN Cast with special gues Rainer Stropek talking about and showing off Blazor!
* [Ed Charbeneau on Blazor](https://crosscuttingconcerns.com/Podcast-099-Ed-Charbeneau-Blazor) - September 17, 2018 - Ed Charbeneau on Blazor.
* [Blazor brings .NET to Web Assembly with Steve Sanderson](https://hanselminutes.com/642/blazor-brings-net-to-web-assembly-with-steve-sanderson) - July 26, 2018 - Blazor brings .NET to Web Assembly with Steve Sanderson.
* [Episode 037 – Blazor with Daniel Roth](https://6figuredev.com/podcast/episode-037-blazor-with-daniel-roth/) - April 30, 2018 - Episode 037 – Blazor with Daniel Roth.
* [MS Dev Show : Blazor](https://www.youtube.com/watch?v=xJtpYsVRggE) - March 19, 2018 - MS Dev Show Episode 184: Blazor (.NET in WebAssembly) with Dan Roth & Steve Sanderson.

## Presentations slides
* [WebAssembly and Blazor – the future of frontend development?](https://github.com/kkalinowski/Wasm-Blazor-Presentation) - December 12, 2018 - WebAssembly and Blazor – the future of frontend development?. Slides: [PPTX](https://raw.githubusercontent.com/kkalinowski/Wasm-Blazor-Presentation/master/presentation/Blazor.pptx). Demo's source code: [GitHub](https://github.com/kkalinowski/Wasm-Blazor-Presentation/tree/master/src/BlazorDemo).
* [C# running in the browser via WebAssembly](https://www.infoq.com/presentations/blazor-web-assembly) - December, 2018 - "C# running in the browser via WebAssembly" by Scott Sauber. Slides: [PDF](https://scottsauber.files.wordpress.com/2018/12/blazor.pdf).
* [SPA Revolution with WebAssembly and ASP.NET Blazor](https://javascript-conference.com/javascriptecmascript/spa-revolution-with-webassembly-and-asp-net-blazor/) - October 16, 2018 - "SPA Revolution with WebAssembly and ASP.NET Blazor" session at the International JavaScript Conference. Slides: [PPTX](https://learn-blazor.com/slides/blazor-intro.pptx).
* [Blazor: Modern Web development with .NET and WebAssembly]() - August 11, 2018 - "Blazor: Modern Web development with .NET and WebAssembly" session at the .NET Conf 2018. Video: [Channel 9](https://channel9.msdn.com/Events/dotnetConf/2018/S207). Slides: [PPTX](https://github.com/dotnet-presentations/dotnetconf2018/blob/master/Technical/Decks/Blazor_Modern%20Web%20development%20with%20.NET%20and%20WebAssembly.pptx?raw=true) or [GitHub](https://github.com/dotnet-presentations/dotnetconf2018/blob/master/Technical/Decks/Blazor_Modern%20Web%20development%20with%20.NET%20and%20WebAssembly.pptx).
* [Blazor v1.1](https://www.slideshare.net/elGuerre/blazor-v11) - June 28, 2018 - Blazor v1.1.
* [Blazor - An Introduction](https://www.slideshare.net/JamieTaylor112/blazor-an-introduction) - April 14, 2018 - Blazor, An Introduction.
* [An experimental .NET framework for the browser](https://github.com/bjablonsky/blazor-presentation) - April, 2018 - An experimental .NET framework for the browser. Slides: [PPTX](https://raw.githubusercontent.com/bjablonsky/blazor-presentation/master/Blazor.pptx). Demo's source code: [GitHub](https://github.com/bjablonsky/blazor-presentation/tree/master/src).

## E-Books
* [Dockerizing ASP.NET Core and Blazor Applications on Mac](https://www.c-sharpcorner.com/ebooks/dockerizing-asp-net-core-and-blazor-applications-on-mac) - October 30, 2018 - Dockerizing ASP.NET Core and Blazor Applications on Mac.
