package stirling.software.SPDF.model.api;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;

import io.swagger.v3.oas.annotations.media.Schema;


import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@ConditionalOnProperty(value = "mail.enabled", havingValue = "true", matchIfMissing = false)
public class Email extends GeneralFile {

    @Schema(
            description = "The recipient's email address",
            requiredMode = Schema.RequiredMode.REQUIRED,
            format = "email")
    private String to;

    @Schema(
            description = "The subject of the email",
            defaultValue = "Stirling Software PDF Notification",
            requiredMode = Schema.RequiredMode.NOT_REQUIRED)
    private String subject;

    @Schema(
            description = "The body of the email",
            requiredMode = Schema.RequiredMode.NOT_REQUIRED,
            defaultValue =
                    "This message was automatically generated by Stirling-PDF, an innovative"
                            + " solution from Stirling Software. For more information, visit our <a"
                            + " href=\"https://stirling-software.com\">website</a>.<br><br>Please do"
                            + " not reply directly to this email.")
    private String body;
}
