"use client";
import { Fragment, useState } from "react";
import { X, Menu } from "lucide-react";
import { Logo } from "@cap/ui";
import Link from "next/link";
import { Dialog, Transition } from "@headlessui/react";
import { AdminNavItems } from "./AdminNavItems";

export const AdminMobileNav = () => {
  const [sidebarOpen, setSidebarOpen] = useState(false);
  return (
    <>
      <Transition.Root show={sidebarOpen} as={Fragment}>
        <Dialog
          as="div"
          static
          className="fixed inset-0 flex z-50 lg:hidden"
          open={sidebarOpen}
          onClose={setSidebarOpen}
        >
          <Transition.Child
            as={Fragment}
            enter="transition-opacity ease-linear duration-300"
            enterFrom="opacity-0"
            enterTo="opacity-100"
            leave="transition-opacity ease-linear duration-300"
            leaveFrom="opacity-100"
            leaveTo="opacity-0"
          >
            <Dialog.Overlay className="fixed inset-0 bg-gray-600 bg-opacity-75" />
          </Transition.Child>
          <Transition.Child
            as={Fragment}
            enter="transition ease-in-out duration-300 transform"
            enterFrom="-translate-x-full"
            enterTo="translate-x-0"
            leave="transition ease-in-out duration-300 transform"
            leaveFrom="translate-x-0"
            leaveTo="-translate-x-full"
          >
            <div className="relative flex-1 flex flex-col max-w-xs w-[275px] pt-5 pb-4 px-4 bg-gradient-to-b from-primary to-primary-3">
              <Transition.Child
                as={Fragment}
                enter="ease-in-out duration-300"
                enterFrom="opacity-0"
                enterTo="opacity-100"
                leave="ease-in-out duration-300"
                leaveFrom="opacity-100"
                leaveTo="opacity-0"
              >
                <div className="absolute top-0 right-0 -mr-12 pt-2">
                  <button
                    className="ml-1 flex items-center justify-center h-10 w-10 rounded-full focus:outline-none focus:ring-2 focus:ring-inset focus:ring-white"
                    onClick={() => setSidebarOpen(false)}
                  >
                    <span className="sr-only">Close sidebar</span>
                    <X className="h-6 w-6 text-black" aria-hidden="true" />
                  </button>
                </div>
              </Transition.Child>
              <div className="flex-shrink-0 flex items-center px-4">
                <Link href="/inbox">
                  <Logo className="h-6 w-auto" />
                </Link>
              </div>
              <AdminNavItems />
            </div>
          </Transition.Child>
          <div className="flex-shrink-0 w-14" aria-hidden="true">
            {/* Dummy element to force sidebar to shrink to fit close icon */}
          </div>
        </Dialog>
      </Transition.Root>

      <div className="relative z-10 flex-shrink-0 flex h-16 bg-gray-50 border-b-2 border-gray-100 lg:border-none lg:hidden">
        <button
          className="px-4 border-r-2 focus:outline-none focus:ring-2 text-white focus:ring-inset focus:ring-cyan-500 lg:hidden"
          onClick={() => setSidebarOpen(true)}
        >
          <span className="sr-only">Open sidebar</span>
          <Menu className="h-6 w-6 text-black" aria-hidden="true" />
        </button>
        <div className="flex justify-center lg:justify-end w-full px-6">
          <div className="flex-shrink-0 flex lg:hidden items-center px-4">
            <Link className="block" href="/inbox">
              <Logo className="w-16 h-auto block" />
            </Link>
          </div>
        </div>
      </div>
    </>
  );
};

export default AdminMobileNav;
