# Next steps

## Learn more about TensorFlow

* The [TensorFlow Guide](/guide) includes usage guides for the
  high-level APIs, as well as advanced TensorFlow operations.
* [Premade Estimators](/guide/premade_estimators) are designed to
  get results out of the box. Use TensorFlow without building your own models.
* [TensorFlow.js](https://js.tensorflow.org/) allows web developers to train and
  deploy ML models in the browser and using Node.js.
* [TFLite](/mobile/tflite) allows mobile developers to do inference efficiently
  on mobile devices.
* [TensorFlow Serving](/serving) is an open-source project that can put
  TensorFlow models in production quickly.
* The [ecosystem](/ecosystem) contains more projects, including
  [Magenta](https://magenta.tensorflow.org/), [TFX](/tfx),
  [Swift for TensorFlow](https://github.com/tensorflow/swift), and more.

## Learn more about machine learning

Recommended resources include:

* [Machine Learning Crash Course](https://developers.google.com/machine-learning/crash-course/),
  a course from Google that introduces machine learning concepts.
* [CS 20: Tensorflow for Deep Learning Research](http://web.stanford.edu/class/cs20si/),
  notes from an intro course from Stanford.
* [CS231n: Convolutional Neural Networks for Visual Recognition](http://cs231n.stanford.edu/),
  a course that teaches how convolutional networks work.
* [Machine Learning Recipes](https://www.youtube.com/watch?v=cKxRvEZd3Mw&list=PLOU2XLYxmsIIuiBfYad6rFYQU_jL2ryal),
  a video series that introduces basic machine learning concepts with few prerequisites.
* [Deep Learning with Python](https://www.manning.com/books/deep-learning-with-python),
  a book by Francois Chollet about the Keras API, as well as an excellent hands on intro to Deep Learning.
* [Hands-on Machine Learning with Scikit-Learn and TensorFlow](https://github.com/ageron/handson-ml),
  a book by Aurélien Geron's that is a clear getting-started guide to data science and deep learning.
* [Deep Learning](https://www.deeplearningbook.org/), a book by Ian Goodfellow et al.
  that provides a technical dive into learning machine learning.
