# Learn and use machine learning

This notebook collection is inspired by the book
*[Deep Learning with Python](https://books.google.com/books?id=Yo3CAQAACAAJ)*.
These tutorials use `tf.keras`, TensorFlow's high-level Python API for building
and training deep learning models. To learn more about using Keras with
TensorFlow, see the [TensorFlow Keras Guide](../../guide/keras).

Publisher's note: *Deep Learning with Python* introduces the field of deep
learning using the Python language and the powerful Keras library. Written by
Keras creator and Google AI researcher François Chollet, this book builds your
understanding through intuitive explanations and practical examples.

To learn about machine learning fundamentals and concepts, consider taking the
[Machine Learning Crash Course](https://developers.google.com/machine-learning/crash-course/).
Additional TensorFlow and machine learning resources are listed in [next steps](../next_steps).

1. [Basic classification](./basic_classification)
2. [Text classification](./basic_text_classification)
3. [Regression](./basic_regression)
4. [Overfitting and underfitting](./overfit_and_underfit)
5. [Save and restore models](./save_and_restore_models)
