# Estimator Examples

TensorFlow Estimators are a high-level API for TensorFlow that allows you to
create, train, and use deep learning models easily.

See the [Quickstart tutorial](https://www.tensorflow.org/get_started/estimator)
for an introduction to the API.

To run most of these examples, you need to install the `scikit learn` library
(`pip install -U scikit-learn`). Some examples use the `pandas` library for data
processing (`pip install -U pandas`).

## Basics

* [Deep Neural Network Regression with Boston Data](https://www.tensorflow.org/code/tensorflow/examples/learn/boston.py)
* [Deep Neural Network Classification with Iris Data](https://www.tensorflow.org/code/tensorflow/examples/learn/iris.py)
* [Building a Custom Model](https://www.tensorflow.org/code/tensorflow/examples/learn/iris_custom_model.py)
* [Building a Model Using Different GPU Configurations](https://www.tensorflow.org/code/tensorflow/examples/learn/iris_run_config.py)

## Techniques

* [Deep Neural Network with Customized Decay Function](https://www.tensorflow.org/code/tensorflow/examples/learn/iris_custom_decay_dnn.py)

## Specialized Models
* [Building a Random Forest Model](https://www.tensorflow.org/code/tensorflow/examples/learn/random_forest_mnist.py)
* [Building a Wide & Deep Model](https://www.tensorflow.org/code/tensorflow/examples/learn/wide_n_deep_tutorial.py)
* [Building a Residual Network Model](https://www.tensorflow.org/code/tensorflow/examples/learn/resnet.py)

## Text classification

* [Text Classification Using Recurrent Neural Networks on Words](https://www.tensorflow.org/code/tensorflow/examples/learn/text_classification.py)
* [Text Classification Using Convolutional Neural Networks on Words](https://www.tensorflow.org/code/tensorflow/examples/learn/text_classification_cnn.py)
* [Text Classification Using Recurrent Neural Networks on Characters](https://www.tensorflow.org/code/tensorflow/examples/learn/text_classification_character_rnn.py)
* [Text Classification Using Convolutional Neural Networks on Characters](https://www.tensorflow.org/code/tensorflow/examples/learn/text_classification_character_cnn.py)
