# Getting Started

TensorFlow is a tool for machine learning. While it contains a wide range of
functionality, TensorFlow is mainly designed for deep neural network models.

The easiest way to get started with tensorflow is using Eager Execution.

  * @{$get_started/eager}, is for anyone new to  machine learning or TensorFlow.

TensorFlow provides many APIs. The remainder of this section focuses on the
Estimator API which provide scalable, high-performance models.
To get started with Estimators begin by reading one of the following documents:

  * @{$get_started/get_started_for_beginners}, which is aimed at readers
    new to machine learning.
  * @{$get_started/premade_estimators}, which is aimed at readers who have
    experience in machine learning.

Then, read the following documents, which demonstrate the key features
in the high-level APIs:

  * @{$get_started/checkpoints}, which explains how to save training progress
    and resume where you left off.
  * @{$get_started/feature_columns}, which shows how an
    Estimator can handle a variety of input data types without changes to the
    model.
  * @{$get_started/datasets_quickstart}, which introduces TensorFlow's
    input pipelines.
  * @{$get_started/custom_estimators}, which demonstrates how
    to build and train models you design yourself.

For more advanced users:

  * The @{$low_level_intro$Low Level Introduction} demonstrates how to use
    TensorFlow outside of the Estimator framework, for debugging and
    experimentation.
  * The @{$programmers_guide$Programmer's Guide} details major
    TensorFlow components.
  * The @{$tutorials$Tutorials} provide walkthroughs of a variety of
    TensorFlow models.
