# Contributing to TensorFlow

TensorFlow is an open-source project, and we welcome your participation
and contribution. This page describes how to get involved.

## Repositories

The code for TensorFlow is hosted in the [TensorFlow GitHub
organization](https://github.com/tensorflow). Multiple projects are located
inside the organization, including:

* [TensorFlow](https://github.com/tensorflow/tensorflow)
* [Models](https://github.com/tensorflow/models)
* [TensorBoard](https://github.com/tensorflow/tensorboard)
* [TensorFlow.js](https://github.com/tensorflow/tfjs)
* [TensorFlow Serving](https://github.com/tensorflow/serving)
* [TensorFlow Documentation](https://github.com/tensorflow/tensorflow/tree/master/tensorflow/docs_src)

## Contributor checklist

* Before contributing to TensorFlow source code, please review the [contribution
guidelines](https://github.com/tensorflow/tensorflow/blob/master/CONTRIBUTING.md).

* Join the
[developers@tensorflow.org](https://groups.google.com/a/tensorflow.org/d/forum/developers)
mailing list, to coordinate and discuss with others contributing to TensorFlow.

* For coding style conventions, read the @{$style_guide$TensorFlow Style Guide}.

* Finally, review @{$documentation$Writing TensorFlow Documentation}, which
  explains documentation conventions.

You may also wish to review our guide to @{$benchmarks$defining and running benchmarks}.

## Special Interest Groups

To enable focused collaboration on particular areas of TensorFlow, we host
Special Interest Groups (SIGs). SIGs do their work in public: if you want to
join and contribute, review the work of the group, and get in touch with the
relevant SIG leader.  Membership policies vary on a per-SIG basis.

* **SIG Build** focuses on issues surrounding building, packaging, and
  distribution of TensorFlow. [Mailing list](https://groups.google.com/a/tensorflow.org/d/forum/build).

* **SIG TensorBoard** furthers the development and direction of TensorBoard and its plugins.
  [Mailing list](https://groups.google.com/a/tensorflow.org/d/forum/sig-tensorboard).

* **SIG Rust** collaborates on the development of TensorFlow's Rust bindings.
  [Mailing list](https://groups.google.com/a/tensorflow.org/d/forum/rust).
