## Contributing to pfSense

The pfSense project welcomes contributions, big or small. Members of the pfSense community frequently contribute bug fixes, enhancements, and documentation changes to improve the functionality and usability of the software.

All of the pfSense project source code is on Github. We recommend potential contributors familiarize themselves with [the pfSense project git repositories](https://github.com/pfsense) and [Github in general](https://help.github.com).

If you want to contribute but do not have a specific topic in mind, review the [list of open bug reports and other issues that are in need of attention](https://redmine.pfsense.org/projects/pfsense/issues).

Contact [coreteam@pfsense.org](mailto:coreteam@pfsense.org "Mail to coreteam@pfsense.org") with any additional questions or concerns.

Before submitting changes, please take a few moments to review our submission guidelines below.

### **Security Submissions**

We prefer [responsible disclosure](https://en.wikipedia.org/wiki/Responsible_disclosure) for security concerns.

If you have discovered a security issue, **do not** create a pull request or open a public bug report. Instead, disclose the details of the potential problem to us privately.

See https://www.pfsense.org/security/ for information on how to submit security issues, including information on our PGP key for encrypting messages.

### **Bug Reports and Feature Requests**

Bug reports and feature requests are tracked at https://redmine.pfsense.org

Please search for existing issues before opening a new report. Before opening a new issue, read the [guidelines for submitting bug reports](https://doc.pfsense.org/index.php/Bug_reporting).

If you are submitting a pull request, locate or create a corresponding Redmine entry first and provide a link to the issue in the pull request.

### **Submitting Changes**

The easiest and best way to contribute code changes to the project is through pull requests on Github.

For an outline of the process and guidelines to follow, see [Submitting a Pull Request via Github](https://doc.pfsense.org/index.php/Submitting_a_Pull_Request_via_Github)

Contributed code must conform to the [pfSense project Developer Style Guide](https://doc.pfsense.org/index.php/Developer_Style_Guide).

