define(function(require, exports, module) {
    exports.Modules = 
{ "http://xbrl.io/modules/bizql/components" : { "ns" : "http://xbrl.io/modules/bizql/components", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This module provides functionality for retrieving components.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Components help organizing the facts contained in archives\n in smaller parts that \"make sense\" together. A component is identified\n with a CID (component ID).</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">A component is made of networks (see the networks module) and hypercubes\n (see the hypercubes module).</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">With this module, you can retrieve all components, all components belonging\n to one or several archives. You can retrieve the CID of a component or retrieve\n the components associated with a couple of CIDs.</p>\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Charles Hoffman</xqdoc:author>", "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Matthias Brantner</xqdoc:author>", "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Dennis Knochenwefel</xqdoc:author>", "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Ghislain Fourny</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://xbrl.io/modules/bizql/archives", "prefix" : "archives" }, { "uri" : "http://xbrl.io/modules/bizql/components", "prefix" : "components" }, { "uri" : "http://www.28msec.com/modules/credentials", "prefix" : "credentials" }, { "uri" : "http://xbrl.io/modules/bizql/facts", "prefix" : "facts" }, { "uri" : "http://www.28msec.com/modules/mongodb", "prefix" : "mongo" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 1, "name" : "cid", "qname" : "components:cid", "signature" : "($component-or-id as item()) as atomic", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Converts the input to a normalized component id (CID). The input\n can be either an CID, or an component object which contains an _id.</p>\n", "summary" : "<p>  Converts the input to a normalized component id (CID).</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "component-or-id", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> an component object or an CID.</div>" } ], "returns" : { "type" : "atomic", "description" : "the normalized CID." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">components:INVALID_PARAMETER if the CID or component is not valid.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "components-for-archives", "qname" : "components:components-for-archives", "signature" : "($archive-or-ids as item()*) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves all components that belong to the supplied archives.</p>\n", "summary" : "<p>  Retrieves all components that belong to the supplied archives.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "archive-or-ids", "type" : "item()", "occurrence" : "*", "description" : "" } ], "returns" : { "type" : "object()*", "description" : "all components in the archive with this AID." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "components", "qname" : "components:components", "signature" : "() as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves all components.</p>\n", "summary" : "<p>  Retrieves all components.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "object()*", "description" : "all components." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "components", "qname" : "components:components", "signature" : "($component-or-ids as item()*) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves the components with the given CIDs.</p>\n", "summary" : "<p>  Retrieves the components with the given CIDs.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "component-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the CIDs or the components themselves.</div>" } ], "returns" : { "type" : "object()*", "description" : "the components whose _id field matches one of these CIDs." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "num-abstract-primary-items-in-hypercubes", "qname" : "components:num-abstract-primary-items-in-hypercubes", "signature" : "($components-or-ids) as integer*", "description" : " Return the number of (distinct) abstract primary items being\n in a hypercube for each of the given components.\n", "summary" : "<p> Return the number of (distinct) abstract primary items being\n in a hypercube for each of the given components.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "components-or-ids", "type" : null, "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> list of archives or IDs</div>" } ], "returns" : { "type" : "integer*", "description" : "the said number of primary items" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "num-concrete-primary-items-in-hypercubes", "qname" : "components:num-concrete-primary-items-in-hypercubes", "signature" : "($components-or-ids) as integer*", "description" : " Return the number of (distinct) concrete primary items being\n in a hypercube for each of the given components.\n", "summary" : "<p> Return the number of (distinct) concrete primary items being\n in a hypercube for each of the given components.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "components-or-ids", "type" : null, "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> list of archives or IDs</div>" } ], "returns" : { "type" : "integer*", "description" : "the said number of primary items" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "num-concrete-primary-items-not-in-hypercubes", "qname" : "components:num-concrete-primary-items-not-in-hypercubes", "signature" : "($components-or-ids) as integer*", "description" : " Return the number of (distinct) concrete primary items not being\n in a hypercube for each of the given components.\n", "summary" : "<p> Return the number of (distinct) concrete primary items not being\n in a hypercube for each of the given components.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "components-or-ids", "type" : null, "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> list of archives or IDs</div>" } ], "returns" : { "type" : "integer*", "description" : "the said number of primary items" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "num-distinct-abstract-primary-items-not-in-hypercubes", "qname" : "components:num-distinct-abstract-primary-items-not-in-hypercubes", "signature" : "($components-or-ids) as integer*", "description" : " Return the number of (distinct) abstract primary items not being\n in a hypercube for each of the given components.\n", "summary" : "<p> Return the number of (distinct) abstract primary items not being\n in a hypercube for each of the given components.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "components-or-ids", "type" : null, "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> list of archives or IDs</div>" } ], "returns" : { "type" : "integer*", "description" : "the said number of primary items" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "num-domains", "qname" : "components:num-domains", "signature" : "($components-or-ids) as integer*", "description" : " Return the number of (distinct) domains in each of the given components.\n", "summary" : "<p> Return the number of (distinct) domains in each of the given components.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "components-or-ids", "type" : null, "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> list of archives or IDs</div>" } ], "returns" : { "type" : "integer*", "description" : "the said number of domains" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "num-explicit-dimensions", "qname" : "components:num-explicit-dimensions", "signature" : "($components-or-ids) as integer*", "description" : " Return the number of (distinct) explicit dimensions in each of the given components.\n", "summary" : "<p> Return the number of (distinct) explicit dimensions in each of the given components.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "components-or-ids", "type" : null, "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> list of archives or IDs</div>" } ], "returns" : { "type" : "integer*", "description" : "the said number of dimensions" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "num-hypercubes", "qname" : "components:num-hypercubes", "signature" : "($components-or-ids as item()*) as integer*", "description" : " Return the number of hypercubes in each of the given components.\n", "summary" : "<p> Return the number of hypercubes in each of the given components.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "components-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> list of archives or IDs</div>" } ], "returns" : { "type" : "integer*", "description" : "the said number of hypercubes" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "num-members", "qname" : "components:num-members", "signature" : "($components-or-ids) as integer*", "description" : " Return the number of (distinct) members in each of the given components.\n", "summary" : "<p> Return the number of (distinct) members in each of the given components.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "components-or-ids", "type" : null, "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> list of archives or IDs</div>" } ], "returns" : { "type" : "integer*", "description" : "the said number of members" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "num-networks", "qname" : "components:num-networks", "signature" : "($components-or-ids) as integer*", "description" : " Return the number of networks in each of the given components.\n", "summary" : "<p> Return the number of networks in each of the given components.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "components-or-ids", "type" : null, "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> list of archives or IDs</div>" } ], "returns" : { "type" : "integer*", "description" : "the said number of networks" }, "errors" : [  ] } ], "variables" : [ { "name" : "components:col", "type" : "xs:string", "description" : " Name of the collection the components are stored in.\n" }, { "name" : "components:ARCHIVE", "type" : "xs:string", "description" : " Name of the field pointing to the archive.\n" } ] }, "http://jsound.io/modules/validate" : { "ns" : "http://jsound.io/modules/validate", "description" : " JSound simple validator.\n This is a JSONiq implemenation of the JSound (the schema for JSON) validator.\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Cezar Andrei</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://zorba.io/annotations", "prefix" : "an" }, { "uri" : "http://zorba.io/modules/fetch", "prefix" : "fetch" }, { "uri" : "http://jsoniq.org/functions", "prefix" : "jn" }, { "uri" : "http://jsound.io/modules/validate", "prefix" : "jsv" }, { "uri" : "http://jsound.io/modules/validate/map", "prefix" : "map" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 3, "name" : "jsd-valid", "qname" : "jsv:jsd-valid", "signature" : "($ns as string, $name as string, $instance as json-item()) as boolean", "description" : " Validates the $instance JSON item against the JSound type with name $name\n and namespace $ns, from the JSound schema definition $jsd.\n", "summary" : "<p> Validates the $instance JSON item against the JSound type with name $name\n and namespace $ns, from the JSound schema definition $jsd.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "ns", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the namespace of the expected type</div>" }, { "name" : "name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the expected type</div>" }, { "name" : "instance", "type" : "json-item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the instance to be validated</div>" } ], "returns" : { "type" : "boolean", "description" : "true if the instance is valid, otherwise throws an error." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">jsv:BadJSoundFormat If the schema is not a valid JSound schema</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">jsv:Invalid If the instance does not conform to the JSound schema</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZXQP0025 If the schema namespace URI cannot be resolved.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">jn:JNDY0021 If the loaded schema is syntactically incorrect</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 4, "name" : "jsd-valid", "qname" : "jsv:jsd-valid", "signature" : "($jsd as object(), $name as string, $ns as string, $instance as item()) as boolean", "description" : " Validates the $instance JSON item against the JSound type with name $name\n and namespace $ns, from the JSound schema definition $jsd.\n", "summary" : "<p> Validates the $instance JSON item against the JSound type with name $name\n and namespace $ns, from the JSound schema definition $jsd.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "jsd", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the JSound schema as a JSON object to be validated against</div>" }, { "name" : "name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the expected type</div>" }, { "name" : "ns", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the namespace of the expected type</div>" }, { "name" : "instance", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the instance to be validated</div>" } ], "returns" : { "type" : "boolean", "description" : "true if the instance is valid, otherwise throws an error." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">jsv:BadJSoundFormat If the schema is not a valid JSound schema</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">jsv:Invalid If the instance does not conform to the JSound schema</xqdoc:error>" ] } ], "variables" : [  ] }, "http://xbrl.io/modules/bizql/archives" : { "ns" : "http://xbrl.io/modules/bizql/archives", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This module provides functions for retrieving metadata about archives.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Archives represent the granularity of \"report shipping\", i.e., an entity\n reports one archive at a time. An archive is identified with an AID (archive ID).</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Archives are made of reported facts (see facts module),\n which are structured and organized in components (see components module).</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">With this module, you can retrieve all archives, or a certain number of archives\n with their AIDs, or obtain the AID of archives you already have. You can also retrieve\n all archives submitted by one or several entities.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Archive information is stored in a MongoDB datasource called <b>xbrl</b>.</p>\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Charles Hoffman</xqdoc:author>", "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Matthias Brantner</xqdoc:author>", "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Dennis Knochenwefel</xqdoc:author>", "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Ghislain Fourny</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://xbrl.io/modules/bizql/archives", "prefix" : "archives" }, { "uri" : "http://www.28msec.com/modules/credentials", "prefix" : "credentials" }, { "uri" : "http://xbrl.io/modules/bizql/entities", "prefix" : "entities" }, { "uri" : "http://www.w3.org/2005/xqt-errors", "prefix" : "err" }, { "uri" : "http://www.28msec.com/modules/mongodb", "prefix" : "mongo" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 1, "name" : "aid", "qname" : "archives:aid", "signature" : "($archives-or-ids as item()*) as atomic*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Converts the input to a normalized archive identifier (AID). The input\n can be either a pure AID, or an archive object which contains an AID.</p>\n", "summary" : "<p>  Converts the input to a normalized archive identifier (AID).</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "archives-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of archive objects or identifiers (AID).</div>" } ], "returns" : { "type" : "atomic*", "description" : "the normalized AIDs." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">archives:INVALID_PARAMETER if the AID or archive is not valid</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "archives-for-entities", "qname" : "archives:archives-for-entities", "signature" : "($entities-or-ids as item()*) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Return all archives created by the supplied entities.</p>\n", "summary" : "<p>  Return all archives created by the supplied entities.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "entities-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> arbitrary number of entity objects or EIDs.</div>" } ], "returns" : { "type" : "object()*", "description" : "all archives created by these entities." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "archives", "qname" : "archives:archives", "signature" : "() as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves all archives.</p>\n", "summary" : "<p>  Retrieves all archives.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "object()*", "description" : "all archives." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "archives", "qname" : "archives:archives", "signature" : "($archive-or-ids as item()*) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves the archives with the given AIDs.</p>\n", "summary" : "<p>  Retrieves the archives with the given AIDs.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "archive-or-ids", "type" : "item()", "occurrence" : "*", "description" : "" } ], "returns" : { "type" : "object()*", "description" : "the archives with the given AIDs the empty sequence if no archive was found or if the input is an empty sequence." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "entities", "qname" : "archives:entities", "signature" : "($archives-or-ids as item()*) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the entities that submitted the supplied archives.</p>\n", "summary" : "<p>  Returns the entities that submitted the supplied archives.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "archives-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of archives or their identifiers (AID).</div>" } ], "returns" : { "type" : "object()*", "description" : "the submitting entities." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "num-abstract-primary-items-in-hypercubes", "qname" : "archives:num-abstract-primary-items-in-hypercubes", "signature" : "($archives-or-ids) as integer*", "description" : " Return the number of (distinct) abstract primary items being\n in a hypercube for each of the given archives.\n", "summary" : "<p> Return the number of (distinct) abstract primary items being\n in a hypercube for each of the given archives.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "archives-or-ids", "type" : null, "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> list of archives or IDs</div>" } ], "returns" : { "type" : "integer*", "description" : "the said number of primary items" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "num-components", "qname" : "archives:num-components", "signature" : "($archives-or-ids) as integer*", "description" : " Return the number of components of each of the given archives.\n", "summary" : "<p> Return the number of components of each of the given archives.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "archives-or-ids", "type" : null, "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> list of archives or IDs</div>" } ], "returns" : { "type" : "integer*", "description" : "the said number of components" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "num-concrete-primary-items-in-hypercubes", "qname" : "archives:num-concrete-primary-items-in-hypercubes", "signature" : "($archives-or-ids) as integer*", "description" : " Return the number of (distinct) concrete primary items being\n in a hypercube for each of the given archives.\n", "summary" : "<p> Return the number of (distinct) concrete primary items being\n in a hypercube for each of the given archives.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "archives-or-ids", "type" : null, "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> list of archives or IDs</div>" } ], "returns" : { "type" : "integer*", "description" : "the said number of primary items" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "num-concrete-primary-items-not-in-hypercubes", "qname" : "archives:num-concrete-primary-items-not-in-hypercubes", "signature" : "($archives-or-ids) as integer*", "description" : " Return the number of (distinct) concrete primary items not being\n in a hypercube for each of the given archives.\n", "summary" : "<p> Return the number of (distinct) concrete primary items not being\n in a hypercube for each of the given archives.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "archives-or-ids", "type" : null, "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> list of archives or IDs</div>" } ], "returns" : { "type" : "integer*", "description" : "the said number of primary items" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "num-distinct-abstract-primary-items-not-in-hypercubes", "qname" : "archives:num-distinct-abstract-primary-items-not-in-hypercubes", "signature" : "($archives-or-ids) as integer*", "description" : " Return the number of (distinct) abstract primary items not being\n in a hypercube for each of the given archives.\n", "summary" : "<p> Return the number of (distinct) abstract primary items not being\n in a hypercube for each of the given archives.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "archives-or-ids", "type" : null, "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> list of archives or IDs</div>" } ], "returns" : { "type" : "integer*", "description" : "the said number of primary items" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "num-domains", "qname" : "archives:num-domains", "signature" : "($archives-or-ids) as integer*", "description" : " Return the number of (distinct) domains in each of the given archives.\n", "summary" : "<p> Return the number of (distinct) domains in each of the given archives.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "archives-or-ids", "type" : null, "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> list of archives or IDs</div>" } ], "returns" : { "type" : "integer*", "description" : "the said number of domains" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "num-explicit-dimensions", "qname" : "archives:num-explicit-dimensions", "signature" : "($archives-or-ids) as integer*", "description" : " Return the number of (distinct) explicit dimensions in each of the given archives.\n", "summary" : "<p> Return the number of (distinct) explicit dimensions in each of the given archives.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "archives-or-ids", "type" : null, "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> list of archives or IDs</div>" } ], "returns" : { "type" : "integer*", "description" : "the said number of dimensions" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "num-facts", "qname" : "archives:num-facts", "signature" : "($archives-or-ids) as integer*", "description" : " Return the number of facts of each of the given archives.\n", "summary" : "<p> Return the number of facts of each of the given archives.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "archives-or-ids", "type" : null, "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> list of archives or IDs</div>" } ], "returns" : { "type" : "integer*", "description" : "the said number of facts" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "num-footnotes", "qname" : "archives:num-footnotes", "signature" : "($archives-or-ids) as integer*", "description" : " Return the number of XBRL footnotes of each of the given archives.\n", "summary" : "<p> Return the number of XBRL footnotes of each of the given archives.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "archives-or-ids", "type" : null, "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> list of archives or IDs</div>" } ], "returns" : { "type" : "integer*", "description" : "the said number of footnotes" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "num-hypercubes", "qname" : "archives:num-hypercubes", "signature" : "($archives-or-ids as item()*) as integer*", "description" : " Return the number of hypercubes in each of the given archives.\n", "summary" : "<p> Return the number of hypercubes in each of the given archives.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "archives-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> list of archives or IDs</div>" } ], "returns" : { "type" : "integer*", "description" : "the said number of hypercubes" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "num-members", "qname" : "archives:num-members", "signature" : "($archives-or-ids) as integer*", "description" : " Return the number of (distinct) members in each of the given archives.\n", "summary" : "<p> Return the number of (distinct) members in each of the given archives.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "archives-or-ids", "type" : null, "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> list of archives or IDs</div>" } ], "returns" : { "type" : "integer*", "description" : "the said number of members" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "num-networks", "qname" : "archives:num-networks", "signature" : "($archives-or-ids) as integer*", "description" : " Return the number of networks in each of the given archives.\n", "summary" : "<p> Return the number of networks in each of the given archives.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "archives-or-ids", "type" : null, "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> list of archives or IDs</div>" } ], "returns" : { "type" : "integer*", "description" : "the said number of networks" }, "errors" : [  ] } ], "variables" : [ { "name" : "archives:col", "type" : "string", "description" : " Name of the collection the archives are stored in.\n" }, { "name" : "archives:ENTITY", "type" : "string", "description" : " Name of the field which points to the reporting entity.\n" } ] }, "http://www.28msec.com/modules/xmlrpc" : { "ns" : "http://www.28msec.com/modules/xmlrpc", "description" : " XML RPC Client Module\n This module provides the functions necessary to execute remote call\n procedures using\n <a xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" href=\"http://www.xmlrpc.com/spec\" target=\"_blank\">XML-RPC</a>.\n The application/mashup creator does not need to know the\n specifics of <a xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" href=\"http://www.xmlrpc.com/spec\" target=\"_blank\">XML-RPC</a> to use this module.\n Usage:\n <pre xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">xmlrpc:invoke(\"http://www.advogato.org/XMLRPC\", \"test.sumprod\", (5, 7))</pre>\n <pre xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">xmlrpc:invoke(\"http://www.advogato.org/XMLRPC\", \"test.capitalize\", \"HelloWorld\")</pre>\n <pre xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">xmlrpc:invoice(\"http://www.example.com/XMLRPC\", \"test.foo\", (\"some-parameter\",\n                      &lt;struct&gt;\n                        &lt;member&gt;\n                          &lt;name&gt;Foo&lt;/name&gt;\n                          &lt;value&gt;&lt;string&gt;Bar&lt;/string&gt;&lt;/value&gt;\n                        &lt;/member&gt;\n                      &lt;/struct&gt;))</pre>\n", "sees" : [ "<xqdoc:see xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"><a href=\"http://www.xmlrpc.com/spec\" target=\"_blank\">XML-RPC Specification</a></xqdoc:see>", "<xqdoc:see xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"><a href=\"http://en.wikipedia.org/wiki/XML-RPC\" target=\"_blank\">XML-RPC Wikipedia article</a></xqdoc:see>" ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">William Candillon {william.candillon@28msec.com}</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://zorba.io/annotations", "prefix" : "ann" }, { "uri" : "http://expath.org/ns/http-client", "prefix" : "http" }, { "uri" : "http://expath.org/ns/http-client", "prefix" : "http-client" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" }, { "uri" : "http://www.28msec.com/modules/xmlrpc", "prefix" : "xmlrpc" } ], "functions" : [ { "isDocumented" : true, "arity" : 2, "name" : "invoke", "qname" : "xmlrpc:invoke", "signature" : "($endpoint-url as xs:string, $method as xs:string) as item()*", "description" : " Invoke a remote method without parameters.\n Calling this function is equivalent to xmlrpc:invoke($url, $method, ())\n", "summary" : "<p> Invoke a remote method without parameters.</p>", "annotation_str" : " %ann:sequential", "annotations" : [ { "prefix" : "ann", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "endpoint-url", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> URL of the XML-RPC server.</div>" }, { "name" : "method", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> Name of the method to invoke.</div>" } ], "returns" : { "type" : "item()*", "description" : "Result of the method invocation." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 3, "name" : "invoke", "qname" : "xmlrpc:invoke", "signature" : "($endpoint-url as xs:string, $method as xs:string, $parameters as item()*) as item()*", "description" : " Invoke a remote method with parameters.\n", "summary" : "<p> Invoke a remote method with parameters.</p>", "annotation_str" : " %ann:sequential", "annotations" : [ { "prefix" : "ann", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "endpoint-url", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> URL of the XML-RPC server.</div>" }, { "name" : "method", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> Name of the method to invoke.</div>" }, { "name" : "parameters", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> Method parameters. Struct and Arrays need to follow XML-RPC format. Atomic types will be automatically convert to the proper XML-RPC data format.</div>" } ], "returns" : { "type" : "item()*", "description" : "Result of the method invocation." }, "errors" : [  ] } ], "variables" : [ { "name" : "xmlrpc:ERR_001", "type" : "xs:QName", "description" : " XML-RPC serialization error.\n" } ] }, "http://zorba.io/modules/unordered-maps" : { "ns" : "http://zorba.io/modules/unordered-maps", "description" : " This module defines a set of functions for working with maps. A map\n is identified by a string and can be created using the map:create function\n and dropped using the map:drop function.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n It is possible to create persistent and transient maps. The lifetime of a\n transient map is limited by the execution of the current query.\n A persistent map lives until it is explicitly dropped.\n Accordingly, it is also available to other requests.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n For example,\n <pre xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">map:create(\"my-map\", [\"string\", \"integer\"], { \"persistent\" : false })</pre>\n will create a transient map named my-map having two keys.\n The types of the keys are string and integer.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The key of a particular entry in the map can consist of a tuple of\n atomic values (called key attributes). The actual type of each attribute\n is determined when the map is created. The value of each entry is a\n sequence of items. If an item in this sequence is a object or array,\n this item needs to belong to a collection, otherwise, an error is raised.\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Matthias Brantner</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://zorba.io/annotations", "prefix" : "an" }, { "uri" : "http://zorba.io/modules/unordered-maps", "prefix" : "map" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" }, { "uri" : "http://zorba.io/errors", "prefix" : "zerr" } ], "functions" : [ { "isDocumented" : true, "arity" : 0, "name" : "available-maps", "qname" : "map:available-maps", "signature" : "() as string* external", "description" : " The function returns a sequence of names of the maps that are\n available (persistent and non-persistent). The sequence will be\n empty if there are no maps.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n", "summary" : "<p> The function returns a sequence of names of the maps that are\n available (persistent and non-persistent).</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "string*", "description" : "A sequence of string, one for each available map, or an empty sequence." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "create", "qname" : "map:create", "signature" : "($name as string, $key-types as item()) as empty-sequence() external", "description" : " Create a persistent map with a given name and type identifiers for the key\n attributes.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n If the map has only one key attribute, a single type identifier is given,\n for more than one key attribute an array of type identifiers is given.\n Calling this function is equivalent to calling create with the options\n <code xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">{ \"persistent\" : true }</code>\n Note that the function is sequential and immediately creates the map.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Each key-type should be specified as string (e.g. \"integer\",\n \"string\", \"boolean\", \"double\", or \"datetime\").\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n For example,\n <pre xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">map:create(\"my-map\", \"string\")</pre> or\n <pre xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">map:create(\"my-map\", [\"string\", \"integer\"])</pre>.\n", "summary" : "<p> Create a persistent map with a given name and type identifiers for the key\n attributes.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the map (the restrictions on collection names apply)</div>" }, { "name" : "key-types", "type" : "item()", "occurrence" : null, "description" : "" } ], "returns" : { "type" : "empty-sequence()", "description" : "the function is sequential and immediately creates the corresponding map. It returns the empty-sequence." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">err:XPTY0004 if any of the key attribute types is not a subtype of anyAtomicType.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZSTR0001 if a map with the given name already exists.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY1000 if the given name is not a legal collection name</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY0043 if any of the given options has an invalid type</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "create", "qname" : "map:create", "signature" : "($name as string, $key-types as item(), $options as object()) as empty-sequence() external", "description" : " Create a map with a given name, type identifiers for the key attributes, and\n options.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n If the map has only one key attribute, a single type identifier is given,\n for more than one key attribute an array of type identifiers is given.\n Currently only one option is supported: To create a transient map the object\n <code xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">{ \"persistent\" : false }</code>\n has to be passed to the $options parameter.\n Note that the function is sequential and immediately creates the map in the\n store.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Note that a map cannot be created if it already exists in a parent context.\n For example, a map that was created in an outer query cannot be\n created again in an inner query executed using the\n <code xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">reflection:eval-s</code> function.\n", "summary" : "<p> Create a map with a given name, type identifiers for the key attributes, and\n options.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the map (the restrictions on collection names apply)</div>" }, { "name" : "key-types", "type" : "item()", "occurrence" : null, "description" : "" }, { "name" : "options", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> an object describing options for the map</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "the function is sequential and immediately creates the corresponding map but returns the empty-sequence." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">err:XPTY0004 if any of the attribute types is not a subtype of anyAtomicType.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZSTR0001 if a map with the given name already exists.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY1000 if the given name is not a legal collection name</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY0043 if any of the given options has an invalid type</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "delete", "qname" : "map:delete", "signature" : "($name as string, $key as item()) as empty-sequence() external", "description" : " Removes an entry identified by the given key from the map.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n If the map has only one key attribute, a single key value is given, for\n more than one key attribute an array of key values is given.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Note that it is possible to insert entries with empty key attributes.\n However as the removing the entries is based on the \"eq\" comparison and\n as \"eq\" with an empty sequence always return false, it is not possible\n to delete these entries.\n", "summary" : "<p> Removes an entry identified by the given key from the map.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the map</div>" }, { "name" : "key", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> either a single attribute key or an array of keys</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "the function is sequential and immediately deletes the entry into the map but returns the empty-sequence." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY0023 if a map with the given name does not exist.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY0025 if the given number of key attributes does not match the number of key attributes specified when creating the map (see the map:create function).</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZXQD0005 if any of the given key attributes can not be cast (or is not a subtype) of the corresponding key attribute specified when creating the map.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "drop", "qname" : "map:drop", "signature" : "($name as string) as empty-sequence() external", "description" : " Deletes the map with the given name.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Note that a map can only be dropped in the context it was created.\n For example, a map that was created in an outer query cannot be\n dropped in an inner query executed using the\n <code xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">reflection:eval-s</code> function.\n", "summary" : "<p> Deletes the map with the given name.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the map to drop</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "the function is sequential and immediately drops the map. It returns the empty-sequence." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY0023 if a map with the given name does not exist.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "get", "qname" : "map:get", "signature" : "($name as string, $key as item()) as item()* external", "description" : " Returns the value of the entry with the given key from the map.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n If the map has only one key attribute, a single key value is given, for\n more than one key attribute an array of key values is given.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Note that it is possible to insert entries with empty key attributes.\n However as the getting the entries is based on the \"eq\" comparison and\n as \"eq\" with an empty sequence always return false, it is not possible\n to retrieve these entries.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n For example,\n <pre xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">map:get(\"my-map\", \"key\")</pre> or\n <pre xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">map:get(\"my-map\", [ \"key1\", \"key2\" ])</pre>.\n", "summary" : "<p> Returns the value of the entry with the given key from the map.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the map</div>" }, { "name" : "key", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> either a single attribute key or an array of keys</div>" } ], "returns" : { "type" : "item()*", "description" : "the value of the entry in the map identified by the given key. The empty-sequence will be returned if no entry with the given key is contained in the map." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY0023 if a map with the given name does not exist.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY0025 if the given number of key attributes does not match the number of key attributes specified when creating the map (see the map:create function).</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZXQD0005 if any of the given key attributes can not be cast (or is not a subtype) of the corresponding key attribute specified when creating the map.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "insert", "qname" : "map:insert", "signature" : "($name as string, $key as item(), $value as item()*) as empty-sequence() external", "description" : " Inserts a new entry into the map with the given name.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n If the map has only one key attribute, a single key value is given, for\n more than one key attribute an array of key values is given.\n If an entry with the given key already exists in the map, the value\n sequences of the existing entry and the sequence passed using $value\n argument are concatenated.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n If an item in the value sequence is an object or array, this\n item needs to belong to a collection, otherwise, an an error\n is raised.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Note that it is possible to insert entries with empty key attributes\n or key attributes having the value <code xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">null</code>. However, as\n the comparison with an empty sequence or null always returns false,\n it is not possible to retrieve these entries.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n For example,\n <pre xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">map:insert(\"my-map\", \"key\", \"value\")</pre> or\n <pre xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">map:insert(\"my-map\", [ \"key1\", \"key2\" ] , (42, \"value\"))</pre>.\n", "summary" : "<p> Inserts a new entry into the map with the given name.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the map</div>" }, { "name" : "key", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> either a single attribute key or an array of keys</div>" }, { "name" : "value", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the value of the entry to insert</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "the function is sequential and immediately inserts the entry into the map. It returns the empty-sequence." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY0023 if a map with the given name does not exist.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY0025 if the given number of key attributes does not match the number of key attributes specified when creating the map (see the map:create function).</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZXQD0005 if any of the given key attributes can not be cast (or is not a subtype) of the corresponding key attribute specified when creating the map.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY1003 if the value to insert is an object or array it must belong to a collection.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "keys", "qname" : "map:keys", "signature" : "($name as string) as array()* external", "description" : " Returns the keys of all entries of a map. The keys\n are returned as sequence of arrays.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The following condition always holds:\n <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">map:size($name) eq count(map:keys($name))</tt>\n", "summary" : "<p> Returns the keys of all entries of a map.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the map</div>" } ], "returns" : { "type" : "array()*", "description" : "an sequence of arrays each array containing the values of all attributes of one key." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY0023 if a map with the given name does not exist.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "options", "qname" : "map:options", "signature" : "($name as string) as object() external", "description" : " The function returns the options that were passed during creation or the\n default options if no options were passed.\n", "summary" : "<p> The function returns the options that were passed during creation or the\n default options if no options were passed.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the map</div>" } ], "returns" : { "type" : "object()", "description" : "an options object" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY0023 if a map with the given name does not exist.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "size", "qname" : "map:size", "signature" : "($name as string) as integer external", "description" : " Returns the number of entries in a map.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The following condition always holds:\n <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">map:size($name) eq count(map:keys($name))</tt>\n", "summary" : "<p> Returns the number of entries in a map.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the map</div>" } ], "returns" : { "type" : "integer", "description" : "the number of entries in the map." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY0023 if a map with the given name does not exist.</xqdoc:error>" ] } ], "variables" : [ { "name" : "map:PERSISTENT", "type" : "string", "description" : " Constant containing the field name of the options object\n indiciating whether a map is persistent or transient.\n" } ] }, "http://www.28msec.com/modules/assertion" : { "ns" : "http://www.28msec.com/modules/assertion", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n   This module provides a set of assertion functions.\n </p>\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">28msec</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://zorba.io/annotations", "prefix" : "an" }, { "uri" : "http://www.28msec.com/modules/assertion", "prefix" : "assertion" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 2, "name" : "equals-deep", "qname" : "assertion:equals-deep", "signature" : "($expected as item()*, $actual as item()*) as item()*", "description" : " Asserts that two objects are deep-equal.\n If they are not, an error containing the diff is raised.\n", "summary" : "<p> Asserts that two objects are deep-equal.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "expected", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> expected value</div>" }, { "name" : "actual", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> actual value</div>" } ], "returns" : { "type" : "item()*", "description" : "actual value" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">assertion:A003 expected and actual value are not deep-equal</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "equals-general", "qname" : "assertion:equals-general", "signature" : "($expected as item()*, $actual as item()*) as item()*", "description" : " Asserts that two objects are equal (by general comarison).\n If they are not, an error containing the diff is raised.\n", "summary" : "<p> Asserts that two objects are equal (by general comarison).</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "expected", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> expected value</div>" }, { "name" : "actual", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> actual value</div>" } ], "returns" : { "type" : "item()*", "description" : "actual value" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">assertion:A002 expected and actual value are not equal</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "equals-value", "qname" : "assertion:equals-value", "signature" : "($expected as item()?, $actual as item()?) as item()?", "description" : " Asserts that two objects are equal (by value comparison).\n If they are not, an error containing the diff is raised.\n", "summary" : "<p> Asserts that two objects are equal (by value comparison).</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "expected", "type" : "item()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> expected value</div>" }, { "name" : "actual", "type" : "item()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> actual value</div>" } ], "returns" : { "type" : "item()?", "description" : "actual value" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">assertion:A001 expected and actual value are not equal</xqdoc:error>" ] } ], "variables" : [ { "name" : "assertion:A001", "type" : "xs:QName", "description" : " xs:QName with namespace URI=\"http://www.28msec.com/modules/assertion\" and\n local name 'A001'. 'equals-value' assertion failed.\n" }, { "name" : "assertion:A002", "type" : "xs:QName", "description" : " xs:QName with namespace URI=\"http://www.28msec.com/modules/assertion\" and\n local name 'A002'. 'equals-general' assertion failed.\n" }, { "name" : "assertion:A003", "type" : "xs:QName", "description" : " xs:QName with namespace URI=\"http://www.28msec.com/modules/assertion\" and\n local name 'A003'. 'equals-general' assertion failed.\n" } ] }, "http://www.zorba-xquery.com/modules/image/basic" : { "ns" : "http://www.zorba-xquery.com/modules/image/basic", "description" : " This module provides function to do the following basic image operations:\n <ul xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n   <li>create empty images</li>\n   <li>compare images</li>\n   <li>compress image</li>\n   <li>convert an image one format to another</li>\n   <li>retrieve with, height, format, and exif information from an image</li>\n </ul>\n The following image formats are supported:\n <ul xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n   <li>GIF</li>\n   <li>JPEG</li>\n   <li>PNG</li>\n   <li>TIFF</li>\n   <li>BMP</li>\n </ul>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The errors raised by functions of this module have the namespace\n <tt>http://www.zorba-xquery.com/modules/image/error</tt> (associated with prefix ierr).</p>\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Daniel Thomas</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://www.zorba-xquery.com/modules/image/basic", "prefix" : "basic" }, { "uri" : "http://www.w3.org/2005/xqt-errors", "prefix" : "err" }, { "uri" : "http://www.zorba-xquery.com/modules/image/error", "prefix" : "ierr" }, { "uri" : "http://www.zorba-xquery.com/modules/image/image", "prefix" : "image" }, { "uri" : "http://www.w3.org/2000/svg", "prefix" : "svg" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 2, "name" : "compress", "qname" : "basic:compress", "signature" : "($image as xs:base64Binary, $quality as xs:unsignedInt) as xs:base64Binary external", "description" : " Compresses the passed image.\n Compressing means lowering the quality and reducing the size.\n", "summary" : "<p> Compresses the passed image.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "image", "type" : "xs:base64Binary", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the image</div>" }, { "name" : "quality", "type" : "xs:unsignedInt", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> compression level, 0 to 100</div>" } ], "returns" : { "type" : "xs:base64Binary", "description" : "the compressed image" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">ierr:IM001 the passed image is invalid.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "convert-svg-string", "qname" : "basic:convert-svg-string", "signature" : "($svg as xs:string, $format as xs:string) as xs:base64Binary", "description" : " Converts an SVG image to a supported image format.\n", "summary" : "<p> Converts an SVG image to a supported image format.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "svg", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the image to convert as string</div>" }, { "name" : "format", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> target format</div>" } ], "returns" : { "type" : "xs:base64Binary", "description" : "the resulting image" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">ierr:IM001 the passed SVG is invalid.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "convert-svg", "qname" : "basic:convert-svg", "signature" : "($svg as element(svg:svg), $format as xs:string) as xs:base64Binary", "description" : " Converts an SVG image to a supported image format.\n", "summary" : "<p> Converts an SVG image to a supported image format.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "svg", "type" : "element(svg:svg)", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the image to convert</div>" }, { "name" : "format", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> target format</div>" } ], "returns" : { "type" : "xs:base64Binary", "description" : "the resulting image" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">ierr:IM001 the passed SVG is invalid.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "convert", "qname" : "basic:convert", "signature" : "($image as xs:base64Binary, $format as xs:string) as xs:base64Binary", "description" : " Converts an image to another format.\n", "summary" : "<p> Converts an image to another format.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "image", "type" : "xs:base64Binary", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the source image</div>" }, { "name" : "format", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the format (see supported formats above) of the resulting image.</div>" } ], "returns" : { "type" : "xs:base64Binary", "description" : "A new image with the same content as the passed image but with the specified file format." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">ierr:IM001 the passed image is invalid.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">err:FORG0001 unsupported image format</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "create", "qname" : "basic:create", "signature" : "($width as xs:unsignedInt, $height as xs:unsignedInt, $format as xs:string) as xs:base64Binary", "description" : " Creates an empty image with background color white.\n", "summary" : "<p> Creates an empty image with background color white.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "width", "type" : "xs:unsignedInt", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the width of the new image</div>" }, { "name" : "height", "type" : "xs:unsignedInt", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the height of the new image</div>" }, { "name" : "format", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the format of the new image</div>" } ], "returns" : { "type" : "xs:base64Binary", "description" : "newly created image" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">err:FORG0001 unsupported image format</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "equals", "qname" : "basic:equals", "signature" : "($image1 as xs:base64Binary, $image2 as xs:base64Binary) as xs:boolean external", "description" : " Compares two images.\n", "summary" : "<p> Compares two images.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "image1", "type" : "xs:base64Binary", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> first image</div>" }, { "name" : "image2", "type" : "xs:base64Binary", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> second image</div>" } ], "returns" : { "type" : "xs:boolean", "description" : "True if the images are equal." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">ierr:IM001 one of the passed images is invalid.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "exif", "qname" : "basic:exif", "signature" : "($image as xs:base64Binary, $tag as xs:string) as xs:string? external", "description" : " Reads exif information from an image.\n This function works for JPEG and TIFF images only.\n It returns empty sequence if no exif information matching the passed tag is found.\n", "summary" : "<p> Reads exif information from an image.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "image", "type" : "xs:base64Binary", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the image</div>" }, { "name" : "tag", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the field name we want read (e.g. DateTime).</div>" } ], "returns" : { "type" : "xs:string?", "description" : "exif field content" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">ierr:IM001 the passed image is invalid.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "format", "qname" : "basic:format", "signature" : "($image as xs:base64Binary) as xs:string external", "description" : " Returns the format of the passed image.\n", "summary" : "<p> Returns the format of the passed image.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "image", "type" : "xs:base64Binary", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the image</div>" } ], "returns" : { "type" : "xs:string", "description" : "the format" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">ierr:IM001 the passed image is invalid.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "height", "qname" : "basic:height", "signature" : "($image as xs:base64Binary) as xs:unsignedInt external", "description" : " Returns the height of the passed image.\n", "summary" : "<p> Returns the height of the passed image.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "image", "type" : "xs:base64Binary", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the image</div>" } ], "returns" : { "type" : "xs:unsignedInt", "description" : "the height in pixels" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">ierr:IM001 the passed image is invalid.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "width", "qname" : "basic:width", "signature" : "($image as xs:base64Binary) as xs:unsignedInt external", "description" : " Returns the width of the passed image.\n", "summary" : "<p> Returns the width of the passed image.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "image", "type" : "xs:base64Binary", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the image</div>" } ], "returns" : { "type" : "xs:unsignedInt", "description" : "the width in pixels" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">ierr:IM001 the passed image is invalid.</xqdoc:error>" ] } ], "variables" : [  ] }, "http://api.28.io/indices" : { "ns" : "http://api.28.io/indices", "description" : "", "sees" : [  ], "authors" : [  ], "version" : null, "encoding" : null, "namespaces" : [ { "uri" : "", "prefix" : "an" }, { "uri" : "http://api.28.io/indices", "prefix" : "in" }, { "uri" : "http://www.28msec.com/modules/http/request", "prefix" : "req" }, { "uri" : "http://www.28msec.com/modules/http/response", "prefix" : "resp" }, { "uri" : "http://api.28.io/util", "prefix" : "util" }, { "uri" : "http://api.28.io/validation", "prefix" : "validate" } ], "functions" : [ { "isDocumented" : false, "arity" : 1, "name" : "create-index", "qname" : "in:create-index", "signature" : "($new-index as object()) as empty-sequence()", "description" : "", "summary" : "", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "new-index", "type" : "object()", "occurrence" : null, "description" : "" } ], "returns" : { "type" : "empty-sequence()", "description" : "" }, "errors" : [  ] }, { "isDocumented" : false, "arity" : 1, "name" : "delete-index", "qname" : "in:delete-index", "signature" : "($name) as empty-sequence()", "description" : "", "summary" : "", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "name", "type" : null, "occurrence" : null, "description" : "" } ], "returns" : { "type" : "empty-sequence()", "description" : "" }, "errors" : [  ] }, { "isDocumented" : false, "arity" : 0, "name" : "dispatch", "qname" : "in:dispatch", "signature" : "()", "description" : "", "summary" : "", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [  ], "returns" : { "type" : null, "description" : "" }, "errors" : [  ] }, { "isDocumented" : false, "arity" : 1, "name" : "get-index", "qname" : "in:get-index", "signature" : "($name as xs:string) as object()?", "description" : "", "summary" : "", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "name", "type" : "xs:string", "occurrence" : null, "description" : "" } ], "returns" : { "type" : "object()?", "description" : "" }, "errors" : [  ] }, { "isDocumented" : false, "arity" : 0, "name" : "list-indices", "qname" : "in:list-indices", "signature" : "() as array()", "description" : "", "summary" : "", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "array()", "description" : "" }, "errors" : [  ] }, { "isDocumented" : false, "arity" : 0, "name" : "metadata", "qname" : "in:metadata", "signature" : "()", "description" : "", "summary" : "", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : null, "description" : "" }, "errors" : [  ] }, { "isDocumented" : false, "arity" : 2, "name" : "put-index", "qname" : "in:put-index", "signature" : "($name as xs:string, $new-index-obj as object()) as empty-sequence()", "description" : "", "summary" : "", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "name", "type" : "xs:string", "occurrence" : null, "description" : "" }, { "name" : "new-index-obj", "type" : "object()", "occurrence" : null, "description" : "" } ], "returns" : { "type" : "empty-sequence()", "description" : "" }, "errors" : [  ] }, { "isDocumented" : false, "arity" : 1, "name" : "refresh-index", "qname" : "in:refresh-index", "signature" : "($index as xs:string) as empty-sequence()", "description" : "", "summary" : "", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "index", "type" : "xs:string", "occurrence" : null, "description" : "" } ], "returns" : { "type" : "empty-sequence()", "description" : "" }, "errors" : [  ] }, { "isDocumented" : false, "arity" : 1, "name" : "validate-index", "qname" : "in:validate-index", "signature" : "($index as object()) as empty-sequence()", "description" : "", "summary" : "", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "index", "type" : "object()", "occurrence" : null, "description" : "" } ], "returns" : { "type" : "empty-sequence()", "description" : "" }, "errors" : [  ] } ], "variables" : [  ] }, "http://api.28.io/xdmview" : { "ns" : "http://api.28.io/xdmview", "description" : "", "sees" : [  ], "authors" : [  ], "version" : null, "encoding" : null, "namespaces" : [ { "uri" : "", "prefix" : "an" }, { "uri" : "http://api.28.io/model", "prefix" : "model" }, { "uri" : "http://zorba.io/modules/reference", "prefix" : "ref" }, { "uri" : "http://www.zorba-xquery.com/schemas/xdm", "prefix" : "xdm" }, { "uri" : "http://api.28.io/xdmview", "prefix" : "xdmview" } ], "functions" : [ { "isDocumented" : false, "arity" : 1, "name" : "show-namespaces", "qname" : "xdmview:show-namespaces", "signature" : "($namespaces)", "description" : "", "summary" : "", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "namespaces", "type" : null, "occurrence" : null, "description" : "" } ], "returns" : { "type" : null, "description" : "" }, "errors" : [  ] }, { "isDocumented" : false, "arity" : 3, "name" : "show-node", "qname" : "xdmview:show-node", "signature" : "($node, $namespaces, $include-noderef as xs:boolean)", "description" : "", "summary" : "", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "node", "type" : null, "occurrence" : null, "description" : "" }, { "name" : "namespaces", "type" : null, "occurrence" : null, "description" : "" }, { "name" : "include-noderef", "type" : "xs:boolean", "occurrence" : null, "description" : "" } ], "returns" : { "type" : null, "description" : "" }, "errors" : [  ] }, { "isDocumented" : false, "arity" : 2, "name" : "show-nodes", "qname" : "xdmview:show-nodes", "signature" : "($nodes, $include-noderef as xs:boolean)", "description" : "", "summary" : "", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "nodes", "type" : null, "occurrence" : null, "description" : "" }, { "name" : "include-noderef", "type" : "xs:boolean", "occurrence" : null, "description" : "" } ], "returns" : { "type" : null, "description" : "" }, "errors" : [  ] } ], "variables" : [  ] }, "http://www.zorba-xquery.com/modules/xqdoc/json" : { "ns" : "http://www.zorba-xquery.com/modules/xqdoc/json", "description" : " Convert an XQDoc document into an HTML document.\n This module contains a single <code xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">convert()</code> function\n that transform an XQDoc document into an HTML document.\n Usage:\n <pre xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" class=\"ace-static\" ace-mode=\"xquery\">\n let $xqdoc := xqdoc:xqdoc(\"http://expath.org/ns/file\")\n return html:convert($xqdoc)\n </pre>\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">William Candillon <a href=\"?anchor=\">wcandillon at gmail dot com</a></xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://www.zorba-xquery.com/modules/xqdoc/json", "prefix" : "html" }, { "uri" : "http://www.w3.org/2010/xslt-xquery-serialization", "prefix" : "o" }, { "uri" : "http://www.xqdoc.org/1.0", "prefix" : "xq" } ], "functions" : [ { "isDocumented" : false, "arity" : 1, "name" : "convert", "qname" : "html:convert", "signature" : "($xqdoc as element(xq:xqdoc)) as object()", "description" : "", "summary" : "", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "xqdoc", "type" : "element(xq:xqdoc)", "occurrence" : null, "description" : "" } ], "returns" : { "type" : "object()", "description" : "" }, "errors" : [  ] }, { "isDocumented" : false, "arity" : 1, "name" : "normalize-anchors", "qname" : "html:normalize-anchors", "signature" : "($node)", "description" : "", "summary" : "", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "node", "type" : null, "occurrence" : null, "description" : "" } ], "returns" : { "type" : null, "description" : "" }, "errors" : [  ] } ], "variables" : [  ] }, "http://zorba.io/modules/math" : { "ns" : "http://zorba.io/modules/math", "description" : " Extensive math library.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Daniel Turcanu, Dan Muresan</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://www.w3.org/2005/xpath-functions/math", "prefix" : "W3Cmath" }, { "uri" : "http://zorba.io/modules/math", "prefix" : "math" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 1, "name" : "acosh", "qname" : "math:acosh", "signature" : "($arg as double) as double external", "description" : " Inverse hyperbolic cosine.\n", "summary" : "<p> Inverse hyperbolic cosine.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "arg", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the arg</div>" } ], "returns" : { "type" : "double", "description" : "the result of acosh(arg)" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "asinh", "qname" : "math:asinh", "signature" : "($arg as double) as double external", "description" : " Calculate the inverse hyperbolic sine.\n", "summary" : "<p> Calculate the inverse hyperbolic sine.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "arg", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the arg</div>" } ], "returns" : { "type" : "double", "description" : "the result of asinh(arg)" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "atanh", "qname" : "math:atanh", "signature" : "($arg as double) as double external", "description" : " Calculate the hyperbolic tangent.\n", "summary" : "<p> Calculate the hyperbolic tangent.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "arg", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> must be in range -1 ... +1 (exclusive)</div>" } ], "returns" : { "type" : "double", "description" : "the result of atanh(arg)" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "avedev", "qname" : "math:avedev", "signature" : "($numbers as double+) as double", "description" : " Returns the average of the absolute deviations of data points from their mean.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The formula is sum(abs(x - average_x))/n, where n is the count of x in the sequence.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Returns the average of the absolute deviations of data points from their mean.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "double", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers. Sequence can be of any length from 1 up.</div>" } ], "returns" : { "type" : "double", "description" : "The formula result" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "cast-as-numeric", "qname" : "math:cast-as-numeric", "signature" : "($number as anyAtomicType) as anyAtomicType", "description" : " Cast the anyAtomicType to a numeric type.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n If the value is already of a numeric type then nothing is changed.\n Otherwise the value is casted to the numeric type that is most appropriate.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Cast the anyAtomicType to a numeric type.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "number", "type" : "anyAtomicType", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The parameter can be a number, string, boolean value.</div>" } ], "returns" : { "type" : "anyAtomicType", "description" : "The casted value." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">math:VALUE_NOT_NUMERIC if the value cannot be casted to numeric type.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "ceiling", "qname" : "math:ceiling", "signature" : "($number as double, $significance as double) as double", "description" : " Returns number rounded up, away from zero, to the nearest multiple of significance.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Significance must have the same sign as number.\n Number and significance must be of a numeric type or castable to numeric.\n Significance must not be zero.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Returns number rounded up, away from zero, to the nearest multiple of significance.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "number", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The value you want to round.</div>" }, { "name" : "significance", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The multiple to which you want to round.</div>" } ], "returns" : { "type" : "double", "description" : "The rounded value." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">math:INVALID_ARGUMENT if significance is zero or it doesn't have the same sign as number.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "cosh", "qname" : "math:cosh", "signature" : "($arg as double) as double external", "description" : " Returns the hyperbolic cosine of x.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n If the result it too large, INF is returned.\n", "summary" : "<p> Returns the hyperbolic cosine of x.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "arg", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> must be smaller than 7.104760e+002</div>" } ], "returns" : { "type" : "double", "description" : "cosh(arg)" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "deg-to-rad", "qname" : "math:deg-to-rad", "signature" : "($deg as double) as double", "description" : " Convert angle from degrees to radians. <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The parameter is first converted to value range of (-360, 360).\n", "summary" : "<p> Convert angle from degrees to radians.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "deg", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> angle in degrees</div>" } ], "returns" : { "type" : "double", "description" : "value in radians (-2PI, 2PI)" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "even", "qname" : "math:even", "signature" : "($number as double) as integer", "description" : " Returns number rounded up to the nearest even integer.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Regardless of the sign of number, a value is rounded up when adjusted away from zero.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Returns number rounded up to the nearest even integer.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "number", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The value to round.</div>" } ], "returns" : { "type" : "integer", "description" : "The rounded value casted as numeric type." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "fact", "qname" : "math:fact", "signature" : "($number as integer) as integer", "description" : " Returns the factorial of a number.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Returns the factorial of a number.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "number", "type" : "integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The non-negative number you want the factorial of.</div>" } ], "returns" : { "type" : "integer", "description" : "Returns the factorial of a number. The factorial of a number is equal to 1*2*3*...* number." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">math:INVALID_ARGUMENT if the number is smaller than zero</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "factdouble", "qname" : "math:factdouble", "signature" : "($number as integer) as integer", "description" : " Returns the double factorial of a number.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Computes the double factorial of n as n(n-2)(n-4)...<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Returns the double factorial of a number.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "number", "type" : "integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The positive integer value.</div>" } ], "returns" : { "type" : "integer", "description" : "The result as integer." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">math:INVALID_ARGUMENT if the number is negative.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "floor", "qname" : "math:floor", "signature" : "($number as double, $significance as double) as double", "description" : " Rounds number down, toward zero, to the nearest multiple of significance.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Significance must have the same sign as number.\n Borrowed from excel module.\n", "summary" : "<p> Rounds number down, toward zero, to the nearest multiple of significance.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "number", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The value you want to round.</div>" }, { "name" : "significance", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The multiple to which you want to round.</div>" } ], "returns" : { "type" : "double", "description" : "The rounded value as numeric type." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">math:INVALID_ARGUMENT if significance is zero or it doesn't have the same sign as number.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "fmod", "qname" : "math:fmod", "signature" : "($x as double, $y as double) as double external", "description" : " Function performing the modulo operation between the two arguments.\n", "summary" : "<p> Function performing the modulo operation between the two arguments.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "x", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the x</div>" }, { "name" : "y", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the y</div>" } ], "returns" : { "type" : "double", "description" : "The remainder of x/y." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "frexp", "qname" : "math:frexp", "signature" : "($arg as double) as double+ external", "description" : " Returns the argument split as mantissa and exponent.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The recombining formula is (mantissa * 2^exponent).\n", "summary" : "<p> Returns the argument split as mantissa and exponent.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "arg", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the double to be split.</div>" } ], "returns" : { "type" : "double+", "description" : "A sequence of two doubles (mantissa, exponent)" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "gcd", "qname" : "math:gcd", "signature" : "($numbers as integer+) as integer", "description" : " Returns the greatest common divisor GCD of a sequence of integers.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The sequence can have one or more positive integers.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Returns the greatest common divisor GCD of a sequence of integers.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "integer", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The sequence of positive integers.</div>" } ], "returns" : { "type" : "integer", "description" : "The GCD as integer." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">math:INVALID_ARGUMENT if any number is smaller than zero.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "int", "qname" : "math:int", "signature" : "($number as double) as integer", "description" : " Rounds a number down to the nearest integer.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Positive numbers are rounded toward zero, negative numbers are rounded away from zero.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Rounds a number down to the nearest integer.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "number", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The value to be rounded.</div>" } ], "returns" : { "type" : "integer", "description" : "The rounded integer." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "is-a-number", "qname" : "math:is-a-number", "signature" : "($value as anyAtomicType) as boolean", "description" : " Checks if the anyAtomicType argument is actually a numeric type\n or can be converted to numeric.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Checks if the anyAtomicType argument is actually a numeric type\n or can be converted to numeric.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "value", "type" : "anyAtomicType", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> Parameter to be checked.</div>" } ], "returns" : { "type" : "boolean", "description" : "true if the value can be casted to numeric." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "is_inf", "qname" : "math:is_inf", "signature" : "($arg as double) as boolean external", "description" : " Checks if the double value is positive or negative infinite.\n", "summary" : "<p> Checks if the double value is positive or negative infinite.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "arg", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the double to be checked</div>" } ], "returns" : { "type" : "boolean", "description" : "boolean true if argument is pos INF or neg INF" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "is_nan", "qname" : "math:is_nan", "signature" : "($arg as double) as boolean external", "description" : " Checks if the double value is Not a Number (NaN).\n", "summary" : "<p> Checks if the double value is Not a Number (NaN).</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "arg", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the arg</div>" } ], "returns" : { "type" : "boolean", "description" : "boolean true if the double is NaN" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "large", "qname" : "math:large", "signature" : "($numbers as double+, $k as integer) as double", "description" : " Returns the k-th largest value in a data set. <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n If n is the number of data points in a range,\n   then LARGE(array,1) returns the largest value,\n   and LARGE(array,n) returns the smallest value.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.<br xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n", "summary" : "<p> Returns the k-th largest value in a data set.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "double", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers The sequence can be of any length, from 1 up.</div>" }, { "name" : "k", "type" : "integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the position of largest value, with value from 1 to count of values</div>" } ], "returns" : { "type" : "double", "description" : "The k-th largest value as numeric type" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">math:INVALID_ARGUMENT if the sequence is empty or k is not a value between 1 and the size of the sequence</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "lcm", "qname" : "math:lcm", "signature" : "($numbers as integer+) as integer", "description" : " Returns the least common multiple of integers.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n LCM for two numbers is computed by multiplying them and dividing with GCD.\n The function is applied recursively replacing the first two numbers in the sequence with their LCM.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Returns the least common multiple of integers.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "integer", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The sequence of one or more positive integers.</div>" } ], "returns" : { "type" : "integer", "description" : "The LCM as integer." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">math:INVALID_ARGUMENT if any number is smaller than zero.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "ldexp", "qname" : "math:ldexp", "signature" : "($x as double, $i as integer) as double external", "description" : " Computes a real number from the mantissa and exponent.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The formula is (x * 2^i).\n", "summary" : "<p> Computes a real number from the mantissa and exponent.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "x", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the mantissa</div>" }, { "name" : "i", "type" : "integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the exponent</div>" } ], "returns" : { "type" : "double", "description" : "the computed real number" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "median", "qname" : "math:median", "signature" : "($numbers as double*) as double", "description" : " Returns the median of the given numbers. <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The median is the number in the middle of a set of numbers.\n Half the numbers have values that are greater than the median,\n and half the numbers have values that are less than the median. <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Returns the median of the given numbers.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "double", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers, of any length</div>" } ], "returns" : { "type" : "double", "description" : "for odd count of numbers return the number in the middle of the sorted sequence. For even count of numbers return the average of the two numbers in the middle." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "mod", "qname" : "math:mod", "signature" : "($number as double, $divisor as double) as double", "description" : " Returns the remainder after number is divided by divisor.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The result has the same sign as divisor.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Returns the remainder after number is divided by divisor.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "number", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The number for which you want to find the remainder.</div>" }, { "name" : "divisor", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The number by which you want to divide number. This cannot be zero.</div>" } ], "returns" : { "type" : "double", "description" : "The remainder from division as numeric type." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">math:DIVIDE_BY_0 if divisor is zero after casting to numeric.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "mode", "qname" : "math:mode", "signature" : "($numbers as double*) as double", "description" : " Returns the most frequently occurring, or repetitive, value in a sequence.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Returns the most frequently occurring, or repetitive, value in a sequence.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "double", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers, of any length</div>" } ], "returns" : { "type" : "double", "description" : "The most occuring number" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">math:INVALID_INPUT if there are no duplicate numbers</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "modf", "qname" : "math:modf", "signature" : "($arg as double) as double+ external", "description" : " Splits a floating-point value into fractional and integer parts.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Both the fraction and integer keep the original sign of the value.\n", "summary" : "<p> Splits a floating-point value into fractional and integer parts.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "arg", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the double to be split.</div>" } ], "returns" : { "type" : "double+", "description" : "A sequence of two doubles (fraction, integer)" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "mround", "qname" : "math:mround", "signature" : "($number as decimal, $multiple as double) as double", "description" : " Returns a number rounded to the desired multiple.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n MROUND rounds up, away from zero, if the remainder of dividing number by multiple\n is greater than or equal to half the value of multiple.\n MROUND is computed through math:floor function.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Returns a number rounded to the desired multiple.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "number", "type" : "decimal", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The value to round,</div>" }, { "name" : "multiple", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The multiple to which you want to round number.</div>" } ], "returns" : { "type" : "double", "description" : "The rounded number up to the desired multiple." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "odd", "qname" : "math:odd", "signature" : "($number as double) as integer", "description" : " Returns number rounded up to the nearest odd integer, away from zero.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Returns number rounded up to the nearest odd integer, away from zero.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "number", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The value to round.</div>" } ], "returns" : { "type" : "integer", "description" : "The odd integer." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "percentile", "qname" : "math:percentile", "signature" : "($numbers as double*, $k_at as double) as double", "description" : " Returns the k-th percentile of values in a sequence.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n If k is not a multiple of 1/(n - 1),\n   PERCENTILE interpolates to determine the value at the k-th percentile.\n The function is computed by (max-min)*k + min<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Returns the k-th percentile of values in a sequence.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "double", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers, of any length</div>" }, { "name" : "k_at", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the percentile, with value between 0 .. 1 inclusive</div>" } ], "returns" : { "type" : "double", "description" : "The computed percentile" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">math:INVALID_ARGUMENT if percentile is not between 0 .. 1</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "percentrank", "qname" : "math:percentrank", "signature" : "($numbers as double*, $x as double) as double", "description" : " Returns the rank of a value in a data set as a percentage of the data set.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n If x does not match one of the values in array,\n   PERCENTRANK interpolates to return the correct percentage rank. <br xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The formula is uses: (RANK - 1) / (size - 1) .<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Returns the rank of a value in a data set as a percentage of the data set.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "double", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers. The sequence can be of any length, from 1 up.</div>" }, { "name" : "x", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> is the value for which you want to know the rank</div>" } ], "returns" : { "type" : "double", "description" : "The percentage of rank." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">math:INVALID_ARGUMENT if the sequence is zero length</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "prob", "qname" : "math:prob", "signature" : "($x_range as double+, $prob_range as double+, $range_lower_limit as double) as double", "description" : " This is the same as math:prob#4, only that upper_limit is not specified.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The probability is computed only for range_lower_limit.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> This is the same as math:prob#4, only that upper_limit is not specified.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "x_range", "type" : "double", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> is the range of numeric values of x with which there are associated probabilities. This does not need to be ordered.</div>" }, { "name" : "prob_range", "type" : "double", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> is a set of probabilities associated with values in x_range.</div>" }, { "name" : "range_lower_limit", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> is the value for which you want a probability.</div>" } ], "returns" : { "type" : "double", "description" : "The probability of the range_lower_limit value" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">math:INVALID_ARGUMENT if any probability is not between 0 and 1</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">math:INVALID_ARGUMENT if the sum of probabilities is not equal to 1</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">math:INVALID_ARGUMENT if x_range and prob_range do not have the same number of values</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 4, "name" : "prob", "qname" : "math:prob", "signature" : "($x_range as double+, $prob_range as double+, $range_lower_limit as double, $upper_limit as double) as double", "description" : " Returns the probability that values in a range are between two limits.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Returns the probability that values in a range are between two limits.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "x_range", "type" : "double", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> is the range of numeric values of x with which there are associated probabilities. This does not need to be ordered.</div>" }, { "name" : "prob_range", "type" : "double", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> is a set of probabilities associated with values in x_range.</div>" }, { "name" : "range_lower_limit", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> is the lower bound on the value for which you want a probability.</div>" }, { "name" : "upper_limit", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> is the upper bound on the value for which you want a probability.</div>" } ], "returns" : { "type" : "double", "description" : "The probability of the entire range" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">math:INVALID_ARGUMENT if any probability is not between 0 and 1</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">math:INVALID_ARGUMENT if the sum of probabilities is not equal to 1</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">math:INVALID_ARGUMENT if x_range and prob_range do not have the same number of values</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "product", "qname" : "math:product", "signature" : "($numbers as double*) as double", "description" : " Multiplies all the numbers given as arguments and returns the product.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Multiplies all the numbers given as arguments and returns the product.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "double", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The sequence of arguments convertible to numeric types. The sequence can be of any length.</div>" } ], "returns" : { "type" : "double", "description" : "The multiplication result as numeric type." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "quartile", "qname" : "math:quartile", "signature" : "($numbers as double*, $quart as integer) as double", "description" : " Returns the quartile of a data set. <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Returns the quartile of a data set.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "double", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> sequence of numbers. The sequence can be of any length, from 1 up.</div>" }, { "name" : "quart", "type" : "integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> <dl>one of the values 0, 1, 2, 3, 4 with meaning: <dt>0</dt> <dd> compute minimum value</dd> <dt>1</dt> <dd> compute first quartile (25th percentile)</dd> <dt>2</dt> <dd> compute median value (50th percentile)</dd> <dt>3</dt> <dd> compute third quartile (75th percentile)</dd> <dt>4</dt> <dd> compute maximum value</dd></dl></div>" } ], "returns" : { "type" : "double", "description" : "the computed quartile, as numeric type" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">math:INVALID_ARGUMENT if the sequence is zero length or $quart is not one of the values 0,1,3,4</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "quotient", "qname" : "math:quotient", "signature" : "($numerator as double, $denominator as double) as integer", "description" : " Returns the integer portion of a division.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Returns the integer portion of a division.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numerator", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The divider.</div>" }, { "name" : "denominator", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The divisor. It cannot be zero.</div>" } ], "returns" : { "type" : "integer", "description" : "The result value as numeric type." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">math:DIVIDE_BY_0 if denominator casted as numeric type has value zero.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "rad-to-deg", "qname" : "math:rad-to-deg", "signature" : "($rad as double) as double", "description" : " Convert angle from radians to degrees. <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n", "summary" : "<p> Convert angle from radians to degrees.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "rad", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> value in radians</div>" } ], "returns" : { "type" : "double", "description" : "value in degrees (-360, 360)" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "rank", "qname" : "math:rank", "signature" : "($x as double, $numbers as double*) as double", "description" : " This RANK function is same as the above, only that $order_ascending is set by default to false.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> This RANK function is same as the above, only that $order_ascending is set by default to false.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "x", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The number whose rank you want to find.</div>" }, { "name" : "numbers", "type" : "double", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers. The sequence can be of any length.</div>" } ], "returns" : { "type" : "double", "description" : "The rank of $x." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 3, "name" : "rank", "qname" : "math:rank", "signature" : "($x as double, $numbers as double*, $order_ascending as boolean) as double", "description" : " Returns the rank of a number in a list of numbers. <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The rank of a number is its size relative to other values in a list.\n (If you were to sort the list, the rank of the number would be its position.)\n RANK gives duplicate numbers the same rank.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Returns the rank of a number in a list of numbers.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "x", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The number whose rank you want to find.</div>" }, { "name" : "numbers", "type" : "double", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The sequence of numbers. The sequence can be of any length.</div>" }, { "name" : "order_ascending", "type" : "boolean", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> <dl>A boolean having the meaning: <dt>false</dt><dd>then rank the number as if the sequence was sorted in descending order.</dd> <dt>true</dt> <dd>then rank the number as if the sequence was sorted in ascending order.</dd></dl></div>" } ], "returns" : { "type" : "double", "description" : "The rank of $x." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "roman", "qname" : "math:roman", "signature" : "($number as integer) as string", "description" : " Converts an Arabic numeral to roman, as text.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Only the classic format is supported (out of all formats Excel requires).\n M is the largest digit, it represents 1000.\n Numbers bigger than 2000 will be represented by a sequence of \"M\".\n D = 500, C = 100, L = 50, X = 10, V = 5, I = 1.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Converts an Arabic numeral to roman, as text.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "number", "type" : "integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> A positive integer.</div>" } ], "returns" : { "type" : "string", "description" : "The roman string representation." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">math:INVALID_ARGUMENT if the input integer is negative</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "round", "qname" : "math:round", "signature" : "($number as double, $precision as integer) as double", "description" : " Rounds a number to a specified number of digits.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n If precision is greater than 0 (zero), then number is rounded\n to the specified number of decimal places.\n If num_digits is 0, then number is rounded to the nearest integer.\n If num_digits is less than 0, then number is rounded to the left of the decimal point.\n The 0.5 is rounded away from zero. <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Rounds a number to a specified number of digits.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "number", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The number to round.</div>" }, { "name" : "precision", "type" : "integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The number of decimal places to keep.</div>" } ], "returns" : { "type" : "double", "description" : "The rounded number as numeric type." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "rounddown", "qname" : "math:rounddown", "signature" : "($number as double, $precision as integer) as double", "description" : " Rounds a number down, toward zero.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n If num_digits is greater than 0 (zero), then number is rounded down\n to the specified number of decimal places.\n If num_digits is 0, then number is rounded down to the nearest integer.\n If num_digits is less than 0, then number is rounded down to the left of the decimal point. <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Rounds a number down, toward zero.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "number", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The number to round</div>" }, { "name" : "precision", "type" : "integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The number of decimal places to keep.</div>" } ], "returns" : { "type" : "double", "description" : "the truncated number toward zero, as numeric type." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "roundup", "qname" : "math:roundup", "signature" : "($number as double, $precision as integer) as double", "description" : " Rounds a number up, away from 0 (zero).<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n If num_digits is greater than 0 (zero), then number is rounded down\n to the specified number of decimal places.\n If num_digits is 0, then number is rounded down to the nearest integer.\n If num_digits is less than 0, then number is rounded down to the left of the decimal point. <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Rounds a number up, away from 0 (zero).</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "number", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The number to round</div>" }, { "name" : "precision", "type" : "integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The number of decimal places to keep.</div>" } ], "returns" : { "type" : "double", "description" : "The truncated number away from zero, as numeric type." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "sign", "qname" : "math:sign", "signature" : "($number as double) as integer", "description" : " Determines the sign of a number. <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Returns 1 if the number is positive, zero (0) if the number is 0,\n and -1 if the number is negative.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Determines the sign of a number.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "number", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The argument</div>" } ], "returns" : { "type" : "integer", "description" : "The sign as (-1, 0, 1)." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "sinh", "qname" : "math:sinh", "signature" : "($arg as double) as double external", "description" : " Calculate the hyperbolic sine.\n", "summary" : "<p> Calculate the hyperbolic sine.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "arg", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the arg</div>" } ], "returns" : { "type" : "double", "description" : "the result of sinh(arg)" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "slope", "qname" : "math:slope", "signature" : "($known_y as double+, $known_x as double+) as double", "description" : " Returns the slope of the linear regression line through data points in known_y's and known_x's.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The slope is the vertical distance divided by the horizontal distance between\n   any two points on the line, which is the rate of change along the regression line.\n It computes the formula:<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n sum((x - average_x)(y - average_y)) / sum((x - average_x)^2)<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n where average_x and average_y are computed with AVERAGE function.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Returns the slope of the linear regression line through data points in known_y's and known_x's.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "known_y", "type" : "double", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of y numbers. The sequence can be of any length, from 1 up.</div>" }, { "name" : "known_x", "type" : "double", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of x numbers. The sequence can be of any length, from 1 up.</div>" } ], "returns" : { "type" : "double", "description" : "The slope value, as numeric type" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">math:INVALID_INPUT if there are different numbers of x's and y's or if the sequence is empty</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">math:DIVIDE_BY_0 if all x's are equal</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "small", "qname" : "math:small", "signature" : "($numbers as double*, $k as integer) as double", "description" : " This function computes the k-th smallest value in a data set. <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Use this function to return values with a particular relative standing in a data set.\n If n is the number of data points in array, SMALL(array,1) equals the smallest value,\n   and SMALL(array,n) equals the largest value.\n Borrowed from excel module.\n", "summary" : "<p> This function computes the k-th smallest value in a data set.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "double", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> A sequence of numbers. The sequence can be of any length, from 1 up.</div>" }, { "name" : "k", "type" : "integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The position (from the smallest) in the sequence of data to return. Must have value between 1 and size of sequence.</div>" } ], "returns" : { "type" : "double", "description" : "The k-th smallest value of $numbers." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">math:INVALID_ARGUMENT if the sequence is zero length or $k is not a value between 1 and the size of sequence.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "sort-numbers", "qname" : "math:sort-numbers", "signature" : "($numbers as double*) as double*", "description" : " Sorts a sequence of numbers or arguments castable to numeric.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n It first casts all arguments to numeric and then sorts ascending.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Helper function.<br xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Sorts a sequence of numbers or arguments castable to numeric.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "double", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The sequence of arguments castable to numeric.</div>" } ], "returns" : { "type" : "double*", "description" : "The sorted sequence as numeric types." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 3, "name" : "standardize", "qname" : "math:standardize", "signature" : "($x as double, $mean as double, $standard_dev as double) as double", "description" : " Returns a normalized value from a distribution characterized by mean and standard_dev.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The formula is (x - mean) / standard_dev .<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Returns a normalized value from a distribution characterized by mean and standard_dev.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "x", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> is the value you want to normalize</div>" }, { "name" : "mean", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> is the arithmetic mean of the distribution.</div>" }, { "name" : "standard_dev", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> is the standard deviation of the distribution.</div>" } ], "returns" : { "type" : "double", "description" : "The normalized x, as numeric type" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">math:INVALID_ARGUMENT if standard_dev is a value smaller than zero or equal</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "stdev", "qname" : "math:stdev", "signature" : "($numbers as double+) as double", "description" : " Estimates standard deviation based on a sample. <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The standard deviation is a measure of how widely values are dispersed\n   from the average value (the mean).\n It is computed with formula:\n sqrt( sum((x-average_x)^2) / (n-1) )    = sqrt ( VAR(numbers) )<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Estimates standard deviation based on a sample.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "double", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers The sequence can be of any length, from 1 up.</div>" } ], "returns" : { "type" : "double", "description" : "the standard deviation, as numeric type" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "stdeva", "qname" : "math:stdeva", "signature" : "($numbers as double+) as double", "description" : " Estimates standard deviation based on a sample. <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The standard deviation is a measure of how widely values are dispersed\n   from the average value (the mean).\n It is computed with formula:\n sqrt( sum((x-average_x)^2) / (n-1) )    = sqrt ( VARA(numbers) )<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Estimates standard deviation based on a sample.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "double", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers. The sequence can be of any length, from 1 up.</div>" } ], "returns" : { "type" : "double", "description" : "the standard deviation, as numeric type" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "stdevp", "qname" : "math:stdevp", "signature" : "($numbers as double+) as double", "description" : " Calculates standard deviation based on the entire population given as arguments. <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The standard deviation is a measure of how widely values are dispersed from\n   the average value (the mean).\n It is computed with formula:\n sqrt( sum((x-average_x)^2) / n )    = sqrt ( VARP(numbers) )<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Calculates standard deviation based on the entire population given as arguments.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "double", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers or values castable to numeric The sequence can be of any length, from 1 up.</div>" } ], "returns" : { "type" : "double", "description" : "the standard deviation, as numeric type" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "stdevpa", "qname" : "math:stdevpa", "signature" : "($numbers as double+) as double", "description" : " Calculates standard deviation based on the entire population given as arguments. <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The standard deviation is a measure of how widely values are dispersed from\n   the average value (the mean).\n It is computed with formula:\n sqrt( sum((x-average_x)^2) / n )    = sqrt ( VARPA(numbers) )<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Calculates standard deviation based on the entire population given as arguments.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "double", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers or values castable to numeric The sequence can be of any length, from 1 up.</div>" } ], "returns" : { "type" : "double", "description" : "the standard deviation, as numeric type" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "subtotal", "qname" : "math:subtotal", "signature" : "($function_num as integer, $numbers as double*) as double", "description" : " Returns a subtotal in a sequence of numbers.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The function applied is given by $function_num.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Returns a subtotal in a sequence of numbers.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "function_num", "type" : "integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> <dl>defines the function to be applied on sequence values. The possible values are: <dt>1 or 101</dt> <dd> AVERAGE</dd> <dt>2 or 102</dt> <dd> COUNT</dd> <dt>3 or 103</dt> <dd> COUNTA</dd> <dt>4 or 104</dt> <dd> MAX</dd> <dt>5 or 105</dt> <dd> MIN</dd> <dt>6 or 106</dt> <dd> PRODUCT</dd> <dt>7 or 107</dt> <dd> STDEV</dd> <dt>8 or 108</dt> <dd> STDEVP</dd> <dt>9 or 109</dt> <dd> SUM</dd> <dt>10 or 110</dt> <dd> VAR</dd> <dt>11 or 111</dt> <dd> VARP</dd></dl> In this implementation there is no difference between x and 10x.<br/></div>" }, { "name" : "numbers", "type" : "double", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers. The sequence can be of any length.</div>" } ], "returns" : { "type" : "double", "description" : "The function result, as numeric type" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">* depends on the function called</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">math:INVALID_ARGUMENT if $function_num is not a value between 1 .. 11 or 101 .. 111</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "sumproduct", "qname" : "math:sumproduct", "signature" : "($array1 as double*, $array2 as double*) as double", "description" : " Multiplies the elements on the same position in each sequence\n and sums up the results.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Multiplies the elements on the same position in each sequence\n and sums up the results.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "array1", "type" : "double", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequences of numbers</div>" }, { "name" : "array2", "type" : "double", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequences of numbers</div>" } ], "returns" : { "type" : "double", "description" : "the sum of products" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "sumsq", "qname" : "math:sumsq", "signature" : "($numbers as double+) as double", "description" : " Returns the sum of the squares of the arguments.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n It uses the sumproduct function.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Returns the sum of the squares of the arguments.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "double", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of one or more numbers</div>" } ], "returns" : { "type" : "double", "description" : "the sum of squared values, as numeric type" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "tanh", "qname" : "math:tanh", "signature" : "($arg as double) as double external", "description" : " Calculate the hyperbolic tangent.\n", "summary" : "<p> Calculate the hyperbolic tangent.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "arg", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the arg</div>" } ], "returns" : { "type" : "double", "description" : "the result of tanh(arg)" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "trunc", "qname" : "math:trunc", "signature" : "($number as double) as integer", "description" : " Truncates a number to an integer by removing the fractional part of the number.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Truncates a number to an integer by removing the fractional part of the number.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "number", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The argument .</div>" } ], "returns" : { "type" : "integer", "description" : "The integer value." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "trunc", "qname" : "math:trunc", "signature" : "($number as double, $precision as integer) as double", "description" : " Truncates a number down to precision.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n This behaves exactly like rounddown.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Truncates a number down to precision.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "number", "type" : "double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The argument castable to numeric type.</div>" }, { "name" : "precision", "type" : "integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The number of decimal places to keep .</div>" } ], "returns" : { "type" : "double", "description" : "The integer value." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "var", "qname" : "math:var", "signature" : "($numbers as double+) as double", "description" : " Estimates variance based on a sample.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The formula is sum(x - average_x)^2 / (n - 1).\n average_x is computed with AVERAGE function.\n n is the count of numbers from the sequence, excluding empty values.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Estimates variance based on a sample.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "double", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers. The sequence can be of any length, from 1 up.</div>" } ], "returns" : { "type" : "double", "description" : "The variance, as numeric type" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "vara", "qname" : "math:vara", "signature" : "($numbers as double+) as double", "description" : " Estimates variance based on a sample.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The formula is sum(x - average_x)^2 / (n - 1).\n average_x is computed with AVERAGE function.\n n is the size of sequence, including empty values.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Estimates variance based on a sample.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "double", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers. The sequence can be of any length, from 1 up.</div>" } ], "returns" : { "type" : "double", "description" : "The variance, as numeric type" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "varp", "qname" : "math:varp", "signature" : "($numbers as double+) as double", "description" : " Calculates variance based on the entire population.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The formula is sum(x - average_x)^2 / n.\n average_x is computed with AVERAGE function.\n n is the count of numbers from the sequence, excluding empty values.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.<br xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n", "summary" : "<p> Calculates variance based on the entire population.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "double", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers. The sequence can be of any length, from 1 up.</div>" } ], "returns" : { "type" : "double", "description" : "The variance, as numeric type" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "varpa", "qname" : "math:varpa", "signature" : "($numbers as double+) as double", "description" : " Calculates variance based on the entire population.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The formula is sum(x - average_x)^2 / n.\n average_x is computed with AVERAGE function.\n n is the size of sequence, including empty values.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Borrowed from excel module.\n", "summary" : "<p> Calculates variance based on the entire population.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "double", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers. The sequence can be of any length, from 1 up.</div>" } ], "returns" : { "type" : "double", "description" : "The variance, as numeric type" }, "errors" : [  ] } ], "variables" : [  ] }, "http://www.zorba-xquery.com/modules/oauth/error" : { "ns" : "http://www.zorba-xquery.com/modules/oauth/error", "description" : " Module that defines the errors raised in Oauth modules.\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Stephanie Russell</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://www.zorba-xquery.com/modules/oauth/error", "prefix" : "oerr" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [  ], "variables" : [ { "name" : "oerr:errNS", "type" : "xs:string", "description" : " Errors namespace URI.\n" }, { "name" : "oerr:OC001", "type" : "xs:QName", "description" : " xs:QName with namespace URI=\"http://www.zorba-xquery.com/modules/oauth/errors\" and local name 'OC001'. This signing method is not implemented yet.\n" }, { "name" : "oerr:OC002", "type" : "xs:QName", "description" : " xs:QName with namespace URI=\"http://www.zorba-xquery.com/modules/oauth/errors\" and local name 'OC002'. This signing method is not supported.\n" }, { "name" : "oerr:OC003", "type" : "xs:QName", "description" : " xs:QName with namespace URI=\"http://www.zorba-xquery.com/modules/oauth/errors\" and local name 'OC003'. Http 401 error.\n" }, { "name" : "oerr:OC004", "type" : "xs:QName", "description" : " xs:QName with namespace URI=\"http://www.zorba-xquery.com/modules/oauth/errors\" and local name 'OC004'. Http 500 error.\n" }, { "name" : "oerr:OC005", "type" : "xs:QName", "description" : " xs:QName with namespace URI=\"http://www.zorba-xquery.com/modules/oauth/errors\" and local name 'OC004'. Http 500 error.\n" } ] }, "http://jsoniq.org/functions" : { "ns" : "http://jsoniq.org/functions", "description" : " This module contains all of the functions defined by the JSONiq\n specification (see http://jsoniq.org/).\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The module is always imported so you do not need to import it explicitly.\n Also, you do not need to fully qualify a function to invoke it.</p>\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Markos Zaharioudakis, Matthias Brantner, Ghislain Fourny</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://www.w3.org/2005/xqt-errors", "prefix" : "err" }, { "uri" : "http://jsoniq.org/errors", "prefix" : "jerr" }, { "uri" : "http://jsoniq.org/functions", "prefix" : "jn" }, { "uri" : "http://jsoniq.org/types", "prefix" : "js" }, { "uri" : "http://zorba.io/modules/schema", "prefix" : "schema" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 1, "name" : "decode-from-roundtrip", "qname" : "jn:decode-from-roundtrip", "signature" : "($items as item()*) as item()* external", "description" : " This function decodes non-JSON types previously encoded with\n jn:encode-for-roundtrip.\n Calling this version of the function is equivalent to calling the\n 2 argument version of the function with the second argument\n   { \"prefix\" : \"Q{http://jsoniq.org/roundtrip}\" }\n", "summary" : "<p> This function decodes non-JSON types previously encoded with\n jn:encode-for-roundtrip.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "items", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the items to be decoded.</div>" } ], "returns" : { "type" : "item()*", "description" : "the decoded items." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "decode-from-roundtrip", "qname" : "jn:decode-from-roundtrip", "signature" : "($items as item()*, $options as object()) as item()* external", "description" : " This function decodes non-JSON types previously encoded with\n jn:encode-for-roundtrip.\n The $options parameter contains options for the decoding process.\n Currently the only supported option is \"prefix\". It specifies the prefix\n that determines if this function decodes an item.\n Example:\n   jn:decode-from-roundtrip(\n     { \"nan\" : { \"pre-type\" : \"double\", \"pre-value\" : \"NaN\" } },\n     { \"prefix\" : \"pre-\" }\n   )\n returns the same instance that would be constructed by\n   { \"nan\" : double(\"NaN\") }\n So\n   let $decoded := jn:decode-from-roundtrip(\n           { \"nan\" : { \"pre-type\" : \"double\", \"pre-value\" : \"NaN\" } },\n           { \"prefix\" : \"pre-\" }\n       )\n   let $nan := $decoded(\"nan\")\n   return\n       ($nan instance of double, $nan)\n returns\n   true NaN\n", "summary" : "<p> This function decodes non-JSON types previously encoded with\n jn:encode-for-roundtrip.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "items", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the items to be decoded.</div>" }, { "name" : "options", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the decoding options.</div>" } ], "returns" : { "type" : "item()*", "description" : "the decoded items." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">jerr:JNTY0023 if $options(\"prefix\") is not a string</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "encode-for-roundtrip", "qname" : "jn:encode-for-roundtrip", "signature" : "($items as item()*) as item()* external", "description" : " This function recursively encodes non-JSON types in such a way that they\n can be serialized as JSON while keeping roundtrip capability.\n", "summary" : "<p> This function recursively encodes non-JSON types in such a way that they\n can be serialized as JSON while keeping roundtrip capability.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "items", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the items to be encoded.</div>" } ], "returns" : { "type" : "item()*", "description" : "the encoded items." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "encode-for-roundtrip", "qname" : "jn:encode-for-roundtrip", "signature" : "($items as item()*, $options as object()) as item()* external", "description" : " This function recursively encodes non-JSON types in such a way that they\n can be serialized as JSON while keeping roundtrip capability.\n Example:\n   jn:encode-for-roundtrip(\n     { \"nan\" : double(\"NaN\") },\n     { \"prefix\" : \"pre-\" }\n   )\n returns\n   { \"nan\" : { \"pre-type\" : \"double\", \"pre-value\" : \"NaN\" } }\n", "summary" : "<p> This function recursively encodes non-JSON types in such a way that they\n can be serialized as JSON while keeping roundtrip capability.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "items", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the items to be encoded.</div>" }, { "name" : "options", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the encoding options.</div>" } ], "returns" : { "type" : "item()*", "description" : "the encoded items." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">jerr:JNTY0023 if $options(\"prefix\") is not a string</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "flatten", "qname" : "jn:flatten", "signature" : "($items as item()*) as item()* external", "description" : " For each item in the given sequence, this function returns the item itself,\n if it is not an array, or a sequence of items \"flattened-out\" from the array.\n Flattening an array means replacing the array with its members, and recursively\n flattening any arrays in the members sequence.\n Note: The function is equivalent to\n   define function jn:flatten($args as item()*)\n   {\n     for $arg in args\n     return\n       if ($arg instance of array())\n       then\n         for $value in $arg[]\n         return\n           if ($value instance of array())\n           then jn:flatten($value[])\n           else $value\n       else\n         $arg\n   };\n", "summary" : "<p> For each item in the given sequence, this function returns the item itself,\n if it is not an array, or a sequence of items \"flattened-out\" from the array.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "items", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> A sequence of items</div>" } ], "returns" : { "type" : "item()*", "description" : "The flattened-out items of the arrays in $items." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "keys", "qname" : "jn:keys", "signature" : "($o as item()*) as string* external", "description" : " Returns the set of keys belonging to the objects found inside a given\n sequence of items. The keys are returned in an implementation-defined\n order. Duplicate keys are eliminated.\n", "summary" : "<p> Returns the set of keys belonging to the objects found inside a given\n sequence of items.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "o", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> A sequence of items. Only object items are actually processed; items of any other kind are simply skipped.</div>" } ], "returns" : { "type" : "string*", "description" : "The distinct keys of the objects in the input sequence." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "members", "qname" : "jn:members", "signature" : "($a as item()*) as item()* external", "description" : " Returns the items belonging to the arrays found inside a given sequence\n of items. The items are returned in an implementation-defined order.\n", "summary" : "<p> Returns the items belonging to the arrays found inside a given sequence\n of items.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "a", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> A sequence of items. Only array items are actually processed; items of any other kind are simply skipped.</div>" } ], "returns" : { "type" : "item()*", "description" : "The members of the arrays in the input sequence." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "null", "qname" : "jn:null", "signature" : "() as js:null external", "description" : " Returns the JSON null.\n", "summary" : "<p> Returns the JSON null.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "js:null", "description" : "The JSON null." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "parse-json", "qname" : "jn:parse-json", "signature" : "($j as string?) as json-item()* external", "description" : " This function parses a given string as JSON and returns a sequence\n of Objects or Arrays.\n Please note that this function allows to parse sequences of whitespace\n separated objects and arrays.\n", "summary" : "<p> This function parses a given string as JSON and returns a sequence\n of Objects or Arrays.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "j", "type" : "string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> A string containing a valid JSON text.</div>" } ], "returns" : { "type" : "json-item()*", "description" : "A sequence of JSON Object or Array item." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">jerr:JNDY0021 if the given string is not valid JSON.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "parse-json", "qname" : "jn:parse-json", "signature" : "($j as string?, $o as object()) as json-item()* external", "description" : " This function parses a given string as JSON and returns a sequence\n of Objects or Arrays.\n", "summary" : "<p> This function parses a given string as JSON and returns a sequence\n of Objects or Arrays.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "j", "type" : "string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> A string containing a valid JSON text.</div>" }, { "name" : "o", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> A JSON object defining options to configure the parser. Allowed options are <ul> <li>jsoniq-multiple-top-level-items: allow parsing of sequences of JSON Objects and Arrays (boolean; default: true)</li> <li>jsoniq-strip-top-level-array: if the top-level JSON item is an array, strip it and return its elements as multiple top-level items (boolean; default: false)</li> </ul></div>" } ], "returns" : { "type" : "json-item()*", "description" : "a sequence of JSON Object or Array item." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">jerr:JNDY0021 if the given string is not valid JSON or if jsoniq-multiple-top-level-items is false and there is additional content after the first JSON Object or Array.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">jerr:JNTY0020 if the value for the option jsoniq-multiple-top-level-items is not of type boolean.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "project", "qname" : "jn:project", "signature" : "($items as item()*, $keys as string*) as item()* external", "description" : " For each item in the given sequence, this function returns the item itself,\n if it is not an object, or its \"projected\" copy if it is an object. Projecting\n an object by a set of keys means creating a new object from the specified pairs\n of the source object. Specifically, for each key in $keys, if the object has a\n pair with that key, then a copy of that pair is included in the new object.\n", "summary" : "<p> For each item in the given sequence, this function returns the item itself,\n if it is not an object, or its \"projected\" copy if it is an object.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "items", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> A sequence of items.</div>" }, { "name" : "keys", "type" : "string", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The keys of the pairs to include from each object in $items.</div>" } ], "returns" : { "type" : "item()*", "description" : "The projection of the original sequence." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "size", "qname" : "jn:size", "signature" : "($a as array()?) as integer? external", "description" : " Returns the size of a JSON array, or the empty sequence if no array is given.\n The size of an Array is the number of members contained within it.\n", "summary" : "<p> Returns the size of a JSON array, or the empty sequence if no array is given.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "a", "type" : "array()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">rray A JSON array.</div>" } ], "returns" : { "type" : "integer?", "description" : "The number of items in $array, or the empty sequence if $array is empty." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "trim", "qname" : "jn:trim", "signature" : "($items as item()*, $keys as string*) as item()* external", "description" : " For each item in the given sequence, this function returns the item itself,\n if it is not an object, or its \"trimmed\" copy, if it is an object. Trimming\n an object by a set of keys means creating a new object containing all the\n pairs of the source object except the ones whose key appears in the given\n set of keys.\n", "summary" : "<p> For each item in the given sequence, this function returns the item itself,\n if it is not an object, or its \"trimmed\" copy, if it is an object.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "items", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> A sequence of items.</div>" }, { "name" : "keys", "type" : "string", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The keys of the pairs to exclude from each object in $items.</div>" } ], "returns" : { "type" : "item()*", "description" : "The trimmed version of the input sequence." }, "errors" : [  ] } ], "variables" : [  ] }, "http://zorba.io/modules/xqdoc" : { "ns" : "http://zorba.io/modules/xqdoc", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n The goal of xqDoc is to provide a simple vendor neutral solution for\n documenting XQuery modules, as well as tools to generate a user friendly\n presentation of this documentation and cross referencing information.\n Therefore, xqDoc proposes a new commenting convention that extends the\n currently defined XQuery comment style. This convention is modeled\n after Java's Javadoc commenting style, and provides a simple, uniform\n way to document XQuery source code. You can find more information about\n xqDoc on the website of the <a href=\"http://xqdoc.org/\">xqDoc project</a>.\n This library module provides XQDoc utility functions.\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n Generating a user friendly presentation of the documentation is\n accomplished in the following steps:\n <ol>\n  <li>Module, variable, function, collection, and index declarations need\n      to be commented using the xqDoc commenting conventions. For example,\n      this module contains xqDoc-style comments</li>\n  <li>A xqDoc-enabled processor can parse such documentation and generate\n      a vendor neutral XML document which stores all the information about\n      the code and the comments. Such a document adheres to the xqDoc\n      Schema.</li>\n  <li>The information of an XML document generated by the second step,\n      can be transformed into arbitrary presentation formats\n      (e.g. html).</li>\n </ol>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n This module implements the first and second step of this process.\n That is, Zorba can parse XQuery modules which are annotated with\n xqDoc-style documentation and generate the vendor neutral\n XML representation.\n </p>\n", "sees" : [ "<xqdoc:see xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"><a href=\"http://xqdoc.org/\" target=\"_blank\">xqDoc specification</a></xqdoc:see>", "<xqdoc:see xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"><a href=\"http://www.zorba-xquery.com/tutorials/xqdoc.html\" target=\"_blank\">xqDoc tutorial with Zorba</a></xqdoc:see>" ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Gabriel Petrovay</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://zorba.io/annotations", "prefix" : "an" }, { "uri" : "http://www.w3.org/2005/xqt-errors", "prefix" : "err" }, { "uri" : "http://zorba.io/modules/fetch", "prefix" : "fetch" }, { "uri" : "http://zorba.io/modules/xqdoc-options", "prefix" : "opt" }, { "uri" : "http://zorba.io/modules/schema", "prefix" : "schema" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" }, { "uri" : "http://zorba.io/modules/xqdoc", "prefix" : "xqd" }, { "uri" : "http://zorba.io/errors", "prefix" : "zerr" } ], "functions" : [ { "isDocumented" : true, "arity" : 1, "name" : "xqdoc-content", "qname" : "xqd:xqdoc-content", "signature" : "($module as xs:string) as element(*)", "description" : " Generated the an XQDoc XML document for the module provided\n as parameter to this function.\n", "summary" : "<p> Generated the an XQDoc XML document for the module provided\n as parameter to this function.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "module", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The module (as string) for which to generate the XQDoc documentation.</div>" } ], "returns" : { "type" : "element(*)", "description" : "An element according to the xqdoc schema (<tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">http://zorba.io/modules/xqdoc.xsd</tt>)." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr::ZXQD0002 if the xqdoc comments in the module contain invalid XML</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "xqdoc-content", "qname" : "xqd:xqdoc-content", "signature" : "($module as xs:string, $options as element(opt:enable)) as element(*)", "description" : " Generated the an XQDoc XML document for the module provided\n as parameter to this function.\n In comparison to the single parameter version, this function does not\n generate XQDoc for all language components. By default, the\n following components are deactivated: XQuery comments, import\n statements, variable declarations, function declarations, collection\n declarations,  and index declarations. The second parameter is used to\n enable the XQDoc generation of those components.\n", "summary" : "<p> Generated the an XQDoc XML document for the module provided\n as parameter to this function.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "module", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The module (as string) for which to generate the XQDoc documentation.</div>" }, { "name" : "options", "type" : "element(opt:enable)", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> XQDoc generation options, e.g.: <pre> &lt;enable xmlns=\"http://zorba.io/modules/xqdoc-options\" comments=\"true\" functions=\"true\" indexes=\"true\" &gt; </pre></div>" } ], "returns" : { "type" : "element(*)", "description" : "An element according to the xqdoc schema (<tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">http://zorba.io/modules/xqdoc.xsd</tt>)." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr::ZXQD0002 if the xqdoc comments in the module contain invalid XML</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "xqdoc", "qname" : "xqd:xqdoc", "signature" : "($module-uri as xs:string) as element(*)", "description" : " Generates an XQDoc XML document for the module located\n at the URI provided as parameter to this function.\n", "summary" : "<p> Generates an XQDoc XML document for the module located\n at the URI provided as parameter to this function.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "module-uri", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The URL of the module for which to generate XQDoc.</div>" } ], "returns" : { "type" : "element(*)", "description" : "An element according to the xqdoc schema (<tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">http://zorba.io/modules/xqdoc.xsd</tt>)." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr::ZXQD0002 if the xqdoc comments in the module contain invalid XML</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "xqdoc", "qname" : "xqd:xqdoc", "signature" : "($module-uri as xs:string, $options as element(opt:enable)) as element(*)", "description" : " Generates an XQDoc XML document for the module located\n at the URI provided as parameter to this function.\n In comparison to the single parameter version, this function does not\n generate XQDoc for all language components. By default, the\n following components are deactivated: XQuery comments, import\n statements, variable declarations, function declarations, collection\n declarations,  and index declarations. The second parameter is used to\n enable the XQDoc generation of those components.\n", "summary" : "<p> Generates an XQDoc XML document for the module located\n at the URI provided as parameter to this function.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "module-uri", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The URL of the module for which to generate XQDoc.</div>" }, { "name" : "options", "type" : "element(opt:enable)", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> XQDoc generation options, e.g.: <pre> &lt;enable xmlns=\"http://zorba.io/modules/xqdoc-options\" comments=\"true\" functions=\"true\" indexes=\"true\" /&gt; </pre></div>" } ], "returns" : { "type" : "element(*)", "description" : "An element according to the xqdoc schema (<tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">http://zorba.io/modules/xqdoc.xsd</tt>)." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr::ZXQD0002 if the xqdoc comments in the module contain invalid XML</xqdoc:error>" ] } ], "variables" : [  ] }, "http://zorba.io/modules/data-cleaning/character-based-string-similarity" : { "ns" : "http://zorba.io/modules/data-cleaning/character-based-string-similarity", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This library module provides character-based string similarity functions\n that view strings as sequences of characters, generally computing a similarity score\n that corresponds to the cost of transforming one string into another.\n These functions are particularly useful for matching near duplicate strings\n in the presence of typographical errors. </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The logic contained in this module is not specific to any particular XQuery implementation.</p>\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Bruno Martins and Diogo Simões</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://zorba.io/modules/data-cleaning/character-based-string-similarity", "prefix" : "simc" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 2, "name" : "edit-distance", "qname" : "simc:edit-distance", "signature" : "($s1 as xs:string, $s2 as xs:string) as xs:integer", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the edit distance between two strings.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This distance, also refered to as the Levenshtein distance, is defined as the minimum number\n of edits needed to transform one string into the other, with the allowable edit operations\n being insertion, deletion, or substitution of a single character.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example usage : <pre class=\"ace-static\" ace-mode=\"xquery\">edit-distance(\"FLWOR\", \"FLOWER\")</pre></p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The function invocation in the example above returns : <pre class=\"ace-static\" ace-mode=\"xquery\">2</pre></p>\n", "summary" : "<p>  Returns the edit distance between two strings.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "s1", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The first string.</div>" }, { "name" : "s2", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The second string.</div>" } ], "returns" : { "type" : "xs:integer", "description" : "The edit distance between the two strings." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 4, "name" : "jaro-winkler", "qname" : "simc:jaro-winkler", "signature" : "($s1 as xs:string, $s2 as xs:string, $prefix as xs:integer, $fact as xs:double) as xs:double", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the Jaro-Winkler similarity coefficient between two strings.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This similarity coefficient corresponds to an extension of the Jaro similarity coefficient that weights or\n penalizes strings based on their similarity at the beginning of the string, up to a given prefix size.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example usage : <pre class=\"ace-static\" ace-mode=\"xquery\">jaro-winkler(\"DWAYNE\", \"DUANE\", 4, 0.1 )</pre></p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The function invocation in the example above returns : <pre class=\"ace-static\" ace-mode=\"xquery\">0.8577777777777778</pre></p>\n", "summary" : "<p>  Returns the Jaro-Winkler similarity coefficient between two strings.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "s1", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The first string.</div>" }, { "name" : "s2", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The second string.</div>" }, { "name" : "prefix", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The number of characters to consider when testing for equal prefixes in the strings.</div>" }, { "name" : "fact", "type" : "xs:double", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The weighting factor to consider when the input strings have equal prefixes.</div>" } ], "returns" : { "type" : "xs:double", "description" : "The Jaro-Winkler similarity coefficient between the two strings." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "jaro", "qname" : "simc:jaro", "signature" : "($s1 as xs:string, $s2 as xs:string) as xs:double", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the Jaro similarity coefficient between two strings.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This similarity coefficient is based on the number of transposed characters and on a\n weighted sum of the percentage of matched characters held within the strings. The higher\n the Jaro-Winkler value is, the more similar the strings are. The coefficient is\n normalized such that 0 equates to no similarity and 1 is an exact match.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example usage : <pre class=\"ace-static\" ace-mode=\"xquery\">jaro(\"FLWOR Found.\", \"FLWOR Foundation\")</pre></p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The function invocation in the example above returns : <pre class=\"ace-static\" ace-mode=\"xquery\">0.5853174603174603</pre></p>\n", "summary" : "<p>  Returns the Jaro similarity coefficient between two strings.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "s1", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The first string.</div>" }, { "name" : "s2", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The second string.</div>" } ], "returns" : { "type" : "xs:double", "description" : "The Jaro similarity coefficient between the two strings." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 4, "name" : "needleman-wunsch", "qname" : "simc:needleman-wunsch", "signature" : "($s1 as xs:string, $s2 as xs:string, $score as xs:integer, $penalty as xs:integer) as xs:double", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the Needleman-Wunsch distance between two strings.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The Needleman-Wunsch distance is similar to the basic edit distance metric, adding a\n variable cost adjustment to the cost of a gap (i.e., an insertion or deletion) in the\n distance metric.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example usage : <pre class=\"ace-static\" ace-mode=\"xquery\">needleman-wunsch(\"KAK\", \"KQRK\", 1, 1)</pre></p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The function invocation in the example above returns : <pre class=\"ace-static\" ace-mode=\"xquery\">0</pre></p>\n", "summary" : "<p>  Returns the Needleman-Wunsch distance between two strings.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "s1", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The first string.</div>" }, { "name" : "s2", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The second string.</div>" }, { "name" : "score", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The score value.</div>" }, { "name" : "penalty", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The penalty value.</div>" } ], "returns" : { "type" : "xs:double", "description" : "The Needleman-Wunsch distance between the two strings." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 4, "name" : "smith-waterman", "qname" : "simc:smith-waterman", "signature" : "($s1 as xs:string, $s2 as xs:string, $score as xs:integer, $penalty as xs:integer) as xs:double", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the Smith-Waterman distance between two strings.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example usage : <pre class=\"ace-static\" ace-mode=\"xquery\">smith-waterman(\"ACACACTA\", \"AGCACACA\", 2, 1)</pre></p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The function invocation in the example above returns : <pre class=\"ace-static\" ace-mode=\"xquery\">12</pre></p>\n", "summary" : "<p>  Returns the Smith-Waterman distance between two strings.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "s1", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The first string.</div>" }, { "name" : "s2", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The second string.</div>" }, { "name" : "score", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The score value.</div>" }, { "name" : "penalty", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The penalty value.</div>" } ], "returns" : { "type" : "xs:double", "description" : "The Smith-Waterman distance between the two strings." }, "errors" : [  ] } ], "variables" : [  ] }, "http://expath.org/ns/error" : { "ns" : "http://expath.org/ns/error", "description" : " This module defines all errors for the http-client module.\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Markus Pilman</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://expath.org/ns/error", "prefix" : "err" } ], "functions" : [  ], "variables" : [ { "name" : "err:errNS", "type" : "xs:string", "description" : " Error namespace URI.\n" }, { "name" : "err:HC001", "type" : "xs:QName", "description" : " An HTTP error occurred.\n" }, { "name" : "err:HC002", "type" : "xs:QName", "description" : " Error parsing the entity content as XML or HTML.\n" }, { "name" : "err:HC003", "type" : "xs:QName", "description" : " With a multipart response, the override-media-type must be either a multipart media type or application/octet-stream.\n" }, { "name" : "err:HC004", "type" : "xs:QName", "description" : " The src attribute on the body element is mutually exclusive with all other attribute (except the media-type).\n" }, { "name" : "err:HC005", "type" : "xs:QName", "description" : " The request element is not valid.\n" }, { "name" : "err:HC006", "type" : "xs:QName", "description" : " A timeout occurred waiting for the response.\n" }, { "name" : "err:HCV01", "type" : "xs:QName", "description" : " This error is not defined in the specification but used by the Zorba implementation.\n It gets thrown when the user gives wrong arguments which are statically correct,\n but make no sense (for example: http:send-request((), ())).\n" }, { "name" : "err:HCV02", "type" : "xs:QName", "description" : " Zorba specific error\n This error is raised if trying to follow a redirect for a POST, PUT, or\n DELETE request\n" } ] }, "http://www.28msec.com/modules/s3" : { "ns" : "http://www.28msec.com/modules/s3", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This module provides functionality for managing S3 buckets and object.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">It is not possible to access buckets whose names are not DNS-compliant. For\n instance a bucket name which contains uppercase letters or is longer than 63\n characters is not DNS-compliant. For additional details on bucket naming\n conventions refer to\n <a href=\"http://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html\">\n Bucket Restrictions and Limitations</a>.</p>\n <h2 xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Authentication</h2>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">For each functionality two methods are provided:\n <ul>\n   <li>one which allows to specify the credentials to use, by means of the\n   optional $credentials parameter (named). If the parameter is not specified,\n   the default credentials in the \"S3\" category will be used. If the parameter\n   is specified it must be either a string or an object. If it is a string it\n   will be interpreted as the name of a credentials in the \"S3\" category. If\n   it is an object it must have the following structure:\n   <ul>\n     <li>accessKey: the AWS access key to use (string, mandatory).</li>\n     <li>secretKey: the AWS secret key to use (string, mandatory).</li>\n     <li>useHttps: whether to use secure HTTPS connections or not.\n     (boolean, optional). The default is <code>false</code></li>\n     <li>defaultBucket: the default bucket name (string, optional).</li>\n   </ul>\n   </li>\n   <li>one which does not allow to specify which credentials to use.\n   In this case the default credentials in the \"S3\" category will be used.</li>\n </ul>\n </p>\n <h2 xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" id=\"determinism\">Important Notice Regarding Function Determinism</h2>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The non side-effecting functions:\n <ul>\n   <li><a href=\"?anchor=list-buckets-0\">list-buckets#0</a></li>\n   <li><a href=\"?anchor=list-buckets-1\">list-buckets#1</a></li>\n   <li><a href=\"?anchor=list-bucket-0\">list-bucket#0</a></li>\n   <li><a href=\"?anchor=list-bucket-1\">list-bucket#1</a></li>\n   <li><a href=\"?anchor=list-bucket-2\">list-bucket#2</a></li>\n   <li><a href=\"?anchor=list-bucket-3\">list-bucket#3</a></li>\n   <li><a href=\"?anchor=list-bucket-versions-0\">list-bucket-versions#0</a></li>\n   <li><a href=\"?anchor=list-bucket-versions-1\">list-bucket-versions#1</a></li>\n   <li><a href=\"?anchor=list-bucket-versions-2\">list-bucket-versions#2</a></li>\n   <li><a href=\"?anchor=list-bucket-versions-3\">list-bucket-versions#3</a></li>\n   <li><a href=\"?anchor=read-text-1\">read-text#1</a></li>\n   <li><a href=\"?anchor=read-text-2\">read-text#2</a></li>\n   <li><a href=\"?anchor=read-binary-1\">read-binary#1</a></li>\n   <li><a href=\"?anchor=read-binary-2\">read-binary#2</a></li>\n   <li><a href=\"?anchor=read-object-1\">read-object#1</a></li>\n   <li><a href=\"?anchor=read-object-2\">read-object#2</a></li>\n   <li><a href=\"?anchor=object-metadata-1\">object-metadata#1</a></li>\n   <li><a href=\"?anchor=object-metadata-2\">object-metadata#2</a></li>\n   <li><a href=\"?anchor=object-torrent-1\">object-torrent#1</a></li>\n   <li><a href=\"?anchor=object-torrent-2\">object-torrent#2</a></li>\n   <li><a href=\"?anchor=object-permissions-1\">object-permissions#1</a></li>\n   <li><a href=\"?anchor=object-permissions-2\">object-permissions#2</a></li>\n </ul>\n are declared deterministic, which means that their results could be cached\n when invoked multiple times with the same arguments in the same query execution.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">To not use cached results you can use the following alternative functions:\n <ul>\n   <li><a href=\"?anchor=list-buckets-nondeterministic-0\">list-buckets-nondeterministic#0</a></li>\n   <li><a href=\"?anchor=list-buckets-nondeterministic-1\">list-buckets-nondeterministic#1</a></li>\n   <li><a href=\"?anchor=list-bucket-nondeterministic-0\">list-bucket-nondeterministic#0</a></li>\n   <li><a href=\"?anchor=list-bucket-nondeterministic-1\">list-bucket-nondeterministic#1</a></li>\n   <li><a href=\"?anchor=list-bucket-nondeterministic-2\">list-bucket-nondeterministic#2</a></li>\n   <li><a href=\"?anchor=list-bucket-nondeterministic-3\">list-bucket-nondeterministic#3</a></li>\n   <li><a href=\"?anchor=list-bucket-versions-nondeterministic-0\">list-bucket-versions-nondeterministic#0</a></li>\n   <li><a href=\"?anchor=list-bucket-versions-nondeterministic-1\">list-bucket-versions-nondeterministic#1</a></li>\n   <li><a href=\"?anchor=list-bucket-versions-nondeterministic-2\">list-bucket-versions-nondeterministic#2</a></li>\n   <li><a href=\"?anchor=list-bucket-versions-nondeterministic-3\">list-bucket-versions-nondeterministic#3</a></li>\n   <li><a href=\"?anchor=read-text-nondeterministic-1\">read-text-nondeterministic#1</a></li>\n   <li><a href=\"?anchor=read-text-nondeterministic-2\">read-text-nondeterministic#2</a></li>\n   <li><a href=\"?anchor=read-binary-nondeterministic-1\">read-binary-nondeterministic#1</a></li>\n   <li><a href=\"?anchor=read-binary-nondeterministic-2\">read-binary-nondeterministic#2</a></li>\n   <li><a href=\"?anchor=read-object-nondeterministic-1\">read-object-nondeterministic#1</a></li>\n   <li><a href=\"?anchor=read-object-nondeterministic-2\">read-object-nondeterministic#2</a></li>\n   <li><a href=\"?anchor=object-metadata-nondeterministic-1\">object-metadata-nondeterministic#1</a></li>\n   <li><a href=\"?anchor=object-metadata-nondeterministic-2\">object-metadata-nondeterministic#2</a></li>\n   <li><a href=\"?anchor=object-torrent-nondeterministic-1\">object-torrent-nondeterministic#1</a></li>\n   <li><a href=\"?anchor=object-torrent-nondeterministic-2\">object-torrent-nondeterministic#2</a></li>\n   <li><a href=\"?anchor=object-permissions-nondeterministic-1\">object-permissions-nondeterministic#1</a></li>\n   <li><a href=\"?anchor=object-permissions-nondeterministic-2\">object-permissions-nondeterministic#2</a></li>\n </ul>\n which have been declared as being non deterministic.</p>\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Alexander Kreutz</xqdoc:author>", "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Federico Cavalieri</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://zorba.io/annotations", "prefix" : "an" }, { "uri" : "http://www.28msec.com/modules/credentials", "prefix" : "credentials" }, { "uri" : "http://www.w3.org/2005/xqt-errors", "prefix" : "err" }, { "uri" : "http://www.zorba-xquery.com/modules/cryptography/hmac", "prefix" : "hmac" }, { "uri" : "http://zorba.io/modules/http-client", "prefix" : "http" }, { "uri" : "http://jsoniq.org/errors", "prefix" : "jerr" }, { "uri" : "http://www.28msec.com/modules/s3", "prefix" : "s3" }, { "uri" : "http://s3.amazonaws.com/doc/2006-03-01/", "prefix" : "s3s" }, { "uri" : "http://www.28msec.com/modules/sleep", "prefix" : "sleep" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 2, "name" : "copy-object", "qname" : "s3:copy-object", "signature" : "($s3-object-source as item(), $s3-object-target as item()) as item()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Copies an object already stored on s3 into a target bucket using the\n default credentials. If the target object already exists it will be overwritten.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The source object metadata is copied to the target object, unless new\n metadata is specified. In this case the target object will possess only the\n specified metadata.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Unless the permissions for the target are specified, the target object will\n have the \"private\" ACL, that is, the owner gets FULL_CONTROL, and no one else\n has access rights.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The source S3 object is specified through the $s3-object-source parameter.\n Either a string or a JSON object can be used. If a string is specified, it is\n interpreted as key for an object in the default bucket of the default\n credentials. If no default bucket is present in the default credentials, the\n <code>s3:BUCKET</code> error is raised. If a JSON object is used, it must have\n the following structure:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, optional). If this field is not present\n   and the default credentials do not have a default bucket, the\n   <code>s3:BUCKET</code> error is raised.</li>\n   <li>version: the object version (string, optional). If versioning is enabled\n   for the specified object and no version is specified the latest version of\n   the object will be copied. If specified, only that particular version of the\n   object will be copied.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The target S3 object is specified through the $s3-object-target parameter.\n Either a string or a JSON object can be used. If a string is specified and the\n default credentials contain a default bucket, the object will be copied in\n the credentials default bucket. Otherwise, the object will be copied in the\n source object bucket. If a JSON object is used, it must have the following\n structure:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, optional). If this field is not present\n   and the default credentials contain a default bucket, the object will be\n   copied in the credentials default bucket. Otherwise, the object will be\n   copied in the source object bucket.</li>\n   <li>metadata: an object specifying additional metadata. Each metadata is a\n   name-value pair and is represented as different fields (object, optional).\n   If not specified, the source object metadata will be copied to the target\n   object. Otherwise the target object metadata will be the specified one.</li>\n   <li>reducedRedundancy: whether to use reduced-redundancy or not (bool,\n   optional). Default is false.</li>\n   <li>permission: the permission to set (string, optional). It must be one of\n   \"private\", \"public-read\", \"public-read-write\", \"authenticated-read\",\n   \"bucket-owner-read\", \"bucket-owner-full-control\". For your convenience the\n   following variables can be used: <code>$s3:ACL-GRANT-PRIVATE</code>,\n   <code>$s3:ACL-GRANT-PUBLIC-READ</code>, <code>$s3:ACL-GRANT-PUBLIC-READ-WRITE</code>,\n   <code>$s3:ACL-GRANT-AUTHENTICATED-READ</code>, <code>$s3:ACL-GRANT-BUCKET-OWNER-READ</code>,\n   <code>$s3:ACL-GRANT-BUCKET-OWNER-FULL-CONTROL</code>. If this field is not\n   specified, the \"private\" ACL is used, that is, the owner gets FULL_CONTROL,\n   and no one else has access rights.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n let $s3-object-source :=\n {\n   \"key\" : \"test.xml\",\n   \"bucket\": \"28msec\"\n }\n let $s3-object-target :=\n {\n   \"key\" : \"test-copy.xml\",\n   \"bucket\": \"28msec\",\n   \"permisstion\": $s3:ACL-GRANT-PUBLIC-READ\n   \"metadata\":\n   {\n     \"author\": \"28msec\"\n   }\n }\n return s3:copy-object($s3-object-source, $s3-object-target)\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example return object:\n <pre>\n {\n   \"sourceVersion\": \"3/L4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo\",\n   \"version\": \"QUpfdndhfd8438MNFDN93jdnJFkdmqnh893\",\n   \"lastModified\": \"2009-10-28T22:32:00\",\n   \"eTag\": \"\\\"9b2cf535f27731c974343645a3985328\\\"\",\n   \"expiration\": \"expiry-date=\\\"Fri, 21 Dec 2012 00:00:00 GMT\\\", rule-id=\\\"Rule for testfile.txt\\\"\"\n }\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The fields in the returned object have the following meanings:\n <ul>\n   <li>sourceVersion: the version of the copied object. When you enable versioning,\n   Amazon S3 generates a random number for objects added to a bucket. The value\n   is UTF-8 encoded and URL ready. When the soruce object is copied in a bucket where\n   versioning has been suspended, the version ID is always null. (string, optional)</li>\n   <li>version: the version of the copied object. When you enable versioning,\n   Amazon S3 generates a random number for objects added to a bucket. The value\n   is UTF-8 encoded and URL ready. When the soruce object is copied in a bucket where\n   versioning has been suspended, the version ID is always null. (string, optional)</li>\n   <li>lastModified: the last modification date of the target object. (dateTime, optional)</li>\n   <li>eTag: the entity tag is a hash of the copeid object. The eTag only reflects\n   changes to the contents of an object, not its metadata. The eTag is determined\n   when an object is created. The eTag returned by this method is a quoted,\n   32-digit hexadecimal string representing the MD5 digest of the object data.\n   For other objects, the eTag may or may not be an MD5 digest of the object data.\n   (string, optional).</li>\n   <li>expiration: if the object expiration is configured (see\n   <a href=\"http://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlifecycle.html\">PUT Bucket lifecycle</a>),\n   this field is present. It includes the expiry-date and rule-id key value\n   pairs providing object expiration information. The value of rule-id is URL\n   encoded.(string, optional).</li>\n </ul>\n </p>\n", "summary" : "<p>  Copies an object already stored on s3 into a target bucket using the\n default credentials.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "s3-object-source", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object or object version to copy from.</div>" }, { "name" : "s3-object-target", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object to write to.</div>" } ], "returns" : { "type" : "item()*", "description" : "the S3 copy result." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the default S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "copy-object", "qname" : "s3:copy-object", "signature" : "($credentials as item()?, $s3-object-source as item(), $s3-object-target as item()) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Copies an object already stored on S3 into a target bucket using the\n specified credentials. If the target object already exists it will be overwritten.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The source object metadata is copied to the target object, unless new\n metadata is specified. In this case the target object will possess only the\n specified metadata.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Unless the permissions for the target are specified, the target object will\n have the \"private\" ACL, that is, the owner gets FULL_CONTROL, and no one else\n has access rights.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The source S3 object is specified through the $s3-object-source parameter.\n Either a string or a JSON object can be used. If a string is specified, it is\n interpreted as key for an object in the default bucket of the specified\n credentials. If no default bucket is present in the specified credentials, the\n <code>s3:BUCKET</code> error is raised. If a JSON object is used, it must have\n the following structure:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, optional). If this field is not present\n   and the specified credentials do not have a default bucket, the\n   <code>s3:BUCKET</code> error is raised.</li>\n   <li>version: the object version (string, optional). If versioning is enabled\n   for the specified object and no version is specified the latest version of\n   the object will be copied. If specified, only that particular version of the\n   object will be copied.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The target S3 object is specified through the $s3-object-target parameter.\n Either a string or a JSON object can be used. If a string is specified and the\n specified credentials contain a default bucket, the object will be copied in\n the credentials default bucket. Otherwise, the object will be copied in the\n source object bucket. If a JSON object is used, it must have the following\n structure:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, optional). If this field is not present\n   and the specified credentials contain a default bucket, the object will be\n   copied in the credentials default bucket. Otherwise, the object will be\n   copied in the source object bucket.</li>\n   <li>metadata: an object specifying additional metadata. Each metadata is a\n   name-value pair and is represented as different fields (object, optional).\n   If not specified, the source object metadata will be copied to the target\n   object. Otherwise the target object metadata will be the specified one.</li>\n   <li>reducedRedundancy: whether to use reduced-redundancy or not (bool,\n   optional). Default is false.</li>\n   <li>permission: the permission to set (string, optional). It must be one of\n   \"private\", \"public-read\", \"public-read-write\", \"authenticated-read\",\n   \"bucket-owner-read\", \"bucket-owner-full-control\". For your convenience the\n   following variables can be used: <code>$s3:ACL-GRANT-PRIVATE</code>,\n   <code>$s3:ACL-GRANT-PUBLIC-READ</code>, <code>$s3:ACL-GRANT-PUBLIC-READ-WRITE</code>,\n   <code>$s3:ACL-GRANT-AUTHENTICATED-READ</code>, <code>$s3:ACL-GRANT-BUCKET-OWNER-READ</code>,\n   <code>$s3:ACL-GRANT-BUCKET-OWNER-FULL-CONTROL</code>. If this field is not\n   specified, the \"private\" ACL is used, that is, the owner gets FULL_CONTROL,\n   and no one else has access rights.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n let $s3-object-source :=\n {\n   \"key\" : \"test.xml\",\n   \"bucket\": \"28msec\"\n }\n let $s3-object-target :=\n {\n   \"key\" : \"test-copy.xml\",\n   \"bucket\": \"28msec\",\n   \"permisstion\": $s3:ACL-GRANT-PUBLIC-READ\n   \"metadata\":\n   {\n     \"author\": \"28msec\"\n   }\n }\n return s3:copy-object(\"credentials\", $s3-object-source, $s3-object-target)\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example return object:\n <pre>\n {\n   \"sourceVersion\": \"3/L4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo\",\n   \"version\": \"QUpfdndhfd8438MNFDN93jdnJFkdmqnh893\",\n   \"lastModified\": \"2009-10-28T22:32:00\",\n   \"eTag\": \"\\\"9b2cf535f27731c974343645a3985328\\\"\",\n   \"expiration\": \"expiry-date=\\\"Fri, 21 Dec 2012 00:00:00 GMT\\\", rule-id=\\\"Rule for testfile.txt\\\"\"\n }\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The fields in the returned object have the following meanings:\n <ul>\n   <li>sourceVersion: the version of the copied object. When you enable versioning,\n   Amazon S3 generates a random number for objects added to a bucket. The value\n   is UTF-8 encoded and URL ready. When the soruce object is copied in a bucket where\n   versioning has been suspended, the version ID is always null. (string, optional)</li>\n   <li>version: the version of the copied object. When you enable versioning,\n   Amazon S3 generates a random number for objects added to a bucket. The value\n   is UTF-8 encoded and URL ready. When the soruce object is copied in a bucket where\n   versioning has been suspended, the version ID is always null. (string, optional)</li>\n   <li>lastModified: the last modification date of the target object. (dateTime, optional)</li>\n   <li>eTag: the entity tag is a hash of the copeid object. The eTag only reflects\n   changes to the contents of an object, not its metadata. The eTag is determined\n   when an object is created. The eTag returned by this method is a quoted,\n   32-digit hexadecimal string representing the MD5 digest of the object data.\n   For other objects, the eTag may or may not be an MD5 digest of the object data.\n   (string, optional).</li>\n </ul>\n </p>\n", "summary" : "<p>  Copies an object already stored on S3 into a target bucket using the\n specified credentials.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "credentials", "type" : "item()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials to use.</div>" }, { "name" : "s3-object-source", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object or object version to copy from.</div>" }, { "name" : "s3-object-target", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object to write to.</div>" } ], "returns" : { "type" : "object()", "description" : "the S3 copy result." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "create-bucket", "qname" : "s3:create-bucket", "signature" : "($bucket as string) as empty-sequence()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Creates a bucket using the default S3 credentials. The bucket owner will\n be the account of the default S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The bucket is created with the S3 default bucket settings. Specifically,\n it is created in the US Standard region and the default credentials\n account becomes its owner. The bucket ACL permissions are set to \"private\",\n that is, the owner gets FULL_CONTROL, whereas no one else has access rights.\n The bucket name must comply with the following rules:\n <ul>\n   <li>bucket names must be no more than 255 characters long.</li>\n   <li>bucket names must be a combination of uppercase letters, lowercase letters,\n   numbers, periods (.), dashes (-) and underscores (_).</li>\n </ul>\n For more details, refer to the\n <a href=\"http://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html\">\n Amazon S3 Bucket Restrictions</a> page.\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If the specified bucket already exists in the US Standard region and has\n the same owner, its permissions settings are reset and its contents are\n preserved. Otherwise, if the specified bucket already exists an s3:REQUEST\n error is raised.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n s3:create-bucket(\"28msec\");\n </pre>\n </p>\n", "summary" : "<p>  Creates a bucket using the default S3 credentials.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "bucket", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The bucket name.</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "the empty sequence" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the default S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "create-bucket", "qname" : "s3:create-bucket", "signature" : "($credentials as item()?, $bucket as string) as empty-sequence()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Creates a bucket using the specified S3 credentials. The bucket owner will\n be the account of the specified S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The bucket is created with the S3 default bucket settings. Specifically,\n it is created in the US Standard region and the specified credentials\n account becomes its owner. The bucket ACL permissions are set to \"private\",\n that is, the owner gets FULL_CONTROL, whereas no one else has access rights.\n The bucket name must comply with the following rules:\n <ul>\n   <li>bucket names must be no more than 255 characters long.</li>\n   <li>bucket names must be a combination of uppercase letters, lowercase letters,\n   numbers, periods (.), dashes (-) and underscores (_).</li>\n </ul>\n For more details, refer to the\n <a href=\"http://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html\">\n Amazon S3 Bucket Restrictions</a> page.\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If the specified bucket already exists in the US Standard region and has\n the same owner, its permissions settings are reset and its contents are\n preserved. Otherwise, if the specified bucket already exists an s3:REQUEST\n error is raised.</p>\n", "summary" : "<p>  Creates a bucket using the specified S3 credentials.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "credentials", "type" : "item()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials to use.</div>" }, { "name" : "bucket", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The bucket name.</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "the empty sequence" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "delete-bucket", "qname" : "s3:delete-bucket", "signature" : "($bucket as string) as empty-sequence()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Deletes a bucket using the default S3 credentials. The bucket must be owned\n by the account of the default S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This operation will fail if the deleted bucket is not empty. All objects,\n object versions, and delete markers have to be deleted beforehand using this\n function.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n s3:delete-bucket(\"28msec\");\n </pre>\n </p>\n", "summary" : "<p>  Deletes a bucket using the default S3 credentials.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "bucket", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The bucket name.</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "the empty sequence" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the default S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "delete-bucket", "qname" : "s3:delete-bucket", "signature" : "($credentials as item()?, $bucket as string) as empty-sequence()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Deletes a bucket using the specified S3 credentials. The bucket must be owned\n by the account of the specified S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This operation will fail if the deleted bucket is not empty. All objects,\n object versions, and delete markers have to be deleted beforehand using this\n function.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n s3:delete-bucket(\"credentials\", \"28msec\");\n </pre>\n </p>\n", "summary" : "<p>  Deletes a bucket using the specified S3 credentials.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "credentials", "type" : "item()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials to use.</div>" }, { "name" : "bucket", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The bucket name.</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "the empty sequence" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "delete-object", "qname" : "s3:delete-object", "signature" : "($s3-object as item()) as empty-sequence()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Deletes an object or a specific object version from a bucket using the\n default S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The S3 object is specified through the $s3-object parameter. Either a string\n or a JSON object can be used. If a string is specified, it is interpreted as\n key for an object in the default bucket of the default credentials. If no default\n bucket is present in the default credentials, the <code>s3:BUCKET</code> error\n is raised. If a JSON object is used, it must have the following structure:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, optional). If this field is not present\n   and the default credentials do not have a default bucket, the\n   <code>s3:BUCKET</code> error is raised.</li>\n   <li>version: the object version (string, optional). If not specified, the\n   null version of the object is removed, if there is one. To remove a specific\n   version, this field must be specified.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If the bucket is versioned a delete marker is inserted for the object. If\n mfa-deletion is enabled you will not be able to delete an object through\n this method. If the specified bucket exists, and the specified object does not\n exist no errors will be raised.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n s3:delete-object(\n {\n   \"key\": \"test.xml\",\n   \"bucket\": \"28msec\",\n   \"version\": \"3/L4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo\"\n });\n </pre>\n </p>\n", "summary" : "<p>  Deletes an object or a specific object version from a bucket using the\n default S3 credentials.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object or object version to delete.</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "the empty sequence" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the default S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "delete-object", "qname" : "s3:delete-object", "signature" : "($credentials as item()?, $s3-object as item()) as empty-sequence()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Deletes an object or a specific object version from a bucket using the\n specified S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The S3 object is specified through the $s3-object parameter. Either a string\n or a JSON object can be used. If a string is specified, it is interpreted as\n key for an object in the default bucket of the specified credentials. If no default\n bucket is present in the specified credentials, the <code>s3:BUCKET</code> error\n is raised. If a JSON object is used, it must have the following structure:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, optional). If this field is not present\n   and the specified credentials do not have a default bucket, the\n   <code>s3:BUCKET</code> error is raised.</li>\n   <li>version: the object version (string, optional). If not specified, the\n   null version of the object is removed, if there is one. To remove a specific\n   version, this field must be specified.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If the bucket is versioned a delete marker is inserted for the object. If\n mfa-deletion is enabled you will not be able to delete an object through\n this method. If the specified bucket exists, and the specified object does not\n exist no errors will be raised.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n s3:delete-object(\"credentials\",\n {\n   \"key\": \"test.xml\",\n   \"bucket\": \"28msec\",\n   \"version\": \"3/L4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo\"\n });\n </pre>\n </p>\n", "summary" : "<p>  Deletes an object or a specific object version from a bucket using the\n specified S3 credentials.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "credentials", "type" : "item()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials to use.</div>" }, { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object or object version to delete.</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "the empty sequence" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 0, "name" : "list-bucket-nondeterministic", "qname" : "s3:list-bucket-nondeterministic", "signature" : "() as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Lists the objects in the default bucket of the default S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as\n <a href=\"#list-bucket-0\">list-bucket#0</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Lists the objects in the default bucket of the default S3 credentials.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "object()", "description" : "the list of objects in the default bucket of the default S3 credentials" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no default bucket is present in the default S3 credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OPTIONS if the specified options are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "list-bucket-nondeterministic", "qname" : "s3:list-bucket-nondeterministic", "signature" : "($bucket as string?) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Lists the objects in a bucket using the default S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as\n <a href=\"#list-bucket-1\">list-bucket#1</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Lists the objects in a bucket using the default S3 credentials.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "bucket", "type" : "string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The bucket to list. If the empty sequence is given, the default bucket of the default S3 credentials will be listed.</div>" } ], "returns" : { "type" : "object()", "description" : "the list of the objects in the specified bucket." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OPTIONS if the specified options are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "list-bucket-nondeterministic", "qname" : "s3:list-bucket-nondeterministic", "signature" : "($bucket as string?, $options as object()?) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Lists the objects in a bucket using the default S3 credentials.\n This method allows the specification of additional listing options.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as\n <a href=\"#list-bucket-2\">list-bucket#2</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Lists the objects in a bucket using the default S3 credentials.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "bucket", "type" : "string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The bucket to list. If the empty sequence is given, the default bucket of the default S3 credentials will be listed.</div>" }, { "name" : "options", "type" : "object()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The listing options.</div>" } ], "returns" : { "type" : "object()", "description" : "the list of the object in the specified bucket" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the default credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OPTIONS if the specified options are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "list-bucket-nondeterministic", "qname" : "s3:list-bucket-nondeterministic", "signature" : "($credentials as item()?, $bucket as string?, $options as object()?) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Lists the objects in a bucket using the specified credentials.\n This method allows the specification of additional listing options.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as\n <a href=\"#list-bucket-3\">list-bucket#3</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Lists the objects in a bucket using the specified credentials.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "credentials", "type" : "item()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials to use.</div>" }, { "name" : "bucket", "type" : "string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The bucket to list. If the empty sequence is given, the default bucket of the specified credentials will be listed.</div>" }, { "name" : "options", "type" : "object()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The listing options.</div>" } ], "returns" : { "type" : "object()", "description" : "the list of the object in the specified bucket" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OPTIONS if the specified options are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 0, "name" : "list-bucket-versions-nondeterministic", "qname" : "s3:list-bucket-versions-nondeterministic", "signature" : "() as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Lists the objects versions in the default bucket of the default S3\n credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as\n <a href=\"#list-bucket-versions-0\">list-bucket-versions#0</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Lists the objects versions in the default bucket of the default S3\n credentials.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "object()", "description" : "the list of the object versions in the default bucket of the default S3 credentials" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no default bucket is present in the default S3 credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OPTIONS if the specified options are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "list-bucket-versions-nondeterministic", "qname" : "s3:list-bucket-versions-nondeterministic", "signature" : "($bucket as string?) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Lists the objects versions in a bucket using the default S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as\n <a href=\"#list-bucket-versions-1\">list-bucket-versions#1</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Lists the objects versions in a bucket using the default S3 credentials.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "bucket", "type" : "string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The bucket to list. If the empty sequence is given, the default bucket of the default credentials will be listed.</div>" } ], "returns" : { "type" : "object()", "description" : "the list of the object versions in the specified bucket" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OPTIONS if the specified options are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "list-bucket-versions-nondeterministic", "qname" : "s3:list-bucket-versions-nondeterministic", "signature" : "($bucket as string?, $options as object()?) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Lists the objects versions in a bucket using the default S3 credentials.\n This method allows the specification of additional listing options.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as\n <a href=\"#list-bucket-versions-2\">list-bucket-versions#2</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Lists the objects versions in a bucket using the default S3 credentials.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "bucket", "type" : "string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The bucket to list. If the empty sequence is given, the default bucket of the default credentials will be listed.</div>" }, { "name" : "options", "type" : "object()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The listing options.</div>" } ], "returns" : { "type" : "object()", "description" : "the list of the object versions in the specified bucket" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the default credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OPTIONS if the specified options are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "list-bucket-versions-nondeterministic", "qname" : "s3:list-bucket-versions-nondeterministic", "signature" : "($credentials as item()?, $bucket as string?, $options as object()?) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Lists the objects versions in a bucket using the specified credentials.\n This method allows the specification of additional listing options.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as\n <a href=\"#list-bucket-versions-3\">list-bucket-versions#3</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Lists the objects versions in a bucket using the specified credentials.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "credentials", "type" : "item()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials to use.</div>" }, { "name" : "bucket", "type" : "string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The bucket to list. If the empty sequence is given, the default bucket of the specified credentials will be listed.</div>" }, { "name" : "options", "type" : "object()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The listing options.</div>" } ], "returns" : { "type" : "object()", "description" : "the list of the object in the specified bucket" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OPTIONS if the specified options are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 0, "name" : "list-bucket-versions", "qname" : "s3:list-bucket-versions", "signature" : "() as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Lists the objects versions in the default bucket of the default S3\n credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n s3:list-bucket-versions()\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example return object:\n <pre>\n {\n   \"name\": \"bucket\",\n   \"prefix\": \"\",\n   \"keyMarker\" : \"image.jpg\",\n   \"versionIdMarker\" : \"QUpfdndhfd8438MNFDN93jdnJFkdmqnh893\",\n   \"nextKeyMarker\": \"marker\",\n   \"nextVersionIdMarker\": \"UIORUnfndfhnw89493jJFJ\",\n   \"maxKeys\": 1,\n   \"delimiter\": \"/\",\n   \"isTruncated\": true,\n   \"revisions\":\n   [\n     {\n       \"kind\": \"Version\",\n       \"key\": \"image.jpg\",\n       \"versionId\": \"QUpfdndhfd8438MNFDN93jdnJFkdmqnh893\",\n       \"isLatest\": false,\n       \"lastModified\": \"2009-10-12T17:50:30.000Z\",\n       \"eTag\": \"\\\"fba9dede5f27731c9771645a39863328\\\"\",\n       \"size\": 434234,\n       \"storageClass\": \"STANDARD\",\n       \"owner\":\n       {\n         \"id\": \"75aa57f09aa0c8caeab4f8c24e99d10f8e7faeebf76c078efc7c6caea54ba06a\"\n         \"displayName\": \"mtd@amazon.com\"\n       }\n     },\n     {\n       \"kind\": \"DeleteMarker\",\n       \"key\": \"image.jpg\",\n       \"versionId\": \"03jpff543dhffds434rfdsFDN943fdsFkdmqnh892\",\n       \"isLatest\": true,\n       \"lastModified\": \"2009-10-12T17:50:30.000Z\",\n       \"owner\":\n       {\n         \"id\": \"75aa57f09aa0c8caeab4f8c24e99d10f8e7faeebf76c078efc7c6caea54ba06a\"\n         \"displayName\": \"mtd@amazon.com\"\n       }\n     }\n   ],\n   \"commonPrefixes\": [\"photos/\"]\n }\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The fields in the returned object have the following meanings:\n <ul>\n   <li>name: the bucket name (string, mandatory).</li>\n   <li>prefix: the used prefix (string, mandatory).</li>\n   <li>keyMarker: indicates from which key in the listing begins\n   (string, mandatory).</li>\n   <li>versionMarker: indicates from which version  the listing begins\n   (string, optional).</li>\n   <li>nextKeyMarker: when the number of responses exceeds the value of maxKeys,\n   nextKeyMarker specifies the first key not returned that satisfies the search\n   criteria. Use this value for the keyMarker request parameter in a subsequent\n   request. (string, optional)</li>\n   <li>nextVersionMarker: when the number of responses exceeds the value of maxKeys,\n   nextVersionIdMarker specifies the first object version not returned that\n   satisfies the search criteria. Use this value for the versionMarker request\n   parameter in a subsequent request. (string, optional)</li>\n   <li>maxKeys: the maximum number of keys returned in the response body\n   (integer, mandatory).</li>\n   <li>delimiter: the used delimiter (string, optional).</li>\n   <li>isTruncated: whether or not all of the results were returned. All of the\n   results may not be returned if the number of results exceeds that specified\n   by the maxKeys request parameter (boolean, mandatory).</li>\n   <li>revisions: an array of objects listing the bucket object versions\n   (array, mandatory). The fields of each contained object have the following\n   meaning:\n   <ul>\n     <li>kind: the revision kind. One of \"Version\" or \"DeleteMarker\" (string,\n     mandatory).</li>\n     <li>key: the object key (string, mandatory).</li>\n     <li>versionId: the object version id (string, mandatory).</li>\n     <li>lastModified: the object last modification date (dateTime, mandatory).</li>\n     <li>eTag: the entity tag is a hash of the object. The eTag only reflects\n     changes to the contents of an object, not its metadata. The eTag is determined\n     when an object is created. For objects created by the PUT Object operation\n     and the POST Object operation, the eTag is a quoted, 32-digit hexadecimal\n     string representing the MD5 digest of the object data. For other objects,\n     the eTag may or may not be an MD5 digest of the object data. If the eTag is\n     not an MD5 digest of the object data, it will contain one or more non-hexadecimal\n     characters and/or will consist of less than 32 or more than 32 hexadecimal\n     digits.(string, mandatory for \"Version\" objects, not present for\n     \"DeleteMarker\" objects).</li>\n     <li>size: the object size in bytes (integer, mandatory for \"Version\" objects,\n     not present for \"DeleteMarker\" objects).</li>\n     <li>storageClass: the object storage class. One of \"STANDARD\",\n     \"REDUCED_REDUNDANCY\" or \"GLACIER\" (string, mandatory for \"Version\" objects,\n     not present for \"DeleteMarker\" objects).</li>\n     <li>owner: an object which specifies the owner of the object (object,\n     optional). It has the following fields:\n     <ul>\n       <li>id: the user identifier of the object owner (string, mandatory).</li>\n       <li>displayName: the screen name of the object owner (string, mandatory).</li>\n     </ul>\n     </li>\n   </ul>\n   </li>\n   <li>commonPrefixes: an array of strings which contains the list of the common\n   prefixes. It can be present only when the delimiter request parameter is\n   specified (array, optional).</li>\n </ul>\n </p>\n", "summary" : "<p>  Lists the objects versions in the default bucket of the default S3\n credentials.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "object()", "description" : "the list of the object versions in the default bucket of the default S3 credentials" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no default bucket is present in the default S3 credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OPTIONS if the specified options are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "list-bucket-versions", "qname" : "s3:list-bucket-versions", "signature" : "($bucket as string?) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Lists the objects versions in a bucket using the default S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n s3:list-bucket-versions(\"28msec\")\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example return object:\n <pre>\n {\n   \"name\": \"bucket\",\n   \"prefix\": \"\",\n   \"keyMarker\" : \"image.jpg\",\n   \"versionIdMarker\" : \"QUpfdndhfd8438MNFDN93jdnJFkdmqnh893\",\n   \"nextKeyMarker\": \"marker\",\n   \"nextVersionIdMarker\": \"UIORUnfndfhnw89493jJFJ\",\n   \"maxKeys\": 1,\n   \"delimiter\": \"/\",\n   \"isTruncated\": true,\n   \"revisions\":\n   [\n     {\n       \"kind\": \"Version\",\n       \"key\": \"image.jpg\",\n       \"versionId\": \"QUpfdndhfd8438MNFDN93jdnJFkdmqnh893\",\n       \"isLatest\": false,\n       \"lastModified\": \"2009-10-12T17:50:30.000Z\",\n       \"eTag\": \"\\\"fba9dede5f27731c9771645a39863328\\\"\",\n       \"size\": 434234,\n       \"storageClass\": \"STANDARD\",\n       \"owner\":\n       {\n         \"id\": \"75aa57f09aa0c8caeab4f8c24e99d10f8e7faeebf76c078efc7c6caea54ba06a\"\n         \"displayName\": \"mtd@amazon.com\"\n       }\n     },\n     {\n       \"kind\": \"DeleteMarker\",\n       \"key\": \"image.jpg\",\n       \"versionId\": \"03jpff543dhffds434rfdsFDN943fdsFkdmqnh892\",\n       \"isLatest\": true,\n       \"lastModified\": \"2009-10-12T17:50:30.000Z\",\n       \"owner\":\n       {\n         \"id\": \"75aa57f09aa0c8caeab4f8c24e99d10f8e7faeebf76c078efc7c6caea54ba06a\"\n         \"displayName\": \"mtd@amazon.com\"\n       }\n     }\n   ],\n   \"commonPrefixes\": [\"photos/\"]\n }\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The fields in the returned object have the following meanings:\n <ul>\n   <li>name: the bucket name (string, mandatory).</li>\n   <li>prefix: the used prefix (string, mandatory).</li>\n   <li>keyMarker: indicates from which key in the listing begins\n   (string, mandatory).</li>\n   <li>versionMarker: indicates from which version  the listing begins\n   (string, optional).</li>\n   <li>nextKeyMarker: when the number of responses exceeds the value of maxKeys,\n   nextKeyMarker specifies the first key not returned that satisfies the search\n   criteria. Use this value for the keyMarker request parameter in a subsequent\n   request. (string, optional)</li>\n   <li>nextVersionMarker: when the number of responses exceeds the value of maxKeys,\n   nextVersionIdMarker specifies the first object version not returned that\n   satisfies the search criteria. Use this value for the versionMarker request\n   parameter in a subsequent request. (string, optional)</li>\n   <li>maxKeys: the maximum number of keys returned in the response body\n   (integer, mandatory).</li>\n   <li>delimiter: the used delimiter (string, optional).</li>\n   <li>isTruncated: whether or not all of the results were returned. All of the\n   results may not be returned if the number of results exceeds that specified\n   by the maxKeys request parameter (boolean, mandatory).</li>\n   <li>revisions: an array of objects listing the bucket object versions\n   (array, mandatory). The fields of each contained object have the following\n   meaning:\n   <ul>\n     <li>kind: the revision kind. One of \"Version\" or \"DeleteMarker\" (string,\n     mandatory).</li>\n     <li>key: the object key (string, mandatory).</li>\n     <li>versionId: the object version id (string, mandatory).</li>\n     <li>lastModified: the object last modification date (dateTime, mandatory).</li>\n     <li>eTag: the entity tag is a hash of the object. The eTag only reflects\n     changes to the contents of an object, not its metadata. The eTag is determined\n     when an object is created. For objects created by the PUT Object operation\n     and the POST Object operation, the eTag is a quoted, 32-digit hexadecimal\n     string representing the MD5 digest of the object data. For other objects,\n     the eTag may or may not be an MD5 digest of the object data. If the eTag is\n     not an MD5 digest of the object data, it will contain one or more non-hexadecimal\n     characters and/or will consist of less than 32 or more than 32 hexadecimal\n     digits.(string, mandatory for \"Version\" objects, not present for\n     \"DeleteMarker\" objects).</li>\n     <li>size: the object size in bytes (integer, mandatory for \"Version\" objects,\n     not present for \"DeleteMarker\" objects).</li>\n     <li>storageClass: the object storage class. One of \"STANDARD\",\n     \"REDUCED_REDUNDANCY\" or \"GLACIER\" (string, mandatory for \"Version\" objects,\n     not present for \"DeleteMarker\" objects).</li>\n     <li>owner: an object which specifies the owner of the object (object,\n     optional). It has the following fields:\n     <ul>\n       <li>id: the user identifier of the object owner (string, mandatory).</li>\n       <li>displayName: the screen name of the object owner (string, mandatory).</li>\n     </ul>\n     </li>\n   </ul>\n   </li>\n   <li>commonPrefixes: an array of strings which contains the list of the common\n   prefixes. It can be present only when the delimiter request parameter is\n   specified (array, optional).</li>\n </ul>\n </p>\n", "summary" : "<p>  Lists the objects versions in a bucket using the default S3 credentials.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "bucket", "type" : "string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The bucket to list. If the empty sequence is given, the default bucket of the default credentials will be listed.</div>" } ], "returns" : { "type" : "object()", "description" : "the list of the object versions in the specified bucket" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OPTIONS if the specified options are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "list-bucket-versions", "qname" : "s3:list-bucket-versions", "signature" : "($bucket as string?, $options as object()?) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Lists the objects versions in a bucket using the default S3 credentials.\n This method allows the specification of additional listing options.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n let $options :=\n {\n   \"delimiter\": \"/\",\n   \"maxKeys\": 2,\n   \"keyMarker\": \"image.jpg\",\n   \"versionIdMarker\" : \"QUpfdndhfd8438MNFDN93jdnJFkdmqnh893\"\n }\n return s3:list-bucket-versions(\"28msec\", $options)\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The options object must have the following structure:\n <ul>\n   <li>delimiter: the delimiter marks where the listed results stop. For example,\n       a delimiter / lists all objects starting with $prefix plus arbitrary\n       characters but not / (string, optional). Default is the empty string,\n       that is, all objects are listed.</li>\n   <li>keyMarker: specifies a key as starting point; following keys (lexicographically\n       greater than the marker) in alphabetical order are listed (string, optional).\n       Default is the empty string, that is, all objects are listed.</li>\n   <li>versionMarker: specifies the object version you want starting from;\n       following revisions (newer than the marker) are listed (string, optional).\n       By default all versions are listed. Empty string is not allowed.</li>\n   <li>maxKeys: the maximum number of keys returned. If more keys than maxKeys\n       can be fetched, the result contains <IsTruncated>true</IsTruncated>\n       (integer, optional). Default is 1000.</li>\n   <li>prefix: only keys starting with the prefix are returned (string, optional).\n       Default is the empty string, that is, all objects are listed.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example return object:\n <pre>\n {\n   \"name\": \"bucket\",\n   \"prefix\": \"\",\n   \"keyMarker\" : \"image.jpg\",\n   \"versionIdMarker\" : \"QUpfdndhfd8438MNFDN93jdnJFkdmqnh893\",\n   \"nextKeyMarker\": \"marker\",\n   \"nextVersionIdMarker\": \"UIORUnfndfhnw89493jJFJ\",\n   \"maxKeys\": 1,\n   \"delimiter\": \"/\",\n   \"isTruncated\": true,\n   \"revisions\":\n   [\n     {\n       \"kind\": \"Version\",\n       \"key\": \"image.jpg\",\n       \"versionId\": \"QUpfdndhfd8438MNFDN93jdnJFkdmqnh893\",\n       \"isLatest\": false,\n       \"lastModified\": \"2009-10-12T17:50:30.000Z\",\n       \"eTag\": \"\\\"fba9dede5f27731c9771645a39863328\\\"\",\n       \"size\": 434234,\n       \"storageClass\": \"STANDARD\",\n       \"owner\":\n       {\n         \"id\": \"75aa57f09aa0c8caeab4f8c24e99d10f8e7faeebf76c078efc7c6caea54ba06a\"\n         \"displayName\": \"mtd@amazon.com\"\n       }\n     },\n     {\n       \"kind\": \"DeleteMarker\",\n       \"key\": \"image.jpg\",\n       \"versionId\": \"03jpff543dhffds434rfdsFDN943fdsFkdmqnh892\",\n       \"isLatest\": true,\n       \"lastModified\": \"2009-10-12T17:50:30.000Z\",\n       \"owner\":\n       {\n         \"id\": \"75aa57f09aa0c8caeab4f8c24e99d10f8e7faeebf76c078efc7c6caea54ba06a\"\n         \"displayName\": \"mtd@amazon.com\"\n       }\n     }\n   ],\n   \"commonPrefixes\": [\"photos/\"]\n }\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The fields in the returned object have the following meanings:\n <ul>\n   <li>name: the bucket name (string, mandatory).</li>\n   <li>prefix: the used prefix (string, mandatory).</li>\n   <li>keyMarker: indicates from which key in the listing begins\n   (string, mandatory).</li>\n   <li>versionMarker: indicates from which version  the listing begins\n   (string, optional).</li>\n   <li>nextKeyMarker: when the number of responses exceeds the value of maxKeys,\n   nextKeyMarker specifies the first key not returned that satisfies the search\n   criteria. Use this value for the keyMarker request parameter in a subsequent\n   request. (string, optional)</li>\n   <li>nextVersionMarker: when the number of responses exceeds the value of maxKeys,\n   nextVersionIdMarker specifies the first object version not returned that\n   satisfies the search criteria. Use this value for the versionMarker request\n   parameter in a subsequent request. (string, optional)</li>\n   <li>maxKeys: the maximum number of keys returned in the response body\n   (integer, mandatory).</li>\n   <li>delimiter: the used delimiter (string, optional).</li>\n   <li>isTruncated: whether or not all of the results were returned. All of the\n   results may not be returned if the number of results exceeds that specified\n   by the maxKeys request parameter (boolean, mandatory).</li>\n   <li>revisions: an array of objects listing the bucket object versions\n   (array, mandatory). The fields of each contained object have the following\n   meaning:\n   <ul>\n     <li>kind: the revision kind. One of \"Version\" or \"DeleteMarker\" (string,\n     mandatory).</li>\n     <li>key: the object key (string, mandatory).</li>\n     <li>versionId: the object version id (string, mandatory).</li>\n     <li>lastModified: the object last modification date (dateTime, mandatory).</li>\n     <li>eTag: the entity tag is a hash of the object. The eTag only reflects\n     changes to the contents of an object, not its metadata. The eTag is determined\n     when an object is created. For objects created by the PUT Object operation\n     and the POST Object operation, the eTag is a quoted, 32-digit hexadecimal\n     string representing the MD5 digest of the object data. For other objects,\n     the eTag may or may not be an MD5 digest of the object data. If the eTag is\n     not an MD5 digest of the object data, it will contain one or more non-hexadecimal\n     characters and/or will consist of less than 32 or more than 32 hexadecimal\n     digits.(string, mandatory for \"Version\" objects, not present for\n     \"DeleteMarker\" objects).</li>\n     <li>size: the object size in bytes (integer, mandatory for \"Version\" objects,\n     not present for \"DeleteMarker\" objects).</li>\n     <li>storageClass: the object storage class. One of \"STANDARD\",\n     \"REDUCED_REDUNDANCY\" or \"GLACIER\" (string, mandatory for \"Version\" objects,\n     not present for \"DeleteMarker\" objects).</li>\n     <li>owner: an object which specifies the owner of the object (object,\n     optional). It has the following fields:\n     <ul>\n       <li>id: the user identifier of the object owner (string, mandatory).</li>\n       <li>displayName: the screen name of the object owner (string, mandatory).</li>\n     </ul>\n     </li>\n   </ul>\n   </li>\n   <li>commonPrefixes: an array of strings which contains the list of the common\n   prefixes. It can be present only when the delimiter request parameter is\n   specified (array, optional).</li>\n </ul>\n </p>\n", "summary" : "<p>  Lists the objects versions in a bucket using the default S3 credentials.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "bucket", "type" : "string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The bucket to list. If the empty sequence is given, the default bucket of the default credentials will be listed.</div>" }, { "name" : "options", "type" : "object()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The listing options.</div>" } ], "returns" : { "type" : "object()", "description" : "the list of the object versions in the specified bucket" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the default credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OPTIONS if the specified options are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "list-bucket-versions", "qname" : "s3:list-bucket-versions", "signature" : "($credentials as item()?, $bucket as string?, $options as object()?) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Lists the objects versions in a bucket using the specified credentials.\n This method allows the specification of additional listing options.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n let $options :=\n {\n   \"delimiter\": \"/\",\n   \"maxKeys\": 2,\n   \"keyMarker\": \"image.jpg\",\n   \"versionIdMarker\": \"QUpfdndhfd8438MNFDN93jdnJFkdmqnh893\"\n }\n return s3:list-bucket-versions(\"credentials\", \"28msec\", $options)\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The options object must have the following structure:\n <ul>\n   <li>delimiter: the delimiter marks where the listed results stop. For example,\n       a delimiter / lists all objects starting with $prefix plus arbitrary\n       characters but not / (string, optional). Default is the empty string,\n       that is, all objects are listed.</li>\n   <li>keyMarker: specifies a key as starting point; following keys (lexicographically\n       greater than the marker) in alphabetical order are listed (string, optional).\n       Default is the empty string, that is, all objects are listed.</li>\n   <li>versionMarker: specifies the object version you want starting from;\n       following revisions (newer than the marker) are listed (string, optional).\n       By default all versions are listed. Empty string is not allowed.</li>\n   <li>maxKeys: the maximum number of keys returned. If more keys than maxKeys\n       can be fetched, the result contains <IsTruncated>true</IsTruncated>\n       (integer, optional). Default is 1000.</li>\n   <li>prefix: only keys starting with the prefix are returned (string, optional).\n       Default is the empty string, that is, all objects are listed.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example return object:\n <pre>\n {\n   \"name\": \"bucket\",\n   \"prefix\": \"\",\n   \"keyMarker\" : \"image.jpg\",\n   \"VersionIdMarker\" : \"QUpfdndhfd8438MNFDN93jdnJFkdmqnh893\",\n   \"nextKeyMarker\": \"marker\",\n   \"nextVersionIdMarker\": \"UIORUnfndfhnw89493jJFJ\",\n   \"maxKeys\": 1,\n   \"delimiter\": \"/\",\n   \"isTruncated\": true,\n   \"revisions\":\n   [\n     {\n       \"kind\": \"Version\",\n       \"key\": \"image.jpg\",\n       \"versionId\": \"QUpfdndhfd8438MNFDN93jdnJFkdmqnh893\",\n       \"isLatest\": false,\n       \"lastModified\": \"2009-10-12T17:50:30.000Z\",\n       \"eTag\": \"\\\"fba9dede5f27731c9771645a39863328\\\"\",\n       \"size\": 434234,\n       \"storageClass\": \"STANDARD\",\n       \"owner\":\n       {\n         \"id\": \"75aa57f09aa0c8caeab4f8c24e99d10f8e7faeebf76c078efc7c6caea54ba06a\"\n         \"displayName\": \"mtd@amazon.com\"\n       }\n     },\n     {\n       \"kind\": \"DeleteMarker\",\n       \"key\": \"image.jpg\",\n       \"versionId\": \"03jpff543dhffds434rfdsFDN943fdsFkdmqnh892\",\n       \"isLatest\": true,\n       \"lastModified\": \"2009-10-12T17:50:30.000Z\",\n       \"owner\":\n       {\n         \"id\": \"75aa57f09aa0c8caeab4f8c24e99d10f8e7faeebf76c078efc7c6caea54ba06a\"\n         \"displayName\": \"mtd@amazon.com\"\n       }\n     }\n   ],\n   \"commonPrefixes\": [\"photos/\"]\n }\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The fields in the returned object have the following meanings:\n <ul>\n   <li>name: the bucket name (string, mandatory).</li>\n   <li>prefix: the used prefix (string, mandatory).</li>\n   <li>keyMarker: indicates from which key in the listing begins\n   (string, mandatory).</li>\n   <li>versionMarker: indicates from which version  the listing begins\n   (string, optional).</li>\n   <li>nextKeyMarker: when the number of responses exceeds the value of maxKeys,\n   nextKeyMarker specifies the first key not returned that satisfies the search\n   criteria. Use this value for the keyMarker request parameter in a subsequent\n   request. (string, optional)</li>\n   <li>nextVersionMarker: when the number of responses exceeds the value of maxKeys,\n   nextVersionIdMarker specifies the first object version not returned that\n   satisfies the search criteria. Use this value for the versionMarker request\n   parameter in a subsequent request. (string, optional)</li>\n   <li>maxKeys: the maximum number of keys returned in the response body\n   (integer, mandatory).</li>\n   <li>delimiter: the used delimiter (string, optional).</li>\n   <li>isTruncated: whether or not all of the results were returned. All of the\n   results may not be returned if the number of results exceeds that specified\n   by the maxKeys request parameter (boolean, mandatory).</li>\n   <li>revisions: an array of objects listing the bucket object versions\n   (array, mandatory). The fields of each contained object have the following\n   meaning:\n   <ul>\n     <li>kind: the revision kind. One of \"Version\" or \"DeleteMarker\" (string,\n     mandatory).</li>\n     <li>key: the object key (string, mandatory).</li>\n     <li>versionId: the object version id (string, mandatory).</li>\n     <li>lastModified: the object last modification date (dateTime, mandatory).</li>\n     <li>eTag: the entity tag is a hash of the object. The eTag only reflects\n     changes to the contents of an object, not its metadata. The eTag is determined\n     when an object is created. For objects created by the PUT Object operation\n     and the POST Object operation, the eTag is a quoted, 32-digit hexadecimal\n     string representing the MD5 digest of the object data. For other objects,\n     the eTag may or may not be an MD5 digest of the object data. If the eTag is\n     not an MD5 digest of the object data, it will contain one or more non-hexadecimal\n     characters and/or will consist of less than 32 or more than 32 hexadecimal\n     digits.(string, mandatory for \"Version\" objects, not present for\n     \"DeleteMarker\" objects).</li>\n     <li>size: the object size in bytes (integer, mandatory for \"Version\" objects,\n     not present for \"DeleteMarker\" objects).</li>\n     <li>storageClass: the object storage class. One of \"STANDARD\",\n     \"REDUCED_REDUNDANCY\" or \"GLACIER\" (string, mandatory for \"Version\" objects,\n     not present for \"DeleteMarker\" objects).</li>\n     <li>owner: an object which specifies the owner of the object (object,\n     optional). It has the following fields:\n     <ul>\n       <li>id: the user identifier of the object owner (string, mandatory).</li>\n       <li>displayName: the screen name of the object owner (string, mandatory).</li>\n     </ul>\n     </li>\n   </ul>\n   </li>\n   <li>commonPrefixes: an array of strings which contains the list of the common\n   prefixes. It can be present only when the delimiter request parameter is\n   specified (array, optional).</li>\n </ul>\n </p>\n", "summary" : "<p>  Lists the objects versions in a bucket using the specified credentials.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "credentials", "type" : "item()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials to use.</div>" }, { "name" : "bucket", "type" : "string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The bucket to list. If the empty sequence is given, the default bucket of the specified credentials will be listed.</div>" }, { "name" : "options", "type" : "object()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The listing options.</div>" } ], "returns" : { "type" : "object()", "description" : "the list of the object in the specified bucket" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OPTIONS if the specified options are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 0, "name" : "list-bucket", "qname" : "s3:list-bucket", "signature" : "() as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Lists the objects in the default bucket of the default S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n s3:list-bucket(\"28msec\")\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example return object:\n <pre>\n {\n   \"name\": \"28msec\",\n   \"prefix\": \"\",\n   \"marker\" : \"\",\n   \"nextMarker\": \"marker\",\n   \"maxKeys\": 1,\n   \"delimiter\": \"\",\n   \"isTruncated\": true,\n   \"contents\":\n   [\n     {\n       \"key\": \"image.jpg\",\n       \"lastModified\": \"2009-10-12T17:50:30.000Z\",\n       \"eTag\": \"\\\"fba9dede5f27731c9771645a39863328\\\"\",\n       \"size\": 434234,\n       \"storageClass\": \"STANDARD\"\n       \"owner\":\n       {\n         \"id\": \"75aa57f09aa0c8caeab4f8c24e99d10f8e7faeebf76c078efc7c6caea54ba06a\"\n         \"displayName\": \"mtd@amazon.com\"\n       }\n     }\n   ]\n }\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The fields in the returned object have the following meanings:\n <ul>\n   <li>name: the bucket name (string, mandatory).</li>\n   <li>prefix: the used prefix (string, mandatory).</li>\n   <li>marker: indicates where in the bucket listing begins (string, mandatory).</li>\n   <li>nextMarker: when the response is truncated, you can use the key name\n   in this field as marker in the subsequent request to get next set of objects.\n   Amazon S3 lists objects in alphabetical order. This field is returned only\n   if you have specified the delimiter request parameter. If the response does\n   not include the nextMaker field and it is truncated, you can use the value\n   of the last Key in the response as the marker in the subsequent request to\n   get the next set of object keys. (string, optional)</li>\n   <li>maxKeys: the maximum number of keys returned in the response body\n   (integer, mandatory).</li>\n   <li>delimiter: the used delimiter (string, optional).</li>\n   <li>isTruncated: whether or not all of the results were returned. All of the\n   results may not be returned if the number of results exceeds that specified\n   by the maxKeys request parameter (boolean, mandatory).</li>\n   <li>contents: an array of objects listing the bucket content  (array, mandatory).\n   The fields of each contained object have the following meaning:\n   <ul>\n     <li>key: the object key (string, mandatory).</li>\n     <li>lastModified: the object last modification date (dateTime, mandatory).</li>\n     <li>eTag: the entity tag is a hash of the object. The eTag only reflects\n     changes to the contents of an object, not its metadata. The eTag is determined\n     when an object is created. For objects created by the PUT Object operation\n     and the POST Object operation, the eTag is a quoted, 32-digit hexadecimal\n     string representing the MD5 digest of the object data. For other objects,\n     the eTag may or may not be an MD5 digest of the object data. If the eTag is\n     not an MD5 digest of the object data, it will contain one or more non-hexadecimal\n     characters and/or will consist of less than 32 or more than 32 hexadecimal\n     digits.(string, mandatory).</li>\n     <li>storageClass: the object storage class. One of \"STANDARD\",\n     \"REDUCED_REDUNDANCY\" or \"GLACIER\" (string, mandatory).</li>\n     <li>owner: an object which specifies the owner of the object (object,\n     optional). It has the following fields:\n     <ul>\n       <li>id: the user identifier of the object owner (string, mandatory).</li>\n       <li>displayName: the screen name of the object owner (string, mandatory).</li>\n     </ul>\n     </li>\n   </ul>\n   </li>\n </ul>\n </p>\n", "summary" : "<p>  Lists the objects in the default bucket of the default S3 credentials.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "object()", "description" : "the list of objects in the default bucket of the default S3 credentials" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no default bucket is present in the default S3 credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OPTIONS if the specified options are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "list-bucket", "qname" : "s3:list-bucket", "signature" : "($bucket as string?) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Lists the objects in a bucket using the default S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n s3:list-bucket(\"28msec\")\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example return object:\n <pre>\n {\n   \"name\": \"28msec\",\n   \"prefix\": \"\",\n   \"marker\" : \"\",\n   \"nextMarker\": \"marker\",\n   \"maxKeys\": 1,\n   \"delimiter\": \"\",\n   \"isTruncated\": true,\n   \"contents\":\n   [\n     {\n       \"key\": \"image.jpg\",\n       \"lastModified\": \"2009-10-12T17:50:30.000Z\",\n       \"eTag\": \"\\\"fba9dede5f27731c9771645a39863328\\\"\",\n       \"size\": 434234,\n       \"storageClass\": \"STANDARD\"\n       \"owner\":\n       {\n         \"id\": \"75aa57f09aa0c8caeab4f8c24e99d10f8e7faeebf76c078efc7c6caea54ba06a\"\n         \"displayName\": \"mtd@amazon.com\"\n       }\n     }\n   ]\n }\n </pre>\n The meanings of the fields in the return object are the following:\n <ul>\n   <li>name: the bucket name (string, mandatory).</li>\n   <li>prefix: the used prefix (string, mandatory).</li>\n   <li>marker: indicates where in the bucket listing begins (string, mandatory).</li>\n   <li>nextMarker: when the response is truncated, you can use the key name\n   in this field as marker in the subsequent request to get next set of objects.\n   Amazon S3 lists objects in alphabetical order. This field is returned only\n   if you have specified the delimiter request parameter. If the response does\n   not include the nextMaker field and it is truncated, you can use the value\n   of the last Key in the response as the marker in the subsequent request to\n   get the next set of object keys. (string, optional)</li>\n   <li>maxKeys: the maximum number of keys returned in the response body\n   (integer, mandatory).</li>\n   <li>delimiter: the used delimiter (string, optional).</li>\n   <li>isTruncated: whether or not all of the results were returned. All of the\n   results may not be returned if the number of results exceeds that specified\n   by the maxKeys request parameter (boolean, mandatory).</li>\n   <li>contents: an array of objects listing the bucket content  (array, mandatory).\n   The fields of each contained object have the following meaning:\n   <ul>\n     <li>key: the object key (string, mandatory).</li>\n     <li>lastModified: the object last modification date (dateTime, mandatory).</li>\n     <li>eTag: the entity tag is a hash of the object. The eTag only reflects\n     changes to the contents of an object, not its metadata. The eTag is determined\n     when an object is created. For objects created by the PUT Object operation\n     and the POST Object operation, the eTag is a quoted, 32-digit hexadecimal\n     string representing the MD5 digest of the object data. For other objects,\n     the eTag may or may not be an MD5 digest of the object data. If the eTag is\n     not an MD5 digest of the object data, it will contain one or more non-hexadecimal\n     characters and/or will consist of less than 32 or more than 32 hexadecimal\n     digits.(string, mandatory).</li>\n     <li>storageClass: the object storage class. One of \"STANDARD\",\n     \"REDUCED_REDUNDANCY\" or \"GLACIER\" (string, mandatory).</li>\n     <li>owner: an object which specifies the owner of the object (object,\n     optional). It has the following fields:\n     <ul>\n       <li>id: the user identifier of the object owner (string, mandatory).</li>\n       <li>displayName: the screen name of the object owner (string, mandatory).</li>\n     </ul>\n     </li>\n   </ul>\n   </li>\n </ul>\n </p>\n", "summary" : "<p>  Lists the objects in a bucket using the default S3 credentials.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "bucket", "type" : "string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The bucket to list. If the empty sequence is given, the default bucket of the default S3 credentials will be listed.</div>" } ], "returns" : { "type" : "object()", "description" : "the list of the objects in the specified bucket." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OPTIONS if the specified options are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "list-bucket", "qname" : "s3:list-bucket", "signature" : "($bucket as string?, $options as object()?) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Lists the objects in a bucket using the default S3 credentials.\n This method allows the specification of additional listing options.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n let $options :=\n {\n   \"delimiter\": \"/\",\n   \"marker\": \"\",\n   \"maxKeys\": 1,\n   \"prefix\": \"\"\n }\n return s3:list-bucket(\"credentials\", \"28msec\", $options)\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The options object must have the following structure:\n <ul>\n   <li>delimiter: the delimiter marks where the listed results stop. For example,\n       a delimiter / lists all objects starting with $prefix plus arbitrary\n       characters but not / (string, optional). Default is the empty string,\n       that is, all objects are listed.</li>\n   <li>marker: specifies a key as starting point; following keys (lexicographically\n       greater than the marker) in alphabetical order are listed (string, optional).\n       Default is the empty string, that is, all objects are listed.</li>\n   <li>maxKeys: the maximum number of keys returned. If more keys than maxKeys\n       can be fetched, the result contains <IsTruncated>true</IsTruncated>\n       (integer, optional). Default is 1000.</li>\n   <li>prefix: only keys starting with the prefix are returned (string, optional).\n       Default is the empty string, that is, all objects are listed.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example return object:\n <pre>\n {\n   \"name\": \"bucket\",\n   \"prefix\": \"\",\n   \"marker\" : \"\",\n   \"nextMarker\": \"marker\",\n   \"maxKeys\": 1,\n   \"delimiter\": \"/\",\n   \"isTruncated\": true,\n   \"contents\":\n   [\n     {\n       \"key\": \"image.jpg\",\n       \"lastModified\": \"2009-10-12T17:50:30.000Z\",\n       \"eTag\": \"\\\"fba9dede5f27731c9771645a39863328\\\"\",\n       \"size\": 434234,\n       \"storageClass\": \"STANDARD\"\n       \"owner\":\n       {\n         \"id\": \"75aa57f09aa0c8caeab4f8c24e99d10f8e7faeebf76c078efc7c6caea54ba06a\"\n         \"displayName\": \"mtd@amazon.com\"\n       }\n     }\n   ],\n   \"commonPrefixes\": [\"photos/\"]\n }\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The fields in the returned object have the following meanings:\n <ul>\n   <li>name: the bucket name (string, mandatory).</li>\n   <li>prefix: the used prefix (string, mandatory).</li>\n   <li>marker: indicates where in the bucket listing begins (string, mandatory).</li>\n   <li>nextMarker: when the response is truncated, you can use the key name\n   in this field as marker in the subsequent request to get next set of objects.\n   Amazon S3 lists objects in alphabetical order. This field is returned only\n   if you have specified the delimiter request parameter. If the response does\n   not include the nextMaker field and it is truncated, you can use the value\n   of the last Key in the response as the marker in the subsequent request to\n   get the next set of object keys. (string, optional)</li>\n   <li>maxKeys: the maximum number of keys returned in the response body\n   (integer, mandatory).</li>\n   <li>delimiter: the used delimiter (string, optional).</li>\n   <li>isTruncated: whether or not all of the results were returned. All of the\n   results may not be returned if the number of results exceeds that specified\n   by the maxKeys request parameter (boolean, mandatory).</li>\n   <li>contents: an array of objects listing the bucket content  (array, mandatory).\n   The fields of each contained object have the following meaning:\n   <ul>\n     <li>key: the object key (string, mandatory).</li>\n     <li>lastModified: the object last modification date (dateTime, mandatory).</li>\n     <li>eTag: the entity tag is a hash of the object. The eTag only reflects\n     changes to the contents of an object, not its metadata. The eTag is determined\n     when an object is created. For objects created by the PUT Object operation\n     and the POST Object operation, the eTag is a quoted, 32-digit hexadecimal\n     string representing the MD5 digest of the object data. For other objects,\n     the eTag may or may not be an MD5 digest of the object data. If the eTag is\n     not an MD5 digest of the object data, it will contain one or more non-hexadecimal\n     characters and/or will consist of less than 32 or more than 32 hexadecimal\n     digits.(string, mandatory).</li>\n     <li>storageClass: the object storage class. One of \"STANDARD\",\n     \"REDUCED_REDUNDANCY\" or \"GLACIER\" (string, mandatory).</li>\n     <li>owner: an object which specifies the owner of the object (object,\n     optional). It has the following fields:\n     <ul>\n       <li>id: the user identifier of the object owner (string, mandatory).</li>\n       <li>displayName: the screen name of the object owner (string, mandatory).</li>\n     </ul>\n     </li>\n   </ul>\n   </li>\n   <li>commonPrefixes: an array of strings which contains the list of the common\n   prefixes. It can be present only when the delimiter request parameter is\n   specified (array, optional).</li>\n </ul>\n </p>\n", "summary" : "<p>  Lists the objects in a bucket using the default S3 credentials.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "bucket", "type" : "string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The bucket to list. If the empty sequence is given, the default bucket of the default S3 credentials will be listed.</div>" }, { "name" : "options", "type" : "object()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The listing options.</div>" } ], "returns" : { "type" : "object()", "description" : "the list of the object in the specified bucket" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the default credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OPTIONS if the specified options are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "list-bucket", "qname" : "s3:list-bucket", "signature" : "($credentials as item()?, $bucket as string?, $options as object()?) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Lists the objects in a bucket using the specified credentials.\n This method allows the specification of additional listing options.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n let $options :=\n {\n   \"delimiter\": \"/\",\n   \"marker\": \"\",\n   \"maxKeys\": 1,\n   \"prefix\": \"\"\n }\n return s3:list-bucket(\"credentials\", \"28msec\", $options)\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The options object must have the following structure:\n <ul>\n   <li>delimiter: the delimiter marks where the listed results stop. For example,\n       a delimiter / lists all objects starting with $prefix plus arbitrary\n       characters but not / (string, optional). Default is the empty string,\n       that is, all objects are listed.</li>\n   <li>marker: specifies a key as starting point; following keys (lexicographically\n       greater than the marker) in alphabetical order are listed (string, optional).\n       Default is the empty string, that is, all objects are listed.</li>\n   <li>maxKeys: the maximum number of keys returned. If more keys than maxKeys\n       can be fetched, the result contains <IsTruncated>true</IsTruncated>\n       (integer, optional). Default is 1000.</li>\n   <li>prefix: only keys starting with the prefix are returned (string, optional).\n       Default is the empty string, that is, all objects are listed.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example result:\n <pre>\n {\n   \"name\": \"bucket\",\n   \"prefix\": \"\",\n   \"marker\" : \"\",\n   \"nextMarker\": \"marker\",\n   \"maxKeys\": 1,\n   \"delimiter\": \"/\",\n   \"isTruncated\": true,\n   \"contents\":\n   [\n     {\n       \"key\": \"image.jpg\",\n       \"lastModified\": \"2009-10-12T17:50:30.000Z\",\n       \"eTag\": \"\\\"fba9dede5f27731c9771645a39863328\\\"\",\n       \"size\": 434234,\n       \"storageClass\": \"STANDARD\"\n       \"owner\":\n       {\n         \"id\": \"75aa57f09aa0c8caeab4f8c24e99d10f8e7faeebf76c078efc7c6caea54ba06a\"\n         \"displayName\": \"mtd@amazon.com\"\n       }\n     }\n   ],\n   \"commonPrefixes\": [\"photos/\"]\n }\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The fields in the returned object have the following meanings:\n <ul>\n   <li>name: the bucket name (string, mandatory).</li>\n   <li>prefix: the used prefix (string, mandatory).</li>\n   <li>marker: indicates where in the bucket listing begins (string, mandatory).</li>\n   <li>nextMarker: when the response is truncated, you can use the key name\n   in this field as marker in the subsequent request to get next set of objects.\n   Amazon S3 lists objects in alphabetical order. This field is returned only\n   if you have specified the delimiter request parameter. If the response does\n   not include the nextMaker field and it is truncated, you can use the value\n   of the last Key in the response as the marker in the subsequent request to\n   get the next set of object keys. (string, optional)</li>\n   <li>maxKeys: the maximum number of keys returned in the response body\n   (integer, mandatory).</li>\n   <li>delimiter: the used delimiter (string, optional).</li>\n   <li>isTruncated: whether or not all of the results were returned. All of the\n   results may not be returned if the number of results exceeds that specified\n   by the maxKeys request parameter (boolean, mandatory).</li>\n   <li>contents: an array of objects listing the bucket content  (array, mandatory).\n   The fields of each contained object have the following meaning:\n   <ul>\n     <li>key: the object key (string, mandatory).</li>\n     <li>lastModified: the object last modification date (dateTime, mandatory).</li>\n     <li>eTag: the entity tag is a hash of the object. The eTag only reflects\n     changes to the contents of an object, not its metadata. The eTag is determined\n     when an object is created. For objects created by the PUT Object operation\n     and the POST Object operation, the eTag is a quoted, 32-digit hexadecimal\n     string representing the MD5 digest of the object data. For other objects,\n     the eTag may or may not be an MD5 digest of the object data. If the eTag is\n     not an MD5 digest of the object data, it will contain one or more non-hexadecimal\n     characters and/or will consist of less than 32 or more than 32 hexadecimal\n     digits.(string, mandatory).</li>\n     <li>storageClass: the object storage class. One of \"STANDARD\",\n     \"REDUCED_REDUNDANCY\" or \"GLACIER\" (string, mandatory).</li>\n     <li>owner: an object which specifies the owner of the object (object,\n     optional). It has the following fields:\n     <ul>\n       <li>id: the user identifier of the object owner (string, mandatory).</li>\n       <li>displayName: the screen name of the object owner (string, mandatory).</li>\n     </ul>\n     </li>\n   </ul>\n   </li>\n   <li>commonPrefixes: an array of strings which contains the list of the common\n   prefixes. It can be present only when the delimiter request parameter is\n   specified (array, optional).</li>\n </ul>\n </p>\n", "summary" : "<p>  Lists the objects in a bucket using the specified credentials.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "credentials", "type" : "item()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials to use.</div>" }, { "name" : "bucket", "type" : "string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The bucket to list. If the empty sequence is given, the default bucket of the specified credentials will be listed.</div>" }, { "name" : "options", "type" : "object()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The listing options.</div>" } ], "returns" : { "type" : "object()", "description" : "the list of the object in the specified bucket" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OPTIONS if the specified options are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 0, "name" : "list-buckets-nondeterministic", "qname" : "s3:list-buckets-nondeterministic", "signature" : "() as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Lists all buckets owned by the account of the default S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as\n <a href=\"#list-buckets-0\">list-buckets#0</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Lists all buckets owned by the account of the default S3 credentials.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "object()", "description" : "the owned buckets list" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the default S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "list-buckets-nondeterministic", "qname" : "s3:list-buckets-nondeterministic", "signature" : "($credentials as item()?) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Lists all buckets owned by the account of the specified S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as\n <a href=\"#list-buckets-1\">list-buckets#1</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Lists all buckets owned by the account of the specified S3 credentials.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "credentials", "type" : "item()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials to use.</div>" } ], "returns" : { "type" : "object()", "description" : "the owned buckets list" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 0, "name" : "list-buckets", "qname" : "s3:list-buckets", "signature" : "() as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Lists all buckets owned by the account of the default S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n s3:list-buckets()\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example return object:\n <pre>\n {\n   \"owner\" :\n   {\n     \"id\": \"dfe08489302934392afe39239fe953039d9e2af0c94\",\n     \"displayName\": \"28msec\"\n   },\n   \"buckets\" :\n   [\n     {\n       \"name\": \"28msec\",\n       \"creationDate\": \"2010-11-03T17:42:45.000Z\",\n     }\n   ]\n }\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The fields in the returned object have the following meanings:\n <ul>\n   <li>owner: an object which specifies the owner of the bucket (object,\n   mandatory). It has the following fields:\n   <ul>\n     <li>id: the user identifier of the bucket owner (string, mandatory).</li>\n     <li>displayName: the screen name of the bucket owner (string, mandatory).</li>\n   </ul>\n   </li>\n   <li>buckets: an array which contains an object for each owned bucket\n   (array, mandatory). Each object contains the following fields:\n   <ul>\n     <li>name: the bucket name (string, mandatory).</li>\n     <li>creationDate: the bucket creation date. (dateTime, mandatory).</li>\n   </ul>\n   </li>\n </ul>\n </p>\n", "summary" : "<p>  Lists all buckets owned by the account of the default S3 credentials.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "object()", "description" : "the owned buckets list" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the default S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "list-buckets", "qname" : "s3:list-buckets", "signature" : "($credentials as item()?) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Lists all buckets owned by the account of the specified S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n s3:list-buckets(\"credentials\")\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example return object:\n <pre>\n {\n   \"owner\" :\n   {\n     \"id\": \"dfe08489302934392afe39239fe953039d9e2af0c94\",\n     \"displayName\": \"28msec\"\n   },\n   \"buckets\" :\n   [\n     {\n       \"name\": \"28msec\",\n       \"creationDate\": \"2010-11-03T17:42:45.000Z\",\n     }\n   ]\n }\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The fields in the returned object have the following meanings:\n <ul>\n   <li>owner: an object which specifies the owner of the bucket (object,\n   mandatory). It has the following fields:\n   <ul>\n     <li>id: the user identifier of the bucket owner (string, mandatory).</li>\n     <li>displayName: the screen name of the bucket owner (string, mandatory).</li>\n   </ul>\n   </li>\n   <li>buckets: an array which contains an object for each owned bucket\n   (array, mandatory). Each object contains the following fields:\n   <ul>\n     <li>name: the bucket name (string, mandatory).</li>\n     <li>creationDate: the bucket creation date. (dateTime, mandatory).</li>\n   </ul>\n   </li>\n </ul>\n </p>\n", "summary" : "<p>  Lists all buckets owned by the account of the specified S3 credentials.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "credentials", "type" : "item()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials to use.</div>" } ], "returns" : { "type" : "object()", "description" : "the owned buckets list" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "object-metadata-nondeterministic", "qname" : "s3:object-metadata-nondeterministic", "signature" : "($s3-object as item()) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves an object metadata using the default S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as\n <a href=\"#object-metadata-1\">object-metadata#1</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Retrieves an object metadata using the default S3 credentials.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object or object version to retrieve the metadata for.</div>" } ], "returns" : { "type" : "object()", "description" : "the specified object metadata." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the default S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "object-metadata-nondeterministic", "qname" : "s3:object-metadata-nondeterministic", "signature" : "($credentials as item()?, $s3-object as item()) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves an object metadata using the specified S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as\n <a href=\"#object-metadata-2\">object-metadata#2</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Retrieves an object metadata using the specified S3 credentials.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "credentials", "type" : "item()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials to use.</div>" }, { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object or object version to retrieve the metadata for.</div>" } ], "returns" : { "type" : "object()", "description" : "the specified object metadata." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "object-metadata", "qname" : "s3:object-metadata", "signature" : "($s3-object as item()) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves an object metadata using the default S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The S3 object is specified through the $s3-object parameter. Either a string\n or a JSON object can be used. If a string is specified, it is interpreted as\n key for an object in the default bucket of the default credentials. If no default\n bucket is present in the default credentials, the <code>s3:BUCKET</code> error\n is raised. If a JSON object is used, it must have the following structure:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, optional). If this field is not present\n   and the default credentials do not have a default bucket, the\n   <code>s3:BUCKET</code> error is raised.</li>\n   <li>version: the object version (string, optional). If versioning is enabled\n   for the specified object and no version is specified the metadata of the\n   latest version of the object will be returned. If specified, only the\n   metadata of that particular version of the object will be returned.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n let $object :=\n {\n   \"key\": \"object\",\n   \"bucket\": \"28msec\",\n   \"version\": \"3/L4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo\"\n }\n return s3:metadata-object($object)\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example return object:\n <pre>\n {\n   \"key\": \"test.xml\",\n   \"bucket\": \"28msec\",\n   \"metadata\":\n   {\n     \"author\": \"28msec\"\n   },\n   \"missing-metadata\" : 1,\n   \"version\": \"3GL4kqtJlcpXroDTDm3vjVBH40Nr8X8g\",\n   \"expiration\": \"expiry-date=\\\"Fri, 21 Dec 2012 00:00:00 GMT\\\", rule-id=\\\"Rule for testfile.txt\\\"\"\n   \"restore\": \"x-amz-restore: ongoing-request=\\\"false\\\", expiry-date=\\\"Wed, 07 Nov 2012 00:00:00 GMT\\\"\"\n   \"serverSideEncryption\": \"AES256\",\n   \"lastModified\": \"Mon, 15 Oct 2012 21:58:07 GMT\",\n   \"eTag\": \"1accb31fcf202eba0c0f41fa2f09b4d7\",\n   \"mediaType\": \"text/plain\"\n   \"length\": \"28\"\n }\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The fields in the returned object have the following meanings:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, mandatory).</li>\n   <li>metadata: an object specifying additional metadata. Each metadata is a\n   name-value pair and is represented as different fields (object, optional).</li>\n   <li>missing-metadata: the number of metadata entries that were not returned\n   in the metadata object. This can happen if you create metadata using an API\n   like SOAP that supports more flexible metadata than the REST API. (integer,\n   optional).</li>\n   <li>version: the object version (string, optional). If versioning is enabled\n   for the specified object and no version is specified the permissions for the\n   latest version of the object will be returned. If specified, only the\n   permissions for that particular version of the object will be returned.</li>\n   <li>expiration: if the object expiration is configured (see\n   <a href=\"http://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlifecycle.html\">PUT Bucket lifecycle</a>),\n   this field is present. It includes the expiry-date and rule-id key value\n   pairs providing object expiration information. The value of rule-id is URL\n   encoded.(string, optional).</li>\n   <li>restore: if the object is an archived object (an object whose storage\n   class is Glacier), the response includes this header if either the archive\n   restoration is in progress (see\n   <a href=\"http://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPOSTrestore.html\">POST Object restore</a>),\n   or an archive copy is already restored.(string, optional).</li>\n   <li>serverSideEncryption: If the object is stored by using server-side\n   encryption, the response includes this header with a value of the encryption\n   algorithm that was used.(string, optional).</li>\n   <li>lastModified: the date in which the object was last modified (dateTime,\n   optional).</li>\n   <li>eTag: the entity tag is a hash of the object. The eTag only reflects\n   changes to the contents of an object, not its metadata. The eTag is determined\n   when an object is created. For objects created by the PUT Object operation\n   and the POST Object operation, the eTag is a quoted, 32-digit hexadecimal\n   string representing the MD5 digest of the object data. For other objects,\n   the eTag may or may not be an MD5 digest of the object data. If the eTag is\n   not an MD5 digest of the object data, it will contain one or more non-hexadecimal\n   characters and/or will consist of less than 32 or more than 32 hexadecimal\n   digits.(string, optional).</li>\n   <li>mediaType: the object media-type (string, mandatory).</li>\n   <li>length: the object content length (integer, optional).</li>\n </ul>\n </p>\n", "summary" : "<p>  Retrieves an object metadata using the default S3 credentials.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object or object version to retrieve the metadata for.</div>" } ], "returns" : { "type" : "object()", "description" : "the specified object metadata." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the default S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "object-metadata", "qname" : "s3:object-metadata", "signature" : "($credentials as item()?, $s3-object as item()) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves an object metadata using the specified S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The S3 object is specified through the $s3-object parameter. Either a string\n or a JSON object can be used. If a string is specified, it is interpreted as\n key for an object in the default bucket of the specified credentials. If no default\n bucket is present in the specified credentials, the <code>s3:BUCKET</code> error\n is raised. If a JSON object is used, it must have the following structure:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, optional). If this field is not present\n   and the specified credentials do not have a default bucket, the\n   <code>s3:BUCKET</code> error is raised.</li>\n   <li>version: the object version (string, optional). If versioning is enabled\n   for the specified object and no version is specified the metadata of the\n   latest version of the object will be returned. If specified, only the\n   metadata of that particular version of the object will be returned.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n let $object :=\n {\n   \"key\": \"object\",\n   \"bucket\": \"28msec\",\n   \"version\": \"3/L4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo\"\n }\n return s3:metadata-object(\"credentials\", $object)\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example return object:\n <pre>\n {\n   \"key\": \"test.xml\",\n   \"bucket\": \"28msec\",\n   \"metadata\":\n   {\n     \"author\": \"28msec\"\n   },\n   \"missing-metadata\" : 1,\n   \"version\": \"3GL4kqtJlcpXroDTDm3vjVBH40Nr8X8g\",\n   \"expiration\": \"expiry-date=\\\"Fri, 21 Dec 2012 00:00:00 GMT\\\", rule-id=\\\"Rule for testfile.txt\\\"\"\n   \"restore\": \"x-amz-restore: ongoing-request=\\\"false\\\", expiry-date=\\\"Wed, 07 Nov 2012 00:00:00 GMT\\\"\"\n   \"serverSideEncryption\": \"AES256\",\n   \"lastModified\": \"Mon, 15 Oct 2012 21:58:07 GMT\",\n   \"eTag\": \"1accb31fcf202eba0c0f41fa2f09b4d7\",\n   \"mediaType\": \"text/plain\"\n   \"length\": \"28\"\n }\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The fields in the returned object have the following meanings:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, mandatory).</li>\n   <li>metadata: an object specifying additional metadata. Each metadata is a\n   name-value pair and is represented as different fields (object, optional).</li>\n   <li>missing-metadata: the number of metadata entries that were not returned\n   in the metadata object. This can happen if you create metadata using an API\n   like SOAP that supports more flexible metadata than the REST API. (integer,\n   optional).</li>\n   <li>version: the object version (string, optional). If versioning is enabled\n   for the specified object and no version is specified the permissions for the\n   latest version of the object will be returned. If specified, only the\n   permissions for that particular version of the object will be returned.</li>\n   <li>expiration: if the object expiration is configured (see\n   <a href=\"http://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlifecycle.html\">PUT Bucket lifecycle</a>),\n   this field is present. It includes the expiry-date and rule-id key value\n   pairs providing object expiration information. The value of rule-id is URL\n   encoded.(string, optional).</li>\n   <li>restore: if the object is an archived object (an object whose storage\n   class is Glacier), the response includes this header if either the archive\n   restoration is in progress (see\n   <a href=\"http://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPOSTrestore.html\">POST Object restore</a>),\n   or an archive copy is already restored.(string, optional).</li>\n   <li>serverSideEncryption: If the object is stored by using server-side\n   encryption, the response includes this header with a value of the encryption\n   algorithm that was used.(string, optional).</li>\n   <li>lastModified: the date in which the object was last modified (dateTime,\n   optional).</li>\n   <li>eTag: the entity tag is a hash of the object. The eTag only reflects\n   changes to the contents of an object, not its metadata. The eTag is determined\n   when an object is created. For objects created by the PUT Object operation\n   and the POST Object operation, the eTag is a quoted, 32-digit hexadecimal\n   string representing the MD5 digest of the object data. For other objects,\n   the eTag may or may not be an MD5 digest of the object data. If the eTag is\n   not an MD5 digest of the object data, it will contain one or more non-hexadecimal\n   characters and/or will consist of less than 32 or more than 32 hexadecimal\n   digits.(string, optional).</li>\n   <li>mediaType: the object media-type (string, mandatory).</li>\n   <li>length: the object content length (integer, optional).</li>\n </ul>\n </p>\n", "summary" : "<p>  Retrieves an object metadata using the specified S3 credentials.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "credentials", "type" : "item()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials to use.</div>" }, { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object or object version to retrieve the metadata for.</div>" } ], "returns" : { "type" : "object()", "description" : "the specified object metadata." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "object-permissions-nondeterministic", "qname" : "s3:object-permissions-nondeterministic", "signature" : "($s3-object as item()) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves the access control list (ACL) of an S3 object using the default\n S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as\n <a href=\"#object-permissions-1\">object-permissions#1</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Retrieves the access control list (ACL) of an S3 object using the default\n S3 credentials.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object or object version to retrieve the ACL for.</div>" } ], "returns" : { "type" : "object()", "description" : "the object ACL" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the default S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "object-permissions-nondeterministic", "qname" : "s3:object-permissions-nondeterministic", "signature" : "($credentials as item()?, $s3-object as item()) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves the access control list (ACL) of an S3 object using the specified\n credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as\n <a href=\"#object-permissions-2\">object-permissions#2</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Retrieves the access control list (ACL) of an S3 object using the specified\n credentials.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "credentials", "type" : "item()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials to use.</div>" }, { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object or object version to retrieve the ACL for.</div>" } ], "returns" : { "type" : "object()", "description" : "the object ACL" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "object-permissions", "qname" : "s3:object-permissions", "signature" : "($s3-object as item()) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves the access control list (ACL) of an S3 object using the default\n S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The S3 object is specified through the $s3-object parameter. Either a string\n or a JSON object can be used. If a string is specified, it is interpreted as\n key for an object in the default bucket of the default credentials. If no default\n bucket is present in the default credentials, the <code>s3:BUCKET</code> error\n is raised. If a JSON object is used, it must have the following structure:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, optional). If this field is not present\n   and the default credentials do not have a default bucket, the\n   <code>s3:BUCKET</code> error is raised.</li>\n   <li>version: the object version (string, optional). If versioning is enabled\n   for the specified object and no version is specified the permissions for the\n   latest version of the object will be returned. If specified, only the\n   permissions for that particular version of the object will be returned.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n let $object :=\n {\n   \"key\": \"object\",\n   \"bucket\": \"28msec\",\n   \"version\": \"3/L4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo\"\n }\n return s3:object-permissions($object)\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example return object:\n <pre>\n {\n   \"owner\" :\n   {\n     \"id\" : \"ea3617f5543e366a51bf51f440c221410b8001c34744e9d3a81acb79cff9d2ed\",\n     \"displayName\" : \"28msec\"\n   },\n   \"acl\" :\n   [\n     {\n       \"grantee\" :\n       {\n         \"type\" : \"CanonicalUser\",\n         \"id\" : \"ea3617f5543e366a51bf51f440c221410b8001c34744e9d3a81acb79cff9d2ed\",\n         \"displayName\" : \"28msec\"\n       },\n       \"permission\" : \"FULL_CONTROL\"\n     }\n   ]\n }\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The fields in the returned object have the following meanings:\n <ul>\n <li>owner: an object which specifies the owner of the object (object,\n mandatory). It has the following fields:\n   <ul>\n     <li>id: the user identifier of the object owner (string, mandatory).</li>\n     <li>displayName: the screen name of the object owner (string, mandatory).</li>\n   </ul>\n </li>\n <li>acl: an array which contains an object for each grantee with the corresponding\n ACL settings (array, mandatory). Each object contains the following fields:\n   <ul>\n     <li>grantee: specifies the permissions grantee (object, mandatory). It\n     contains the following fields:\n       <ul>\n         <li>type: one of \"AmazonCustomerByEmail\", \"CanonicalUser\" or \"Group\".</li>\n         <li>emailAddress: the customer email address (string, present in all\n         and only AmazonCustomerByEmail grantees).</li>\n         <li>id: the user identifier (string, present in all and only CanonicalUser\n         grantees).</li>\n         <li>displayName: the user screen name (string, present in all and only\n         CanonicalUser grantees).</li>\n         <li>URI: the group URI (string, present in all and only Group grantees).</li>\n       </ul>\n     </li>\n     <li>permission: the granted permissions. One of \"READ\", \"WRITE\", \"READ_ACP\",\n     \"WRITE_ACP\", \"FULL_CONTROL\". (string, mandatory).</li>\n   </ul>\n </li>\n </ul>\n </p>\n", "summary" : "<p>  Retrieves the access control list (ACL) of an S3 object using the default\n S3 credentials.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object or object version to retrieve the ACL for.</div>" } ], "returns" : { "type" : "object()", "description" : "the object ACL" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the default S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "object-permissions", "qname" : "s3:object-permissions", "signature" : "($credentials as item()?, $s3-object as item()) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves the access control list (ACL) of an S3 object using the specified\n credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The S3 object is specified through the $s3-object parameter. Either a string\n or a JSON object can be used. If a string is specified, it is interpreted as\n key for an object in the default bucket of the specified credentials. If no default\n bucket is present in the specified credentials, the <code>s3:BUCKET</code> error\n is raised. If a JSON object is used, it must have the following structure:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, optional). If this field is not present\n   and the specified credentials does not have a default bucket, the\n   <code>s3:BUCKET</code> error is raised.</li>\n   <li>version: the object version (string, optional). If versioning is enabled\n   for the specified object and no version is specified the permissions for the\n   latest version of the object will be returned. If specified, only the\n   permissions for that particular version of the object will be returned.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n let $object :=\n {\n   \"key\": \"object\",\n   \"bucket\": \"28msec\",\n   \"version\": \"3/L4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo\"\n }\n return s3:object-permissions(\"credentials\", $object)\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example return object:\n <pre>\n {\n   \"owner\" :\n   {\n     \"id\" : \"ea3617f5543e366a51bf51f440c221410b8001c34744e9d3a81acb79cff9d2ed\",\n     \"displayName\" : \"28msec\"\n   },\n   \"acl\" :\n   [\n     {\n       \"grantee\" :\n       {\n         \"type\" : \"CanonicalUser\",\n         \"id\" : \"ea3617f5543e366a51bf51f440c221410b8001c34744e9d3a81acb79cff9d2ed\",\n         \"displayName\" : \"28msec\"\n       },\n       \"permission\" : \"FULL_CONTROL\"\n     }\n   ]\n }\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The fields in the returned object have the following meanings:\n <ul>\n <li>owner: an object which specifies the owner of the object (object,\n mandatory). It has the following fields:\n   <ul>\n     <li>id: the user identifier of the object owner (string, mandatory).</li>\n     <li>displayName: the screen name of the object owner (string, mandatory).</li>\n   </ul>\n </li>\n <li>acl: an array which contains an object for each grantee with the corresponding\n ACL settings (array, mandatory). Each object contains the following fields:\n   <ul>\n     <li>grantee: specifies the permissions grantee (object, mandatory). It contains\n     the following fields:\n       <ul>\n         <li>type: one of \"AmazonCustomerByEmail\", \"CanonicalUser\" or \"Group\".</li>\n         <li>emailAddress: the customer email address (string, present in all\n         and only AmazonCustomerByEmail grantees).</li>\n         <li>id: the user identifier (string, present in all and only CanonicalUser\n         grantees).</li>\n         <li>displayName: the user screen name (string, present in all and only\n         CanonicalUser grantees).</li>\n         <li>URI: the group URI (string, present in all and only Group grantees).</li>\n       </ul>\n     </li>\n     <li>permission: the granted permissions. One of \"READ\", \"WRITE\", \"READ_ACP\",\n     \"WRITE_ACP\", \"FULL_CONTROL\". (string, mandatory).</li>\n   </ul>\n </li>\n </ul>\n </p>\n", "summary" : "<p>  Retrieves the access control list (ACL) of an S3 object using the specified\n credentials.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "credentials", "type" : "item()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials to use.</div>" }, { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object or object version to retrieve the ACL for.</div>" } ], "returns" : { "type" : "object()", "description" : "the object ACL" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "object-torrent-nondeterministic", "qname" : "s3:object-torrent-nondeterministic", "signature" : "($s3-object as item()) as base64Binary", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns a torrent file for a given object using the default S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as\n <a href=\"#object-torrent-1\">object-torrent#1</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Returns a torrent file for a given object using the default S3 credentials.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object to retrieve the torrent file for</div>" } ], "returns" : { "type" : "base64Binary", "description" : "the base64 encoded torrent file for the specified object." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the default S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "object-torrent-nondeterministic", "qname" : "s3:object-torrent-nondeterministic", "signature" : "($credentials as item()?, $s3-object as item()) as base64Binary", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns a torrent file for a given object using the specified S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as\n <a href=\"#object-torrent-2\">object-torrent#2</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Returns a torrent file for a given object using the specified S3 credentials.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "credentials", "type" : "item()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials to use.</div>" }, { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object to retrieve the torrent file for</div>" } ], "returns" : { "type" : "base64Binary", "description" : "the base64 encoded torrent file of the specified object." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "object-torrent", "qname" : "s3:object-torrent", "signature" : "($s3-object as item()) as base64Binary", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns a torrent file for a given object using the default S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The S3 object is specified through the $s3-object parameter. Either a string\n or a JSON object can be used. If a string is specified, it is interpreted as\n key for an object in the default bucket of the default credentials. If no default\n bucket is present in the default credentials, the <code>s3:BUCKET</code> error\n is raised. If a JSON object is used, it must have the following structure:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, optional). If this field is not present\n   and the default credentials do not have a default bucket, the\n   <code>s3:BUCKET</code> error is raised.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n let $object :=\n {\n   \"key\": \"object\",\n   \"bucket\": \"28msec\"\n }\n return s3:object-torrent($object)\n </pre>\n </p>\n", "summary" : "<p>  Returns a torrent file for a given object using the default S3 credentials.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object to retrieve the torrent file for</div>" } ], "returns" : { "type" : "base64Binary", "description" : "the base64 encoded torrent file for the specified object." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the default S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "object-torrent", "qname" : "s3:object-torrent", "signature" : "($credentials as item()?, $s3-object as item()) as base64Binary", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns a torrent file for a given object using the specified S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The S3 object is specified through the $s3-object parameter. Either a string\n or a JSON object can be used. If a string is specified, it is interpreted as\n key for an object in the default bucket of the specified credentials. If no default\n bucket is present in the specified credentials, the <code>s3:BUCKET</code> error\n is raised. If a JSON object is used, it must have the following structure:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, optional). If this field is not present\n   and the specified credentials do not have a default bucket, the\n   <code>s3:BUCKET</code> error is raised.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n let $object :=\n {\n   \"key\": \"object\",\n   \"bucket\": \"28msec\"\n }\n return s3:object-torrent($object)\n </pre>\n </p>\n", "summary" : "<p>  Returns a torrent file for a given object using the specified S3 credentials.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "credentials", "type" : "item()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials to use.</div>" }, { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object to retrieve the torrent file for</div>" } ], "returns" : { "type" : "base64Binary", "description" : "the base64 encoded torrent file of the specified object." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "read-binary-nondeterministic", "qname" : "s3:read-binary-nondeterministic", "signature" : "($s3-object as item()) as base64Binary", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves the binary content of an S3 object using the default S3 credentials.\n The object content is forced to be interpreted as binaryand will be returned\n as a base64Binary item.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as\n <a href=\"#read-binary-1\">read-binary#1</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Retrieves the binary content of an S3 object using the default S3 credentials.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object or object version to retrieve.</div>" } ], "returns" : { "type" : "base64Binary", "description" : "the object or object version binary content." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the default S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "read-binary-nondeterministic", "qname" : "s3:read-binary-nondeterministic", "signature" : "($credentials as item()?, $s3-object as item()) as base64Binary", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves the binary content of an S3 object using the specified S3 credentials.\n The object content is forced to be interpreted as binaryand will be returned\n as a base64Binary item.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as\n <a href=\"#read-binary-2\">read-binary#2</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Retrieves the binary content of an S3 object using the specified S3 credentials.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "credentials", "type" : "item()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials to use.</div>" }, { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object or object version to retrieve.</div>" } ], "returns" : { "type" : "base64Binary", "description" : "the object or object version binary content." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "read-binary", "qname" : "s3:read-binary", "signature" : "($s3-object as item()) as base64Binary", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves the binary content of an S3 object using the default S3 credentials.\n The object content is forced to be interpreted as binaryand will be returned\n as a base64Binary item.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The S3 object is specified through the $s3-object parameter. Either a string\n or a JSON object can be used. If a string is specified, it is interpreted as\n key for an object in the default bucket of the default credentials. If no default\n bucket is present in the default credentials, the <code>s3:BUCKET</code> error\n is raised. If a JSON object is used, it must have the following structure:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, optional). If this field is not present\n   and the default credentials do not have a default bucket, the\n   <code>s3:BUCKET</code> error is raised.</li>\n   <li>version: the object version (string, optional). If versioning is enabled\n   for the specified object and no version is specified the latest version of\n   the object will be returned. If specified, only that particular version of\n   the object will be returned.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n let $object :=\n {\n   \"key\": \"object\",\n   \"bucket\": \"28msec\",\n   \"version\": \"3/L4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo\"\n }\n return s3:read-binary($object)\n </pre>\n </p>\n", "summary" : "<p>  Retrieves the binary content of an S3 object using the default S3 credentials.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object or object version to retrieve.</div>" } ], "returns" : { "type" : "base64Binary", "description" : "the object or object version binary content." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the default S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "read-binary", "qname" : "s3:read-binary", "signature" : "($credentials as item()?, $s3-object as item()) as base64Binary", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves the binary content of an S3 object using the specified S3 credentials.\n The object content is forced to be interpreted as binaryand will be returned\n as a base64Binary item.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The S3 object is specified through the $s3-object parameter. Either a string\n or a JSON object can be used. If a string is specified, it is interpreted as\n key for an object in the default bucket of the specified credentials. If no default\n bucket is present in the specified credentials, the <code>s3:BUCKET</code> error\n is raised. If a JSON object is used, it must have the following structure:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, optional). If this field is not present\n   and the specified credentials do not have a default bucket, the\n   <code>s3:BUCKET</code> error is raised.</li>\n   <li>version: the object version (string, optional). If versioning is enabled\n   for the specified object and no version is specified the latest version of\n   the object will be returned. If specified, only that particular version of\n   the object will be returned.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n let $object :=\n {\n   \"key\": \"object\",\n   \"bucket\": \"28msec\",\n   \"version\": \"3/L4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo\"\n }\n return s3:read-binary(\"credentials\", $object)\n </pre>\n </p>\n", "summary" : "<p>  Retrieves the binary content of an S3 object using the specified S3 credentials.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "credentials", "type" : "item()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials to use.</div>" }, { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object or object version to retrieve.</div>" } ], "returns" : { "type" : "base64Binary", "description" : "the object or object version binary content." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "read-object-nondeterministic", "qname" : "s3:read-object-nondeterministic", "signature" : "($s3-object as item()) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves an S3 object using the default S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as\n <a href=\"#read-object-1\">read-object#1</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Retrieves an S3 object using the default S3 credentials.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object or object version to retrieve.</div>" } ], "returns" : { "type" : "object()", "description" : "the specified object." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the default S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "read-object-nondeterministic", "qname" : "s3:read-object-nondeterministic", "signature" : "($credentials as item()?, $s3-object as item()) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves an S3 object using the specified S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as\n <a href=\"#read-object-2\">read-object#2</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Retrieves an S3 object using the specified S3 credentials.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "credentials", "type" : "item()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials to use.</div>" }, { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object or object version to retrieve.</div>" } ], "returns" : { "type" : "object()", "description" : "the specified object." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "read-object", "qname" : "s3:read-object", "signature" : "($s3-object as item()) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves an S3 object using the default S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The S3 object is specified through the $s3-object parameter. Either a string\n or a JSON object can be used. If a string is specified, it is interpreted as\n key for an object in the default bucket of the default credentials. If no default\n bucket is present in the default credentials, the <code>s3:BUCKET</code> error\n is raised. If a JSON object is used, it must have the following structure:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, optional). If this field is not present\n   and the default credentials do not have a default bucket, the\n   <code>s3:BUCKET</code> error is raised.</li>\n   <li>version: the object version (string, optional). If versioning is enabled\n   for the specified object and no version is specified the latest version of\n   the object will be returned. If specified, only that particular version of\n   the object will be returned.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n let $object :=\n {\n   \"key\": \"object\",\n   \"bucket\": \"28msec\",\n   \"version\": \"3/L4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo\"\n }\n return s3:read-object($object)\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example return object:\n <pre>\n {\n   \"key\": \"test.xml\",\n   \"bucket\": \"28msec\",\n   \"metadata\":\n   {\n     \"author\": \"28msec\"\n   },\n   \"missing-metadata\" : 1,\n   \"version\": \"3GL4kqtJlcpXroDTDm3vjVBH40Nr8X8g\",\n   \"expiration\": \"expiry-date=\\\"Fri, 21 Dec 2012 00:00:00 GMT\\\", rule-id=\\\"Rule for testfile.txt\\\"\"\n   \"restore\": \"x-amz-restore: ongoing-request=\\\"false\\\", expiry-date=\\\"Wed, 07 Nov 2012 00:00:00 GMT\\\"\"\n   \"serverSideEncryption\": \"AES256\",\n   \"lastModified\": \"Mon, 15 Oct 2012 21:58:07 GMT\",\n   \"eTag\": \"1accb31fcf202eba0c0f41fa2f09b4d7\",\n   \"mediaType\": \"text/plain\"\n   \"length\": \"28\",\n   \"content: \"1234567890123456789012345678\"\n }\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The fields in the returned object have the following meanings:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, mandatory).</li>\n   <li>metadata: an object specifying additional metadata. Each metadata is a\n   name-value pair and is represented as different fields (object, optional).</li>\n   <li>missing-metadata: the number of metadata entries that were not returned\n   in the metadata object. This can happen if you create metadata using an API\n   like SOAP that supports more flexible metadata than the REST API. (integer,\n   optional).</li>\n   <li>version: the object version (string, optional). If versioning is enabled\n   for the specified object and no version is specified the permissions for the\n   latest version of the object will be returned. If specified, only the\n   permissions for that particular version of the object will be returned.</li>\n   <li>expiration: if the object expiration is configured (see\n   <a href=\"http://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlifecycle.html\">PUT Bucket lifecycle</a>),\n   this field is present. It includes the expiry-date and rule-id key value\n   pairs providing object expiration information. The value of rule-id is URL\n   encoded.(string, optional).</li>\n   <li>restore: if the object is an archived object (an object whose storage\n   class is Glacier), the response includes this header if either the archive\n   restoration is in progress (see\n   <a href=\"http://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPOSTrestore.html\">POST Object restore</a>),\n   or an archive copy is already restored.(string, optional).</li>\n   <li>serverSideEncryption: If the object is stored by using server-side\n   encryption, the response includes this header with a value of the encryption\n   algorithm that was used.(string, optional).</li>\n   <li>lastModified: the date in which the object was last modified (dateTime,\n   optional).</li>\n   <li>eTag: the entity tag is a hash of the object. The eTag only reflects\n   changes to the contents of an object, not its metadata. The eTag is determined\n   when an object is created. For objects created by the PUT Object operation\n   and the POST Object operation, the eTag is a quoted, 32-digit hexadecimal\n   string representing the MD5 digest of the object data. For other objects,\n   the eTag may or may not be an MD5 digest of the object data. If the eTag is\n   not an MD5 digest of the object data, it will contain one or more non-hexadecimal\n   characters and/or will consist of less than 32 or more than 32 hexadecimal\n   digits.(string, optional).</li>\n   <li>mediaType: the object media-type (string, mandatory).</li>\n   <li>length: the object content length (integer, optional).</li>\n   <li>content: the object content. (item, optional). The type of this field\n   is determined by the media-type returned by the server. If the media-type\n   indicates that the body content is textual, then the content has type string,\n   base64Binary otherwise. Specifically, the body content is considered textual\n   if and only if the MIME-type specified in the media-type is one of:\n   <ul>\n     <li>\"application/json\"</li>\n     <li>\"application/x-javascript\"</li>\n     <li>\"application/xml\"</li>\n     <li>\"application/xml-external-parsed-entity\"</li>\n   </ul>\n   or if the MIME-type starts with \"text/\" or ends with \"+xml\".</li>\n </ul>\n </p>\n", "summary" : "<p>  Retrieves an S3 object using the default S3 credentials.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object or object version to retrieve.</div>" } ], "returns" : { "type" : "object()", "description" : "the specified object." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the default S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "read-object", "qname" : "s3:read-object", "signature" : "($credentials as item()?, $s3-object as item()) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves an S3 object using the specified S3 credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The S3 object is specified through the $s3-object parameter. Either a string\n or a JSON object can be used. If a string is specified, it is interpreted as\n key for an object in the default bucket of the specified credentials. If no default\n bucket is present in the specified credentials, the <code>s3:BUCKET</code> error\n is raised. If a JSON object is used, it must have the following structure:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, optional). If this field is not present\n   and the specified credentials do not have a default bucket, the\n   <code>s3:BUCKET</code> error is raised.</li>\n   <li>version: the object version (string, optional). If versioning is enabled\n   for the specified object and no version is specified the latest version of\n   the object will be returned. If specified, only that particular version of\n   the object will be returned.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n let $object :=\n {\n   \"key\": \"object\",\n   \"bucket\": \"28msec\",\n   \"version\": \"3/L4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo\"\n }\n return s3:read-object($object)\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example return object:\n <pre>\n {\n   \"key\": \"test.xml\",\n   \"bucket\": \"28msec\",\n   \"metadata\":\n   {\n     \"author\": \"28msec\"\n   },\n   \"missing-metadata\" : 1,\n   \"version\": \"3GL4kqtJlcpXroDTDm3vjVBH40Nr8X8g\",\n   \"expiration\": \"expiry-date=\\\"Fri, 21 Dec 2012 00:00:00 GMT\\\", rule-id=\\\"Rule for testfile.txt\\\"\"\n   \"restore\": \"x-amz-restore: ongoing-request=\\\"false\\\", expiry-date=\\\"Wed, 07 Nov 2012 00:00:00 GMT\\\"\"\n   \"serverSideEncryption\": \"AES256\",\n   \"lastModified\": \"Mon, 15 Oct 2012 21:58:07 GMT\",\n   \"eTag\": \"1accb31fcf202eba0c0f41fa2f09b4d7\",\n   \"mediaType\": \"text/plain\"\n   \"length\": \"28\",\n   \"content: \"1234567890123456789012345678\"\n }\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The fields in the returned object have the following meanings:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, mandatory).</li>\n   <li>metadata: an object specifying additional metadata. Each metadata is a\n   name-value pair and is represented as different fields (object, optional).</li>\n   <li>missing-metadata: the number of metadata entries that were not returned\n   in the metadata object. This can happen if you create metadata using an API\n   like SOAP that supports more flexible metadata than the REST API. (integer,\n   optional).</li>\n   <li>version: the object version (string, optional). If versioning is enabled\n   for the specified object and no version is specified the permissions for the\n   latest version of the object will be returned. If specified, only the\n   permissions for that particular version of the object will be returned.</li>\n   <li>expiration: if the object expiration is configured (see\n   <a href=\"http://docs.aws.amazon.com/AmazonS3/latest/API/RESTBucketPUTlifecycle.html\">PUT Bucket lifecycle</a>),\n   this field is present. It includes the expiry-date and rule-id key value\n   pairs providing object expiration information. The value of rule-id is URL\n   encoded.(string, optional).</li>\n   <li>restore: if the object is an archived object (an object whose storage\n   class is Glacier), the response includes this header if either the archive\n   restoration is in progress (see\n   <a href=\"http://docs.aws.amazon.com/AmazonS3/latest/API/RESTObjectPOSTrestore.html\">POST Object restore</a>),\n   or an archive copy is already restored.(string, optional).</li>\n   <li>serverSideEncryption: If the object is stored by using server-side\n   encryption, the response includes this header with a value of the encryption\n   algorithm that was used.(string, optional).</li>\n   <li>lastModified: the date in which the object was last modified (dateTime,\n   optional).</li>\n   <li>eTag: the entity tag is a hash of the object. The eTag only reflects\n   changes to the contents of an object, not its metadata. The eTag is determined\n   when an object is created. For objects created by the PUT Object operation\n   and the POST Object operation, the eTag is a quoted, 32-digit hexadecimal\n   string representing the MD5 digest of the object data. For other objects,\n   the eTag may or may not be an MD5 digest of the object data. If the eTag is\n   not an MD5 digest of the object data, it will contain one or more non-hexadecimal\n   characters and/or will consist of less than 32 or more than 32 hexadecimal\n   digits.(string, optional).</li>\n   <li>mediaType: the object media-type (string, mandatory).</li>\n   <li>length: the object content length (integer, optional).</li>\n   <li>content: the object content. (item, optional). The type of this field\n   is determined by the media-type returned by the server. If the media-type\n   indicates that the body content is textual,then the content has type string,\n   base64Binary otherwise. Specifically, the body content is considered textual\n   if and only if the MIME-type specified in the media-type is one of:\n   <ul>\n     <li>\"application/json\"</li>\n     <li>\"application/x-javascript\"</li>\n     <li>\"application/xml\"</li>\n     <li>\"application/xml-external-parsed-entity\"</li>\n   </ul>\n   or if the MIME-type starts with \"text/\" or ends with \"+xml\".</li>\n </ul>\n </p>\n", "summary" : "<p>  Retrieves an S3 object using the specified S3 credentials.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "credentials", "type" : "item()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials to use.</div>" }, { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object or object version to retrieve.</div>" } ], "returns" : { "type" : "object()", "description" : "the specified object." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "read-text-nondeterministic", "qname" : "s3:read-text-nondeterministic", "signature" : "($s3-object as item()) as string", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves the textual content of an S3 object using the default S3 credentials.\n The object content is forced to be interpreted as textual, with a UTF-8 charset\n and will be returned as string.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as\n <a href=\"#read-text-1\">read-text#1</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Retrieves the textual content of an S3 object using the default S3 credentials.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object or object version to retrieve.</div>" } ], "returns" : { "type" : "string", "description" : "the object or object version textual content." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the default S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "read-text-nondeterministic", "qname" : "s3:read-text-nondeterministic", "signature" : "($credentials as item()?, $s3-object as item()) as string", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves the textual content of an S3 object using the specified S3 credentials.\n The object content is forced to be interpreted as textual, with a UTF-8 charset\n and will be returned as string.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as\n <a href=\"#read-text-2\">read-text#2</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Retrieves the textual content of an S3 object using the specified S3 credentials.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "credentials", "type" : "item()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials to use.</div>" }, { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object or object version to retrieve.</div>" } ], "returns" : { "type" : "string", "description" : "the object or object version textual content." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "read-text", "qname" : "s3:read-text", "signature" : "($s3-object as item()) as string", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves the textual content of an S3 object using the default S3 credentials.\n The object content is forced to be interpreted as textual, with a UTF-8 charset\n and will be returned as string.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The S3 object is specified through the $s3-object parameter. Either a string\n or a JSON object can be used. If a string is specified, it is interpreted as\n key for an object in the default bucket of the default credentials. If no default\n bucket is present in the default credentials, the <code>s3:BUCKET</code> error\n is raised. If a JSON object is used, it must have the following structure:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, optional). If this field is not present\n   and the default credentials do not have a default bucket, the\n   <code>s3:BUCKET</code> error is raised.</li>\n   <li>version: the object version (string, optional). If versioning is enabled\n   for the specified object and no version is specified the latest version of\n   the object will be returned. If specified, only that particular version of\n   the object will be returned.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n let $object :=\n {\n   \"key\": \"object\",\n   \"bucket\": \"28msec\",\n   \"version\": \"3/L4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo\"\n }\n return s3:read-text(\"credentials\", $object)\n </pre>\n </p>\n", "summary" : "<p>  Retrieves the textual content of an S3 object using the default S3 credentials.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object or object version to retrieve.</div>" } ], "returns" : { "type" : "string", "description" : "the object or object version textual content." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the default S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "read-text", "qname" : "s3:read-text", "signature" : "($credentials as item()?, $s3-object as item()) as string", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves the textual content of an S3 object using the specified S3 credentials.\n The object content is forced to be interpreted as textual, with a UTF-8 charset\n and will be returned as string.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The S3 object is specified through the $s3-object parameter. Either a string\n or a JSON object can be used. If a string is specified, it is interpreted as\n key for an object in the default bucket of the specified credentials. If no default\n bucket is present in the specified credentials, the <code>s3:BUCKET</code> error\n is raised. If a JSON object is used, it must have the following structure:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, optional). If this field is not present\n   and the specified credentials do not have a default bucket, the\n   <code>s3:BUCKET</code> error is raised.</li>\n   <li>version: the object version (string, optional). If versioning is enabled\n   for the specified object and no version is specified the latest version of\n   the object will be returned. If specified, only that particular version of\n   the object will be returned.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n let $object :=\n {\n   \"key\": \"object\",\n   \"bucket\": \"28msec\",\n   \"version\": \"3/L4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo\"\n }\n return s3:read-text(\"credentials\", $object)\n </pre>\n </p>\n", "summary" : "<p>  Retrieves the textual content of an S3 object using the specified S3 credentials.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "credentials", "type" : "item()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials to use.</div>" }, { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object or object version to retrieve.</div>" } ], "returns" : { "type" : "string", "description" : "the object or object version textual content." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:RESPONSE the response received from S3 cannot be parsed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "set-object-permissions", "qname" : "s3:set-object-permissions", "signature" : "($s3-object as item()) as empty-sequence()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Sets the access control list (ACL) of an S3 object using the default S3\n credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The S3 object is specified through the $s3-object parameter. Either a string\n or a JSON object can be used. If a string is specified, it is interpreted as\n key for an object in the default bucket of the default credentials. If no default\n bucket is present in the default credentials, the <code>s3:BUCKET</code> error\n is raised. If a JSON object is used, it must have the following structure:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, optional). If this field is not present\n   and the default credentials do not have a default bucket, the\n   <code>s3:BUCKET</code> error is raised.</li>\n   <li>version: the object version (string, optional). If versioning is enabled\n   for the specified object and no version is specified the permissions for the\n   latest version of the object will be set. If specified, only the\n   permissions for that particular version of the object will be set.</li>\n   <li>permission: the permission to set (string, optional). It must be one of\n   \"private\", \"public-read\", \"public-read-write\", \"authenticated-read\",\n   \"bucket-owner-read\", \"bucket-owner-full-control\". For your convenience the\n   following variables can be used: <code>$s3:ACL-GRANT-PRIVATE</code>,\n   <code>$s3:ACL-GRANT-PUBLIC-READ</code>, <code>$s3:ACL-GRANT-PUBLIC-READ-WRITE</code>,\n   <code>$s3:ACL-GRANT-AUTHENTICATED-READ</code>, <code>$s3:ACL-GRANT-BUCKET-OWNER-READ</code>,\n   <code>$s3:ACL-GRANT-BUCKET-OWNER-FULL-CONTROL</code>. If this field is not\n   specified, the \"private\" ACL is used, that is, the owner gets FULL_CONTROL,\n   and no one else has access rights.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n let $object :=\n {\n   \"key\": \"object\",\n   \"bucket\": \"28msec\",\n   \"version\": \"3/L4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo\",\n   \"permission\": $s3:ACL-GRANT-PUBLIC-READ\n }\n return s3:set-object-permissions($object)\n </pre>\n </p>\n", "summary" : "<p>  Sets the access control list (ACL) of an S3 object using the default S3\n credentials.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object or object version and ACL to set.</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "the empty sequence" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the default S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "set-object-permissions", "qname" : "s3:set-object-permissions", "signature" : "($credentials as item()?, $s3-object as item()) as empty-sequence()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Sets the access control list (ACL) of an S3 object using the specified S3\n credentials.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The S3 object is specified through the $s3-object parameter. Either a string\n or a JSON object can be used. If a string is specified, it is interpreted as\n key for an object in the default bucket of the specified credentials. If no default\n bucket is present in the specified credentials, the <code>s3:BUCKET</code> error\n is raised. If a JSON object is used, it must have the following structure:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, optional). If this field is not present\n   and the specified credentials do not have a default bucket, the\n   <code>s3:BUCKET</code> error is raised.</li>\n   <li>version: the object version (string, optional). If versioning is enabled\n   for the specified object and no version is specified the permissions for the\n   latest version of the object will be set. If specified, only the\n   permissions for that particular version of the object will be set.</li>\n   <li>permission: the permission to set (string, optional). It must be one of\n   \"private\", \"public-read\", \"public-read-write\", \"authenticated-read\",\n   \"bucket-owner-read\", \"bucket-owner-full-control\". For your convenience the\n   following variables can be used: <code>$s3:ACL-GRANT-PRIVATE</code>,\n   <code>$s3:ACL-GRANT-PUBLIC-READ</code>, <code>$s3:ACL-GRANT-PUBLIC-READ-WRITE</code>,\n   <code>$s3:ACL-GRANT-AUTHENTICATED-READ</code>, <code>$s3:ACL-GRANT-BUCKET-OWNER-READ</code>,\n   <code>$s3:ACL-GRANT-BUCKET-OWNER-FULL-CONTROL</code>. If this field is not\n   specified, the \"private\" ACL is used, that is, the owner gets FULL_CONTROL,\n   and no one else has access rights.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n let $object :=\n {\n   \"key\": \"object\",\n   \"bucket\": \"28msec\",\n   \"version\": \"3/L4kqtJlcpXroDTDmJ+rmSpXd3dIbrHY+MTRCxf3vjVBH40Nr8X8gdRQBpUMLUo\",\n   \"permission\": $s3:ACL-GRANT-PUBLIC-READ\n }\n return s3:set-object-permissions($object)\n </pre>\n </p>\n", "summary" : "<p>  Sets the access control list (ACL) of an S3 object using the specified S3\n credentials.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "credentials", "type" : "item()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials to use.</div>" }, { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object or object version and ACL to set.</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "the empty sequence" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "write-binary", "qname" : "s3:write-binary", "signature" : "($object as item(), $binary-content as base64Binary) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Writes a binary object in an S3 bucket using the default S3 credentials.\n If the object already exists it is overwritten.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The S3 object is specified through the $s3-object parameter. Either a string\n or a JSON object can be used.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If a string is specified, it is interpreted as\n key for an object in the default bucket of the default credentials. If no default\n bucket is present in the default credentials, the <code>s3:BUCKET</code> error\n is raised. The object media-type will be set to \"binary/octet-stream\", no metadata will\n be set for the object, the object will be stored on standard redundancy storage,\n and the object permission will be set to \"private\", that is, the owner gets\n FULL_CONTROL, and no one else has access rights.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If a JSON object is used, it must have the following structure:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, optional). If this field is not present\n   and the default credentials do not have a default bucket, the\n   <code>s3:BUCKET</code> error is raised.</li>\n   <li>mediaType: the media-type of the object (string, optional). If not specified,\n   \"binary/octet-stream\" is used.</li>\n   <li>metadata: an object specifying additional metadata. Each metadata is a\n   name-value pair and is represented as different fields (object, optional).</li>\n   <li>permission: the permission to set (string, optional). It must be one of\n   \"private\", \"public-read\", \"public-read-write\", \"authenticated-read\",\n   \"bucket-owner-read\", \"bucket-owner-full-control\". For your convenience the\n   following variables can be used: <code>$s3:ACL-GRANT-PRIVATE</code>,\n   <code>$s3:ACL-GRANT-PUBLIC-READ</code>, <code>$s3:ACL-GRANT-PUBLIC-READ-WRITE</code>,\n   <code>$s3:ACL-GRANT-AUTHENTICATED-READ</code>, <code>$s3:ACL-GRANT-BUCKET-OWNER-READ</code>,\n   <code>$s3:ACL-GRANT-BUCKET-OWNER-FULL-CONTROL</code>. If this field is not\n   specified, the \"private\" ACL is used, that is, the owner gets FULL_CONTROL,\n   and no one else has access rights.</li>\n   <li>reducedRedundancy: whether to use reduced-redundancy or not (bool,\n   optional). Default is false.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n variable $s3-object :=\n {\n   \"key\": \"test.xml\",\n   \"bucket\": \"28msec\",\n   \"permission\": $const:ACL-GRANT-PUBLIC-READ,\n   \"metadata\": { \"author\": \"28msec\" },\n   \"mediaType\": \"application/octet-stream\"\n }\n s3:write-binary($s3-object, base64Binary(\"Mjhtc2Vj\"))\n </pre>\n Example Result:\n <pre>\n {\n   \"expiration\": \"expiry-date=\\\"Fri, 23 Dec 2012 00:00:00 GMT\\\", rule-id=\\\"1\\\"\",\n   \"version\": \"3GL4kqtJlcpXroDTDm3vjVBH40Nr8X8g\",\n   \"eTag\": \"\\\"1b2cf535f27731c974343645a3985328\\\"\"\n }\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The meaning of the fields in the result object is the following:\n <ul>\n   <li>expiration: if the object expiration is configured, the response\n   includes this header. It includes the expiry-date and rule-id key-value\n   pairs providing object expiration information. The value of the rule-id is\n   URL encoded. (string, optional)</li>\n   <li>version: the version of the object. When you enable versioning,\n   Amazon S3 generates a random number for objects added to a bucket. The value\n   is UTF-8 encoded and URL ready. When you PUT an object in a bucket where\n   versioning has been suspended, the version ID is always null. (string, optional)</li>\n   <li>eTag: the entity tag is a hash of the object. The eTag only reflects\n   changes to the contents of an object, not its metadata. The eTag is determined\n   when an object is created. The eTag returned by this method is a quoted,\n   32-digit hexadecimal string representing the MD5 digest of the object data.\n   For other objects, the eTag may or may not be an MD5 digest of the object data.\n   (string, optional).</li>\n </ul>\n </p>\n", "summary" : "<p>  Writes a binary object in an S3 bucket using the default S3 credentials.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "object", "type" : "item()", "occurrence" : null, "description" : "" }, { "name" : "binary-content", "type" : "base64Binary", "occurrence" : null, "description" : "" } ], "returns" : { "type" : "object()", "description" : "the S3 operation result." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the default S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "write-binary", "qname" : "s3:write-binary", "signature" : "($credentials as item()?, $object as item(), $binary-content as base64Binary) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Writes a binary object in an S3 bucket using the specified S3 credentials.\n If the object already exists it is overwritten.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The S3 object is specified through the $s3-object parameter. Either a string\n or a JSON object can be used.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If a string is specified, it is interpreted as\n key for an object in the default bucket of the specified credentials. If no default\n bucket is present in the specified credentials, the <code>s3:BUCKET</code> error\n is raised. The object media-type will be set to \"binary/octet-stream\", no metadata will\n be set for the object, the object will be stored on standard redundancy storage,\n and the object permission will be set to \"private\", that is, the owner gets\n FULL_CONTROL, and no one else has access rights.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If a JSON object is used, it must have the following structure:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, optional). If this field is not present\n   and the specified credentials do not have a default bucket, the\n   <code>s3:BUCKET</code> error is raised.</li>\n   <li>mediaType: the media-type of the object (string, optional). If not specified,\n   \"binary/octet-stream\" is used.</li>\n   <li>metadata: an object specifying additional metadata. Each metadata is a\n   name-value pair and is represented as different fields (object, optional).</li>\n   <li>permission: the permission to set (string, optional). It must be one of\n   \"private\", \"public-read\", \"public-read-write\", \"authenticated-read\",\n   \"bucket-owner-read\", \"bucket-owner-full-control\". For your convenience the\n   following variables can be used: <code>$s3:ACL-GRANT-PRIVATE</code>,\n   <code>$s3:ACL-GRANT-PUBLIC-READ</code>, <code>$s3:ACL-GRANT-PUBLIC-READ-WRITE</code>,\n   <code>$s3:ACL-GRANT-AUTHENTICATED-READ</code>, <code>$s3:ACL-GRANT-BUCKET-OWNER-READ</code>,\n   <code>$s3:ACL-GRANT-BUCKET-OWNER-FULL-CONTROL</code>. If this field is not\n   specified, the \"private\" ACL is used, that is, the owner gets FULL_CONTROL,\n   and no one else has access rights.</li>\n   <li>reducedRedundancy: whether to use reduced-redundancy or not (bool,\n   optional). Default is false.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n variable $s3-object :=\n {\n   \"key\": \"test.xml\",\n   \"bucket\": \"28msec\",\n   \"permission\": $const:ACL-GRANT-PUBLIC-READ,\n   \"metadata\": { \"author\": \"28msec\" },\n   \"mediaType\": \"application/octet-stream\"\n }\n s3:write-binary(\"credentials\", $s3-object, base64Binary(\"Mjhtc2Vj\"))\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example return object:\n <pre>\n {\n   \"expiration\": \"expiry-date=\\\"Fri, 23 Dec 2012 00:00:00 GMT\\\", rule-id=\\\"1\\\"\",\n   \"version\": \"3GL4kqtJlcpXroDTDm3vjVBH40Nr8X8g\",\n   \"eTag\": \"\\\"1b2cf535f27731c974343645a3985328\\\"\"\n }\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The fields in the returned object have the following meanings:\n <ul>\n   <li>expiration: if the object expiration is configured, the response\n   includes this header. It includes the expiry-date and rule-id key-value\n   pairs providing object expiration information. The value of the rule-id is\n   URL encoded. (string, optional)</li>\n   <li>version: the version of the object. When you enable versioning,\n   Amazon S3 generates a random number for objects added to a bucket. The value\n   is UTF-8 encoded and URL ready. When you PUT an object in a bucket where\n   versioning has been suspended, the version ID is always null. (string, optional)</li>\n   <li>eTag: the entity tag is a hash of the object. The eTag only reflects\n   changes to the contents of an object, not its metadata. The eTag is determined\n   when an object is created. The eTag returned by this method is a quoted,\n   32-digit hexadecimal string representing the MD5 digest of the object data.\n   For other objects, the eTag may or may not be an MD5 digest of the object data.\n   (string, optional).</li>\n </ul>\n </p>\n", "summary" : "<p>  Writes a binary object in an S3 bucket using the specified S3 credentials.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "credentials", "type" : "item()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials to use.</div>" }, { "name" : "object", "type" : "item()", "occurrence" : null, "description" : "" }, { "name" : "binary-content", "type" : "base64Binary", "occurrence" : null, "description" : "" } ], "returns" : { "type" : "object()", "description" : "the S3 operation result." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "write-object", "qname" : "s3:write-object", "signature" : "($s3-object as item()) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Writes an object in an S3 bucket using the default S3 credentials.\n If the object already exists it is overwritten.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The object to write and its contents are specified through the $s3-object\n parameter, which must have the following structure:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, optional). If this field is not present\n   and the default credentials do not have a default bucket, the\n   <code>s3:BUCKET</code> error is raised.</li>\n   <li>content: the object content. It must either be a string or a base64Binary\n   atomic. (item, mandatory).</li>\n   <li>mediaType: the media-type of the object (string, optional). If not specified,\n   \"text/plain\" is used if the content field is of type string, \"binary/octet-stream\"\n   if it is of type base64Binary.</li>\n   <li>metadata: an object specifying additional metadata. Each metadata is a\n   name-value pair and is represented as different fields (object, optional).</li>\n   <li>permission: the permission to set (string, optional). It must be one of\n   \"private\", \"public-read\", \"public-read-write\", \"authenticated-read\",\n   \"bucket-owner-read\", \"bucket-owner-full-control\". For your convenience the\n   following variables can be used: <code>$s3:ACL-GRANT-PRIVATE</code>,\n   <code>$s3:ACL-GRANT-PUBLIC-READ</code>, <code>$s3:ACL-GRANT-PUBLIC-READ-WRITE</code>,\n   <code>$s3:ACL-GRANT-AUTHENTICATED-READ</code>, <code>$s3:ACL-GRANT-BUCKET-OWNER-READ</code>,\n   <code>$s3:ACL-GRANT-BUCKET-OWNER-FULL-CONTROL</code>. If this field is not\n   specified, the \"private\" ACL is used, that is, the owner gets FULL_CONTROL,\n   and no one else has access rights.</li>\n   <li>reducedRedundancy: whether to use reduced-redundancy or not (bool,\n   optional). Default is false.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n variable $s3-object :=\n {\n   \"key\": \"test.xml\",\n   \"bucket\": \"28msec\",\n   \"permission\": $const:ACL-GRANT-PUBLIC-READ,\n   \"metadata\": { \"author\": \"28msec\" },\n   \"content\": serialize({ \"Hello\": \"World\" }),\n   \"mediaType\": \"application/xml\"\n }\n s3:write-object($s3-object)\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example return object:\n <pre>\n {\n   \"expiration\": \"expiry-date=\\\"Fri, 23 Dec 2012 00:00:00 GMT\\\", rule-id=\\\"1\\\"\",\n   \"version\": \"3GL4kqtJlcpXroDTDm3vjVBH40Nr8X8g\",\n   \"eTag\": \"\\\"1b2cf535f27731c974343645a3985328\\\"\"\n }\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The fields in the returned object have the following meanings:\n <ul>\n   <li>expiration: if the object expiration is configured, the response\n   includes this header. It includes the expiry-date and rule-id key-value\n   pairs providing object expiration information. The value of the rule-id is\n   URL encoded. (string, optional)</li>\n   <li>version: the version of the object. When you enable versioning,\n   Amazon S3 generates a random number for objects added to a bucket. The value\n   is UTF-8 encoded and URL ready. When you PUT an object in a bucket where\n   versioning has been suspended, the version ID is always null. (string, optional)</li>\n   <li>eTag: the entity tag is a hash of the object. The eTag only reflects\n   changes to the contents of an object, not its metadata. The eTag is determined\n   when an object is created. The eTag returned by this method is a quoted,\n   32-digit hexadecimal string representing the MD5 digest of the object data.\n   For other objects, the eTag may or may not be an MD5 digest of the object data.\n   (string, optional).</li>\n </ul>\n </p>\n", "summary" : "<p>  Writes an object in an S3 bucket using the default S3 credentials.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "s3-object", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object to write.</div>" } ], "returns" : { "type" : "object()", "description" : "the S3 operation result." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the default S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "write-object", "qname" : "s3:write-object", "signature" : "($credentials as item()?, $s3-object as object()) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Writes an object in an S3 bucket using the specified credentials.\n If the object already exists it is overwritten.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The object to write and its contents are specified through the $s3-object\n parameter, which must have the following structure:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, optional). If this field is not present\n   and the specified credentials do not have a default bucket, the\n   <code>s3:BUCKET</code> error is raised.</li>\n   <li>content: the object content. It must either be a string or a base64Binary\n   atomic. (item, mandatory).</li>\n   <li>mediaType: the media-type of the object (string, optional). If not specified,\n   \"text/plain\" is used if the content field is of type string, \"binary/octet-stream\"\n   if it is of type base64Binary.</li>\n   <li>metadata: an object specifying additional metadata. Each metadata is a\n   name-value pair and is represented as different fields (object, optional).</li>\n   <li>permission: the permission to set (string, optional). It must be one of\n   \"private\", \"public-read\", \"public-read-write\", \"authenticated-read\",\n   \"bucket-owner-read\", \"bucket-owner-full-control\". For your convenience the\n   following variables can be used: <code>$s3:ACL-GRANT-PRIVATE</code>,\n   <code>$s3:ACL-GRANT-PUBLIC-READ</code>, <code>$s3:ACL-GRANT-PUBLIC-READ-WRITE</code>,\n   <code>$s3:ACL-GRANT-AUTHENTICATED-READ</code>, <code>$s3:ACL-GRANT-BUCKET-OWNER-READ</code>,\n   <code>$s3:ACL-GRANT-BUCKET-OWNER-FULL-CONTROL</code>. If this field is not\n   specified, the \"private\" ACL is used, that is, the owner gets FULL_CONTROL,\n   and no one else has access rights.</li>\n   <li>reducedRedundancy: whether to use reduced-redundancy or not (bool,\n   optional). Default is false.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n variable $s3-object :=\n {\n   \"key\": \"test.xml\",\n   \"bucket\": \"28msec\",\n   \"permission\": $const:ACL-GRANT-PUBLIC-READ,\n   \"metadata\": { \"author\": \"28msec\" },\n   \"content\": serialize({ \"Hello\": \"World\" }),\n   \"mediaType\": \"application/xml\"\n }\n s3:write-object(\"s3\", $s3-object)\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example return object:\n <pre>\n {\n   \"expiration\": \"expiry-date=\\\"Fri, 23 Dec 2012 00:00:00 GMT\\\", rule-id=\\\"1\\\"\",\n   \"version\": \"3GL4kqtJlcpXroDTDm3vjVBH40Nr8X8g\",\n   \"eTag\": \"\\\"1b2cf535f27731c974343645a3985328\\\"\"\n }\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The fields in the returned object have the following meanings:\n <ul>\n   <li>expiration: if the object expiration is configured, the response\n   includes this header. It includes the expiry-date and rule-id key-value\n   pairs providing object expiration information. The value of the rule-id is\n   URL encoded. (string, optional)</li>\n   <li>version: the version of the object. When you enable versioning,\n   Amazon S3 generates a random number for objects added to a bucket. The value\n   is UTF-8 encoded and URL ready. When you PUT an object in a bucket where\n   versioning has been suspended, the version ID is always null. (string, optional)</li>\n   <li>eTag: the entity tag is a hash of the object. The eTag only reflects\n   changes to the contents of an object, not its metadata. The eTag is determined\n   when an object is created. The eTag returned by this method is a quoted,\n   32-digit hexadecimal string representing the MD5 digest of the object data.\n   For other objects, the eTag may or may not be an MD5 digest of the object data.\n   (string, optional).</li>\n </ul>\n </p>\n", "summary" : "<p>  Writes an object in an S3 bucket using the specified credentials.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "credentials", "type" : "item()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials to use.</div>" }, { "name" : "s3-object", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The S3 object to write.</div>" } ], "returns" : { "type" : "object()", "description" : "the S3 operation result." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "write-text", "qname" : "s3:write-text", "signature" : "($object as item(), $text-content as string) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Writes a textual object in an S3 bucket using the default S3 credentials.\n If the object already exists it is overwritten.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The S3 object is specified through the $s3-object parameter. Either a string\n or a JSON object can be used.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If a string is specified, it is interpreted as\n key for an object in the default bucket of the default credentials. If no default\n bucket is present in the default credentials, the <code>s3:BUCKET</code> error\n is raised. The object media-type will be set to \"text/plain\", no metadata will\n be set for the object, the object will be stored on standard redundancy storage,\n and the object permission will be set to \"private\", that is, the owner gets\n FULL_CONTROL, and no one else has access rights.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If a JSON object is used, it must have the following structure:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, optional). If this field is not present\n   and the default credentials do not have a default bucket, the\n   <code>s3:BUCKET</code> error is raised.</li>\n   <li>mediaType: the media-type of the object (string, optional). If not specified,\n   \"text/plain\" is used.</li>\n   <li>metadata: an object specifying additional metadata. Each metadata is a\n   name-value pair and is represented as different fields (object, optional).</li>\n   <li>permission: the permission to set (string, optional). It must be one of\n   \"private\", \"public-read\", \"public-read-write\", \"authenticated-read\",\n   \"bucket-owner-read\", \"bucket-owner-full-control\". For your convenience the\n   following variables can be used: <code>$s3:ACL-GRANT-PRIVATE</code>,\n   <code>$s3:ACL-GRANT-PUBLIC-READ</code>, <code>$s3:ACL-GRANT-PUBLIC-READ-WRITE</code>,\n   <code>$s3:ACL-GRANT-AUTHENTICATED-READ</code>, <code>$s3:ACL-GRANT-BUCKET-OWNER-READ</code>,\n   <code>$s3:ACL-GRANT-BUCKET-OWNER-FULL-CONTROL</code>. If this field is not\n   specified, the \"private\" ACL is used, that is, the owner gets FULL_CONTROL,\n   and no one else has access rights.</li>\n   <li>reducedRedundancy: whether to use reduced-redundancy or not (bool,\n   optional). Default is false.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n variable $s3-object :=\n {\n   \"key\": \"test.xml\",\n   \"bucket\": \"28msec\",\n   \"permission\": $const:ACL-GRANT-PUBLIC-READ,\n   \"metadata\": { \"author\": \"28msec\" },\n   \"mediaType\": \"text/xml\"\n }\n s3:write-text($s3-object, serialize(&lt;a/&gt;))\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example return object:\n <pre>\n {\n   \"expiration\": \"expiry-date=\\\"Fri, 23 Dec 2012 00:00:00 GMT\\\", rule-id=\\\"1\\\"\",\n   \"version\": \"3GL4kqtJlcpXroDTDm3vjVBH40Nr8X8g\",\n   \"eTag\": \"\\\"1b2cf535f27731c974343645a3985328\\\"\"\n }\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The fields in the returned object have the following meanings:\n <ul>\n   <li>expiration: if the object expiration is configured, the response\n   includes this header. It includes the expiry-date and rule-id key-value\n   pairs providing object expiration information. The value of the rule-id is\n   URL encoded. (string, optional)</li>\n   <li>version: the version of the object. When you enable versioning,\n   Amazon S3 generates a random number for objects added to a bucket. The value\n   is UTF-8 encoded and URL ready. When you PUT an object in a bucket where\n   versioning has been suspended, the version ID is always null. (string, optional)</li>\n   <li>eTag: the entity tag is a hash of the object. The eTag only reflects\n   changes to the contents of an object, not its metadata. The eTag is determined\n   when an object is created. The eTag returned by this method is a quoted,\n   32-digit hexadecimal string representing the MD5 digest of the object data.\n   For other objects, the eTag may or may not be an MD5 digest of the object data.\n   (string, optional).</li>\n </ul>\n </p>\n", "summary" : "<p>  Writes a textual object in an S3 bucket using the default S3 credentials.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "object", "type" : "item()", "occurrence" : null, "description" : "" }, { "name" : "text-content", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The textual object content.</div>" } ], "returns" : { "type" : "object()", "description" : "the S3 operation result." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the default S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "write-text", "qname" : "s3:write-text", "signature" : "($credentials as item()?, $object as item(), $text-content as string) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Writes a text object in an S3 bucket using the specified S3 credentials.\n If the object already exists it is overwritten.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The S3 object is specified through the $s3-object parameter. Either a string\n or a JSON object can be used.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If a string is specified, it is interpreted as\n key for an object in the default bucket of the specified credentials. If no default\n bucket is present in the specified credentials, the <code>s3:BUCKET</code> error\n is raised. The object media-type will be set to \"text/plain\", no metadata will\n be set for the object, the object will be stored on standard redundancy storage,\n and the object permission will be set to \"private\", that is, the owner gets\n FULL_CONTROL, and no one else has access rights.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If a JSON object is used, it must have the following structure:\n <ul>\n   <li>key: the object key (string, mandatory).</li>\n   <li>bucket: the bucket name (string, optional). If this field is not present\n   and the specified credentials do not have a default bucket, the\n   <code>s3:BUCKET</code> error is raised.</li>\n   <li>mediaType: the media-type of the object (string, optional). If not specified,\n   \"text/plain\" is used.</li>\n   <li>metadata: an object specifying additional metadata. Each metadata is a\n   name-value pair and is represented as different fields (object, optional).</li>\n   <li>permission: the permission to set (string, optional). It must be one of\n   \"private\", \"public-read\", \"public-read-write\", \"authenticated-read\",\n   \"bucket-owner-read\", \"bucket-owner-full-control\". For your convenience the\n   following variables can be used: <code>$s3:ACL-GRANT-PRIVATE</code>,\n   <code>$s3:ACL-GRANT-PUBLIC-READ</code>, <code>$s3:ACL-GRANT-PUBLIC-READ-WRITE</code>,\n   <code>$s3:ACL-GRANT-AUTHENTICATED-READ</code>, <code>$s3:ACL-GRANT-BUCKET-OWNER-READ</code>,\n   <code>$s3:ACL-GRANT-BUCKET-OWNER-FULL-CONTROL</code>. If this field is not\n   specified, the \"private\" ACL is used, that is, the owner gets FULL_CONTROL,\n   and no one else has access rights.</li>\n   <li>reducedRedundancy: whether to use reduced-redundancy or not (bool,\n   optional). Default is false.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n variable $s3-object :=\n {\n   \"key\": \"test.xml\",\n   \"bucket\": \"28msec\",\n   \"permission\": $const:ACL-GRANT-PUBLIC-READ,\n   \"metadata\": { \"author\": \"28msec\" },\n   \"mediaType\": \"text/xml\"\n }\n s3:write-text(\"credentials\", $s3-object, serialize(&lt;a/&gt;))\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example return object:\n <pre>\n {\n   \"expiration\": \"expiry-date=\\\"Fri, 23 Dec 2012 00:00:00 GMT\\\", rule-id=\\\"1\\\"\",\n   \"version\": \"3GL4kqtJlcpXroDTDm3vjVBH40Nr8X8g\",\n   \"eTag\": \"\\\"1b2cf535f27731c974343645a3985328\\\"\"\n }\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The fields in the returned object have the following meanings:\n <ul>\n   <li>expiration: if the object expiration is configured, the response\n   includes this header. It includes the expiry-date and rule-id key-value\n   pairs providing object expiration information. The value of the rule-id is\n   URL encoded. (string, optional)</li>\n   <li>version: the version of the object. When you enable versioning,\n   Amazon S3 generates a random number for objects added to a bucket. The value\n   is UTF-8 encoded and URL ready. When you PUT an object in a bucket where\n   versioning has been suspended, the version ID is always null. (string, optional)</li>\n   <li>eTag: the entity tag is a hash of the object. The eTag only reflects\n   changes to the contents of an object, not its metadata. The eTag is determined\n   when an object is created. The eTag returned by this method is a quoted,\n   32-digit hexadecimal string representing the MD5 digest of the object data.\n   For other objects, the eTag may or may not be an MD5 digest of the object data.\n   (string, optional).</li>\n </ul>\n </p>\n", "summary" : "<p>  Writes a text object in an S3 bucket using the specified S3 credentials.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "credentials", "type" : "item()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials to use.</div>" }, { "name" : "object", "type" : "item()", "occurrence" : null, "description" : "" }, { "name" : "text-content", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The textual object content.</div>" } ], "returns" : { "type" : "object()", "description" : "the S3 operation result." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:CREDENTIALS if the specified S3 credentials cannot be found or are invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:OBJECT if the object specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:BUCKET if no bucket has been specified and no default bucket is present in the used credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:HTTP an HTTP error occurred sending the request to S3</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">s3:REQUEST S3 refused to execute the request</xqdoc:error>" ] } ], "variables" : [ { "name" : "s3:ACL-GRANT-PRIVATE", "type" : "item()*", "description" : " The private canned ACL. It is applicable to buckets and objects.\n Owner gets FULL_CONTROL. No one else has access rights.\n" }, { "name" : "s3:ACL-GRANT-PUBLIC-READ", "type" : "item()*", "description" : " The public-read canned ACL. Applicable to buckets and objects.\n Owner gets FULL_CONTROL. The AllUsers group gets READ access.\n" }, { "name" : "s3:ACL-GRANT-PUBLIC-READ-WRITE", "type" : "item()*", "description" : " The public-read-write canned ACL. Applicable to buckets and objects.\n Owner gets FULL_CONTROL. The AllUsers group gets READ and WRITE access.\n Granting this on a bucket is generally not recommended.\n" }, { "name" : "s3:ACL-GRANT-AUTHENTICATED-READ", "type" : "item()*", "description" : " The autenticated-read canned ACL. Applicable to buckets and objects.\n Owner gets FULL_CONTROL. The AuthenticatedUsers group gets READ access.\n" }, { "name" : "s3:ACL-GRANT-BUCKET-OWNER-READ", "type" : "item()*", "description" : " The grant-bucket-owner-read canned ACL. Applicable to objects.\n Object owner gets FULL_CONTROL. Bucket owner gets READ access.\n If you specify this canned ACL when creating a bucket, Amazon S3 ignores it.\n" }, { "name" : "s3:ACL-GRANT-BUCKET-OWNER-FULL-CONTROL", "type" : "item()*", "description" : " The grant-bucket-owner-full-control canned ACL. Applicable to objects.\n Both the object owner and the bucket owner get FULL_CONTROL over the object.\n If you specify this canned ACL when creating a bucket, Amazon S3 ignores it.\n" } ] }, "http://api.28.io/authorization" : { "ns" : "http://api.28.io/authorization", "description" : "", "sees" : [  ], "authors" : [  ], "version" : null, "encoding" : null, "namespaces" : [ { "uri" : "", "prefix" : "an" }, { "uri" : "http://api.28.io/authorization", "prefix" : "authorization" }, { "uri" : "http://zorba.io/modules/base64", "prefix" : "base64" }, { "uri" : "http://zorba.io/modules/hmac", "prefix" : "hmac" }, { "uri" : "http://expath.org/ns/http-client", "prefix" : "http-client" }, { "uri" : "http://www.28msec.com/modules/project", "prefix" : "project" }, { "uri" : "http://www.28msec.com/modules/http/request", "prefix" : "req" }, { "uri" : "http://www.28msec.com/modules/http/response", "prefix" : "res" } ], "functions" : [ { "isDocumented" : false, "arity" : 0, "name" : "authorized", "qname" : "authorization:authorized", "signature" : "() as xs:boolean", "description" : "", "summary" : "", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:boolean", "description" : "" }, "errors" : [  ] }, { "isDocumented" : false, "arity" : 0, "name" : "html-do-login", "qname" : "authorization:html-do-login", "signature" : "()", "description" : "", "summary" : "", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [  ], "returns" : { "type" : null, "description" : "" }, "errors" : [  ] }, { "isDocumented" : false, "arity" : 0, "name" : "html-show-login", "qname" : "authorization:html-show-login", "signature" : "()", "description" : "", "summary" : "", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [  ], "returns" : { "type" : null, "description" : "" }, "errors" : [  ] } ], "variables" : [  ] }, "http://zorba.io/modules/store/static/integrity-constraints/dml" : { "ns" : "http://zorba.io/modules/store/static/integrity-constraints/dml", "description" : " This module defines a function to check if an integrity constraint is\n satisfied.\n The integrity constraint needs to be declared in the prolog of a module.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n This module is part of\n <a xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" href=\"../zorba/xqddf.html\">Zorba's XQuery Data Definition Facility</a>.\n All the integrity constraints managed by this module have to be pre-declared\n in the prolog of a module.\n Please refer to the\n <a xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" href=\"../zorba/data_lifecycle.html\">general documentation</a>\n for more information and examples.\n", "sees" : [ "<xqdoc:see xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"><a href=\"../zorba/data_lifecycle.html\">Data Lifecycle</a></xqdoc:see>", "<xqdoc:see xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"><a href=\"../zorba/xqddf.html\">XQuery Data Definition Facility</a></xqdoc:see>", "<xqdoc:see xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">http://zorba.io/modules/store/static/integrity-constraints/dml</xqdoc:see>", "<xqdoc:see xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">http://zorba.io/modules/store/static/collections/dml</xqdoc:see>", "<xqdoc:see xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">http://zorba.io/modules/store/static/collections/ddl</xqdoc:see>", "<xqdoc:see xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">http://zorba.io/modules/store/static/indexes/ddl</xqdoc:see>", "<xqdoc:see xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">http://zorba.io/modules/store/static/indexes/dml</xqdoc:see>", "<xqdoc:see xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">http://zorba.io/errors</xqdoc:see>" ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Nicolae Brinza, Matthias Brantner, David Graf, Till Westmann, Markos Zaharioudakis</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://zorba.io/modules/store/static/integrity-constraints/dml", "prefix" : "icdml" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" }, { "uri" : "http://zorba.io/errors", "prefix" : "zerr" } ], "functions" : [ { "isDocumented" : true, "arity" : 1, "name" : "check-integrity-constraint", "qname" : "icdml:check-integrity-constraint", "signature" : "($name as xs:QName) as xs:boolean external", "description" : " Checks if the specified constraints are valid in the database.\n", "summary" : "<p> Checks if the specified constraints are valid in the database.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "name", "type" : "xs:QName", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The name of the integrity constraint to check.</div>" } ], "returns" : { "type" : "xs:boolean", "description" : "true if the constraints are valid; false otherwise." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY0031 if the integrity constraint is not declared.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY0032 if the integrity constraint is not available.</xqdoc:error>" ] } ], "variables" : [  ] }, "http://zorba.io/modules/excel/statistical" : { "ns" : "http://zorba.io/modules/excel/statistical", "description" : " This is a library module offering a part of the set of statistical functions\n defined by Microsoft Excel 2003.\n", "sees" : [ "<xqdoc:see xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"><a href=\"http://office.microsoft.com/en-us/excel/CH062528311033.aspx\" target=\"_blank\">Excel 2003 Documentation: Statistical Functions</a></xqdoc:see>" ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Daniel Turcanu</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://zorba.io/modules/excel/statistical", "prefix" : "excel" }, { "uri" : "http://zorba.io/modules/excel/errors", "prefix" : "excel-err" }, { "uri" : "http://zorba.io/modules/excel/math", "prefix" : "excel-math" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 1, "name" : "avedev", "qname" : "excel:avedev", "signature" : "($numbers as xs:anyAtomicType+) as xs:anyAtomicType", "description" : " Returns the average of the absolute deviations of data points from their mean.\n The formula is sum(abs(x - average_x))/n, where n is the count of x in the sequence.\n", "summary" : "<p> Returns the average of the absolute deviations of data points from their mean.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "xs:anyAtomicType", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers or values castable to numeric. Sequence can be of any length from 1 up.</div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "The formula result" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if the parameters cannot be casted to numeric type</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "average", "qname" : "excel:average", "signature" : "($numbers as xs:anyAtomicType*) as xs:anyAtomicType", "description" : " Returns the average (arithmetic mean) of the arguments.\n Arguments can be empty values, otherwise must be castable to numeric.\n If sequence is empty then zero is returned.\n The sequence can be of any length.\n", "summary" : "<p> Returns the average (arithmetic mean) of the arguments.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The sequence of numbers or empty values.</div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "The sum of all numbers divided by the number of non-empty values." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if the parameters cannot be casted to numeric type.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "averagea", "qname" : "excel:averagea", "signature" : "($numbers as xs:anyAtomicType+) as xs:anyAtomicType", "description" : " Calculates the average (arithmetic mean) of the values in the sequence of arguments.\n Arguments can be of any type.\n The numbers are added, and the sum is divided by the size of entire sequence.\n", "summary" : "<p> Calculates the average (arithmetic mean) of the values in the sequence of arguments.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "xs:anyAtomicType", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of values of any type. The sequence can be of any length, from 1 up.</div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "The result" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "count", "qname" : "excel:count", "signature" : "($numbers as xs:anyAtomicType*) as xs:integer", "description" : " Counts the number of cells that contain numbers or values castable to numeric.\n", "summary" : "<p> Counts the number of cells that contain numbers or values castable to numeric.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The sequence of values, of any length.</div>" } ], "returns" : { "type" : "xs:integer", "description" : "The count of numbers." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "counta", "qname" : "excel:counta", "signature" : "($numbers as xs:anyAtomicType*) as xs:integer", "description" : " Counts the number of values that are not empty.\n Empty values are the one with string value \"\".\n", "summary" : "<p> Counts the number of values that are not empty.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of values of any type, any length</div>" } ], "returns" : { "type" : "xs:integer", "description" : "The count of non-empty values" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "countblank", "qname" : "excel:countblank", "signature" : "($cells as xs:anyAtomicType*) as xs:integer", "description" : " Counts the empty values in a sequence.\n The empty values are the ones with string value \"\".\n The value 0 is not counted.\n", "summary" : "<p> Counts the empty values in a sequence.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "cells", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of values, of any length</div>" } ], "returns" : { "type" : "xs:integer", "description" : "The count" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "large", "qname" : "excel:large", "signature" : "($numbers as xs:anyAtomicType*, $k as xs:integer) as xs:anyAtomicType", "description" : " Returns the k-th largest value in a data set.\n If n is the number of data points in a range,\n   then LARGE(array,1) returns the largest value,\n   and LARGE(array,n) returns the smallest value.\n", "summary" : "<p> Returns the k-th largest value in a data set.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers or values castable to numeric. The sequence can be of any length, from 1 up.</div>" }, { "name" : "k", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the position of largest value, with value from 1 to count of values</div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "The k-th largest value as numeric type" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if the parameters cannot be casted to numeric type</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Num if the sequence is empty</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Num if k is not a value between 1 and the sequence size</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "max", "qname" : "excel:max", "signature" : "($numbers as xs:anyAtomicType*) as xs:anyAtomicType", "description" : " Returns the largest number in a sequence.\n", "summary" : "<p> Returns the largest number in a sequence.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers or values castable to numeric. The sequence can be of any length.</div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "The max" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if the parameters cannot be casted to numeric type</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "maxa", "qname" : "excel:maxa", "signature" : "($numbers as xs:anyAtomicType*) as xs:anyAtomicType", "description" : " Returns the largest value in a list of arguments.\n In this implementation there is no difference between MAX and MAXA.\n", "summary" : "<p> Returns the largest value in a list of arguments.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers or values castable to numeric The sequence can be of any length.</div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "The max" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if the parameters cannot be casted to numeric type</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "median", "qname" : "excel:median", "signature" : "($numbers as xs:anyAtomicType*) as xs:anyAtomicType", "description" : " Returns the median of the given numbers.\n The median is the number in the middle of a set of numbers.\n Half the numbers have values that are greater than the median,\n and half the numbers have values that are less than the median.\n", "summary" : "<p> Returns the median of the given numbers.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers, of any length</div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "for odd count of numbers return the number in the middle of the sorted sequence. For even count of numbers return the average of the two numbers in the middle." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if the parameters cannot be casted to numeric type</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "min", "qname" : "excel:min", "signature" : "($numbers as xs:anyAtomicType*) as xs:anyAtomicType", "description" : " Returns the smallest number in a sequence.\n", "summary" : "<p> Returns the smallest number in a sequence.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers or values castable to numeric. The sequence can be of any length.</div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "The min" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if the parameters cannot be casted to numeric type</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "mina", "qname" : "excel:mina", "signature" : "($numbers as xs:anyAtomicType*) as xs:anyAtomicType", "description" : " Returns the smallest value in a list of arguments.\n In this implementation there is no difference between MAX and MAXA.\n", "summary" : "<p> Returns the smallest value in a list of arguments.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers or values castable to numeric The sequence can be of any length.</div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "The min" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if the parameters cannot be casted to numeric type</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "mode", "qname" : "excel:mode", "signature" : "($numbers as xs:anyAtomicType*) as xs:anyAtomicType", "description" : " Returns the most frequently occurring, or repetitive, value in a sequence.\n Arguments must be castable to numeric.\n", "summary" : "<p> Returns the most frequently occurring, or repetitive, value in a sequence.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers, of any length</div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "The most occuring number" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if the parameters cannot be casted to numeric type</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">fn:QName(\"http://zorba.io/modules/excel/errors\", \"excel-err:NA\") if there are no duplicate numbers</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "percentile", "qname" : "excel:percentile", "signature" : "($numbers as xs:anyAtomicType*, $k_at as xs:anyAtomicType) as xs:anyAtomicType", "description" : " Returns the k-th percentile of values in a sequence.\n If k is not a multiple of 1/(n - 1),\n   PERCENTILE interpolates to determine the value at the k-th percentile.\n The function is computed by (max-min)*k + min\n", "summary" : "<p> Returns the k-th percentile of values in a sequence.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers, of any length</div>" }, { "name" : "k_at", "type" : "xs:anyAtomicType", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the percentile, with value between 0 .. 1 inclusive</div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "The computed percentile" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if the parameters cannot be casted to numeric type</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Num if percentile is not between 0 .. 1</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "percentrank", "qname" : "excel:percentrank", "signature" : "($numbers as xs:anyAtomicType*, $x as xs:anyAtomicType) as xs:decimal", "description" : " Returns the rank of a value in a data set as a percentage of the data set.\n If x does not match one of the values in array,\n   PERCENTRANK interpolates to return the correct percentage rank. <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The formula is uses: (RANK - 1) / (size - 1) .\n", "summary" : "<p> Returns the rank of a value in a data set as a percentage of the data set.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers or values castable to numbers. The sequence can be of any length, from 1 up.</div>" }, { "name" : "x", "type" : "xs:anyAtomicType", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> is the value for which you want to know the rank</div>" } ], "returns" : { "type" : "xs:decimal", "description" : "The percentage of rank." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if the parameters cannot be casted to numeric type</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Num if the sequence is zero length</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "prob", "qname" : "excel:prob", "signature" : "($x_range as xs:anyAtomicType+, $prob_range as xs:anyAtomicType+, $range_lower_limit as xs:anyAtomicType) as xs:anyAtomicType", "description" : " This is the same as above, only that upper_limit is not specified.\n The probability is computed only for range_lower_limit.\n", "summary" : "<p> This is the same as above, only that upper_limit is not specified.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "x_range", "type" : "xs:anyAtomicType", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> is the range of numeric values of x with which there are associated probabilities. This does not need to be ordered.</div>" }, { "name" : "prob_range", "type" : "xs:anyAtomicType", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> is a set of probabilities associated with values in x_range.</div>" }, { "name" : "range_lower_limit", "type" : "xs:anyAtomicType", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> is the value for which you want a probability.</div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "The probability of the range_lower_limit value" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Num if any probability is not between 0 and 1</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Num if the sum of probabilities is not equal to 1</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if any parameter is not castable to numeric</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Num if x_range and prob_range do not have the same number of values</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 4, "name" : "prob", "qname" : "excel:prob", "signature" : "($x_range as xs:anyAtomicType+, $prob_range as xs:anyAtomicType+, $range_lower_limit as xs:anyAtomicType, $upper_limit as xs:anyAtomicType) as xs:anyAtomicType", "description" : " Returns the probability that values in a range are between two limits.\n", "summary" : "<p> Returns the probability that values in a range are between two limits.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "x_range", "type" : "xs:anyAtomicType", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> is the range of numeric values of x with which there are associated probabilities. This does not need to be ordered.</div>" }, { "name" : "prob_range", "type" : "xs:anyAtomicType", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> is a set of probabilities associated with values in x_range.</div>" }, { "name" : "range_lower_limit", "type" : "xs:anyAtomicType", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> is the lower bound on the value for which you want a probability.</div>" }, { "name" : "upper_limit", "type" : "xs:anyAtomicType", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> is the upper bound on the value for which you want a probability.</div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "The probability of the entire range" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Num if any probability is not between 0 and 1</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Num if the sum of probabilities is not equal to 1</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if any parameter is not castable to numeric</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Num if x_range and prob_range do not have the same number of values</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "quartile", "qname" : "excel:quartile", "signature" : "($numbers as xs:anyAtomicType*, $quart as xs:integer) as xs:anyAtomicType", "description" : " Returns the quartile of a data set.\n", "summary" : "<p> Returns the quartile of a data set.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> sequence of numbers or values castable to numbers. The sequence can be of any length, from 1 up.</div>" }, { "name" : "quart", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> <dl>one of the values 0, 1, 2, 3, 4 with meaning: <dt>0</dt> <dd> compute minimum value</dd> <dt>1</dt> <dd> compute first quartile (25th percentile)</dd> <dt>2</dt> <dd> compute median value (50th percentile)</dd> <dt>3</dt> <dd> compute third quartile (75th percentile)</dd> <dt>4</dt> <dd> compute maximum value</dd></dl></div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "the computed quartile, as numeric type" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if the parameters cannot be casted to numeric type</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Num if the sequence is zero length</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Num if $quart is not one of the values 0, 1, 2, 3, 4</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "rank", "qname" : "excel:rank", "signature" : "($x as xs:anyAtomicType, $numbers as xs:anyAtomicType*) as xs:decimal", "description" : " This RANK function is same as the above, only that $order_ascending is set by default to false.\n", "summary" : "<p> This RANK function is same as the above, only that $order_ascending is set by default to false.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "x", "type" : "xs:anyAtomicType", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The number whose rank you want to find.</div>" }, { "name" : "numbers", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers or values castable to numbers. The sequence can be of any length.</div>" } ], "returns" : { "type" : "xs:decimal", "description" : "The rank of $x." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if the parameters cannot be casted to numeric type.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "rank", "qname" : "excel:rank", "signature" : "($x as xs:anyAtomicType, $numbers as xs:anyAtomicType*, $order_ascending as xs:boolean) as xs:decimal", "description" : " Returns the rank of a number in a list of numbers.\n The rank of a number is its size relative to other values in a list.\n (If you were to sort the list, the rank of the number would be its position.)\n RANK gives duplicate numbers the same rank.\n", "summary" : "<p> Returns the rank of a number in a list of numbers.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "x", "type" : "xs:anyAtomicType", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The number whose rank you want to find.</div>" }, { "name" : "numbers", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The sequence of numbers or values castable to numbers. The sequence can be of any length.</div>" }, { "name" : "order_ascending", "type" : "xs:boolean", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> <dl>A boolean having the meaning: <dt>false</dt><dd>then rank the number as if the sequence was sorted in descending order.</dd> <dt>true</dt> <dd>then rank the number as if the sequence was sorted in ascending order.</dd></dl></div>" } ], "returns" : { "type" : "xs:decimal", "description" : "The rank of $x." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if the parameters cannot be casted to numeric type.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "slope", "qname" : "excel:slope", "signature" : "($known_y as xs:anyAtomicType+, $known_x as xs:anyAtomicType+) as xs:anyAtomicType", "description" : " Returns the slope of the linear regression line through data points in known_y's and known_x's.\n The slope is the vertical distance divided by the horizontal distance between\n   any two points on the line, which is the rate of change along the regression line.\n It computes the formula:<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n sum((x - average_x)(y - average_y)) / sum((x - average_x)^2)  <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n where average_x and average_y are computed with AVERAGE function.\n", "summary" : "<p> Returns the slope of the linear regression line through data points in known_y's and known_x's.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "known_y", "type" : "xs:anyAtomicType", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of y numbers. The sequence can be of any length, from 1 up.</div>" }, { "name" : "known_x", "type" : "xs:anyAtomicType", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of x numbers. The sequence can be of any length, from 1 up.</div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "The slope value, as numeric type" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if any parameter cannot be casted to numeric</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">fn:QName(\"http://zorba.io/modules/excel/errors\", \"excel-err:NA\") if there are different numbers of x's and y's</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">fn:QName(\"http://zorba.io/modules/excel/errors\", \"excel-err:NA\") if any sequence is empty</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Div0 if all x's are equal</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "small", "qname" : "excel:small", "signature" : "($numbers as xs:anyAtomicType*, $k as xs:integer) as xs:anyAtomicType", "description" : " This function computes the k-th smallest value in a data set.\n Use this function to return values with a particular relative standing in a data set.\n If n is the number of data points in array, SMALL(array,1) equals the smallest value,\n   and SMALL(array,n) equals the largest value.\n", "summary" : "<p> This function computes the k-th smallest value in a data set.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> A sequence of numbers or values castable to numeric. The sequence can be of any length, from 1 up.</div>" }, { "name" : "k", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The position (from the smallest) in the sequence of data to return. Must have value between 1 and size of sequence.</div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "The k-th smallest value of $numbers." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if the parameters cannot be casted to numeric type.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Num if the sequence is zero length.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Num if $k is not a value between 1 and the size of sequence.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "standardize", "qname" : "excel:standardize", "signature" : "($x as xs:anyAtomicType, $mean as xs:anyAtomicType, $standard_dev as xs:anyAtomicType) as xs:double", "description" : " Returns a normalized value from a distribution characterized by mean and standard_dev.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The formula is (x - mean) / standard_dev .\n", "summary" : "<p> Returns a normalized value from a distribution characterized by mean and standard_dev.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "x", "type" : "xs:anyAtomicType", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> is the value you want to normalize</div>" }, { "name" : "mean", "type" : "xs:anyAtomicType", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> is the arithmetic mean of the distribution.</div>" }, { "name" : "standard_dev", "type" : "xs:anyAtomicType", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> is the standard deviation of the distribution.</div>" } ], "returns" : { "type" : "xs:double", "description" : "The normalized x, as numeric type" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if any parameter cannot be casted to numeric</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Num if standard_dev is a value smaller than zero or equal</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "var", "qname" : "excel:var", "signature" : "($numbers as xs:anyAtomicType+) as xs:anyAtomicType", "description" : " Estimates variance based on a sample.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The formula is sum(x - average_x)^2 / (n - 1).<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n average_x is computed with AVERAGE function.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n n is the count of numbers from the sequence, excluding empty values.\n", "summary" : "<p> Estimates variance based on a sample.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "xs:anyAtomicType", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers or values castable to numeric. The sequence can be of any length, from 1 up.</div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "The variance, as numeric type" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if the parameters cannot be casted to numeric type</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "vara", "qname" : "excel:vara", "signature" : "($numbers as xs:anyAtomicType+) as xs:anyAtomicType", "description" : " Estimates variance based on a sample.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The formula is sum(x - average_x)^2 / (n - 1).<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n average_x is computed with AVERAGE function.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n n is the size of sequence, including empty values.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n", "summary" : "<p> Estimates variance based on a sample.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "xs:anyAtomicType", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers or values castable to numeric. The sequence can be of any length, from 1 up.</div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "The variance, as numeric type" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if the parameters cannot be casted to numeric type</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "varp", "qname" : "excel:varp", "signature" : "($numbers as xs:anyAtomicType+) as xs:anyAtomicType", "description" : " Calculates variance based on the entire population.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The formula is sum(x - average_x)^2 / n.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n average_x is computed with AVERAGE function.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n n is the count of numbers from the sequence, excluding empty values.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n", "summary" : "<p> Calculates variance based on the entire population.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "xs:anyAtomicType", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers or values castable to numeric. The sequence can be of any length, from 1 up.</div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "The variance, as numeric type" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if the parameters cannot be casted to numeric type</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "varpa", "qname" : "excel:varpa", "signature" : "($numbers as xs:anyAtomicType+) as xs:anyAtomicType", "description" : " Calculates variance based on the entire population.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The formula is sum(x - average_x)^2 / n.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n average_x is computed with AVERAGE function.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n n is the size of sequence, including empty values.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n", "summary" : "<p> Calculates variance based on the entire population.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "numbers", "type" : "xs:anyAtomicType", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of numbers or values castable to numeric. The sequence can be of any length, from 1 up.</div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "The variance, as numeric type" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if the parameters cannot be casted to numeric type</xqdoc:error>" ] } ], "variables" : [  ] }, "http://www.zorba-xquery.com/modules/languages/xslt" : { "ns" : "http://www.zorba-xquery.com/modules/languages/xslt", "description" : " This module provides XSLT 1.0 transformation functionality.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">For details on XSLT see\n <a href=\"http://www.w3.org/TR/xslt\">XSLT 1.0 specification</a>.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This module implements the invoking of an XSLT transformation from XQuery\n described in <a href=\"http://lists.w3.org/Archives/Member/w3c-xsl-wg/2008Apr/0052.html\">\n    Michael Kay's proposal</a>.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre class=\"ace-static\" ace-mode=\"xquery\">import module namespace\n        xslt = \"http://www.zorba-xquery.com/modules/languages/xslt\";\n let $source :=\n     &lt;catalog&gt;\n         &lt;cd&gt;\n           &lt;title&gt;Empire Burlesque&lt;/title&gt;\n           &lt;artist&gt;Bob Dylan&lt;/artist&gt;\n           &lt;country&gt;USA&lt;/country&gt;\n           &lt;company&gt;Columbia&lt;/company&gt;\n           &lt;price&gt;10.90&lt;/price&gt;\n           &lt;year&gt;1985&lt;/year&gt;\n         &lt;/cd&gt;\n         &lt;cd&gt;\n           &lt;title&gt;Hide your heart&lt;/title&gt;\n           &lt;artist&gt;Bonnie Tyler&lt;/artist&gt;\n           &lt;country&gt;UK&lt;/country&gt;\n           &lt;company&gt;CBS Records&lt;/company&gt;\n           &lt;price&gt;9.90&lt;/price&gt;\n           &lt;year&gt;1988&lt;/year&gt;\n         &lt;/cd&gt;\n     &lt;/catalog&gt;\n let $stylesheet :=\n   &lt;xsl:stylesheet version=\"1.0\"\n       xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"&gt;\n     &lt;xsl:template match=\"/\"&gt;\n       &lt;html&gt;\n       &lt;body&gt;\n       &lt;h2&gt;Music Collection&amp;lt;/h2&gt;\n         &lt;table border=\"1\"&gt;\n           &lt;tr bgcolor=\"lightblue\"&gt;\n             &lt;th&gt;Title&amp;lt;/th&gt;\n             &lt;th&gt;Artist&amp;lt;/th&gt;\n           &lt;/tr&gt;\n           &lt;xsl:for-each select=\"catalog/cd\"&gt;\n            &lt;tr&gt;\n              &lt;td&gt;&amp;lt;xsl:value-of select=\"title\"/&gt;&lt;/td&gt;\n              &lt;td&gt;&amp;lt;xsl:value-of select=\"artist\"/&gt;&lt;/td&gt;\n           &lt;/tr&gt;\n           &lt;/xsl:for-each&gt;\n         &lt;/table&gt;\n       &lt;/body&gt;\n       &lt;/html&gt;\n     &lt;/xsl:template&gt;\n   &lt;/xsl:stylesheet&gt;\n return\n   xslt:transform( $source, $stylesheet)</pre></p>\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Cezar Andrei</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" }, { "uri" : "http://www.zorba-xquery.com/modules/languages/xslt", "prefix" : "xslt" } ], "functions" : [ { "isDocumented" : true, "arity" : 2, "name" : "transform", "qname" : "xslt:transform", "signature" : "($source as node(), $stylesheet as node()) as node() external", "description" : "<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Invokes an XSLT transformation.</p>\n", "summary" : "<p>Invokes an XSLT transformation.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "source", "type" : "node()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the input document to the transformation</div>" }, { "name" : "stylesheet", "type" : "node()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the XSLT stylesheet module</div>" } ], "returns" : { "type" : "node()", "description" : "the result tree produced by the transformation" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">xslt:XSLT001 if $stylesheet is not a valid XSLT stylesheet</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">xslt:XSLT002 if result can not be imported</xqdoc:error>" ] } ], "variables" : [  ] }, "http://zorba.io/modules/data-cleaning/phonetic-string-similarity" : { "ns" : "http://zorba.io/modules/data-cleaning/phonetic-string-similarity", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This library module provides phonetic string similarity functions, comparing strings with basis on how they sound.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">These metrics are particularly effective in matching names, since names are often spelled in different\n ways that sound the same.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The logic contained in this module is not specific to any particular XQuery implementation.</p>\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Bruno Martins</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://zorba.io/modules/data-cleaning/phonetic-string-similarity", "prefix" : "simp" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 1, "name" : "metaphone-key", "qname" : "simp:metaphone-key", "signature" : "($s1 as xs:string) as xs:string", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the Metaphone key for a given string.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The Metaphone algorithm produces variable length keys as its output, as opposed to Soundex's fixed-length keys.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example usage : <pre class=\"ace-static\" ace-mode=\"xquery\">metaphone-key(\"ALEKSANDER\")</pre></p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The function invocation in the example above returns : <pre class=\"ace-static\" ace-mode=\"xquery\">\"ALKSNTR\"</pre></p>\n", "summary" : "<p>  Returns the Metaphone key for a given string.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "s1", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The string.</div>" } ], "returns" : { "type" : "xs:string", "description" : "The Metaphone key for the given input string." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "metaphone", "qname" : "simp:metaphone", "signature" : "($s1 as xs:string, $s2 as xs:string) as xs:boolean", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Checks if two strings have the same Metaphone key.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example usage : <pre class=\"ace-static\" ace-mode=\"xquery\">metaphone(\"ALEKSANDER\", \"ALEXANDRE\")</pre></p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The function invocation in the example above returns : <pre class=\"ace-static\" ace-mode=\"xquery\">true</pre></p>\n", "summary" : "<p>  Checks if two strings have the same Metaphone key.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "s1", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The first string.</div>" }, { "name" : "s2", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The second string.</div>" } ], "returns" : { "type" : "xs:boolean", "description" : "Returns true if both strings have the same Metaphone key and false otherwise." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "soundex-key", "qname" : "simp:soundex-key", "signature" : "($s1 as xs:string) as xs:string", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the Soundex key for a given string.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example usage : <pre class=\"ace-static\" ace-mode=\"xquery\">soundex-key(\"Robert\")</pre></p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The function invocation in the example above returns : <pre class=\"ace-static\" ace-mode=\"xquery\">\"R163\"</pre></p>\n", "summary" : "<p>  Returns the Soundex key for a given string.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "s1", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The string.</div>" } ], "returns" : { "type" : "xs:string", "description" : "The Soundex key for the given input string." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "soundex", "qname" : "simp:soundex", "signature" : "($s1 as xs:string, $s2 as xs:string) as xs:boolean", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Checks if two strings have the same Soundex key.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example usage : <pre class=\"ace-static\" ace-mode=\"xquery\">soundex( \"Robert\" , \"Rupert\" )</pre></p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The function invocation in the example above returns : <pre class=\"ace-static\" ace-mode=\"xquery\">true</pre></p>\n", "summary" : "<p>  Checks if two strings have the same Soundex key.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "s1", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The first string.</div>" }, { "name" : "s2", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The second string.</div>" } ], "returns" : { "type" : "xs:boolean", "description" : "Returns true if both strings have the same Soundex key and false otherwise." }, "errors" : [  ] } ], "variables" : [  ] }, "http://www.28msec.com/modules/collections" : { "ns" : "http://www.28msec.com/modules/collections", "description" : " This module provides functions to work with collections. For example,\n it contains functions to retrieve the content of a collection or the\n names of all collections.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The module is always imported so you don't need to import it explicitly.\n Also, you don't need to fully qualify a function to invoke it.</p>\n", "sees" : [  ], "authors" : [  ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://zorba.io/annotations", "prefix" : "an" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" }, { "uri" : "http://zorba.io/errors", "prefix" : "zerr" } ], "functions" : [ { "isDocumented" : true, "arity" : 2, "name" : "apply-insert", "qname" : "db:apply-insert", "signature" : "($name as string, $content as item()*) as item()* external", "description" : " This function does the same as the insert function and it immediately applies\n the resulting pending updates and returns the items that have been inserted.\n Note that each item in the content sequence is copied before insertion. This\n function provides an efficient way to retrieve the actual copies that have\n been inserted.\n", "summary" : "<p> This function does the same as the insert function and it immediately applies\n the resulting pending updates and returns the items that have been inserted.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The name of the collection to which the items should be added.</div>" }, { "name" : "content", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The sequences of items whose copies should be added to the collection.</div>" } ], "returns" : { "type" : "item()*", "description" : "The result of the function is the sequence of items that have been inserted into the collection." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY0003 if the collection identified by <tt>$name</tt> does not exist.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDTY0001 if any of the items in the $content do not match the expected type (as specified in the collection declaration) or are not XML documents, XML elements, JSON objects, or JSON arrays.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 0, "name" : "available-collections", "qname" : "db:available-collections", "signature" : "() as string* external", "description" : " Return the names of all existing collections.\n", "summary" : "<p> Return the names of all existing collections.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "string*", "description" : "The names of all existing collections." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "collection-name", "qname" : "db:collection-name", "signature" : "($o as item()) as string external", "description" : " The collection-name function returns the name of the containing collection\n of the given item.\n", "summary" : "<p> The collection-name function returns the name of the containing collection\n of the given item.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "o", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The item for which to get the name of the collection.</div>" } ], "returns" : { "type" : "string", "description" : "The name of the containing collection." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY0011 if the given item does not belong to a collection.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "collection", "qname" : "db:collection", "signature" : "($name as string) as item()* external", "description" : " The collection function returns the sequence of items that belong\n to the collection identified by the given name.\n Please note that the order of the items returned is not deterministic,\n i.e. it might change between invocations. You can use\n <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">db:collection($name, 0)</tt> to get a deterministic order.\n", "summary" : "<p> The collection function returns the sequence of items that belong\n to the collection identified by the given name.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The name of the collection.</div>" } ], "returns" : { "type" : "item()*", "description" : "The content of the collection." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY0003 if the collection identified by $name does not exist.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "collection", "qname" : "db:collection", "signature" : "($name as string, $skip as integer) as item()* external", "description" : " The collection function returns the sequence of items that belong to\n the collection identified\n by the given name. The skip parameter allows to (efficiently) skip\n a given number of items.\n Note that the collections are generally unordered. However, there\n is an implicit deterministic ordering (i.e. sorting by the _id field\n in MongoDB) that is used by this function. This ordering is not present\n for the <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">db:collection#1</tt> function. In order to return items with\n a stable ordering, db:collection($name, 0) can be used.\n", "summary" : "<p> The collection function returns the sequence of items that belong to\n the collection identified\n by the given name.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The name of the collection.</div>" }, { "name" : "skip", "type" : "integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The number of items to skip starting from the beginning.</div>" } ], "returns" : { "type" : "item()*", "description" : "The content of the collection starting at the <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$skip</tt>+1 item." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY0003 if the collection identified by $name does not exist</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "collection", "qname" : "db:collection", "signature" : "($name as string, $start as string, $skip as integer) as item()* external", "description" : " The collection function returns the sequence of items that belong to\n the collection identified\n by the given name. The start parameter is a reference and determines\n the first item to return. The skip parameter allows to (efficiently) skip\n a given number of items starting at the item referenced by <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$start</tt>.\n The start parameter is useful for efficiently implementing pagination.\n Note that the collections are generally unordered. However, there\n is an implicit deterministic ordering (i.e. sorting by the _id field\n in MongoDB) that is used by this function. This ordering is not present\n for the <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">db:collection#1</tt> function. In order to return items with\n a stable ordering, db:collection($name, $start, 0) can be used.\n Example:\n <pre xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n import module namespace ref = \"http://zorba.io/modules/reference\";\n let $ref := ref:reference(db:collection(\"test\", 1)[1])\n return\n   db:collection(\"test\", $ref, 1)\n </pre>\n", "summary" : "<p> The collection function returns the sequence of items that belong to\n the collection identified\n by the given name.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The name of the collection.</div>" }, { "name" : "start", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The reference to the first item to return.</div>" }, { "name" : "skip", "type" : "integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The number of collection items to skip.</div>" } ], "returns" : { "type" : "item()*", "description" : "The content of the collection starting at the item referenced by <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$start</tt> and skipping <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$skip</tt> items." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY0003 if the collection identified by <tt>$name</tt> does not exist.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZAPI0028 If the given reference $start is not a valid reference.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZSTR0066 if the given reference $start does not reference an item of this collection.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "create", "qname" : "db:create", "signature" : "($name as string) external", "description" : " The create function is an updating function that creates\n a new collection with the given name.\n It is not possible to create collections that start with\n \"system.\" or \"_28\" (zerr:ZDDY1000).\n Collections are identified by a name (string). Names are not allowed to\n contain the <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$</tt> sign or exceed the length of 70 characters.\n This is consistent with the restrictions for names of collections in MongoDB.\n", "summary" : "<p> The create function is an updating function that creates\n a new collection with the given name.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : true, "parameters" : [ { "name" : "name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The name of the collection to create.</div>" } ], "returns" : { "type" : null, "description" : "The result of the function is an empty XDM instance and a pending update list which, once applied, creates a collection with the given name." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY0002 if a collection with the given name already exists.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY1000 if the given name is not a legal collection name</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "create", "qname" : "db:create", "signature" : "($name as string, $content as item()*) external", "description" : " The create function is an updating function which creates\n a new collection with the given name. Moreover, it adds copies\n of the sequence <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$content</tt> to the new collection.\n It is not possible to create collections that start with\n \"system.\" or \"_28\" (zerr:ZDDY1000).\n Collections are identified by a name (string). Names are not allowed to\n contain the <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$</tt> sign or exceed the length of 70 characters.\n This is consistent with the restrictions for names of collections in MongoDB.\n", "summary" : "<p> The create function is an updating function which creates\n a new collection with the given name.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : true, "parameters" : [ { "name" : "name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The string of the collection to create.</div>" }, { "name" : "content", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The sequences of items that should be added to the new collection.</div>" } ], "returns" : { "type" : null, "description" : "The result of the function is an empty XDM instance and a pending update list which, once applied, creates a collection with the given name and inserts the given items into it." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY0002 if a collection with the given name already exists.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDTY0001 if any of the items in the $content do not match the expected type (as specified in the collection declaration) or are not XML documents, XML elements, JSON objects, or JSON arrays.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY1000 if the given name is not a legal collection name</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "delete", "qname" : "db:delete", "signature" : "($target as item()*) external", "description" : " The delete function is an updating function that deletes zero or more items\n (JSON objects, JSON arrays, or XML nodes) from a collection.\n Please note that the all of the items belong to the same collection\n (zerr:ZDDY0011).\n", "summary" : "<p> The delete function is an updating function that deletes zero or more items\n (JSON objects, JSON arrays, or XML nodes) from a collection.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : true, "parameters" : [ { "name" : "target", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the items that should be deleted from the containing collection.</div>" } ], "returns" : { "type" : null, "description" : "The result of this function is an empty XDM instance and a pending update list which, once applied, deletes the items from the collections." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY0003 if the collection identified by <tt>$name</tt> does not exist.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY0011 if any item in the <tt>$target</tt> sequence is not a member of a collection or not all items belong to the same collection.</xqdoc:error>" ] }, { "isDocumented" : false, "arity" : 1, "name" : "drop", "qname" : "db:drop", "signature" : "($name as string) external", "description" : "", "summary" : "", "annotation_str" : "", "annotations" : [  ], "updating" : true, "parameters" : [ { "name" : "name", "type" : "string", "occurrence" : null, "description" : "" } ], "returns" : { "type" : null, "description" : "" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "edit", "qname" : "db:edit", "signature" : "($target as item(), $content as item()) external", "description" : " The edit function is an updating function that edits the first supplied\n item so as to make it look exactly like a copy of the second supplied item,\n while retaining its original identity.\n", "summary" : "<p> The edit function is an updating function that edits the first supplied\n item so as to make it look exactly like a copy of the second supplied item,\n while retaining its original identity.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : true, "parameters" : [ { "name" : "target", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The target item, that must be edited.</div>" }, { "name" : "content", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The content item, that serves as an edit goal.</div>" } ], "returns" : { "type" : null, "description" : "The result of the function is an empty XDM instance and a pending update list which, once applied, performs the edit." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY0017 if the $target item is not a member of a collection.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY0040 if the target cannot be updated to match the content (for example because the target is a node and the content is an object).</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDTY0001 if $content does not match the expected type (as specified in the collection declaration) according to the rules for SequenceType Matching.</xqdoc:error>" ] }, { "isDocumented" : false, "arity" : 1, "name" : "index-keys", "qname" : "db:index-keys", "signature" : "($index-name as string) as array()* external", "description" : "", "summary" : "", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "index-name", "type" : "string", "occurrence" : null, "description" : "" } ], "returns" : { "type" : "array()*", "description" : "" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "insert", "qname" : "db:insert", "signature" : "($name as string, $content as item()*) external", "description" : " The insert function is an updating function that inserts copies of the given\n items into a collection.\n", "summary" : "<p> The insert function is an updating function that inserts copies of the given\n items into a collection.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : true, "parameters" : [ { "name" : "name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The name of the collection to which the items should be added.</div>" }, { "name" : "content", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The sequences of items whose copies should be added.</div>" } ], "returns" : { "type" : null, "description" : "The result of the function is an empty XDM instance and a pending update list which, once applied, inserts the items into the collection." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY0003 if the collection identified by <tt>$name</tt> does not exist.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDTY0001 if any of the items in the $content do not match the expected type (as specified in the collection declaration) or are not XML documents, XML elements, JSON objects, or JSON arrays.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "is-available-collection", "qname" : "db:is-available-collection", "signature" : "($name as string) as boolean external", "description" : " Determine if the collection with the given name exists.\n", "summary" : "<p> Determine if the collection with the given name exists.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The string of the collection in question.</div>" } ], "returns" : { "type" : "boolean", "description" : "true if collection with the given name exists, false otherwise." }, "errors" : [  ] }, { "isDocumented" : false, "arity" : 2, "name" : "lookup", "qname" : "db:lookup", "signature" : "($index-name as string, $key as item()) as item()* external", "description" : "", "summary" : "", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "index-name", "type" : "string", "occurrence" : null, "description" : "" }, { "name" : "key", "type" : "item()", "occurrence" : null, "description" : "" } ], "returns" : { "type" : "item()*", "description" : "" }, "errors" : [  ] }, { "isDocumented" : false, "arity" : 3, "name" : "lookup", "qname" : "db:lookup", "signature" : "($index-name as string, $keys as item(), $skip as integer) as item()* external", "description" : "", "summary" : "", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "index-name", "type" : "string", "occurrence" : null, "description" : "" }, { "name" : "keys", "type" : "item()", "occurrence" : null, "description" : "" }, { "name" : "skip", "type" : "integer", "occurrence" : null, "description" : "" } ], "returns" : { "type" : "item()*", "description" : "" }, "errors" : [  ] }, { "isDocumented" : false, "arity" : 1, "name" : "refresh", "qname" : "db:refresh", "signature" : "($index-name as string) external", "description" : "", "summary" : "", "annotation_str" : "", "annotations" : [  ], "updating" : true, "parameters" : [ { "name" : "index-name", "type" : "string", "occurrence" : null, "description" : "" } ], "returns" : { "type" : null, "description" : "" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "truncate", "qname" : "db:truncate", "signature" : "($name as string) external", "description" : " The truncate function is an updating function that deletes the\n entire content of a given collection.\n Please note that applying this function can not be undone in case\n an error happens during the application of the containing PUL.\n", "summary" : "<p> The truncate function is an updating function that deletes the\n entire content of a given collection.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : true, "parameters" : [ { "name" : "name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The name of the collection whose content to delete.</div>" } ], "returns" : { "type" : null, "description" : "The result of this function is an empty XDM instance and a pending update list which, once applied, deletes the nodes." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZDDY0003 if the collection identified by <tt>$name</tt> does not exist.</xqdoc:error>" ] } ], "variables" : [  ] }, "http://expath.org/ns/http-client" : { "ns" : "http://expath.org/ns/http-client", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n This module provides an implementation of the\n <a href=\"http://expath.org/modules/http-client/\">EXPath Http Client</a>.\n It provides functions for making HTTP requests and is a superset of the\n module specified by EXPath.\n Specifically, it implements the <code>http:send-request()</code> functions\n as specified by EXPath. Moreover, it adds an additional function\n <code>http:read()</code> (with several arities for the sake of ease).\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n In general, both functions take a description of the HTTP request to make\n as parameter, execute the request, and return a representation of the HTTP\n response. For instance, in the following code snippet, we fetch the Zorba\n home page:\n </p>\n <pre xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" class=\"ace-static\" ace-mode=\"xquery\">import module namespace http = \"http://expath.org/ns/http-client\";\n http:send-request(\n  &lt;http:request href=\"http://zorba.io\" method=\"get\" /&gt;\n )\n </pre>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n The <code>http:send-request()</code> functions are declared as sequential.\n Sequential functions are allowed to have side effects. For example, most probably,\n an HTTP POST request is a request that has side effects because it adds/changes\n a remote resource. Sequential functions are specified in the\n <a href=\"http://zorba.io/documentation/2.9/zorba/scripting_tutorial.html\">XQuery Scripting Extension</a>.\n In contrast, the http:read() functions are not declared as sequential -\n they are declared as being non deterministic though, which\n means that several calls may return different results.\n HTTP requests performed using these functions are <b>not</b> allowed to have\n side effects.\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n The response is returned as a sequence of one or more items. The first\n one is an <code>http:response</code> element with quite the same\n structure as an http:request, but without the content itself.\n The content is returned as the second item (or several items in case of\n a multipart response) as a string, a document node, or a binary item.\n This depends on the content-type returned.\n Specifically, the rules are as follows:\n <ul>\n  <li>A document node is returned if the media type has a MIME type of\n     text/xml, application/xml, text/xml-external-parsed-entity, or\n     application/xml-external-parsed-entity, as defined in [RFC 3023]\n     (except that application/xml-dtd is considered a text media type).\n     MIME types ending by +xml are also XML media types.</li>\n  <li>A document node is returned if the media type has a MIME type of\n      text/html. In order to be able to make HTML parseable, tidy is automatically\n      invoked. If you want to prevent that, you can also set your own content-type\n      by setting the override-media-type attribute in the request element.\n       For tidying, the following <a href=\"http://tidy.sourceforge.net/docs/quickref.html\">options</a>\n       will be used:\n       <ul>\n         <li>TidyXmlOut=yes</li>\n         <li>TidyDoctypeMode=TidyDoctypeOmit</li>\n         <li>TidyQuoteNbsp=yes</li>\n         <li>TidyCharEncoding=\"utf8\"</li>\n         <li>TidyNewline=\"LF\"</li>\n       </ul>\n  </li>\n  <li>An xs:string item is returned if the media type has a text MIME type,\n     i.e. beginning with text/.</li>\n  <li>An xs:base64Binary item is returned for all the other media types.</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n The structure of a request element is defined in the schema that is imported\n by this module. The details are described in the\n <a href=\"http://expath.org/spec/http-client#d2e183\">specification</a>.\n Analogously, the response element is also described in this\n <a href=\"http://expath.org/spec/http-client#d2e491\">specification</a>.\n </p>\n", "sees" : [ "<xqdoc:see xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"><a href=\"http://www.w3.org/TR/xquery-3/#FunctionDeclns\">XQuery 3.0: Function Declaration</a></xqdoc:see>" ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Federico Cavalieri, Markus Pilman</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://zorba.io/annotations", "prefix" : "an" }, { "uri" : "http://expath.org/ns/error", "prefix" : "err" }, { "uri" : "http://expath.org/ns/http-client", "prefix" : "http" }, { "uri" : "http://zorba.io/modules/http-client-wrapper", "prefix" : "http-wrapper" }, { "uri" : "http://expath.org/ns/http-client", "prefix" : "https" }, { "uri" : "http://www.zorba-xquery.com/modules/converters/html", "prefix" : "tidy" }, { "uri" : "http://www.zorba-xquery.com/modules/converters/html-options", "prefix" : "tidy-options" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 1, "name" : "send-request", "qname" : "http:send-request", "signature" : "($request as element(*)) as item()+", "description" : " Function for convenience.\n Calling this function is equivalent to calling\n <code xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n http:send-request($request, (), ())\n </code>\n", "summary" : "<p> Function for convenience.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "request", "type" : "element(*)", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> see request parameter of the sequential <a href=\"#send-request-3\">send-request</a> function with three parameters.</div>" } ], "returns" : { "type" : "item()+", "description" : "see return value of the sequential <a xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" href=\"#send-request-3\">send-request</a> function with three parameters." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "send-request", "qname" : "http:send-request", "signature" : "($request as element(*)?, $href as xs:string?) as item()+", "description" : " Function for convenience.\n Calling this function is equivalent to calling\n <code xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n http:send-request($request, $href, ())\n </code>\n", "summary" : "<p> Function for convenience.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "request", "type" : "element(*)", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> see request parameter of the sequential <a href=\"#send-request-3\">send-request</a> function with three parameters.</div>" }, { "name" : "href", "type" : "xs:string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> see href parameter of the sequential <a href=\"#send-request-3\">send-request</a> function with three parameters.</div>" } ], "returns" : { "type" : "item()+", "description" : "see return of <a xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" href=\"#send-request-3\">send-request</a>" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 3, "name" : "send-request", "qname" : "http:send-request", "signature" : "($request as element(*)?, $href as xs:string?, $bodies as item()*) as item()+", "description" : " This function sends an HTTP request and returns the corresponding response.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n This function is declared as sequential (see XQuery Scripting).\n Sequential functions are allowed to have side effects. For example, most probably,\n an HTTP POST request is a request that has side effects because it adds/changes\n a remote resource.\n </p>\n", "summary" : "<p> This function sends an HTTP request and returns the corresponding response.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "request", "type" : "element(*)", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> Contains the various parameters of the request. See the <a href=\"http://expath.org/spec/http-client#d2e183\">specification</a>. for a full description of the structure of this element.</div>" }, { "name" : "href", "type" : "xs:string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> is the HTTP or HTTPS URI to send the request to. It must be a valid xs:anyURI, but is declared as a string to be able to pass literal strings (without requiring to explicitly cast it to an xs:anyURI.)</div>" }, { "name" : "bodies", "type" : "item()", "occurrence" : "*", "description" : "" } ], "returns" : { "type" : "item()+", "description" : "a sequence of items, where the first item is a element of type http:responseType. The response element is also described in the <a xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" href=\"http://expath.org/spec/http-client#d2e483\">specification</a>. If there is one (or several, in case of multipart) response body, the response bodies are the next items in the sequence." }, "errors" : [  ] } ], "variables" : [  ] }, "http://zorba.io/modules/schema" : { "ns" : "http://zorba.io/modules/schema", "description" : " This module provides function that are related to XML Schema support\n in Zorba.\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Cezar Andrei, Matthias Brantner</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://zorba.io/modules/schema", "prefix" : "schema" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 1, "name" : "is-validated", "qname" : "schema:is-validated", "signature" : "($node as node()) as xs:boolean external", "description" : " This function returns true if the given node has been validated,\n and false otherwise.\n", "summary" : "<p> This function returns true if the given node has been validated,\n and false otherwise.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "node", "type" : "node()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the node item that should be checked for validation</div>" } ], "returns" : { "type" : "xs:boolean", "description" : "true if the given node has been validated, false otherwise." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "schema-type", "qname" : "schema:schema-type", "signature" : "($item as item()) as xs:QName? external", "description" : " This function returns the name of the type of the item passed\n as parameter.\n", "summary" : "<p> This function returns the name of the type of the item passed\n as parameter.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "item", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the item from which the name of the type should be returned.</div>" } ], "returns" : { "type" : "xs:QName?", "description" : "the name of the type (as QName) of the item passed as parameter." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "validate-in-place", "qname" : "schema:validate-in-place", "signature" : "($node as node()) external", "description" : " Updating function that validates the document in place. After the updating\n query is applied the $node will contain the validated content.\n", "summary" : "<p> Updating function that validates the document in place.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : true, "parameters" : [ { "name" : "node", "type" : "node()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the document or element to be validated, otherwise error</div>" } ], "returns" : { "type" : null, "description" : "The result of the function is an empty XDM instance and a pending update list that consists the schema:validate-in-place($node)) primitive." }, "errors" : [  ] } ], "variables" : [  ] }, "http://www.28msec.com/modules/mongodb" : { "ns" : "http://www.28msec.com/modules/mongodb", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This module provides a driver to access a\n <a href=\"http://www.mongodb.org/\">MongoDB</a> database - similar to\n drivers for other high-level languages like e.g.\n <a href=\"http://api.mongodb.org/python/current/\">PyMongo</a>.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Here is a simple example of how we can raise the salary of each\n developer by 10%.\n Starting with an <em>employees</em> collection in MongoDB that contains\n <pre>\n { \"name\" : \"Peter\", \"role\" : \"developer\" , \"salary\" : 80 }\n { \"name\" : \"Paul\",  \"role\" : \"developer\" , \"salary\" : 75 }\n { \"name\" : \"Mary\",  \"role\" : \"manager\"   , \"salary\" : 90 } </pre>\n we can get a connection\n <pre>\n variable $conn := mongo:connect(\"hostname\", 27017, \"db\", \"user\", \"password\");\n </pre>\n run this update\n <pre>\n for $emp in mongo:find($conn, \"employees\")\n where $emp(\"role\") = \"developer\"\n let $salary := $emp(\"salary\")\n return {\n   replace value of json $emp(\"salary\") with $salary * 1.1;\n   mongo:save($conn, \"employees\", $emp)\n };\n </pre>\n and get the names and the current salaries using\n <pre>\n mongo:find($conn, \"employees\", {}, { \"_id\" : false, \"role\" : false }, {}) </pre>\n In this query we have removed the <em>_id</em> and <em>role</em> fields from\n the results and get\n <pre>\n { \"name\" : \"Peter\", \"salary\" : 88   }\n { \"name\" : \"Paul\",  \"salary\" : 82.5 }\n { \"name\" : \"Mary\",  \"salary\" : 90   }\n </pre>\n </p>\n <h2 xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" id=\"determinism\">Important Notice Regarding Function Determinism</h2>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The non side-effecting functions:\n <ul>\n   <li><a href=\"?anchor=connect-0\">connect#0</a></li>\n   <li><a href=\"?anchor=connect-1\">connect#1</a></li>\n   <li><a href=\"?anchor=connect-2\">connect#2</a></li>\n   <li><a href=\"?anchor=connect-5\">connect#5</a></li>\n   <li><a href=\"?anchor=collection-names-1\">collection-names#1</a></li>\n   <li><a href=\"?anchor=count-2\">count#2</a></li>\n   <li><a href=\"?anchor=count-3\">count#3</a></li>\n   <li><a href=\"?anchor=find-2\">find#2</a></li>\n   <li><a href=\"?anchor=find-3\">find#3</a></li>\n   <li><a href=\"?anchor=find-4\">find#4</a></li>\n   <li><a href=\"?anchor=find-5\">find#5</a></li>\n </ul>\n are declared deterministic, which means that their results could be cached\n when invoked multiple times with the same arguments in the same query execution.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">To not use cached results you can use the following alternative functions:\n <ul>\n   <li><a href=\"?anchor=connect-nondeterministic-0\">connect-nondeterministic#0</a></li>\n   <li><a href=\"?anchor=connect-nondeterministic-1\">connect-nondeterministic#1</a></li>\n   <li><a href=\"?anchor=connect-nondeterministic-2\">connect-nondeterministic#2</a></li>\n   <li><a href=\"?anchor=connect-nondeterministic-5\">connect-nondeterministic#5</a></li>\n   <li><a href=\"?anchor=collection-names-nondeterministic-1\">collection-names-nondeterministic#1</a></li>\n   <li><a href=\"?anchor=count-nondeterministic-2\">count-nondeterministic#2</a></li>\n   <li><a href=\"?anchor=count-nondeterministic-3\">count-nondeterministic#3</a></li>\n   <li><a href=\"?anchor=find-nondeterministic-2\">find-nondeterministic#2</a></li>\n   <li><a href=\"?anchor=find-nondeterministic-3\">find-nondeterministic#3</a></li>\n   <li><a href=\"?anchor=find-nondeterministic-4\">find-nondeterministic#4</a></li>\n   <li><a href=\"?anchor=find-nondeterministic-5\">find-nondeterministic#5</a></li>\n </ul>\n which have been declared as being non deterministic.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Three different functions have been defined to run mongo commands:\n <ul>\n   <li><a href=\"?anchor=run-cmd-2\">run-cmd#2</a></li>\n   <li><a href=\"?anchor=run-cmd-nondeterministic-2\">run-cmd-nondeterministic#2</a></li>\n   <li><a href=\"?anchor=run-cmd-deterministic-2\">run-cmd-deterministic#2</a></li>\n </ul>\n If your application depends on the ordering of side-effects from commands issued\n through these functions you should use <a href=\"?anchor=run-cmd-2\">run-cmd#2</a>,\n which has been declared as sequential.\n For non-side-effecting commands you can also use\n <a href=\"?anchor=run-cmd-nondeterministic-2\">run-cmd-nondeterministic#2</a> and\n <a href=\"?anchor=run-cmd-deterministic-2\">run-cmd-deterministic#2</a>.\n The results of commands executed by means of\n <a href=\"?anchor=run-cmd-deterministic-2\">run-cmd-deterministic#2</a> (which is\n declared <i>deterministic</i>) could be cached, whereas the results of\n commands executed by means of\n <a href=\"?anchor=run-cmd-nondeterministic-2\">run-cmd-nondeterministic#2</a> (which is\n declared <i>non-deterministic</i>) are never cached.</p>\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">28msec</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://zorba.io/annotations", "prefix" : "an" }, { "uri" : "http://www.28msec.com/modules/credentials", "prefix" : "credentials" }, { "uri" : "http://www.28msec.com/modules/mongodb/types", "prefix" : "m-schema" }, { "uri" : "http://www.28msec.com/modules/mongodb", "prefix" : "mongo" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 1, "name" : "collection-names-nondeterministic", "qname" : "mongo:collection-names-nondeterministic", "signature" : "($db as xs:anyURI) as xs:string* external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Get a list of all the collection names in this database.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as\n <a href=\"#collection-names-1\">collection-names#1</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Get a list of all the collection names in this database.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "db", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a database connection identifier</div>" } ], "returns" : { "type" : "xs:string*", "description" : "a list of the names of all collection in the given database." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO004 invalid database identifier</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO005 if any mongodb error happens</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "collection-names", "qname" : "mongo:collection-names", "signature" : "($db as xs:anyURI) as xs:string* external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Get a list of all the collection names in this database.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n", "summary" : "<p>  Get a list of all the collection names in this database.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "db", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a database connection identifier</div>" } ], "returns" : { "type" : "xs:string*", "description" : "a list of the names of all collection in the given database." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO004 invalid database identifier</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO005 if any mongodb error happens</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 0, "name" : "connect-nondeterministic", "qname" : "mongo:connect-nondeterministic", "signature" : "() as xs:anyURI", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Connect to this project's default MongoDB database.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as <a href=\"#connect-0\">connect#0</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Connect to this project's default MongoDB database.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:anyURI", "description" : "an identifier for a connection to the MongoDB database." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO002 connection to MongoDB failed</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO003 authentication to the MongoDB database failed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "connect-nondeterministic", "qname" : "mongo:connect-nondeterministic", "signature" : "($connection-config as item()) as xs:anyURI", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Connect to a MongoDB database.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as <a href=\"#connect-1\">connect#1</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Connect to a MongoDB database.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "connection-config", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the connection specification.</div>" } ], "returns" : { "type" : "xs:anyURI", "description" : "an identifier for a connection to the MongoDB database." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO001 if the connection specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO002 connection to MongoDB failed</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO003 authentication to the MongoDB database failed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "connect-nondeterministic", "qname" : "mongo:connect-nondeterministic", "signature" : "($credentials-name as xs:string?, $options as object()) as xs:anyURI", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Connect to a MongoDB database.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as <a href=\"#connect-2\">connect#2</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Connect to a MongoDB database.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "credentials-name", "type" : "xs:string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the credentials to use.</div>" }, { "name" : "options", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the credentials to use.</div>" } ], "returns" : { "type" : "xs:anyURI", "description" : "an identifier for a connection to the MongoDB database." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO001 if the connection specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO002 connection to MongoDB failed</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO003 authentication to the MongoDB database failed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 5, "name" : "connect-nondeterministic", "qname" : "mongo:connect-nondeterministic", "signature" : "($host as xs:string, $port as xs:integer?, $db as xs:string, $user as xs:string?, $pass as xs:string?) as xs:anyURI", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Connect to a MongoDB database.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as <a href=\"#connect-5\">connect#5</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Connect to a MongoDB database.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "host", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the host to connect to</div>" }, { "name" : "port", "type" : "xs:integer", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the port to connect to</div>" }, { "name" : "db", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the database to connect to</div>" }, { "name" : "user", "type" : "xs:string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the user used to authorize access to the db</div>" }, { "name" : "pass", "type" : "xs:string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the password used to authorize access to the db</div>" } ], "returns" : { "type" : "xs:anyURI", "description" : "an identifier for a connection to the MongoDB database." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO002 connection to MongoDB failed</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO003 authentication to the MongoDB database failed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 0, "name" : "connect", "qname" : "mongo:connect", "signature" : "() as xs:anyURI", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Connect to this project's default MongoDB database.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n", "summary" : "<p>  Connect to this project's default MongoDB database.</p>", "annotation_str" : " %an:strictlydeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "strictlydeterministic", "value" : "" } ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:anyURI", "description" : "an identifier for a connection to the MongoDB database." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO002 connection to MongoDB failed</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO003 authentication to the MongoDB database failed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "connect", "qname" : "mongo:connect", "signature" : "($connection-config as item()) as xs:anyURI", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Connect to a MongoDB database.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The $connection-config parameter is used to specify the connection information.\n If a string is used, then the function will interpret it as the name of\n a credential in the MongoDB category.\n If an object is used, then the function will open a connection using it.\n The object structure is the following:\n <ul>\n   <li>host (string; mandatory)</li>\n   <li>port (integer; default: 27017)</li>\n   <li>db (string; mandatory)</li>\n   <li>user (string)</li>\n   <li>pass (string)</li>\n   <li>timeout (decimal; default: 0)</li>\n   <li>pre-digested (boolean; default: false)</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">For example, using stored credential:\n <pre>mongo:connect(\"credentials-name\")</pre>\n <p>For example, specifying the connection information:</p>\n <pre>mongo:connect(\n   {\n     \"host\": \"hostname\",\n     \"port\": 11011,\n     \"db\": \"mydb\",\n     \"user\": \"myuser\"\n     \"password: \"mypass\"\n   })</pre>.\n </p>\n", "summary" : "<p>  Connect to a MongoDB database.</p>", "annotation_str" : " %an:strictlydeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "strictlydeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "connection-config", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the connection specification.</div>" } ], "returns" : { "type" : "xs:anyURI", "description" : "an identifier for a connection to the MongoDB database." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO001 if the connection specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO002 connection to MongoDB failed</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO003 authentication to the MongoDB database failed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "connect", "qname" : "mongo:connect", "signature" : "($credentials-name as xs:string?, $options as object()) as xs:anyURI", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Connect to a MongoDB database.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The $credentials-name parameter is used to specify the connection information.\n If empty a connection will be opened to the project default MongoDB database.\n Otherwise, the function will use it to identify a credential in the MongoDB category.\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The $options object can be used to specify connection options. The following\n fields are supported:\n <ul>\n   <li>timeout (decimal; default: 0)</li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">For example, connecting to the project default MongoDB database:\n <pre>mongo:connect((), {\"timeout\": 10})</pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">For example, specifying the connection information:\n <pre>mongo:connect(\"credentials-name\", {\"timeout\": 10})</pre>\n </p>\n", "summary" : "<p>  Connect to a MongoDB database.</p>", "annotation_str" : " %an:strictlydeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "strictlydeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "credentials-name", "type" : "xs:string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the credentials to use.</div>" }, { "name" : "options", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the credentials to use.</div>" } ], "returns" : { "type" : "xs:anyURI", "description" : "an identifier for a connection to the MongoDB database." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO001 if the connection specification is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO002 connection to MongoDB failed</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO003 authentication to the MongoDB database failed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 5, "name" : "connect", "qname" : "mongo:connect", "signature" : "($host as xs:string, $port as xs:integer?, $db as xs:string, $user as xs:string?, $pass as xs:string?) as xs:anyURI", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Connect to a MongoDB database.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n", "summary" : "<p>  Connect to a MongoDB database.</p>", "annotation_str" : " %an:strictlydeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "strictlydeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "host", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the host to connect to</div>" }, { "name" : "port", "type" : "xs:integer", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the port to connect to</div>" }, { "name" : "db", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the database to connect to</div>" }, { "name" : "user", "type" : "xs:string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the user used to authorize access to the db</div>" }, { "name" : "pass", "type" : "xs:string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the password used to authorize access to the db</div>" } ], "returns" : { "type" : "xs:anyURI", "description" : "an identifier for a connection to the MongoDB database." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO002 connection to MongoDB failed</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO003 authentication to the MongoDB database failed</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "copy", "qname" : "mongo:copy", "signature" : "($db as xs:anyURI, $from-db as xs:string, $to-db as xs:string) as empty-sequence()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Copies a MongoDB database. Be aware, you must call\n this function on the admin database.</p>\n", "summary" : "<p>  Copies a MongoDB database.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "db", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a database connection identifier</div>" }, { "name" : "from-db", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the source database</div>" }, { "name" : "to-db", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the target database</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "the function has side-effects and returns the empty sequence." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO004 invalid database identifier</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO005 if copy operation fails</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO006 if any mongodb error happens</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "count-nondeterministic", "qname" : "mongo:count-nondeterministic", "signature" : "($db as xs:anyURI, $coll as xs:string) as xs:integer external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Counts the number of documents in the given collection.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as <a href=\"#count-2\">count#2</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Counts the number of documents in the given collection.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "db", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a database connection identifier</div>" }, { "name" : "coll", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the collection</div>" } ], "returns" : { "type" : "xs:integer", "description" : "the said count" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO005 if any mongodb error happens</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "count-nondeterministic", "qname" : "mongo:count-nondeterministic", "signature" : "($db as xs:anyURI, $coll as xs:string, $query as object()) as xs:integer external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Counts the number of documents satisfying the query in the given collection.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as <a href=\"#count-3\">count#3</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Counts the number of documents satisfying the query in the given collection.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "db", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a database connection identifier</div>" }, { "name" : "coll", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the collection</div>" }, { "name" : "query", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the query specifying which objects to count</div>" } ], "returns" : { "type" : "xs:integer", "description" : "the said count" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO005 if any mongodb error happens</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "count", "qname" : "mongo:count", "signature" : "($db as xs:anyURI, $coll as xs:string) as xs:integer external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Counts the number of documents in the given collection.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n", "summary" : "<p>  Counts the number of documents in the given collection.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "db", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a database connection identifier</div>" }, { "name" : "coll", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the collection</div>" } ], "returns" : { "type" : "xs:integer", "description" : "the said count" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO005 if any mongodb error happens</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "count", "qname" : "mongo:count", "signature" : "($db as xs:anyURI, $coll as xs:string, $query as object()) as xs:integer external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Counts the number of documents satisfying the query in the given collection.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n", "summary" : "<p>  Counts the number of documents satisfying the query in the given collection.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "db", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a database connection identifier</div>" }, { "name" : "coll", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the collection</div>" }, { "name" : "query", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the query specifying which objects to count</div>" } ], "returns" : { "type" : "xs:integer", "description" : "the said count" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO005 if any mongodb error happens</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "disconnect", "qname" : "mongo:disconnect", "signature" : "($db as xs:anyURI) as empty-sequence() external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Disconnect from a MongoDB database.</p>\n", "summary" : "<p>  Disconnect from a MongoDB database.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "db", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a database connection identifier</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "the function has side-effects and returns the empty sequence." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO004 invalid database identifier</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO005 if any mongodb error happens</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "drop-collection", "qname" : "mongo:drop-collection", "signature" : "($db as xs:anyURI, $coll as xs:string) as empty-sequence() external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Drop a collection.</p>\n", "summary" : "<p>  Drop a collection.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "db", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a database connection identifier</div>" }, { "name" : "coll", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the collection</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "the function has side-effects and returns the empty sequence." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO004 invalid database identifier</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO005 if any mongodb error happens</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "find-nondeterministic", "qname" : "mongo:find-nondeterministic", "signature" : "($db as xs:anyURI, $coll as xs:string) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns all objects of the given collection.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as <a href=\"#find-2\">find#2</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Returns all objects of the given collection.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "db", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a database connection identifier</div>" }, { "name" : "coll", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the collection</div>" } ], "returns" : { "type" : "object()*", "description" : "all objects of the given collection" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO004 invalid database identifier</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO005 if any mongodb error happens</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "find-nondeterministic", "qname" : "mongo:find-nondeterministic", "signature" : "($db as xs:anyURI, $coll as xs:string, $query as object()) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Performs a query operation on the given collection and\n returns all matches.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as <a href=\"#find-3\">find#3</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Performs a query operation on the given collection and\n returns all matches.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "db", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a database connection identifier</div>" }, { "name" : "coll", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the collection</div>" }, { "name" : "query", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the query operation to perform</div>" } ], "returns" : { "type" : "object()*", "description" : "all matches returned by the given query operation" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO004 invalid database identifier</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO005 if any mongodb error happens</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO006 if the given query could not be converted to BSON</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 4, "name" : "find-nondeterministic", "qname" : "mongo:find-nondeterministic", "signature" : "($db as xs:anyURI, $coll as xs:string, $query as object(), $options as object()) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Performs a query operation on the given collection and\n returns all matches.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as <a href=\"#find-4\">find#4</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Performs a query operation on the given collection and\n returns all matches.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "db", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a database connection identifier</div>" }, { "name" : "coll", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the collection</div>" }, { "name" : "query", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the query operation to perform</div>" }, { "name" : "options", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the options for this operation (see find#5 for available options)</div>" } ], "returns" : { "type" : "object()*", "description" : "all matches returned by the given query operation" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO004 invalid database identifier</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO005 if any mongodb error happens</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO006 if the given query could not be converted to BSON</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 5, "name" : "find-nondeterministic", "qname" : "mongo:find-nondeterministic", "signature" : "($db as xs:anyURI, $coll as xs:string, $query as object(), $projection as object(), $options as object()) as object()* external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Performs a query operation on the given collection and\n returns all matches.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function has the same semantics as <a href=\"#find-5\">find#5</a>,\n but is declared as being non deterministic and thus should only be used when\n result caching is not desired.</p>\n", "summary" : "<p>  Performs a query operation on the given collection and\n returns all matches.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "db", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a database connection identifier</div>" }, { "name" : "coll", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the collection</div>" }, { "name" : "query", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the query operation to perform</div>" }, { "name" : "projection", "type" : "object()", "occurrence" : null, "description" : "" }, { "name" : "options", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the options for this operation</div>" } ], "returns" : { "type" : "object()*", "description" : "all matches returned by the given query operation" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO004 invalid database identifier</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO005 if any mongodb error happens</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO006 if the given query or projection could not be converted to BSON</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "find", "qname" : "mongo:find", "signature" : "($db as xs:anyURI, $coll as xs:string) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns all objects of the given collection.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n", "summary" : "<p>  Returns all objects of the given collection.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "db", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a database connection identifier</div>" }, { "name" : "coll", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the collection</div>" } ], "returns" : { "type" : "object()*", "description" : "all objects of the given collection" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO004 invalid database identifier</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO005 if any mongodb error happens</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "find", "qname" : "mongo:find", "signature" : "($db as xs:anyURI, $coll as xs:string, $query as object()) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Performs a query operation on the given collection and\n returns all matches.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n", "summary" : "<p>  Performs a query operation on the given collection and\n returns all matches.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "db", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a database connection identifier</div>" }, { "name" : "coll", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the collection</div>" }, { "name" : "query", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the query operation to perform</div>" } ], "returns" : { "type" : "object()*", "description" : "all matches returned by the given query operation" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO004 invalid database identifier</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO005 if any mongodb error happens</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO006 if the given query could not be converted to BSON</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 4, "name" : "find", "qname" : "mongo:find", "signature" : "($db as xs:anyURI, $coll as xs:string, $query as object(), $options as object()) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Performs a query operation on the given collection and\n returns all matches.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n", "summary" : "<p>  Performs a query operation on the given collection and\n returns all matches.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "db", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a database connection identifier</div>" }, { "name" : "coll", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the collection</div>" }, { "name" : "query", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the query operation to perform</div>" }, { "name" : "options", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the options for this operation (see find#5 for available options)</div>" } ], "returns" : { "type" : "object()*", "description" : "all matches returned by the given query operation" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO004 invalid database identifier</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO005 if any mongodb error happens</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO006 if the given query could not be converted to BSON</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 5, "name" : "find", "qname" : "mongo:find", "signature" : "($db as xs:anyURI, $coll as xs:string, $query as object(), $projection as object(), $options as object()) as object()* external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Performs a query operation on the given collection and\n returns all matches.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is declared as deterministic and should be used whenever result\n caching is acceptable.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Available options:\n <ul>\n   <li>to-return: the maximum number of objects to return (0 = unlimited)</li>\n   <li>to-skip: start with the n-th object</li>\n   <li>batch-size: the number of objects to return in one batch</li>\n   <li>slave-ok: allow this query to be run against a replica secondary</li>\n   <li>await-data: the server will block for some extra time before returning,\n   waiting for more data to return</li>\n   <li>partial-results: return partial results if some shards are down instead\n   of returning an error</li>\n </ul>\n </p>\n", "summary" : "<p>  Performs a query operation on the given collection and\n returns all matches.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "db", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a database connection identifier</div>" }, { "name" : "coll", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the collection</div>" }, { "name" : "query", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the query operation to perform</div>" }, { "name" : "projection", "type" : "object()", "occurrence" : null, "description" : "" }, { "name" : "options", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the options for this operation</div>" } ], "returns" : { "type" : "object()*", "description" : "all matches returned by the given query operation" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO004 invalid database identifier</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO005 if any mongodb error happens</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO006 if the given query or projection could not be converted to BSON</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "is-connected", "qname" : "mongo:is-connected", "signature" : "($db as xs:anyURI) as xs:boolean external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Checks if the given identifiers is valid and the corresponding\n connection is open.</p>\n", "summary" : "<p>  Checks if the given identifiers is valid and the corresponding\n connection is open.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "db", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a database connection identifier</div>" } ], "returns" : { "type" : "xs:boolean", "description" : "true if the given connection identifier is valid and the corresponding connection is open, false otherwise." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO004 invalid database identifier</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO005 if any mongodb error happens</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "remove", "qname" : "mongo:remove", "signature" : "($db as xs:anyURI, $coll as xs:string, $remove as object()) as empty-sequence()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Performs a remove operation on the given collection.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The operation will be checked and an error is raised if\n one of them fails.</p>\n", "summary" : "<p>  Performs a remove operation on the given collection.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "db", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a database connection identifier</div>" }, { "name" : "coll", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the collection</div>" }, { "name" : "remove", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the remove command to be performed</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "the function has side-effects and returns the empty sequence." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO004 invalid database identifier</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO005 if any mongodb error happens</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO006 if the given document could not be converted to BSON</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 4, "name" : "remove", "qname" : "mongo:remove", "signature" : "($db as xs:anyURI, $coll as xs:string, $remove as object(), $options as object()) as empty-sequence() external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Performs a remove operation on the given collection.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n <ul>\n   <li>safe: If to true, the operation will wait for a response from\n    the database and an error is raised if the operation fails.\n    Otherwise, the operation will not wait for a response.</li>\n  <li>just-one: true if the operation should stop after a single match\n    has been found and deleted</li>\n </ul>\n </p>\n", "summary" : "<p>  Performs a remove operation on the given collection.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "db", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a database connection identifier</div>" }, { "name" : "coll", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the collection</div>" }, { "name" : "remove", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the remove command to be performed</div>" }, { "name" : "options", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the options for this operation</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "the function has side-effects and returns the empty sequence." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO004 invalid database identifier</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO005 if any mongodb error happens</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO006 if the given document could not be converted to BSON</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "run-cmd-deterministic", "qname" : "mongo:run-cmd-deterministic", "signature" : "($db as xs:anyURI, $cmd as object()) as object() external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Executes a\n <a href=\"http://docs.mongodb.org/manual/reference/commands/\">database command</a>.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is marked as deterministic and should be used whenever the\n specified command has no side-effects and result caching is desired.</p>\n", "summary" : "<p>  Executes a\n  database command .</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "db", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a database connection identifier</div>" }, { "name" : "cmd", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the database command to execute</div>" } ], "returns" : { "type" : "object()", "description" : "The result object. Typically has { ok : ..., errmsg : ... } fields set." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO004 invalid database identifier</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO006 if any mongodb error happens</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "run-cmd-nondeterministic", "qname" : "mongo:run-cmd-nondeterministic", "signature" : "($db as xs:anyURI, $cmd as object()) as object() external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Executes a\n <a href=\"http://docs.mongodb.org/manual/reference/commands/\">database command</a>.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is marked as non-deterministic and should be used whenever the\n specified command has no side-effects and result caching is undesired.</p>\n", "summary" : "<p>  Executes a\n  database command .</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "db", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a database connection identifier</div>" }, { "name" : "cmd", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the database command to execute</div>" } ], "returns" : { "type" : "object()", "description" : "The result object. Typically has { ok : ..., errmsg : ... } fields set." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO004 invalid database identifier</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO006 if any mongodb error happens</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "run-cmd", "qname" : "mongo:run-cmd", "signature" : "($db as xs:anyURI, $cmd as object()) as object() external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Executes a\n <a href=\"http://docs.mongodb.org/manual/reference/commands/\">database command</a>.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is marked as sequential and should be used whenever the\n specified command has side-effects.</p>\n", "summary" : "<p>  Executes a\n  database command .</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "db", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a database connection identifier</div>" }, { "name" : "cmd", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the database command to execute</div>" } ], "returns" : { "type" : "object()", "description" : "The result object. Typically has { ok : ..., errmsg : ... } fields set." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO004 invalid database identifier</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO006 if any mongodb error happens</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "save", "qname" : "mongo:save", "signature" : "($db as xs:anyURI, $coll as xs:string, $doc as object()) as empty-sequence()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Save a sequence of documents in the given collection.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If a document to be save already has an \"_id\" field, then an\n upsert operation is performed an any existing document with that\n id will be overwritten. Otherwise, an insert operation is performed\n and the \"_id\" generated for each document will be returned.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Each safe operation will be checked and an error is raised if\n one of them fails.</p>\n", "summary" : "<p>  Save a sequence of documents in the given collection.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "db", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a database connection identifier</div>" }, { "name" : "coll", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the collection</div>" }, { "name" : "doc", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the document to be saved or upserted</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "the documents that have been inserted with \"_id\" fields." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO004 invalid database identifier</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO005 if any mongodb error happens</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO006 if the given document could not be converted to BSON</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 4, "name" : "save", "qname" : "mongo:save", "signature" : "($db as xs:anyURI, $coll as xs:string, $doc as object(), $options as object()) as m-schema:oid? external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Save a sequence of documents in the given collection.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If a document to be saved already has an \"_id\" field, then an\n upsert operation is performed and any existing document with that\n id will be overwritten. Otherwise, an insert operation is performed.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If the manipulate option is set to true, an \"_id\" field will be\n added to the document. The new id will be returned. Otherwise,\n the \"_id\" field will be added by the server.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If the safe options is set to true, each operation will wait for a\n response from the database and an error is raised if the operation\n fails. Otherwise, the operation will not wait for a response.</p>\n", "summary" : "<p>  Save a sequence of documents in the given collection.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "db", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a database connection identifier</div>" }, { "name" : "coll", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the collection</div>" }, { "name" : "doc", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the document to be saved or upserted</div>" }, { "name" : "options", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the options for this operation</div>" } ], "returns" : { "type" : "m-schema:oid?", "description" : "a generated OID if the manipulate option was set to true, the empty sequence otherwise." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO004 invalid database identifier</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO005 if any mongodb error happens</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO006 if the given document could not be converted to BSON</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 4, "name" : "update", "qname" : "mongo:update", "signature" : "($db as xs:anyURI, $coll as xs:string, $query as object(), $update as object()) as empty-sequence()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Performs an update command on the given collection.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The operation will be checked and an error is raised if\n one of them fails. Also, this function only modifies one\n document matching the query and does not do any upserts.</p>\n", "summary" : "<p>  Performs an update command on the given collection.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "db", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a database connection identifier</div>" }, { "name" : "coll", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the collection</div>" }, { "name" : "query", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the query to select the objects that are updated</div>" }, { "name" : "update", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the update specification to be performed</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "the function has side-effects and returns the empty sequence." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO004 invalid database identifier</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO005 if any mongodb error happens</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO006 if the given objects could not be converted to BSON</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 5, "name" : "update", "qname" : "mongo:update", "signature" : "($db as xs:anyURI, $coll as xs:string, $query as object(), $update as object(), $options as object()) as empty-sequence() external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Performs an update operation on the given collection.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n <ul>\n   <li>safe: If to true, the operation will wait for a response from\n    the database and an error is raised if the operation fails.\n    Otherwise, the operation will not wait for a response.</li>\n  <li>multi: indicates if all documents matching criteria should be updated\n  rather than just one.</li>\n  <li>upsert: if this should be an \"upsert\" operation; that is,\n  if the record(s) do not exist, insert one. Upsert only inserts a single document.</li>\n </ul>\n </p>\n", "summary" : "<p>  Performs an update operation on the given collection.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "db", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a database connection identifier</div>" }, { "name" : "coll", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the collection</div>" }, { "name" : "query", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the query to select the objects that are updated</div>" }, { "name" : "update", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the update specification to be performed</div>" }, { "name" : "options", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the options for this operation</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "the function has side-effects and returns the empty sequence." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO004 invalid database identifier</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO005 if any mongodb error happens</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">mongo:MONGO006 if the given objects could not be converted to BSON</xqdoc:error>" ] } ], "variables" : [  ] }, "http://jsoniq.org/function-library" : { "ns" : "http://jsoniq.org/function-library", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This module provides extensions to the JSONiq core function library.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The module is always imported so you do not need to import it explicitly.\n Also, you do not need to fully qualify a function to invoke it.</p>\n", "sees" : [ "<xqdoc:see xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">http://jsoniq.org/</xqdoc:see>" ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Ghislain Fourny</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://jsoniq.org/functions", "prefix" : "jn" }, { "uri" : "http://jsoniq.org/function-library", "prefix" : "libjn" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 1, "name" : "accumulate", "qname" : "libjn:accumulate", "signature" : "($items as item()*) as object()", "description" : " This function dynamically builds an object, like the {||} syntax, except that\n it does not throw an error upon pair collision. Instead, it accumulates them\n into an array, if more than one.\n", "summary" : "<p> This function dynamically builds an object, like the {||} syntax, except that\n it does not throw an error upon pair collision.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "items", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> A sequence of items, the objects of which are going to be accumulated into a single object.</div>" } ], "returns" : { "type" : "object()", "description" : "The accumulated object." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "descendant-arrays", "qname" : "libjn:descendant-arrays", "signature" : "($items as item()*) as array()*", "description" : " This function returns all arrays contained at any depth within a sequence of items.\n", "summary" : "<p> This function returns all arrays contained at any depth within a sequence of items.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "items", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> A sequence of items.</div>" } ], "returns" : { "type" : "array()*", "description" : "The descendant arrays of the input sequence." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "descendant-objects", "qname" : "libjn:descendant-objects", "signature" : "($items as item()*) as object()*", "description" : " This function returns all objects contained at any depth within a sequence of items.\n", "summary" : "<p> This function returns all objects contained at any depth within a sequence of items.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "items", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> A sequence of items.</div>" } ], "returns" : { "type" : "object()*", "description" : "The descendant objects of the input sequence." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "descendant-pairs-priv", "qname" : "libjn:descendant-pairs-priv", "signature" : "($i as item()) as object()*", "description" : " Helper function for libjn:descendant-pairs()\n", "summary" : "<p> Helper function for libjn:descendant-pairs()\n</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "i", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> An item</div>" } ], "returns" : { "type" : "object()*", "description" : "The descendant pairs of the item" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "descendant-pairs", "qname" : "libjn:descendant-pairs", "signature" : "($items as item()*) as object()*", "description" : " This function returns all pairs contained at any depth within an sequence of items.\n", "summary" : "<p> This function returns all pairs contained at any depth within an sequence of items.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "items", "type" : "item()", "occurrence" : "*", "description" : "" } ], "returns" : { "type" : "object()*", "description" : "All direct and indirect descendant pairs." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "intersect", "qname" : "libjn:intersect", "signature" : "($items as item()*) as object()", "description" : " This function returns the intersection of the objects contained in the\n given sequence of items, aggregating values corresponding to the same key\n into an array.\n", "summary" : "<p> This function returns the intersection of the objects contained in the\n given sequence of items, aggregating values corresponding to the same key\n into an array.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "items", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> A sequence of items.</div>" } ], "returns" : { "type" : "object()", "description" : "The insersection of the objects contained in $items." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "values", "qname" : "libjn:values", "signature" : "($items as item()*) as item()*", "description" : " This functions returns all values of all objects contained in a sequence of items.\n", "summary" : "<p> This functions returns all values of all objects contained in a sequence of items.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "items", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> A sequence of items.</div>" } ], "returns" : { "type" : "item()*", "description" : "The values inside the objects of the sequence." }, "errors" : [  ] } ], "variables" : [  ] }, "http://zorba.io/modules/node-position" : { "ns" : "http://zorba.io/modules/node-position", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This module provides a function (np:node-position) that, given a node,\n returns positional information about the node in the form of an xs:anyURI\n item. The module also defines functions that use such positional information\n to determine: (1) positional relationships between two nodes (e.g. if one\n is the ancestor of another) and (2) positional properties of a single node\n (e.g. its level in the tree).</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Within this module, the term \"node position\" will be used to refer to an\n xs:anyURI item that is returned by the np:node-position function.</p>\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Federico Cavalieri, Markos Zaharioudakis</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://zorba.io/modules/node-position", "prefix" : "np" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 2, "name" : "ancestor-of", "qname" : "np:ancestor-of", "signature" : "($pos1 as xs:anyURI, $pos2 as xs:anyURI) as xs:boolean external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Determines whether the node position given as second argument is\n an ancestor of the node position given as first argument.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If the two positions were obtained within the same snapshot S, then the\n result of the function applies to the corresponding nodes as well, that\n is, within snapshot S, the second node is an ancestor of the first.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Otherwise, the result of the function does not imply anything about the\n positional relationship of the two nodes.</p>\n", "summary" : "<p>  Determines whether the node position given as second argument is\n an ancestor of the node position given as first argument.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "pos1", "type" : "xs:anyURI", "occurrence" : null, "description" : "" }, { "name" : "pos2", "type" : "xs:anyURI", "occurrence" : null, "description" : "" } ], "returns" : { "type" : "xs:boolean", "description" : "true if the node position $n-pos2 is an ancestor of the node position $n-pos1; false otherwise." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZAPI0028 if one of the given URI is not a valid node position computed by the <tt>np:node-position</tt> function.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "attribute-of", "qname" : "np:attribute-of", "signature" : "($n-pos1 as xs:anyURI, $n-pos2 as xs:anyURI) as xs:boolean external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Determines whether the node position given as second argument is\n an attribute of the node position given as first argument.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If the two positions were obtained within the same snapshot S, then the\n result of the function applies to the corresponding nodes as well, that\n is, within snapshot S, the second node is an attribute of the first.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Otherwise, the result of the function does not imply anything about the\n positional relationship of the two nodes.</p>\n", "summary" : "<p>  Determines whether the node position given as second argument is\n an attribute of the node position given as first argument.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "n-pos1", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the potential parent node position</div>" }, { "name" : "n-pos2", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the potential attribute node position</div>" } ], "returns" : { "type" : "xs:boolean", "description" : "true if the node position $n-pos2 is an attribute of the node position $n-pos1; false otherwise." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZAPI0028 if one of the given URI is not a valid node position computed by the <tt>np:node-position</tt> function.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "child-of", "qname" : "np:child-of", "signature" : "($n-pos1 as xs:anyURI, $n-pos2 as xs:anyURI) as xs:boolean external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Determines whether the node position given as second argument is\n a child of the node position given as first argument.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If the two positions were obtained within the same snapshot S, then the\n result of the function applies to the corresponding nodes as well, that\n is, within snapshot S, the second node is a child of the first.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Otherwise, the result of the function does not imply anything about the\n positional relationship of the two nodes.</p>\n", "summary" : "<p>  Determines whether the node position given as second argument is\n a child of the node position given as first argument.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "n-pos1", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the potential parent node position</div>" }, { "name" : "n-pos2", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the potential child node position</div>" } ], "returns" : { "type" : "xs:boolean", "description" : "true if the node position $n-pos2 is a child of the node position $n-pos1; false otherwise." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZAPI0028 if one of the given URI is not a valid node position computed by the <tt>np:node-position</tt> function.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "descendant-of", "qname" : "np:descendant-of", "signature" : "($n-pos1 as xs:anyURI, $n-pos2 as xs:anyURI) as xs:boolean external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Determines whether the node position given as second argument is\n a descendant of the node position given as first argument.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If the two positions were obtained within the same snapshot S, then the\n result of the function applies to the corresponding nodes as well, that\n is, within snapshot S, the second node is a descendant of the first.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Otherwise, the result of the function does not imply anything about the\n positional relationship of the two nodes.</p>\n", "summary" : "<p>  Determines whether the node position given as second argument is\n a descendant of the node position given as first argument.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "n-pos1", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the potential ancestor node position</div>" }, { "name" : "n-pos2", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the potential descendant node position</div>" } ], "returns" : { "type" : "xs:boolean", "description" : "true if the node position $n-pos2 is a descendant of the node position $n-pos1; false otherwise." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZAPI0028 if one of the given URI is not a valid node position computed by the <tt>np:node-position</tt> function.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "following-in-document-order-of", "qname" : "np:following-in-document-order-of", "signature" : "($n-pos1 as xs:anyURI, $n-pos2 as xs:anyURI) as xs:boolean external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Determines whether the node position given as second argument is\n following in document order the node position given as first argument.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If the two positions were obtained within the same snapshot S, then the\n result of the function applies to the corresponding nodes as well, that\n is, within snapshot S, the second node is following in document order the\n first.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Otherwise, the result of the function does not imply anything about\n the positional relationship of the two nodes.</p>\n", "summary" : "<p>  Determines whether the node position given as second argument is\n following in document order the node position given as first argument.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "n-pos1", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the potential preceding node position</div>" }, { "name" : "n-pos2", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the potential following node position</div>" } ], "returns" : { "type" : "xs:boolean", "description" : "true if the node position $n-pos2 is following in document order the node position $n-pos1; false otherwise." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZAPI0028 if one of the given URI is not a valid node position computed by the <tt>np:node-position</tt> function.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "following-of", "qname" : "np:following-of", "signature" : "($n-pos1 as xs:anyURI, $n-pos2 as xs:anyURI) as xs:boolean external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Determines whether the node position given as second argument is\n following the node position given as first argument.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If the two positions were obtained within the same snapshot S, then the\n result of the function applies to the corresponding nodes as well, that\n is, within snapshot S, the second node is following the first.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Otherwise, the result of the function does not imply anything about the\n positional relationship of the two nodes.</p>\n", "summary" : "<p>  Determines whether the node position given as second argument is\n following the node position given as first argument.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "n-pos1", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the potential preceding node position</div>" }, { "name" : "n-pos2", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the potential following node position</div>" } ], "returns" : { "type" : "xs:boolean", "description" : "true if node positions $n-pos1 and $n-pos2 belong to the same XML tree and $n-pos2 is following the node position $n-pos1; false otherwise." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZAPI0028 if one of the given URI is not a valid node position computed by the <tt>np:node-position</tt> function.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "following-sibling-of", "qname" : "np:following-sibling-of", "signature" : "($n-pos1 as xs:anyURI, $n-pos2 as xs:anyURI) as xs:boolean external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Determines whether the node position given as second argument is\n a following-sibling of the node position given as first argument.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If the two positions were obtained within the same snapshot S, then the\n result of the function applies to the corresponding nodes as well, that\n is, within snapshot S, the second node is a following-sibling of the first.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Otherwise, the result of the function does not imply anything about the\n positional relationship of the two nodes.</p>\n", "summary" : "<p>  Determines whether the node position given as second argument is\n a following-sibling of the node position given as first argument.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "n-pos1", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the potential preceding-sibling node position</div>" }, { "name" : "n-pos2", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the potential following-sibling node position</div>" } ], "returns" : { "type" : "xs:boolean", "description" : "true if the node position $n-pos2 is a following-sibling of the node position $n-pos1; false otherwise." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZAPI0028 if one of the given URI is not a valid node position computed by the <tt>np:node-position</tt> function.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "in-collection", "qname" : "np:in-collection", "signature" : "($n-pos as xs:anyURI) as xs:boolean external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Determines whether a node position belongs to a collection.</p>\n", "summary" : "<p>  Determines whether a node position belongs to a collection.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "n-pos", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the node position</div>" } ], "returns" : { "type" : "xs:boolean", "description" : "true if the node position $n-pos belongs to a collection; false otherwise." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZAPI0028 if the given URI is not a valid node position computed by the <tt>np:node-position</tt> function.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "in-same-collection-of", "qname" : "np:in-same-collection-of", "signature" : "($n-pos1 as xs:anyURI, $n-pos2 as xs:anyURI) as xs:boolean external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Determines whether two node positions belong to the same collection.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If the two positions were obtained within the same snapshot S, then the\n result of the function applies to the corresponding nodes as well, that\n is, within snapshot S, the two nodes belong to the same collection.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Otherwise, the result of the function does not imply anything about\n the positional relationship of the two nodes.</p>\n", "summary" : "<p>  Determines whether two node positions belong to the same collection.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "n-pos1", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a node position</div>" }, { "name" : "n-pos2", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a node position</div>" } ], "returns" : { "type" : "xs:boolean", "description" : "true if the two nodes whose node positions are $n-pos1 and $n-pos2 belong to the same collection." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZAPI0028 if one of the given URI is not a valid node position computed by the <tt>np:node-position</tt> function.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "in-same-tree-of", "qname" : "np:in-same-tree-of", "signature" : "($n-pos1 as xs:anyURI, $n-pos2 as xs:anyURI) as xs:boolean external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Determines whether two node positions belong to the same tree.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If the two positions were obtained within the same snapshot S, then the\n result of the function applies to the corresponding nodes as well, that\n is, within snapshot S, the two nodes belong to the same tree.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Otherwise, the result of the function does not imply anything about\n the positional relationship of the two nodes.</p>\n", "summary" : "<p>  Determines whether two node positions belong to the same tree.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "n-pos1", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a node position</div>" }, { "name" : "n-pos2", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a node position</div>" } ], "returns" : { "type" : "xs:boolean", "description" : "true if the two nodes whose node positions are $n-pos1 and $n-pos2 belong to the same tree." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZAPI0028 if one of the given URI is not a valid node position computed by the <tt>np:node-position</tt> function.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "in-subtree-of", "qname" : "np:in-subtree-of", "signature" : "($n-pos1 as xs:anyURI, $n-pos2 as xs:anyURI) as xs:boolean external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Determines whether the node position given as second argument belongs\n to the subtree rooted at the node position given as first argument.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If the two positions were obtained within the same snapshot S, then the\n result of the function applies to the corresponding nodes as well, that\n is, within snapshot S, the second node belongs to the subtree rooted at the\n first. Otherwise, the result of the function does not imply anything about\n the positional relationship of the two nodes.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function differs from np:descendant-of in the way it treats attribute\n nodes. np:descendant-of follows the XQuery/XPath specification for the\n descendant axis, and as a result, it does not consider attributes as\n descendants of any nodes; it will always return false if $n-pos2 was\n obtained from an attribute node.In contrast, np:in-subtree-of will return\n true if $n-pos2 was obtained from an attribute node that appeared in the\n subtree of the node that $n-pos1 was obtained from.</p>\n", "summary" : "<p>  Determines whether the node position given as second argument belongs\n to the subtree rooted at the node position given as first argument.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "n-pos1", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the potential subtree root node position</div>" }, { "name" : "n-pos2", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the potential node in the subtree node position</div>" } ], "returns" : { "type" : "xs:boolean", "description" : "true if the node position $n-pos2 belongs to the subtree rooted at the node position $n-pos1; false otherwise." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZAPI0028 if one of the given URI is not a valid node position computed by the <tt>np:node-position</tt> function.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "is-attribute", "qname" : "np:is-attribute", "signature" : "($n-pos1 as xs:anyURI) as xs:boolean external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Determines whether a node position corresponds to an attribute node.</p>\n", "summary" : "<p>  Determines whether a node position corresponds to an attribute node.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "n-pos1", "type" : "xs:anyURI", "occurrence" : null, "description" : "" } ], "returns" : { "type" : "xs:boolean", "description" : "true if the node position $n-pos corresponds to an attribute; false otherwise." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZAPI0028 if the given URI is not a valid node position computed by the <tt>np:node-position</tt> function.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "is-comment", "qname" : "np:is-comment", "signature" : "($n-pos1 as xs:anyURI) as xs:boolean external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Determines whether a node position corresponds to a comment node.</p>\n", "summary" : "<p>  Determines whether a node position corresponds to a comment node.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "n-pos1", "type" : "xs:anyURI", "occurrence" : null, "description" : "" } ], "returns" : { "type" : "xs:boolean", "description" : "true if the node position $n-pos corresponds to an comment; false otherwise." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZAPI0028 if the given URI is not a valid node position computed by the <tt>np:node-position</tt> function.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "is-document", "qname" : "np:is-document", "signature" : "($n-pos1 as xs:anyURI) as xs:boolean external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Determines whether a node position corresponds to a document node.</p>\n", "summary" : "<p>  Determines whether a node position corresponds to a document node.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "n-pos1", "type" : "xs:anyURI", "occurrence" : null, "description" : "" } ], "returns" : { "type" : "xs:boolean", "description" : "true if the node position $n-pos corresponds to a document; false otherwise." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZAPI0028 if the given URI is not a valid node position computed by the <tt>np:node-position</tt> function.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "is-element", "qname" : "np:is-element", "signature" : "($n-pos1 as xs:anyURI) as xs:boolean external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Determines whether a node position corresponds to an element node.</p>\n", "summary" : "<p>  Determines whether a node position corresponds to an element node.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "n-pos1", "type" : "xs:anyURI", "occurrence" : null, "description" : "" } ], "returns" : { "type" : "xs:boolean", "description" : "true if the node position $n-pos corresponds to an element; false otherwise." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZAPI0028 if the given URI is not a valid node position computed by the <tt>np:node-position</tt> function.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "is-processing-instruction", "qname" : "np:is-processing-instruction", "signature" : "($n-pos1 as xs:anyURI) as xs:boolean external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Determines whether a node position corresponds to an processing-instruction\n node.</p>\n", "summary" : "<p>  Determines whether a node position corresponds to an processing-instruction\n node.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "n-pos1", "type" : "xs:anyURI", "occurrence" : null, "description" : "" } ], "returns" : { "type" : "xs:boolean", "description" : "true if the node position $n-pos corresponds to a processing instruction; false otherwise." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZAPI0028 if the given URI is not a valid node position computed by the <tt>np:node-position</tt> function.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "is-text", "qname" : "np:is-text", "signature" : "($n-pos1 as xs:anyURI) as xs:boolean external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Determines whether a node position corresponds to a text node.</p>\n", "summary" : "<p>  Determines whether a node position corresponds to a text node.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "n-pos1", "type" : "xs:anyURI", "occurrence" : null, "description" : "" } ], "returns" : { "type" : "xs:boolean", "description" : "true if the node position $n-pos corresponds to a text; false otherwise." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZAPI0028 if the given URI is not a valid node position computed by the <tt>np:node-position</tt> function.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "level", "qname" : "np:level", "signature" : "($n-pos as xs:anyURI) as xs:integer external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Computes the level of a node position in its tree.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Note: The root node of a tree is at level one.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The result of the function applies to the corresponding node as well,\n that is, within the snapshot in which the position was computed, the node\n level is the returned one.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The result of the function does not imply anything about the\n node level in other snapshots.</p>\n", "summary" : "<p>  Computes the level of a node position in its tree.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "n-pos", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the node position of the node whose level should be determined.</div>" } ], "returns" : { "type" : "xs:integer", "description" : "the level in the tree of the node position $n-pos as xs:integer." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZAPI0028 if the given URI is not a valid node position computed by the <tt>np:node-position</tt> function.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "node-position", "qname" : "np:node-position", "signature" : "($arg as node()) as xs:anyURI external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Return a URI item containing positional information for a given node.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Within a snapshot, each has a different positional URI. However,\n different nodes in different snapshots might have the same URI.</p>\n", "summary" : "<p>  Return a URI item containing positional information for a given node.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "arg", "type" : "node()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the node for which the positional information URI should be computed</div>" } ], "returns" : { "type" : "xs:anyURI", "description" : "the opaque positional information URI of the node." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "parent-of", "qname" : "np:parent-of", "signature" : "($n-pos1 as xs:anyURI, $n-pos2 as xs:anyURI) as xs:boolean external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Determines whether the node position given as second argument is\n the parent of the node position given as first argument.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If the two positions were obtained within the same snapshot S, then the\n result of the function applies to the corresponding nodes as well, that\n is, within snapshot S, the second node is the parent of the first.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Otherwise, the result of the function does not imply anything about the\n positional relationship of the two nodes.</p>\n", "summary" : "<p>  Determines whether the node position given as second argument is\n the parent of the node position given as first argument.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "n-pos1", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the potential child node position</div>" }, { "name" : "n-pos2", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the potential parent node position</div>" } ], "returns" : { "type" : "xs:boolean", "description" : "true if the node position $n-pos2 is the parent of the node position $n-pos1; false otherwise." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZAPI0028 if one of the given URI is not a valid node position computed by the <tt>np:node-position</tt> function.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "preceding-in-document-order-of", "qname" : "np:preceding-in-document-order-of", "signature" : "($n-pos1 as xs:anyURI, $n-pos2 as xs:anyURI) as xs:boolean external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Determines whether the node position given as second argument is\n preceding in document order the node position given as first argument.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If the two positions were obtained within the same snapshot S, then the\n result of the function applies to the corresponding nodes as well, that\n is, within snapshot S, the second node is preceding in document order the\n first.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Otherwise, the result of the function does not imply anything about\n the positional relationship of the two nodes.</p>\n", "summary" : "<p>  Determines whether the node position given as second argument is\n preceding in document order the node position given as first argument.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "n-pos1", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the potential following node position</div>" }, { "name" : "n-pos2", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the potential preceding node position</div>" } ], "returns" : { "type" : "xs:boolean", "description" : "true if the node position $n-pos2 is preceding in document order the node position $n-pos1; false otherwise." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZAPI0028 if one of the given URI is not a valid node position computed by the <tt>np:node-position</tt> function.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "preceding-of", "qname" : "np:preceding-of", "signature" : "($n-pos1 as xs:anyURI, $n-pos2 as xs:anyURI) as xs:boolean external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Determines whether the node position given as second argument is\n preceding the node position given as first argument.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If the two positions were obtained within the same snapshot S, then the\n result of the function applies to the corresponding nodes as well, that\n is, within snapshot S, the second node is preceding the first.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Otherwise, the result of the function does not imply anything about the\n positional relationship of the two nodes.</p>\n", "summary" : "<p>  Determines whether the node position given as second argument is\n preceding the node position given as first argument.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "n-pos1", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the potential following node position</div>" }, { "name" : "n-pos2", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the potential preceding node position</div>" } ], "returns" : { "type" : "xs:boolean", "description" : "true if node positions $n-pos1 and $n-pos2 belong to the same XML tree and $n-pos2 is preceding the node position $n-pos1; false otherwise." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZAPI0028 if one of the given URI is not a valid node position computed by the <tt>np:node-position</tt> function.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "preceding-sibling-of", "qname" : "np:preceding-sibling-of", "signature" : "($n-pos1 as xs:anyURI, $n-pos2 as xs:anyURI) as xs:boolean external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Determines whether the node position given as second argument is\n a preceding-sibling of the node position given as first argument.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If the two positions were obtained within the same snapshot S, then the\n result of the function applies to the corresponding nodes as well, that\n is, within snapshot S, the second node is a preceding-sibling of the first.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Otherwise, the result of the function does not imply anything about the\n positional relationship of the two nodes.</p>\n", "summary" : "<p>  Determines whether the node position given as second argument is\n a preceding-sibling of the node position given as first argument.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "n-pos1", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the potential following-sibling node position</div>" }, { "name" : "n-pos2", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the potential preceding-sibling node position</div>" } ], "returns" : { "type" : "xs:boolean", "description" : "true if the node position $n-pos2 is a preceding-sibling of the node position $n-pos1; false otherwise." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZAPI0028 if one of the given URI is not a valid node position computed by the <tt>np:node-position</tt> function.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "sibling-of", "qname" : "np:sibling-of", "signature" : "($n-pos1 as xs:anyURI, $n-pos2 as xs:anyURI) as xs:boolean external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Determines whether two node positions are siblings.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If the two positions were obtained within the same snapshot S, then the\n result of the function applies to the corresponding nodes as well, that\n is, within snapshot S, the second node is a sibling of the first.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Otherwise, the result of the function does not imply anything about the\n positional relationship of the two nodes.</p>\n", "summary" : "<p>  Determines whether two node positions are siblings.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "n-pos1", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a node position</div>" }, { "name" : "n-pos2", "type" : "xs:anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a node position</div>" } ], "returns" : { "type" : "xs:boolean", "description" : "true if the two node positions $n-pos1 and $n-pos2 are siblings; false otherwise." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZAPI0028 if one of the given URI is not a valid node position computed by the <tt>np:node-position</tt> function.</xqdoc:error>" ] } ], "variables" : [  ] }, "http://www.zorba-xquery.com/modules/cryptography/hash" : { "ns" : "http://www.zorba-xquery.com/modules/cryptography/hash", "description" : " This module provides functions that perform different hash operations.\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Gabriel Petrovay, Markus Pilman</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://www.zorba-xquery.com/modules/cryptography/hash", "prefix" : "hash" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 2, "name" : "hash-impl", "qname" : "hash:hash-impl", "signature" : "($value as xs:string, $alg as xs:string) as xs:string external", "description" : " This function computes a hash value of the string provided as parameter.\n The function expects the hash algorithm to be used as parameter.\n", "summary" : "<p> This function computes a hash value of the string provided as parameter.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "value", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The string to be hashed.</div>" }, { "name" : "alg", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The algorithm to use for this hashing operation. Currently only \"md5\" and \"sha1\" algorithms are available. If no valid algorithm name is given, md5 will be used.</div>" } ], "returns" : { "type" : "xs:string", "description" : "The hash of the provided string. In case SHA1 is used, the resulting hash value is base64 encoded." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "md5", "qname" : "hash:md5", "signature" : "($value as xs:string) as xs:string", "description" : " Computes the MD5 hash of the string provided as parameter.\n", "summary" : "<p> Computes the MD5 hash of the string provided as parameter.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "value", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The string to hash.</div>" } ], "returns" : { "type" : "xs:string", "description" : "The MD5 hash of the provided string." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "sha1", "qname" : "hash:sha1", "signature" : "($value as xs:string) as xs:string", "description" : " Computes the SHA1 hash of the string provided as parameter.\n", "summary" : "<p> Computes the SHA1 hash of the string provided as parameter.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "value", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The string to hash.</div>" } ], "returns" : { "type" : "xs:string", "description" : "The base64 encoded SHA1 hash of the provided string." }, "errors" : [  ] } ], "variables" : [  ] }, "http://zorba.io/modules/excel/lookup" : { "ns" : "http://zorba.io/modules/excel/lookup", "description" : " This module implements some Excel 2003 lookup functions.\n", "sees" : [ "<xqdoc:see xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"><a href=\"http://office.microsoft.com/en-us/excel/CH062528281033.aspx\" target=\"_blank\">Excel 2003 Documentation: Lookup Functions</a></xqdoc:see>" ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Daniel Turcanu</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://zorba.io/modules/excel/lookup", "prefix" : "excel" }, { "uri" : "http://zorba.io/modules/excel/errors", "prefix" : "excel-err" }, { "uri" : "http://zorba.io/modules/excel/math", "prefix" : "excel-math" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 2, "name" : "choose", "qname" : "excel:choose", "signature" : "($index_num as xs:integer, $values as xs:anyAtomicType*) as xs:anyAtomicType", "description" : " Uses index_num to return a value from the sequence of value arguments.\n", "summary" : "<p> Uses index_num to return a value from the sequence of value arguments.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "index_num", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The position in the sequence, 1 based.</div>" }, { "name" : "values", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The sequence of values.</div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "The value at the index position." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if index is smaller than 1 or bigger than the size of sequence.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 30, "name" : "choose", "qname" : "excel:choose", "signature" : "($index_num as xs:integer, $value_sequence1 as xs:anyAtomicType*, $value_sequence2 as xs:anyAtomicType*, $value_sequence3 as xs:anyAtomicType*, $value_sequence4 as xs:anyAtomicType*, $value_sequence5 as xs:anyAtomicType*, $value_sequence6 as xs:anyAtomicType*, $value_sequence7 as xs:anyAtomicType*, $value_sequence8 as xs:anyAtomicType*, $value_sequence9 as xs:anyAtomicType*, $value_sequence10 as xs:anyAtomicType*, $value_sequence11 as xs:anyAtomicType*, $value_sequence12 as xs:anyAtomicType*, $value_sequence13 as xs:anyAtomicType*, $value_sequence14 as xs:anyAtomicType*, $value_sequence15 as xs:anyAtomicType*, $value_sequence16 as xs:anyAtomicType*, $value_sequence17 as xs:anyAtomicType*, $value_sequence18 as xs:anyAtomicType*, $value_sequence19 as xs:anyAtomicType*, $value_sequence20 as xs:anyAtomicType*, $value_sequence21 as xs:anyAtomicType*, $value_sequence22 as xs:anyAtomicType*, $value_sequence23 as xs:anyAtomicType*, $value_sequence24 as xs:anyAtomicType*, $value_sequence25 as xs:anyAtomicType*, $value_sequence26 as xs:anyAtomicType*, $value_sequence27 as xs:anyAtomicType*, $value_sequence28 as xs:anyAtomicType*, $value_sequence29 as xs:anyAtomicType*) as xs:anyAtomicType*", "description" : " Uses index_num to return a sequence from the list of sequences.\n Use CHOOSE to select one of up to 29 sequences based on the index number.\n", "summary" : "<p> Uses index_num to return a sequence from the list of sequences.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "index_num", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the position in the sequence, 1 based</div>" }, { "name" : "value_sequence1", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" }, { "name" : "value_sequence2", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" }, { "name" : "value_sequence3", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" }, { "name" : "value_sequence4", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" }, { "name" : "value_sequence5", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" }, { "name" : "value_sequence6", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" }, { "name" : "value_sequence7", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" }, { "name" : "value_sequence8", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" }, { "name" : "value_sequence9", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" }, { "name" : "value_sequence10", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" }, { "name" : "value_sequence11", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" }, { "name" : "value_sequence12", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" }, { "name" : "value_sequence13", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" }, { "name" : "value_sequence14", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" }, { "name" : "value_sequence15", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" }, { "name" : "value_sequence16", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" }, { "name" : "value_sequence17", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" }, { "name" : "value_sequence18", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" }, { "name" : "value_sequence19", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" }, { "name" : "value_sequence20", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" }, { "name" : "value_sequence21", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" }, { "name" : "value_sequence22", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" }, { "name" : "value_sequence23", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" }, { "name" : "value_sequence24", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" }, { "name" : "value_sequence25", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" }, { "name" : "value_sequence26", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" }, { "name" : "value_sequence27", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" }, { "name" : "value_sequence28", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" }, { "name" : "value_sequence29", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of values. Specify the empty sequence () if you don't need it.</div>" } ], "returns" : { "type" : "xs:anyAtomicType*", "description" : "The value at the index position" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if index is smaller than 1 or bigger than 29</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 5, "name" : "hlookup", "qname" : "excel:hlookup", "signature" : "($lookup_value as xs:anyAtomicType, $table_array as xs:anyAtomicType+, $table_width as xs:integer, $table_height as xs:integer, $row_index_num as xs:integer) as xs:anyAtomicType", "description" : " Same as above, only that range_lookup is defaulted to true.\n That is, this Hlookup looks for the approximate value\n   and the first row must be ordered ascending.\n", "summary" : "<p> Same as above, only that range_lookup is defaulted to true.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "lookup_value", "type" : "xs:anyAtomicType", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the value to be searched. Allowed types are numeric, string, boolean. <p/> Boolean values are compared only with booleans. Numbers are compared only with numbers, if range_lookup is not zero. The other types are converted to string and compared to string value of all values.</div>" }, { "name" : "table_array", "type" : "xs:anyAtomicType", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of values, row after row</div>" }, { "name" : "table_width", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the number of values in a row</div>" }, { "name" : "table_height", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the number of rows</div>" }, { "name" : "row_index_num", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the row index, 1 based</div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "The value found, with original type" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if the array contains less elements than specified by table_height and table_width</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if row_index_num is outside the range 1 .. table_height</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if range_lookup is true and the value searched is smaller than the first value in the header</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if range_lookup=false and the value cannot be found</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 6, "name" : "hlookup", "qname" : "excel:hlookup", "signature" : "($lookup_value as xs:anyAtomicType, $table_array as xs:anyAtomicType+, $table_width as xs:integer, $table_height as xs:integer, $row_index_num as xs:integer, $range_lookup as xs:boolean) as xs:anyAtomicType", "description" : " Searches for a value in the top row of an array of values,\n   and then returns a value in the same column from a row you specify in the array.\n <dl xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Array is specified with 3 parameters:\n <dt>table_array</dt> <dd>is a sequence of elements, first row first, then second row and so on</dd>\n <dt>table_width</dt> <dd>specifies the number of elements in a row</dd>\n <dt>table_height</dt> <dd>specifies the number of rows</dd></dl>\n The number of elements in table_array must be equal or more than table_width * table_height.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n For wildchar matching, the XQuery regex matcher is used.\n", "summary" : "<p> Searches for a value in the top row of an array of values,\n   and then returns a value in the same column from a row you specify in the array.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "lookup_value", "type" : "xs:anyAtomicType", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the value to be searched. Allowed types are numeric, string, boolean. <p/> Boolean values are compared only with booleans. Numbers are compared only with numbers, if range_lookup is not zero. The other types are converted to string and compared to string value of all values.</div>" }, { "name" : "table_array", "type" : "xs:anyAtomicType", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of values, row after row</div>" }, { "name" : "table_width", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the number of values in a row</div>" }, { "name" : "table_height", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the number of rows</div>" }, { "name" : "row_index_num", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the row index, 1 based</div>" }, { "name" : "range_lookup", "type" : "xs:boolean", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> <dl>specifies the algorithm to use: <dt>true</dt> <dd>find approximative match. First row of array must be sorted in ascending order.</dd> <dt>false</dt> <dd>find exact match, using xquery regex First row of array can be in any order. </dd></dl></div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "The value found, with original type" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if the array contains less elements than specified by table_height and table_width</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if row_index_num is outside the range 1 .. table_height</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if range_lookup is true and the value searched is smaller than the first value in the header</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if range_lookup=false and the value cannot be found</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 5, "name" : "index", "qname" : "excel:index", "signature" : "($array as xs:anyAtomicType+, $array_height as xs:integer, $array_width as xs:integer, $row_num as xs:integer, $column_num as xs:integer) as xs:anyAtomicType+", "description" : " Returns a value from within an array.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n This is the Array form of the Excel Index function.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <dl xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Array is specified with 3 parameters:\n <dt>array</dt> <dd>is a sequence of elements, first row first, then second row and so on</dd>\n <dt>array_height</dt> <dd>specifies the number of rows</dd>\n <dt>array_width</dt> <dd>specifies the number of elements in a row</dd></dl>\n The number of elements in array must be equal or more than array_width * array_height.\n", "summary" : "<p> Returns a value from within an array.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "array", "type" : "xs:anyAtomicType", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of values, row after row</div>" }, { "name" : "array_height", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the number of rows</div>" }, { "name" : "array_width", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the number of values in a row</div>" }, { "name" : "row_num", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the row position of the value, 1 based</div>" }, { "name" : "column_num", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the column position of the value, 1 based</div>" } ], "returns" : { "type" : "xs:anyAtomicType+", "description" : "The value from x-y in the array" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if the array contains less elements than specified by table_height and table_width</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Ref if row_num is outside the range</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "lookup", "qname" : "excel:lookup", "signature" : "($lookup_value as xs:anyAtomicType, $lookup_vector as xs:anyAtomicType+, $result_vector as xs:anyAtomicType+) as xs:anyAtomicType", "description" : " The Vector form. <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n Looks in a sequence for a value\n   and return a value from the same position in a second sequence.\n If the value is not found, then it matches the largest value in lookup_vector\n   that is less than or equal to lookup_value.\n", "summary" : "<p> The Vector form.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "lookup_value", "type" : "xs:anyAtomicType", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the value to be searched</div>" }, { "name" : "lookup_vector", "type" : "xs:anyAtomicType", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence to be searched, in ascending order.</div>" }, { "name" : "result_vector", "type" : "xs:anyAtomicType", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence containing the result values</div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "a value from $result_vector" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:NA if lookup value is smaller than the first value in lookup_vector</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:NA if position found is outside the result range</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 4, "name" : "lookup", "qname" : "excel:lookup", "signature" : "($lookup_value as xs:anyAtomicType, $array as xs:anyAtomicType+, $array_width as xs:integer, $array_height as xs:integer) as xs:anyAtomicType", "description" : " The Array form.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n It looks in the first row or column of an array for the specified value\n   and returns a value from the same position in the last row or column of the array.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n If array covers an area that is wider than it is tall (more columns than rows),\n   LOOKUP searches for lookup_value in the first row.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n If array is square or is taller than it is wide (more rows than columns),\n   LOOKUP searches in the first column.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The values in the first row or first column must be in ascending order.\n", "summary" : "<p> The Array form.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "lookup_value", "type" : "xs:anyAtomicType", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the value to be searched. If the value is not found, then it matches the largest value in lookup_vector that is less than or equal to lookup_value.</div>" }, { "name" : "array", "type" : "xs:anyAtomicType", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the array sequence, row after row</div>" }, { "name" : "array_width", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the number of values in a row</div>" }, { "name" : "array_height", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the number of rows in the array</div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "The corresponding value in the last row or column" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if array contains less values than specified by array_width and array_height or array_width = 0 or array_height = 0</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:NA if the lookup_value is smaller than the first value in the row or column</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "match", "qname" : "excel:match", "signature" : "($lookup_value as xs:anyAtomicType, $sequence as xs:anyAtomicType+) as xs:anyAtomicType", "description" : " Same as above, but match_type is defaulted to 1.\n It finds the largest value that is less than or equal to lookup_value.\n", "summary" : "<p> Same as above, but match_type is defaulted to 1.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "lookup_value", "type" : "xs:anyAtomicType", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> value to be searched.</div>" }, { "name" : "sequence", "type" : "xs:anyAtomicType", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the vector where to search the value</div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "The position of found value" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:NA for match_type 1 or -1, the lookup_value is smaller or larger than the first value in sequence</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if range_lookup=0 and the value cannot be found</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "match", "qname" : "excel:match", "signature" : "($lookup_value as xs:anyAtomicType, $sequence as xs:anyAtomicType+, $match_type as xs:integer) as xs:anyAtomicType", "description" : " Returns the relative position of an item in a sequence that\n   matches a specified value in a specified order.\n Only for one dimensional vector.\n", "summary" : "<p> Returns the relative position of an item in a sequence that\n   matches a specified value in a specified order.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "lookup_value", "type" : "xs:anyAtomicType", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> value to be searched.</div>" }, { "name" : "sequence", "type" : "xs:anyAtomicType", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the vector where to search the value</div>" }, { "name" : "match_type", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> <dl>specifies the algorithm used for searching. Possible values: <dt>1</dt> <dd> finds the largest value that is less than or equal to lookup_value. Sequence must be in ascending order.</dd> <dt>0</dt> <dd> finds the first value that is exactly equal to lookup_value. <p/> Sequence can be in any order.<p/> If lookup_value is boolean, then only booleans are compared.<p/> For other types, they are casted to string and then compared using xquery regular expressions. Lookup_value can be a xquery regular expression.</dd> <dt>-1</dt> <dd> finds the smallest value that is greater than or equal to lookup_value.<p/> Sequence must be in descending order.</dd></dl></div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "The position of found value" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:NA for match_type 1 or -1, the lookup_value is smaller or larger than the first value in sequence</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if range_lookup=0 and the value cannot be found</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 5, "name" : "offset", "qname" : "excel:offset", "signature" : "($reference as xs:anyAtomicType+, $reference_height as xs:integer, $reference_width as xs:integer, $rows as xs:integer, $cols as xs:integer) as xs:anyAtomicType*", "description" : " Same as above, only that the sub-array is specified only by rows and cols relative position.\n The sub-array height and width is computed to contain the remaining elements of the array.\n", "summary" : "<p> Same as above, only that the sub-array is specified only by rows and cols relative position.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "reference", "type" : "xs:anyAtomicType", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the reference array</div>" }, { "name" : "reference_height", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the number of rows in the reference array</div>" }, { "name" : "reference_width", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the number of elements in the reference array row</div>" }, { "name" : "rows", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the relative row position where the sub-array starts. It must be a positive value, zero relative.</div>" }, { "name" : "cols", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the relative column position where the sub-array starts. It must be a positive value, zero relative.</div>" } ], "returns" : { "type" : "xs:anyAtomicType*", "description" : "The sequence specifying the sub-array, row after row" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:NA rows or cols are negative</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:NA height or width are smaller than 1</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value reference array contains less elements than specified by reference_height and reference_width</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:NA the resulted sub-array is not completely contained inside reference array</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 7, "name" : "offset", "qname" : "excel:offset", "signature" : "($reference as xs:anyAtomicType+, $reference_height as xs:integer, $reference_width as xs:integer, $rows as xs:integer, $cols as xs:integer, $height as xs:integer, $width as xs:integer) as xs:anyAtomicType*", "description" : " Returns a sub-array from an array.\n The inner array must be within the reference array\n", "summary" : "<p> Returns a sub-array from an array.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "reference", "type" : "xs:anyAtomicType", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the reference array</div>" }, { "name" : "reference_height", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the number of rows in the reference array</div>" }, { "name" : "reference_width", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the number of elements in the reference array row</div>" }, { "name" : "rows", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the relative row position where the sub-array starts. It must be a positive value, zero relative.</div>" }, { "name" : "cols", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the relative column position where the sub-array starts. It must be a positive value, zero relative.</div>" }, { "name" : "height", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the desired height of sub-array. The sub-array must be inside the reference array.</div>" }, { "name" : "width", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the desired width of sub-array. The sub-array must be inside the reference array.</div>" } ], "returns" : { "type" : "xs:anyAtomicType*", "description" : "The sequence specifying the sub-array, row after row" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:NA rows or cols are negative</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:NA height or width are smaller than 1</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value reference array contains less elements than specified by reference_height and reference_width</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:NA the resulted sub-array is not completely contained inside reference array</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "transpose", "qname" : "excel:transpose", "signature" : "($array as xs:anyAtomicType+, $array_width as xs:integer, $array_height as xs:integer) as xs:anyAtomicType+", "description" : " Transposes an array. The rows become columns and vice versa.\n", "summary" : "<p> Transposes an array.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "array", "type" : "xs:anyAtomicType", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence specifying the array, row after row</div>" }, { "name" : "array_width", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the number of elements in a row</div>" }, { "name" : "array_height", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the number of rows in the array</div>" } ], "returns" : { "type" : "xs:anyAtomicType+", "description" : "The transposed array. It will be a sequence specifying an array, row after row. The result width is the input height. The result height is the input width." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value the array contains less elements than specified by array_width and array_height</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 5, "name" : "vlookup", "qname" : "excel:vlookup", "signature" : "($lookup_value as xs:anyAtomicType, $table_array as xs:anyAtomicType+, $table_width as xs:integer, $table_height as xs:integer, $col_index_num as xs:integer) as xs:anyAtomicType", "description" : " Same as above, with range_lookup defaulted to true.\n It finds the largest value that is less than or equal to lookup_value.\n First column must be in ascending order.\n", "summary" : "<p> Same as above, with range_lookup defaulted to true.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "lookup_value", "type" : "xs:anyAtomicType", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the value to be searched. Allowed types are numeric, string, boolean. <p/> Boolean values are compared only with booleans. Numbers are compared only with numbers, if range_lookup is not zero. The other types are converted to string and compared to string value of all values.</div>" }, { "name" : "table_array", "type" : "xs:anyAtomicType", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of values, row after row</div>" }, { "name" : "table_width", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the number of values in a row</div>" }, { "name" : "table_height", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the number of rows</div>" }, { "name" : "col_index_num", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the row index, 1 based</div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "The value found, with original type" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if the array contains less elements than specified by table_height and table_width</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if col_index_num is outside the range 1 .. table_height</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if range_lookup is true and the value searched is smaller than the first value in the first column</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if range_lookup=false and the value cannot be found</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 6, "name" : "vlookup", "qname" : "excel:vlookup", "signature" : "($lookup_value as xs:anyAtomicType, $table_array as xs:anyAtomicType+, $table_width as xs:integer, $table_height as xs:integer, $col_index_num as xs:integer, $range_lookup as xs:boolean) as xs:anyAtomicType", "description" : " Searches for a value in the first column of a table array\n   and returns a value in the same row from another column in the table array.\n <dl xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Array is specified with 3 parameters:\n <dt>table_array</dt> <dd>is a sequence of elements, first row first, then second row and so on</dd>\n <dt>table_width</dt> <dd>specifies the number of elements in a row</dd>\n <dt>table_height</dt> <dd>specifies the number of rows</dd></dl>\n For wildchar matching, the XQuery regex matcher is used.\n", "summary" : "<p> Searches for a value in the first column of a table array\n   and returns a value in the same row from another column in the table array.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "lookup_value", "type" : "xs:anyAtomicType", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the value to be searched. Allowed types are numeric, string, boolean. <p/> Boolean values are compared only with booleans. Numbers are compared only with numbers, if range_lookup is not zero. The other types are converted to string and compared to string value of all values.</div>" }, { "name" : "table_array", "type" : "xs:anyAtomicType", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the sequence of values, row after row</div>" }, { "name" : "table_width", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the number of values in a row</div>" }, { "name" : "table_height", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the number of rows</div>" }, { "name" : "col_index_num", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the row index, 1 based</div>" }, { "name" : "range_lookup", "type" : "xs:boolean", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> <dl>specified the algorithm to use: <dt>true</dt> <dd> find approximative match. First column of array must be sorted in ascending order.</dd> <dt>false</dt> <dd> find exact match, using xquery regex. First column of array can be in any order.</dd></dl></div>" } ], "returns" : { "type" : "xs:anyAtomicType", "description" : "The value found, with original type" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if the array contains less elements than specified by table_height and table_width</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if col_index_num is outside the range 1 .. table_height</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if range_lookup is true and the value searched is smaller than the first value in the first column</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">excel-err:Value if range_lookup=false and the value cannot be found</xqdoc:error>" ] } ], "variables" : [  ] }, "http://zorba.io/modules/datetime" : { "ns" : "http://zorba.io/modules/datetime", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This module provides functions to retrieve the current dateTime and to\n parse dates and times.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">In contrast to the current-dateTime functions specified in\n <a href=\"http://www.w3.org/TR/xpath-functions-30/\">XQuery Functions and\n Operators</a>, the functions in this module are nondeterministic, that is,\n they do not return the current dateTime from the dynamic context, but return\n the actual value.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Dates and times are parsed according to the format given by\n <a href=\"http://pubs.opengroup.org/onlinepubs/007904975/functions/strptime.html\">strptime</a>.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">However, date and time values must be \"complete.\"</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">For a date, the year and either month and day or day of the year must have\n been parsed.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">For a time, the hour must have been parsed.\n (If either the minute, second, or timezone has not been parsed, they default\n to 0.)</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">For a dateTime, the parsing requirements of both date and time must be met.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">When a locale is given,\n it must be of the form {lang}[{sep}{country}[{encoding}]] where\n {lang} is an ISO 639-1 2-letter or 639-2 3-letter language code,\n {sep} is either '-' or '_',\n {country} is an ISO 3166-1 2-letter country code,\n and {encoding} is any string that begins with a '.'.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The {sep}, {country}, and {encoding} are optional;\n {encoding} is always ignored.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Examples include: de, en-US, fr_CA, ru_RU.UTF-8.</p>\n", "sees" : [ "<xqdoc:see xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">http://www.w3.org/TR/xpath-functions/#context</xqdoc:see>" ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Matthias Brantner</xqdoc:author>", "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Paul J. Lucas</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://zorba.io/annotations", "prefix" : "an" }, { "uri" : "http://zorba.io/modules/datetime", "prefix" : "datetime" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 0, "name" : "current-date", "qname" : "datetime:current-date", "signature" : "() as xs:date external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Gets the current date value in Universal time.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Note that this function is not stable: it returns the value of the date when\n the function is invoked.</p>\n", "summary" : "<p>  Gets the current date value in Universal time.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:date", "description" : "the non-stable date value" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "current-dateTime", "qname" : "datetime:current-dateTime", "signature" : "() as xs:dateTimeStamp external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Gets the current dateTime value in Universal time.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Note that this function is not stable: it returns the value of the date and\n time when the function is invoked.</p>\n", "summary" : "<p>  Gets the current dateTime value in Universal time.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:dateTimeStamp", "description" : "the non-stable datetime value" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "current-time", "qname" : "datetime:current-time", "signature" : "() as xs:time external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Return the current time value in Universal time.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Note that this function is not stable: it returns the value of the time when\n the function is invoked.</p>\n", "summary" : "<p>  Return the current time value in Universal time.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:time", "description" : "the non-stable time value" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "millis-to-dateTime", "qname" : "datetime:millis-to-dateTime", "signature" : "($millis as xs:long) as xs:dateTime external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Converts the given number of milliseconds since epoch into its corresponding\n xs:dateTime.</p>\n", "summary" : "<p>  Converts the given number of milliseconds since epoch into its corresponding\n xs:dateTime.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "millis", "type" : "xs:long", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The number of milliseconds since epoch.</div>" } ], "returns" : { "type" : "xs:dateTime", "description" : "Returns an xs:dateTime." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "parse-date", "qname" : "datetime:parse-date", "signature" : "($input as xs:string, $format as xs:string) as xs:date external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Parses a date from a string in the current locale.</p>\n", "summary" : "<p>  Parses a date from a string in the current locale.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "input", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The string to parse.</div>" }, { "name" : "format", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The format string containing zero or more conversion specifications and ordinary characters. All ordinary characters are matched exactly with the buffer; all whitespace characters match any amount of whitespace in the buffer.</div>" } ], "returns" : { "type" : "xs:date", "description" : "Returns an xs:date." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:INVALID_SPECIFICATION if $format contains an invalid conversion specification.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:INSUFFICIENT_BUFFER if $input is insufficient for $format.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:INVALID_VALUE if $input contains an invalid value for a conversion specification.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:LITERAL_MISMATCH if there is a literal characer mismatch between $input and $format.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:INCOMPLETE_DATE_OR_TIME if the date is incomplete.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "parse-date", "qname" : "datetime:parse-date", "signature" : "($input as xs:string, $format as xs:string, $locale as xs:string) as xs:date external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Parses a date from a string in the given locale.</p>\n", "summary" : "<p>  Parses a date from a string in the given locale.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "input", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The string to parse.</div>" }, { "name" : "format", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The format string containing zero or more conversion specifications and ordinary characters. All ordinary characters are matched exactly with the buffer; all whitespace characters match any amount of whitespace in the buffer.</div>" }, { "name" : "locale", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The locale to use.</div>" } ], "returns" : { "type" : "xs:date", "description" : "Returns an xs:date." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:INVALID_SPECIFICATION if $format contains an invalid conversion specification.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:INSUFFICIENT_BUFFER if $input is insufficient for $format.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:INVALID_VALUE if $input contains an invalid value for a conversion specification.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:LITERAL_MISMATCH if there is a literal characer mismatch between $input and $format.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:INCOMPLETE_DATE_OR_TIME if the date is incomplete.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:INVALID_LOCALE if $locale is in an invalid format.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:UNKNOWN_LOCALE if $locale is unknown.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:UNSUPPORTED_LOCALE if $locale is unsupported by the operating system.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "parse-dateTime", "qname" : "datetime:parse-dateTime", "signature" : "($input as xs:string, $format as xs:string) as xs:dateTime external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Parses a dateTime from a string in the current locale.</p>\n", "summary" : "<p>  Parses a dateTime from a string in the current locale.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "input", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The string to parse.</div>" }, { "name" : "format", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The format string containing zero or more conversion specifications and ordinary characters. All ordinary characters are matched exactly with the buffer; all whitespace characters match any amount of whitespace in the buffer.</div>" } ], "returns" : { "type" : "xs:dateTime", "description" : "Returns an xs:dateTime." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:INVALID_SPECIFICATION if $format contains an invalid conversion specification.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:INSUFFICIENT_BUFFER if $input is insufficient for $format.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:INVALID_VALUE if $input contains an invalid value for a conversion specification.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:LITERAL_MISMATCH if there is a literal characer mismatch between $input and $format.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:INCOMPLETE_DATE_OR_TIME if either the date or time is incomplete.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "parse-dateTime", "qname" : "datetime:parse-dateTime", "signature" : "($input as xs:string, $format as xs:string, $locale as xs:string) as xs:dateTime external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Parses a dateTime from a string in the given locale.</p>\n", "summary" : "<p>  Parses a dateTime from a string in the given locale.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "input", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The string to parse.</div>" }, { "name" : "format", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The format string containing zero or more conversion specifications and ordinary characters. All ordinary characters are matched exactly with the buffer; all whitespace characters match any amount of whitespace in the buffer.</div>" }, { "name" : "locale", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The locale to use.</div>" } ], "returns" : { "type" : "xs:dateTime", "description" : "Returns an xs:dateTime." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:INVALID_SPECIFICATION if $format contains an invalid conversion specification.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:INSUFFICIENT_BUFFER if $input is insufficient for $format.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:INVALID_VALUE if $input contains an invalid value for a conversion specification.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:LITERAL_MISMATCH if there is a literal characer mismatch between $input and $format.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:INCOMPLETE_DATE_OR_TIME if either the date or time is incomplete.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:INVALID_LOCALE if $locale is in an invalid format.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:UNKNOWN_LOCALE if $locale is unknown.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:UNSUPPORTED_LOCALE if $locale is unsupported by the operating system.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "parse-time", "qname" : "datetime:parse-time", "signature" : "($input as xs:string, $format as xs:string) as xs:time external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Parses a time from a string in the current locale.</p>\n", "summary" : "<p>  Parses a time from a string in the current locale.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "input", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The string to parse.</div>" }, { "name" : "format", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The format string containing zero or more conversion specifications and ordinary characters. All ordinary characters are matched exactly with the buffer; all whitespace characters match any amount of whitespace in the buffer.</div>" } ], "returns" : { "type" : "xs:time", "description" : "Returns an xs:time." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:INVALID_SPECIFICATION if $format contains an invalid conversion specification.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:INSUFFICIENT_BUFFER if $input is insufficient for $format.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:INVALID_VALUE if $input contains an invalid value for a conversion specification.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:LITERAL_MISMATCH if there is a literal characer mismatch between $input and $format.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:INCOMPLETE_DATE_OR_TIME if the hour has not been parsed.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "parse-time", "qname" : "datetime:parse-time", "signature" : "($input as xs:string, $format as xs:string, $locale as xs:string) as xs:time external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Parses a time from a string in the given locale.</p>\n", "summary" : "<p>  Parses a time from a string in the given locale.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "input", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The string to parse.</div>" }, { "name" : "format", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The format string containing zero or more conversion specifications and ordinary characters. All ordinary characters are matched exactly with the buffer; all whitespace characters match any amount of whitespace in the buffer.</div>" }, { "name" : "locale", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The locale to use.</div>" } ], "returns" : { "type" : "xs:time", "description" : "Returns an xs:time." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:INVALID_SPECIFICATION if $format contains an invalid conversion specification.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:INSUFFICIENT_BUFFER if $input is insufficient for $format.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:INVALID_VALUE if $input contains an invalid value for a conversion specification.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:LITERAL_MISMATCH if there is a literal characer mismatch between $input and $format.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:INCOMPLETE_DATE_OR_TIME if the hour has not been parsed.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:INVALID_LOCALE if $locale is in an invalid format.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:UNKNOWN_LOCALE if $locale is unknown.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">datetime:UNSUPPORTED_LOCALE if $locale is unsupported by the operating system.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 0, "name" : "timestamp", "qname" : "datetime:timestamp", "signature" : "() as xs:long external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Gets the the number of milliseconds since epoch.</p>\n", "summary" : "<p>  Gets the the number of milliseconds since epoch.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:long", "description" : "the said number of milliseconds." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "utc-offset", "qname" : "datetime:utc-offset", "signature" : "() as xs:long external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Gets the offset of the current timezone from Universal time.</p>\n", "summary" : "<p>  Gets the offset of the current timezone from Universal time.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:long", "description" : "the offset in seconds with positive values being east of the prime meridian." }, "errors" : [  ] } ], "variables" : [  ] }, "http://www.28msec.com/modules/http/util/diagnostic" : { "ns" : "http://www.28msec.com/modules/http/util/diagnostic", "description" : " This module provides utility functions to help with diagnostic analysis\n / debugging of RESTful Apps or webapps.\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">28msec</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://zorba.io/modules/base64", "prefix" : "base64" }, { "uri" : "http://www.28msec.com/modules/http/util/diagnostic", "prefix" : "diagnostic" }, { "uri" : "http://www.w3.org/2005/xqt-errors", "prefix" : "err" }, { "uri" : "http://www.28msec.com/modules/http/util/multipart", "prefix" : "multipart" }, { "uri" : "http://www.28msec.com/modules/http/request", "prefix" : "request" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 0, "name" : "serialize-request-as-html", "qname" : "diagnostic:serialize-request-as-html", "signature" : "() as element(*)*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns a sequence of html elements listing all request\n characteristics.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is helpful for debugging purposes. It can be used\n to output request information within an HTML page.</p>\n", "summary" : "<p>  Returns a sequence of html elements listing all request\n characteristics.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "element(*)*", "description" : "HTML elements describing the request" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "serialize-request-as-txt", "qname" : "diagnostic:serialize-request-as-txt", "signature" : "() as xs:string*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns a sequence of xs:string listing all request\n characteristics.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is helpful for debugging purposes. It can be used\n to output request information as plan text.</p>\n", "summary" : "<p>  Returns a sequence of xs:string listing all request\n characteristics.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:string*", "description" : "sequence of strings describing each characteristic of a request" }, "errors" : [  ] } ], "variables" : [  ] }, "http://www.28msec.com/modules/credentials" : { "ns" : "http://www.28msec.com/modules/credentials", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This module provides functionality for storing credentials\n using an AES-encrypted file the project configuration folder.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Specifically, the credentials will be stored in the <tt>credentials</tt>\n file in the <tt>config</tt> folder in the project root folder.\n The credentials file is encrypted using 256bit AES encryption. The AES\n key is computed using the project seed. If the project seed is changed the\n credential store is re-encrypted transparently.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Each credential has an associated name and category.\n Credentials can be retrieved specifying their name and category.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">For each category, it is possible to specify the default credentials.\n A category default credentials can then be easily retrieved. </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The name of credentials and categories can contain lowercase or\n uppercase letters, digits, and the following special characters: \"_\" , \"-\",\n \".\". Additionally it must not be empty and must start with a lowercase\n or uppercase letter.</p>\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Federico Cavalieri</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://zorba.io/annotations", "prefix" : "an" }, { "uri" : "http://www.28msec.com/modules/credentials", "prefix" : "credentials" }, { "uri" : "http://www.w3.org/2005/xqt-errors", "prefix" : "err" }, { "uri" : "http://jsoniq.org/errors", "prefix" : "jerr" }, { "uri" : "http://www.28msec.com/modules/mongodb", "prefix" : "mongo" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 3, "name" : "add-credentials", "qname" : "credentials:add-credentials", "signature" : "($category as string, $name as string, $credentials as object()) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Adds the given credentials to the credential store.\n The credentials are not set as default.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If credentials  with the given name and category are already present an\n error is raised.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n import module namespace credentials = \"http://www.28msec.com/modules/credentials\";\n credentials:add-credentials(\"S3\", \"DataBucket\", { ... });\n </pre>\n </p>\n", "summary" : "<p>  Adds the given credentials to the credential store.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "category", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials category name.</div>" }, { "name" : "name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials name.</div>" }, { "name" : "credentials", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> An object containing the credentials data.</div>" } ], "returns" : { "type" : "object()", "description" : "the credential object" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:EXIST if credentials with the given name and category are already present.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:NAME if the credentials or category name is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:MONGO-DEFAULT if the specified credentials and category name correspond with the default MongoDB credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:TEST if a connection cannot be established using the specified credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:CREDENTIALS-STORE if an internal error arises accessing the crendentials store</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 4, "name" : "add-credentials", "qname" : "credentials:add-credentials", "signature" : "($category as string, $name as string, $credentials as object(), $default as boolean) as object()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Adds the given credentials to the credential store,\n either as default or not.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If credentials  with the given name and category are already present an\n error is raised.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n import module namespace credentials = \"http://www.28msec.com/modules/credentials\";\n credentials:add-credentials(\"S3\", \"DataBucket\", { ... }, true);\n </pre>\n </p>\n", "summary" : "<p>  Adds the given credentials to the credential store,\n either as default or not.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "category", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials category name.</div>" }, { "name" : "name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials name.</div>" }, { "name" : "credentials", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> An object containing the credentials data.</div>" }, { "name" : "default", "type" : "boolean", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> Whether the credentials will be default or not.</div>" } ], "returns" : { "type" : "object()", "description" : "the credential object" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:EXIST if credentials with the given name and category are already present.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:NAME if the credentials or category name is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:MONGO-DEFAULT if trying to add the default MongoDB credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:TEST if a connection cannot be established using the specified credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:CREDENTIALS-STORE if an internal error arises accessing the crendentials store</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "credentials", "qname" : "credentials:credentials", "signature" : "($category as string) as object()?", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the given category's default credentials, if any.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If no default credentials are present for the given category\n the empty sequence is returned.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n import module namespace credentials = \"http://www.28msec.com/modules/credentials\";\n credentials:credentials(\"S3\")\n </pre>\n </p>\n", "summary" : "<p>  Returns the given category's default credentials, if any.</p>", "annotation_str" : " %an:strictlydeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "strictlydeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "category", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The category name.</div>" } ], "returns" : { "type" : "object()?", "description" : "The specified category default credentials, if any." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:NAME if the credentials or category name is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:MONGO-DEFAULT if the specified category is MongoDB</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:CREDENTIALS-STORE if an internal error arises accessing the crendentials store</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "credentials", "qname" : "credentials:credentials", "signature" : "($category as string, $name as string) as object()?", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the specified credentials, if present in the credential store.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If the specified credentials are not present the empty sequence is returned.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n import module namespace credentials = \"http://www.28msec.com/modules/credentials\";\n credentials:credentials(\"S3\", \"DataBucket\")\n </pre>\n </p>\n", "summary" : "<p>  Returns the specified credentials, if present in the credential store.</p>", "annotation_str" : " %an:strictlydeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "strictlydeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "category", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials category name.</div>" }, { "name" : "name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials name.</div>" } ], "returns" : { "type" : "object()?", "description" : "The specified credentials, if present." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:NAME if the credentials or category name is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:MONGO-DEFAULT if the credentials or category name is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:CREDENTIALS-STORE if an internal error arises accessing the crendentials store</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 0, "name" : "list-categories", "qname" : "credentials:list-categories", "signature" : "() as array()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Lists all the credentials categories in the credentials store.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If no credentials are stored the empty sequence is returned.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n import module namespace credentials = \"http://www.28msec.com/modules/credentials\";\n credentials:list-categories()\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The returned array contains the name of each distinct credential category.</p>\n", "summary" : "<p>  Lists all the credentials categories in the credentials store.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "array()", "description" : "An array of all the distinct credentials categories in the credentials store." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:CREDENTIALS-STORE if an internal error arises accessing the crendentials store</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "list-category-credentials", "qname" : "credentials:list-category-credentials", "signature" : "($category-name as string) as array()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Lists all the credentials of the specified category in the\n credentials store.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If no credentials for the given category are stored the empty\n sequence is returned.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n import module namespace credentials = \"http://www.28msec.com/modules/credentials\";\n credentials:list-category-credentials(\"category-name\")\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The returned array contains one object for each credential. Each object has\n the following structure:\n <pre>\n {\n   \"category\": \"category-name\",\n   \"name\": \"credential-name\",\n   \"default\": true\n }\n </pre>\n Specifically the fields of each object have the following meaning:\n <ul>\n  <li>category: the name of the credentials category (string)</li>\n  <li>name: the name of the credentials (string)</li>\n  <li>default: whether the credentials are the default credentials in\n      their category (boolean)</li>\n </ul>\n </p>\n", "summary" : "<p>  Lists all the credentials of the specified category in the\n credentials store.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "category-name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials category name.</div>" } ], "returns" : { "type" : "array()", "description" : "An array of all the credentials of the specified category in the credentials store." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:NAME if the credentials or category name is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:CREDENTIALS-STORE if an internal error arises accessing the crendentials store</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 0, "name" : "list-credentials", "qname" : "credentials:list-credentials", "signature" : "() as array()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Lists all the credentials in the credentials store.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If no credentials are stored the empty sequence is returned.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n import module namespace credentials = \"http://www.28msec.com/modules/credentials\";\n credentials:list-credentials()\n </pre>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The returned array contains one object for each credential. Each object has\n the following structure:\n <pre>\n {\n   \"category\": \"category-name\",\n   \"name\": \"credential-name\",\n   \"default\": true\n }\n </pre>\n Specifically the fields of each object have the following meaning:\n <ul>\n  <li>category: the name of the credentials category (string)</li>\n  <li>name: the name of the credentials (string)</li>\n  <li>default: whether the credentials are the default credentials in\n      their category (boolean)</li>\n </ul>\n </p>\n", "summary" : "<p>  Lists all the credentials in the credentials store.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "array()", "description" : "An array of all credentials in the credentials store." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:CREDENTIALS-STORE if an internal error arises accessing the crendentials store</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "make-default", "qname" : "credentials:make-default", "signature" : "($category as string, $name as string) as empty-sequence()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Makes the specified credentials the default for their category.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">It is not allowed to call this method on credentials in the \"MongoDB\" category.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If the specified credentials are not present an error is raised.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n import module namespace credentials = \"http://www.28msec.com/modules/credentials\";\n credentials:make-default(\"S3\", \"DataBucket\");\n </pre>\n </p>\n", "summary" : "<p>  Makes the specified credentials the default for their category.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "category", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials category name.</div>" }, { "name" : "name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials name.</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "The empty sequence." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:NOT-EXIST if no credentials with the given name and category are present.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:NAME if the credentials or category name is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:MONGO-DEFAULT if the specified category is MongoDB</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:CREDENTIALS-STORE if an internal error arises accessing the crendentials store</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "remove-credentials", "qname" : "credentials:remove-credentials", "signature" : "($category as string, $name as string) as empty-sequence()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Removes the specified credentials from the credential store.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">If no credentials with the given name and category are present\n in the category store an error is raised.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <pre>\n import module namespace credentials = \"http://www.28msec.com/modules/credentials\";\n credentials:remove-credentials(\"S3\", \"DataBucket\");\n </pre>\n </p>\n", "summary" : "<p>  Removes the specified credentials from the credential store.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "category", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials category name.</div>" }, { "name" : "name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials name.</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "The empty sequence." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:NOT-EXIST if no credentials with the given name and category exist.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:NAME if the credentials or category name is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:MONGO-DEFAULT if the specified credentials and category name correspond with the default MongoDB credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:CREDENTIALS-STORE if an internal error arises accessing the crendentials store</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 5, "name" : "update-credentials", "qname" : "credentials:update-credentials", "signature" : "($category as string, $name as string, $new-default as boolean?, $new-name as string?, $new-credentials as object()?) as empty-sequence()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Updates the specified credentials in the credential store.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">It is possible to specify whether the credentials should become or stop being the\n default credentials in their category, rename the credentials or change the credentials\n object. These three changes are specified by means of the $new-default, $new-name and\n $new-credentials parameter. If the corresponding parameter is the empty sequence the\n corresponding property will not be changed.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">For example the following query renames the \"DataBucket\" credentials in the \"S3\"\n category as \"Bucket\":\n <pre>\n import module namespace credentials = \"http://www.28msec.com/modules/credentials\";\n credentials:update-credentials(\"S3\", \"DataBucket\", (), \"Bucket\", () );\n </pre>\n </p>\n", "summary" : "<p>  Updates the specified credentials in the credential store.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "category", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials category name.</div>" }, { "name" : "name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The credentials name.</div>" }, { "name" : "new-default", "type" : "boolean", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> Whether the credentials should become/stop being the default credentials in their category. If it is an empty sequence the current default property will not be changed.</div>" }, { "name" : "new-name", "type" : "string", "occurrence" : "?", "description" : "" }, { "name" : "new-credentials", "type" : "object()", "occurrence" : "?", "description" : "" } ], "returns" : { "type" : "empty-sequence()", "description" : "the empty sequence" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:NOT-EXIST if credentials with the given name and category do not exist.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:EXIST if credentials with the given new name and category are already present.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:NAME if the credentials or category name is invalid</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:MONGO-DEFAULT if the specified credentials or category name correspond with the default MongoDB credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:TEST if a connection cannot be established using the specified credentials</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">credentials:CREDENTIALS-STORE if an internal error arises accessing the crendentials store</xqdoc:error>" ] } ], "variables" : [  ] }, "http://www.28msec.com/modules/parallelism" : { "ns" : "http://www.28msec.com/modules/parallelism", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This module provides functionality for executing FLWOR queries in parallel.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">There are two kinds of parallel jobs: map jobs and shuffle jobs.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">A map job runs a mapping function on the items of an input collection. The input\n collection is chunked and the mapping function is called on each chunk in parallel.\n The results are either inserted in a single collection, or on one ouptut collection\n for each chunk.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">A shuffle job shuffles the items of an input collection to several output collections.\n The input collection is chunked and each chunk is processed in parallel.\n The selection of the output collection for each item is done with a shuffling function.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">It is also possible to run a map or shuffle job on the output of another map or shuffle\n job (piping).\n Keep in mind though that if an intermediate output is in a\n single collection, no chunking can be done: only the first job of the pipeline can chunk\n its input.\n Hence, for performance, it makes sense that all intermediate jobs\n in the pipeline (except the last one, although not compulsory) output to automatically\n generated temporary collections rather than a single collection. That way, the next job\n can be executed on these collections in parallel.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Map jobs allow the parallel execution of \"simple\" FLWORs: a for on a big collection, let clauses,\n small for clauses, where clauses.\n Map-shuffle-map piping allows the parallel execution of FLWORs containing a group by clause.\n Jobs can be composed in many ways, for example map-map-shuffle-map-shuffle-map. This way,\n FLWORs with several group by clauses can be parallelized.\n In some circumstances, FLWORs with order by clauses (using bucket sort) can also be\n parallelized, but one should keep in mind that collections are not ordered so that\n any ordering within a map job is susceptible to be lost in the output.</p>\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Ghislain Fourny</xqdoc:author>", "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Julien Ribon</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "", "prefix" : "an" }, { "uri" : "http://www.28msec.com/modules/asynchronous-jobs", "prefix" : "job" }, { "uri" : "http://www.28msec.com/modules/parallelism", "prefix" : "parallel" }, { "uri" : "http://zorba.io/modules/random", "prefix" : "rand" }, { "uri" : "http://www.28msec.com/modules/store", "prefix" : "store" } ], "functions" : [ { "isDocumented" : true, "arity" : 1, "name" : "job-statuses", "qname" : "parallel:job-statuses", "signature" : "($id as xs:string) as object()?", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the statuses of the underlying asynchronous jobs, as an object\n indicating the number of chunks in each status.</p>\n", "summary" : "<p>  Returns the statuses of the underlying asynchronous jobs, as an object\n indicating the number of chunks in each status.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "id", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The id of the parallel job to query, as it was returned by map or shuffle.</div>" } ], "returns" : { "type" : "object()?", "description" : "The statuses of the underlying jobs. The empty sequence if the parallel job does not exist." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "map", "qname" : "parallel:map", "signature" : "($input as xs:string, $function as function (item()*) as item()*) as xs:string", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Schedules a parallel map job on a collection or on the output of another\n parallel job.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The name of the output collections are randomly generated (one for\n each chunk and start with <tt>_28.temporary</tt>.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example of usage:</p>\n parallel:map(\"input\", my:function#1)\n", "summary" : "<p>  Schedules a parallel map job on a collection or on the output of another\n parallel job.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "input", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The name of the collection to process, or the id of a parallel job of which the output will be taken.</div>" }, { "name" : "function", "type" : "function (item()*) as item()*", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the function which is run in parallel on the collection's contents.</div>" } ], "returns" : { "type" : "xs:string", "description" : "A parallel job id that can be used to query the parallel job's properties." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">job:JBDY0005 if the supplied function does not have a name.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">job:JBDY0006 if the supplied function is in the local namespace.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">job:JPDY0001 if the input is not an available collection or a parallel job id.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "map", "qname" : "parallel:map", "signature" : "($input as xs:string, $function as function (item()*) as item()*, $options as object()?) as xs:string", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Schedules a parallel map job on a collection or on the output of another\n parallel job.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The $options parameter allows for the specification of properties for\n the parallel job. Allowed options are:\n <ul>\n   <li><tt>output-collection as string</tt>: the name of the collection in\n     which the output of the executed query is stored. If not specified,\n     the result of the query will be stored in a collection withing the\n     MongoDB database associated with the project. The name of the\n     collection is randomly generated and starts with <tt>_28.temporary</tt>\n   </li>\n   <li><tt>chunk-size</tt>: the size of the chunks the collection must be split\n   into, if it is not already sharded (default: MongoDB sharding, or 1000).\n   </li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example of usage:</p>\n parallel:map(\"input\", my:function#1, { \"chunk-size\" : xs:int(1000) })\n parallel:map(\"input\",\n              my:function#1,\n              {\n                \"chunk-size\" : xs:int(1000),\n                \"output-collection\" : output\"\n              }\n )\n", "summary" : "<p>  Schedules a parallel map job on a collection or on the output of another\n parallel job.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "input", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The name of the collection to process, or the id of a parallel job of which the output will be taken.</div>" }, { "name" : "function", "type" : "function (item()*) as item()*", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The function which is run in parallel on the collection's contents.</div>" }, { "name" : "options", "type" : "object()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> An object specifying above options for the parallel job.</div>" } ], "returns" : { "type" : "xs:string", "description" : "A parallel job id that can be used to query the parallel job's properties." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">err:XPTY0004 if the type of a supplied option is incorrect.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">job:JBDY0005 if the supplied function does not have a name.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">job:JBDY0006 if the supplied function is in the local namespace.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">job:JPDY0001 if the input is not an available collection or a parallel job id.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "output-collections", "qname" : "parallel:output-collections", "signature" : "($id as xs:string) as xs:string*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the output collections of the specified parallel job.</p>\n", "summary" : "<p>  Returns the output collections of the specified parallel job.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "id", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The id of the parallel job to query, as it was returned by map or shuffle.</div>" } ], "returns" : { "type" : "xs:string*", "description" : "The names of the output collections to which the corresponding parallel job writes. The empty sequence if the job does not exist." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "results", "qname" : "parallel:results", "signature" : "($id as xs:string) as item()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the results of the specified parallel job.</p>\n", "summary" : "<p>  Returns the results of the specified parallel job.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "id", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The id of the parallel job to query, as it was returned by map or shuffle.</div>" } ], "returns" : { "type" : "item()*", "description" : "The structured items output by the corresponding parallel job. The empty sequence if the job does not exist." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "shuffle", "qname" : "parallel:shuffle", "signature" : "($input as xs:string, $function as function (item()) as xs:integer) as xs:string", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Schedules a parallel shuffle job on a collection or on the output of another\n parallel job.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The output collection for each item is determined by calling the shuffle function,\n which gives an integer i. The i-th output collection\n is then taken. If necessary, a modulo operation is done\n to make sure that the integer is comprised between 1 and the number of output collections.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The name of the output collections are randomly generated (10 of them) and\n start with <tt>_28.temporary</tt>.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example of usage:</p>\n parallel:shuffle(\"input\", my:function#1)\n", "summary" : "<p>  Schedules a parallel shuffle job on a collection or on the output of another\n parallel job.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "input", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The name of the collection to process, or the id of a parallel job of which the output will be taken.</div>" }, { "name" : "function", "type" : "function (item()) as xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the function which is run on each item to determine where it is shuffled to.</div>" } ], "returns" : { "type" : "xs:string", "description" : "A parallel job id that can be used to query the parallel job's properties." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">job:JBDY0005 if the supplied function does not have a name.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">job:JBDY0006 if the supplied function is in the local namespace.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">job:JPDY0001 if the input is not an available collection or a parallel job id.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "shuffle", "qname" : "parallel:shuffle", "signature" : "($input as item(), $function as function (item()) as xs:integer, $options as object()?) as xs:string", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Schedules a parallel shuffle job on a collection or on the output of another\n parallel job.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The output collection for each item is determined by calling the shuffle function,\n which gives an integer i. The i-th output collection\n is then taken. If necessary, a modulo operation is done\n to make sure that the integer is comprised between 1 and the number of output collections.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The $options parameter allows for the specification of properties for\n the parallel shuffle job. Allowed options are:\n <ul>\n   <li><tt>number-of-output-collections as integer</tt>: the number of output collections\n     to automatically generate if none are provided. The default value is 10. An error is raised\n     if the provided value is not positive.\n   </li>\n   <li><tt>output-collections as array</tt>: an array with the names of the collections in\n     which the items of the input collections are shuffled. If not specified,\n     these collections will be automatically generated (as many as specified in the\n     <tt>number-of-output-collections</tt> option) in the\n     MongoDB database associated with the project. The name of the\n     collections are randomly generated and start with <tt>_28.temporary</tt>\n   </li>\n   <li><tt>chunk-size</tt>: the size of the chunks the collection must be split\n   into, if it is not already sharded (default: MongoDB sharding, or 1000).\n   </li>\n </ul>\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example of usage:</p>\n parallel:shuffle(\"input\", my:function#1, { \"chunk-size\" : xs:int(1000) })\n parallel:shuffle(\"input\",\n                  my:function#1,\n                  {\n                    \"chunk-size\" : xs:int(1000),\n                    \"output-collections\" : [ \"output1\", \"output2\" ]\n                  }\n )\n parallel:shuffle(\"input\",\n                  my:function#1,\n                  {\n                    \"number-of-output-collections\" : 20\n                  }\n )\n", "summary" : "<p>  Schedules a parallel shuffle job on a collection or on the output of another\n parallel job.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "input", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The name of the collection to process, or the id of a parallel job of which the output will be taken.</div>" }, { "name" : "function", "type" : "function (item()) as xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the function which is run on each item to determine where it is shuffled to.</div>" }, { "name" : "options", "type" : "object()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> An object specifying above options for the parallel shuffle job.</div>" } ], "returns" : { "type" : "xs:string", "description" : "A parallel job id that can be used to query the parallel job's properties." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">err:XPTY0004 if the type of a supplied option is incorrect.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">job:JBDY0005 if the supplied function does not have a name.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">job:JBDY0006 if the supplied function is in the local namespace.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">job:JPDY0001 if the input is not an available collection or a parallel job id.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">err:FOCA0002 if number-of-output-collections is not a positive integer.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "status", "qname" : "parallel:status", "signature" : "($id as xs:string) as xs:string?", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the general status of the parallel job.</p>\n", "summary" : "<p>  Returns the general status of the parallel job.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "id", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> id of the parallel job to query, as it was returned by map or shuffle.</div>" } ], "returns" : { "type" : "xs:string?", "description" : "The status of the corresponding parallel job. The empty sequence if the job does not exist." }, "errors" : [  ] } ], "variables" : [  ] }, "http://www.zorba-xquery.com/modules/image/graphviz" : { "ns" : "http://www.zorba-xquery.com/modules/image/graphviz", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Module that provides functions for generating SVG graphs.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The module provides two function for generating graphs given in the :\n <ul><li>DOT language (see <a href=\"http://www.graphviz.org/\">\n http://www.graphviz.org</a>)</li><li>or in the XML-based Graph eXchange\n Language (see <a href=\"http://www.gupro.de/GXL/\">http://www.gupro.de/GXL/</a>),\n respectively.</li></ul>\n Both functions use the Graphviz Visualization Library in order to\n layout and render the graphs. As a result, both return a sequence\n of (document)-nodes (one for each input graph).\n These nodes are instances of the Scalable Vector Graphics (SVG) format.\n SVG is a language for describing two-dimensional graphics and\n graphical applications in XML. More information about SVG can\n be found at <a href=\"http://www.w3.org/Graphics/SVG/\">http://www.w3.org/Graphics/SVG/</a>.\n As second parameters, both functions take a sequence of strings that\n are parameters for the graph generation and rendering algorithms.\n Currently, only the empty-sequence is allowed here.\n These parameters exist for future use.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Please note that this feature is only available on Unix-based\n platforms (i.e. not on Windows).</p>\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"><a href=\"http://www.28msec.com/home/index\">28msec</a></xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://www.zorba-xquery.com/modules/image/graphviz", "prefix" : "gr" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 2, "name" : "dot", "qname" : "gr:dot", "signature" : "($dot as xs:string*, $params as xs:string*) as node()* external", "description" : " Layout one ore more graphs given in the DOT language and render\n them as SVG. For example,\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"><code>\n dot(\"digraph mygraph { p -&gt; q }\", ())\n </code></p>\n", "summary" : "<p> Layout one ore more graphs given in the DOT language and render\n them as SVG.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "dot", "type" : "xs:string", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> A dot description of the graph to render.</div>" }, { "name" : "params", "type" : "xs:string", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> Parameters to configure the layout and rendering process. Currently, only the empty-sequence is allowed here.</div>" } ], "returns" : { "type" : "node()*", "description" : "A graph for each item in the sequence given using the first parameter. The result sequence consists of items which are instance of the SVG data model." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "gxl", "qname" : "gr:gxl", "signature" : "($gxl as node()*, $params as xs:string*) as node()* external", "description" : " Layout one ore more graphs given in the GXL language and render\n them as SVG.\n", "summary" : "<p> Layout one ore more graphs given in the GXL language and render\n them as SVG.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "gxl", "type" : "node()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> A GXL description of the graph to render.</div>" }, { "name" : "params", "type" : "xs:string", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> Parameters to configure the layout and rendering process. Currently, only the empty-sequence is allowed here.</div>" } ], "returns" : { "type" : "node()*", "description" : "A graph for each item in the sequence given using the first parameter. The result sequence consists of items which are instance of the SVG data model." }, "errors" : [  ] } ], "variables" : [  ] }, "http://zorba.io/modules/data-cleaning/token-based-string-similarity" : { "ns" : "http://zorba.io/modules/data-cleaning/token-based-string-similarity", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This library module provides token-based string similarity functions that view strings\n as sets or multi-sets of tokens and use set-related properties to compute similarity scores.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The tokens correspond to groups of characters extracted from the strings being compared, such as\n individual words or character n-grams.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">These functions are particularly useful for matching near duplicate strings in cases where\n typographical conventions often lead to rearrangement of words (e.g., \"John Smith\" versus \"Smith, John\").</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The logic contained in this module is not specific to any particular XQuery implementation,\n although the module requires the trigonometic functions of XQuery 3.0 or a math extension\n function such as sqrt($x as numeric) for computing the square root.</p>\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Bruno Martins</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://www.w3.org/2005/xpath-functions/math", "prefix" : "math" }, { "uri" : "http://zorba.io/modules/data-cleaning/set-similarity", "prefix" : "set" }, { "uri" : "http://zorba.io/modules/data-cleaning/token-based-string-similarity", "prefix" : "simt" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 3, "name" : "cosine-ngrams", "qname" : "simt:cosine-ngrams", "signature" : "($s1 as xs:string, $s2 as xs:string, $n as xs:integer) as xs:double", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the cosine similarity coefficient between sets of character n-grams extracted from two strings.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The n-grams from each string are weighted according to their occurence frequency (i.e., weighted according to\n the term-frequency heuristic from Information Retrieval).</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example usage : <pre class=\"ace-static\" ace-mode=\"xquery\"> cosine-ngrams(\"DWAYNE\", \"DUANE\", 2 ) </pre></p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The function invocation in the example above returns : <pre class=\"ace-static\" ace-mode=\"xquery\"> 0.2401922307076307 </pre></p>\n", "summary" : "<p>  Returns the cosine similarity coefficient between sets of character n-grams extracted from two strings.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "s1", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The first string.</div>" }, { "name" : "s2", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The second string.</div>" }, { "name" : "n", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The number of characters to consider when extracting n-grams.</div>" } ], "returns" : { "type" : "xs:double", "description" : "The cosine similarity coefficient between the sets n-grams extracted from the two strings." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 3, "name" : "cosine-tokens", "qname" : "simt:cosine-tokens", "signature" : "($s1 as xs:string, $s2 as xs:string, $r as xs:string) as xs:double", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the cosine similarity coefficient between sets of tokens extracted from two strings. The tokens\n from each string are weighted according to their occurence frequency (i.e., weighted according to the\n term-frequency heuristic from Information Retrieval).</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example usage : <pre class=\"ace-static\" ace-mode=\"xquery\"> cosine-tokens(\"The FLWOR Foundation\", \"FLWOR Found.\", \" +\" ) </pre></p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The function invocation in the example above returns : <pre class=\"ace-static\" ace-mode=\"xquery\"> 0.408248290463863 </pre></p>\n", "summary" : "<p>  Returns the cosine similarity coefficient between sets of tokens extracted from two strings.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "s1", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The first string.</div>" }, { "name" : "s2", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The second string.</div>" }, { "name" : "r", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> A regular expression forming the delimiter character(s) which mark the boundaries between adjacent tokens.</div>" } ], "returns" : { "type" : "xs:double", "description" : "The cosine similarity coefficient between the sets tokens extracted from the two strings." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "cosine", "qname" : "simt:cosine", "signature" : "($desc1 as xs:string*, $desc2 as xs:string*) as xs:double", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Auxiliary function for computing the cosine similarity coefficient between strings,\n using stringdescriptors based on sets of character n-grams or sets of tokens extracted from two strings.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example usage : <pre class=\"ace-static\" ace-mode=\"xquery\"> cosine( (\"aa\",\"bb\") , (\"bb\",\"aa\")) </pre></p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The function invocation in the example above returns : <pre class=\"ace-static\" ace-mode=\"xquery\"> 1.0 </pre></p>\n", "summary" : "<p>  Auxiliary function for computing the cosine similarity coefficient between strings,\n using stringdescriptors based on sets of character n-grams or sets of tokens extracted from two strings.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "desc1", "type" : "xs:string", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The descriptor for the first string.</div>" }, { "name" : "desc2", "type" : "xs:string", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The descriptor for the second string.</div>" } ], "returns" : { "type" : "xs:double", "description" : "The cosine similarity coefficient between the descriptors for the two strings." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 3, "name" : "dice-ngrams", "qname" : "simt:dice-ngrams", "signature" : "($s1 as xs:string, $s2 as xs:string, $n as xs:integer) as xs:double", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the Dice similarity coefficient between sets of character n-grams extracted from two strings.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example usage : <pre class=\"ace-static\" ace-mode=\"xquery\"> dice-ngrams(\"DWAYNE\", \"DUANE\", 2 ) </pre></p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The function invocation in the example above returns : <pre class=\"ace-static\" ace-mode=\"xquery\"> 0.4615384615384616 </pre></p>\n", "summary" : "<p>  Returns the Dice similarity coefficient between sets of character n-grams extracted from two strings.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "s1", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The first string.</div>" }, { "name" : "s2", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The second string.</div>" }, { "name" : "n", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The number of characters to consider when extracting n-grams.</div>" } ], "returns" : { "type" : "xs:double", "description" : "The Dice similarity coefficient between the sets of character n-grams extracted from the two strings." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 3, "name" : "dice-tokens", "qname" : "simt:dice-tokens", "signature" : "($s1 as xs:string, $s2 as xs:string, $r as xs:string) as xs:double", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the Dice similarity coefficient between sets of tokens extracted from two strings.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example usage : <pre class=\"ace-static\" ace-mode=\"xquery\"> dice-tokens(\"The FLWOR Foundation\", \"FLWOR Found.\", \" +\" ) </pre></p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The function invocation in the example above returns : <pre class=\"ace-static\" ace-mode=\"xquery\"> 0.4 </pre></p>\n", "summary" : "<p>  Returns the Dice similarity coefficient between sets of tokens extracted from two strings.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "s1", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The first string.</div>" }, { "name" : "s2", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The second string.</div>" }, { "name" : "r", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> A regular expression forming the delimiter character(s) which mark the boundaries between adjacent tokens.</div>" } ], "returns" : { "type" : "xs:double", "description" : "The Dice similarity coefficient between the sets tokens extracted from the two strings." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 3, "name" : "jaccard-ngrams", "qname" : "simt:jaccard-ngrams", "signature" : "($s1 as xs:string, $s2 as xs:string, $n as xs:integer) as xs:double", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the Jaccard similarity coefficient between sets of character n-grams extracted from two strings.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example usage : <pre class=\"ace-static\" ace-mode=\"xquery\"> jaccard-ngrams(\"DWAYNE\", \"DUANE\", 2 ) </pre></p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The function invocation in the example above returns : <pre class=\"ace-static\" ace-mode=\"xquery\"> 0.3 </pre></p>\n", "summary" : "<p>  Returns the Jaccard similarity coefficient between sets of character n-grams extracted from two strings.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "s1", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The first string.</div>" }, { "name" : "s2", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The second string.</div>" }, { "name" : "n", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The number of characters to consider when extracting n-grams.</div>" } ], "returns" : { "type" : "xs:double", "description" : "The Jaccard similarity coefficient between the sets of character n-grams extracted from the two strings." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 3, "name" : "jaccard-tokens", "qname" : "simt:jaccard-tokens", "signature" : "($s1 as xs:string, $s2 as xs:string, $r as xs:string) as xs:double", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the Jaccard similarity coefficient between sets of tokens extracted from two strings.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example usage : <pre class=\"ace-static\" ace-mode=\"xquery\"> jaccard-tokens(\"The FLWOR Foundation\", \"FLWOR Found.\", \" +\" ) </pre></p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The function invocation in the example above returns : <pre class=\"ace-static\" ace-mode=\"xquery\"> 0.25 </pre></p>\n", "summary" : "<p>  Returns the Jaccard similarity coefficient between sets of tokens extracted from two strings.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "s1", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The first string.</div>" }, { "name" : "s2", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The second string.</div>" }, { "name" : "r", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> A regular expression forming the delimiter character(s) which mark the boundaries between adjacent tokens.</div>" } ], "returns" : { "type" : "xs:double", "description" : "The Jaccard similarity coefficient between the sets tokens extracted from the two strings." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "ngrams", "qname" : "simt:ngrams", "signature" : "($s as xs:string, $n as xs:integer) as xs:string*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the individual character n-grams forming a string.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example usage : <pre class=\"ace-static\" ace-mode=\"xquery\"> ngrams(\"FLWOR\", 2 ) </pre></p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The function invocation in the example above returns : <pre class=\"ace-static\" ace-mode=\"xquery\"> (\"_F\" , \"FL\" , \"LW\" , \"WO\" , \"LW\" , \"WO\" , \"OR\" , \"R_\") </pre></p>\n", "summary" : "<p>  Returns the individual character n-grams forming a string.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "s", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The input string.</div>" }, { "name" : "n", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The number of characters to consider when extracting n-grams.</div>" } ], "returns" : { "type" : "xs:string*", "description" : "The sequence of strings with the extracted n-grams." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 3, "name" : "overlap-ngrams", "qname" : "simt:overlap-ngrams", "signature" : "($s1 as xs:string, $s2 as xs:string, $n as xs:integer) as xs:double", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the overlap similarity coefficient between sets of character n-grams extracted from two strings.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example usage : <pre class=\"ace-static\" ace-mode=\"xquery\"> overlap-ngrams(\"DWAYNE\", \"DUANE\", 2 ) </pre></p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The function invocation in the example above returns : <pre class=\"ace-static\" ace-mode=\"xquery\"> 0.5 </pre></p>\n", "summary" : "<p>  Returns the overlap similarity coefficient between sets of character n-grams extracted from two strings.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "s1", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The first string.</div>" }, { "name" : "s2", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The second string.</div>" }, { "name" : "n", "type" : "xs:integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The number of characters to consider when extracting n-grams.</div>" } ], "returns" : { "type" : "xs:double", "description" : "The overlap similarity coefficient between the sets of character n-grams extracted from the two strings." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 3, "name" : "overlap-tokens", "qname" : "simt:overlap-tokens", "signature" : "($s1 as xs:string, $s2 as xs:string, $r as xs:string) as xs:double", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the overlap similarity coefficient between sets of tokens extracted from two strings.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example usage : <pre class=\"ace-static\" ace-mode=\"xquery\"> overlap-tokens(\"The FLWOR Foundation\", \"FLWOR Found.\", \" +\" ) </pre></p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The function invocation in the example above returns : <pre class=\"ace-static\" ace-mode=\"xquery\"> 0.5 </pre></p>\n", "summary" : "<p>  Returns the overlap similarity coefficient between sets of tokens extracted from two strings.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "s1", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The first string.</div>" }, { "name" : "s2", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The second string.</div>" }, { "name" : "r", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> A regular expression forming the delimiter character(s) which mark the boundaries between adjacent tokens.</div>" } ], "returns" : { "type" : "xs:double", "description" : "The overlap similarity coefficient between the sets tokens extracted from the two strings." }, "errors" : [  ] } ], "variables" : [  ] }, "http://www.zorba-xquery.com/modules/image/paint" : { "ns" : "http://www.zorba-xquery.com/modules/image/paint", "description" : " This module provides a function to extend an image with additional shapes.\n Fully supported image formats are:\n <ul xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n   <li>GIF</li>\n   <li>JPEG</li>\n   <li>PNG</li>\n   <li>TIFF</li>\n   <li>BMP</li>\n </ul>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The errors raised by functions of this module have the namespace\n <tt>http://www.zorba-xquery.com/modules/image/error</tt> (associated with prefix ierr).</p>\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Daniel Thomas</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://www.w3.org/2005/xqt-errors", "prefix" : "err" }, { "uri" : "http://www.zorba-xquery.com/modules/image/error", "prefix" : "ierr" }, { "uri" : "http://www.zorba-xquery.com/modules/image/image", "prefix" : "img" }, { "uri" : "http://www.zorba-xquery.com/modules/image/paint", "prefix" : "paint" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 2, "name" : "paint", "qname" : "paint:paint", "signature" : "($image as xs:base64Binary, $shapes as element(*)*) as xs:base64Binary", "description" : " Extends the passed image with a sequence of shapes.\n The shapes are passed as a sequence of elements.\n The possibilities for shape elements are:\n    <ul xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n      <li> line:\n        <pre class=\"brush: xml\">\n          &lt;img:line&gt;\n            &lt;img:start&gt;&lt;img:x&gt;-20&lt;/img:x&gt;&lt;img:y&gt;-20&lt;/img:y&gt;&lt;/img:start&gt;\n            &lt;img:end&gt;&lt;img:x&gt;80&lt;/img:x&gt;&lt;img:y&gt;80&lt;/img:y&gt;&lt;/img:end&gt;\n          &lt;/img:line&gt;</pre>\n      </li>\n       <li> polyline:\n         <pre class=\"brush: xml\">\n           &lt;img:polyLine&gt;\n             &lt;img:point&gt;&lt;img:x&gt;10&lt;/img:x&gt;&lt;img:y&gt;10&lt;/img:y&gt;&lt;/img:point&gt;\n             &lt;img:point&gt;&lt;img:x&gt;40&lt;/img:x&gt;&lt;img:y&gt;80&lt;/img:y&gt;&lt;/point&gt;\n             &lt;img:point&gt;&lt;img:x&gt;50&lt;/img:x&gt;&lt;img:y&gt;30&lt;/img:y&gt;&lt;/point&gt;\n             &lt;img:point&gt;&lt;img:x&gt;200&lt;/img:x&gt;&lt;img:y&gt;200&lt;/img:y&gt;&lt;/point&gt;\n           &lt;/img:polyLine&gt;\n         </pre>\n       </li>\n       <li> stroked polyline:\n         <pre class=\"brush: xml\">\n           &lt;img:strokedPolyLine&gt;\n             &lt;img:point&gt;&lt;img:x&gt;10&lt;/img:x&gt;&lt;img:y&gt;10&lt;/img:y&gt;&lt;/img:point&gt;\n             &lt;img:point&gt;&lt;img:x&gt;40&lt;/img:x&gt;&lt;img:y&gt;80&lt;/img:y&gt;&lt;/img:point&gt;\n             &lt;img:point&gt;&lt;img:x&gt;50&lt;/img:x&gt;&lt;img:y&gt;30&lt;/img:y&gt;&lt;/img:point&gt;\n             &lt;img:strokeLength&gt;5&lt;/img:strokeLength&gt;&lt;img:gapLength&gt;2&lt;/img:gapLength&gt;\n           &lt;/img:strokedPolyLine&gt;\n         </pre>\n       </li>\n       <li> rectangle:\n         <pre class=\"brush: xml\">\n           &lt;img:rectangle&gt;\n             &lt;img:upperLeft&gt;&lt;img:x&gt;20&lt;/img:x&gt;&lt;img:y&gt;20&lt;/img:y&gt;&lt;/img:upperLeft&gt;\n             &lt;img:lowerRight&gt;&lt;img:x&gt;50&lt;/img:x&gt;&lt;img:y&gt;50&lt;/img:y&gt;&lt;/img:lowerRight&gt;\n           &lt;/img:rectangle&gt;\n         </pre>\n       </li>\n       <li> rounded rectangle:\n         <pre class=\"brush: xml\">\n           &lt;img:roundedRectangle&gt;\n             &lt;img:upperLeft&gt;&lt;img:x&gt;20&lt;/img:x&gt;&lt;img:y&gt;20&lt;/img:y&gt;&lt;/img:upperLeft&gt;\n             &lt;img:lowerRight&gt;&lt;img:x&gt;50&lt;/img:x&gt;&lt;img:y&gt;50&lt;/img:y&gt;&lt;/img:lowerRight&gt;\n             &lt;img:cornerWidth&gt;10&lt;/img:cornerWidth&gt;&lt;img:cornerHeight&gt;10&lt;/img:cornerHeight&gt;\n           &lt;/img:roundedRectangle&gt;\n         </pre>\n       </li>\n       <li> circle:\n         <pre class=\"brush: xml\">\n           &lt;img:circle&gt;\n             &lt;img:origin&gt;&lt;img:x&gt;20&lt;/img:x&gt;&lt;img:y&gt;20&lt;/img:y&gt;&lt;/img:origin&gt;\n             &lt;img:perimeter&gt;5&lt;/img:perimeter&gt;\n           &lt;/img:circle&gt;\n         </pre>\n       </li>\n       <li> ellipse:\n         <pre class=\"brush: xml\">\n           &lt;img:ellipse&gt;\n             &lt;img:origin&gt;&lt;img:x&gt;50&lt;/img:x&gt;&lt;img:y&gt;50&lt;/img:y&gt;&lt;/img:origin&gt;\n             &lt;img:perimeterX&gt;30&lt;/img:perimeterX&gt;&lt;img:perimeterY&gt;20&lt;/img:perimeterY&gt;\n           &lt;/img:ellipse&gt;\n         </pre>\n       </li>\n       <li> arc:\n         <pre class=\"brush: xml\">\n           &lt;img:arc&gt;\n             &lt;img:origin&gt;&lt;img:x&gt;50&lt;/img:x&gt;&lt;img:y&gt;50&lt;/img:y&gt;&lt;/img:origin&gt;\n             &lt;img:perimeterX&gt;10&lt;/img:perimeterX&gt;&lt;img:perimeterY&gt;20&lt;/img:perimeterY&gt;\n             &lt;img:startDegrees&gt;180&lt;/img:startDegrees&gt;&lt;img:endDegrees&gt;270&lt;/img:endDegrees&gt;\n           &lt;/img:arc&gt;\n         </pre>\n       </li>\n       <li> polygon:\n         <pre class=\"brush: xml\">\n           &lt;img:polygon&gt;\n             &lt;img:point&gt;&lt;img:x&gt;10&lt;/img:x&gt;&lt;img:y&gt;10&lt;/img:y&gt;&lt;/img:point&gt;\n             &lt;img:point&gt;&lt;img:x&gt;40&lt;/img:x&gt;&lt;img:y&gt;80&lt;/img:y&gt;&lt;/img:point&gt;\n             &lt;img:point&gt;&lt;img:x&gt;50&lt;/img:x&gt;&lt;img:y&gt;30&lt;/img:y&gt;&lt;/img:point&gt;\n           &lt;/img:polygon&gt;\n         </pre>\n       </li>\n       <li> text:\n         <pre class=\"brush: xml\">\n           &lt;img:text&gt;\n             &lt;img:origin&gt;&lt;img:x&gt;20&lt;/img:x&gt;&lt;img:y&gt;20&lt;/img:y&gt;&lt;/img:origin&gt;\n             &lt;img:text&gt;Hello Zorba&lt;/img:text&gt;&lt;img:font&gt;&lt;/img:font&gt;&lt;img:font-size&gt;12&lt;/img:font-size&gt;\n           &lt;/img:text&gt;\n         </pre>\n       </li>\n     </ul>\n Optionally, each of the shape elements can contain elements to define the stroke with, stroke color, fill color, and anti-aliasing.\n E.g.:\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n   <pre class=\"brush: xml\">\n     &lt;img:rectangle&gt;\n       &lt;img:strokeWidth&gt;5&lt;/img:strokeWidth&gt;\n       &lt;img:strokeColor&gt;#00AF00&lt;/img:strokeColor&gt;\n       &lt;img:fillColor&gt;#A10000&lt;/img:fillColor&gt;\n       &lt;img:antiAliasing&gt;true&lt;/img:antiAliasing&gt;\n       &lt;img:upperLeft&gt;&lt;img:x&gt;20&lt;/img:x&gt;&lt;img:y&gt;20&lt;/img:y&gt;&lt;/img:upperLeft&gt;\n       &lt;img:lowerRight&gt;&lt;img:x&gt;50&lt;/img:x&gt;&lt;img:y&gt;50&lt;/img:y&gt;&lt;/img:lowerRight&gt;\n     &lt;/img:rectangle&gt;\n   </pre>\n  </p>\n", "summary" : "<p> Extends the passed image with a sequence of shapes.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "image", "type" : "xs:base64Binary", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the passed image</div>" }, { "name" : "shapes", "type" : "element(*)", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the shapes</div>" } ], "returns" : { "type" : "xs:base64Binary", "description" : "image with additional shapes" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">ierr:IM001 the passed image is invalid.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">err:FORG0001 one of the passed shape elements is invalid.</xqdoc:error>" ] } ], "variables" : [  ] }, "http://zorba.io/modules/fetch" : { "ns" : "http://zorba.io/modules/fetch", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This module provides functions to fetch the content of a resource identified\n by a URI. For example, it fetches the content of file or http resources.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">In order to retrieve such content, the functions use the\n URI resolution and URL resolver process as documented at\n <a href=\"../zorba/uriresolvers.html\">\n URI Resolvers</a>.</p>\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Matthias Brantner</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://zorba.io/annotations", "prefix" : "an" }, { "uri" : "http://zorba.io/modules/fetch", "prefix" : "fetch" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" }, { "uri" : "http://zorba.io/errors", "prefix" : "zerr" } ], "functions" : [ { "isDocumented" : true, "arity" : 1, "name" : "content-binary", "qname" : "fetch:content-binary", "signature" : "($uri as xs:string) as xs:base64Binary", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Tries to fetch the resource referred to by the given URI and\n returning it as base64Binary.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">It queries all URI mappers and resolvers with kind\n <tt>EntityData::SOME_CONTENT</tt>.</p>\n", "summary" : "<p>  Tries to fetch the resource referred to by the given URI and\n returning it as base64Binary.</p>", "annotation_str" : " %an:streamable", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "streamable", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "uri", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the resource to fetch.</div>" } ], "returns" : { "type" : "xs:base64Binary", "description" : "the resource referred to by the given URI as streamble base64Binary." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">uri:URI_UNRESOLVED_OR_NOSTREAM if the URI could not be resolved or did not resolve to a <tt>StreamResource</tt>.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "content-binary", "qname" : "fetch:content-binary", "signature" : "($uri as xs:string, $entity-kind as xs:string) as xs:base64Binary external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Tries to fetch the resource referred to by the given URI and\n returning it as base64Binary.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">It queries all URI mappers and resolvers with kind the specified\n entity kind.</p>\n", "summary" : "<p>  Tries to fetch the resource referred to by the given URI and\n returning it as base64Binary.</p>", "annotation_str" : " %an:streamable", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "streamable", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "uri", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the resource to fetch.</div>" }, { "name" : "entity-kind", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the kind of resource to fetch.</div>" } ], "returns" : { "type" : "xs:base64Binary", "description" : "the resource referred to by the given URI as streamble base64Binary." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">uri:URI_UNRESOLVED_OR_NOSTREAM if the URI could not be resolved or did not resolve to a <tt>StreamResource</tt>.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "content", "qname" : "fetch:content", "signature" : "($uri as xs:string) as xs:string", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Tries to fetch the resource referred to by the given URI.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">It queries all URI mappers and resolvers with kind\n <tt>EntityData::SOME_CONTENT</tt>.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The content is assumed to be UTF-8 encoded.</p>\n", "summary" : "<p>  Tries to fetch the resource referred to by the given URI.</p>", "annotation_str" : " %an:streamable", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "streamable", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "uri", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the resource to fetch.</div>" } ], "returns" : { "type" : "xs:string", "description" : "the resource referred to by the given URI as streamble string." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">uri:URI_UNRESOLVED_OR_NOSTREAM if the URI could not be resolved or did not resolve to a <tt>StreamResource</tt>.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "content", "qname" : "fetch:content", "signature" : "($uri as xs:string, $entity-kind as xs:string) as xs:string", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Tries to fetch the resource referred to by the given URI.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">It queries all URI mappers and resolvers with kind the specified\n entity kind.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The content is assumed to be UTF-8 encoded.</p>\n", "summary" : "<p>  Tries to fetch the resource referred to by the given URI.</p>", "annotation_str" : " %an:streamable", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "streamable", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "uri", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the resource to fetch.</div>" }, { "name" : "entity-kind", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the kind of resource to fetch.</div>" } ], "returns" : { "type" : "xs:string", "description" : "the resource referred to by the given URI as streamble string." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">uri:URI_NOT_RESOLVED_OR_NOSTREAM if the URI could not be resolved or did not resolve to a <tt>StreamResource</tt>.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "content", "qname" : "fetch:content", "signature" : "($uri as xs:string, $entity-kind as xs:string, $encoding as xs:string) as xs:string external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Tries to fetch the resource referred to by the given URI.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">It queries all URI mappers and resolvers with kind the specified\n entity kind.</p>\n", "summary" : "<p>  Tries to fetch the resource referred to by the given URI.</p>", "annotation_str" : " %an:streamable", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "streamable", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "uri", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the resource to fetch.</div>" }, { "name" : "entity-kind", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the kind of resource to fetch.</div>" }, { "name" : "encoding", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the encoding of the content</div>" } ], "returns" : { "type" : "xs:string", "description" : "the resource referred to by the given URI as streamble string." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">uri:URI_UNRESOLVED_OR_NOSTREAM if the URI could not be resolved or did not resolve to a <tt>StreamResource</tt>.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">uri:CHARSET_UNKNOWN if the given encoding is invalid or not supported.</xqdoc:error>" ] } ], "variables" : [  ] }, "http://xbrl.io/modules/bizql/concept-maps" : { "ns" : "http://xbrl.io/modules/bizql/concept-maps", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This module provides functions for storing, retrieving, and modifying\n concept maps. Concept maps can be used in BizQL queries.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">A concept map is a network of concepts that can be contained in a report schema.\n It maps \"virtual\" concepts to reported concepts, which allows comparison across\n archives that use different vocabularies (so-called extension facts).</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">With this module, you can retrieve the concept map associated with each report\n schema. You can also query for facts by making implicitly use of the mapping.</p>\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Charles Hoffman</xqdoc:author>", "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Matthias Brantner</xqdoc:author>", "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Dennis Knochenwefel</xqdoc:author>", "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Ghislain Fourny</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://xbrl.io/modules/bizql/archives", "prefix" : "archives" }, { "uri" : "http://xbrl.io/modules/bizql/concept-maps", "prefix" : "concept-maps" }, { "uri" : "http://xbrl.io/modules/bizql/facts", "prefix" : "facts" }, { "uri" : "http://xbrl.io/modules/bizql/networks", "prefix" : "networks" }, { "uri" : "http://xbrl.io/modules/bizql/report-schemas", "prefix" : "report-schemas" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 0, "name" : "concept-maps", "qname" : "concept-maps:concept-maps", "signature" : "() as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves all concept maps.</p>\n", "summary" : "<p>  Retrieves all concept maps.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "object()*", "description" : "all concept maps." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "concept-maps", "qname" : "concept-maps:concept-maps", "signature" : "($report-schemas-or-ids as item()*) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Return the concept maps from the given report schemas.</p>\n", "summary" : "<p>  Return the concept maps from the given report schemas.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "report-schemas-or-ids", "type" : "item()", "occurrence" : "*", "description" : "" } ], "returns" : { "type" : "object()*", "description" : "the concept maps from the report schemas." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 3, "name" : "facts-for-archives-and-concepts", "qname" : "concept-maps:facts-for-archives-and-concepts", "signature" : "($archive-or-ids as item()*, $concepts as string*, $concept-maps as object()*) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Resolves the supplied concepts according to the supplied concept map.</p>\n", "summary" : "<p>  Resolves the supplied concepts according to the supplied concept map.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "archive-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of archives or AIDs (or $concept-maps:ALL_OF_THEM to do no filter on archives).</div>" }, { "name" : "concepts", "type" : "string", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of concept names (or $concept-maps:ALL_OF_THEM to do no filter on concepts).</div>" }, { "name" : "concept-maps", "type" : "object()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of concept maps.</div>" } ], "returns" : { "type" : "object()*", "description" : "the resolved facts, with the concept name overriden with the new name." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 4, "name" : "facts-for-archives-and-concepts", "qname" : "concept-maps:facts-for-archives-and-concepts", "signature" : "($archive-or-ids as item()*, $concepts as string*, $concept-maps as object()+, $options as object()?) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Resolves the supplied concepts according to the supplied concept map.</p>\n", "summary" : "<p>  Resolves the supplied concepts according to the supplied concept map.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "archive-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of archives or AIDs (or $concept-maps:ALL_OF_THEM to do no filter on archives).</div>" }, { "name" : "concepts", "type" : "string", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of concept names (or $concept-maps:ALL_OF_THEM to do no filter on concepts).</div>" }, { "name" : "concept-maps", "type" : "object()", "occurrence" : "+", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of concept maps.</div>" }, { "name" : "options", "type" : "object()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> <a href=\"facts#standard_options\">standard fact retrieving options</a>.</div>" } ], "returns" : { "type" : "object()*", "description" : "the resolved facts, with the concept name overriden with the new name." }, "errors" : [  ] } ], "variables" : [ { "name" : "concept-maps:ALL_OF_THEM", "type" : "boolean", "description" : " Joker for all archives or all concepts.\n" } ] }, "http://www.28msec.com/modules/http/cookie" : { "ns" : "http://www.28msec.com/modules/http/cookie", "description" : " The Sausalito Cookie module provides function to manipulate\n HTTP-Cookies.\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">28msec</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://zorba.io/annotations", "prefix" : "an" }, { "uri" : "http://www.28msec.com/modules/http/cookie", "prefix" : "cookie" }, { "uri" : "http://www.28msec.com/modules/http/cookie", "prefix" : "cookie-schema" }, { "uri" : "http://www.28msec.com/modules/http/request", "prefix" : "req" }, { "uri" : "http://www.28msec.com/modules/http/response", "prefix" : "resp" }, { "uri" : "http://zorba.io/modules/schema", "prefix" : "schema" }, { "uri" : "http://www.zorba-xquery.com/modules/cryptography/hmac", "prefix" : "sec" }, { "uri" : "http://zorba.io/modules/uri", "prefix" : "uri" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 1, "name" : "create-session", "qname" : "cookie:create-session", "signature" : "($sessionData as node()) as empty-sequence()", "description" : " Creates a client-side cookie named \"_session\", containing the\n <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$sessionData</tt> node value together with its signature.\n The signature is generated with the server's private key.\n", "summary" : "<p> Creates a client-side cookie named \"_session\", containing the\n  $sessionData  node value together with its signature.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "sessionData", "type" : "node()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The data to be used for the session.</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "The empty-sequence is returned." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "create-session", "qname" : "cookie:create-session", "signature" : "($sessionData as node(), $expires as xs:dateTime) as empty-sequence()", "description" : " Creates a client-side cookie named \"_session\", containing the\n <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$sessionData</tt> node value together with its signature.\n The signature is generated with the server's private key.\n The cookie is also set to expire on the date specified by\n <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$expires</tt>.\n", "summary" : "<p> Creates a client-side cookie named \"_session\", containing the\n  $sessionData  node value together with its signature.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "sessionData", "type" : "node()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The data to be used for the session.</div>" }, { "name" : "expires", "type" : "xs:dateTime", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The expiration time of the cookie.</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "The empty-sequence is returned." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 3, "name" : "create-session", "qname" : "cookie:create-session", "signature" : "($sessionData as node(), $expires as xs:dateTime?, $path as xs:string?) as empty-sequence()", "description" : " Creates a client-side cookie named \"_session\", containing the\n <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$sessionData</tt> node value together with its signature.\n The signature is generated with the server's private key.\n The cookie is also set to expire on the date specified by\n <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$expires</tt>. The cookie is only valid for the specified path.\n", "summary" : "<p> Creates a client-side cookie named \"_session\", containing the\n  $sessionData  node value together with its signature.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "sessionData", "type" : "node()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The data to be used for the session.</div>" }, { "name" : "expires", "type" : "xs:dateTime", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The expiration time of the cookie.</div>" }, { "name" : "path", "type" : "xs:string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The path of the URL for which the cookie is valid.</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "The empty-sequence is returned." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "delete-session", "qname" : "cookie:delete-session", "signature" : "() as empty-sequence()", "description" : " Delete the \"_session\" cookie from the client. The next\n user request will not receive a valid session cookie\n anymore\n", "summary" : "<p> Delete the \"_session\" cookie from the client.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "empty-sequence()", "description" : "The empty-sequence is returned." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "delete-session", "qname" : "cookie:delete-session", "signature" : "($path as xs:string?) as empty-sequence()", "description" : " Delete the \"_session\" cookie from the client. The next\n user request will not receive a valid session cookie\n anymore\n", "summary" : "<p> Delete the \"_session\" cookie from the client.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "path", "type" : "xs:string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The path of the URL for which the cookie is valid.</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "The empty-sequence is returned." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "get", "qname" : "cookie:get", "signature" : "($name as xs:string?) as element(cookie:cookie)*", "description" : " Returns the cookie in the request having the given name or the empty sequence\n if no such cookie exists. The cookie format returned is:\n <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n &lt;cookie:cookie\n   name=\"..\"&gt;...&lt;/cookie:cookie&gt;</tt>.\n The content of the cookie element is the value of the cookie.\n", "summary" : "<p> Returns the cookie in the request having the given name or the empty sequence\n if no such cookie exists.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "name", "type" : "xs:string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The name of the cookie that should be retrieved.</div>" } ], "returns" : { "type" : "element(cookie:cookie)*", "description" : "The cookie with the given name or the empty sequence if no cookie with the given name exist" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">cookie:S003 if $decode evaluates to fn:true() and the value of the cookie cannot be parsed.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "get", "qname" : "cookie:get", "signature" : "($name as xs:string?, $decode as xs:boolean) as element(cookie:cookie)*", "description" : " Returns the cookies in the request having the given name. If no name is given,\n it returns all available cookies. If no cookie value decoding is wanted,\n the user must specify a second argument that evaluates to fn:false().\n", "summary" : "<p> Returns the cookies in the request having the given name.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "name", "type" : "xs:string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The name of the cookie that should be retrieved</div>" }, { "name" : "decode", "type" : "xs:boolean", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> Boolean to specify if cookie value decoding id needed</div>" } ], "returns" : { "type" : "element(cookie:cookie)*", "description" : "The cookie with the given name or the empty sequence if no cookie with the given name exist" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">cookie:S003 if $decode evaluates to fn:true() and the value of the cookie cannot be parsed.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 0, "name" : "session-data", "qname" : "cookie:session-data", "signature" : "() as node()", "description" : " Reads the \"_session\" cookie in the request and verifies if the signature\n matches the ad-hoc computed signature of the content of the session. If the\n verification is successful, the function returns the session data. Otherwise,\n an error is raised.\n", "summary" : "<p> Reads the \"_session\" cookie in the request and verifies if the signature\n matches the ad-hoc computed signature of the content of the session.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "node()", "description" : "The session data is returned if verification succesful." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "set", "qname" : "cookie:set", "signature" : "($cookie as element(cookie:cookie)) as empty-sequence()", "description" : " Adds a <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Set-Cookie</tt> header to the response. This function is equivalent to\n <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">cookie:set($cookie, fn:true())</tt>.\n", "summary" : "<p> Adds a  Set-Cookie  header to the response.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "cookie", "type" : "element(cookie:cookie)", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The XML representation of the cookie to be sent to the client.</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "The empty-sequence is returned." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">cookie:S002 if the cookie is bigger than 4096 bytes.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "set", "qname" : "cookie:set", "signature" : "($cookie as element(cookie:cookie), $encode as xs:boolean) as empty-sequence()", "description" : " Adds a <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Set-Cookie</tt> header to the response.\n The cookie parameter needs to adhere to the cookie schema. For example,\n <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n &lt;cookie:cookie\n   name=\"xs:string\"\n   expires=\"xs:datetime\"\n   domain=\"xs:string\"\n   path=\"xs:string\"\n   secure=\"xs:boolean\"&gt;value&lt;/cookie:cookie&gt;\n </tt>.\n If the cookie parameter is not valid according to the schema, err:XQDY0027 is raised.\n If $encode evaluates to fn:true(), then the child nodes of the cookie element will be\n serialized using XML serialization (omitting the XML declaration). In order not to\n break the cookie syntax, any occurence of whitespace or column in the value will be\n encoded on the client using the URL encoding format. For this reason also the '%'\n character will be encoded using the same format.\n If $encode evaluates to fn:false(), the children nodes of the cookie element will be\n serialized as text and no encoding will be performed whatsoever. It is the\n responsibility of the caller to make sure the text serialization will not produce an\n invalid cookie.\n", "summary" : "<p> Adds a  Set-Cookie  header to the response.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "cookie", "type" : "element(cookie:cookie)", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The cookie to send to the client</div>" }, { "name" : "encode", "type" : "xs:boolean", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> if encoding should be performed on the value or not</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "The empty-sequence is returned." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">cookie:S002 if the cookie is bigger than 4096 bytes.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 0, "name" : "validate-session", "qname" : "cookie:validate-session", "signature" : "() as xs:boolean", "description" : " Reads the \"_session\" cookie in the request and verifies if\n the signature matches the ad-hoc computed signature of the\n content of the session. The signature is generated with a\n server private key. If no cookie named \"_session\" exists,\n this function returns false.\n", "summary" : "<p> Reads the \"_session\" cookie in the request and verifies if\n the signature matches the ad-hoc computed signature of the\n content of the session.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:boolean", "description" : "Returns <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">true</tt> if the session is valid, and and false otherwise." }, "errors" : [  ] } ], "variables" : [  ] }, "http://www.28msec.com/modules/couchbase" : { "ns" : "http://www.28msec.com/modules/couchbase", "description" : " This module provides functionality to interact with the\n Couchbase NoSQL database.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The module is built using the libcouchbase 2.0 C client library and\n exposes most of its functionality in JSONiq.\n Beyond just allowing for basic key-value store operations (e.g.\n put-/get-text or put-/get-binary, this module also allows to work\n with Couchbase views in order to allow for complex JSON query\n operations.\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Cristi Dumitru</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://zorba.io/annotations", "prefix" : "an" }, { "uri" : "http://www.28msec.com/modules/couchbase", "prefix" : "cb" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" }, { "uri" : "http://www.zorba-xquery.com/modules/couchbase", "prefix" : "zcb" } ], "functions" : [ { "isDocumented" : true, "arity" : 1, "name" : "connect", "qname" : "cb:connect", "signature" : "($options as object()) as anyURI", "description" : " Connect to the Couchbase server.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The input to the function is an object that contains the connection\n information. Specifically, it allows for the following options:\n <ul>\n   <li><tt>host</tt>: the endpoint of the Couchbase server (mandatory)</li>\n   <li><tt>user</tt>: the user used for connecting (optional)</li>\n   <li><tt>password</tt>: the password used for connecting (optional)</li>\n   <li><tt>bucket</tt>: name of an existing bucket (mandatory)</li>\n </ul></p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <ul><li><pre>\n $conn := cb:connect({\n   \"host\" : \"192.168.1.56:8091\",\n   \"username\" : (),\n   \"password\" : (),\n   \"bucket\" : \"default\"\n });\n </pre></li></ul></p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The function returns an opaque URI that represents the connection.\n This URI has to be passed to other functions of this module that require\n the <tt>$conn</tt> parameter as a first argument.</p>\n", "summary" : "<p> Connect to the Couchbase server.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "options", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a object that contains the host, bucket, and authentication information.</div>" } ], "returns" : { "type" : "anyURI", "description" : "an identifier for the established connection." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">LCB0001 if the connection to the given host/bucket could not be established.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">CB0001 if mandatory connection information is missing.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">CB0007 if a given option is not supported.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 4, "name" : "connect", "qname" : "cb:connect", "signature" : "($host as string, $username as string?, $password as string?, $bucket as string) as anyURI", "description" : " Connect to the Couchbase server.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The function returns an opaque URI that represents the connection.\n This URI has to be passed to other functions of this module that require\n the <tt>$conn</tt> parameter as a first argument.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <ul><li><pre>\n $conn := cb:connect(\"192.168.1.56:8091\", (), (), \"default\");\n </pre></li></ul></p>\n", "summary" : "<p> Connect to the Couchbase server.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "host", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> address of the couchbase server (mandatory) <code>\"192.168.1.56:8091\"</code></div>" }, { "name" : "username", "type" : "string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> username used for the connection</div>" }, { "name" : "password", "type" : "string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> password used for the connection</div>" }, { "name" : "bucket", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> name of the bucket to use (mandatory) <code>\"default\"</code></div>" } ], "returns" : { "type" : "anyURI", "description" : "an identifier that represents the connection to the server." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">LCB0001 if the connection to the given host/bucket could not be established.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "create-view", "qname" : "cb:create-view", "signature" : "($conn as anyURI, $doc-name as string, $view-names as string*) as string*", "description" : " Create a document and views.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n If the document already exists, it is replaced.\n A document can hold several views that must be specified in the same call.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <ul><li><pre>\n $views := cb:create-view($conn, \"zip\", (\"bystate\", \"bycity\"));\n </pre></li></ul></p>\n", "summary" : "<p> Create a document and views.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "conn", "type" : "anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The identifier of the active connection</div>" }, { "name" : "doc-name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The name of the document to create</div>" }, { "name" : "view-names", "type" : "string", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The names of the views to create in the document</div>" } ], "returns" : { "type" : "string*", "description" : "The paths for the views that have been created." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">LCB0002 if any error occurs in the communication with the server.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 4, "name" : "create-view", "qname" : "cb:create-view", "signature" : "($conn as anyURI, $doc-name as string, $view-names as string*, $options as object()*) as string*", "description" : " Create a document and views.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n If the document already exists, it is replaced.\n A document can hold several views that must be specified in the same call.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">In addition, the function allows to specify several options:\n <ul>\n   <li><tt>key</tt>: <tt>string</tt> name of the value that will be used\n        as key in the view</li>\n   <li><tt>values</tt>: <tt>string/array</tt> name of the value(s) that\n        will be used as values in the view</li>\n   <li><tt>function</tt>: <tt>javascript function</tt> the map function\n        that will create the connection between key and value.<br/>\n        If <tt>function</tt> is specified, the <tt>key</tt> and\n        <tt>values</tt> options are ignored.</li>\n </ul></p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <ul><li><pre>\n $views := cb:create-view($conn, \"zip\", \"bystate\", { \"key\": \"doc.state\", \"values\" : [\"doc.pop\", \"doc.city\"] });\n </pre></li>\n <li><pre>\n $views := cb:create-view($conn, \"zip\", \"bycity\", { \"function\": \"function(doc, meta) {  emit(doc.state, null); }\"});\n </pre></li></ul></p>\n", "summary" : "<p> Create a document and views.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "conn", "type" : "anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The identifier of the active connection</div>" }, { "name" : "doc-name", "type" : "string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The name of the document to create</div>" }, { "name" : "view-names", "type" : "string", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The names of the views to create in the document</div>" }, { "name" : "options", "type" : "object()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> An object with additional options</div>" } ], "returns" : { "type" : "string*", "description" : "The paths for the views that have been created." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">LCB0002 if any error occurs in the communication with the server.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">CB0005 if the number of options doesn't match the number of view-names.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">CB0007 if any of the options is not supported.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">CB0010 if any of the given options has an invalid type.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "delete-view", "qname" : "cb:delete-view", "signature" : "($conn as anyURI, $doc as string*) as string*", "description" : " Delete a document and its views.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n If the document doesn't exists, the function does nothing.\n All the views hold in the document are deleted.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <ul><li><pre>\n cb:delete-view($conn, \"zip\");\n </pre></li></ul></p>\n", "summary" : "<p> Delete a document and its views.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "conn", "type" : "anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The identifier of the active connection</div>" }, { "name" : "doc", "type" : "string", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">-name The name of the document to delete</div>" } ], "returns" : { "type" : "string*", "description" : "a empty sequence." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">LCB0002 if any error occurs in the communication with the server.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "flush", "qname" : "cb:flush", "signature" : "($conn as anyURI) as empty-sequence()", "description" : " Remove all values and their keys.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <ul><li><pre>\n cb:flush($conn);\n </pre></li></ul></p>\n", "summary" : "<p> Remove all values and their keys.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "conn", "type" : "anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The identifier of the active connection</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "a empty sequence." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">LCB0002 if any error occurs in the communication with the server.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "get-binary", "qname" : "cb:get-binary", "signature" : "($conn as anyURI, $key as string*) as base64Binary*", "description" : " Retrieve the values matching the given string keys, as base64Binary.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <ul><li><pre>\n $result := cb:get-binary($conn, \"image\");\n </pre></li></ul></p>\n", "summary" : "<p> Retrieve the values matching the given string keys, as base64Binary.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "conn", "type" : "anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The identifier of the active connection</div>" }, { "name" : "key", "type" : "string", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The requested keys</div>" } ], "returns" : { "type" : "base64Binary*", "description" : "A sequence of base64Binary values corresponding to the keys" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">LCB0002 if any error occurs in the communication with the server.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "get-binary", "qname" : "cb:get-binary", "signature" : "($conn as anyURI, $key as string*, $options as object()) as base64Binary*", "description" : " Retrieve the values matching the given string keys, as base64Binary.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">In addition, the function allows to specify several options:\n <ul>\n   <li><tt>expiration-time</tt>: <tt>integer</tt> value for refreshing the\n        expiration time in seconds\n       (default 0, which means values are kept indefinitely)</li>\n </ul></p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <ul><li><pre>\n $result := cb:get-binary($conn, \"image\",{ \"expiration-time\" : 60 * 60 });\n </pre></li></ul></p>\n", "summary" : "<p> Retrieve the values matching the given string keys, as base64Binary.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "conn", "type" : "anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The identifier of the active connection</div>" }, { "name" : "key", "type" : "string", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The requested keys</div>" }, { "name" : "options", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> An object with additional options</div>" } ], "returns" : { "type" : "base64Binary*", "description" : "A sequence of base64Binary values corresponding to the keys" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">LCB0002 if any error occurs in the communication with the server.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">CB0007 if any of the options is not supported.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">CB0009 if the given expiration time is not an integer.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "get-text", "qname" : "cb:get-text", "signature" : "($conn as anyURI, $key as string*) as string*", "description" : " Retrieve the values matching the given string keys, as string.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <ul><li><pre>\n $result := cb:get-text($conn, \"35040\");\n </pre></li></ul></p>\n", "summary" : "<p> Retrieve the values matching the given string keys, as string.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "conn", "type" : "anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The identifier of the active connection</div>" }, { "name" : "key", "type" : "string", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The requested keys</div>" } ], "returns" : { "type" : "string*", "description" : "A sequence of string values corresponding to the keys" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">LCB0002 if any error occurs in the communication with the server.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "get-text", "qname" : "cb:get-text", "signature" : "($conn as anyURI, $key as string*, $options as object()) as string*", "description" : " Retrieve the values matching the given string keys, as string.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">In addition, the function allows to specify several options:\n <ul>\n   <li><tt>expiration-time</tt>: <tt>integer</tt> value for refreshing the\n        expiration time in seconds\n       (default 0, which means values are kept indefinitely)</li>\n   <li><tt>encoding</tt>: <tt>string</tt> name of the encoding of the\n        returned string (default UTF-8)</li>\n </ul></p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <ul><li><pre>\n $result := cb:get-text($conn, \"35040\", { \"encoding\" : \"ASCII\" } );\n </pre></li></ul></p>\n", "summary" : "<p> Retrieve the values matching the given string keys, as string.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "conn", "type" : "anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The identifier of the active connection</div>" }, { "name" : "key", "type" : "string", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The requested key</div>" }, { "name" : "options", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> An object with additional options</div>" } ], "returns" : { "type" : "string*", "description" : "A sequence of string values corresponding to the keys" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">LCB0002 if any error occurs in the communication with the server.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">CB0006 if the given encoding is not supported.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">CB0007 if any of the options is not supported.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">CB0009 if the given expiration time is not an integer.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "put-binary", "qname" : "cb:put-binary", "signature" : "($conn as anyURI, $key as string*, $value as base64Binary*) as empty-sequence()", "description" : " Store base64binary values along with their string keys.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <ul><li><pre>\n cb:put-binary($conn, \"image\",\n   http:get-binary(\"http://localhost:8091/images/couchbase_logo.png\")[2]);\n </pre></li></ul></p>\n", "summary" : "<p> Store base64binary values along with their string keys.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "conn", "type" : "anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The identifier of the active connection</div>" }, { "name" : "key", "type" : "string", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The keys to store</div>" }, { "name" : "value", "type" : "base64Binary", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The base64 binary values to be stored</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "a empty sequence." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">LCB0002 if any error occurs in the communication with the server.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">CB0005 if the number of keys doesn't match the number of values.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 4, "name" : "put-binary", "qname" : "cb:put-binary", "signature" : "($conn as anyURI, $key as string*, $value as base64Binary*, $options as object()) as empty-sequence()", "description" : " Store base64Binary values along with their string keys.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">In addition, the function allows to specify several options:\n <ul>\n   <li><tt>expiration-time</tt>: <tt>integer</tt> value for refreshing the\n        expiration time in seconds\n       (default 0, which means values are kept indefinitely)</li>\n   <li><tt>operation</tt>: <tt>add/replace/set/append/prepend</tt> type of\n       operation</li>\n   <li><tt>wait</tt>: <tt>persist/false</tt> if the system should wait for\n        persistence of the keys</li>\n </ul></p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <ul><li><pre>\n cb:put-binary($conn, \"image\",\n   http:get-binary(\"http://localhost:8091/images/couchbase_logo.png\")[2],\n   { \"expiration-time\" : 60 * 60 * 24 });\n </pre></li></ul></p>\n", "summary" : "<p> Store base64Binary values along with their string keys.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "conn", "type" : "anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The identifier of the active connection</div>" }, { "name" : "key", "type" : "string", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The keys to store</div>" }, { "name" : "value", "type" : "base64Binary", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The base64Binary values to be stored</div>" }, { "name" : "options", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> An object with additional options</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "a empty sequence." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">LCB0002 if any error occurs in the communication with the server.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">CB0005 if the number of keys doesn't match the number of values.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">CB0007 if any of the options is not supported.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">CB0009 if the given expiration time is not an integer.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">CB0011 if the stored Variable was not stored</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "put-text", "qname" : "cb:put-text", "signature" : "($conn as anyURI, $key as string*, $value as string*) as empty-sequence()", "description" : " Store string values along with their string keys.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n The values are stored with the UTF-8 encoding and a default\n expiration time 0.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <ul><li><pre>\n cb:put-text($conn, \"35040\", fn:serialize({\n                      \"city\" : \"CALERA\",\n                      \"loc\" : [ -86.755987, 33.1098 ],\n                      \"pop\" : 4675,\n                      \"state\" : \"AL\",\n                      \"_id\" : \"35040\"\n                    }));\n </pre></li></ul></p>\n", "summary" : "<p> Store string values along with their string keys.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "conn", "type" : "anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The identifier of the active connection</div>" }, { "name" : "key", "type" : "string", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The keys to store</div>" }, { "name" : "value", "type" : "string", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The string values to be stored.</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "a empty sequence." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">LCB0002 if any error occurs in the communication with the server.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">CB0005 if the number of keys doesn't match the number of values.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 4, "name" : "put-text", "qname" : "cb:put-text", "signature" : "($conn as anyURI, $key as string*, $value as string*, $options as object()) as empty-sequence()", "description" : " Store string values along with their string keys.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">In addition, the function allows to specify several options:\n <ul>\n   <li><tt>expiration-time</tt>: <tt>integer</tt> value for refreshing the\n        expiration time in seconds\n       (default 0, which means values are kept indefinitely)</li>\n   <li><tt>encoding</tt>: <tt>string</tt> name of the encoding of the\n        returned string (default UTF-8)</li>\n   <li><tt>operation</tt>: <tt>add/replace/set/append/prepend</tt> type\n        of operation</li>\n   <li><tt>wait</tt>: <tt>persist/false</tt> if the system should wait for\n        persistence of the keys</li>\n </ul></p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <ul><li><pre>\n cb:put-text($conn, \"35040\", fn:serialize({\n                      \"city\" : \"CALERA\",\n                      \"loc\" : [ -86.755987, 33.1098 ],\n                      \"pop\" : 4675,\n                      \"state\" : \"AL\",\n                      \"_id\" : \"35040\"\n                    }), { \"expiration-time\" : 60 * 60 * 24 });\n </pre></li></ul></p>\n", "summary" : "<p> Store string values along with their string keys.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "conn", "type" : "anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The identifier of the active connection</div>" }, { "name" : "key", "type" : "string", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The keys to store</div>" }, { "name" : "value", "type" : "string", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The string values to be stored</div>" }, { "name" : "options", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> An object with additional options</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "a empty sequence." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">LCB0002 if any error occurs in the communication with the server.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">CB0005 if the number of keys doesn't match the number of values.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">CB0006 if the given encoding is not supported.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">CB0007 if any of the options is not supported.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">CB0009 if the given expiration time is not an integer.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">CB0011 if the stored Variable was not stored</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "remove", "qname" : "cb:remove", "signature" : "($conn as anyURI, $key as string*) as empty-sequence()", "description" : " Remove the values matching the given string keys.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <ul><li><pre>\n cb:remove($conn, \"35040\");\n </pre></li></ul></p>\n", "summary" : "<p> Remove the values matching the given string keys.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "conn", "type" : "anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The identifier of the active connection</div>" }, { "name" : "key", "type" : "string", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The requested keys to have their values removed</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "a empty sequence." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">LCB0002 if any error occurs in the communication with the server.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "touch", "qname" : "cb:touch", "signature" : "($conn as anyURI, $key as string*, $exp-time as integer) as empty-sequence()", "description" : " Refresh the expiration time of the given string keys.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <ul><li><pre>\n cb:touch($conn, \"35040\", 60 * 60 * 24);\n </pre></li></ul></p>\n", "summary" : "<p> Refresh the expiration time of the given string keys.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "conn", "type" : "anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The identifier of the active connection</div>" }, { "name" : "key", "type" : "string", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The keys to touch</div>" }, { "name" : "exp-time", "type" : "integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> New expiration time in seconds</div>" } ], "returns" : { "type" : "empty-sequence()", "description" : "a empty sequence." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">LCB0002 if any error occurs in the communication with the server.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "view", "qname" : "cb:view", "signature" : "($conn as anyURI, $path as string*) as object()*", "description" : " Retrieve the content of existing views. <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <ul><li><pre>\n $results := cb:view($conn, \"_design/zip/_view/bystate\");\n </pre></li></ul></p>\n", "summary" : "<p> Retrieve the content of existing views.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "conn", "type" : "anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The identifier of the active connection</div>" }, { "name" : "path", "type" : "string", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The view path</div>" } ], "returns" : { "type" : "object()*", "description" : "information about the view" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">LCB0002 if any error occurs in the communication with the server.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "view", "qname" : "cb:view", "signature" : "($conn as anyURI, $path as string*, $options as object()) as object()*", "description" : " Retrieve the content of existing views.<p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"/>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Example:\n <ul><li><pre>\n $results := cb:view($conn, \"_design/zip/_view/bystate\", { \"limit\": 100 });\n </pre></li></ul></p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">In addition, the function allows to specify several options:\n <ul>\n   <li><tt>encoding</tt>: <tt>string</tt> name of the encoding of the\n        returned string (default UTF-8)</li>\n   <li><tt>stale</tt>: if the system should wait for persistence of the keys\n    <ul>\n      <li><tt>ok</tt> the view is not updated</li>\n      <li><tt>false</tt> the view is updated before the function view is\n      executed, this options needs the key to be on disk before the call of\n      the function.</li>\n      <li><tt>update_after</tt> the view is updated after the call\n      of the function.</li>\n    </ul></li>\n   <li><tt>limit</tt>: <tt>integer</tt> how many rows qill be shown\n         (default all)</li>\n </ul></p>\n", "summary" : "<p> Retrieve the content of existing views.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "conn", "type" : "anyURI", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The identifier of the active connection</div>" }, { "name" : "path", "type" : "string", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The view path <code>\"_design/test/_view/vies\"</code></div>" }, { "name" : "options", "type" : "object()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> An object with additional options</div>" } ], "returns" : { "type" : "object()*", "description" : "information about the view" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">LCB0002 if any error occurs in the communication with the server.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">CB0007 if any of the options is not supported.</xqdoc:error>" ] } ], "variables" : [  ] }, "http://zorba.io/modules/random" : { "ns" : "http://zorba.io/modules/random", "description" : " This module provides several functions for generating (pseudo-)random\n numbers and strings.\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Matthias Brantner, Sorin Nasoi</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://zorba.io/annotations", "prefix" : "an" }, { "uri" : "http://zorba.io/modules/random", "prefix" : "r" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" }, { "uri" : "http://zorba.io/errors", "prefix" : "zerr" } ], "functions" : [ { "isDocumented" : true, "arity" : 2, "name" : "random-between", "qname" : "r:random-between", "signature" : "($lower as integer, $upper as integer) as integer", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function generates one random number within a given range.\n The function is nondeterministic.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The function is based on <tt>r:random-between#3</tt>.\n Specifically, it returns the value of invoking\n <tt>r:random-betwen($lower, $upper, 1)</tt>.</p>\n", "summary" : "<p>  This function generates one random number within a given range.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "lower", "type" : "integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the lower bound for the random number</div>" }, { "name" : "upper", "type" : "integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the upper bound for the random number</div>" } ], "returns" : { "type" : "integer", "description" : "a random integer within the given range" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 3, "name" : "random-between", "qname" : "r:random-between", "signature" : "($lower as integer, $upper as integer, $num as integer) as integer*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function generates an arbitrary number of random numbers\n within a given range. The function is nondeterministic because\n the sequence is <b>not</b> repeatable.</p>\n", "summary" : "<p>  This function generates an arbitrary number of random numbers\n within a given range.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "lower", "type" : "integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the lower bound for every value within the sequence</div>" }, { "name" : "upper", "type" : "integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the upper bound for every value within the sequence</div>" }, { "name" : "num", "type" : "integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the length of the sequence returned</div>" } ], "returns" : { "type" : "integer*", "description" : "<tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$num</tt> pseudo-random integers within (and including) the range specified by <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$lower</tt> and <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$upper</tt>. It returns <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$num</tt>-times <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$lower</tt> if <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$lower</tt> is equal to <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$upper</tt> and the empty sequence if <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$num</tt> is negative." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">r:INVALID_ARGUMENT if <tt>$lower</tt> is greater than <tt>$upper</tt></xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 0, "name" : "random", "qname" : "r:random", "signature" : "() as integer", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function generates one random number.\n The function is nondeterministic.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The function is based on <tt>r:random#1</tt>. Specifically, it\n returns the value of invoking <tt>r:random(1)</tt>.</p>\n", "summary" : "<p>  This function generates one random number.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "integer", "description" : "a random integer" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "random", "qname" : "r:random", "signature" : "($num as integer) as integer* external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function generates an arbitrary number of random numbers.\n The function is nondeterministic because the sequence is\n <b>not</b> repeatable.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">However, the function is based on posix function <tt>srand()</tt> and\n <tt>rand()</tt>. Specifically, it invokes <tt>srand()</tt>\n with some random number based on the current time\n and then returns the values returned by invoking\n <tt>rand()</tt> <tt>$num</tt>-times.</p>\n", "summary" : "<p>  This function generates an arbitrary number of random numbers.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "num", "type" : "integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the length of the sequence returned</div>" } ], "returns" : { "type" : "integer*", "description" : "<tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$num</tt> random integers, or the empty sequence if <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$num</tt> is negative." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 4, "name" : "seeded-random-between", "qname" : "r:seeded-random-between", "signature" : "($seed as integer, $lower as integer, $upper as integer, $num as integer) as integer*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function generates an arbitrary number of pseudo-random numbers\n within a given range. The sequence is repeatable by calling the\n function with the same seed and boundaries.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The function is based on the function <tt>r:seeded-random#2</tt>.\n Specifically, its result is repeatable if called with the\n same arguments.</p>\n", "summary" : "<p>  This function generates an arbitrary number of pseudo-random numbers\n within a given range.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "seed", "type" : "integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the initial seed value for the sequence</div>" }, { "name" : "lower", "type" : "integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the lower bound for every value within the sequence</div>" }, { "name" : "upper", "type" : "integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the upper bound for every value within the sequence</div>" }, { "name" : "num", "type" : "integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the length of the sequence returned</div>" } ], "returns" : { "type" : "integer*", "description" : "<tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$num</tt> pseudo-random integers within (and including) the range specified by <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$lower</tt> and <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$upper</tt>. It returns <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$num</tt>-times <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$lower</tt> if <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$lower</tt> is equal to <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$upper</tt> and the empty sequence if <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$num</tt> is negative." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZQXD0004 if the given seed is negative or great than the max value of <tt>unsigned int</tt> on the given platform.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">r:INVALID_ARGUMENT if <tt>$lower</tt> is greater than <tt>$upper</tt></xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "seeded-random", "qname" : "r:seeded-random", "signature" : "($seed as integer, $num as integer) as integer* external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function generates an arbitrary number of pseudo-random numbers.\n The sequence is repeatable by calling the function with the same\n seed.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The function is based on posix function <tt>srand()</tt> and\n <tt>rand()</tt>. Specifically, it invokes <tt>srand($seed)</tt>\n and then returns the values returned by invoking <tt>rand()</tt>\n <tt>$num</tt>-times.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Sequences returned by this function are not thread-safe (i.e.\n if multiple XQuery programs invoking this function are executed\n concurrently in several threads). This is because the function is\n based on <tt>srand()</tt> and <tt>rand()</tt>.</p>\n", "summary" : "<p>  This function generates an arbitrary number of pseudo-random numbers.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "seed", "type" : "integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the initial seed value for the sequence</div>" }, { "name" : "num", "type" : "integer", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the length of the sequence returned</div>" } ], "returns" : { "type" : "integer*", "description" : "<tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$num</tt> pseudo-random integers, or the empty sequence if <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$num</tt> is negative." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">zerr:ZQXD0004 if the given seed is negative or great than the max value of <tt>unsigned int</tt> on the given platform.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 0, "name" : "uuid", "qname" : "r:uuid", "signature" : "() as string external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function returns a uuid.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> Note, that the function is not stable,\n that is, it returns a different UUID everytime the function is invoked.</p>\n", "summary" : "<p>  This function returns a uuid.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "string", "description" : "the generated UUID as string" }, "errors" : [  ] } ], "variables" : [  ] }, "http://www.zorba-xquery.com/modules/http-client" : { "ns" : "http://www.zorba-xquery.com/modules/http-client", "description" : " <h1 xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Introduction</h1>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n This module provides provides simple functions for performing HTTP requests\n (GET, POST, DELETE etc.), as well as a more flexible general\n purpose function (<a href=\"?anchor=send-request-3\">send-request()</a>).\n </p>\n <h1 xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Examples of how to use this module</h1>\n <h4 xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Simple GET Request</h4>\n <pre xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" class=\"ace-static\" ace-mode=\"xquery\">\n import module namespace http=\"http://www.zorba-xquery.com/modules/http-client\";\n declare namespace svg=\"http://www.w3.org/2000/svg\";\n http:get(\"http://www.w3.org/Graphics/SVG/svglogo.svg\")[2]/svg:svg/svg:title\n </pre>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n This example downloads an XML resource from the web (in this case,\n an SVG file, which is an XML-based image format) and returns it as\n a document node. Since the XML is in a namespace, we declare that\n namespace; we can then perform a path expression directly on the\n return value of http:get().\n </p>\n <h4 xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Simple GET Request (retrieving XHTML)</h4>\n   <pre xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" class=\"ace-static\" ace-mode=\"xquery\">\n   import module namespace http=\"http://www.zorba-xquery.com/modules/http-client\";\n   declare namespace xhtml=\"http://www.w3.org/1999/xhtml\";\n   http:get-node( \"http://www.w3.org\" )[2]//xhtml:body\n   </pre>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n This example shows how to retrieve an XHTML resource. XHTML is\n XML, so the http:get-node() function will return it as a document node\n and you can operate on it with the full power of XQuery. As above, since this\n XML is in a particular namespace, the above query defines that namespace\n with the prefix \"xhtml\" so it can easily perform path expressions, etc.\n </p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n Note: many webservers, include www.w3.org, return XHTML with the\n HTTP Content-Type \"text/html\". Zorba cannot assume that \"text/html\"\n is actually XHTML, and so http:get() would have returned raw text\n rather than a document node. That is why the example above uses\n http:get-node(), which overrides the server's Content-Type and tells\n Zorba to attempt to parse the result as XML.\n </p>\n <h4 xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Simple GET Request (retrieving HTML as text)</h4>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n Note that XQuery does <b>not</b> understand plain HTML, and so if the URL\n you retrieve contains plain HTML data (not XHTML), it will be treated as\n plain text as shown in the next example. If you want to operate on the HTML\n with XQuery, you should use the HTML language module which can transform\n HTML to XHTML. The HTML module is supported by the Zorba team, but it is\n not a \"core module\", meaning that it is not shipped with every Zorba\n installation and may not be available. See\n <a href=\"http://www.zorba-xquery.com/site2/html/downloads.html\">the Zorba downloads\n page</a> for information about obtaining this module if you do not\n have it.</p>\n <pre xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" class=\"ace-static\" ace-mode=\"xquery\">\n import module namespace http=\"http://www.zorba-xquery.com/modules/http-client\";\n http:get(\"http://www.example.com\")[2]\n </pre>\n returns\n   <pre xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" class=\"ace-static\" ace-mode=\"xml\">\n   &lt;!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"&gt;\n   &lt;html&gt;\n     &lt;head&gt;\n       &lt;meta http-equiv=\"Content-Type\"\n       content=\"text/html; charset=utf-8\" /&gt;\n       &lt;title&gt;Example Web Page&lt;/title&gt;\n     &lt;/head&gt;\n     &lt;body&gt;\n       &lt;p&gt;You have reached this web page by typing \"example.com\",\n       \"example.net\", or \"example.org\" into your web browser.&lt;/p&gt;\n       &lt;p&gt;These domain names are reserved for use in documentation and are\n       Not available for registration. See\n       &lt;a href=\"http://www.rfc-editor.org/rfc/rfc2606.txt\"&gt;RFC 2606&lt;/a&gt;,\n       Section 3.&lt;/p&gt;\n     &lt;/body&gt;\n   &lt;/html&gt;\n   </pre>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Note that the response data above is a simple\n xs:string value containing the HTML data, not actual XML data. If you\n executed the above query using the Zorba command-line client, you would\n have actually seen data like the following:</p>\n <pre xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" class=\"ace-static\" ace-mode=\"xml\">\n   &amp;lt;!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"&amp;gt;\n   &amp;lt;html&amp;gt;\n      ...\n </pre>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">because Zorba would attempt to serialize it as XML data, and would\n escape all the raw angle brackets in the original xs:string.</p>\n <h4 xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Simple POST Request</h4>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n Here is a simple example which sends text content by making an HTTP POST\n request.\n </p>\n <pre xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" class=\"ace-static\" ace-mode=\"xquery\">\n import module namespace http=\"http://www.zorba-xquery.com/modules/http-client\";\n http:post( \"...\", \"Hello World\" )\n </pre>\n <h1 xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" id=\"standard_return\">Return Values</h1>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Most functions in this module (all except\n <a href=\"?anchor=options-1\">options()</a>) return one or more items.\n (<a href=\"?anchor=head-1\">head()</a> returns exactly one.) For all of these,\n the first item returned will be a &lt;http-schema:response&gt;\n element, as seen in the examples above. This element has \"status\" and\n \"message\" attributes, representing the result of the HTTP call. It\n also has any number of &lt;http-schema:header&gt; child elements that\n encode the HTTP headers returned by the HTTP server. Finally, it\n will generally contain a &lt;http-schema:body&gt; child element with\n a \"media-type\" attribute that identifies the content-type of the\n result data.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The full schema of this &lt;http-schema:response&gt; element is\n part of the <a href=\"http://expath.org/modules/http-client/\">EXPath\n HTTP Client module</a>. You can see the schema\n <a href=\"schemas/expath.org_ns_http-client.html\">here</a>.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Any items in function return values after the initial\n &lt;http-schema:response&gt; element are the body/bodies of the HTTP\n response from the server. (MIME Multi-part responses will have\n more than one body.) The type of these items depends on the\n Content-Type for each body. Each item will be:</p>\n <ul xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n  <li>\n    an element node, if the returned content type is one of:\n    <ul>\n      <li>text/xml</li>\n      <li>application/xml</li>\n      <li>text/xml-external-parsed-entity</li>\n      <li>application/xml-external-parsed-entity</li>\n      <li>or if the Content-Type ends with \"+xml\".</li>\n    </ul>\n  </li>\n  <li>\n    an xs:string, if the returned content type starts with \"text/\"\n    and does not match the above XML content types strings, or if\n    it is one of:\n    <ul>\n      <li>\"application/json\"</li>\n      <li>\"application/x-javascript\"</li>\n    </ul>\n  </li>\n  <li>xs:base64Binary for all other content types.</li>\n </ul>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This return value - a sequence of items comprising one\n &lt;http-schema:response&gt; element followed by zero or more\n response items - is referred to as the \"standard http-client\n return type\" in the function declarations below.</p>\n <h1 xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" id=\"url_string\">$href Arguments to Functions</h1>\n All functions in this module accept a URL argument named $href. In\n all cases, the value passed to $href must be a valid xs:anyURI.\n However, all functions declare $href to be of type xs:string. This\n is for convenience, since you can pass a string literal value (that\n is, a URL in double-quotes spelled out explicitly in your query)\n to an xs:string parameter.\n <h1 xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" id=\"get_warning\">Important Notice Regarding get() Functions</h1>\n All of the get() functions in this module -\n <a xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" href=\"?anchor=get-1\">get()</a>, <a xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" href=\"?anchor=get-node-1\">get-node()</a>,\n <a xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" href=\"?anchor=get-text-1\">get-text()</a>, and\n <a xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" href=\"?anchor=get-binary()\">get-binary()</a> - are declared to be\n <i xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">nondeterministic</i>, which means that Zorba will not cache\n their results. However, they are <b xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">not</b> declared to be\n <i xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">sequential</i>, which means that Zorba may re-order them\n as part of its query optimization. According to the HTTP RFC,\n GET requests should only return data, and should not have any\n side-effects. However, in practice it is not uncommon for GET\n requests to have side-effects. If your application depends on\n the ordering of side-effects from making GET requests, you should\n either use the more complex <a xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" href=\"?anchor=send-request-3\">send-request()</a>\n function (which <b xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">is</b> declared <i xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">sequential</i>), or alterately\n wrap each call to get() in your own sequential function, to ensure\n that Zorba does not place the GET requests out of order.\n <h1 xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" id=\"expath_relation\">Relation to the EXPath http-client module</h1>\n <a xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" href=\"http://expath.org/\">EXPath</a> defines its own http-client\n module, which is available separately for Zorba as a non-core module.\n There are two primary differences between EXPath's http-client and\n Zorba's core http-client (this module):\n <ol xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n   <li>EXPath defines only the send-request() function, although it\n does include convenient 1- and 2-argument forms in addition to the\n full 3-argument form. EXPath does not include the simpler get(),\n post(), put(), delete(), head(), and options() functions defined by\n this module.</li>\n   <li>EXPath specifies that all HTML content returned from the\n HTTP server will be <i>tidied up</i> into valid XML, and then parsed\n into an element. As this required an additional third-party library\n dependency, Zorba's http-client module does not perform this tidying.\n Instead, HTML content is returned as a string (with special XML\n characters replaced with XML entity references, as shown in the\n above examples).</li>\n </ol>\n See <a xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" href=\"http://www.expath.org/spec/http-client\">the full spec\n of the EXPath http-client module</a> for more information.\n", "sees" : [ "<xqdoc:see xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"><a href=\"http://www.w3.org/TR/xquery-11/#FunctionDeclns\">XQuery 1.1: Function Declaration</a></xqdoc:see>" ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Markus Pilman, Federico Cavalieri</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://zorba.io/annotations", "prefix" : "an" }, { "uri" : "http://www.w3.org/2005/xqt-errors", "prefix" : "err" }, { "uri" : "http://expath.org/ns/error", "prefix" : "error" }, { "uri" : "http://www.zorba-xquery.com/modules/http-client", "prefix" : "http" }, { "uri" : "http://expath.org/ns/http-client", "prefix" : "http-schema" }, { "uri" : "http://zorba.io/modules/http-client-wrapper", "prefix" : "http-wrapper" }, { "uri" : "http://jsoniq.org/functions", "prefix" : "jn" }, { "uri" : "http://zorba.io/modules/http-client", "prefix" : "json-http" }, { "uri" : "http://jsoniq.org/function-library", "prefix" : "libjn" }, { "uri" : "http://www.w3.org/2010/xslt-xquery-serialization", "prefix" : "ser" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 1, "name" : "delete", "qname" : "http:delete", "signature" : "($href as xs:string) as item()+", "description" : " This function makes an HTTP DELETE request to a given URL.\n", "summary" : "<p> This function makes an HTTP DELETE request to a given URL.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "href", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The URL to which the request will be made (see <a href=\"#url_string\">note</a> above).</div>" } ], "returns" : { "type" : "item()+", "description" : "<a xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" href=\"#standard_return\">standard http-client return type</a>." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC001 An HTTP error occurred.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC002 Error parsing the response content as XML.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC006 A timeout occurred waiting for the response.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HCV02 Trying to follow a redirect of a DELETE request.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "get-binary", "qname" : "http:get-binary", "signature" : "($href as xs:string) as item()+", "description" : " This function makes a GET request on a given URL. All returned bodies\n are forced to be interpreted as binary data, and will be returned\n as xs:base64Binary items.\n", "summary" : "<p> This function makes a GET request on a given URL.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "href", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The URL to which the request will be made (see <a href=\"#url_string\">note</a> above).</div>" } ], "returns" : { "type" : "item()+", "description" : "<a xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" href=\"#standard_return\">standard http-client return type</a>." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC001 An HTTP error occurred.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC002 Error parsing the response content as XML.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC006 A timeout occurred waiting for the response.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "get-node", "qname" : "http:get-node", "signature" : "($href as xs:string) as item()+", "description" : " This function makes a GET request to a given URL. All returned bodies\n are forced to be interpreted as XML and parsed into elements.\n", "summary" : "<p> This function makes a GET request to a given URL.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "href", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The URL to which the request will be made (see <a href=\"#url_string\">note</a> above).</div>" } ], "returns" : { "type" : "item()+", "description" : "<a xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" href=\"#standard_return\">standard http-client return type</a>." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC001 An HTTP error occurred.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC002 Error parsing the response content as XML.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC006 A timeout occurred waiting for the response.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "get-text", "qname" : "http:get-text", "signature" : "($href as xs:string) as item()+", "description" : " This function makes a GET request to a given URL. All returned bodies\n are forced to be interpreted as plain strings, and will be returned\n as xs:string items.\n", "summary" : "<p> This function makes a GET request to a given URL.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "href", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The URL to which the request will be made (see <a href=\"#url_string\">note</a> above).</div>" } ], "returns" : { "type" : "item()+", "description" : "<a xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" href=\"#standard_return\">standard http-client return type</a>." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC001 An HTTP error occurred.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC002 Error parsing the response content as XML.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC006 A timeout occurred waiting for the response.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "get", "qname" : "http:get", "signature" : "($href as xs:string) as item()+", "description" : " This function makes a GET request to a given URL.\n", "summary" : "<p> This function makes a GET request to a given URL.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "href", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The URL to which the request will be made (see <a href=\"#url_string\">note</a> above).</div>" } ], "returns" : { "type" : "item()+", "description" : "<a xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" href=\"#standard_return\">standard http-client return type</a>." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC001 An HTTP error occurred.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC002 Error parsing the response content as XML.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC006 A timeout occurred waiting for the response.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "head", "qname" : "http:head", "signature" : "($href as xs:string) as item()", "description" : " This function makes an HTTP HEAD request on a given URL.\n", "summary" : "<p> This function makes an HTTP HEAD request on a given URL.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "href", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The URL to which the request will be made (see <a href=\"#url_string\">note</a> above).</div>" } ], "returns" : { "type" : "item()", "description" : "<a xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" href=\"#standard_return\">standard http-client return type</a> (since HEAD never returns any body data, only the &lt;http-schema:response&gt; element will be returned)." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC001 An HTTP error occurred.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC006 A timeout occurred waiting for the response.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "options", "qname" : "http:options", "signature" : "($href as xs:string) as xs:string*", "description" : " This function makes an HTTP OPTIONS request, which asks the server\n which operations it supports.\n", "summary" : "<p> This function makes an HTTP OPTIONS request, which asks the server\n which operations it supports.</p>", "annotation_str" : " %an:nondeterministic", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "nondeterministic", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "href", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The URL to which the request will be made (see <a href=\"#url_string\">note</a> above).</div>" } ], "returns" : { "type" : "xs:string*", "description" : "A sequence of xs:string values of the allowed operations." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC001 An HTTP error occurred.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC006 A timeout occurred waiting for the response.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "post", "qname" : "http:post", "signature" : "($href as xs:string, $body as item()) as item()+", "description" : " This function makes an HTTP POST request to a given URL. If the body\n passed to this function is an element, it will be serialized to XML\n to be sent to the server, and the Content-Type sent to the server will\n be \"text/xml\". Otherwise, the body will be converted to\n a plain string, and the Content-Type will be \"text/plain\".\n", "summary" : "<p> This function makes an HTTP POST request to a given URL.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "href", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The URL to which the request will be made (see <a href=\"#url_string\">note</a> above).</div>" }, { "name" : "body", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The body which will be sent to the server.</div>" } ], "returns" : { "type" : "item()+", "description" : "<a xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" href=\"#standard_return\">standard http-client return type</a>." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC001 An HTTP error occurred.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC002 Error parsing the response content as XML.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC006 A timeout occurred waiting for the response.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HCV02 Trying to follow a redirect of a POST request.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "post", "qname" : "http:post", "signature" : "($href as xs:string, $body as item(), $content-type as xs:string) as item()+", "description" : " This function makes an HTTP POST request to a given URL. If the body\n passed to this function is an element, it will be serialized\n according to the $content-type parameter as follows:\n <ul xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n  <li>If $content-type is \"text/xml\", \"application/xml\",\n \"text/xml-external-parsed-entity\", or\n \"application/xml-external-parsed-entity\", or if it ends with \"+xml\",\n $body will be serialized to XML.</li>\n  <li>If $content-type starts with \"text/html\", $body will be\n serialized to HTML.</li>\n  <li>Otherwise, $body will be serialized to text.</li>\n </ul>\n If $body is not an element, $body will be serialized to text\n regardless of $content-type.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">In any case, Content-Type of the request sent to the server will\n be $content-type.</p>\n", "summary" : "<p> This function makes an HTTP POST request to a given URL.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "href", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The URL to which the request will be made (see <a href=\"#url_string\">note</a> above).</div>" }, { "name" : "body", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The body which will be sent to the server</div>" }, { "name" : "content-type", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The content type of the body as described above.</div>" } ], "returns" : { "type" : "item()+", "description" : "The first element of the result is the metadata (like headers, status etc), the next elements are the response" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC001 An HTTP error occurred.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC002 Error parsing the response content as XML.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC006 A timeout occurred waiting for the response.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HCV02 Trying to follow a redirect of a POST request.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "put", "qname" : "http:put", "signature" : "($href as xs:string, $body as item()) as item()+", "description" : " This function makes an HTTP PUT request to a given URL. If the body\n passed to this function is an element, it will be serialized to XML\n to be sent to the server, and the Content-Type sent to the server will\n be \"text/xml\". Otherwise, the body will be converted to\n a plain string, and the Content-Type will be \"text/plain\".\n", "summary" : "<p> This function makes an HTTP PUT request to a given URL.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "href", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The URL to which the request will be made (see <a href=\"#url_string\">note</a> above).</div>" }, { "name" : "body", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The body which will be sent to the server.</div>" } ], "returns" : { "type" : "item()+", "description" : "<a xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" href=\"#standard_return\">standard http-client return type</a>." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC001 An HTTP error occurred.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC002 Error parsing the response content as XML.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC006 A timeout occurred waiting for the response.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HCV02 Trying to follow a redirect of a PUT request.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "put", "qname" : "http:put", "signature" : "($href as xs:string, $body as item(), $content-type as xs:string) as item()+", "description" : " This function makes an HTTP PUT request to a given URL. If the body\n passed to this function is an element, it will be serialized\n according to the $content-type parameter as follows:\n <ul xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n  <li>If $content-type is \"text/xml\", \"application/xml\",\n \"text/xml-external-parsed-entity\", or\n \"application/xml-external-parsed-entity\", or if it ends with \"+xml\",\n $body will be serialized to XML.</li>\n  <li>If $content-type starts with \"text/html\", $body will be\n serialized to HTML.</li>\n  <li>Otherwise, $body will be serialized to text.</li>\n </ul>\n If $body is not an element, $body will be serialized to text\n regardless of $content-type.\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">In any case, Content-Type of the request sent to the server will\n be $content-type.</p>\n", "summary" : "<p> This function makes an HTTP PUT request to a given URL.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "href", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The URL to which the request will be made (see <a href=\"#url_string\">note</a> above).</div>" }, { "name" : "body", "type" : "item()", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The body which will be sent to the server.</div>" }, { "name" : "content-type", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The content type of $body as described above.</div>" } ], "returns" : { "type" : "item()+", "description" : "<a xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" href=\"#standard_return\">standard http-client return type</a>." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC001 An HTTP error occurred.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC002 Error parsing the response content as XML.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC006 A timeout occurred waiting for the response.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HCV02 Trying to follow a redirect of a PUT request.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 3, "name" : "send-request", "qname" : "http:send-request", "signature" : "($request as element(http-schema:request)?, $href as xs:string?, $bodies as item()*) as item()+", "description" : " This function sends an HTTP request and returns the corresponding response.\n Its inputs, outputs, and behavior are identical to the\n <a xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" href=\"http://expath.org/spec/http-client\">EXPath http-client</a>'s\n send-request() function (except that HTML responses are not tidied\n into XML - see <a xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" href=\"#expath_relation\">the note above</a>). It\n is provided here for use in Zorba installations that do not have\n the EXPath module available. If you have the option of using the\n EXPath module instead of this function, please do so, as it will\n allow your application to be more interoperable between different\n XQuery engines.\n Full documentation of the $request parameter can be found in\n <a xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" href=\"http://expath.org/spec/http-client#d2e183\">the EXPath\n specification</a>.\n", "summary" : "<p> This function sends an HTTP request and returns the corresponding response.</p>", "annotation_str" : " %an:sequential", "annotations" : [ { "prefix" : "an", "ns" : "http://zorba.io/annotations", "name" : "sequential", "value" : "" } ], "updating" : false, "parameters" : [ { "name" : "request", "type" : "element(http-schema:request)", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> Contains the various parameters of the request (see above).</div>" }, { "name" : "href", "type" : "xs:string", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The URL to which the request will be made (see <a href=\"#url_string\">note</a> above). If this parameter is specified, it will override the \"href\" attribute of $request.</div>" }, { "name" : "bodies", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> is the request body content, for HTTP methods that can contain a body in the request (i.e. POST and PUT). It is an error if this param is not the empty sequence for methods</div>" } ], "returns" : { "type" : "item()+", "description" : "<a xmlns:xqdoc=\"http://www.xqdoc.org/1.0\" href=\"#standard_return\">standard http-client return type</a>." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC001 An HTTP error occurred.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC002 Error parsing the response content as XML.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC003 With a multipart response, the override-media-type must be either a multipart media type or application/octet-stream.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC004 The src attribute on the body element is mutually exclusive with all other attribute (except the media-type).</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC005 The input request element is not valid.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HC006 A timeout occurred waiting for the response.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">error:HCV02 Trying to follow a redirect of a POST, PUT, or DELETE request</xqdoc:error>" ] } ], "variables" : [  ] }, "http://xbrl.io/modules/bizql/profiles/sec/networks" : { "ns" : "http://xbrl.io/modules/bizql/profiles/sec/networks", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This module provides functionality for querying SEC networks in SEC filings.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">SEC Networks are actually XBRL Components. In the SEC profiles, all XBRL networks\n in an XBRL component must be consistent to each other. A way to look at it is that\n the SEC Network can be identified with the XBRL presentation network it contains.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">For XBRL-generic operations on XBRL components, use the\n generic components module.</p>\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Charles Hoffman</xqdoc:author>", "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Matthias Brantner</xqdoc:author>", "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Dennis Knochenwefel</xqdoc:author>", "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Ghislain Fourny</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://xbrl.io/modules/bizql/archives", "prefix" : "archives" }, { "uri" : "http://xbrl.io/modules/bizql/components", "prefix" : "components" }, { "uri" : "http://www.28msec.com/modules/credentials", "prefix" : "credentials" }, { "uri" : "http://xbrl.io/modules/bizql/facts", "prefix" : "facts" }, { "uri" : "http://xbrl.io/modules/bizql/profiles/sec/filings", "prefix" : "filings" }, { "uri" : "http://xbrl.io/modules/bizql/hypercubes", "prefix" : "hypercubes" }, { "uri" : "http://www.28msec.com/modules/mongodb", "prefix" : "mongo" }, { "uri" : "http://xbrl.io/modules/bizql/networks", "prefix" : "networks" }, { "uri" : "http://xbrl.io/modules/bizql/profiles/sec/core", "prefix" : "sec" }, { "uri" : "http://xbrl.io/modules/bizql/profiles/sec/networks", "prefix" : "sec-networks" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 1, "name" : "abstracts", "qname" : "sec-networks:abstracts", "signature" : "($networks-or-ids as item()*) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns all SEC Abstracts contained in the supplied SEC Networks.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">SEC Abstracts are XBRL abstract primary items that may or may not be associated\n with a hypercube -- except those that are SEC LineItems (i.e., source of an all relation).</p>\n", "summary" : "<p>  Returns all SEC Abstracts contained in the supplied SEC Networks.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "networks-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of SEC Network objects, or their XBRL Component IDs.</div>" } ], "returns" : { "type" : "object()*", "description" : "the SEC Abstracts." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "axes", "qname" : "sec-networks:axes", "signature" : "($networks-or-ids as item()*) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns all SEC Axes contained in the supplied SEC Networks.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">SEC Axes are XBRL dimensions.</p>\n", "summary" : "<p>  Returns all SEC Axes contained in the supplied SEC Networks.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "networks-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of SEC Network objects, or their XBRL Component IDs.</div>" } ], "returns" : { "type" : "object()*", "description" : "the SEC Axes." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "categories", "qname" : "sec-networks:categories", "signature" : "($networks-or-ids) as string*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Return the categories of the supplied SEC networks (Statement, Disclosure, Document or Schedule).</p>\n", "summary" : "<p>  Return the categories of the supplied SEC networks (Statement, Disclosure, Document or Schedule).</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "networks-or-ids", "type" : null, "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of SEC Network objects, or their XBRL Component IDs.</div>" } ], "returns" : { "type" : "string*", "description" : "the category of each network." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "concepts", "qname" : "sec-networks:concepts", "signature" : "($networks-or-ids as item()*) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns all SEC Concepts contained in the supplied SEC Networks.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">SEC Concepts are XBRL concrete primary items that may or may not be associated\n with a hypercube.</p>\n", "summary" : "<p>  Returns all SEC Concepts contained in the supplied SEC Networks.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "networks-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of SEC Network objects, or their XBRL Component IDs.</div>" } ], "returns" : { "type" : "object()*", "description" : "the SEC Concepts." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "disclosures", "qname" : "sec-networks:disclosures", "signature" : "($networks-or-ids as item()*) as string+", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the disclosures of the suplied networks.</p>\n", "summary" : "<p>  Returns the disclosures of the suplied networks.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "networks-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of SEC Network objects, or their XBRL Component IDs.</div>" } ], "returns" : { "type" : "string+", "description" : "the disclosure names, or \"UncategorizedInformation\" if none." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "fact-tables", "qname" : "sec-networks:fact-tables", "signature" : "($networks-or-ids as item()*) as array()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves all facts belonging to the SEC Network.</p>\n", "summary" : "<p>  Retrieves all facts belonging to the SEC Network.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "networks-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of SEC Network objects, or their XBRL Component IDs.</div>" } ], "returns" : { "type" : "array()", "description" : "a array populated with fact values." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "fact-tables", "qname" : "sec-networks:fact-tables", "signature" : "($networks-or-ids as item()*, $options as object()?) as array()", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves all facts belonging to the SEC Network.</p>\n", "summary" : "<p>  Retrieves all facts belonging to the SEC Network.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "networks-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of SEC Network objects, or their XBRL Component IDs.</div>" }, { "name" : "options", "type" : "object()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> <a href=\"core#standard_options\">standard SEC BizQL options</a>.</div>" } ], "returns" : { "type" : "array()", "description" : "a array of arrays filled with fact values." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "facts", "qname" : "sec-networks:facts", "signature" : "($networks-or-ids as item()*) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves all facts belonging to the SEC Network.</p>\n", "summary" : "<p>  Retrieves all facts belonging to the SEC Network.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "networks-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of SEC Network objects, or their XBRL Component IDs.</div>" } ], "returns" : { "type" : "object()*", "description" : "a sequence of facts." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "facts", "qname" : "sec-networks:facts", "signature" : "($networks-or-ids as item()*, $options as object()?) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves all facts belonging to the SEC Network.</p>\n", "summary" : "<p>  Retrieves all facts belonging to the SEC Network.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "networks-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of SEC Network objects, or their XBRL Component IDs.</div>" }, { "name" : "options", "type" : "object()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> <a href=\"core#standard_options\">standard SEC BizQL options</a>.</div>" } ], "returns" : { "type" : "object()*", "description" : "a sequence of facts." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "line-items-report-elements", "qname" : "sec-networks:line-items-report-elements", "signature" : "($networks-or-ids as item()*) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns all SEC LineItems report elements contained in the supplied SEC Networks.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This is not to be confused with the \"line items\" terminology, which includes all\n SEC Abstracts and SEC Concepts.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">SEC LineItems report elements are XBRL abstract primary items that are top-level in their\n association with an XBRL hypercube (source of an all relation).</p>\n", "summary" : "<p>  Returns all SEC LineItems report elements contained in the supplied SEC Networks.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "networks-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of SEC Network objects, or their XBRL Component IDs.</div>" } ], "returns" : { "type" : "object()*", "description" : "the SEC LineItems report elements." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "line-items", "qname" : "sec-networks:line-items", "signature" : "($networks-or-ids as item()*) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns all SEC Line Items (Concepts and Abstracts) contained in the\n supplied SEC Networks. Not to be confused with the LineItems report element.</p>\n", "summary" : "<p>  Returns all SEC Line Items (Concepts and Abstracts) contained in the\n supplied SEC Networks.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "networks-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of SEC Network objects, or their XBRL Component IDs.</div>" } ], "returns" : { "type" : "object()*", "description" : "the SEC Line Items." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "members", "qname" : "sec-networks:members", "signature" : "($networks-or-ids as item()*) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns all SEC Members contained in the supplied SEC Networks.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">SEC Members are XBRL members that are in the transitive closure of SEC Axes\n via the dimension-domain and domain-member relations.</p>\n", "summary" : "<p>  Returns all SEC Members contained in the supplied SEC Networks.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "networks-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of SEC Network objects, or their XBRL Component IDs.</div>" } ], "returns" : { "type" : "object()*", "description" : "the SEC Members." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "model-structures", "qname" : "sec-networks:model-structures", "signature" : "($networks-or-ids as item()*) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Computes the model structure of the supplied SEC Network, which is a hierarchy\n of SEC Report Elements (Tables, Axes, Members, LineItems, Abstracts, Concepts).</p>\n", "summary" : "<p>  Computes the model structure of the supplied SEC Network, which is a hierarchy\n of SEC Report Elements (Tables, Axes, Members, LineItems, Abstracts, Concepts).</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "networks-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of SEC Network objects, or their XBRL Component IDs.</div>" } ], "returns" : { "type" : "object()*", "description" : "the model structures of these SEC Networks." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "networks-for-disclosures", "qname" : "sec-networks:networks-for-disclosures", "signature" : "($disclosures as string*) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves all SEC Networks that bear the supplied disclosures.</p>\n", "summary" : "<p>  Retrieves all SEC Networks that bear the supplied disclosures.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "disclosures", "type" : "string", "occurrence" : "*", "description" : "" } ], "returns" : { "type" : "object()*", "description" : "all models that match one of the disclosures." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "networks-for-filings-and-categories", "qname" : "sec-networks:networks-for-filings-and-categories", "signature" : "($archive-or-ids as item()*, $categories as string*) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves all models that belong to the archives given as first\n parameter and that match the supplied category.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">A category can be any of \"Statement\", \"Disclosure\", \"Document\",\n \"Schedule\", or \"Unknown\".</p>\n", "summary" : "<p>  Retrieves all models that belong to the archives given as first\n parameter and that match the supplied category.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "archive-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> an arbitrary number of archive identifiers (AIDs) or archive objects.</div>" }, { "name" : "categories", "type" : "string", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a list of categories.</div>" } ], "returns" : { "type" : "object()*", "description" : "all said models" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "networks-for-filings-and-disclosures", "qname" : "sec-networks:networks-for-filings-and-disclosures", "signature" : "($archive-or-ids as item()*, $disclosures as string*) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves all models that belong to the archives given as first\n parameter and that match the supplied disclosures.</p>\n", "summary" : "<p>  Retrieves all models that belong to the archives given as first\n parameter and that match the supplied disclosures.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "archive-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> an arbitrary number of archive identifiers (AIDs) or archive objects.</div>" }, { "name" : "disclosures", "type" : "string", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a list of disclosures.</div>" } ], "returns" : { "type" : "object()*", "description" : "all models in the archives and that match one of the disclosures." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "networks-for-filings", "qname" : "sec-networks:networks-for-filings", "signature" : "($archives-or-ids as item()*) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves all SEC Networks in a given filing.</p>\n", "summary" : "<p>  Retrieves all SEC Networks in a given filing.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "archives-or-ids", "type" : "item()", "occurrence" : "*", "description" : "" } ], "returns" : { "type" : "object()*", "description" : "all networks in the supplied filings." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "num-abstracts", "qname" : "sec-networks:num-abstracts", "signature" : "($networks-or-ids as item()*) as integer*", "description" : " Return the number of (distinct) SEC Abstracts in each of the given components.\n", "summary" : "<p> Return the number of (distinct) SEC Abstracts in each of the given components.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "networks-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> list of components or IDs</div>" } ], "returns" : { "type" : "integer*", "description" : "the said number of abstracts" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "num-axes", "qname" : "sec-networks:num-axes", "signature" : "($networks-or-ids as item()*) as integer*", "description" : " Return the number of (distinct) SEC Axes in each of the given components.\n", "summary" : "<p> Return the number of (distinct) SEC Axes in each of the given components.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "networks-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> list of components or IDs</div>" } ], "returns" : { "type" : "integer*", "description" : "the said number of axes" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "num-concepts", "qname" : "sec-networks:num-concepts", "signature" : "($networks-or-ids as item()*) as integer*", "description" : " Return the number of (distinct) SEC Concepts in each of the given components.\n", "summary" : "<p> Return the number of (distinct) SEC Concepts in each of the given components.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "networks-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> list of components or IDs</div>" } ], "returns" : { "type" : "integer*", "description" : "the said number of concepts" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "num-line-items", "qname" : "sec-networks:num-line-items", "signature" : "($networks-or-ids as item()*) as integer*", "description" : " Return the number of (distinct) SEC LineItems report elements in each of the given components.\n", "summary" : "<p> Return the number of (distinct) SEC LineItems report elements in each of the given components.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "networks-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> list of components or IDs</div>" } ], "returns" : { "type" : "integer*", "description" : "the said number of line items" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "num-members", "qname" : "sec-networks:num-members", "signature" : "($networks-or-ids as item()*) as integer*", "description" : " Return the number of (distinct) SEC Members in each of the given components.\n", "summary" : "<p> Return the number of (distinct) SEC Members in each of the given components.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "networks-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> list of components or IDs</div>" } ], "returns" : { "type" : "integer*", "description" : "the said number of members" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "num-report-elements", "qname" : "sec-networks:num-report-elements", "signature" : "($networks-or-ids as item()*) as integer*", "description" : " Return the number of (distinct) SEC report elements in each of the given components.\n", "summary" : "<p> Return the number of (distinct) SEC report elements in each of the given components.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "networks-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> list of components or IDs</div>" } ], "returns" : { "type" : "integer*", "description" : "the said number of report elements" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "num-tables", "qname" : "sec-networks:num-tables", "signature" : "($networks-or-ids as item()*) as integer*", "description" : " Return the number of SEC Tables in each of the given components.\n", "summary" : "<p> Return the number of SEC Tables in each of the given components.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "networks-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> list of components or IDs</div>" } ], "returns" : { "type" : "integer*", "description" : "the said number of tables" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "populated-model-structures", "qname" : "sec-networks:populated-model-structures", "signature" : "($networks-or-ids as item()*) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves all facts belonging to the SEC Networks and populates the model structures.</p>\n", "summary" : "<p>  Retrieves all facts belonging to the SEC Networks and populates the model structures.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "networks-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of SEC Network objects, or their XBRL Component IDs.</div>" } ], "returns" : { "type" : "object()*", "description" : "the populated model structures (Facts array fields)." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "populated-model-structures", "qname" : "sec-networks:populated-model-structures", "signature" : "($networks-or-ids as item()*, $options as object()?) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Retrieves all facts belonging to the SEC Networks and populates the model structures.</p>\n", "summary" : "<p>  Retrieves all facts belonging to the SEC Networks and populates the model structures.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "networks-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of SEC Network objects, or their XBRL Component IDs.</div>" }, { "name" : "options", "type" : "object()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> <a href=\"core#standard_options\">standard SEC BizQL options</a>.</div>" } ], "returns" : { "type" : "object()*", "description" : "the populated model structures (Facts array fields)." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "sub-categories", "qname" : "sec-networks:sub-categories", "signature" : "($networks-or-ids) as string*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Return the sub-categories of the supplied SEC networks (Detail, TextBlockLevel4, TextBLockLevel1to3).</p>\n", "summary" : "<p>  Return the sub-categories of the supplied SEC networks (Detail, TextBlockLevel4, TextBLockLevel1to3).</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "networks-or-ids", "type" : null, "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of SEC Network objects, or their XBRL Component IDs.</div>" } ], "returns" : { "type" : "string*", "description" : "the sub-category of each network." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "summaries", "qname" : "sec-networks:summaries", "signature" : "($networks-or-ids) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Return summary information for the supplied SEC networks.</p>\n", "summary" : "<p>  Return summary information for the supplied SEC networks.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "networks-or-ids", "type" : null, "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of SEC Network objects, or their XBRL Component IDs.</div>" } ], "returns" : { "type" : "object()*", "description" : "one object per network, containing a summary." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "tables", "qname" : "sec-networks:tables", "signature" : "($networks-or-ids as item()*) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns all SEC Tables contained in the supplied SEC Networks.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">SEC Tables are XBRL hypercubes.</p>\n", "summary" : "<p>  Returns all SEC Tables contained in the supplied SEC Networks.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "networks-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of SEC Network objects, or their XBRL Component IDs.</div>" } ], "returns" : { "type" : "object()*", "description" : "the SEC Tables." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "tables", "qname" : "sec-networks:tables", "signature" : "($networks-or-ids as item()*, $options as object()?) as object()*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns all SEC Tables contained in the supplied SEC Networks.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">SEC Tables are XBRL hypercubes.</p>\n", "summary" : "<p>  Returns all SEC Tables contained in the supplied SEC Networks.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "networks-or-ids", "type" : "item()", "occurrence" : "*", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> a sequence of SEC Network objects, or their XBRL Component IDs.</div>" }, { "name" : "options", "type" : "object()", "occurrence" : "?", "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> <a href=\"core#standard_options\">standard SEC BizQL options</a>.</div>" } ], "returns" : { "type" : "object()*", "description" : "the SEC Tables." }, "errors" : [  ] } ], "variables" : [ { "name" : "sec-networks:BALANCE_SHEET", "type" : "xs:string", "description" : " Disclosure for the balance sheet.\n" }, { "name" : "sec-networks:BALANCE_SHEET_PARENTHETICAL", "type" : "xs:string", "description" : " Disclosure for the parenthetical balance sheet.\n" }, { "name" : "sec-networks:INCOME_STATEMENT", "type" : "xs:string", "description" : " Disclosure for the income statement.\n" }, { "name" : "sec-networks:INCOME_STATEMENT_PARENTHETICAL", "type" : "xs:string", "description" : " Disclosure for the parenthetical income statement.\n" }, { "name" : "sec-networks:STATEMENT_OF_COMPREHENSIVE_INCOME", "type" : "xs:string", "description" : " Disclosure for the statement of comprehensive income.\n" }, { "name" : "sec-networks:CASH_FLOW_STATEMENT", "type" : "xs:string", "description" : " Disclosure for the cash flow statement.\n" }, { "name" : "sec-networks:CASH_FLOW_STATEMENT_PARENTHETICAL", "type" : "xs:string", "description" : " Disclosure for the parenthetical cash flow statement.\n" }, { "name" : "sec-networks:DEFAULT_COMPONENT", "type" : "xs:string", "description" : " Disclosure for the default component.\n" }, { "name" : "sec-networks:DOCUMENT_AND_ENTITY_INFO", "type" : "xs:string", "description" : " Disclosure for the document and entity information\n" } ] }, "http://www.28msec.com/modules/http/request" : { "ns" : "http://www.28msec.com/modules/http/request", "description" : " The Sausalito request module provides functions for accessing\n information contained in the current HTTP request. For example,\n the <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">parameter-names</tt> function can be used to retrieve all\n the names of the parameters contained in a request.\n", "sees" : [  ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">28msec</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [ { "uri" : "http://www.28msec.com/modules/http/request", "prefix" : "request" }, { "uri" : "http://www.zorba-xquery.com/modules/cryptography/hmac", "prefix" : "sec" }, { "uri" : "http://zorba.io/options/versioning", "prefix" : "ver" } ], "functions" : [ { "isDocumented" : true, "arity" : 0, "name" : "binary-content", "qname" : "request:binary-content", "signature" : "() as xs:base64Binary external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the content of the request as base64Binary.</p>\n", "summary" : "<p>  Returns the content of the request as base64Binary.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:base64Binary", "description" : "The content of the request as base64Binary." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">request:no-binary-content if the content contained in the body of the request cannot be treated as binary because it is a request with multipart or url-encoded content.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "binary-part", "qname" : "request:binary-part", "signature" : "($ref as xs:string) as xs:base64Binary external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the value of a part as base64Binary.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">A part is identified by a reference that is the value of a\n <tt>src</tt> attribute returned by the <tt>request:parts</tt> function.</p>\n", "summary" : "<p>  Returns the value of a part as base64Binary.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "ref", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the part</div>" } ], "returns" : { "type" : "xs:base64Binary", "description" : "the value of the part as base64Binary" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">request:invalid-part if the part with the given name ($ref) does not exist</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">request:non-multipart if the current request does not contain multipart content</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">request:invalid-multipart if the multipart content is invalid (e.g. the boundary is missing)</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 0, "name" : "content-length", "qname" : "request:content-length", "signature" : "() as xs:integer? external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the length of the content in bytes.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The value returned corresponds to the value of the HTTP\n content-length header. The function returns an empty sequence\n if this header does not exist in the request or its value\n could not be converted to item of type xs:integer</p>.\n", "summary" : "<p>  Returns the length of the content in bytes.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:integer?", "description" : "The content-length in bytes of the content sent with this request or the empty sequence if the content-length header does not exist in the request." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "content-type", "qname" : "request:content-type", "signature" : "() as xs:string? external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the content-type of the data sent with this request.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Note that the content-type is only set for PUT and POST requests.</p>\n", "summary" : "<p>  Returns the content-type of the data sent with this request.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:string?", "description" : "The content-type of the request if it is a PUT or POST request. Otherwise, it returns the empty sequence." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "header-accept", "qname" : "request:header-accept", "signature" : "() as element(request:accept)*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the values of the HTTP ACCEPT header.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The data is returned as a sequence of elements with name\n <tt>request:accept</tt> as shown in the following example.</p>\n <code xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n  &lt;request:accept xmlns:request=\"http://www.28msec.com/modules/http/request\"&gt;\n    &lt;request:type&gt;text&lt;/request:type&gt;\n    &lt;request:subtype&gt;html&lt;/request:subtype&gt;\n    &lt;request:quality&gt;1&lt;/request:quality&gt;\n  &lt;/request:accept&gt;\n  &lt;request:accept xmlns=\"http://www.28msec.com/modules/http/request\"&gt;\n    &lt;request:type&gt;application&lt;/request:type&gt;\n    &lt;request:quality&gt;0.9&lt;/request:quality&gt;\n  &lt;/request:accept&gt;\n </code>\n", "summary" : "<p>  Returns the values of the HTTP ACCEPT header.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "element(request:accept)*", "description" : "The header values of the header ACCEPT or the empty sequence if the header is not contained in the request. The order of the returned elements reflects the order of the components in the header." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "header-names", "qname" : "request:header-names", "signature" : "() as xs:string* external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the names of all the HTTP headers in this request.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Header fields are colon-separated name-value pairs, terminated\n by a carriage return (CR) and line feed (LF) character sequence. The\n names and values of each header are allowed to consist of US-ASCII\n characters only.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The names of the headers are returned using upper-case letters.\n If a header with the same name is contained multiple times in a request,\n its name is only returned once. The order of the names in the resulting\n sequence does not reflect the order of the headers in the request. If\n a header does not have a value, it is as if the header does not exist\n in the request.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Note that the header names user-agent and content-type are not\n returned by this function. They are returned by the corresponding\n functions of this module module\n (e.g. <a href=\"#user-agent-0\">user-agent</a>).</p>\n", "summary" : "<p>  Returns the names of all the HTTP headers in this request.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:string*", "description" : "The names of the headers of this request or the empty sequence if no headers are contained in the request." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "header-value", "qname" : "request:header-value", "signature" : "($name as xs:string) as xs:string? external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the value of the HTTP header with the given name.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Header fields are colon-separated name-value pairs, terminated\n by a carriage return (CR) and line feed (LF) character sequence. The\n names and values of each header are allowed to consist of US-ASCII\n characters only.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Please note that header names are considered case-insensitive.\n Also note, that only one value is returned if multiple headers with the\n same names exist in the request. This value is a comma-separated list\n of the values of the headers in the order in which the headers appeared\n in the request.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">All headers having a name that starts with SAUSALITO_ are reserved\n and will not be returned by this function.</p>\n", "summary" : "<p>  Returns the value of the HTTP header with the given name.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "name", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The header name for which the value should be returned.</div>" } ], "returns" : { "type" : "xs:string?", "description" : "The header value of the header with the <tt xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">$name</tt> argument or the empty sequence if no header with that name is contained in the request." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "method-delete", "qname" : "request:method-delete", "signature" : "() as xs:boolean external", "description" : " Returns true if the HTTP method of this request is DELETE.\n", "summary" : "<p> Returns true if the HTTP method of this request is DELETE.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:boolean", "description" : "true if the HTTP method of this request is DELETE, false otherwise." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "method-get", "qname" : "request:method-get", "signature" : "() as xs:boolean external", "description" : " Returns true if the HTTP method of this request is GET.\n", "summary" : "<p> Returns true if the HTTP method of this request is GET.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:boolean", "description" : "true if the HTTP method of this request is GET, false otherwise." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "method-head", "qname" : "request:method-head", "signature" : "() as xs:boolean external", "description" : " Returns true if the HTTP method of this request is HEAD.\n", "summary" : "<p> Returns true if the HTTP method of this request is HEAD.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:boolean", "description" : "true if the HTTP method of this request is HEAD, false otherwise." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "method-options", "qname" : "request:method-options", "signature" : "() as xs:boolean external", "description" : " Returns true if the HTTP method of this request is OPTION.\n", "summary" : "<p> Returns true if the HTTP method of this request is OPTION.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:boolean", "description" : "true if the HTTP method of this request is OPTION, false otherwise." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "method-patch", "qname" : "request:method-patch", "signature" : "() as xs:boolean external", "description" : " Returns true if the HTTP method of this request is PATCH.\n", "summary" : "<p> Returns true if the HTTP method of this request is PATCH.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:boolean", "description" : "true if the HTTP method of this request is PATCH, false otherwise." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "method-post", "qname" : "request:method-post", "signature" : "() as xs:boolean external", "description" : " Returns true if the HTTP method of this request is POST.\n", "summary" : "<p> Returns true if the HTTP method of this request is POST.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:boolean", "description" : "true if the HTTP method of this request is POST, false otherwise." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "method-put", "qname" : "request:method-put", "signature" : "() as xs:boolean external", "description" : " Returns true if the HTTP method of this request is PUT.\n", "summary" : "<p> Returns true if the HTTP method of this request is PUT.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:boolean", "description" : "true if the HTTP method of this request is PUT, false otherwise." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "method", "qname" : "request:method", "signature" : "() as xs:string external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the name of the HTTP method used to make this request.</p>\n", "summary" : "<p>  Returns the name of the HTTP method used to make this request.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:string", "description" : "The request method used to make this request (i.e. GET, POST, PUT, DELETE or HEAD)." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "parameter-names", "qname" : "request:parameter-names", "signature" : "() as xs:string*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the names of the parameters contained in the current request.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Parameters are name-value pairs contained in the query string of the URL\n used to make this request. As defined in RFC 1738, the query string of a\n URL starts with a \"?\" character and ends with the character (if any).\n Additionally, such name-value pairs may be part of the request's body if\n it is a PUT or POST request and the content-type of the request is\n \"application/x-www-form-urlencoded\". Name-value pairs are separated\n using either the \"&amp;\" or the \";\" character.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">In general, the names and the values  are precent-encoded. This function\n does the decoding of the parameters, i.e. it returns the values being\n not percent-encoded.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Also, the names of each parameter (after being precent-decoded) are\n treated as UTF-8. Please see the <tt>http:parameter-names#1</tt> function\n for retrieving parameter names submitted using a encoding other than UTF-8.\n </p>\n", "summary" : "<p>  Returns the names of the parameters contained in the current request.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:string*", "description" : "The names of all parameters in this request. The empty sequence is returned if there are none." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "parameter-names", "qname" : "request:parameter-names", "signature" : "($encoding as xs:string) as xs:string* external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the names of the parameters contained in the current request.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is similar to the <tt>request:parameter-names#0</tt> function.\n However, the names are treated (after precent-decoding) using the\n given encoding supplied as parameter. For example, parameters might\n be encoded using the ISO-8859-1 encoding.</p>\n", "summary" : "<p>  Returns the names of the parameters contained in the current request.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "encoding", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The encoding of the parameters in the request (e.g. ISO-8859-1).</div>" } ], "returns" : { "type" : "xs:string*", "description" : "The names of all parameters in this request. The empty sequence is returned if there are none." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">request:invalid-encoding if the given encoding is invalid or not supported.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "parameter-values", "qname" : "request:parameter-values", "signature" : "($name as xs:string) as xs:string*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns a sequence of parameter values for the given parameter name\n which are contained in the URL's query string or the body of a POST or PUT\n request.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Parameters are name-value pairs contained in the query string of the URL\n used to make this request. As defined in RFC 1738, the query string of a\n URL starts with a \"?\" character and ends with the character (if any).\n Additionally, such name-value pairs may be part of the request's body if\n it is a PUT or POST request and the content-type of the request is\n \"application/x-www-form-urlencoded\". Name-value pairs are separated\n using either the \"&amp;\" or the \";\" character.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">In general, the names and the values  are precent-encoded. This function\n does the decoding of the parameters, i.e. it returns the values being\n not percent-encoded.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Also, the names and the values of each parameter (after being precent-decoded)\n are treated as UTF-8. Please see the <tt>http:parameter-values#3</tt> function\n for retrieving parameters submitted using a encoding other than UTF-8.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function returns the empty-sequence if no parameter with the\n given name exists in this request. If you want the function to return\n a default value other than the empty sequence, use the\n <tt>http:parameter-values#2</tt> function.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">A URL could contain the following query string:\n <tt>name1=value1&amp;name2=value2;name1=value3&amp;name3</tt>.\n <tt>name1=value1&amp;name2=value2&amp;name1=value3&amp;name3</tt>.\n The name value pairs in this query string are\n <ul>\n   <li> name: <tt>name1</tt>; values: <tt>value1</tt> and <tt>value3</tt></li>\n   <li> name: <tt>name2</tt>; value: <tt>value2</tt></li>\n   <li> name: <tt>name3</tt>; value: <tt/></li>\n </ul>\n </p>\n", "summary" : "<p>  Returns a sequence of parameter values for the given parameter name\n which are contained in the URL's query string or the body of a POST or PUT\n request.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "name", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The name of the parameter whose value(s) should be returned.</div>" } ], "returns" : { "type" : "xs:string*", "description" : "A sequence of values for the parameter with the given name. The empty sequence is returned if no parameter exists with the given name." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "parameter-values", "qname" : "request:parameter-values", "signature" : "($name as xs:string, $default-values as xs:string*) as xs:string*", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns a sequence of parameter values for the given parameter name\n which are contained in the URL's query string or the body of a POST or PUT\n request.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is similar to the <tt>request:parameter-values#1</tt> function.\n However, instead of returning the empty-sequence as a default value it returns\n the given default-values sequence if no parameter with the given name is found\n in this request.</p>\n", "summary" : "<p>  Returns a sequence of parameter values for the given parameter name\n which are contained in the URL's query string or the body of a POST or PUT\n request.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "name", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The name of the parameter whose value(s) should be returned.</div>" }, { "name" : "default-values", "type" : "xs:string", "occurrence" : "*", "description" : "" } ], "returns" : { "type" : "xs:string*", "description" : "A sequence of values for the parameter with the given name. The sequence given as $default-values parameter is returned if no parameter exists with the given name." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 3, "name" : "parameter-values", "qname" : "request:parameter-values", "signature" : "($name as xs:string, $default-values as xs:string*, $encoding as xs:string) as xs:string* external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns a sequence of parameter values for the given parameter name\n which are contained in the URL's query string or the body of a POST or PUT\n request.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function is similar to the <tt>request:parameter-values#2</tt> function.\n However, the names and values are treated (after precent-decoding) using the\n given encoding supplied as third parameter. For example, parameters might\n be encoded using the ISO-8859-1 encoding.</p>\n", "summary" : "<p>  Returns a sequence of parameter values for the given parameter name\n which are contained in the URL's query string or the body of a POST or PUT\n request.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "name", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The name of the parameter whose value(s) should be returned.</div>" }, { "name" : "default-values", "type" : "xs:string", "occurrence" : "*", "description" : "" }, { "name" : "encoding", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> The encoding of the parameters in the request (e.g. ISO-8859-1)</div>" } ], "returns" : { "type" : "xs:string*", "description" : "A sequence of values for the parameter with the given name. The sequence given as $default-values parameter is returned if no parameter exists with the given name." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">request:invalid-encoding if the given encoding is invalid or not supported.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 0, "name" : "parts", "qname" : "request:parts", "signature" : "() as element(request:multipart) external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the metadata of all parts contained in a multipart request.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The data is returned as an element with name <tt>request:mulitpart</tt>\n as shown in the following example.</p>\n <code xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">\n  &lt;multipart xmlns=\"http://www.28msec.com/modules/http/request\"\n    media-type=\"multipart/...; boundary=...\"&gt;\n    &lt;header name=\"Content-Disposition\" value='form-data; filename=\"...\"'/&gt;\n    &lt;header name=\"Content-Type\" value=\"application/octet-stream\"/&gt;\n    &lt;body filename=\"...\" src=\"...\"/&gt;\n    &lt;header name=\"Content-Disposition\" value='form-data; filename=\"...\"'/&gt;\n    &lt;header name=\"Content-Type\" value=\"application/octet-stream\"/&gt;\n    &lt;body filename=\"...\" src=\"...\"/&gt;\n  &lt;/multipart&gt;\n </code>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The <tt>media-type</tt> is the type of the content as given in the\n request (i.e. it's value is equal to the value returned by\n <tt>request:header-values(\"Content-Type\")</tt>).</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Within the <tt>multipart</tt> element is a sequence of\n (<tt>header</tt>*,<tt>body</tt>) elements. Each such group corresponds to\n one part. Every <tt>header</tt> belongs to a header for this part and the\n <tt>body</tt> refers to the value of a part. The actual value of a part\n can be retrieved by passing the value of the <tt>src</tt> attribute of\n the <tt>body</tt> to the <tt>request:text-part</tt> or\n <tt>request:binary-part</tt> functions. The other attributes of the\n <tt>body</tt> element represent a parameter of the Content-Disposition\n header as described in RFC 2183 (e.g. filename, name, creation-date).</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Please note that recursive multipart content is not supported.</p>\n", "summary" : "<p>  Returns the metadata of all parts contained in a multipart request.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "element(request:multipart)", "description" : "a multipart element representing the meta data of the multipart content" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">request:non-multipart if the current request does not contain multipart content</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">request:invalid-multipart if the multipart content is invalid (e.g. the boundary is missing)</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 0, "name" : "path", "qname" : "request:path", "signature" : "() as xs:string", "description" : " Return the path component of the request URI. The path starts after the\n host and ends before the query string starts.\n", "summary" : "<p> Return the path component of the request URI.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:string", "description" : "The path component of the request URI" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "query-string", "qname" : "request:query-string", "signature" : "() as xs:string external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the query string that was used to make this request.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The query string contains the part of the request URL that\n starts with the '?' character to the end or the starting of the\n fragment (i.e. the '#' character).</p>\n", "summary" : "<p>  Returns the query string that was used to make this request.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:string", "description" : "The query string part of the request's URL" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "remote-addr", "qname" : "request:remote-addr", "signature" : "() as xs:string external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the IP address of the client to which this request\n is connected.</p>\n", "summary" : "<p>  Returns the IP address of the client to which this request\n is connected.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:string", "description" : "The IP address on the client side to which this request is connected." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "remote-port", "qname" : "request:remote-port", "signature" : "() as xs:int external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the port of the client to which this request is connected.</p>\n", "summary" : "<p>  Returns the port of the client to which this request is connected.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:int", "description" : "The port on the client side to which this request is connected." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "server-name", "qname" : "request:server-name", "signature" : "() as xs:string external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the server name of the server running the application.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The web server's hostname or IP address.</p>\n", "summary" : "<p>  Returns the server name of the server running the application.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:string", "description" : "The name of the server that runs the application accepting this request." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "server-port", "qname" : "request:server-port", "signature" : "() as xs:int external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the sever port to which the client making the current request\n is connected.</p>\n", "summary" : "<p>  Returns the sever port to which the client making the current request\n is connected.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:int", "description" : "The server port to which the client is connected." }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "text-content", "qname" : "request:text-content", "signature" : "() as xs:string external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the content of the request as string.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The function returns the content of the request only\n if the content-type refers to a type that can be treated\n as text (e.g. text/* or application/xml). The function raises\n an error if the content cannot be treated as text.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The text content is interpreted using the encoding/charset\n that is specified in the Content-Type header of the request. If\n no charset is specified, the default ISO-8859-1 is used. If a encoding\n other than the specified or default one should be used, the\n <tt>request:text-content#1</tt> function should be used.</p>\n", "summary" : "<p>  Returns the content of the request as string.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:string", "description" : "The content of the request as a string." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">request:invalid-encoding if the encoding specified in the Content-Type header is invalid or not supported.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">request:no-text-content if the content contained in the body of the request cannot be treated as text.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "text-content", "qname" : "request:text-content", "signature" : "($overwrite-encoding as xs:string) as xs:string external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the content of the request as string interpreting\n it with the given encoding.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The function returns the content of the request only\n if the content-type refers to a type that can be treated\n as text (e.g. text/* or application/xml). The function raises\n an error if the content cannot be treated as text.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The text content is interpreted using the given encoding/charset.\n That is, the charset specified in the Content-Type header of the request\n is ignored. An error is raised if the given encoding is invalid\n or not supported.</p>\n", "summary" : "<p>  Returns the content of the request as string interpreting\n it with the given encoding.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "overwrite-encoding", "type" : "xs:string", "occurrence" : null, "description" : "" } ], "returns" : { "type" : "xs:string", "description" : "The content of the request as a string." }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">request:invalid-encoding if the encoding specified in the Content-Type header or the $overwrite-encoding parameter is invalid or not supported.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">request:no-text-content if the content contained in the body of the request cannot be treated as text.</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 1, "name" : "text-part", "qname" : "request:text-part", "signature" : "($ref as xs:string) as xs:string external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the value of a part as string</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">A part is identified by a reference that is the value of a\n <tt>src</tt> attribute returned by the <tt>request:parts</tt> function.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The value of the text part is interpreted using the encoding/charset\n given in the headers of the part. If no encoding is given, the default\n US-ASCII is assumed.</p>\n", "summary" : "<p>  Returns the value of a part as string \n  A part is identified by a reference that is the value of a\n  src  attribute returned by the  request:parts  function.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "ref", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the part</div>" } ], "returns" : { "type" : "xs:string", "description" : "the value of the part as string" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">request:invalid-encoding if the encoding given in the headers of the part is invalid or not supported.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">request:no-text-content if the value of the part cannot be treated as text</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">request:invalid-part if the part with the given name ($ref) does not exist</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">request:non-multipart if the current request does not contain multipart content</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">request:invalid-multipart if the multipart content is invalid (e.g. the boundary is missing)</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 2, "name" : "text-part", "qname" : "request:text-part", "signature" : "($ref as xs:string, $overwrite-encoding as xs:string) as xs:string external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the value of a part as string interpreting\n it with the given encoding.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">A part is identified by a reference that is the value of a\n <tt>src</tt> attribute returned by the <tt>request:parts</tt> function.</p>\n", "summary" : "<p>  Returns the value of a part as string interpreting\n it with the given encoding.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "ref", "type" : "xs:string", "occurrence" : null, "description" : "<div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"> the name of the part</div>" }, { "name" : "overwrite-encoding", "type" : "xs:string", "occurrence" : null, "description" : "" } ], "returns" : { "type" : "xs:string", "description" : "the value of the part as string" }, "errors" : [ "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">request:invalid-encoding if the encoding given using the $overwrite-encoding parameter is invalid or not supported.</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">request:no-text-content if the value of the part cannot be treated as text</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">request:invalid-part if the part with the given name ($ref) does not exist</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">request:non-multipart if the current request does not contain multipart content</xqdoc:error>", "<xqdoc:error xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">request:invalid-multipart if the multipart content is invalid (e.g. the boundary is missing)</xqdoc:error>" ] }, { "isDocumented" : true, "arity" : 0, "name" : "uri", "qname" : "request:uri", "signature" : "() as xs:string external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the URI that was used to make this request.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">The value returned contains the part of the URL starting\n from the path to the end or the starting of the fragment (i.e.\n the '#' character).</p>\n", "summary" : "<p>  Returns the URI that was used to make this request.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:string", "description" : "The path and query string part of the request's URL" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "user-agent", "qname" : "request:user-agent", "signature" : "() as xs:string? external", "description" : " <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">Returns the user agent that made to perform the current request.</p>\n <p xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">This function returns the value of the User-Agent header\n contained in the current request.</p>\n", "summary" : "<p>  Returns the user agent that made to perform the current request.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:string?", "description" : "The user agent used to perform this request of the empty sequence if there was no User-Agent header in the request." }, "errors" : [  ] } ], "variables" : [  ] }, "http://www.w3.org/2005/xpath-functions" : { "ns" : "http://www.w3.org/2005/xpath-functions", "description" : " This module contains all the functions specified in the\n W3C XPath and XQuery Functions and Operators 3.0.\n", "sees" : [ "<xqdoc:see xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">http://www.w3.org/TR/xpath-functions-30/</xqdoc:see>" ], "authors" : [ "<xqdoc:author xmlns:xqdoc=\"http://www.xqdoc.org/1.0\">www.w3c.org</xqdoc:author>" ], "version" : null, "encoding" : "utf-8", "namespaces" : [  ], "functions" : [ { "isDocumented" : true, "arity" : 2, "name" : "QName", "qname" : "fn:QName", "signature" : "($paramURI as xs:string?, $paramQName as xs:string) as xs:QName external", "description" : " <div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">Constructs an <code>xs:QName</code> value given a namespace URI and a lexical\n             QName.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"><example role=\"signature\"><proto name=\"QName\" return-type=\"xs:QName\" isOp=\"no\" prefix=\"fn\" returnEmptyOk=\"no\" returnSeq=\"no\" returnVaries=\"no\" isSchema=\"no\" isDatatype=\"no\" isSpecial=\"no\"><arg name=\"paramURI\" type=\"xs:string?\"/><arg name=\"paramQName\" type=\"xs:string\"/></proto></example></p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">This function is <termref def=\"dt-deterministic\">deterministic</termref>, <termref def=\"dt-context-independent\">context-independent</termref>,  and <termref def=\"dt-focus-independent\">focus-independent</termref>. </p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The namespace URI in the returned QName is taken from <code>$paramURI</code>. If\n                <code>$paramURI</code> is the zero-length string or the empty sequence, it represents\n             \"no namespace\".</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The prefix (or absence of a prefix) in <code>$paramQName</code> is retained in the\n             returned <code>xs:QName</code> value.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The local name in the result is taken from the local part of\n             <code>$paramQName</code>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">A <phrase diff=\"add\" at=\"L\">dynamic</phrase> error is raised <errorref class=\"CA\" code=\"0002\"/> if <code>$paramQName</code> does\n             not have the correct lexical form for an instance of <code>xs:QName</code>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">A <phrase diff=\"add\" at=\"L\">dynamic</phrase> error is raised <errorref class=\"CA\" code=\"0002\"/> if <code>$paramURI</code> is the\n             zero-length string or the empty sequence, and the value of <code>$paramQName</code>\n             contains a colon (<code>:</code>).</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\" diff=\"add\" at=\"G\">A <phrase diff=\"add\" at=\"L\">dynamic</phrase> error <rfc2119>may</rfc2119> be raised <errorref class=\"CA\" code=\"0002\"/> if <code>$paramURI</code> is not a valid URI (XML Namespaces 1.0) or\n             IRI (XML Namespaces 1.1). </p></div>\n", "summary" : "<p>  Constructs an  xs:QName  value given a namespace URI and a lexical\n             QName.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "paramURI", "type" : "xs:string", "occurrence" : "?", "description" : "" }, { "name" : "paramQName", "type" : "xs:string", "occurrence" : null, "description" : "" } ], "returns" : { "type" : "xs:QName", "description" : "" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "abs", "qname" : "fn:abs", "signature" : "($arg as numeric?) as numeric? external", "description" : " <div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">Returns the absolute value of <code>$arg</code>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"><example role=\"signature\"><proto name=\"abs\" return-type=\"numeric?\" isOp=\"no\" prefix=\"fn\" returnEmptyOk=\"no\" returnSeq=\"no\" returnVaries=\"no\" isSchema=\"no\" isDatatype=\"no\" isSpecial=\"no\"><arg name=\"arg\" type=\"numeric?\"/></proto></example></p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">This function is <termref def=\"dt-deterministic\">deterministic</termref>, <termref def=\"dt-context-independent\">context-independent</termref>,  and <termref def=\"dt-focus-independent\">focus-independent</termref>. </p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">General rules: see <specref ref=\"numeric-value-functions\"/>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">If <code>$arg</code> is negative the function returns <code>-$arg</code>, otherwise it\n             returns <code>$arg</code>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">If the type of <code>$arg</code> is one of the four numeric types <code>xs:float</code>,\n                <code>xs:double</code>, <code>xs:decimal</code> or <code>xs:integer</code> the type\n             of the result is the same as the type of <code>$arg</code>. If the type of\n                <code>$arg</code> is a type derived from one of the numeric types, the result is an\n             instance of the base numeric type.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">For <code>xs:float</code> and <code>xs:double</code> arguments, if the argument is\n             positive zero or negative zero, then positive zero is returned. If the argument is\n             positive or negative infinity, positive infinity is returned.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\" diff=\"del\" at=\"F\">For detailed type semantics, see [Formal Semantics].</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The expression <code>fn:abs(10.5)</code> returns <code>10.5</code>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The expression <code>fn:abs(-10.5)</code> returns <code>10.5</code>.</p></div>\n", "summary" : "<p>  Returns the absolute value of  $arg .</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "arg", "type" : "numeric", "occurrence" : "?", "description" : "" } ], "returns" : { "type" : "numeric?", "description" : "" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "adjust-date-to-timezone", "qname" : "fn:adjust-date-to-timezone", "signature" : "($arg as xs:date?) as xs:date? external", "description" : " <div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">Adjusts an <code>xs:date</code> value to a specific timezone, or to no timezone\n             at all; the result is the date in the target timezone that contains the starting instant\n             of the supplied date.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"><example role=\"signature\"><proto name=\"adjust-date-to-timezone\" return-type=\"xs:date?\" isOp=\"no\" prefix=\"fn\" returnEmptyOk=\"no\" returnSeq=\"no\" returnVaries=\"no\" isSchema=\"no\" isDatatype=\"no\" isSpecial=\"no\"><arg name=\"arg\" type=\"xs:date?\"/></proto></example><example role=\"signature\"><proto name=\"adjust-date-to-timezone\" return-type=\"xs:date?\" isOp=\"no\" prefix=\"fn\" returnEmptyOk=\"no\" returnSeq=\"no\" returnVaries=\"no\" isSchema=\"no\" isDatatype=\"no\" isSpecial=\"no\"><arg name=\"arg\" type=\"xs:date?\"/><arg name=\"timezone\" type=\"xs:dayTimeDuration?\"/></proto></example></p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The one-argument form of this function is <termref def=\"dt-deterministic\">deterministic</termref>, <termref def=\"dt-context-dependent\">context-dependent</termref>,  and <termref def=\"dt-focus-independent\">focus-independent</termref>.  It depends on\n \t\timplicit timezone.\n \t</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The two-argument form of this function is <termref def=\"dt-deterministic\">deterministic</termref>, <termref def=\"dt-context-independent\">context-independent</termref>,  and <termref def=\"dt-focus-independent\">focus-independent</termref>. </p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$timezone</code> is not specified, then the effective value of\n                <code>$timezone</code> is the value of the implicit timezone in the dynamic\n             context.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> is the empty sequence, then the function returns the empty\n             sequence.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> does not have a timezone component and <code>$timezone</code> is\n             the empty sequence, then the result is the value of <code>$arg</code>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> does not have a timezone component and <code>$timezone</code> is\n             not the empty sequence, then the result is <code>$arg</code> with <code>$timezone</code>\n             as the timezone component.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> has a timezone component and <code>$timezone</code> is the empty\n             sequence, then the result is the local value of <code>$arg</code> without its timezone\n             component.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> has a timezone component and <code>$timezone</code> is not the\n             empty sequence, then the function returns the value of the expression:</p><ulist xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"><item><p>Let <code>$dt</code> be the value of <code>fn:dateTime($arg,\n                      xs:time('00:00:00'))</code>.</p></item><item><p>Let <code>$adt</code> be the value of <code>fn:adjust-dateTime-to-timezone($dt,\n                      $timezone)</code></p></item><item><p>The function returns the value of <code>xs:date($adt)</code></p></item></ulist><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">A <phrase diff=\"add\" at=\"L\">dynamic</phrase> error is raised <errorref class=\"DT\" code=\"0003\"/> if <code>$timezone</code> is less\n             than <code>-PT14H</code> or greater than <code>PT14H</code> or is not an integral number\n             of minutes.</p></div>\n", "summary" : "<p>  Adjusts an  xs:date  value to a specific timezone, or to no timezone\n             at all; the result is the date in the target timezone that contains the starting instant\n             of the supplied date.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "arg", "type" : "xs:date", "occurrence" : "?", "description" : "" } ], "returns" : { "type" : "xs:date?", "description" : "" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "adjust-date-to-timezone", "qname" : "fn:adjust-date-to-timezone", "signature" : "($arg as xs:date?, $timezone as xs:dayTimeDuration?) as xs:date? external", "description" : " <div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">Adjusts an <code>xs:date</code> value to a specific timezone, or to no timezone\n             at all; the result is the date in the target timezone that contains the starting instant\n             of the supplied date.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"><example role=\"signature\"><proto name=\"adjust-date-to-timezone\" return-type=\"xs:date?\" isOp=\"no\" prefix=\"fn\" returnEmptyOk=\"no\" returnSeq=\"no\" returnVaries=\"no\" isSchema=\"no\" isDatatype=\"no\" isSpecial=\"no\"><arg name=\"arg\" type=\"xs:date?\"/></proto></example><example role=\"signature\"><proto name=\"adjust-date-to-timezone\" return-type=\"xs:date?\" isOp=\"no\" prefix=\"fn\" returnEmptyOk=\"no\" returnSeq=\"no\" returnVaries=\"no\" isSchema=\"no\" isDatatype=\"no\" isSpecial=\"no\"><arg name=\"arg\" type=\"xs:date?\"/><arg name=\"timezone\" type=\"xs:dayTimeDuration?\"/></proto></example></p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The one-argument form of this function is <termref def=\"dt-deterministic\">deterministic</termref>, <termref def=\"dt-context-dependent\">context-dependent</termref>,  and <termref def=\"dt-focus-independent\">focus-independent</termref>.  It depends on\n \t\timplicit timezone.\n \t</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The two-argument form of this function is <termref def=\"dt-deterministic\">deterministic</termref>, <termref def=\"dt-context-independent\">context-independent</termref>,  and <termref def=\"dt-focus-independent\">focus-independent</termref>. </p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$timezone</code> is not specified, then the effective value of\n                <code>$timezone</code> is the value of the implicit timezone in the dynamic\n             context.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> is the empty sequence, then the function returns the empty\n             sequence.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> does not have a timezone component and <code>$timezone</code> is\n             the empty sequence, then the result is the value of <code>$arg</code>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> does not have a timezone component and <code>$timezone</code> is\n             not the empty sequence, then the result is <code>$arg</code> with <code>$timezone</code>\n             as the timezone component.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> has a timezone component and <code>$timezone</code> is the empty\n             sequence, then the result is the local value of <code>$arg</code> without its timezone\n             component.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> has a timezone component and <code>$timezone</code> is not the\n             empty sequence, then the function returns the value of the expression:</p><ulist xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"><item><p>Let <code>$dt</code> be the value of <code>fn:dateTime($arg,\n                      xs:time('00:00:00'))</code>.</p></item><item><p>Let <code>$adt</code> be the value of <code>fn:adjust-dateTime-to-timezone($dt,\n                      $timezone)</code></p></item><item><p>The function returns the value of <code>xs:date($adt)</code></p></item></ulist><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">A <phrase diff=\"add\" at=\"L\">dynamic</phrase> error is raised <errorref class=\"DT\" code=\"0003\"/> if <code>$timezone</code> is less\n             than <code>-PT14H</code> or greater than <code>PT14H</code> or is not an integral number\n             of minutes.</p></div>\n", "summary" : "<p>  Adjusts an  xs:date  value to a specific timezone, or to no timezone\n             at all; the result is the date in the target timezone that contains the starting instant\n             of the supplied date.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "arg", "type" : "xs:date", "occurrence" : "?", "description" : "" }, { "name" : "timezone", "type" : "xs:dayTimeDuration", "occurrence" : "?", "description" : "" } ], "returns" : { "type" : "xs:date?", "description" : "" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "adjust-dateTime-to-timezone", "qname" : "fn:adjust-dateTime-to-timezone", "signature" : "($arg as xs:dateTime?) as xs:dateTime external", "description" : " <div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">Adjusts an <code>xs:dateTime</code> value to a specific timezone, or to no\n             timezone at all.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"><example role=\"signature\"><proto name=\"adjust-dateTime-to-timezone\" return-type=\"xs:dateTime?\" isOp=\"no\" prefix=\"fn\" returnEmptyOk=\"no\" returnSeq=\"no\" returnVaries=\"no\" isSchema=\"no\" isDatatype=\"no\" isSpecial=\"no\"><arg name=\"arg\" type=\"xs:dateTime?\"/></proto></example><example role=\"signature\"><proto name=\"adjust-dateTime-to-timezone\" return-type=\"xs:dateTime?\" isOp=\"no\" prefix=\"fn\" returnEmptyOk=\"no\" returnSeq=\"no\" returnVaries=\"no\" isSchema=\"no\" isDatatype=\"no\" isSpecial=\"no\"><arg name=\"arg\" type=\"xs:dateTime?\"/><arg name=\"timezone\" type=\"xs:dayTimeDuration?\"/></proto></example></p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The one-argument form of this function is <termref def=\"dt-deterministic\">deterministic</termref>, <termref def=\"dt-context-dependent\">context-dependent</termref>,  and <termref def=\"dt-focus-independent\">focus-independent</termref>.  It depends on\n \t\timplicit timezone.\n \t</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The two-argument form of this function is <termref def=\"dt-deterministic\">deterministic</termref>, <termref def=\"dt-context-independent\">context-independent</termref>,  and <termref def=\"dt-focus-independent\">focus-independent</termref>. </p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$timezone</code> is not specified, then the effective value of\n                <code>$timezone</code> is the value of the implicit timezone in the dynamic\n             context.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> is the empty sequence, then the function returns the empty\n             sequence.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> does not have a timezone component and <code>$timezone</code> is\n             the empty sequence, then the result is <code>$arg</code>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> does not have a timezone component and <code>$timezone</code> is\n             not the empty sequence, then the result is <code>$arg</code> with <code>$timezone</code>\n             as the timezone component.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> has a timezone component and <code>$timezone</code> is the empty\n             sequence, then the result is the local value of <code>$arg</code> without its timezone\n             component.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> has a timezone component and <code>$timezone</code> is not the\n             empty sequence, then the result is the <code>xs:dateTime</code> value that is equal to\n                <code>$arg</code> and that has a timezone component equal to\n             <code>$timezone</code>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> A <phrase diff=\"add\" at=\"L\">dynamic</phrase> error is raised <errorref class=\"DT\" code=\"0003\"/> if <code>$timezone</code> is less\n             than <code>-PT14H</code> or greater than <code>PT14H</code> or is not an integral number\n             of minutes.</p></div>\n", "summary" : "<p>  Adjusts an  xs:dateTime  value to a specific timezone, or to no\n             timezone at all.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "arg", "type" : "xs:dateTime", "occurrence" : "?", "description" : "" } ], "returns" : { "type" : "xs:dateTime", "description" : "" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "adjust-dateTime-to-timezone", "qname" : "fn:adjust-dateTime-to-timezone", "signature" : "($arg as xs:dateTime?, $timezone as xs:dayTimeDuration?) as xs:dateTime external", "description" : " <div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">Adjusts an <code>xs:dateTime</code> value to a specific timezone, or to no\n             timezone at all.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"><example role=\"signature\"><proto name=\"adjust-dateTime-to-timezone\" return-type=\"xs:dateTime?\" isOp=\"no\" prefix=\"fn\" returnEmptyOk=\"no\" returnSeq=\"no\" returnVaries=\"no\" isSchema=\"no\" isDatatype=\"no\" isSpecial=\"no\"><arg name=\"arg\" type=\"xs:dateTime?\"/></proto></example><example role=\"signature\"><proto name=\"adjust-dateTime-to-timezone\" return-type=\"xs:dateTime?\" isOp=\"no\" prefix=\"fn\" returnEmptyOk=\"no\" returnSeq=\"no\" returnVaries=\"no\" isSchema=\"no\" isDatatype=\"no\" isSpecial=\"no\"><arg name=\"arg\" type=\"xs:dateTime?\"/><arg name=\"timezone\" type=\"xs:dayTimeDuration?\"/></proto></example></p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The one-argument form of this function is <termref def=\"dt-deterministic\">deterministic</termref>, <termref def=\"dt-context-dependent\">context-dependent</termref>,  and <termref def=\"dt-focus-independent\">focus-independent</termref>.  It depends on\n \t\timplicit timezone.\n \t</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The two-argument form of this function is <termref def=\"dt-deterministic\">deterministic</termref>, <termref def=\"dt-context-independent\">context-independent</termref>,  and <termref def=\"dt-focus-independent\">focus-independent</termref>. </p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$timezone</code> is not specified, then the effective value of\n                <code>$timezone</code> is the value of the implicit timezone in the dynamic\n             context.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> is the empty sequence, then the function returns the empty\n             sequence.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> does not have a timezone component and <code>$timezone</code> is\n             the empty sequence, then the result is <code>$arg</code>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> does not have a timezone component and <code>$timezone</code> is\n             not the empty sequence, then the result is <code>$arg</code> with <code>$timezone</code>\n             as the timezone component.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> has a timezone component and <code>$timezone</code> is the empty\n             sequence, then the result is the local value of <code>$arg</code> without its timezone\n             component.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> has a timezone component and <code>$timezone</code> is not the\n             empty sequence, then the result is the <code>xs:dateTime</code> value that is equal to\n                <code>$arg</code> and that has a timezone component equal to\n             <code>$timezone</code>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> A <phrase diff=\"add\" at=\"L\">dynamic</phrase> error is raised <errorref class=\"DT\" code=\"0003\"/> if <code>$timezone</code> is less\n             than <code>-PT14H</code> or greater than <code>PT14H</code> or is not an integral number\n             of minutes.</p></div>\n", "summary" : "<p>  Adjusts an  xs:dateTime  value to a specific timezone, or to no\n             timezone at all.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "arg", "type" : "xs:dateTime", "occurrence" : "?", "description" : "" }, { "name" : "timezone", "type" : "xs:dayTimeDuration", "occurrence" : "?", "description" : "" } ], "returns" : { "type" : "xs:dateTime", "description" : "" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "adjust-time-to-timezone", "qname" : "fn:adjust-time-to-timezone", "signature" : "($arg as xs:time?) as xs:time? external", "description" : " <div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">Adjusts an <code>xs:time</code> value to a specific timezone, or to no timezone\n             at all.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"><example role=\"signature\"><proto name=\"adjust-time-to-timezone\" return-type=\"xs:time?\" isOp=\"no\" prefix=\"fn\" returnEmptyOk=\"no\" returnSeq=\"no\" returnVaries=\"no\" isSchema=\"no\" isDatatype=\"no\" isSpecial=\"no\"><arg name=\"arg\" type=\"xs:time?\"/></proto></example><example role=\"signature\"><proto name=\"adjust-time-to-timezone\" return-type=\"xs:time?\" isOp=\"no\" prefix=\"fn\" returnEmptyOk=\"no\" returnSeq=\"no\" returnVaries=\"no\" isSchema=\"no\" isDatatype=\"no\" isSpecial=\"no\"><arg name=\"arg\" type=\"xs:time?\"/><arg name=\"timezone\" type=\"xs:dayTimeDuration?\"/></proto></example></p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The one-argument form of this function is <termref def=\"dt-deterministic\">deterministic</termref>, <termref def=\"dt-context-dependent\">context-dependent</termref>,  and <termref def=\"dt-focus-independent\">focus-independent</termref>.  It depends on\n \t\timplicit timezone.\n \t</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The two-argument form of this function is <termref def=\"dt-deterministic\">deterministic</termref>, <termref def=\"dt-context-independent\">context-independent</termref>,  and <termref def=\"dt-focus-independent\">focus-independent</termref>. </p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$timezone</code> is not specified, then the effective value of\n                <code>$timezone</code> is the value of the implicit timezone in the dynamic\n             context.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> is the empty sequence, then the function returns the empty\n             sequence.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> does not have a timezone component and <code>$timezone</code> is\n             the empty sequence, then the result is <code>$arg</code>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> does not have a timezone component and <code>$timezone</code> is\n             not the empty sequence, then the result is <code>$arg</code> with <code>$timezone</code>\n             as the timezone component.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> has a timezone component and <code>$timezone</code> is the empty\n             sequence, then the result is the localized value of <code>$arg</code> without its\n             timezone component.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> has a timezone component and <code>$timezone</code> is not the\n             empty sequence, then:</p><ulist xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"><item><p>Let <code>$dt</code> be the <code>xs:dateTime</code> value\n                      <code>fn:dateTime(xs:date('1972-12-31'), $arg)</code>.</p></item><item><p>Let <code>$adt</code> be the value of <code>fn:adjust-dateTime-to-timezone($dt,\n                      $timezone)</code>\n                </p></item><item><p>The function returns the <code>xs:time</code> value\n                   <code>xs:time($adt)</code>.</p></item></ulist><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">A <phrase diff=\"add\" at=\"L\">dynamic</phrase> error is raised <errorref class=\"DT\" code=\"0003\"/> if <code>$timezone</code> is less\n             than <code>-PT14H</code> or greater than <code>PT14H</code> or if does not contain an\n             integral number of minutes.</p></div>\n", "summary" : "<p>  Adjusts an  xs:time  value to a specific timezone, or to no timezone\n             at all.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "arg", "type" : "xs:time", "occurrence" : "?", "description" : "" } ], "returns" : { "type" : "xs:time?", "description" : "" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "adjust-time-to-timezone", "qname" : "fn:adjust-time-to-timezone", "signature" : "($arg as xs:time?, $timezone as xs:dayTimeDuration?) as xs:time? external", "description" : " <div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">Adjusts an <code>xs:time</code> value to a specific timezone, or to no timezone\n             at all.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"><example role=\"signature\"><proto name=\"adjust-time-to-timezone\" return-type=\"xs:time?\" isOp=\"no\" prefix=\"fn\" returnEmptyOk=\"no\" returnSeq=\"no\" returnVaries=\"no\" isSchema=\"no\" isDatatype=\"no\" isSpecial=\"no\"><arg name=\"arg\" type=\"xs:time?\"/></proto></example><example role=\"signature\"><proto name=\"adjust-time-to-timezone\" return-type=\"xs:time?\" isOp=\"no\" prefix=\"fn\" returnEmptyOk=\"no\" returnSeq=\"no\" returnVaries=\"no\" isSchema=\"no\" isDatatype=\"no\" isSpecial=\"no\"><arg name=\"arg\" type=\"xs:time?\"/><arg name=\"timezone\" type=\"xs:dayTimeDuration?\"/></proto></example></p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The one-argument form of this function is <termref def=\"dt-deterministic\">deterministic</termref>, <termref def=\"dt-context-dependent\">context-dependent</termref>,  and <termref def=\"dt-focus-independent\">focus-independent</termref>.  It depends on\n \t\timplicit timezone.\n \t</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The two-argument form of this function is <termref def=\"dt-deterministic\">deterministic</termref>, <termref def=\"dt-context-independent\">context-independent</termref>,  and <termref def=\"dt-focus-independent\">focus-independent</termref>. </p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$timezone</code> is not specified, then the effective value of\n                <code>$timezone</code> is the value of the implicit timezone in the dynamic\n             context.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> is the empty sequence, then the function returns the empty\n             sequence.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> does not have a timezone component and <code>$timezone</code> is\n             the empty sequence, then the result is <code>$arg</code>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> does not have a timezone component and <code>$timezone</code> is\n             not the empty sequence, then the result is <code>$arg</code> with <code>$timezone</code>\n             as the timezone component.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> has a timezone component and <code>$timezone</code> is the empty\n             sequence, then the result is the localized value of <code>$arg</code> without its\n             timezone component.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"> If <code>$arg</code> has a timezone component and <code>$timezone</code> is not the\n             empty sequence, then:</p><ulist xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"><item><p>Let <code>$dt</code> be the <code>xs:dateTime</code> value\n                      <code>fn:dateTime(xs:date('1972-12-31'), $arg)</code>.</p></item><item><p>Let <code>$adt</code> be the value of <code>fn:adjust-dateTime-to-timezone($dt,\n                      $timezone)</code>\n                </p></item><item><p>The function returns the <code>xs:time</code> value\n                   <code>xs:time($adt)</code>.</p></item></ulist><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">A <phrase diff=\"add\" at=\"L\">dynamic</phrase> error is raised <errorref class=\"DT\" code=\"0003\"/> if <code>$timezone</code> is less\n             than <code>-PT14H</code> or greater than <code>PT14H</code> or if does not contain an\n             integral number of minutes.</p></div>\n", "summary" : "<p>  Adjusts an  xs:time  value to a specific timezone, or to no timezone\n             at all.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "arg", "type" : "xs:time", "occurrence" : "?", "description" : "" }, { "name" : "timezone", "type" : "xs:dayTimeDuration", "occurrence" : "?", "description" : "" } ], "returns" : { "type" : "xs:time?", "description" : "" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 2, "name" : "analyze-string", "qname" : "fn:analyze-string", "signature" : "($input as xs:string?, $pattern as xs:string) as element(fn:analyze-string-result) external", "description" : " <div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">Analyzes a string using a regular expression, returning an XML structure that\n             identifies which parts of the input string matched or failed to match the regular\n             expression, and in the case of matched substrings, which substrings matched each\n             capturing group in the regular expression.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"><example role=\"signature\"><proto name=\"analyze-string\" return-type=\"element(fn:analyze-string-result)\" isOp=\"no\" prefix=\"fn\" returnEmptyOk=\"no\" returnSeq=\"no\" returnVaries=\"no\" isSchema=\"no\" isDatatype=\"no\" isSpecial=\"no\"><arg name=\"input\" type=\"xs:string?\"/><arg name=\"pattern\" type=\"xs:string\"/></proto></example><example role=\"signature\"><proto name=\"analyze-string\" return-type=\"element(fn:analyze-string-result)\" isOp=\"no\" prefix=\"fn\" returnEmptyOk=\"no\" returnSeq=\"no\" returnVaries=\"no\" isSchema=\"no\" isDatatype=\"no\" isSpecial=\"no\"><arg name=\"input\" type=\"xs:string?\"/><arg name=\"pattern\" type=\"xs:string\"/><arg name=\"flags\" type=\"xs:string\"/></proto></example></p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">This function is <termref def=\"dt-nondeterministic\">nondeterministic</termref>, <termref def=\"dt-context-independent\">context-independent</termref>,  and <termref def=\"dt-focus-independent\">focus-independent</termref>. </p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The effect of calling the first version of this function (omitting the argument\n                <code>$flags</code>) is the same as the effect of calling the second version with the\n                <code>$flags</code> argument set to a zero-length string. Flags are defined in\n                <specref ref=\"flags\"/>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The <code>$flags</code> argument is interpreted in the same way as for the\n                <code>fn:matches</code> function.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">If <code>$input</code> is the empty sequence the function behaves as if\n                <code>$input</code> were the zero-length string. In this situation the result will be\n             an element node with no children.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The function returns an element node whose local name is\n                <code>analyze-string-result</code>. This element and all its descendant elements have\n             the namespace URI <code>http://www.w3.org/2005/xpath-functions</code>. The namespace\n             prefix is <termref def=\"implementation-dependent\"/>. The children of this element are a\n             sequence of <code>fn:match</code> and <code>fn:non-match</code> elements. This sequence\n             is formed by breaking the <code>$input</code> string into a sequence of strings,\n             returning any substring that matches <code>$pattern</code> as the content of a\n                <code>match</code> element, and any intervening substring as the content of a\n                <code>non-match</code> element.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">More specifically, the function starts at the beginning of the input string and attempts\n             to find the first substring that matches the regular expression. If there are several\n             matches, the first match is defined to be the one whose starting position comes first in\n             the string. If several alternatives within the regular expression both match at the same\n             position in the input string, then the match that is chosen is the first alternative\n             that matches. For example, if the input string is <code>The quick brown fox jumps</code>\n             and the regular expression is <code>jump|jumps</code>, then the match that is chosen is\n                <code>jump</code>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">Having found the first match, the instruction proceeds to find the second and subsequent\n             matches by repeating the search, starting at the first <termref def=\"character\">character</termref> that was not included in the previous match.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The input string is thus partitioned into a sequence of substrings, some of which match\n             the regular expression, others which do not match it. Each substring will contain at\n             least one character. This sequence is represented in the result by the sequence of\n                <code>fn:match</code> and <code>fn:non-match</code> children of the returned element\n             node; the string value of the <code>fn:match</code> or <code>fn:non-match</code> element\n             will be the corresponding substring of <code>$input</code>, and the string value of the\n             returned element node will therefore be the same as <code>$input</code>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The content of an <code>fn:non-match</code> element is always a single text node.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The content of a <code>fn:match</code> element, however, is in general a sequence of\n             text nodes and <code>fn:group</code> element children. An <code>fn:group</code> element\n             with a <code>nr</code> attribute having the integer value <var>N</var> identifies the\n             substring captured by the <var>Nth</var> parenthesized sub-expression in the regular\n             expression. For each capturing subexpression there will be at most one corresponding\n                <code>fn:group</code> element in each <code>fn:match</code> element in the\n             result.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">If the function is called twice with the same arguments, it is <termref def=\"implementation-dependent\"/> whether the two calls return the same element node\n             or distinct (but deep equal) element nodes. In this respect it is\n             <termref def=\"nondeterministic\">nondeterministic</termref>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\" diff=\"add\" at=\"J\">The base URI of the element nodes in the result is\n          <termref def=\"implementation-dependent\"/></p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">A schema is defined for the structure of the returned element, containing the\n             definitions below. The returned element and its descendants will have type annotations\n             obtained by validating the returned element against this schema, unless the function is\n             used in an environment where type annotations are not supported (for example, a Basic\n             XSLT Processor), in which case the elements will all be annotated as\n                <code>xs:untyped</code> and the attributes as <code>xs:untypedAtomic</code>.</p><note xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"><p diff=\"add\" at=\"M\">A free-standing copy of this schema can be found at <loc xmlns:xlink=\"http://www.w3.org/1999/xlink\" href=\"analyze-string.xsd\" xlink:type=\"simple\" xlink:show=\"replace\" xlink:actuate=\"onRequest\">analyze-string.xsd</loc></p></note><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">\n             <eg xml:space=\"preserve\">&lt;?xml version=\"1.0\" encoding=\"UTF-8\"?&gt;\n &lt;xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n     targetNamespace=\"http://www.w3.org/2005/xpath-functions\"\n     xmlns:fn=\"http://www.w3.org/2005/xpath-functions\"\n     elementFormDefault=\"qualified\"&gt;\n     &lt;xs:element name=\"analyze-string-result\" type=\"fn:analyze-string-result-type\"/&gt;\n     &lt;xs:element name=\"match\" type=\"fn:match-type\"/&gt;\n     &lt;xs:element name=\"non-match\" type=\"xs:string\"/&gt;\n     &lt;xs:element name=\"group\" type=\"fn:group-type\"/&gt;\n     &lt;xs:complexType name=\"analyze-string-result-type\" mixed=\"true\"&gt;\n         &lt;xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\"&gt;\n             &lt;xs:element ref=\"fn:match\"/&gt;\n             &lt;xs:element ref=\"fn:non-match\"/&gt;\n         &lt;/xs:choice&gt;\n     &lt;/xs:complexType&gt;\n     &lt;xs:complexType name=\"match-type\" mixed=\"true\"&gt;\n         &lt;xs:sequence&gt;\n             &lt;xs:element ref=\"fn:group\" minOccurs=\"0\" maxOccurs=\"unbounded\"/&gt;\n         &lt;/xs:sequence&gt;\n     &lt;/xs:complexType&gt;\n     &lt;xs:complexType name=\"group-type\" mixed=\"true\"&gt;\n         &lt;xs:sequence&gt;\n             &lt;xs:element ref=\"fn:group\" minOccurs=\"0\" maxOccurs=\"unbounded\"/&gt;\n         &lt;/xs:sequence&gt;\n         &lt;xs:attribute name=\"nr\" type=\"xs:positiveInteger\"/&gt;\n     &lt;/xs:complexType&gt;\n &lt;/xs:schema&gt;\n </eg>\n          </p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">A <phrase diff=\"add\" at=\"L\">dynamic</phrase> error is raised <errorref class=\"RX\" code=\"0002\"/> if the value of\n                <code>$pattern</code> is invalid according to the rules described in section <specref ref=\"regex-syntax\"/>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">A <phrase diff=\"add\" at=\"L\">dynamic</phrase> error is raised <errorref class=\"RX\" code=\"0001\"/> if the value of\n                <code>$flags</code> is invalid according to the rules described in section <specref ref=\"regex-syntax\"/>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">A <phrase diff=\"add\" at=\"L\">dynamic</phrase> error is raised <errorref class=\"RX\" code=\"0003\"/> if the supplied\n                <code>$pattern</code> matches a zero-length string, that is, if <code>fn:matches(\"\",\n                $pattern, $flags)</code> returns <code>true</code>.</p></div>\n", "summary" : "<p>  Analyzes a string using a regular expression, returning an XML structure that\n             identifies which parts of the input string matched or failed to match the regular\n             expression, and in the case of matched substrings, which substrings matched each\n             capturing group in the regular expression.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "input", "type" : "xs:string", "occurrence" : "?", "description" : "" }, { "name" : "pattern", "type" : "xs:string", "occurrence" : null, "description" : "" } ], "returns" : { "type" : "element(fn:analyze-string-result)", "description" : "" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 3, "name" : "analyze-string", "qname" : "fn:analyze-string", "signature" : "($input as xs:string?, $pattern as xs:string, $flags as xs:string) as element(fn:analyze-string-result) external", "description" : " <div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">Analyzes a string using a regular expression, returning an XML structure that\n             identifies which parts of the input string matched or failed to match the regular\n             expression, and in the case of matched substrings, which substrings matched each\n             capturing group in the regular expression.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"><example role=\"signature\"><proto name=\"analyze-string\" return-type=\"element(fn:analyze-string-result)\" isOp=\"no\" prefix=\"fn\" returnEmptyOk=\"no\" returnSeq=\"no\" returnVaries=\"no\" isSchema=\"no\" isDatatype=\"no\" isSpecial=\"no\"><arg name=\"input\" type=\"xs:string?\"/><arg name=\"pattern\" type=\"xs:string\"/></proto></example><example role=\"signature\"><proto name=\"analyze-string\" return-type=\"element(fn:analyze-string-result)\" isOp=\"no\" prefix=\"fn\" returnEmptyOk=\"no\" returnSeq=\"no\" returnVaries=\"no\" isSchema=\"no\" isDatatype=\"no\" isSpecial=\"no\"><arg name=\"input\" type=\"xs:string?\"/><arg name=\"pattern\" type=\"xs:string\"/><arg name=\"flags\" type=\"xs:string\"/></proto></example></p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">This function is <termref def=\"dt-nondeterministic\">nondeterministic</termref>, <termref def=\"dt-context-independent\">context-independent</termref>,  and <termref def=\"dt-focus-independent\">focus-independent</termref>. </p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The effect of calling the first version of this function (omitting the argument\n                <code>$flags</code>) is the same as the effect of calling the second version with the\n                <code>$flags</code> argument set to a zero-length string. Flags are defined in\n                <specref ref=\"flags\"/>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The <code>$flags</code> argument is interpreted in the same way as for the\n                <code>fn:matches</code> function.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">If <code>$input</code> is the empty sequence the function behaves as if\n                <code>$input</code> were the zero-length string. In this situation the result will be\n             an element node with no children.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The function returns an element node whose local name is\n                <code>analyze-string-result</code>. This element and all its descendant elements have\n             the namespace URI <code>http://www.w3.org/2005/xpath-functions</code>. The namespace\n             prefix is <termref def=\"implementation-dependent\"/>. The children of this element are a\n             sequence of <code>fn:match</code> and <code>fn:non-match</code> elements. This sequence\n             is formed by breaking the <code>$input</code> string into a sequence of strings,\n             returning any substring that matches <code>$pattern</code> as the content of a\n                <code>match</code> element, and any intervening substring as the content of a\n                <code>non-match</code> element.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">More specifically, the function starts at the beginning of the input string and attempts\n             to find the first substring that matches the regular expression. If there are several\n             matches, the first match is defined to be the one whose starting position comes first in\n             the string. If several alternatives within the regular expression both match at the same\n             position in the input string, then the match that is chosen is the first alternative\n             that matches. For example, if the input string is <code>The quick brown fox jumps</code>\n             and the regular expression is <code>jump|jumps</code>, then the match that is chosen is\n                <code>jump</code>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">Having found the first match, the instruction proceeds to find the second and subsequent\n             matches by repeating the search, starting at the first <termref def=\"character\">character</termref> that was not included in the previous match.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The input string is thus partitioned into a sequence of substrings, some of which match\n             the regular expression, others which do not match it. Each substring will contain at\n             least one character. This sequence is represented in the result by the sequence of\n                <code>fn:match</code> and <code>fn:non-match</code> children of the returned element\n             node; the string value of the <code>fn:match</code> or <code>fn:non-match</code> element\n             will be the corresponding substring of <code>$input</code>, and the string value of the\n             returned element node will therefore be the same as <code>$input</code>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The content of an <code>fn:non-match</code> element is always a single text node.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The content of a <code>fn:match</code> element, however, is in general a sequence of\n             text nodes and <code>fn:group</code> element children. An <code>fn:group</code> element\n             with a <code>nr</code> attribute having the integer value <var>N</var> identifies the\n             substring captured by the <var>Nth</var> parenthesized sub-expression in the regular\n             expression. For each capturing subexpression there will be at most one corresponding\n                <code>fn:group</code> element in each <code>fn:match</code> element in the\n             result.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">If the function is called twice with the same arguments, it is <termref def=\"implementation-dependent\"/> whether the two calls return the same element node\n             or distinct (but deep equal) element nodes. In this respect it is\n             <termref def=\"nondeterministic\">nondeterministic</termref>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\" diff=\"add\" at=\"J\">The base URI of the element nodes in the result is\n          <termref def=\"implementation-dependent\"/></p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">A schema is defined for the structure of the returned element, containing the\n             definitions below. The returned element and its descendants will have type annotations\n             obtained by validating the returned element against this schema, unless the function is\n             used in an environment where type annotations are not supported (for example, a Basic\n             XSLT Processor), in which case the elements will all be annotated as\n                <code>xs:untyped</code> and the attributes as <code>xs:untypedAtomic</code>.</p><note xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"><p diff=\"add\" at=\"M\">A free-standing copy of this schema can be found at <loc xmlns:xlink=\"http://www.w3.org/1999/xlink\" href=\"analyze-string.xsd\" xlink:type=\"simple\" xlink:show=\"replace\" xlink:actuate=\"onRequest\">analyze-string.xsd</loc></p></note><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">\n             <eg xml:space=\"preserve\">&lt;?xml version=\"1.0\" encoding=\"UTF-8\"?&gt;\n &lt;xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n     targetNamespace=\"http://www.w3.org/2005/xpath-functions\"\n     xmlns:fn=\"http://www.w3.org/2005/xpath-functions\"\n     elementFormDefault=\"qualified\"&gt;\n     &lt;xs:element name=\"analyze-string-result\" type=\"fn:analyze-string-result-type\"/&gt;\n     &lt;xs:element name=\"match\" type=\"fn:match-type\"/&gt;\n     &lt;xs:element name=\"non-match\" type=\"xs:string\"/&gt;\n     &lt;xs:element name=\"group\" type=\"fn:group-type\"/&gt;\n     &lt;xs:complexType name=\"analyze-string-result-type\" mixed=\"true\"&gt;\n         &lt;xs:choice minOccurs=\"0\" maxOccurs=\"unbounded\"&gt;\n             &lt;xs:element ref=\"fn:match\"/&gt;\n             &lt;xs:element ref=\"fn:non-match\"/&gt;\n         &lt;/xs:choice&gt;\n     &lt;/xs:complexType&gt;\n     &lt;xs:complexType name=\"match-type\" mixed=\"true\"&gt;\n         &lt;xs:sequence&gt;\n             &lt;xs:element ref=\"fn:group\" minOccurs=\"0\" maxOccurs=\"unbounded\"/&gt;\n         &lt;/xs:sequence&gt;\n     &lt;/xs:complexType&gt;\n     &lt;xs:complexType name=\"group-type\" mixed=\"true\"&gt;\n         &lt;xs:sequence&gt;\n             &lt;xs:element ref=\"fn:group\" minOccurs=\"0\" maxOccurs=\"unbounded\"/&gt;\n         &lt;/xs:sequence&gt;\n         &lt;xs:attribute name=\"nr\" type=\"xs:positiveInteger\"/&gt;\n     &lt;/xs:complexType&gt;\n &lt;/xs:schema&gt;\n </eg>\n          </p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">A <phrase diff=\"add\" at=\"L\">dynamic</phrase> error is raised <errorref class=\"RX\" code=\"0002\"/> if the value of\n                <code>$pattern</code> is invalid according to the rules described in section <specref ref=\"regex-syntax\"/>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">A <phrase diff=\"add\" at=\"L\">dynamic</phrase> error is raised <errorref class=\"RX\" code=\"0001\"/> if the value of\n                <code>$flags</code> is invalid according to the rules described in section <specref ref=\"regex-syntax\"/>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">A <phrase diff=\"add\" at=\"L\">dynamic</phrase> error is raised <errorref class=\"RX\" code=\"0003\"/> if the supplied\n                <code>$pattern</code> matches a zero-length string, that is, if <code>fn:matches(\"\",\n                $pattern, $flags)</code> returns <code>true</code>.</p></div>\n", "summary" : "<p>  Analyzes a string using a regular expression, returning an XML structure that\n             identifies which parts of the input string matched or failed to match the regular\n             expression, and in the case of matched substrings, which substrings matched each\n             capturing group in the regular expression.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "input", "type" : "xs:string", "occurrence" : "?", "description" : "" }, { "name" : "pattern", "type" : "xs:string", "occurrence" : null, "description" : "" }, { "name" : "flags", "type" : "xs:string", "occurrence" : null, "description" : "" } ], "returns" : { "type" : "element(fn:analyze-string-result)", "description" : "" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "available-environment-variables", "qname" : "fn:available-environment-variables", "signature" : "() as xs:string* external", "description" : " <div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">Returns a list of environment variable names that are suitable for passing to\n                <code>fn:environment-variable</code>, as a (possibly empty) sequence of strings.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"><example role=\"signature\"><proto name=\"available-environment-variables\" return-type=\"xs:string*\" isOp=\"no\" prefix=\"fn\" returnEmptyOk=\"no\" returnSeq=\"no\" returnVaries=\"no\" isSchema=\"no\" isDatatype=\"no\" isSpecial=\"no\"/></example></p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">This function is <termref def=\"dt-deterministic\">deterministic</termref>, <termref def=\"dt-context-dependent\">context-dependent</termref>,  and <termref def=\"dt-focus-independent\">focus-independent</termref>.  It depends on\n \t\tenvironment variables.\n \t</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The function returns a sequence of strings, being the names of the environment variables\n             in the dynamic context in some <termref def=\"implementation-dependent\">implementation-dependent</termref> order.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The function is <termref def=\"dt-deterministic\">deterministic</termref>: that is, the\n             set of available environment variables does not vary during evaluation.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The function returns a list of strings, containing no duplicates.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">It is intended that the strings in this list should be suitable for passing to\n                <code>fn:environment-variable</code>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">See also the note on security under the definition of the\n                <code>fn:environment-variable</code> function. If access to environment variables has\n             been disabled, <code>fn:available-environment-variables</code> always returns the empty\n             sequence.</p></div>\n", "summary" : "<p>  Returns a list of environment variable names that are suitable for passing to\n                 fn:environment-variable , as a (possibly empty) sequence of strings.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:string*", "description" : "" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "available-environment-variables", "qname" : "fn:available-environment-variables", "signature" : "() as xs:string* external", "description" : " <div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">Returns a list of environment variable names that are suitable for passing to\n                <code>fn:environment-variable</code>, as a (possibly empty) sequence of strings.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"><example role=\"signature\"><proto name=\"available-environment-variables\" return-type=\"xs:string*\" isOp=\"no\" prefix=\"fn\" returnEmptyOk=\"no\" returnSeq=\"no\" returnVaries=\"no\" isSchema=\"no\" isDatatype=\"no\" isSpecial=\"no\"/></example></p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">This function is <termref def=\"dt-deterministic\">deterministic</termref>, <termref def=\"dt-context-dependent\">context-dependent</termref>,  and <termref def=\"dt-focus-independent\">focus-independent</termref>.  It depends on\n \t\tenvironment variables.\n \t</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The function returns a sequence of strings, being the names of the environment variables\n             in the dynamic context in some <termref def=\"implementation-dependent\">implementation-dependent</termref> order.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The function is <termref def=\"dt-deterministic\">deterministic</termref>: that is, the\n             set of available environment variables does not vary during evaluation.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The function returns a list of strings, containing no duplicates.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">It is intended that the strings in this list should be suitable for passing to\n                <code>fn:environment-variable</code>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">See also the note on security under the definition of the\n                <code>fn:environment-variable</code> function. If access to environment variables has\n             been disabled, <code>fn:available-environment-variables</code> always returns the empty\n             sequence.</p></div>\n", "summary" : "<p>  Returns a list of environment variable names that are suitable for passing to\n                 fn:environment-variable , as a (possibly empty) sequence of strings.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:string*", "description" : "" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "avg", "qname" : "fn:avg", "signature" : "($arg as xs:anyAtomicType*) as xs:anyAtomicType? external", "description" : " <div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">Returns the average of the values in the input sequence <code>$arg</code>, that\n             is, the sum of the values divided by the number of values.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"><example role=\"signature\"><proto name=\"avg\" return-type=\"xs:anyAtomicType?\" isOp=\"no\" prefix=\"fn\" returnEmptyOk=\"no\" returnSeq=\"no\" returnVaries=\"no\" isSchema=\"no\" isDatatype=\"no\" isSpecial=\"no\"><arg name=\"arg\" type=\"xs:anyAtomicType*\"/></proto></example></p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">This function is <termref def=\"dt-deterministic\">deterministic</termref>, <termref def=\"dt-context-independent\">context-independent</termref>,  and <termref def=\"dt-focus-independent\">focus-independent</termref>. </p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">If <code>$arg</code> is the empty sequence, the empty sequence is returned.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">If <code>$arg</code> contains values of type <code>xs:untypedAtomic</code> they are cast\n             to <code>xs:double</code>. </p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">Duration values must either all be <code>xs:yearMonthDuration</code> values or must all\n             be <code>xs:dayTimeDuration</code> values. For numeric values, the numeric promotion\n             rules defined in <specref ref=\"op.numeric\"/> are used to promote all values to a single\n             common type. After these operations, <code>$arg</code> must contain items of a single\n             type, which must be one of the four numeric types, <code>xs:yearMonthDuration</code> or\n                <code>xs:dayTimeDuration</code> or one if its subtypes.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The function returns the average of the values as <code>sum($arg) div\n             count($arg)</code>; but the implementation may use an otherwise equivalent algorithm\n             that avoids arithmetic overflow.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\" diff=\"del\" at=\"F\">For detailed type semantics, see [Formal Semantics].</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">A type error is raised <errorref class=\"RG\" code=\"0006\"/> if the input sequence contains\n             items of incompatible types, as described above.</p></div>\n", "summary" : "<p>  Returns the average of the values in the input sequence  $arg , that\n             is, the sum of the values divided by the number of values.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "arg", "type" : "xs:anyAtomicType", "occurrence" : "*", "description" : "" } ], "returns" : { "type" : "xs:anyAtomicType?", "description" : "" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 0, "name" : "base-uri", "qname" : "fn:base-uri", "signature" : "() as xs:anyURI? external", "description" : " <div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">Returns the base URI of a node.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"><example role=\"signature\"><proto name=\"base-uri\" return-type=\"xs:anyURI?\" isOp=\"no\" prefix=\"fn\" returnEmptyOk=\"no\" returnSeq=\"no\" returnVaries=\"no\" isSchema=\"no\" isDatatype=\"no\" isSpecial=\"no\"/></example><example role=\"signature\"><proto name=\"base-uri\" return-type=\"xs:anyURI?\" isOp=\"no\" prefix=\"fn\" returnEmptyOk=\"no\" returnSeq=\"no\" returnVaries=\"no\" isSchema=\"no\" isDatatype=\"no\" isSpecial=\"no\"><arg name=\"arg\" type=\"node()?\"/></proto></example></p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The zero-argument form of this function is <termref def=\"dt-deterministic\">deterministic</termref>, <termref def=\"dt-context-dependent\">context-dependent</termref>,  and <termref def=\"dt-focus-dependent\">focus-dependent</termref>. </p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The one-argument form of this function is <termref def=\"dt-deterministic\">deterministic</termref>, <termref def=\"dt-context-independent\">context-independent</termref>,  and <termref def=\"dt-focus-independent\">focus-independent</termref>. </p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\" diff=\"add\" at=\"B\">The zero-argument version of the function returns the base URI of the\n             context node: it is equivalent to calling <code>fn:base-uri(.)</code>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\" diff=\"add\" at=\"B\">The single-argument version of the function behaves as follows:</p><olist xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"><item>If <code>$arg</code> is the empty sequence, the function returns the empty\n                sequence.</item><item>Otherwise, the function returns the value of the <code>dm:base-uri</code> accessor\n                applied to the node <code>$arg</code>. This accessor is defined, for each kind of\n                node, in the XDM specification (See <xspecref spec=\"DM30\" ref=\"dm-base-uri\"/>).</item></olist><note xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">As explained in XDM, document, element and processing-instruction nodes have a\n             base-uri property which may be empty. The base-uri property for all other node kinds is\n             the empty sequence. The dm:base-uri accessor returns the base-uri property of a node if\n             it exists and is non-empty; otherwise it returns the result of applying the dm:base-uri\n             accessor to its parent, recursively. If the node does not have a parent, or if the\n             recursive ascent up the ancestor chain encounters a parentless node whose base-uri\n             property is empty, the empty sequence is returned. In the case of namespace nodes,\n             however, the result is always an empty sequence -- it does not depend on the base URI of\n             the parent element.</note><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">See also <code>fn:static-base-uri</code>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The following errors may be raised when <code>$arg</code> is omitted:</p><ul xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"><li><p>If the context\n                item is <xtermref ref=\"dt-absent\" spec=\"DM30\">absent</xtermref>, <phrase diff=\"add\" at=\"M\">dynamic error</phrase>\n                <xerrorref spec=\"XP\" class=\"DY\" code=\"0002\" type=\"dynamic\"/></p></li><li><p>If the context item is not a\n                node, <phrase diff=\"add\" at=\"M\">type error</phrase> <xerrorref spec=\"XP\" class=\"TY\" code=\"0004\" type=\"type\"/>.</p></li></ul></div>\n", "summary" : "<p>  Returns the base URI of a node.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [  ], "returns" : { "type" : "xs:anyURI?", "description" : "" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "base-uri", "qname" : "fn:base-uri", "signature" : "($arg as node()?) as xs:anyURI? external", "description" : " <div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">Returns the base URI of a node.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"><example role=\"signature\"><proto name=\"base-uri\" return-type=\"xs:anyURI?\" isOp=\"no\" prefix=\"fn\" returnEmptyOk=\"no\" returnSeq=\"no\" returnVaries=\"no\" isSchema=\"no\" isDatatype=\"no\" isSpecial=\"no\"/></example><example role=\"signature\"><proto name=\"base-uri\" return-type=\"xs:anyURI?\" isOp=\"no\" prefix=\"fn\" returnEmptyOk=\"no\" returnSeq=\"no\" returnVaries=\"no\" isSchema=\"no\" isDatatype=\"no\" isSpecial=\"no\"><arg name=\"arg\" type=\"node()?\"/></proto></example></p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The zero-argument form of this function is <termref def=\"dt-deterministic\">deterministic</termref>, <termref def=\"dt-context-dependent\">context-dependent</termref>,  and <termref def=\"dt-focus-dependent\">focus-dependent</termref>. </p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The one-argument form of this function is <termref def=\"dt-deterministic\">deterministic</termref>, <termref def=\"dt-context-independent\">context-independent</termref>,  and <termref def=\"dt-focus-independent\">focus-independent</termref>. </p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\" diff=\"add\" at=\"B\">The zero-argument version of the function returns the base URI of the\n             context node: it is equivalent to calling <code>fn:base-uri(.)</code>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\" diff=\"add\" at=\"B\">The single-argument version of the function behaves as follows:</p><olist xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"><item>If <code>$arg</code> is the empty sequence, the function returns the empty\n                sequence.</item><item>Otherwise, the function returns the value of the <code>dm:base-uri</code> accessor\n                applied to the node <code>$arg</code>. This accessor is defined, for each kind of\n                node, in the XDM specification (See <xspecref spec=\"DM30\" ref=\"dm-base-uri\"/>).</item></olist><note xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">As explained in XDM, document, element and processing-instruction nodes have a\n             base-uri property which may be empty. The base-uri property for all other node kinds is\n             the empty sequence. The dm:base-uri accessor returns the base-uri property of a node if\n             it exists and is non-empty; otherwise it returns the result of applying the dm:base-uri\n             accessor to its parent, recursively. If the node does not have a parent, or if the\n             recursive ascent up the ancestor chain encounters a parentless node whose base-uri\n             property is empty, the empty sequence is returned. In the case of namespace nodes,\n             however, the result is always an empty sequence -- it does not depend on the base URI of\n             the parent element.</note><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">See also <code>fn:static-base-uri</code>.</p><p xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\">The following errors may be raised when <code>$arg</code> is omitted:</p><ul xmlns:e=\"http://www.w3.org/1999/XSL/Spec/ElementSyntax\"><li><p>If the context\n                item is <xtermref ref=\"dt-absent\" spec=\"DM30\">absent</xtermref>, <phrase diff=\"add\" at=\"M\">dynamic error</phrase>\n                <xerrorref spec=\"XP\" class=\"DY\" code=\"0002\" type=\"dynamic\"/></p></li><li><p>If the context item is not a\n                node, <phrase diff=\"add\" at=\"M\">type error</phrase> <xerrorref spec=\"XP\" class=\"TY\" code=\"0004\" type=\"type\"/>.</p></li></ul></div>\n", "summary" : "<p>  Returns the base URI of a node.</p>", "annotation_str" : "", "annotations" : [  ], "updating" : false, "parameters" : [ { "name" : "arg", "type" : "node()", "occurrence" : "?", "description" : "" } ], "returns" : { "type" : "xs:anyURI?", "description" : "" }, "errors" : [  ] }, { "isDocumented" : true, "arity" : 1, "name" : "boolean", "qname" : "fn:boolean", "signature" : "($arg as item()*) as xs:boolean external", "description" : " <div xmlns:xqdoc=\"http://www.xqdoc.org/1.0\"><p xmlns:e=\"http://www.w3.org/1