export function TurbopackIconLight() {
  return (
    <svg
      width="52"
      height="52"
      viewBox="0 0 52 52"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <g clipPath="url(#clip0_967_9063)">
        <g clipPath="url(#clip1_967_9063)">
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M25.675 2.4375L12.376 10.0373L12.402 16.0095L25.675 8.4253L41.275 17.3407L46.475 20.3125V14.3221L25.675 2.4375ZM23.335 42.6543L10.075 35.0779V17.3537L10.0698 17.3511L10.0412 11.3711L4.875 14.3221V22.2469V30.1717V38.0939L18.148 45.6781L23.335 42.6543ZM41.275 35.0779V20.0369L46.475 23.0087V30.1717V38.0939L25.675 49.9811L20.4932 47.0197L25.675 43.9985V43.9907L41.275 35.0779Z"
            fill="url(#paint0_linear_967_9063)"
          />
          <path
            d="M12.415 20.0474V33.7182L25.675 41.2972V27.6238L12.415 20.0474Z"
            fill="black"
          />
          <path
            d="M25.675 11.1216L13.5928 18.0246L26.8554 25.6036L38.935 18.698L25.675 11.1216Z"
            fill="black"
          />
        </g>
      </g>
      <defs>
        <linearGradient
          id="paint0_linear_967_9063"
          x1="25.6751"
          y1="6.19135"
          x2="25.5964"
          y2="46.8163"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#0096FF" />
          <stop offset="1" stopColor="#FF1E56" />
        </linearGradient>
        <clipPath id="clip0_967_9063">
          <rect width="52" height="52" fill="white" />
        </clipPath>
        <clipPath id="clip1_967_9063">
          <rect
            width="41.6"
            height="47.5436"
            fill="white"
            transform="translate(4.875 2.4375)"
          />
        </clipPath>
      </defs>
    </svg>
  );
}

export function TurbopackIconDark() {
  return (
    <svg
      width="52"
      height="52"
      viewBox="0 0 52 52"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <g clipPath="url(#clip0_967_8735)">
        <g clipPath="url(#clip1_967_8735)">
          <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M25.675 2.4375L12.376 10.0373L12.402 16.0095L25.675 8.4253L41.275 17.3407L46.475 20.3125V14.3221L25.675 2.4375ZM23.335 42.6543L10.075 35.0779V17.3537L10.0698 17.3511L10.0412 11.3711L4.875 14.3221V22.2469V30.1717V38.0939L18.148 45.6781L23.335 42.6543ZM41.275 35.0779V20.0369L46.475 23.0087V30.1717V38.0939L25.675 49.9811L20.4932 47.0197L25.675 43.9985V43.9907L41.275 35.0779Z"
            fill="url(#paint0_linear_967_8735)"
          />
          <path
            d="M12.415 20.0474V33.7182L25.675 41.2972V27.6238L12.415 20.0474Z"
            fill="white"
          />
          <path
            d="M25.675 11.1216L13.5928 18.0246L26.8554 25.6036L38.935 18.698L25.675 11.1216Z"
            fill="white"
          />
        </g>
      </g>
      <defs>
        <linearGradient
          id="paint0_linear_967_8735"
          x1="25.6751"
          y1="6.19135"
          x2="25.5964"
          y2="46.8163"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="#0096FF" />
          <stop offset="1" stopColor="#FF1E56" />
        </linearGradient>
        <clipPath id="clip0_967_8735">
          <rect width="52" height="52" fill="white" />
        </clipPath>
        <clipPath id="clip1_967_8735">
          <rect
            width="41.6"
            height="47.5436"
            fill="white"
            transform="translate(4.875 2.4375)"
          />
        </clipPath>
      </defs>
    </svg>
  );
}

export function TurbopackIconBackground() {
  return (
    <svg
      width="84"
      height="94"
      viewBox="0 0 84 94"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M36 2.4641C39.7128 0.320508 44.2872 0.320508 48 2.4641L77.5692 19.5359C81.282 21.6795 83.5692 25.641 83.5692 29.9282V64.0718C83.5692 68.359 81.282 72.3205 77.5692 74.4641L48 91.5359C44.2872 93.6795 39.7128 93.6795 36 91.5359L6.43078 74.4641C2.71797 72.3205 0.430782 68.359 0.430782 64.0718V29.9282C0.430782 25.641 2.71797 21.6795 6.43078 19.5359L36 2.4641Z"
        fill="white"
      />
      <path
        d="M36.25 2.89711C39.8081 0.842837 44.1919 0.842837 47.75 2.89711L77.3192 19.9689C80.8773 22.0232 83.0692 25.8196 83.0692 29.9282V64.0718C83.0692 68.1804 80.8773 71.9768 77.3192 74.0311L47.75 91.1029C44.1919 93.1572 39.8081 93.1572 36.25 91.1029L6.68078 74.0311C3.12267 71.9768 0.930782 68.1804 0.930782 64.0718V29.9282C0.930782 25.8197 3.12267 22.0232 6.68078 19.9689L36.25 2.89711Z"
        stroke="url(#paint0_radial_967_9060)"
        strokeOpacity="0.15"
      />
      <path
        d="M36.25 2.89711C39.8081 0.842837 44.1919 0.842837 47.75 2.89711L77.3192 19.9689C80.8773 22.0232 83.0692 25.8196 83.0692 29.9282V64.0718C83.0692 68.1804 80.8773 71.9768 77.3192 74.0311L47.75 91.1029C44.1919 93.1572 39.8081 93.1572 36.25 91.1029L6.68078 74.0311C3.12267 71.9768 0.930782 68.1804 0.930782 64.0718V29.9282C0.930782 25.8197 3.12267 22.0232 6.68078 19.9689L36.25 2.89711Z"
        stroke="url(#paint1_linear_967_9060)"
        strokeOpacity="0.5"
      />
      <defs>
        <radialGradient
          id="paint0_radial_967_9060"
          cx="0"
          cy="0"
          r="1"
          gradientUnits="userSpaceOnUse"
          gradientTransform="translate(42 -1) rotate(90) scale(123.429)"
        >
          <stop />
          <stop offset="1" />
        </radialGradient>
        <linearGradient
          id="paint1_linear_967_9060"
          x1="-6"
          y1="-1"
          x2="15"
          y2="38"
          gradientUnits="userSpaceOnUse"
        >
          <stop />
          <stop offset="1" stopOpacity="0" />
        </linearGradient>
      </defs>
    </svg>
  );
}

export function TurbopackIconBackgroundDark() {
  return (
    <svg
      width="84"
      height="94"
      viewBox="0 0 84 94"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M36 2.4641C39.7128 0.320508 44.2872 0.320508 48 2.4641L77.5692 19.5359C81.282 21.6795 83.5692 25.641 83.5692 29.9282V64.0718C83.5692 68.359 81.282 72.3205 77.5692 74.4641L48 91.5359C44.2872 93.6795 39.7128 93.6795 36 91.5359L6.43078 74.4641C2.71797 72.3205 0.430782 68.359 0.430782 64.0718V29.9282C0.430782 25.641 2.71797 21.6795 6.43078 19.5359L36 2.4641Z"
        fill="black"
      />
      <path
        d="M47.75 2.89711L77.3192 19.9689C80.8773 22.0232 83.0692 25.8196 83.0692 29.9282V64.0718C83.0692 68.1804 80.8773 71.9768 77.3192 74.0311L47.75 91.1029C44.1919 93.1572 39.8081 93.1572 36.25 91.1029L6.68078 74.0311C3.12267 71.9768 0.930782 68.1804 0.930782 64.0718V29.9282C0.930782 25.8197 3.12267 22.0232 6.68078 19.9689L36.25 2.89711C39.8081 0.842837 44.1919 0.842837 47.75 2.89711Z"
        stroke="url(#paint0_radial_967_8731)"
        strokeOpacity="0.15"
      />
      <path
        d="M47.75 2.89711L77.3192 19.9689C80.8773 22.0232 83.0692 25.8196 83.0692 29.9282V64.0718C83.0692 68.1804 80.8773 71.9768 77.3192 74.0311L47.75 91.1029C44.1919 93.1572 39.8081 93.1572 36.25 91.1029L6.68078 74.0311C3.12267 71.9768 0.930782 68.1804 0.930782 64.0718V29.9282C0.930782 25.8197 3.12267 22.0232 6.68078 19.9689L36.25 2.89711C39.8081 0.842837 44.1919 0.842837 47.75 2.89711Z"
        stroke="url(#paint1_linear_967_8731)"
        strokeOpacity="0.5"
      />
      <defs>
        <radialGradient
          id="paint0_radial_967_8731"
          cx="0"
          cy="0"
          r="1"
          gradientUnits="userSpaceOnUse"
          gradientTransform="translate(42 -1) rotate(90) scale(123.429)"
        >
          <stop stopColor="white" />
          <stop offset="1" stopColor="white" />
        </radialGradient>
        <linearGradient
          id="paint1_linear_967_8731"
          x1="-6"
          y1="-1"
          x2="15"
          y2="38"
          gradientUnits="userSpaceOnUse"
        >
          <stop stopColor="white" />
          <stop offset="1" stopColor="white" stopOpacity="0" />
        </linearGradient>
      </defs>
    </svg>
  );
}

export function TurbopackIconOutline() {
  return (
    <svg
      width="118"
      height="134"
      viewBox="0 0 118 134"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M53.25 2.89711C56.8081 0.842836 61.1919 0.842837 64.75 2.89711L111.64 29.9689C115.198 32.0232 117.39 35.8196 117.39 39.9282V94.0718C117.39 98.1804 115.198 101.977 111.64 104.031L64.75 131.103C61.1919 133.157 56.8081 133.157 53.25 131.103L6.36027 104.031C2.80216 101.977 0.610271 98.1804 0.610271 94.0718V39.9282C0.610271 35.8196 2.80216 32.0232 6.36027 29.9689L53.25 2.89711Z"
        stroke="white"
        strokeOpacity="0.05"
      />
    </svg>
  );
}

export function Turbopack() {
  return (
    <div className="relative w-24 h-24">
      <div className="pointer-events-none absolute w-[261px] h-[261px] top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2 bg-gradient-to-b from-[#4EBFFF] to-[#BD69FF] mix-blend-normal opacity-5 dark:opacity-[0.15] blur-[60px]" />
      <div className="contents dark:hidden">
        <div className="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2">
          <TurbopackIconBackground />
        </div>
        <div className="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2">
          <TurbopackIconLight />
        </div>
      </div>
      <div className="dark:contents hidden">
        <div className="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2">
          <TurbopackIconBackgroundDark />
        </div>
        <div className="absolute top-1/2 left-1/2 -translate-x-1/2 -translate-y-1/2">
          <TurbopackIconDark />
        </div>
      </div>
    </div>
  );
}
