﻿## 개발 가이드

* [어플리케이션 배포](tutorial/application-distribution-ko.md)
* [어플리케이션 패키징](tutorial/application-packaging-ko.md)
* [네이티브 node 모듈 사용하기](tutorial/using-native-node-modules-ko.md)
* [메인 프로세스 디버깅하기](tutorial/debugging-main-process-ko.md)
* [Selenium 과 WebDriver 사용하기](tutorial/using-selenium-and-webdriver-ko.md)
* [개발자 콘솔 확장기능](tutorial/devtools-extension-ko.md)
* [Pepper 플래시 플러그인 사용하기](tutorial/using-pepper-flash-plugin-ko.md)

## 튜토리얼

* [시작하기](tutorial/quick-start-ko.md)
* [데스크톱 환경 통합](tutorial/desktop-environment-integration-ko.md)
* [온라인/오프라인 이벤트](tutorial/online-offline-events-ko.md)

## API 레퍼런스

* [개요](api/synopsis-ko.md)
* [프로세스 객체](api/process-ko.md)
* [크롬 Command-Line 스위치에 대한 지원](api/chrome-command-line-switches-ko.md)

커스텀 DOM Element:

* [`File` 객체](api/file-object-ko.md)
* [`<webview>` 태그](api/web-view-tag-ko.md)
* [`window.open` 함수](api/window-open-ko.md)

메인 프로세스를 위한 모듈들:

* [app](api/app-ko.md)
* [auto-updater](api/auto-updater-ko.md)
* [browser-window](api/browser-window-ko.md)
* [content-tracing](api/content-tracing-ko.md)
* [dialog](api/dialog-ko.md)
* [global-shortcut](api/global-shortcut-ko.md)
* [ipc (main process)](api/ipc-main-process-ko.md)
* [menu](api/menu-ko.md)
* [menu-item](api/menu-item-ko.md)
* [power-monitor](api/power-monitor-ko.md)
* [protocol](api/protocol-ko.md)
* [tray](api/tray-ko.md)

랜더러 프로세스를 위한 모듈들 (웹 페이지):

* [ipc (renderer)](api/ipc-renderer-ko.md)
* [remote](api/remote-ko.md)
* [web-frame](api/web-frame-ko.md)

두 프로세스에서 모두 사용 가능한 모듈들:

* [clipboard](api/clipboard-ko.md)
* [crash-reporter](api/crash-reporter-ko.md)
* [native-image](api/native-image-ko.md)
* [screen](api/screen-ko.md)
* [shell](api/shell-ko.md)

## 개발자용

* [코딩 스타일](development/coding-style-ko.md)
* [소스코드 구조](development/source-code-directory-structure-ko.md)
* [NW.js와 기술적으로 다른점 (이전 node-webkit)](development/atom-shell-vs-node-webkit-ko.md)
* [빌드 시스템 개요](development/build-system-overview-ko.md)
* [빌드 설명서 (Mac)](development/build-instructions-mac-ko.md)
* [빌드 설명서 (Windows)](development/build-instructions-windows-ko.md)
* [빌드 설명서 (Linux)](development/build-instructions-linux-ko.md)
* [디버거에서 디버그 심볼 서버 설정](development/setting-up-symbol-server-ko.md)

이 문서는 (@preco21)[https://github.com/preco21]이 번역하였습니다.
