## Guides

* [Application distribution](tutorial/application-distribution.md)
* [Application packaging](tutorial/application-packaging.md)
* [Using native node modules](tutorial/using-native-node-modules.md)
* [Debugging main process](tutorial/debugging-main-process.md)
* [Using Selenium and WebDriver](tutorial/using-selenium-and-webdriver.md)
* [DevTools extension](tutorial/devtools-extension.md)
* [Using pepper flash plugin](tutorial/using-pepper-flash-plugin.md)

## Tutorials

* [Quick start](tutorial/quick-start.md)
* [Desktop environment integration](tutorial/desktop-environment-integration.md)
* [Online/offline event detection](tutorial/online-offline-events.md)

## API references

* [Synopsis](api/synopsis.md)
* [Process object](api/process.md)
* [Supported Chrome command line switches](api/chrome-command-line-switches.md)

Custom DOM elements:

* [`File` object](api/file-object.md)
* [`<webview>` tag](api/web-view-tag.md)
* [`window.open` function](api/window-open.md)

Modules for the main process:

* [app](api/app.md)
* [auto-updater](api/auto-updater.md)
* [browser-window](api/browser-window.md)
* [content-tracing](api/content-tracing.md)
* [dialog](api/dialog.md)
* [global-shortcut](api/global-shortcut.md)
* [ipc (main process)](api/ipc-main-process.md)
* [menu](api/menu.md)
* [menu-item](api/menu-item.md)
* [power-monitor](api/power-monitor.md)
* [protocol](api/protocol.md)
* [tray](api/tray.md)

Modules for the renderer process (web page):

* [ipc (renderer)](api/ipc-renderer.md)
* [remote](api/remote.md)
* [web-frame](api/web-frame.md)

Modules for both processes:

* [clipboard](api/clipboard.md)
* [crash-reporter](api/crash-reporter.md)
* [native-image](api/native-image.md)
* [screen](api/screen.md)
* [shell](api/shell.md)

## Development

* [Coding style](development/coding-style.md)
* [Source code directory structure](development/source-code-directory-structure.md)
* [Technical differences to NW.js (formerly node-webkit)](development/atom-shell-vs-node-webkit.md)
* [Build system overview](development/build-system-overview.md)
* [Build instructions (Mac)](development/build-instructions-mac.md)
* [Build instructions (Windows)](development/build-instructions-windows.md)
* [Build instructions (Linux)](development/build-instructions-linux.md)
* [Setting up symbol server in debugger](development/setting-up-symbol-server.md)
