## Guias

* [Distribuir Aplicação](tutorial/application-distribution.md)
* [Empacotamento da aplicação](tutorial/application-packaging.md)
* [Usando módulos nativos](../../docs/tutorial/using-native-node-modules.md)
* [Depuração do processo principal](../../docs/tutorial/debugging-main-process.md)
* [Usando Selenium e WebDriver](../../docs/tutorial/using-selenium-and-webdriver.md)
* [Extensão DevTools](../../docs/tutorial/devtools-extension.md)
* [Usando o plugin papper flash](../../docs/tutorial/using-pepper-flash-plugin.md)

## Tutoriais

* [Introdução](tutorial/quick-start.md)
* [A integração com o ambiente de desenvolvimento](tutorial/desktop-environment-integration.md)
* [Evento de detecção on-line/off-line](tutorial/online-offline-events.md)

## API - Referencias

* [Sinopse](../../docs/api/synopsis.md)
* [Processos](api/process.md)
* [Aceleradores (Teclas de Atalho)](api/accelerator.md)
* [Parâmetros CLI suportados (Chrome)](../../docs/api/chrome-command-line-switches.md)

DOM elementos personalizados:

* [Objeto `File`](../../docs/api/file-object.md)
* [Tag `<webview>`](../../docs/api/web-view-tag.md)
* [Função `window.open`](../../docs/api/window-open.md)

Os principais módulos:

* [app](../../docs/api/app.md)
* [auto-updater](../../docs/api/auto-updater.md)
* [browser-window](../../docs/api/browser-window.md)
* [content-tracing](../../docs/api/content-tracing.md)
* [dialog](../../docs/api/dialog.md)
* [global-shortcut](../../docs/api/global-shortcut.md)
* [ipc (main process)](../../docs/api/ipc-main-process.md)
* [menu](../../docs/api/menu.md)
* [menu-item](../../docs/api/menu-item.md)
* [power-monitor](../../docs/api/power-monitor.md)
* [power-save-blocker](../../docs/api/power-save-blocker.md)
* [protocol](../../docs/api/protocol.md)
* [session](../../docs/api/session.md)
* [webContents](../../docs/api/web-contents.md)
* [tray](../../docs/api/tray.md)

Módulos do renderizador (web page):

* [ipc (renderer)](../../docs/api/ipc-renderer.md)
* [remote](../../docs/api/remote.md)
* [web-frame](../../docs/api/web-frame.md)

Módulos de ambos os processos:

* [clipboard](../../docs/api/clipboard.md)
* [crash-reporter](../../docs/api/crash-reporter.md)
* [native-image](../../docs/api/native-image.md)
* [screen](../../docs/api/screen.md)
* [shell](api/shell.md)

## Desenvolvimento

* [Estilo de código](../../docs/development/coding-style.md)
* [Estrutura de diretórios padrão](../../docs/development/source-code-directory-structure.md)
* [Diferenças técnicas do NW.js (antigo node-webkit)](../../docs/development/atom-shell-vs-node-webkit.md)
* [Visão geral do build](../../docs/development/build-system-overview.md)
* [Instrução de build (Mac)](../../docs/development/build-instructions-osx.md)
* [Instrução de build (Windows)](../../docs/development/build-instructions-windows.md)
* [Instrução de build (Linux)](../../docs/development/build-instructions-linux.md)
* [Configurando um symbol server no debugger](../../docs/development/setting-up-symbol-server.md)
