## Guías

* [Distribución de aplicaciones](tutorial/application-distribution.md)
* [Empaquetamiento de aplicaciones](tutorial/application-packaging.md)
* [Utilizando módulos nativos](tutorial/using-native-node-modules.md)
* [Depurando el proceso principal](tutorial/debugging-main-process.md)
* [Utilizando Selenium y WebDriver](tutorial/using-selenium-and-webdriver.md)
* [Extensión DevTools](tutorial/devtools-extension.md)
* [Utilizando el plugin pepper flash](tutorial/using-pepper-flash-plugin.md)

## Tutoriales

* [Introducción](../../docs/tutorial/quick-start.md)
* [Integración con el entorno de escritorio](../../docs/tutorial/desktop-environment-integration.md)
* [Detección del evento en línea/fuera de línea](../../docs/tutorial/online-offline-events.md)

## API

* [Sinopsis](../../docs/api/synopsis.md)
* [Proceso](../../docs/api/process.md)
* [Parámetros CLI soportados (Chrome)](../../docs/api/chrome-command-line-switches.md)

Elementos DOM customizados:

* [Objeto `File`](../../docs/api/file-object.md)
* [Etiqueta `<webview>`](../../docs/api/web-view-tag.md)
* [Función `window.open`](../../docs/api/window-open.md)

Módulos del proceso principal:

* [app](../../docs/api/app.md)
* [auto-updater](../../docs/api/auto-updater.md)
* [browser-window](../../docs/api/browser-window.md)
* [content-tracing](../../docs/api/content-tracing.md)
* [dialog](../../docs/api/dialog.md)
* [global-shortcut](../../docs/api/global-shortcut.md)
* [ipc (main process)](../../docs/api/ipc-main-process.md)
* [menu](../../docs/api/menu.md)
* [menu-item](../../docs/api/menu-item.md)
* [power-monitor](../../docs/api/power-monitor.md)
* [power-save-blocker](../../docs/api/power-save-blocker.md)
* [protocol](../../docs/api/protocol.md)
* [tray](../../docs/api/tray.md)

Módulos del renderer (página web):

* [ipc (renderer)](../../docs/api/ipc-renderer.md)
* [remote](../../docs/api/remote.md)
* [web-frame](../../docs/api/web-frame.md)

Módulos de ambos procesos:

* [clipboard](../../docs/api/clipboard.md)
* [crash-reporter](../../docs/api/crash-reporter.md)
* [native-image](../../docs/api/native-image.md)
* [screen](../../docs/api/screen.md)
* [shell](../../docs/api/shell.md)

## Desarrollo

* [Guía de estilo](../../docs/development/coding-style.md)
* [Estructura de directorio](../../docs/development/source-code-directory-structure.md)
* [Diferencias técnicas con NW.js (anteriormente conocido como node-webkit)](../../docs/development/atom-shell-vs-node-webkit.md)
* [Sistema de compilación](../../docs/development/build-system-overview.md)
* [Instrucciones de compilación (Mac)](../../docs/development/build-instructions-osx.md)
* [Instrucciones de compilación (Windows)](../../docs/development/build-instructions-windows.md)
* [Instrucciones de compilación (Linux)](../../docs/development/build-instructions-linux.md)
* [Configurando un servidor de símbolos en el depurador](../../docs/development/setting-up-symbol-server.md)
