﻿# 빌드 설명서 (Linux)

## 빌드전 요구사양

* Python 2.7.x. 몇몇 CentOS와 같은 배포판들은 아직도 Python 2.6.x 버전을 사용합니다. 그래서 `python -V`를 통해 버전을 확인해 줄 필요가 있습니다.
* Node.js v0.12.x. Node를 설치하는 방법은 여러가지가 있습니다. 그중 하나는 [Node.js](http://nodejs.org) 사이트에서 소스코드를 받아 빌드하는 방법입니다.
이렇게 하면 Node를 일반 유저로 홈 디렉터리에 설치할 수 있습니다. 또는 [NodeSource](https://nodesource.com/blog/nodejs-v012-iojs-and-the-nodesource-linux-repositories) 에서 받아올 수도 있습니다.
자세한 내용은 [Node.js 설치 방법](https://github.com/joyent/node/wiki/Installation) 을 참고하세요.
* Clang 3.4 또는 최신 버전
* GTK+ 와 libnotify의 개발용 헤더

Ubuntu를 사용하고 있다면 다음 커맨드로 설치하면 합니다:

```bash
$ sudo apt-get install build-essential clang libdbus-1-dev libgtk2.0-dev \
                       libnotify-dev libgnome-keyring-dev libgconf2-dev \
                       libasound2-dev libcap-dev libcups2-dev libxtst-dev \
                       libxss1 libnss3-dev gcc-multilib g++-multilib
```

다른 배포판의 경우 yum과 같은 패키지 매니저를 통해 패키지를 설치 할 수 있습니다. 패키지의 이름은 대부분 비슷할 것입니다.
또는 소스코드를 내려받아 직접 빌드하는 방법도 있습니다.

## 가상머신을 사용하여 빌드 하는 경우

만약 Electron을 가상머신으로 빌드 할 계획이라면 해당 가상머신의 스토리지를 최소 25GB 이상을 확보해 놓아야 합니다.


## 코드 가져오기

```bash
$ git clone https://github.com/atom/electron.git
```

## 부트 스트랩

부트스트랩 스크립트는 필수적인 빌드 종속성 라이브러리들을 모두 다운로드하고 프로젝트 파일을 생성합니다.
스크립트가 정상적으로 작동하기 위해선 Python 2.7.x 버전이 필요합니다.
아마 다운로드 작업이 상당히 많은 시간을 소요할 것입니다.
참고로 Electron은 빌드 툴체인으로 `ninja`를 사용하므로 `Makefile`은 생성되지 않습니다.

```bash
$ cd electron
$ ./script/bootstrap.py -v
```

### 크로스 컴파일

`arm` 아키텍쳐로 빌드 하려면 먼저 종속성 라이브러리를 설치해야 합니다:

```bash
$ sudo apt-get install libc6-dev-armhf-cross linux-libc-dev-armhf-cross \
                       g++-arm-linux-gnueabihf
```

그리고 `bootstrap.py` 스크립트의 `--target_arch` 파라미터에 `arm` 또는 `ia32` 아키텍쳐를 지정하여 크로스 컴파일 할 수 있습니다:

```bash
$ ./script/bootstrap.py -v --target_arch=arm
```

## 빌드 하기

`Release` 와 `Debug` 두 타겟 모두 빌드 합니다:

```bash
$ ./script/build.py
```

이 스크립트는 `out/R` 디렉터리에 크기가 매우 큰 Electron 실행 파일을 배치합니다. 파일 크기는 1.3GB를 초과합니다.
이러한 문제가 발생하는 이유는 Release 타겟 바이너리가 디버그 심볼을 포함하기 때문입니다.
파일 크기를 줄이려면 `create-dist.py` 스크립트를 실행하세요:

```bash
$ ./script/create-dist.py
```

이 스크립트는 매우 작은 배포판을 `dist` 디렉터리에 생성합니다.
create-dist.py 스크립트를 실행한 이후 1.3GB를 초과하는 공간을 차지하는 out/R 폴더의 실행파일 바이너리는 삭제해도 됩니다.

`Debug` 타겟만 빌드 할 수도 있습니다:

```bash
$ ./script/build.py -c D
```

빌드가 모두 끝나면 `out/D` 디렉터리에서 `electron` 디버그 바이너리를 찾을 수 있습니다.

## 정리 하기

빌드 파일들을 정리합니다:

```bash
$ ./script/clean.py
```

## 문제 해결

개발 종속성 라이브러리들을 제대로 설치했는지 확인하세요.

## libtinfo.so.5 동적 링크 라이브러리를 로드하는 도중 에러가 발생할 경우

미리 빌드된 `clang`은 `libtinfo.so.5`로 링크를 시도합니다.
플랫폼에 따라 적당한 `libncurses` symlink를 추가하세요.

```bash
$ sudo ln -s /usr/lib/libncurses.so.5 /usr/lib/libtinfo.so.5
```

## 테스트

프로젝트 코딩 스타일을 확인하려면:

```bash
$ ./script/cpplint.py
```

테스트를 실행하려면:

```bash
$ ./script/test.py
```
