# content-tracing

The `content-trace` module is used to collect tracing data generated by the
underlying Chromium content module. This module does not include a web interface
so you need to open `chrome://tracing/` in a Chrome browser and load the generated
file to view the result.

```javascript
var tracing = require('content-tracing');
tracing.startRecording('*', tracing.DEFAULT_OPTIONS, function() {
  console.log('Tracing started');

  setTimeout(function() {
    tracing.stopRecording('', function(path) {
      console.log('Tracing data recorded to ' + path);
    });
  }, 5000);
});
```

## tracing.getCategories(callback)

* `callback` Function

Get a set of category groups. The category groups can change as new code paths
are reached.

Once all child processes have acked to the `getCategories` request, `callback`
is invoked with an array of category groups.

## tracing.startRecording(categoryFilter, traceOptions, callback)

* `categoryFilter` String
* `traceOptions` String
* `callback` Function

Start recording on all processes.

Recording begins immediately locally, and asynchronously on child processes
as soon as they receive the EnableRecording request. Once all child processes
have acked to the `startRecording` request, `callback` will be called back.

`categoryFilter` is a filter to control what category groups should be
traced. A filter can have an optional `-` prefix to exclude category groups
that contain a matching category. Having both included and excluded
category patterns in the same list is not supported.

Examples:

* `test_MyTest*`,
* `test_MyTest*,test_OtherStuff`,
* `"-excluded_category1,-excluded_category2`

`traceOptions` controls what kind of tracing is enabled, it is a comma-delimited list.
Possible options are:

* `record-until-full`
* `record-continuously`
* `trace-to-console`
* `enable-sampling`
* `enable-systrace`

The first 3 options are trace recoding modes and hence mutually exclusive.
If more than one trace recording modes appear in the `traceOptions` string,
the last one takes precedence. If none of the trace recording mode is specified,
recording mode is `record-until-full`.

The trace option will first be reset to the default option (record_mode set to
`record-until-full`, enable_sampling and enable_systrace set to false)
before options parsed from `traceOptions` are applied on it.

## tracing.stopRecording(resultFilePath, callback)

* `resultFilePath` String
* `callback` Function

Stop recording on all processes.

Child processes typically are caching trace data and only rarely flush and send
trace data back to the main process. That is because it may be an expensive
operation to send the trace data over IPC, and we would like to avoid much
runtime overhead of tracing. So, to end tracing, we must asynchronously ask all
child processes to flush any pending trace data.

Once all child processes have acked to the `stopRecording` request, `callback`
will be called back with a file that contains the traced data.

Trace data will be written into `resultFilePath` if it is not empty, or into a
temporary file. The actual file path will be passed to `callback` if it's not
null.

## tracing.startMonitoring(categoryFilter, traceOptions, callback)

* `categoryFilter` String
* `traceOptions` String
* `callback` Function

Start monitoring on all processes.

Monitoring begins immediately locally, and asynchronously on child processes as
soon as they receive the `startMonitoring` request.

Once all child processes have acked to the `startMonitoring` request,
`callback` will be called back.

## tracing.stopMonitoring(callback);

* `callback` Function

Stop monitoring on all processes.

Once all child processes have acked to the `stopMonitoring` request, `callback`
is called back.

## tracing.captureMonitoringSnapshot(resultFilePath, callback)

* `resultFilePath` String
* `callback` Function

Get the current monitoring traced data.

Child processes typically are caching trace data and only rarely flush and send
trace data back to the main process. That is because it may be an expensive
operation to send the trace data over IPC, and we would like to avoid unneeded
runtime overhead of tracing. So, to end tracing, we must asynchronously ask all
child processes to flush any pending trace data.

Once all child processes have acked to the `captureMonitoringSnapshot` request,
the `callback` will be invoked with a file that contains the traced data.


## tracing.getTraceBufferUsage(callback)

* `callback` Function

Get the maximum across processes of trace buffer percent full state. When the
TraceBufferUsage value is determined, the `callback` is called.

## tracing.setWatchEvent(categoryName, eventName, callback)

* `categoryName` String
* `eventName` String
* `callback` Function

`callback` will will be called every time the given event occurs on any
process.

## tracing.cancelWatchEvent()

Cancel the watch event. If tracing is enabled, this may race with the watch
event callback.
