## Guías

* [Distribución de aplicaciones](tutorial/application-distribution-es.md)
* [Empaquetamiento de aplicaciones](tutorial/application-packaging-es.md)
* [Utilizando módulos nativos](tutorial/using-native-node-modules-es.md)
* [Depurando el proceso principal](tutorial/debugging-main-process-es.md)
* [Utilizando Selenium y WebDriver](tutorial/using-selenium-and-webdriver-es.md)
* [Extensión DevTools](tutorial/devtools-extension-es.md)
* [Utilizando el plugin pepper flash](tutorial/using-pepper-flash-plugin-es.md)

## Tutoriales

* [Introducción](tutorial/quick-start.md)
* [Integración con el entorno de escritorio](tutorial/desktop-environment-integration.md)
* [Detección del evento en línea/fuera de línea](tutorial/online-offline-events.md)

## API

* [Sinopsis](api/synopsis.md)
* [Proceso](api/process.md)
* [Parámetros CLI soportados (Chrome)](api/chrome-command-line-switches.md)

Elementos DOM customizados:

* [Objeto `File`](api/file-object.md)
* [Etiqueta `<webview>`](api/web-view-tag.md)
* [Función `window.open`](api/window-open.md)

Módulos del proceso principal:

* [app](api/app.md)
* [auto-updater](api/auto-updater.md)
* [browser-window](api/browser-window.md)
* [content-tracing](api/content-tracing.md)
* [dialog](api/dialog.md)
* [global-shortcut](api/global-shortcut.md)
* [ipc (main process)](api/ipc-main-process.md)
* [menu](api/menu.md)
* [menu-item](api/menu-item.md)
* [power-monitor](api/power-monitor.md)
* [power-save-blocker](api/power-save-blocker.md)
* [protocol](api/protocol.md)
* [tray](api/tray.md)

Módulos del renderer (página web):

* [ipc (renderer)](api/ipc-renderer.md)
* [remote](api/remote.md)
* [web-frame](api/web-frame.md)

Módulos de ambos procesos:

* [clipboard](api/clipboard.md)
* [crash-reporter](api/crash-reporter.md)
* [native-image](api/native-image.md)
* [screen](api/screen.md)
* [shell](api/shell.md)

## Desarrollo

* [Guía de estilo](development/coding-style.md)
* [Estructura de directorio](development/source-code-directory-structure.md)
* [Diferencias técnicas con NW.js (anteriormente conocido como node-webkit)](development/atom-shell-vs-node-webkit.md)
* [Sistema de compilación](development/build-system-overview.md)
* [Instrucciones de compilación (Mac)](development/build-instructions-mac.md)
* [Instrucciones de compilación (Windows)](development/build-instructions-windows.md)
* [Instrucciones de compilación (Linux)](development/build-instructions-linux.md)
* [Configurando un servidor de símbolos en el depurador](development/setting-up-symbol-server.md)
