## Guías

* [Plataformas Soportadas](tutorial/supported-platforms.md)
* [Distribución de la Aplicación](tutorial/application-distribution.md)
* [Empaquetamiento de la Aplicación](tutorial/application-packaging.md)
* [Utilizando Módulos Node Nativos](tutorial/using-native-node-modules.md)
* [Depurando el Proceso Principal](tutorial/debugging-main-process.md)
* [Utilizando Selenium y WebDriver](tutorial/using-selenium-and-webdriver.md)
* [Extensión DevTools](tutorial/devtools-extension.md)
* [Utilizando el plugin Pepper Flash](tutorial/using-pepper-flash-plugin.md)

## Tutoriales

* [Introducción](tutorial/quick-start.md)
* [Integración con el entorno de escritorio](tutorial/desktop-environment-integration.md)
* [Detección del evento en línea/fuera de línea](tutorial/online-offline-events.md)

## Referencias a la API

* [Sinopsis](api/synopsis.md)
* [Proceso](api/process.md)
* [Parámetros CLI soportados (Chrome)](api/chrome-command-line-switches.md)

### Elementos DOM personalizados:

* [Objeto `File`](../../docs/api/file-object.md)
* [Etiqueta `<webview>`](../../docs/api/web-view-tag.md)
* [Función `window.open`](../../docs/api/window-open.md)

### Módulos del Proceso Principal:

* [app](../../docs/api/app.md)
* [auto-updater](../../docs/api/auto-updater.md)
* [browser-window](../../docs/api/browser-window.md)
* [content-tracing](../../docs/api/content-tracing.md)
* [dialog](../../docs/api/dialog.md)
* [global-shortcut](../../docs/api/global-shortcut.md)
* [ipc (proceso principal)](../../docs/api/ipc-main-process.md)
* [menu](../../docs/api/menu.md)
* [menu-item](../../docs/api/menu-item.md)
* [power-monitor](../../docs/api/power-monitor.md)
* [power-save-blocker](../../docs/api/power-save-blocker.md)
* [protocol](../../docs/api/protocol.md)
* [session](../../docs/api/session.md)
* [web-contents](../../docs/api/web-contents.md)
* [tray](../../docs/api/tray.md)

### Módulos del proceso de renderizado (Página Web):

* [ipc (renderizador)](../../docs/api/ipc-renderer.md)
* [remote](../../docs/api/remote.md)
* [web-frame](../../docs/api/web-frame.md)

### Módulos de Ambos Procesos:

* [clipboard](../../docs/api/clipboard.md)
* [crash-reporter](../../docs/api/crash-reporter.md)
* [native-image](../../docs/api/native-image.md)
* [screen](../../docs/api/screen.md)
* [shell](../../docs/api/shell.md)

## Desarrollo

* [Guía de Estilo](development/coding-style.md)
* [Estructura de los directorios del Código Fuente](development/source-code-directory-structure.md)
* [Diferencias Técnicas con NW.js (anteriormente conocido como node-webkit)](development/atom-shell-vs-node-webkit.md)
* [Repaso del Sistema de Compilación](development/build-system-overview.md)
* [Instrucciones de Compilación (Mac)](development/build-instructions-osx.md)
* [Instrucciones de Compilación (Windows)](../../development/build-instructions-windows.md)
* [Instrucciones de Compilación (Linux)](development/build-instructions-linux.md)
* [Configurando un Servidor de Símbolos en el depurador](../../development/setting-up-symbol-server.md)
