使用している Electron のバージョンに応じたドキュメントを使うように確認してください。
ドキュメントのバージョン番号はページの URL の一部になっています。
そうでない場合、おそらくご使用の Electron のバージョンと互換性のない API 変更を含んだ development ブランチのドキュメントを使っているものと思われます。
その場合、atom.io の [available versions](http://electron.atom.io/docs/) リストにある別のバージョンのドキュメントに切り替えることができます。また GitHub で閲覧している場合、"Switch branches/tags" ドロップダウンを開いて、バージョンに対応したタグを選ぶこともできます。

## FAQ

頻繁に聞かれる質問がありますので、issueを作成する前にこれをチェックしてください。

* [Electron FAQ](faq/electron-faq.md)

## ガイド

* [サポートするプラットフォーム](tutorial/supported-platforms.md)
* [アプリケーションの配布](tutorial/application-distribution.md)
* [Mac App Store 提出ガイド](tutorial/mac-app-store-submission-guide.md)
* [アプリケーションのパッケージ化](tutorial/application-packaging.md)
* [ネイティブのNodeモジュールを使用する](tutorial/using-native-node-modules.md)
* [メインプロセスのデバッグ](tutorial/debugging-main-process.md)
* [Selenium と WebDriverを使用する](tutorial/using-selenium-and-webdriver.md)
* [DevTools エクステンション](tutorial/devtools-extension.md)
* [Pepper Flashプラグインを使用する](tutorial/using-pepper-flash-plugin.md)
* [Widevine CDMプラグインを使用する](tutorial/using-widevine-cdm-plugin.md)

# チュートリアル

* [クイックスタート](tutorial/quick-start.md)
* [デスクトップ環境の統合](tutorial/desktop-environment-integration.md)
* [オンライン/オフライン イベントの検知](tutorial/online-offline-events.md)

## API リファレンス

* [概要](api/synopsis.md)
