// Copyright (c) 2013 GitHub, Inc.
// Use of this source code is governed by the MIT license that can be
// found in the LICENSE file.

#include "atom/browser/atom_browser_main_parts.h"

#include "atom/browser/mac/atom_application.h"
#include "atom/browser/mac/atom_application_delegate.h"
#include "base/mac/bundle_locations.h"
#include "base/mac/foundation_util.h"
#include "ui/base/l10n/l10n_util_mac.h"

namespace atom {

void AtomBrowserMainParts::PreMainMessageLoopStart() {
  // Initialize locale setting.
  l10n_util::OverrideLocaleWithCocoaLocale();

  // Force the NSApplication subclass to be used.
  NSApplication* application = [AtomApplication sharedApplication];

  AtomApplicationDelegate* delegate = [[AtomApplicationDelegate alloc] init];
  [NSApp setDelegate:(id<NSFileManagerDelegate>)delegate];

  NSBundle* frameworkBundle = base::mac::FrameworkBundle();
  NSNib* mainNib = [[NSNib alloc] initWithNibNamed:@"MainMenu"
                                            bundle:frameworkBundle];
  [mainNib instantiateWithOwner:application topLevelObjects:nil];
  [mainNib release];

  // Prevent Cocoa from turning command-line arguments into
  // |-application:openFiles:|, since we already handle them directly.
  [[NSUserDefaults standardUserDefaults]
      setObject:@"NO" forKey:@"NSTreatUnknownArgumentsAsOpen"];
}

void AtomBrowserMainParts::FreeAppDelegate() {
  [[NSApp delegate] release];
  [NSApp setDelegate:nil];
}

}  // namespace atom
