[![Electron Logo](http://electron.atom.io/images/electron-logo.svg)](http://electron.atom.io/)

[![Build Status](https://travis-ci.org/atom/electron.svg?branch=master)](https://travis-ci.org/atom/electron)
[![devDependency Status](https://david-dm.org/atom/electron/dev-status.svg)](https://david-dm.org/atom/electron#info=devDependencies)
[![Join the Electron Community on Slack](http://atom-slack.herokuapp.com/badge.svg)](http://atom-slack.herokuapp.com/)

### [Electron](https://github.com/atom/electron/) 한국어 참조문서

:zap: *프레임워크 이름이 Atom Shell에서 Electron으로 변경되었습니다* :zap:

Electron 프레임워크는 JavaScript, HTML 그리고 CSS를 사용하여
Cross-Platform 데스크톱 어플리케이션을 개발할 수 있도록 해주는 프레임워크입니다.
[Node.js](https://nodejs.org/)와 [Chromium](http://www.chromium.org)을 기반으로
만들어졌으며 [Atom Editor](https://github.com/atom/atom)에 사용되고 있습니다.

Electron에 대한 중요한 알림을 받고 싶다면 Twitter에서
[@ElectronJS](https://twitter.com/electronjs)를 팔로우 하세요.

이 프로젝트는 기여자 규약 [행동강령](CODE_OF_CONDUCT.md)을 준수합니다. 따라서 이
프로젝트의 개발에 참여하려면 이 규약을 지켜야 합니다. 받아들일 수 없는 행위를 발견했을
경우 atom@github.com로 보고 하십시오.

## 다운로드

Linux, Windows, OS X 용으로 미리 빌드된 Electron 바이너리와 디버그 심볼이 준비되어
있습니다. [releases](https://github.com/atom/electron/releases) 페이지에서 받아 볼
수 있습니다.

또한 [`npm`](https://docs.npmjs.com/)을 통해 미리 빌드된 Electron 바이너리를 설치할
수도 있습니다:

```sh
# $PATH에 `electron` 커맨드를 등록하고 전역에 설치합니다.
npm install electron-prebuilt -g

# 개발 의존성 모듈 형태로 설치합니다.
npm install electron-prebuilt --save-dev
```

### 미러

- [China](https://npm.taobao.org/mirrors/electron)

## 참조 문서

[Docs](https://github.com/atom/electron/tree/master/docs/README.md)에 개발 지침과
API 레퍼런스가 있습니다. Electron을 빌드 하는 방법과 프로젝트에 기여하는법 또한 문서에
포함되어 있으니 참고하시기 바랍니다.

## 참조 문서 (번역)

- [브라질 포르투갈어](https://github.com/atom/electron/tree/master/docs-translations/pt-BR)
- [한국어](https://github.com/atom/electron/tree/master/docs-translations/ko-KR)
- [일본어](https://github.com/atom/electron/tree/master/docs-translations/jp)
- [스페인어](https://github.com/atom/electron/tree/master/docs-translations/es)
- [중국어 간체](https://github.com/atom/electron/tree/master/docs-translations/zh-CN)
- [중국어 번체](https://github.com/atom/electron/tree/master/docs-translations/zh-TW)
- [우크라이나어](https://github.com/atom/electron/tree/master/docs-translations/uk-UA)
- [러시아어](https://github.com/atom/electron/tree/master/docs-translations/ru-RU)

## 시작하기

[`atom/electron-quick-start`](https://github.com/atom/electron-quick-start)
저장소를 클론하여 Electron을 간단히 접해볼 수 있습니다.

## 커뮤니티

다음 링크를 통해 커뮤니티에 질문을 올리거나 토론을 나눌 수 있습니다:

- Atom 포럼의 [`electron`](http://discuss.atom.io/c/electron) 카테고리
- Freenode 채팅의 `#atom-shell` 채널
- Slack의 [`Atom`](http://atom-slack.herokuapp.com/) 채널
- [`electron-br`](https://electron-br.slack.com) *(브라질 포르투갈어)*

[awesome-electron](https://github.com/sindresorhus/awesome-electron) 프로젝트에
커뮤니티가 운영중인 유용한 예제 어플리케이션과 도구, 리소스가 있으니 한번 참고해 보시기
바랍니다.
