/* eslint-disable */
import { TypedDocumentNode as DocumentNode } from '@graphql-typed-document-node/core';
export type Maybe<T> = T | null;
export type InputMaybe<T> = Maybe<T>;
export type Exact<T extends { [key: string]: unknown }> = { [K in keyof T]: T[K] };
export type MakeOptional<T, K extends keyof T> = Omit<T, K> & { [SubKey in K]?: Maybe<T[SubKey]> };
export type MakeMaybe<T, K extends keyof T> = Omit<T, K> & { [SubKey in K]: Maybe<T[SubKey]> };
export type MakeEmpty<T extends { [key: string]: unknown }, K extends keyof T> = { [_ in K]?: never };
export type Incremental<T> =
    | T
    | { [P in keyof T]?: P extends ' $fragmentName' | '__typename' ? T[P] : never };
/** All built-in and custom scalars, mapped to their actual values */
export type Scalars = {
    ID: { input: string; output: string };
    String: { input: string; output: string };
    Boolean: { input: boolean; output: boolean };
    Int: { input: number; output: number };
    Float: { input: number; output: number };
    DateTime: { input: any; output: any };
    JSON: { input: any; output: any };
    Money: { input: number; output: number };
    Upload: { input: any; output: any };
};

export type AddFulfillmentToOrderResult =
    | CreateFulfillmentError
    | EmptyOrderLineSelectionError
    | Fulfillment
    | FulfillmentStateTransitionError
    | InsufficientStockOnHandError
    | InvalidFulfillmentHandlerError
    | ItemsAlreadyFulfilledError;

export type AddItemInput = {
    productVariantId: Scalars['ID']['input'];
    quantity: Scalars['Int']['input'];
};

export type AddItemToDraftOrderInput = {
    productVariantId: Scalars['ID']['input'];
    quantity: Scalars['Int']['input'];
};

export type AddManualPaymentToOrderResult = ManualPaymentStateError | Order;

export type AddNoteToCustomerInput = {
    id: Scalars['ID']['input'];
    isPublic: Scalars['Boolean']['input'];
    note: Scalars['String']['input'];
};

export type AddNoteToOrderInput = {
    id: Scalars['ID']['input'];
    isPublic: Scalars['Boolean']['input'];
    note: Scalars['String']['input'];
};

export type Address = Node & {
    city?: Maybe<Scalars['String']['output']>;
    company?: Maybe<Scalars['String']['output']>;
    country: Country;
    createdAt: Scalars['DateTime']['output'];
    customFields?: Maybe<Scalars['JSON']['output']>;
    defaultBillingAddress?: Maybe<Scalars['Boolean']['output']>;
    defaultShippingAddress?: Maybe<Scalars['Boolean']['output']>;
    fullName?: Maybe<Scalars['String']['output']>;
    id: Scalars['ID']['output'];
    phoneNumber?: Maybe<Scalars['String']['output']>;
    postalCode?: Maybe<Scalars['String']['output']>;
    province?: Maybe<Scalars['String']['output']>;
    streetLine1: Scalars['String']['output'];
    streetLine2?: Maybe<Scalars['String']['output']>;
    updatedAt: Scalars['DateTime']['output'];
};

export type AdjustDraftOrderLineInput = {
    orderLineId: Scalars['ID']['input'];
    quantity: Scalars['Int']['input'];
};

export type Adjustment = {
    adjustmentSource: Scalars['String']['output'];
    amount: Scalars['Money']['output'];
    data?: Maybe<Scalars['JSON']['output']>;
    description: Scalars['String']['output'];
    type: AdjustmentType;
};

export enum AdjustmentType {
    DISTRIBUTED_ORDER_PROMOTION = 'DISTRIBUTED_ORDER_PROMOTION',
    OTHER = 'OTHER',
    PROMOTION = 'PROMOTION',
}

export type Administrator = Node & {
    createdAt: Scalars['DateTime']['output'];
    customFields?: Maybe<Scalars['JSON']['output']>;
    emailAddress: Scalars['String']['output'];
    firstName: Scalars['String']['output'];
    id: Scalars['ID']['output'];
    lastName: Scalars['String']['output'];
    updatedAt: Scalars['DateTime']['output'];
    user: User;
};

export type AdministratorFilterParameter = {
    _and?: InputMaybe<Array<AdministratorFilterParameter>>;
    _or?: InputMaybe<Array<AdministratorFilterParameter>>;
    createdAt?: InputMaybe<DateOperators>;
    emailAddress?: InputMaybe<StringOperators>;
    firstName?: InputMaybe<StringOperators>;
    id?: InputMaybe<IdOperators>;
    lastName?: InputMaybe<StringOperators>;
    updatedAt?: InputMaybe<DateOperators>;
};

export type AdministratorList = PaginatedList & {
    items: Array<Administrator>;
    totalItems: Scalars['Int']['output'];
};

export type AdministratorListOptions = {
    /** Allows the results to be filtered */
    filter?: InputMaybe<AdministratorFilterParameter>;
    /** Specifies whether multiple top-level "filter" fields should be combined with a logical AND or OR operation. Defaults to AND. */
    filterOperator?: InputMaybe<LogicalOperator>;
    /** Skips the first n results, for use in pagination */
    skip?: InputMaybe<Scalars['Int']['input']>;
    /** Specifies which properties to sort the results by */
    sort?: InputMaybe<AdministratorSortParameter>;
    /** Takes n results, for use in pagination */
    take?: InputMaybe<Scalars['Int']['input']>;
};

export type AdministratorPaymentInput = {
    metadata?: InputMaybe<Scalars['JSON']['input']>;
    paymentMethod?: InputMaybe<Scalars['String']['input']>;
};

export type AdministratorRefundInput = {
    /**
     * The amount to be refunded to this particular Payment. This was introduced in
     * v2.2.0 as the preferred way to specify the refund amount. The `lines`, `shipping` and `adjustment`
     * fields will be removed in a future version.
     */
    amount?: InputMaybe<Scalars['Money']['input']>;
    paymentId: Scalars['ID']['input'];
    reason?: InputMaybe<Scalars['String']['input']>;
};

export type AdministratorSortParameter = {
    createdAt?: InputMaybe<SortOrder>;
    emailAddress?: InputMaybe<SortOrder>;
    firstName?: InputMaybe<SortOrder>;
    id?: InputMaybe<SortOrder>;
    lastName?: InputMaybe<SortOrder>;
    updatedAt?: InputMaybe<SortOrder>;
};

export type Allocation = Node &
    StockMovement & {
        createdAt: Scalars['DateTime']['output'];
        id: Scalars['ID']['output'];
        orderLine: OrderLine;
        productVariant: ProductVariant;
        quantity: Scalars['Int']['output'];
        type: StockMovementType;
        updatedAt: Scalars['DateTime']['output'];
    };

/** Returned if an attempting to refund an OrderItem which has already been refunded */
export type AlreadyRefundedError = ErrorResult & {
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
    refundId: Scalars['ID']['output'];
};

export type ApplyCouponCodeResult =
    | CouponCodeExpiredError
    | CouponCodeInvalidError
    | CouponCodeLimitError
    | Order;

export type Asset = Node & {
    createdAt: Scalars['DateTime']['output'];
    customFields?: Maybe<Scalars['JSON']['output']>;
    fileSize: Scalars['Int']['output'];
    focalPoint?: Maybe<Coordinate>;
    height: Scalars['Int']['output'];
    id: Scalars['ID']['output'];
    mimeType: Scalars['String']['output'];
    name: Scalars['String']['output'];
    preview: Scalars['String']['output'];
    source: Scalars['String']['output'];
    tags: Array<Tag>;
    type: AssetType;
    updatedAt: Scalars['DateTime']['output'];
    width: Scalars['Int']['output'];
};

export type AssetFilterParameter = {
    _and?: InputMaybe<Array<AssetFilterParameter>>;
    _or?: InputMaybe<Array<AssetFilterParameter>>;
    createdAt?: InputMaybe<DateOperators>;
    fileSize?: InputMaybe<NumberOperators>;
    height?: InputMaybe<NumberOperators>;
    id?: InputMaybe<IdOperators>;
    mimeType?: InputMaybe<StringOperators>;
    name?: InputMaybe<StringOperators>;
    preview?: InputMaybe<StringOperators>;
    source?: InputMaybe<StringOperators>;
    type?: InputMaybe<StringOperators>;
    updatedAt?: InputMaybe<DateOperators>;
    width?: InputMaybe<NumberOperators>;
};

export type AssetList = PaginatedList & {
    items: Array<Asset>;
    totalItems: Scalars['Int']['output'];
};

export type AssetListOptions = {
    /** Allows the results to be filtered */
    filter?: InputMaybe<AssetFilterParameter>;
    /** Specifies whether multiple top-level "filter" fields should be combined with a logical AND or OR operation. Defaults to AND. */
    filterOperator?: InputMaybe<LogicalOperator>;
    /** Skips the first n results, for use in pagination */
    skip?: InputMaybe<Scalars['Int']['input']>;
    /** Specifies which properties to sort the results by */
    sort?: InputMaybe<AssetSortParameter>;
    tags?: InputMaybe<Array<Scalars['String']['input']>>;
    tagsOperator?: InputMaybe<LogicalOperator>;
    /** Takes n results, for use in pagination */
    take?: InputMaybe<Scalars['Int']['input']>;
};

export type AssetSortParameter = {
    createdAt?: InputMaybe<SortOrder>;
    fileSize?: InputMaybe<SortOrder>;
    height?: InputMaybe<SortOrder>;
    id?: InputMaybe<SortOrder>;
    mimeType?: InputMaybe<SortOrder>;
    name?: InputMaybe<SortOrder>;
    preview?: InputMaybe<SortOrder>;
    source?: InputMaybe<SortOrder>;
    updatedAt?: InputMaybe<SortOrder>;
    width?: InputMaybe<SortOrder>;
};

export enum AssetType {
    BINARY = 'BINARY',
    IMAGE = 'IMAGE',
    VIDEO = 'VIDEO',
}

export type AssignAssetsToChannelInput = {
    assetIds: Array<Scalars['ID']['input']>;
    channelId: Scalars['ID']['input'];
};

export type AssignCollectionsToChannelInput = {
    channelId: Scalars['ID']['input'];
    collectionIds: Array<Scalars['ID']['input']>;
};

export type AssignFacetsToChannelInput = {
    channelId: Scalars['ID']['input'];
    facetIds: Array<Scalars['ID']['input']>;
};

export type AssignPaymentMethodsToChannelInput = {
    channelId: Scalars['ID']['input'];
    paymentMethodIds: Array<Scalars['ID']['input']>;
};

export type AssignProductVariantsToChannelInput = {
    channelId: Scalars['ID']['input'];
    priceFactor?: InputMaybe<Scalars['Float']['input']>;
    productVariantIds: Array<Scalars['ID']['input']>;
};

export type AssignProductsToChannelInput = {
    channelId: Scalars['ID']['input'];
    priceFactor?: InputMaybe<Scalars['Float']['input']>;
    productIds: Array<Scalars['ID']['input']>;
};

export type AssignPromotionsToChannelInput = {
    channelId: Scalars['ID']['input'];
    promotionIds: Array<Scalars['ID']['input']>;
};

export type AssignShippingMethodsToChannelInput = {
    channelId: Scalars['ID']['input'];
    shippingMethodIds: Array<Scalars['ID']['input']>;
};

export type AssignStockLocationsToChannelInput = {
    channelId: Scalars['ID']['input'];
    stockLocationIds: Array<Scalars['ID']['input']>;
};

export type AuthenticationInput = {
    native?: InputMaybe<NativeAuthInput>;
};

export type AuthenticationMethod = Node & {
    createdAt: Scalars['DateTime']['output'];
    id: Scalars['ID']['output'];
    strategy: Scalars['String']['output'];
    updatedAt: Scalars['DateTime']['output'];
};

export type AuthenticationResult = CurrentUser | InvalidCredentialsError;

export type BooleanCustomFieldConfig = CustomField & {
    description?: Maybe<Array<LocalizedString>>;
    internal?: Maybe<Scalars['Boolean']['output']>;
    label?: Maybe<Array<LocalizedString>>;
    list: Scalars['Boolean']['output'];
    name: Scalars['String']['output'];
    nullable?: Maybe<Scalars['Boolean']['output']>;
    readonly?: Maybe<Scalars['Boolean']['output']>;
    requiresPermission?: Maybe<Array<Permission>>;
    type: Scalars['String']['output'];
    ui?: Maybe<Scalars['JSON']['output']>;
};

/** Operators for filtering on a list of Boolean fields */
export type BooleanListOperators = {
    inList: Scalars['Boolean']['input'];
};

/** Operators for filtering on a Boolean field */
export type BooleanOperators = {
    eq?: InputMaybe<Scalars['Boolean']['input']>;
    isNull?: InputMaybe<Scalars['Boolean']['input']>;
};

/** Returned if an attempting to cancel lines from an Order which is still active */
export type CancelActiveOrderError = ErrorResult & {
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
    orderState: Scalars['String']['output'];
};

export type CancelOrderInput = {
    /** Specify whether the shipping charges should also be cancelled. Defaults to false */
    cancelShipping?: InputMaybe<Scalars['Boolean']['input']>;
    /** Optionally specify which OrderLines to cancel. If not provided, all OrderLines will be cancelled */
    lines?: InputMaybe<Array<OrderLineInput>>;
    /** The id of the order to be cancelled */
    orderId: Scalars['ID']['input'];
    reason?: InputMaybe<Scalars['String']['input']>;
};

export type CancelOrderResult =
    | CancelActiveOrderError
    | EmptyOrderLineSelectionError
    | MultipleOrderError
    | Order
    | OrderStateTransitionError
    | QuantityTooGreatError;

/** Returned if the Payment cancellation fails */
export type CancelPaymentError = ErrorResult & {
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
    paymentErrorMessage: Scalars['String']['output'];
};

export type CancelPaymentResult = CancelPaymentError | Payment | PaymentStateTransitionError;

export type Cancellation = Node &
    StockMovement & {
        createdAt: Scalars['DateTime']['output'];
        id: Scalars['ID']['output'];
        orderLine: OrderLine;
        productVariant: ProductVariant;
        quantity: Scalars['Int']['output'];
        type: StockMovementType;
        updatedAt: Scalars['DateTime']['output'];
    };

export type Channel = Node & {
    availableCurrencyCodes: Array<CurrencyCode>;
    availableLanguageCodes?: Maybe<Array<LanguageCode>>;
    code: Scalars['String']['output'];
    createdAt: Scalars['DateTime']['output'];
    /** @deprecated Use defaultCurrencyCode instead */
    currencyCode: CurrencyCode;
    customFields?: Maybe<Scalars['JSON']['output']>;
    defaultCurrencyCode: CurrencyCode;
    defaultLanguageCode: LanguageCode;
    defaultShippingZone?: Maybe<Zone>;
    defaultTaxZone?: Maybe<Zone>;
    id: Scalars['ID']['output'];
    /** Not yet used - will be implemented in a future release. */
    outOfStockThreshold?: Maybe<Scalars['Int']['output']>;
    pricesIncludeTax: Scalars['Boolean']['output'];
    seller?: Maybe<Seller>;
    token: Scalars['String']['output'];
    /** Not yet used - will be implemented in a future release. */
    trackInventory?: Maybe<Scalars['Boolean']['output']>;
    updatedAt: Scalars['DateTime']['output'];
};

/**
 * Returned when the default LanguageCode of a Channel is no longer found in the `availableLanguages`
 * of the GlobalSettings
 */
export type ChannelDefaultLanguageError = ErrorResult & {
    channelCode: Scalars['String']['output'];
    errorCode: ErrorCode;
    language: Scalars['String']['output'];
    message: Scalars['String']['output'];
};

export type ChannelFilterParameter = {
    _and?: InputMaybe<Array<ChannelFilterParameter>>;
    _or?: InputMaybe<Array<ChannelFilterParameter>>;
    code?: InputMaybe<StringOperators>;
    createdAt?: InputMaybe<DateOperators>;
    currencyCode?: InputMaybe<StringOperators>;
    defaultCurrencyCode?: InputMaybe<StringOperators>;
    defaultLanguageCode?: InputMaybe<StringOperators>;
    id?: InputMaybe<IdOperators>;
    outOfStockThreshold?: InputMaybe<NumberOperators>;
    pricesIncludeTax?: InputMaybe<BooleanOperators>;
    token?: InputMaybe<StringOperators>;
    trackInventory?: InputMaybe<BooleanOperators>;
    updatedAt?: InputMaybe<DateOperators>;
};

export type ChannelList = PaginatedList & {
    items: Array<Channel>;
    totalItems: Scalars['Int']['output'];
};

export type ChannelListOptions = {
    /** Allows the results to be filtered */
    filter?: InputMaybe<ChannelFilterParameter>;
    /** Specifies whether multiple top-level "filter" fields should be combined with a logical AND or OR operation. Defaults to AND. */
    filterOperator?: InputMaybe<LogicalOperator>;
    /** Skips the first n results, for use in pagination */
    skip?: InputMaybe<Scalars['Int']['input']>;
    /** Specifies which properties to sort the results by */
    sort?: InputMaybe<ChannelSortParameter>;
    /** Takes n results, for use in pagination */
    take?: InputMaybe<Scalars['Int']['input']>;
};

export type ChannelSortParameter = {
    code?: InputMaybe<SortOrder>;
    createdAt?: InputMaybe<SortOrder>;
    id?: InputMaybe<SortOrder>;
    outOfStockThreshold?: InputMaybe<SortOrder>;
    token?: InputMaybe<SortOrder>;
    updatedAt?: InputMaybe<SortOrder>;
};

export type Collection = Node & {
    assets: Array<Asset>;
    breadcrumbs: Array<CollectionBreadcrumb>;
    children?: Maybe<Array<Collection>>;
    createdAt: Scalars['DateTime']['output'];
    customFields?: Maybe<Scalars['JSON']['output']>;
    description: Scalars['String']['output'];
    featuredAsset?: Maybe<Asset>;
    filters: Array<ConfigurableOperation>;
    id: Scalars['ID']['output'];
    inheritFilters: Scalars['Boolean']['output'];
    isPrivate: Scalars['Boolean']['output'];
    languageCode?: Maybe<LanguageCode>;
    name: Scalars['String']['output'];
    parent?: Maybe<Collection>;
    parentId: Scalars['ID']['output'];
    position: Scalars['Int']['output'];
    productVariants: ProductVariantList;
    slug: Scalars['String']['output'];
    translations: Array<CollectionTranslation>;
    updatedAt: Scalars['DateTime']['output'];
};

export type CollectionProductVariantsArgs = {
    options?: InputMaybe<ProductVariantListOptions>;
};

export type CollectionBreadcrumb = {
    id: Scalars['ID']['output'];
    name: Scalars['String']['output'];
    slug: Scalars['String']['output'];
};

export type CollectionFilterParameter = {
    _and?: InputMaybe<Array<CollectionFilterParameter>>;
    _or?: InputMaybe<Array<CollectionFilterParameter>>;
    createdAt?: InputMaybe<DateOperators>;
    description?: InputMaybe<StringOperators>;
    id?: InputMaybe<IdOperators>;
    inheritFilters?: InputMaybe<BooleanOperators>;
    isPrivate?: InputMaybe<BooleanOperators>;
    languageCode?: InputMaybe<StringOperators>;
    name?: InputMaybe<StringOperators>;
    parentId?: InputMaybe<IdOperators>;
    position?: InputMaybe<NumberOperators>;
    slug?: InputMaybe<StringOperators>;
    updatedAt?: InputMaybe<DateOperators>;
};

export type CollectionList = PaginatedList & {
    items: Array<Collection>;
    totalItems: Scalars['Int']['output'];
};

export type CollectionListOptions = {
    /** Allows the results to be filtered */
    filter?: InputMaybe<CollectionFilterParameter>;
    /** Specifies whether multiple top-level "filter" fields should be combined with a logical AND or OR operation. Defaults to AND. */
    filterOperator?: InputMaybe<LogicalOperator>;
    /** Skips the first n results, for use in pagination */
    skip?: InputMaybe<Scalars['Int']['input']>;
    /** Specifies which properties to sort the results by */
    sort?: InputMaybe<CollectionSortParameter>;
    /** Takes n results, for use in pagination */
    take?: InputMaybe<Scalars['Int']['input']>;
    topLevelOnly?: InputMaybe<Scalars['Boolean']['input']>;
};

/**
 * Which Collections are present in the products returned
 * by the search, and in what quantity.
 */
export type CollectionResult = {
    collection: Collection;
    count: Scalars['Int']['output'];
};

export type CollectionSortParameter = {
    createdAt?: InputMaybe<SortOrder>;
    description?: InputMaybe<SortOrder>;
    id?: InputMaybe<SortOrder>;
    name?: InputMaybe<SortOrder>;
    parentId?: InputMaybe<SortOrder>;
    position?: InputMaybe<SortOrder>;
    slug?: InputMaybe<SortOrder>;
    updatedAt?: InputMaybe<SortOrder>;
};

export type CollectionTranslation = {
    createdAt: Scalars['DateTime']['output'];
    description: Scalars['String']['output'];
    id: Scalars['ID']['output'];
    languageCode: LanguageCode;
    name: Scalars['String']['output'];
    slug: Scalars['String']['output'];
    updatedAt: Scalars['DateTime']['output'];
};

export type ConfigArg = {
    name: Scalars['String']['output'];
    value: Scalars['String']['output'];
};

export type ConfigArgDefinition = {
    defaultValue?: Maybe<Scalars['JSON']['output']>;
    description?: Maybe<Scalars['String']['output']>;
    label?: Maybe<Scalars['String']['output']>;
    list: Scalars['Boolean']['output'];
    name: Scalars['String']['output'];
    required: Scalars['Boolean']['output'];
    type: Scalars['String']['output'];
    ui?: Maybe<Scalars['JSON']['output']>;
};

export type ConfigArgInput = {
    name: Scalars['String']['input'];
    /** A JSON stringified representation of the actual value */
    value: Scalars['String']['input'];
};

export type ConfigurableOperation = {
    args: Array<ConfigArg>;
    code: Scalars['String']['output'];
};

export type ConfigurableOperationDefinition = {
    args: Array<ConfigArgDefinition>;
    code: Scalars['String']['output'];
    description: Scalars['String']['output'];
};

export type ConfigurableOperationInput = {
    arguments: Array<ConfigArgInput>;
    code: Scalars['String']['input'];
};

export type Coordinate = {
    x: Scalars['Float']['output'];
    y: Scalars['Float']['output'];
};

export type CoordinateInput = {
    x: Scalars['Float']['input'];
    y: Scalars['Float']['input'];
};

/**
 * A Country of the world which your shop operates in.
 *
 * The `code` field is typically a 2-character ISO code such as "GB", "US", "DE" etc. This code is used in certain inputs such as
 * `UpdateAddressInput` and `CreateAddressInput` to specify the country.
 */
export type Country = Node &
    Region & {
        code: Scalars['String']['output'];
        createdAt: Scalars['DateTime']['output'];
        customFields?: Maybe<Scalars['JSON']['output']>;
        enabled: Scalars['Boolean']['output'];
        id: Scalars['ID']['output'];
        languageCode: LanguageCode;
        name: Scalars['String']['output'];
        parent?: Maybe<Region>;
        parentId?: Maybe<Scalars['ID']['output']>;
        translations: Array<RegionTranslation>;
        type: Scalars['String']['output'];
        updatedAt: Scalars['DateTime']['output'];
    };

export type CountryFilterParameter = {
    _and?: InputMaybe<Array<CountryFilterParameter>>;
    _or?: InputMaybe<Array<CountryFilterParameter>>;
    code?: InputMaybe<StringOperators>;
    createdAt?: InputMaybe<DateOperators>;
    enabled?: InputMaybe<BooleanOperators>;
    id?: InputMaybe<IdOperators>;
    languageCode?: InputMaybe<StringOperators>;
    name?: InputMaybe<StringOperators>;
    parentId?: InputMaybe<IdOperators>;
    type?: InputMaybe<StringOperators>;
    updatedAt?: InputMaybe<DateOperators>;
};

export type CountryList = PaginatedList & {
    items: Array<Country>;
    totalItems: Scalars['Int']['output'];
};

export type CountryListOptions = {
    /** Allows the results to be filtered */
    filter?: InputMaybe<CountryFilterParameter>;
    /** Specifies whether multiple top-level "filter" fields should be combined with a logical AND or OR operation. Defaults to AND. */
    filterOperator?: InputMaybe<LogicalOperator>;
    /** Skips the first n results, for use in pagination */
    skip?: InputMaybe<Scalars['Int']['input']>;
    /** Specifies which properties to sort the results by */
    sort?: InputMaybe<CountrySortParameter>;
    /** Takes n results, for use in pagination */
    take?: InputMaybe<Scalars['Int']['input']>;
};

export type CountrySortParameter = {
    code?: InputMaybe<SortOrder>;
    createdAt?: InputMaybe<SortOrder>;
    id?: InputMaybe<SortOrder>;
    name?: InputMaybe<SortOrder>;
    parentId?: InputMaybe<SortOrder>;
    type?: InputMaybe<SortOrder>;
    updatedAt?: InputMaybe<SortOrder>;
};

export type CountryTranslationInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    id?: InputMaybe<Scalars['ID']['input']>;
    languageCode: LanguageCode;
    name?: InputMaybe<Scalars['String']['input']>;
};

/** Returned if the provided coupon code is invalid */
export type CouponCodeExpiredError = ErrorResult & {
    couponCode: Scalars['String']['output'];
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
};

/** Returned if the provided coupon code is invalid */
export type CouponCodeInvalidError = ErrorResult & {
    couponCode: Scalars['String']['output'];
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
};

/** Returned if the provided coupon code is invalid */
export type CouponCodeLimitError = ErrorResult & {
    couponCode: Scalars['String']['output'];
    errorCode: ErrorCode;
    limit: Scalars['Int']['output'];
    message: Scalars['String']['output'];
};

/**
 * Input used to create an Address.
 *
 * The countryCode must correspond to a `code` property of a Country that has been defined in the
 * Vendure server. The `code` property is typically a 2-character ISO code such as "GB", "US", "DE" etc.
 * If an invalid code is passed, the mutation will fail.
 */
export type CreateAddressInput = {
    city?: InputMaybe<Scalars['String']['input']>;
    company?: InputMaybe<Scalars['String']['input']>;
    countryCode: Scalars['String']['input'];
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    defaultBillingAddress?: InputMaybe<Scalars['Boolean']['input']>;
    defaultShippingAddress?: InputMaybe<Scalars['Boolean']['input']>;
    fullName?: InputMaybe<Scalars['String']['input']>;
    phoneNumber?: InputMaybe<Scalars['String']['input']>;
    postalCode?: InputMaybe<Scalars['String']['input']>;
    province?: InputMaybe<Scalars['String']['input']>;
    streetLine1: Scalars['String']['input'];
    streetLine2?: InputMaybe<Scalars['String']['input']>;
};

export type CreateAdministratorInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    emailAddress: Scalars['String']['input'];
    firstName: Scalars['String']['input'];
    lastName: Scalars['String']['input'];
    password: Scalars['String']['input'];
    roleIds: Array<Scalars['ID']['input']>;
};

export type CreateAssetInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    file: Scalars['Upload']['input'];
    tags?: InputMaybe<Array<Scalars['String']['input']>>;
};

export type CreateAssetResult = Asset | MimeTypeError;

export type CreateChannelInput = {
    availableCurrencyCodes?: InputMaybe<Array<CurrencyCode>>;
    availableLanguageCodes?: InputMaybe<Array<LanguageCode>>;
    code: Scalars['String']['input'];
    /** @deprecated Use defaultCurrencyCode instead */
    currencyCode?: InputMaybe<CurrencyCode>;
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    defaultCurrencyCode?: InputMaybe<CurrencyCode>;
    defaultLanguageCode: LanguageCode;
    defaultShippingZoneId: Scalars['ID']['input'];
    defaultTaxZoneId: Scalars['ID']['input'];
    outOfStockThreshold?: InputMaybe<Scalars['Int']['input']>;
    pricesIncludeTax: Scalars['Boolean']['input'];
    sellerId?: InputMaybe<Scalars['ID']['input']>;
    token: Scalars['String']['input'];
    trackInventory?: InputMaybe<Scalars['Boolean']['input']>;
};

export type CreateChannelResult = Channel | LanguageNotAvailableError;

export type CreateCollectionInput = {
    assetIds?: InputMaybe<Array<Scalars['ID']['input']>>;
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    featuredAssetId?: InputMaybe<Scalars['ID']['input']>;
    filters: Array<ConfigurableOperationInput>;
    inheritFilters?: InputMaybe<Scalars['Boolean']['input']>;
    isPrivate?: InputMaybe<Scalars['Boolean']['input']>;
    parentId?: InputMaybe<Scalars['ID']['input']>;
    translations: Array<CreateCollectionTranslationInput>;
};

export type CreateCollectionTranslationInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    description: Scalars['String']['input'];
    languageCode: LanguageCode;
    name: Scalars['String']['input'];
    slug: Scalars['String']['input'];
};

export type CreateCountryInput = {
    code: Scalars['String']['input'];
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    enabled: Scalars['Boolean']['input'];
    translations: Array<CountryTranslationInput>;
};

export type CreateCustomerGroupInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    customerIds?: InputMaybe<Array<Scalars['ID']['input']>>;
    name: Scalars['String']['input'];
};

export type CreateCustomerInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    emailAddress: Scalars['String']['input'];
    firstName: Scalars['String']['input'];
    lastName: Scalars['String']['input'];
    phoneNumber?: InputMaybe<Scalars['String']['input']>;
    title?: InputMaybe<Scalars['String']['input']>;
};

export type CreateCustomerResult = Customer | EmailAddressConflictError;

export type CreateFacetInput = {
    code: Scalars['String']['input'];
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    isPrivate: Scalars['Boolean']['input'];
    translations: Array<FacetTranslationInput>;
    values?: InputMaybe<Array<CreateFacetValueWithFacetInput>>;
};

export type CreateFacetValueInput = {
    code: Scalars['String']['input'];
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    facetId: Scalars['ID']['input'];
    translations: Array<FacetValueTranslationInput>;
};

export type CreateFacetValueWithFacetInput = {
    code: Scalars['String']['input'];
    translations: Array<FacetValueTranslationInput>;
};

/** Returned if an error is thrown in a FulfillmentHandler's createFulfillment method */
export type CreateFulfillmentError = ErrorResult & {
    errorCode: ErrorCode;
    fulfillmentHandlerError: Scalars['String']['output'];
    message: Scalars['String']['output'];
};

export type CreateGroupOptionInput = {
    code: Scalars['String']['input'];
    translations: Array<ProductOptionGroupTranslationInput>;
};

export type CreatePaymentMethodInput = {
    checker?: InputMaybe<ConfigurableOperationInput>;
    code: Scalars['String']['input'];
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    enabled: Scalars['Boolean']['input'];
    handler: ConfigurableOperationInput;
    translations: Array<PaymentMethodTranslationInput>;
};

export type CreateProductInput = {
    assetIds?: InputMaybe<Array<Scalars['ID']['input']>>;
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    enabled?: InputMaybe<Scalars['Boolean']['input']>;
    facetValueIds?: InputMaybe<Array<Scalars['ID']['input']>>;
    featuredAssetId?: InputMaybe<Scalars['ID']['input']>;
    translations: Array<ProductTranslationInput>;
};

export type CreateProductOptionGroupInput = {
    code: Scalars['String']['input'];
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    options: Array<CreateGroupOptionInput>;
    translations: Array<ProductOptionGroupTranslationInput>;
};

export type CreateProductOptionInput = {
    code: Scalars['String']['input'];
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    productOptionGroupId: Scalars['ID']['input'];
    translations: Array<ProductOptionGroupTranslationInput>;
};

export type CreateProductVariantInput = {
    assetIds?: InputMaybe<Array<Scalars['ID']['input']>>;
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    facetValueIds?: InputMaybe<Array<Scalars['ID']['input']>>;
    featuredAssetId?: InputMaybe<Scalars['ID']['input']>;
    optionIds?: InputMaybe<Array<Scalars['ID']['input']>>;
    outOfStockThreshold?: InputMaybe<Scalars['Int']['input']>;
    price?: InputMaybe<Scalars['Money']['input']>;
    productId: Scalars['ID']['input'];
    sku: Scalars['String']['input'];
    stockLevels?: InputMaybe<Array<StockLevelInput>>;
    stockOnHand?: InputMaybe<Scalars['Int']['input']>;
    taxCategoryId?: InputMaybe<Scalars['ID']['input']>;
    trackInventory?: InputMaybe<GlobalFlag>;
    translations: Array<ProductVariantTranslationInput>;
    useGlobalOutOfStockThreshold?: InputMaybe<Scalars['Boolean']['input']>;
};

export type CreateProductVariantOptionInput = {
    code: Scalars['String']['input'];
    optionGroupId: Scalars['ID']['input'];
    translations: Array<ProductOptionTranslationInput>;
};

export type CreatePromotionInput = {
    actions: Array<ConfigurableOperationInput>;
    conditions: Array<ConfigurableOperationInput>;
    couponCode?: InputMaybe<Scalars['String']['input']>;
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    enabled: Scalars['Boolean']['input'];
    endsAt?: InputMaybe<Scalars['DateTime']['input']>;
    perCustomerUsageLimit?: InputMaybe<Scalars['Int']['input']>;
    startsAt?: InputMaybe<Scalars['DateTime']['input']>;
    translations: Array<PromotionTranslationInput>;
    usageLimit?: InputMaybe<Scalars['Int']['input']>;
};

export type CreatePromotionResult = MissingConditionsError | Promotion;

export type CreateProvinceInput = {
    code: Scalars['String']['input'];
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    enabled: Scalars['Boolean']['input'];
    translations: Array<ProvinceTranslationInput>;
};

export type CreateRoleInput = {
    channelIds?: InputMaybe<Array<Scalars['ID']['input']>>;
    code: Scalars['String']['input'];
    description: Scalars['String']['input'];
    permissions: Array<Permission>;
};

export type CreateSellerInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    name: Scalars['String']['input'];
};

export type CreateShippingMethodInput = {
    calculator: ConfigurableOperationInput;
    checker: ConfigurableOperationInput;
    code: Scalars['String']['input'];
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    fulfillmentHandler: Scalars['String']['input'];
    translations: Array<ShippingMethodTranslationInput>;
};

export type CreateStockLocationInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    description?: InputMaybe<Scalars['String']['input']>;
    name: Scalars['String']['input'];
};

export type CreateTagInput = {
    value: Scalars['String']['input'];
};

export type CreateTaxCategoryInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    isDefault?: InputMaybe<Scalars['Boolean']['input']>;
    name: Scalars['String']['input'];
};

export type CreateTaxRateInput = {
    categoryId: Scalars['ID']['input'];
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    customerGroupId?: InputMaybe<Scalars['ID']['input']>;
    enabled: Scalars['Boolean']['input'];
    name: Scalars['String']['input'];
    value: Scalars['Float']['input'];
    zoneId: Scalars['ID']['input'];
};

export type CreateZoneInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    memberIds?: InputMaybe<Array<Scalars['ID']['input']>>;
    name: Scalars['String']['input'];
};

/**
 * @description
 * ISO 4217 currency code
 *
 * @docsCategory common
 */
export enum CurrencyCode {
    /** United Arab Emirates dirham */
    AED = 'AED',
    /** Afghan afghani */
    AFN = 'AFN',
    /** Albanian lek */
    ALL = 'ALL',
    /** Armenian dram */
    AMD = 'AMD',
    /** Netherlands Antillean guilder */
    ANG = 'ANG',
    /** Angolan kwanza */
    AOA = 'AOA',
    /** Argentine peso */
    ARS = 'ARS',
    /** Australian dollar */
    AUD = 'AUD',
    /** Aruban florin */
    AWG = 'AWG',
    /** Azerbaijani manat */
    AZN = 'AZN',
    /** Bosnia and Herzegovina convertible mark */
    BAM = 'BAM',
    /** Barbados dollar */
    BBD = 'BBD',
    /** Bangladeshi taka */
    BDT = 'BDT',
    /** Bulgarian lev */
    BGN = 'BGN',
    /** Bahraini dinar */
    BHD = 'BHD',
    /** Burundian franc */
    BIF = 'BIF',
    /** Bermudian dollar */
    BMD = 'BMD',
    /** Brunei dollar */
    BND = 'BND',
    /** Boliviano */
    BOB = 'BOB',
    /** Brazilian real */
    BRL = 'BRL',
    /** Bahamian dollar */
    BSD = 'BSD',
    /** Bhutanese ngultrum */
    BTN = 'BTN',
    /** Botswana pula */
    BWP = 'BWP',
    /** Belarusian ruble */
    BYN = 'BYN',
    /** Belize dollar */
    BZD = 'BZD',
    /** Canadian dollar */
    CAD = 'CAD',
    /** Congolese franc */
    CDF = 'CDF',
    /** Swiss franc */
    CHF = 'CHF',
    /** Chilean peso */
    CLP = 'CLP',
    /** Renminbi (Chinese) yuan */
    CNY = 'CNY',
    /** Colombian peso */
    COP = 'COP',
    /** Costa Rican colon */
    CRC = 'CRC',
    /** Cuban convertible peso */
    CUC = 'CUC',
    /** Cuban peso */
    CUP = 'CUP',
    /** Cape Verde escudo */
    CVE = 'CVE',
    /** Czech koruna */
    CZK = 'CZK',
    /** Djiboutian franc */
    DJF = 'DJF',
    /** Danish krone */
    DKK = 'DKK',
    /** Dominican peso */
    DOP = 'DOP',
    /** Algerian dinar */
    DZD = 'DZD',
    /** Egyptian pound */
    EGP = 'EGP',
    /** Eritrean nakfa */
    ERN = 'ERN',
    /** Ethiopian birr */
    ETB = 'ETB',
    /** Euro */
    EUR = 'EUR',
    /** Fiji dollar */
    FJD = 'FJD',
    /** Falkland Islands pound */
    FKP = 'FKP',
    /** Pound sterling */
    GBP = 'GBP',
    /** Georgian lari */
    GEL = 'GEL',
    /** Ghanaian cedi */
    GHS = 'GHS',
    /** Gibraltar pound */
    GIP = 'GIP',
    /** Gambian dalasi */
    GMD = 'GMD',
    /** Guinean franc */
    GNF = 'GNF',
    /** Guatemalan quetzal */
    GTQ = 'GTQ',
    /** Guyanese dollar */
    GYD = 'GYD',
    /** Hong Kong dollar */
    HKD = 'HKD',
    /** Honduran lempira */
    HNL = 'HNL',
    /** Croatian kuna */
    HRK = 'HRK',
    /** Haitian gourde */
    HTG = 'HTG',
    /** Hungarian forint */
    HUF = 'HUF',
    /** Indonesian rupiah */
    IDR = 'IDR',
    /** Israeli new shekel */
    ILS = 'ILS',
    /** Indian rupee */
    INR = 'INR',
    /** Iraqi dinar */
    IQD = 'IQD',
    /** Iranian rial */
    IRR = 'IRR',
    /** Icelandic króna */
    ISK = 'ISK',
    /** Jamaican dollar */
    JMD = 'JMD',
    /** Jordanian dinar */
    JOD = 'JOD',
    /** Japanese yen */
    JPY = 'JPY',
    /** Kenyan shilling */
    KES = 'KES',
    /** Kyrgyzstani som */
    KGS = 'KGS',
    /** Cambodian riel */
    KHR = 'KHR',
    /** Comoro franc */
    KMF = 'KMF',
    /** North Korean won */
    KPW = 'KPW',
    /** South Korean won */
    KRW = 'KRW',
    /** Kuwaiti dinar */
    KWD = 'KWD',
    /** Cayman Islands dollar */
    KYD = 'KYD',
    /** Kazakhstani tenge */
    KZT = 'KZT',
    /** Lao kip */
    LAK = 'LAK',
    /** Lebanese pound */
    LBP = 'LBP',
    /** Sri Lankan rupee */
    LKR = 'LKR',
    /** Liberian dollar */
    LRD = 'LRD',
    /** Lesotho loti */
    LSL = 'LSL',
    /** Libyan dinar */
    LYD = 'LYD',
    /** Moroccan dirham */
    MAD = 'MAD',
    /** Moldovan leu */
    MDL = 'MDL',
    /** Malagasy ariary */
    MGA = 'MGA',
    /** Macedonian denar */
    MKD = 'MKD',
    /** Myanmar kyat */
    MMK = 'MMK',
    /** Mongolian tögrög */
    MNT = 'MNT',
    /** Macanese pataca */
    MOP = 'MOP',
    /** Mauritanian ouguiya */
    MRU = 'MRU',
    /** Mauritian rupee */
    MUR = 'MUR',
    /** Maldivian rufiyaa */
    MVR = 'MVR',
    /** Malawian kwacha */
    MWK = 'MWK',
    /** Mexican peso */
    MXN = 'MXN',
    /** Malaysian ringgit */
    MYR = 'MYR',
    /** Mozambican metical */
    MZN = 'MZN',
    /** Namibian dollar */
    NAD = 'NAD',
    /** Nigerian naira */
    NGN = 'NGN',
    /** Nicaraguan córdoba */
    NIO = 'NIO',
    /** Norwegian krone */
    NOK = 'NOK',
    /** Nepalese rupee */
    NPR = 'NPR',
    /** New Zealand dollar */
    NZD = 'NZD',
    /** Omani rial */
    OMR = 'OMR',
    /** Panamanian balboa */
    PAB = 'PAB',
    /** Peruvian sol */
    PEN = 'PEN',
    /** Papua New Guinean kina */
    PGK = 'PGK',
    /** Philippine peso */
    PHP = 'PHP',
    /** Pakistani rupee */
    PKR = 'PKR',
    /** Polish złoty */
    PLN = 'PLN',
    /** Paraguayan guaraní */
    PYG = 'PYG',
    /** Qatari riyal */
    QAR = 'QAR',
    /** Romanian leu */
    RON = 'RON',
    /** Serbian dinar */
    RSD = 'RSD',
    /** Russian ruble */
    RUB = 'RUB',
    /** Rwandan franc */
    RWF = 'RWF',
    /** Saudi riyal */
    SAR = 'SAR',
    /** Solomon Islands dollar */
    SBD = 'SBD',
    /** Seychelles rupee */
    SCR = 'SCR',
    /** Sudanese pound */
    SDG = 'SDG',
    /** Swedish krona/kronor */
    SEK = 'SEK',
    /** Singapore dollar */
    SGD = 'SGD',
    /** Saint Helena pound */
    SHP = 'SHP',
    /** Sierra Leonean leone */
    SLL = 'SLL',
    /** Somali shilling */
    SOS = 'SOS',
    /** Surinamese dollar */
    SRD = 'SRD',
    /** South Sudanese pound */
    SSP = 'SSP',
    /** São Tomé and Príncipe dobra */
    STN = 'STN',
    /** Salvadoran colón */
    SVC = 'SVC',
    /** Syrian pound */
    SYP = 'SYP',
    /** Swazi lilangeni */
    SZL = 'SZL',
    /** Thai baht */
    THB = 'THB',
    /** Tajikistani somoni */
    TJS = 'TJS',
    /** Turkmenistan manat */
    TMT = 'TMT',
    /** Tunisian dinar */
    TND = 'TND',
    /** Tongan paʻanga */
    TOP = 'TOP',
    /** Turkish lira */
    TRY = 'TRY',
    /** Trinidad and Tobago dollar */
    TTD = 'TTD',
    /** New Taiwan dollar */
    TWD = 'TWD',
    /** Tanzanian shilling */
    TZS = 'TZS',
    /** Ukrainian hryvnia */
    UAH = 'UAH',
    /** Ugandan shilling */
    UGX = 'UGX',
    /** United States dollar */
    USD = 'USD',
    /** Uruguayan peso */
    UYU = 'UYU',
    /** Uzbekistan som */
    UZS = 'UZS',
    /** Venezuelan bolívar soberano */
    VES = 'VES',
    /** Vietnamese đồng */
    VND = 'VND',
    /** Vanuatu vatu */
    VUV = 'VUV',
    /** Samoan tala */
    WST = 'WST',
    /** CFA franc BEAC */
    XAF = 'XAF',
    /** East Caribbean dollar */
    XCD = 'XCD',
    /** CFA franc BCEAO */
    XOF = 'XOF',
    /** CFP franc (franc Pacifique) */
    XPF = 'XPF',
    /** Yemeni rial */
    YER = 'YER',
    /** South African rand */
    ZAR = 'ZAR',
    /** Zambian kwacha */
    ZMW = 'ZMW',
    /** Zimbabwean dollar */
    ZWL = 'ZWL',
}

export type CurrentUser = {
    channels: Array<CurrentUserChannel>;
    id: Scalars['ID']['output'];
    identifier: Scalars['String']['output'];
};

export type CurrentUserChannel = {
    code: Scalars['String']['output'];
    id: Scalars['ID']['output'];
    permissions: Array<Permission>;
    token: Scalars['String']['output'];
};

export type CustomField = {
    description?: Maybe<Array<LocalizedString>>;
    internal?: Maybe<Scalars['Boolean']['output']>;
    label?: Maybe<Array<LocalizedString>>;
    list: Scalars['Boolean']['output'];
    name: Scalars['String']['output'];
    nullable?: Maybe<Scalars['Boolean']['output']>;
    readonly?: Maybe<Scalars['Boolean']['output']>;
    requiresPermission?: Maybe<Array<Permission>>;
    type: Scalars['String']['output'];
    ui?: Maybe<Scalars['JSON']['output']>;
};

export type CustomFieldConfig =
    | BooleanCustomFieldConfig
    | DateTimeCustomFieldConfig
    | FloatCustomFieldConfig
    | IntCustomFieldConfig
    | LocaleStringCustomFieldConfig
    | LocaleTextCustomFieldConfig
    | RelationCustomFieldConfig
    | StringCustomFieldConfig
    | TextCustomFieldConfig;

/**
 * This type is deprecated in v2.2 in favor of the EntityCustomFields type,
 * which allows custom fields to be defined on user-supplies entities.
 */
export type CustomFields = {
    Address: Array<CustomFieldConfig>;
    Administrator: Array<CustomFieldConfig>;
    Asset: Array<CustomFieldConfig>;
    Channel: Array<CustomFieldConfig>;
    Collection: Array<CustomFieldConfig>;
    Customer: Array<CustomFieldConfig>;
    CustomerGroup: Array<CustomFieldConfig>;
    Facet: Array<CustomFieldConfig>;
    FacetValue: Array<CustomFieldConfig>;
    Fulfillment: Array<CustomFieldConfig>;
    GlobalSettings: Array<CustomFieldConfig>;
    Order: Array<CustomFieldConfig>;
    OrderLine: Array<CustomFieldConfig>;
    PaymentMethod: Array<CustomFieldConfig>;
    Product: Array<CustomFieldConfig>;
    ProductOption: Array<CustomFieldConfig>;
    ProductOptionGroup: Array<CustomFieldConfig>;
    ProductVariant: Array<CustomFieldConfig>;
    ProductVariantPrice: Array<CustomFieldConfig>;
    Promotion: Array<CustomFieldConfig>;
    Region: Array<CustomFieldConfig>;
    Seller: Array<CustomFieldConfig>;
    ShippingMethod: Array<CustomFieldConfig>;
    StockLocation: Array<CustomFieldConfig>;
    TaxCategory: Array<CustomFieldConfig>;
    TaxRate: Array<CustomFieldConfig>;
    User: Array<CustomFieldConfig>;
    Zone: Array<CustomFieldConfig>;
};

export type Customer = Node & {
    addresses?: Maybe<Array<Address>>;
    createdAt: Scalars['DateTime']['output'];
    customFields?: Maybe<Scalars['JSON']['output']>;
    emailAddress: Scalars['String']['output'];
    firstName: Scalars['String']['output'];
    groups: Array<CustomerGroup>;
    history: HistoryEntryList;
    id: Scalars['ID']['output'];
    lastName: Scalars['String']['output'];
    orders: OrderList;
    phoneNumber?: Maybe<Scalars['String']['output']>;
    title?: Maybe<Scalars['String']['output']>;
    updatedAt: Scalars['DateTime']['output'];
    user?: Maybe<User>;
};

export type CustomerHistoryArgs = {
    options?: InputMaybe<HistoryEntryListOptions>;
};

export type CustomerOrdersArgs = {
    options?: InputMaybe<OrderListOptions>;
};

export type CustomerFilterParameter = {
    _and?: InputMaybe<Array<CustomerFilterParameter>>;
    _or?: InputMaybe<Array<CustomerFilterParameter>>;
    createdAt?: InputMaybe<DateOperators>;
    emailAddress?: InputMaybe<StringOperators>;
    firstName?: InputMaybe<StringOperators>;
    id?: InputMaybe<IdOperators>;
    lastName?: InputMaybe<StringOperators>;
    phoneNumber?: InputMaybe<StringOperators>;
    postalCode?: InputMaybe<StringOperators>;
    title?: InputMaybe<StringOperators>;
    updatedAt?: InputMaybe<DateOperators>;
};

export type CustomerGroup = Node & {
    createdAt: Scalars['DateTime']['output'];
    customFields?: Maybe<Scalars['JSON']['output']>;
    customers: CustomerList;
    id: Scalars['ID']['output'];
    name: Scalars['String']['output'];
    updatedAt: Scalars['DateTime']['output'];
};

export type CustomerGroupCustomersArgs = {
    options?: InputMaybe<CustomerListOptions>;
};

export type CustomerGroupFilterParameter = {
    _and?: InputMaybe<Array<CustomerGroupFilterParameter>>;
    _or?: InputMaybe<Array<CustomerGroupFilterParameter>>;
    createdAt?: InputMaybe<DateOperators>;
    id?: InputMaybe<IdOperators>;
    name?: InputMaybe<StringOperators>;
    updatedAt?: InputMaybe<DateOperators>;
};

export type CustomerGroupList = PaginatedList & {
    items: Array<CustomerGroup>;
    totalItems: Scalars['Int']['output'];
};

export type CustomerGroupListOptions = {
    /** Allows the results to be filtered */
    filter?: InputMaybe<CustomerGroupFilterParameter>;
    /** Specifies whether multiple top-level "filter" fields should be combined with a logical AND or OR operation. Defaults to AND. */
    filterOperator?: InputMaybe<LogicalOperator>;
    /** Skips the first n results, for use in pagination */
    skip?: InputMaybe<Scalars['Int']['input']>;
    /** Specifies which properties to sort the results by */
    sort?: InputMaybe<CustomerGroupSortParameter>;
    /** Takes n results, for use in pagination */
    take?: InputMaybe<Scalars['Int']['input']>;
};

export type CustomerGroupSortParameter = {
    createdAt?: InputMaybe<SortOrder>;
    id?: InputMaybe<SortOrder>;
    name?: InputMaybe<SortOrder>;
    updatedAt?: InputMaybe<SortOrder>;
};

export type CustomerList = PaginatedList & {
    items: Array<Customer>;
    totalItems: Scalars['Int']['output'];
};

export type CustomerListOptions = {
    /** Allows the results to be filtered */
    filter?: InputMaybe<CustomerFilterParameter>;
    /** Specifies whether multiple top-level "filter" fields should be combined with a logical AND or OR operation. Defaults to AND. */
    filterOperator?: InputMaybe<LogicalOperator>;
    /** Skips the first n results, for use in pagination */
    skip?: InputMaybe<Scalars['Int']['input']>;
    /** Specifies which properties to sort the results by */
    sort?: InputMaybe<CustomerSortParameter>;
    /** Takes n results, for use in pagination */
    take?: InputMaybe<Scalars['Int']['input']>;
};

export type CustomerSortParameter = {
    createdAt?: InputMaybe<SortOrder>;
    emailAddress?: InputMaybe<SortOrder>;
    firstName?: InputMaybe<SortOrder>;
    id?: InputMaybe<SortOrder>;
    lastName?: InputMaybe<SortOrder>;
    phoneNumber?: InputMaybe<SortOrder>;
    title?: InputMaybe<SortOrder>;
    updatedAt?: InputMaybe<SortOrder>;
};

/** Operators for filtering on a list of Date fields */
export type DateListOperators = {
    inList: Scalars['DateTime']['input'];
};

/** Operators for filtering on a DateTime field */
export type DateOperators = {
    after?: InputMaybe<Scalars['DateTime']['input']>;
    before?: InputMaybe<Scalars['DateTime']['input']>;
    between?: InputMaybe<DateRange>;
    eq?: InputMaybe<Scalars['DateTime']['input']>;
    isNull?: InputMaybe<Scalars['Boolean']['input']>;
};

export type DateRange = {
    end: Scalars['DateTime']['input'];
    start: Scalars['DateTime']['input'];
};

/**
 * Expects the same validation formats as the `<input type="datetime-local">` HTML element.
 * See https://developer.mozilla.org/en-US/docs/Web/HTML/Element/input/datetime-local#Additional_attributes
 */
export type DateTimeCustomFieldConfig = CustomField & {
    description?: Maybe<Array<LocalizedString>>;
    internal?: Maybe<Scalars['Boolean']['output']>;
    label?: Maybe<Array<LocalizedString>>;
    list: Scalars['Boolean']['output'];
    max?: Maybe<Scalars['String']['output']>;
    min?: Maybe<Scalars['String']['output']>;
    name: Scalars['String']['output'];
    nullable?: Maybe<Scalars['Boolean']['output']>;
    readonly?: Maybe<Scalars['Boolean']['output']>;
    requiresPermission?: Maybe<Array<Permission>>;
    step?: Maybe<Scalars['Int']['output']>;
    type: Scalars['String']['output'];
    ui?: Maybe<Scalars['JSON']['output']>;
};

export type DeleteAssetInput = {
    assetId: Scalars['ID']['input'];
    deleteFromAllChannels?: InputMaybe<Scalars['Boolean']['input']>;
    force?: InputMaybe<Scalars['Boolean']['input']>;
};

export type DeleteAssetsInput = {
    assetIds: Array<Scalars['ID']['input']>;
    deleteFromAllChannels?: InputMaybe<Scalars['Boolean']['input']>;
    force?: InputMaybe<Scalars['Boolean']['input']>;
};

export type DeleteStockLocationInput = {
    id: Scalars['ID']['input'];
    transferToLocationId?: InputMaybe<Scalars['ID']['input']>;
};

export type DeletionResponse = {
    message?: Maybe<Scalars['String']['output']>;
    result: DeletionResult;
};

export enum DeletionResult {
    /** The entity was successfully deleted */
    DELETED = 'DELETED',
    /** Deletion did not take place, reason given in message */
    NOT_DELETED = 'NOT_DELETED',
}

export type Discount = {
    adjustmentSource: Scalars['String']['output'];
    amount: Scalars['Money']['output'];
    amountWithTax: Scalars['Money']['output'];
    description: Scalars['String']['output'];
    type: AdjustmentType;
};

export type DuplicateEntityError = ErrorResult & {
    duplicationError: Scalars['String']['output'];
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
};

export type DuplicateEntityInput = {
    duplicatorInput: ConfigurableOperationInput;
    entityId: Scalars['ID']['input'];
    entityName: Scalars['String']['input'];
};

export type DuplicateEntityResult = DuplicateEntityError | DuplicateEntitySuccess;

export type DuplicateEntitySuccess = {
    newEntityId: Scalars['ID']['output'];
};

/** Returned when attempting to create a Customer with an email address already registered to an existing User. */
export type EmailAddressConflictError = ErrorResult & {
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
};

/** Returned if no OrderLines have been specified for the operation */
export type EmptyOrderLineSelectionError = ErrorResult & {
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
};

export type EntityCustomFields = {
    customFields: Array<CustomFieldConfig>;
    entityName: Scalars['String']['output'];
};

export type EntityDuplicatorDefinition = {
    args: Array<ConfigArgDefinition>;
    code: Scalars['String']['output'];
    description: Scalars['String']['output'];
    forEntities: Array<Scalars['String']['output']>;
    requiresPermission: Array<Permission>;
};

export enum ErrorCode {
    ALREADY_REFUNDED_ERROR = 'ALREADY_REFUNDED_ERROR',
    CANCEL_ACTIVE_ORDER_ERROR = 'CANCEL_ACTIVE_ORDER_ERROR',
    CANCEL_PAYMENT_ERROR = 'CANCEL_PAYMENT_ERROR',
    CHANNEL_DEFAULT_LANGUAGE_ERROR = 'CHANNEL_DEFAULT_LANGUAGE_ERROR',
    COUPON_CODE_EXPIRED_ERROR = 'COUPON_CODE_EXPIRED_ERROR',
    COUPON_CODE_INVALID_ERROR = 'COUPON_CODE_INVALID_ERROR',
    COUPON_CODE_LIMIT_ERROR = 'COUPON_CODE_LIMIT_ERROR',
    CREATE_FULFILLMENT_ERROR = 'CREATE_FULFILLMENT_ERROR',
    DUPLICATE_ENTITY_ERROR = 'DUPLICATE_ENTITY_ERROR',
    EMAIL_ADDRESS_CONFLICT_ERROR = 'EMAIL_ADDRESS_CONFLICT_ERROR',
    EMPTY_ORDER_LINE_SELECTION_ERROR = 'EMPTY_ORDER_LINE_SELECTION_ERROR',
    FACET_IN_USE_ERROR = 'FACET_IN_USE_ERROR',
    FULFILLMENT_STATE_TRANSITION_ERROR = 'FULFILLMENT_STATE_TRANSITION_ERROR',
    GUEST_CHECKOUT_ERROR = 'GUEST_CHECKOUT_ERROR',
    INELIGIBLE_SHIPPING_METHOD_ERROR = 'INELIGIBLE_SHIPPING_METHOD_ERROR',
    INSUFFICIENT_STOCK_ERROR = 'INSUFFICIENT_STOCK_ERROR',
    INSUFFICIENT_STOCK_ON_HAND_ERROR = 'INSUFFICIENT_STOCK_ON_HAND_ERROR',
    INVALID_CREDENTIALS_ERROR = 'INVALID_CREDENTIALS_ERROR',
    INVALID_FULFILLMENT_HANDLER_ERROR = 'INVALID_FULFILLMENT_HANDLER_ERROR',
    ITEMS_ALREADY_FULFILLED_ERROR = 'ITEMS_ALREADY_FULFILLED_ERROR',
    LANGUAGE_NOT_AVAILABLE_ERROR = 'LANGUAGE_NOT_AVAILABLE_ERROR',
    MANUAL_PAYMENT_STATE_ERROR = 'MANUAL_PAYMENT_STATE_ERROR',
    MIME_TYPE_ERROR = 'MIME_TYPE_ERROR',
    MISSING_CONDITIONS_ERROR = 'MISSING_CONDITIONS_ERROR',
    MULTIPLE_ORDER_ERROR = 'MULTIPLE_ORDER_ERROR',
    NATIVE_AUTH_STRATEGY_ERROR = 'NATIVE_AUTH_STRATEGY_ERROR',
    NEGATIVE_QUANTITY_ERROR = 'NEGATIVE_QUANTITY_ERROR',
    NOTHING_TO_REFUND_ERROR = 'NOTHING_TO_REFUND_ERROR',
    NO_ACTIVE_ORDER_ERROR = 'NO_ACTIVE_ORDER_ERROR',
    NO_CHANGES_SPECIFIED_ERROR = 'NO_CHANGES_SPECIFIED_ERROR',
    ORDER_LIMIT_ERROR = 'ORDER_LIMIT_ERROR',
    ORDER_MODIFICATION_ERROR = 'ORDER_MODIFICATION_ERROR',
    ORDER_MODIFICATION_STATE_ERROR = 'ORDER_MODIFICATION_STATE_ERROR',
    ORDER_STATE_TRANSITION_ERROR = 'ORDER_STATE_TRANSITION_ERROR',
    PAYMENT_METHOD_MISSING_ERROR = 'PAYMENT_METHOD_MISSING_ERROR',
    PAYMENT_ORDER_MISMATCH_ERROR = 'PAYMENT_ORDER_MISMATCH_ERROR',
    PAYMENT_STATE_TRANSITION_ERROR = 'PAYMENT_STATE_TRANSITION_ERROR',
    PRODUCT_OPTION_IN_USE_ERROR = 'PRODUCT_OPTION_IN_USE_ERROR',
    QUANTITY_TOO_GREAT_ERROR = 'QUANTITY_TOO_GREAT_ERROR',
    REFUND_AMOUNT_ERROR = 'REFUND_AMOUNT_ERROR',
    REFUND_ORDER_STATE_ERROR = 'REFUND_ORDER_STATE_ERROR',
    REFUND_PAYMENT_ID_MISSING_ERROR = 'REFUND_PAYMENT_ID_MISSING_ERROR',
    REFUND_STATE_TRANSITION_ERROR = 'REFUND_STATE_TRANSITION_ERROR',
    SETTLE_PAYMENT_ERROR = 'SETTLE_PAYMENT_ERROR',
    UNKNOWN_ERROR = 'UNKNOWN_ERROR',
}

export type ErrorResult = {
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
};

export type Facet = Node & {
    code: Scalars['String']['output'];
    createdAt: Scalars['DateTime']['output'];
    customFields?: Maybe<Scalars['JSON']['output']>;
    id: Scalars['ID']['output'];
    isPrivate: Scalars['Boolean']['output'];
    languageCode: LanguageCode;
    name: Scalars['String']['output'];
    translations: Array<FacetTranslation>;
    updatedAt: Scalars['DateTime']['output'];
    /** Returns a paginated, sortable, filterable list of the Facet's values. Added in v2.1.0. */
    valueList: FacetValueList;
    values: Array<FacetValue>;
};

export type FacetValueListArgs = {
    options?: InputMaybe<FacetValueListOptions>;
};

export type FacetFilterParameter = {
    _and?: InputMaybe<Array<FacetFilterParameter>>;
    _or?: InputMaybe<Array<FacetFilterParameter>>;
    code?: InputMaybe<StringOperators>;
    createdAt?: InputMaybe<DateOperators>;
    id?: InputMaybe<IdOperators>;
    isPrivate?: InputMaybe<BooleanOperators>;
    languageCode?: InputMaybe<StringOperators>;
    name?: InputMaybe<StringOperators>;
    updatedAt?: InputMaybe<DateOperators>;
};

export type FacetInUseError = ErrorResult & {
    errorCode: ErrorCode;
    facetCode: Scalars['String']['output'];
    message: Scalars['String']['output'];
    productCount: Scalars['Int']['output'];
    variantCount: Scalars['Int']['output'];
};

export type FacetList = PaginatedList & {
    items: Array<Facet>;
    totalItems: Scalars['Int']['output'];
};

export type FacetListOptions = {
    /** Allows the results to be filtered */
    filter?: InputMaybe<FacetFilterParameter>;
    /** Specifies whether multiple top-level "filter" fields should be combined with a logical AND or OR operation. Defaults to AND. */
    filterOperator?: InputMaybe<LogicalOperator>;
    /** Skips the first n results, for use in pagination */
    skip?: InputMaybe<Scalars['Int']['input']>;
    /** Specifies which properties to sort the results by */
    sort?: InputMaybe<FacetSortParameter>;
    /** Takes n results, for use in pagination */
    take?: InputMaybe<Scalars['Int']['input']>;
};

export type FacetSortParameter = {
    code?: InputMaybe<SortOrder>;
    createdAt?: InputMaybe<SortOrder>;
    id?: InputMaybe<SortOrder>;
    name?: InputMaybe<SortOrder>;
    updatedAt?: InputMaybe<SortOrder>;
};

export type FacetTranslation = {
    createdAt: Scalars['DateTime']['output'];
    id: Scalars['ID']['output'];
    languageCode: LanguageCode;
    name: Scalars['String']['output'];
    updatedAt: Scalars['DateTime']['output'];
};

export type FacetTranslationInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    id?: InputMaybe<Scalars['ID']['input']>;
    languageCode: LanguageCode;
    name?: InputMaybe<Scalars['String']['input']>;
};

export type FacetValue = Node & {
    code: Scalars['String']['output'];
    createdAt: Scalars['DateTime']['output'];
    customFields?: Maybe<Scalars['JSON']['output']>;
    facet: Facet;
    facetId: Scalars['ID']['output'];
    id: Scalars['ID']['output'];
    languageCode: LanguageCode;
    name: Scalars['String']['output'];
    translations: Array<FacetValueTranslation>;
    updatedAt: Scalars['DateTime']['output'];
};

/**
 * Used to construct boolean expressions for filtering search results
 * by FacetValue ID. Examples:
 *
 * * ID=1 OR ID=2: `{ facetValueFilters: [{ or: [1,2] }] }`
 * * ID=1 AND ID=2: `{ facetValueFilters: [{ and: 1 }, { and: 2 }] }`
 * * ID=1 AND (ID=2 OR ID=3): `{ facetValueFilters: [{ and: 1 }, { or: [2,3] }] }`
 */
export type FacetValueFilterInput = {
    and?: InputMaybe<Scalars['ID']['input']>;
    or?: InputMaybe<Array<Scalars['ID']['input']>>;
};

export type FacetValueFilterParameter = {
    _and?: InputMaybe<Array<FacetValueFilterParameter>>;
    _or?: InputMaybe<Array<FacetValueFilterParameter>>;
    code?: InputMaybe<StringOperators>;
    createdAt?: InputMaybe<DateOperators>;
    facetId?: InputMaybe<IdOperators>;
    id?: InputMaybe<IdOperators>;
    languageCode?: InputMaybe<StringOperators>;
    name?: InputMaybe<StringOperators>;
    updatedAt?: InputMaybe<DateOperators>;
};

export type FacetValueList = PaginatedList & {
    items: Array<FacetValue>;
    totalItems: Scalars['Int']['output'];
};

export type FacetValueListOptions = {
    /** Allows the results to be filtered */
    filter?: InputMaybe<FacetValueFilterParameter>;
    /** Specifies whether multiple top-level "filter" fields should be combined with a logical AND or OR operation. Defaults to AND. */
    filterOperator?: InputMaybe<LogicalOperator>;
    /** Skips the first n results, for use in pagination */
    skip?: InputMaybe<Scalars['Int']['input']>;
    /** Specifies which properties to sort the results by */
    sort?: InputMaybe<FacetValueSortParameter>;
    /** Takes n results, for use in pagination */
    take?: InputMaybe<Scalars['Int']['input']>;
};

/**
 * Which FacetValues are present in the products returned
 * by the search, and in what quantity.
 */
export type FacetValueResult = {
    count: Scalars['Int']['output'];
    facetValue: FacetValue;
};

export type FacetValueSortParameter = {
    code?: InputMaybe<SortOrder>;
    createdAt?: InputMaybe<SortOrder>;
    facetId?: InputMaybe<SortOrder>;
    id?: InputMaybe<SortOrder>;
    name?: InputMaybe<SortOrder>;
    updatedAt?: InputMaybe<SortOrder>;
};

export type FacetValueTranslation = {
    createdAt: Scalars['DateTime']['output'];
    id: Scalars['ID']['output'];
    languageCode: LanguageCode;
    name: Scalars['String']['output'];
    updatedAt: Scalars['DateTime']['output'];
};

export type FacetValueTranslationInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    id?: InputMaybe<Scalars['ID']['input']>;
    languageCode: LanguageCode;
    name?: InputMaybe<Scalars['String']['input']>;
};

export type FloatCustomFieldConfig = CustomField & {
    description?: Maybe<Array<LocalizedString>>;
    internal?: Maybe<Scalars['Boolean']['output']>;
    label?: Maybe<Array<LocalizedString>>;
    list: Scalars['Boolean']['output'];
    max?: Maybe<Scalars['Float']['output']>;
    min?: Maybe<Scalars['Float']['output']>;
    name: Scalars['String']['output'];
    nullable?: Maybe<Scalars['Boolean']['output']>;
    readonly?: Maybe<Scalars['Boolean']['output']>;
    requiresPermission?: Maybe<Array<Permission>>;
    step?: Maybe<Scalars['Float']['output']>;
    type: Scalars['String']['output'];
    ui?: Maybe<Scalars['JSON']['output']>;
};

export type FulfillOrderInput = {
    handler: ConfigurableOperationInput;
    lines: Array<OrderLineInput>;
};

export type Fulfillment = Node & {
    createdAt: Scalars['DateTime']['output'];
    customFields?: Maybe<Scalars['JSON']['output']>;
    id: Scalars['ID']['output'];
    lines: Array<FulfillmentLine>;
    method: Scalars['String']['output'];
    nextStates: Array<Scalars['String']['output']>;
    state: Scalars['String']['output'];
    /** @deprecated Use the `lines` field instead */
    summary: Array<FulfillmentLine>;
    trackingCode?: Maybe<Scalars['String']['output']>;
    updatedAt: Scalars['DateTime']['output'];
};

export type FulfillmentLine = {
    fulfillment: Fulfillment;
    fulfillmentId: Scalars['ID']['output'];
    orderLine: OrderLine;
    orderLineId: Scalars['ID']['output'];
    quantity: Scalars['Int']['output'];
};

/** Returned when there is an error in transitioning the Fulfillment state */
export type FulfillmentStateTransitionError = ErrorResult & {
    errorCode: ErrorCode;
    fromState: Scalars['String']['output'];
    message: Scalars['String']['output'];
    toState: Scalars['String']['output'];
    transitionError: Scalars['String']['output'];
};

export enum GlobalFlag {
    FALSE = 'FALSE',
    INHERIT = 'INHERIT',
    TRUE = 'TRUE',
}

export type GlobalSettings = {
    availableLanguages: Array<LanguageCode>;
    createdAt: Scalars['DateTime']['output'];
    customFields?: Maybe<Scalars['JSON']['output']>;
    id: Scalars['ID']['output'];
    outOfStockThreshold: Scalars['Int']['output'];
    serverConfig: ServerConfig;
    trackInventory: Scalars['Boolean']['output'];
    updatedAt: Scalars['DateTime']['output'];
};

/** Returned when attempting to set the Customer on a guest checkout when the configured GuestCheckoutStrategy does not allow it. */
export type GuestCheckoutError = ErrorResult & {
    errorCode: ErrorCode;
    errorDetail: Scalars['String']['output'];
    message: Scalars['String']['output'];
};

export type HistoryEntry = Node & {
    administrator?: Maybe<Administrator>;
    createdAt: Scalars['DateTime']['output'];
    data: Scalars['JSON']['output'];
    id: Scalars['ID']['output'];
    isPublic: Scalars['Boolean']['output'];
    type: HistoryEntryType;
    updatedAt: Scalars['DateTime']['output'];
};

export type HistoryEntryFilterParameter = {
    _and?: InputMaybe<Array<HistoryEntryFilterParameter>>;
    _or?: InputMaybe<Array<HistoryEntryFilterParameter>>;
    createdAt?: InputMaybe<DateOperators>;
    id?: InputMaybe<IdOperators>;
    isPublic?: InputMaybe<BooleanOperators>;
    type?: InputMaybe<StringOperators>;
    updatedAt?: InputMaybe<DateOperators>;
};

export type HistoryEntryList = PaginatedList & {
    items: Array<HistoryEntry>;
    totalItems: Scalars['Int']['output'];
};

export type HistoryEntryListOptions = {
    /** Allows the results to be filtered */
    filter?: InputMaybe<HistoryEntryFilterParameter>;
    /** Specifies whether multiple top-level "filter" fields should be combined with a logical AND or OR operation. Defaults to AND. */
    filterOperator?: InputMaybe<LogicalOperator>;
    /** Skips the first n results, for use in pagination */
    skip?: InputMaybe<Scalars['Int']['input']>;
    /** Specifies which properties to sort the results by */
    sort?: InputMaybe<HistoryEntrySortParameter>;
    /** Takes n results, for use in pagination */
    take?: InputMaybe<Scalars['Int']['input']>;
};

export type HistoryEntrySortParameter = {
    createdAt?: InputMaybe<SortOrder>;
    id?: InputMaybe<SortOrder>;
    updatedAt?: InputMaybe<SortOrder>;
};

export enum HistoryEntryType {
    CUSTOMER_ADDED_TO_GROUP = 'CUSTOMER_ADDED_TO_GROUP',
    CUSTOMER_ADDRESS_CREATED = 'CUSTOMER_ADDRESS_CREATED',
    CUSTOMER_ADDRESS_DELETED = 'CUSTOMER_ADDRESS_DELETED',
    CUSTOMER_ADDRESS_UPDATED = 'CUSTOMER_ADDRESS_UPDATED',
    CUSTOMER_DETAIL_UPDATED = 'CUSTOMER_DETAIL_UPDATED',
    CUSTOMER_EMAIL_UPDATE_REQUESTED = 'CUSTOMER_EMAIL_UPDATE_REQUESTED',
    CUSTOMER_EMAIL_UPDATE_VERIFIED = 'CUSTOMER_EMAIL_UPDATE_VERIFIED',
    CUSTOMER_NOTE = 'CUSTOMER_NOTE',
    CUSTOMER_PASSWORD_RESET_REQUESTED = 'CUSTOMER_PASSWORD_RESET_REQUESTED',
    CUSTOMER_PASSWORD_RESET_VERIFIED = 'CUSTOMER_PASSWORD_RESET_VERIFIED',
    CUSTOMER_PASSWORD_UPDATED = 'CUSTOMER_PASSWORD_UPDATED',
    CUSTOMER_REGISTERED = 'CUSTOMER_REGISTERED',
    CUSTOMER_REMOVED_FROM_GROUP = 'CUSTOMER_REMOVED_FROM_GROUP',
    CUSTOMER_VERIFIED = 'CUSTOMER_VERIFIED',
    ORDER_CANCELLATION = 'ORDER_CANCELLATION',
    ORDER_COUPON_APPLIED = 'ORDER_COUPON_APPLIED',
    ORDER_COUPON_REMOVED = 'ORDER_COUPON_REMOVED',
    ORDER_CUSTOMER_UPDATED = 'ORDER_CUSTOMER_UPDATED',
    ORDER_FULFILLMENT = 'ORDER_FULFILLMENT',
    ORDER_FULFILLMENT_TRANSITION = 'ORDER_FULFILLMENT_TRANSITION',
    ORDER_MODIFIED = 'ORDER_MODIFIED',
    ORDER_NOTE = 'ORDER_NOTE',
    ORDER_PAYMENT_TRANSITION = 'ORDER_PAYMENT_TRANSITION',
    ORDER_REFUND_TRANSITION = 'ORDER_REFUND_TRANSITION',
    ORDER_STATE_TRANSITION = 'ORDER_STATE_TRANSITION',
}

/** Operators for filtering on a list of ID fields */
export type IdListOperators = {
    inList: Scalars['ID']['input'];
};

/** Operators for filtering on an ID field */
export type IdOperators = {
    eq?: InputMaybe<Scalars['String']['input']>;
    in?: InputMaybe<Array<Scalars['String']['input']>>;
    isNull?: InputMaybe<Scalars['Boolean']['input']>;
    notEq?: InputMaybe<Scalars['String']['input']>;
    notIn?: InputMaybe<Array<Scalars['String']['input']>>;
};

export type ImportInfo = {
    errors?: Maybe<Array<Scalars['String']['output']>>;
    imported: Scalars['Int']['output'];
    processed: Scalars['Int']['output'];
};

/** Returned when attempting to set a ShippingMethod for which the Order is not eligible */
export type IneligibleShippingMethodError = ErrorResult & {
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
};

/** Returned when attempting to add more items to the Order than are available */
export type InsufficientStockError = ErrorResult & {
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
    order: Order;
    quantityAvailable: Scalars['Int']['output'];
};

/**
 * Returned if attempting to create a Fulfillment when there is insufficient
 * stockOnHand of a ProductVariant to satisfy the requested quantity.
 */
export type InsufficientStockOnHandError = ErrorResult & {
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
    productVariantId: Scalars['ID']['output'];
    productVariantName: Scalars['String']['output'];
    stockOnHand: Scalars['Int']['output'];
};

export type IntCustomFieldConfig = CustomField & {
    description?: Maybe<Array<LocalizedString>>;
    internal?: Maybe<Scalars['Boolean']['output']>;
    label?: Maybe<Array<LocalizedString>>;
    list: Scalars['Boolean']['output'];
    max?: Maybe<Scalars['Int']['output']>;
    min?: Maybe<Scalars['Int']['output']>;
    name: Scalars['String']['output'];
    nullable?: Maybe<Scalars['Boolean']['output']>;
    readonly?: Maybe<Scalars['Boolean']['output']>;
    requiresPermission?: Maybe<Array<Permission>>;
    step?: Maybe<Scalars['Int']['output']>;
    type: Scalars['String']['output'];
    ui?: Maybe<Scalars['JSON']['output']>;
};

/** Returned if the user authentication credentials are not valid */
export type InvalidCredentialsError = ErrorResult & {
    authenticationError: Scalars['String']['output'];
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
};

/** Returned if the specified FulfillmentHandler code is not valid */
export type InvalidFulfillmentHandlerError = ErrorResult & {
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
};

/** Returned if the specified items are already part of a Fulfillment */
export type ItemsAlreadyFulfilledError = ErrorResult & {
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
};

export type Job = Node & {
    attempts: Scalars['Int']['output'];
    createdAt: Scalars['DateTime']['output'];
    data?: Maybe<Scalars['JSON']['output']>;
    duration: Scalars['Int']['output'];
    error?: Maybe<Scalars['JSON']['output']>;
    id: Scalars['ID']['output'];
    isSettled: Scalars['Boolean']['output'];
    progress: Scalars['Float']['output'];
    queueName: Scalars['String']['output'];
    result?: Maybe<Scalars['JSON']['output']>;
    retries: Scalars['Int']['output'];
    settledAt?: Maybe<Scalars['DateTime']['output']>;
    startedAt?: Maybe<Scalars['DateTime']['output']>;
    state: JobState;
};

export type JobBufferSize = {
    bufferId: Scalars['String']['output'];
    size: Scalars['Int']['output'];
};

export type JobFilterParameter = {
    _and?: InputMaybe<Array<JobFilterParameter>>;
    _or?: InputMaybe<Array<JobFilterParameter>>;
    attempts?: InputMaybe<NumberOperators>;
    createdAt?: InputMaybe<DateOperators>;
    duration?: InputMaybe<NumberOperators>;
    id?: InputMaybe<IdOperators>;
    isSettled?: InputMaybe<BooleanOperators>;
    progress?: InputMaybe<NumberOperators>;
    queueName?: InputMaybe<StringOperators>;
    retries?: InputMaybe<NumberOperators>;
    settledAt?: InputMaybe<DateOperators>;
    startedAt?: InputMaybe<DateOperators>;
    state?: InputMaybe<StringOperators>;
};

export type JobList = PaginatedList & {
    items: Array<Job>;
    totalItems: Scalars['Int']['output'];
};

export type JobListOptions = {
    /** Allows the results to be filtered */
    filter?: InputMaybe<JobFilterParameter>;
    /** Specifies whether multiple top-level "filter" fields should be combined with a logical AND or OR operation. Defaults to AND. */
    filterOperator?: InputMaybe<LogicalOperator>;
    /** Skips the first n results, for use in pagination */
    skip?: InputMaybe<Scalars['Int']['input']>;
    /** Specifies which properties to sort the results by */
    sort?: InputMaybe<JobSortParameter>;
    /** Takes n results, for use in pagination */
    take?: InputMaybe<Scalars['Int']['input']>;
};

export type JobQueue = {
    name: Scalars['String']['output'];
    running: Scalars['Boolean']['output'];
};

export type JobSortParameter = {
    attempts?: InputMaybe<SortOrder>;
    createdAt?: InputMaybe<SortOrder>;
    duration?: InputMaybe<SortOrder>;
    id?: InputMaybe<SortOrder>;
    progress?: InputMaybe<SortOrder>;
    queueName?: InputMaybe<SortOrder>;
    retries?: InputMaybe<SortOrder>;
    settledAt?: InputMaybe<SortOrder>;
    startedAt?: InputMaybe<SortOrder>;
};

/**
 * @description
 * The state of a Job in the JobQueue
 *
 * @docsCategory common
 */
export enum JobState {
    CANCELLED = 'CANCELLED',
    COMPLETED = 'COMPLETED',
    FAILED = 'FAILED',
    PENDING = 'PENDING',
    RETRYING = 'RETRYING',
    RUNNING = 'RUNNING',
}

/**
 * @description
 * Languages in the form of a ISO 639-1 language code with optional
 * region or script modifier (e.g. de_AT). The selection available is based
 * on the [Unicode CLDR summary list](https://unicode-org.github.io/cldr-staging/charts/37/summary/root.html)
 * and includes the major spoken languages of the world and any widely-used variants.
 *
 * @docsCategory common
 */
export enum LanguageCode {
    /** Afrikaans */
    af = 'af',
    /** Akan */
    ak = 'ak',
    /** Amharic */
    am = 'am',
    /** Arabic */
    ar = 'ar',
    /** Assamese */
    as = 'as',
    /** Azerbaijani */
    az = 'az',
    /** Belarusian */
    be = 'be',
    /** Bulgarian */
    bg = 'bg',
    /** Bambara */
    bm = 'bm',
    /** Bangla */
    bn = 'bn',
    /** Tibetan */
    bo = 'bo',
    /** Breton */
    br = 'br',
    /** Bosnian */
    bs = 'bs',
    /** Catalan */
    ca = 'ca',
    /** Chechen */
    ce = 'ce',
    /** Corsican */
    co = 'co',
    /** Czech */
    cs = 'cs',
    /** Church Slavic */
    cu = 'cu',
    /** Welsh */
    cy = 'cy',
    /** Danish */
    da = 'da',
    /** German */
    de = 'de',
    /** Austrian German */
    de_AT = 'de_AT',
    /** Swiss High German */
    de_CH = 'de_CH',
    /** Dzongkha */
    dz = 'dz',
    /** Ewe */
    ee = 'ee',
    /** Greek */
    el = 'el',
    /** English */
    en = 'en',
    /** Australian English */
    en_AU = 'en_AU',
    /** Canadian English */
    en_CA = 'en_CA',
    /** British English */
    en_GB = 'en_GB',
    /** American English */
    en_US = 'en_US',
    /** Esperanto */
    eo = 'eo',
    /** Spanish */
    es = 'es',
    /** European Spanish */
    es_ES = 'es_ES',
    /** Mexican Spanish */
    es_MX = 'es_MX',
    /** Estonian */
    et = 'et',
    /** Basque */
    eu = 'eu',
    /** Persian */
    fa = 'fa',
    /** Dari */
    fa_AF = 'fa_AF',
    /** Fulah */
    ff = 'ff',
    /** Finnish */
    fi = 'fi',
    /** Faroese */
    fo = 'fo',
    /** French */
    fr = 'fr',
    /** Canadian French */
    fr_CA = 'fr_CA',
    /** Swiss French */
    fr_CH = 'fr_CH',
    /** Western Frisian */
    fy = 'fy',
    /** Irish */
    ga = 'ga',
    /** Scottish Gaelic */
    gd = 'gd',
    /** Galician */
    gl = 'gl',
    /** Gujarati */
    gu = 'gu',
    /** Manx */
    gv = 'gv',
    /** Hausa */
    ha = 'ha',
    /** Hebrew */
    he = 'he',
    /** Hindi */
    hi = 'hi',
    /** Croatian */
    hr = 'hr',
    /** Haitian Creole */
    ht = 'ht',
    /** Hungarian */
    hu = 'hu',
    /** Armenian */
    hy = 'hy',
    /** Interlingua */
    ia = 'ia',
    /** Indonesian */
    id = 'id',
    /** Igbo */
    ig = 'ig',
    /** Sichuan Yi */
    ii = 'ii',
    /** Icelandic */
    is = 'is',
    /** Italian */
    it = 'it',
    /** Japanese */
    ja = 'ja',
    /** Javanese */
    jv = 'jv',
    /** Georgian */
    ka = 'ka',
    /** Kikuyu */
    ki = 'ki',
    /** Kazakh */
    kk = 'kk',
    /** Kalaallisut */
    kl = 'kl',
    /** Khmer */
    km = 'km',
    /** Kannada */
    kn = 'kn',
    /** Korean */
    ko = 'ko',
    /** Kashmiri */
    ks = 'ks',
    /** Kurdish */
    ku = 'ku',
    /** Cornish */
    kw = 'kw',
    /** Kyrgyz */
    ky = 'ky',
    /** Latin */
    la = 'la',
    /** Luxembourgish */
    lb = 'lb',
    /** Ganda */
    lg = 'lg',
    /** Lingala */
    ln = 'ln',
    /** Lao */
    lo = 'lo',
    /** Lithuanian */
    lt = 'lt',
    /** Luba-Katanga */
    lu = 'lu',
    /** Latvian */
    lv = 'lv',
    /** Malagasy */
    mg = 'mg',
    /** Maori */
    mi = 'mi',
    /** Macedonian */
    mk = 'mk',
    /** Malayalam */
    ml = 'ml',
    /** Mongolian */
    mn = 'mn',
    /** Marathi */
    mr = 'mr',
    /** Malay */
    ms = 'ms',
    /** Maltese */
    mt = 'mt',
    /** Burmese */
    my = 'my',
    /** Norwegian Bokmål */
    nb = 'nb',
    /** North Ndebele */
    nd = 'nd',
    /** Nepali */
    ne = 'ne',
    /** Dutch */
    nl = 'nl',
    /** Flemish */
    nl_BE = 'nl_BE',
    /** Norwegian Nynorsk */
    nn = 'nn',
    /** Nyanja */
    ny = 'ny',
    /** Oromo */
    om = 'om',
    /** Odia */
    or = 'or',
    /** Ossetic */
    os = 'os',
    /** Punjabi */
    pa = 'pa',
    /** Polish */
    pl = 'pl',
    /** Pashto */
    ps = 'ps',
    /** Portuguese */
    pt = 'pt',
    /** Brazilian Portuguese */
    pt_BR = 'pt_BR',
    /** European Portuguese */
    pt_PT = 'pt_PT',
    /** Quechua */
    qu = 'qu',
    /** Romansh */
    rm = 'rm',
    /** Rundi */
    rn = 'rn',
    /** Romanian */
    ro = 'ro',
    /** Moldavian */
    ro_MD = 'ro_MD',
    /** Russian */
    ru = 'ru',
    /** Kinyarwanda */
    rw = 'rw',
    /** Sanskrit */
    sa = 'sa',
    /** Sindhi */
    sd = 'sd',
    /** Northern Sami */
    se = 'se',
    /** Sango */
    sg = 'sg',
    /** Sinhala */
    si = 'si',
    /** Slovak */
    sk = 'sk',
    /** Slovenian */
    sl = 'sl',
    /** Samoan */
    sm = 'sm',
    /** Shona */
    sn = 'sn',
    /** Somali */
    so = 'so',
    /** Albanian */
    sq = 'sq',
    /** Serbian */
    sr = 'sr',
    /** Southern Sotho */
    st = 'st',
    /** Sundanese */
    su = 'su',
    /** Swedish */
    sv = 'sv',
    /** Swahili */
    sw = 'sw',
    /** Congo Swahili */
    sw_CD = 'sw_CD',
    /** Tamil */
    ta = 'ta',
    /** Telugu */
    te = 'te',
    /** Tajik */
    tg = 'tg',
    /** Thai */
    th = 'th',
    /** Tigrinya */
    ti = 'ti',
    /** Turkmen */
    tk = 'tk',
    /** Tongan */
    to = 'to',
    /** Turkish */
    tr = 'tr',
    /** Tatar */
    tt = 'tt',
    /** Uyghur */
    ug = 'ug',
    /** Ukrainian */
    uk = 'uk',
    /** Urdu */
    ur = 'ur',
    /** Uzbek */
    uz = 'uz',
    /** Vietnamese */
    vi = 'vi',
    /** Volapük */
    vo = 'vo',
    /** Wolof */
    wo = 'wo',
    /** Xhosa */
    xh = 'xh',
    /** Yiddish */
    yi = 'yi',
    /** Yoruba */
    yo = 'yo',
    /** Chinese */
    zh = 'zh',
    /** Simplified Chinese */
    zh_Hans = 'zh_Hans',
    /** Traditional Chinese */
    zh_Hant = 'zh_Hant',
    /** Zulu */
    zu = 'zu',
}

/** Returned if attempting to set a Channel's defaultLanguageCode to a language which is not enabled in GlobalSettings */
export type LanguageNotAvailableError = ErrorResult & {
    errorCode: ErrorCode;
    languageCode: Scalars['String']['output'];
    message: Scalars['String']['output'];
};

export type LocaleStringCustomFieldConfig = CustomField & {
    description?: Maybe<Array<LocalizedString>>;
    internal?: Maybe<Scalars['Boolean']['output']>;
    label?: Maybe<Array<LocalizedString>>;
    length?: Maybe<Scalars['Int']['output']>;
    list: Scalars['Boolean']['output'];
    name: Scalars['String']['output'];
    nullable?: Maybe<Scalars['Boolean']['output']>;
    pattern?: Maybe<Scalars['String']['output']>;
    readonly?: Maybe<Scalars['Boolean']['output']>;
    requiresPermission?: Maybe<Array<Permission>>;
    type: Scalars['String']['output'];
    ui?: Maybe<Scalars['JSON']['output']>;
};

export type LocaleTextCustomFieldConfig = CustomField & {
    description?: Maybe<Array<LocalizedString>>;
    internal?: Maybe<Scalars['Boolean']['output']>;
    label?: Maybe<Array<LocalizedString>>;
    list: Scalars['Boolean']['output'];
    name: Scalars['String']['output'];
    nullable?: Maybe<Scalars['Boolean']['output']>;
    readonly?: Maybe<Scalars['Boolean']['output']>;
    requiresPermission?: Maybe<Array<Permission>>;
    type: Scalars['String']['output'];
    ui?: Maybe<Scalars['JSON']['output']>;
};

export type LocalizedString = {
    languageCode: LanguageCode;
    value: Scalars['String']['output'];
};

export enum LogicalOperator {
    AND = 'AND',
    OR = 'OR',
}

export type ManualPaymentInput = {
    metadata?: InputMaybe<Scalars['JSON']['input']>;
    method: Scalars['String']['input'];
    orderId: Scalars['ID']['input'];
    transactionId?: InputMaybe<Scalars['String']['input']>;
};

/**
 * Returned when a call to addManualPaymentToOrder is made but the Order
 * is not in the required state.
 */
export type ManualPaymentStateError = ErrorResult & {
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
};

export enum MetricInterval {
    Daily = 'Daily',
}

export type MetricSummary = {
    entries: Array<MetricSummaryEntry>;
    interval: MetricInterval;
    title: Scalars['String']['output'];
    type: MetricType;
};

export type MetricSummaryEntry = {
    label: Scalars['String']['output'];
    value: Scalars['Float']['output'];
};

export type MetricSummaryInput = {
    interval: MetricInterval;
    refresh?: InputMaybe<Scalars['Boolean']['input']>;
    types: Array<MetricType>;
};

export enum MetricType {
    AverageOrderValue = 'AverageOrderValue',
    OrderCount = 'OrderCount',
    OrderTotal = 'OrderTotal',
}

export type MimeTypeError = ErrorResult & {
    errorCode: ErrorCode;
    fileName: Scalars['String']['output'];
    message: Scalars['String']['output'];
    mimeType: Scalars['String']['output'];
};

/** Returned if a PromotionCondition has neither a couponCode nor any conditions set */
export type MissingConditionsError = ErrorResult & {
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
};

export type ModifyOrderInput = {
    addItems?: InputMaybe<Array<AddItemInput>>;
    adjustOrderLines?: InputMaybe<Array<OrderLineInput>>;
    couponCodes?: InputMaybe<Array<Scalars['String']['input']>>;
    dryRun: Scalars['Boolean']['input'];
    note?: InputMaybe<Scalars['String']['input']>;
    options?: InputMaybe<ModifyOrderOptions>;
    orderId: Scalars['ID']['input'];
    /**
     * Deprecated in v2.2.0. Use `refunds` instead to allow multiple refunds to be
     * applied in the case that multiple payment methods have been used on the order.
     */
    refund?: InputMaybe<AdministratorRefundInput>;
    refunds?: InputMaybe<Array<AdministratorRefundInput>>;
    /** Added in v2.2 */
    shippingMethodIds?: InputMaybe<Array<Scalars['ID']['input']>>;
    surcharges?: InputMaybe<Array<SurchargeInput>>;
    updateBillingAddress?: InputMaybe<UpdateOrderAddressInput>;
    updateShippingAddress?: InputMaybe<UpdateOrderAddressInput>;
};

export type ModifyOrderOptions = {
    freezePromotions?: InputMaybe<Scalars['Boolean']['input']>;
    recalculateShipping?: InputMaybe<Scalars['Boolean']['input']>;
};

export type ModifyOrderResult =
    | CouponCodeExpiredError
    | CouponCodeInvalidError
    | CouponCodeLimitError
    | IneligibleShippingMethodError
    | InsufficientStockError
    | NegativeQuantityError
    | NoChangesSpecifiedError
    | Order
    | OrderLimitError
    | OrderModificationStateError
    | PaymentMethodMissingError
    | RefundPaymentIdMissingError;

export type MoveCollectionInput = {
    collectionId: Scalars['ID']['input'];
    index: Scalars['Int']['input'];
    parentId: Scalars['ID']['input'];
};

/** Returned if an operation has specified OrderLines from multiple Orders */
export type MultipleOrderError = ErrorResult & {
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
};

export type Mutation = {
    /** Add Customers to a CustomerGroup */
    addCustomersToGroup: CustomerGroup;
    addFulfillmentToOrder: AddFulfillmentToOrderResult;
    /** Adds an item to the draft Order. */
    addItemToDraftOrder: UpdateOrderItemsResult;
    /**
     * Used to manually create a new Payment against an Order.
     * This can be used by an Administrator when an Order is in the ArrangingPayment state.
     *
     * It is also used when a completed Order
     * has been modified (using `modifyOrder`) and the price has increased. The extra payment
     * can then be manually arranged by the administrator, and the details used to create a new
     * Payment.
     */
    addManualPaymentToOrder: AddManualPaymentToOrderResult;
    /** Add members to a Zone */
    addMembersToZone: Zone;
    addNoteToCustomer: Customer;
    addNoteToOrder: Order;
    /** Add an OptionGroup to a Product */
    addOptionGroupToProduct: Product;
    /** Adjusts a draft OrderLine. If custom fields are defined on the OrderLine entity, a third argument 'customFields' of type `OrderLineCustomFieldsInput` will be available. */
    adjustDraftOrderLine: UpdateOrderItemsResult;
    /** Applies the given coupon code to the draft Order */
    applyCouponCodeToDraftOrder: ApplyCouponCodeResult;
    /** Assign assets to channel */
    assignAssetsToChannel: Array<Asset>;
    /** Assigns Collections to the specified Channel */
    assignCollectionsToChannel: Array<Collection>;
    /** Assigns Facets to the specified Channel */
    assignFacetsToChannel: Array<Facet>;
    /** Assigns PaymentMethods to the specified Channel */
    assignPaymentMethodsToChannel: Array<PaymentMethod>;
    /** Assigns ProductVariants to the specified Channel */
    assignProductVariantsToChannel: Array<ProductVariant>;
    /** Assigns all ProductVariants of Product to the specified Channel */
    assignProductsToChannel: Array<Product>;
    /** Assigns Promotions to the specified Channel */
    assignPromotionsToChannel: Array<Promotion>;
    /** Assign a Role to an Administrator */
    assignRoleToAdministrator: Administrator;
    /** Assigns ShippingMethods to the specified Channel */
    assignShippingMethodsToChannel: Array<ShippingMethod>;
    /** Assigns StockLocations to the specified Channel */
    assignStockLocationsToChannel: Array<StockLocation>;
    /** Authenticates the user using a named authentication strategy */
    authenticate: AuthenticationResult;
    cancelJob: Job;
    cancelOrder: CancelOrderResult;
    cancelPayment: CancelPaymentResult;
    /** Create a new Administrator */
    createAdministrator: Administrator;
    /** Create a new Asset */
    createAssets: Array<CreateAssetResult>;
    /** Create a new Channel */
    createChannel: CreateChannelResult;
    /** Create a new Collection */
    createCollection: Collection;
    /** Create a new Country */
    createCountry: Country;
    /** Create a new Customer. If a password is provided, a new User will also be created an linked to the Customer. */
    createCustomer: CreateCustomerResult;
    /** Create a new Address and associate it with the Customer specified by customerId */
    createCustomerAddress: Address;
    /** Create a new CustomerGroup */
    createCustomerGroup: CustomerGroup;
    /** Creates a draft Order */
    createDraftOrder: Order;
    /** Create a new Facet */
    createFacet: Facet;
    /** Create one or more FacetValues */
    createFacetValues: Array<FacetValue>;
    /** Create existing PaymentMethod */
    createPaymentMethod: PaymentMethod;
    /** Create a new Product */
    createProduct: Product;
    /** Create a new ProductOption within a ProductOptionGroup */
    createProductOption: ProductOption;
    /** Create a new ProductOptionGroup */
    createProductOptionGroup: ProductOptionGroup;
    /** Create a set of ProductVariants based on the OptionGroups assigned to the given Product */
    createProductVariants: Array<Maybe<ProductVariant>>;
    createPromotion: CreatePromotionResult;
    /** Create a new Province */
    createProvince: Province;
    /** Create a new Role */
    createRole: Role;
    /** Create a new Seller */
    createSeller: Seller;
    /** Create a new ShippingMethod */
    createShippingMethod: ShippingMethod;
    createStockLocation: StockLocation;
    /** Create a new Tag */
    createTag: Tag;
    /** Create a new TaxCategory */
    createTaxCategory: TaxCategory;
    /** Create a new TaxRate */
    createTaxRate: TaxRate;
    /** Create a new Zone */
    createZone: Zone;
    /** Delete an Administrator */
    deleteAdministrator: DeletionResponse;
    /** Delete multiple Administrators */
    deleteAdministrators: Array<DeletionResponse>;
    /** Delete an Asset */
    deleteAsset: DeletionResponse;
    /** Delete multiple Assets */
    deleteAssets: DeletionResponse;
    /** Delete a Channel */
    deleteChannel: DeletionResponse;
    /** Delete multiple Channels */
    deleteChannels: Array<DeletionResponse>;
    /** Delete a Collection and all of its descendants */
    deleteCollection: DeletionResponse;
    /** Delete multiple Collections and all of their descendants */
    deleteCollections: Array<DeletionResponse>;
    /** Delete multiple Countries */
    deleteCountries: Array<DeletionResponse>;
    /** Delete a Country */
    deleteCountry: DeletionResponse;
    /** Delete a Customer */
    deleteCustomer: DeletionResponse;
    /** Update an existing Address */
    deleteCustomerAddress: Success;
    /** Delete a CustomerGroup */
    deleteCustomerGroup: DeletionResponse;
    /** Delete multiple CustomerGroups */
    deleteCustomerGroups: Array<DeletionResponse>;
    deleteCustomerNote: DeletionResponse;
    /** Deletes Customers */
    deleteCustomers: Array<DeletionResponse>;
    /** Deletes a draft Order */
    deleteDraftOrder: DeletionResponse;
    /** Delete an existing Facet */
    deleteFacet: DeletionResponse;
    /** Delete one or more FacetValues */
    deleteFacetValues: Array<DeletionResponse>;
    /** Delete multiple existing Facets */
    deleteFacets: Array<DeletionResponse>;
    deleteOrderNote: DeletionResponse;
    /** Delete a PaymentMethod */
    deletePaymentMethod: DeletionResponse;
    /** Delete multiple PaymentMethods */
    deletePaymentMethods: Array<DeletionResponse>;
    /** Delete a Product */
    deleteProduct: DeletionResponse;
    /** Delete a ProductOption */
    deleteProductOption: DeletionResponse;
    /** Delete a ProductVariant */
    deleteProductVariant: DeletionResponse;
    /** Delete multiple ProductVariants */
    deleteProductVariants: Array<DeletionResponse>;
    /** Delete multiple Products */
    deleteProducts: Array<DeletionResponse>;
    deletePromotion: DeletionResponse;
    deletePromotions: Array<DeletionResponse>;
    /** Delete a Province */
    deleteProvince: DeletionResponse;
    /** Delete an existing Role */
    deleteRole: DeletionResponse;
    /** Delete multiple Roles */
    deleteRoles: Array<DeletionResponse>;
    /** Delete a Seller */
    deleteSeller: DeletionResponse;
    /** Delete multiple Sellers */
    deleteSellers: Array<DeletionResponse>;
    /** Delete a ShippingMethod */
    deleteShippingMethod: DeletionResponse;
    /** Delete multiple ShippingMethods */
    deleteShippingMethods: Array<DeletionResponse>;
    deleteStockLocation: DeletionResponse;
    deleteStockLocations: Array<DeletionResponse>;
    /** Delete an existing Tag */
    deleteTag: DeletionResponse;
    /** Deletes multiple TaxCategories */
    deleteTaxCategories: Array<DeletionResponse>;
    /** Deletes a TaxCategory */
    deleteTaxCategory: DeletionResponse;
    /** Delete a TaxRate */
    deleteTaxRate: DeletionResponse;
    /** Delete multiple TaxRates */
    deleteTaxRates: Array<DeletionResponse>;
    /** Delete a Zone */
    deleteZone: DeletionResponse;
    /** Delete a Zone */
    deleteZones: Array<DeletionResponse>;
    /**
     * Duplicate an existing entity using a specific EntityDuplicator.
     * Since v2.2.0.
     */
    duplicateEntity: DuplicateEntityResult;
    flushBufferedJobs: Success;
    importProducts?: Maybe<ImportInfo>;
    /**
     * Authenticates the user using the native authentication strategy. This mutation is an alias for authenticate({ native: { ... }})
     *
     * The `rememberMe` option applies when using cookie-based sessions, and if `true` it will set the maxAge of the session cookie
     * to 1 year.
     */
    login: NativeAuthenticationResult;
    logout: Success;
    /**
     * Allows an Order to be modified after it has been completed by the Customer. The Order must first
     * be in the `Modifying` state.
     */
    modifyOrder: ModifyOrderResult;
    /** Move a Collection to a different parent or index */
    moveCollection: Collection;
    refundOrder: RefundOrderResult;
    reindex: Job;
    /** Removes Collections from the specified Channel */
    removeCollectionsFromChannel: Array<Collection>;
    /** Removes the given coupon code from the draft Order */
    removeCouponCodeFromDraftOrder?: Maybe<Order>;
    /** Remove Customers from a CustomerGroup */
    removeCustomersFromGroup: CustomerGroup;
    /** Remove an OrderLine from the draft Order */
    removeDraftOrderLine: RemoveOrderItemsResult;
    /** Removes Facets from the specified Channel */
    removeFacetsFromChannel: Array<RemoveFacetFromChannelResult>;
    /** Remove members from a Zone */
    removeMembersFromZone: Zone;
    /**
     * Remove an OptionGroup from a Product. If the OptionGroup is in use by any ProductVariants
     * the mutation will return a ProductOptionInUseError, and the OptionGroup will not be removed.
     * Setting the `force` argument to `true` will override this and remove the OptionGroup anyway,
     * as well as removing any of the group's options from the Product's ProductVariants.
     */
    removeOptionGroupFromProduct: RemoveOptionGroupFromProductResult;
    /** Removes PaymentMethods from the specified Channel */
    removePaymentMethodsFromChannel: Array<PaymentMethod>;
    /** Removes ProductVariants from the specified Channel */
    removeProductVariantsFromChannel: Array<ProductVariant>;
    /** Removes all ProductVariants of Product from the specified Channel */
    removeProductsFromChannel: Array<Product>;
    /** Removes Promotions from the specified Channel */
    removePromotionsFromChannel: Array<Promotion>;
    /** Remove all settled jobs in the given queues older than the given date. Returns the number of jobs deleted. */
    removeSettledJobs: Scalars['Int']['output'];
    /** Removes ShippingMethods from the specified Channel */
    removeShippingMethodsFromChannel: Array<ShippingMethod>;
    /** Removes StockLocations from the specified Channel */
    removeStockLocationsFromChannel: Array<StockLocation>;
    runPendingSearchIndexUpdates: Success;
    setCustomerForDraftOrder: SetCustomerForDraftOrderResult;
    /** Sets the billing address for a draft Order */
    setDraftOrderBillingAddress: Order;
    /** Allows any custom fields to be set for the active order */
    setDraftOrderCustomFields: Order;
    /** Sets the shipping address for a draft Order */
    setDraftOrderShippingAddress: Order;
    /** Sets the shipping method by id, which can be obtained with the `eligibleShippingMethodsForDraftOrder` query */
    setDraftOrderShippingMethod: SetOrderShippingMethodResult;
    setOrderCustomFields?: Maybe<Order>;
    /** Allows a different Customer to be assigned to an Order. Added in v2.2.0. */
    setOrderCustomer?: Maybe<Order>;
    settlePayment: SettlePaymentResult;
    settleRefund: SettleRefundResult;
    transitionFulfillmentToState: TransitionFulfillmentToStateResult;
    transitionOrderToState?: Maybe<TransitionOrderToStateResult>;
    transitionPaymentToState: TransitionPaymentToStateResult;
    /** Update the active (currently logged-in) Administrator */
    updateActiveAdministrator: Administrator;
    /** Update an existing Administrator */
    updateAdministrator: Administrator;
    /** Update an existing Asset */
    updateAsset: Asset;
    /** Update an existing Channel */
    updateChannel: UpdateChannelResult;
    /** Update an existing Collection */
    updateCollection: Collection;
    /** Update an existing Country */
    updateCountry: Country;
    /** Update an existing Customer */
    updateCustomer: UpdateCustomerResult;
    /** Update an existing Address */
    updateCustomerAddress: Address;
    /** Update an existing CustomerGroup */
    updateCustomerGroup: CustomerGroup;
    updateCustomerNote: HistoryEntry;
    /** Update an existing Facet */
    updateFacet: Facet;
    /** Update one or more FacetValues */
    updateFacetValues: Array<FacetValue>;
    updateGlobalSettings: UpdateGlobalSettingsResult;
    updateOrderNote: HistoryEntry;
    /** Update an existing PaymentMethod */
    updatePaymentMethod: PaymentMethod;
    /** Update an existing Product */
    updateProduct: Product;
    /** Create a new ProductOption within a ProductOptionGroup */
    updateProductOption: ProductOption;
    /** Update an existing ProductOptionGroup */
    updateProductOptionGroup: ProductOptionGroup;
    /** Update existing ProductVariants */
    updateProductVariants: Array<Maybe<ProductVariant>>;
    /** Update multiple existing Products */
    updateProducts: Array<Product>;
    updatePromotion: UpdatePromotionResult;
    /** Update an existing Province */
    updateProvince: Province;
    /** Update an existing Role */
    updateRole: Role;
    /** Update an existing Seller */
    updateSeller: Seller;
    /** Update an existing ShippingMethod */
    updateShippingMethod: ShippingMethod;
    updateStockLocation: StockLocation;
    /** Update an existing Tag */
    updateTag: Tag;
    /** Update an existing TaxCategory */
    updateTaxCategory: TaxCategory;
    /** Update an existing TaxRate */
    updateTaxRate: TaxRate;
    /** Update an existing Zone */
    updateZone: Zone;
};

export type MutationAddCustomersToGroupArgs = {
    customerGroupId: Scalars['ID']['input'];
    customerIds: Array<Scalars['ID']['input']>;
};

export type MutationAddFulfillmentToOrderArgs = {
    input: FulfillOrderInput;
};

export type MutationAddItemToDraftOrderArgs = {
    input: AddItemToDraftOrderInput;
    orderId: Scalars['ID']['input'];
};

export type MutationAddManualPaymentToOrderArgs = {
    input: ManualPaymentInput;
};

export type MutationAddMembersToZoneArgs = {
    memberIds: Array<Scalars['ID']['input']>;
    zoneId: Scalars['ID']['input'];
};

export type MutationAddNoteToCustomerArgs = {
    input: AddNoteToCustomerInput;
};

export type MutationAddNoteToOrderArgs = {
    input: AddNoteToOrderInput;
};

export type MutationAddOptionGroupToProductArgs = {
    optionGroupId: Scalars['ID']['input'];
    productId: Scalars['ID']['input'];
};

export type MutationAdjustDraftOrderLineArgs = {
    input: AdjustDraftOrderLineInput;
    orderId: Scalars['ID']['input'];
};

export type MutationApplyCouponCodeToDraftOrderArgs = {
    couponCode: Scalars['String']['input'];
    orderId: Scalars['ID']['input'];
};

export type MutationAssignAssetsToChannelArgs = {
    input: AssignAssetsToChannelInput;
};

export type MutationAssignCollectionsToChannelArgs = {
    input: AssignCollectionsToChannelInput;
};

export type MutationAssignFacetsToChannelArgs = {
    input: AssignFacetsToChannelInput;
};

export type MutationAssignPaymentMethodsToChannelArgs = {
    input: AssignPaymentMethodsToChannelInput;
};

export type MutationAssignProductVariantsToChannelArgs = {
    input: AssignProductVariantsToChannelInput;
};

export type MutationAssignProductsToChannelArgs = {
    input: AssignProductsToChannelInput;
};

export type MutationAssignPromotionsToChannelArgs = {
    input: AssignPromotionsToChannelInput;
};

export type MutationAssignRoleToAdministratorArgs = {
    administratorId: Scalars['ID']['input'];
    roleId: Scalars['ID']['input'];
};

export type MutationAssignShippingMethodsToChannelArgs = {
    input: AssignShippingMethodsToChannelInput;
};

export type MutationAssignStockLocationsToChannelArgs = {
    input: AssignStockLocationsToChannelInput;
};

export type MutationAuthenticateArgs = {
    input: AuthenticationInput;
    rememberMe?: InputMaybe<Scalars['Boolean']['input']>;
};

export type MutationCancelJobArgs = {
    jobId: Scalars['ID']['input'];
};

export type MutationCancelOrderArgs = {
    input: CancelOrderInput;
};

export type MutationCancelPaymentArgs = {
    id: Scalars['ID']['input'];
};

export type MutationCreateAdministratorArgs = {
    input: CreateAdministratorInput;
};

export type MutationCreateAssetsArgs = {
    input: Array<CreateAssetInput>;
};

export type MutationCreateChannelArgs = {
    input: CreateChannelInput;
};

export type MutationCreateCollectionArgs = {
    input: CreateCollectionInput;
};

export type MutationCreateCountryArgs = {
    input: CreateCountryInput;
};

export type MutationCreateCustomerArgs = {
    input: CreateCustomerInput;
    password?: InputMaybe<Scalars['String']['input']>;
};

export type MutationCreateCustomerAddressArgs = {
    customerId: Scalars['ID']['input'];
    input: CreateAddressInput;
};

export type MutationCreateCustomerGroupArgs = {
    input: CreateCustomerGroupInput;
};

export type MutationCreateFacetArgs = {
    input: CreateFacetInput;
};

export type MutationCreateFacetValuesArgs = {
    input: Array<CreateFacetValueInput>;
};

export type MutationCreatePaymentMethodArgs = {
    input: CreatePaymentMethodInput;
};

export type MutationCreateProductArgs = {
    input: CreateProductInput;
};

export type MutationCreateProductOptionArgs = {
    input: CreateProductOptionInput;
};

export type MutationCreateProductOptionGroupArgs = {
    input: CreateProductOptionGroupInput;
};

export type MutationCreateProductVariantsArgs = {
    input: Array<CreateProductVariantInput>;
};

export type MutationCreatePromotionArgs = {
    input: CreatePromotionInput;
};

export type MutationCreateProvinceArgs = {
    input: CreateProvinceInput;
};

export type MutationCreateRoleArgs = {
    input: CreateRoleInput;
};

export type MutationCreateSellerArgs = {
    input: CreateSellerInput;
};

export type MutationCreateShippingMethodArgs = {
    input: CreateShippingMethodInput;
};

export type MutationCreateStockLocationArgs = {
    input: CreateStockLocationInput;
};

export type MutationCreateTagArgs = {
    input: CreateTagInput;
};

export type MutationCreateTaxCategoryArgs = {
    input: CreateTaxCategoryInput;
};

export type MutationCreateTaxRateArgs = {
    input: CreateTaxRateInput;
};

export type MutationCreateZoneArgs = {
    input: CreateZoneInput;
};

export type MutationDeleteAdministratorArgs = {
    id: Scalars['ID']['input'];
};

export type MutationDeleteAdministratorsArgs = {
    ids: Array<Scalars['ID']['input']>;
};

export type MutationDeleteAssetArgs = {
    input: DeleteAssetInput;
};

export type MutationDeleteAssetsArgs = {
    input: DeleteAssetsInput;
};

export type MutationDeleteChannelArgs = {
    id: Scalars['ID']['input'];
};

export type MutationDeleteChannelsArgs = {
    ids: Array<Scalars['ID']['input']>;
};

export type MutationDeleteCollectionArgs = {
    id: Scalars['ID']['input'];
};

export type MutationDeleteCollectionsArgs = {
    ids: Array<Scalars['ID']['input']>;
};

export type MutationDeleteCountriesArgs = {
    ids: Array<Scalars['ID']['input']>;
};

export type MutationDeleteCountryArgs = {
    id: Scalars['ID']['input'];
};

export type MutationDeleteCustomerArgs = {
    id: Scalars['ID']['input'];
};

export type MutationDeleteCustomerAddressArgs = {
    id: Scalars['ID']['input'];
};

export type MutationDeleteCustomerGroupArgs = {
    id: Scalars['ID']['input'];
};

export type MutationDeleteCustomerGroupsArgs = {
    ids: Array<Scalars['ID']['input']>;
};

export type MutationDeleteCustomerNoteArgs = {
    id: Scalars['ID']['input'];
};

export type MutationDeleteCustomersArgs = {
    ids: Array<Scalars['ID']['input']>;
};

export type MutationDeleteDraftOrderArgs = {
    orderId: Scalars['ID']['input'];
};

export type MutationDeleteFacetArgs = {
    force?: InputMaybe<Scalars['Boolean']['input']>;
    id: Scalars['ID']['input'];
};

export type MutationDeleteFacetValuesArgs = {
    force?: InputMaybe<Scalars['Boolean']['input']>;
    ids: Array<Scalars['ID']['input']>;
};

export type MutationDeleteFacetsArgs = {
    force?: InputMaybe<Scalars['Boolean']['input']>;
    ids: Array<Scalars['ID']['input']>;
};

export type MutationDeleteOrderNoteArgs = {
    id: Scalars['ID']['input'];
};

export type MutationDeletePaymentMethodArgs = {
    force?: InputMaybe<Scalars['Boolean']['input']>;
    id: Scalars['ID']['input'];
};

export type MutationDeletePaymentMethodsArgs = {
    force?: InputMaybe<Scalars['Boolean']['input']>;
    ids: Array<Scalars['ID']['input']>;
};

export type MutationDeleteProductArgs = {
    id: Scalars['ID']['input'];
};

export type MutationDeleteProductOptionArgs = {
    id: Scalars['ID']['input'];
};

export type MutationDeleteProductVariantArgs = {
    id: Scalars['ID']['input'];
};

export type MutationDeleteProductVariantsArgs = {
    ids: Array<Scalars['ID']['input']>;
};

export type MutationDeleteProductsArgs = {
    ids: Array<Scalars['ID']['input']>;
};

export type MutationDeletePromotionArgs = {
    id: Scalars['ID']['input'];
};

export type MutationDeletePromotionsArgs = {
    ids: Array<Scalars['ID']['input']>;
};

export type MutationDeleteProvinceArgs = {
    id: Scalars['ID']['input'];
};

export type MutationDeleteRoleArgs = {
    id: Scalars['ID']['input'];
};

export type MutationDeleteRolesArgs = {
    ids: Array<Scalars['ID']['input']>;
};

export type MutationDeleteSellerArgs = {
    id: Scalars['ID']['input'];
};

export type MutationDeleteSellersArgs = {
    ids: Array<Scalars['ID']['input']>;
};

export type MutationDeleteShippingMethodArgs = {
    id: Scalars['ID']['input'];
};

export type MutationDeleteShippingMethodsArgs = {
    ids: Array<Scalars['ID']['input']>;
};

export type MutationDeleteStockLocationArgs = {
    input: DeleteStockLocationInput;
};

export type MutationDeleteStockLocationsArgs = {
    input: Array<DeleteStockLocationInput>;
};

export type MutationDeleteTagArgs = {
    id: Scalars['ID']['input'];
};

export type MutationDeleteTaxCategoriesArgs = {
    ids: Array<Scalars['ID']['input']>;
};

export type MutationDeleteTaxCategoryArgs = {
    id: Scalars['ID']['input'];
};

export type MutationDeleteTaxRateArgs = {
    id: Scalars['ID']['input'];
};

export type MutationDeleteTaxRatesArgs = {
    ids: Array<Scalars['ID']['input']>;
};

export type MutationDeleteZoneArgs = {
    id: Scalars['ID']['input'];
};

export type MutationDeleteZonesArgs = {
    ids: Array<Scalars['ID']['input']>;
};

export type MutationDuplicateEntityArgs = {
    input: DuplicateEntityInput;
};

export type MutationFlushBufferedJobsArgs = {
    bufferIds?: InputMaybe<Array<Scalars['String']['input']>>;
};

export type MutationImportProductsArgs = {
    csvFile: Scalars['Upload']['input'];
};

export type MutationLoginArgs = {
    password: Scalars['String']['input'];
    rememberMe?: InputMaybe<Scalars['Boolean']['input']>;
    username: Scalars['String']['input'];
};

export type MutationModifyOrderArgs = {
    input: ModifyOrderInput;
};

export type MutationMoveCollectionArgs = {
    input: MoveCollectionInput;
};

export type MutationRefundOrderArgs = {
    input: RefundOrderInput;
};

export type MutationRemoveCollectionsFromChannelArgs = {
    input: RemoveCollectionsFromChannelInput;
};

export type MutationRemoveCouponCodeFromDraftOrderArgs = {
    couponCode: Scalars['String']['input'];
    orderId: Scalars['ID']['input'];
};

export type MutationRemoveCustomersFromGroupArgs = {
    customerGroupId: Scalars['ID']['input'];
    customerIds: Array<Scalars['ID']['input']>;
};

export type MutationRemoveDraftOrderLineArgs = {
    orderId: Scalars['ID']['input'];
    orderLineId: Scalars['ID']['input'];
};

export type MutationRemoveFacetsFromChannelArgs = {
    input: RemoveFacetsFromChannelInput;
};

export type MutationRemoveMembersFromZoneArgs = {
    memberIds: Array<Scalars['ID']['input']>;
    zoneId: Scalars['ID']['input'];
};

export type MutationRemoveOptionGroupFromProductArgs = {
    force?: InputMaybe<Scalars['Boolean']['input']>;
    optionGroupId: Scalars['ID']['input'];
    productId: Scalars['ID']['input'];
};

export type MutationRemovePaymentMethodsFromChannelArgs = {
    input: RemovePaymentMethodsFromChannelInput;
};

export type MutationRemoveProductVariantsFromChannelArgs = {
    input: RemoveProductVariantsFromChannelInput;
};

export type MutationRemoveProductsFromChannelArgs = {
    input: RemoveProductsFromChannelInput;
};

export type MutationRemovePromotionsFromChannelArgs = {
    input: RemovePromotionsFromChannelInput;
};

export type MutationRemoveSettledJobsArgs = {
    olderThan?: InputMaybe<Scalars['DateTime']['input']>;
    queueNames?: InputMaybe<Array<Scalars['String']['input']>>;
};

export type MutationRemoveShippingMethodsFromChannelArgs = {
    input: RemoveShippingMethodsFromChannelInput;
};

export type MutationRemoveStockLocationsFromChannelArgs = {
    input: RemoveStockLocationsFromChannelInput;
};

export type MutationSetCustomerForDraftOrderArgs = {
    customerId?: InputMaybe<Scalars['ID']['input']>;
    input?: InputMaybe<CreateCustomerInput>;
    orderId: Scalars['ID']['input'];
};

export type MutationSetDraftOrderBillingAddressArgs = {
    input: CreateAddressInput;
    orderId: Scalars['ID']['input'];
};

export type MutationSetDraftOrderCustomFieldsArgs = {
    input: UpdateOrderInput;
    orderId: Scalars['ID']['input'];
};

export type MutationSetDraftOrderShippingAddressArgs = {
    input: CreateAddressInput;
    orderId: Scalars['ID']['input'];
};

export type MutationSetDraftOrderShippingMethodArgs = {
    orderId: Scalars['ID']['input'];
    shippingMethodId: Scalars['ID']['input'];
};

export type MutationSetOrderCustomFieldsArgs = {
    input: UpdateOrderInput;
};

export type MutationSetOrderCustomerArgs = {
    input: SetOrderCustomerInput;
};

export type MutationSettlePaymentArgs = {
    id: Scalars['ID']['input'];
};

export type MutationSettleRefundArgs = {
    input: SettleRefundInput;
};

export type MutationTransitionFulfillmentToStateArgs = {
    id: Scalars['ID']['input'];
    state: Scalars['String']['input'];
};

export type MutationTransitionOrderToStateArgs = {
    id: Scalars['ID']['input'];
    state: Scalars['String']['input'];
};

export type MutationTransitionPaymentToStateArgs = {
    id: Scalars['ID']['input'];
    state: Scalars['String']['input'];
};

export type MutationUpdateActiveAdministratorArgs = {
    input: UpdateActiveAdministratorInput;
};

export type MutationUpdateAdministratorArgs = {
    input: UpdateAdministratorInput;
};

export type MutationUpdateAssetArgs = {
    input: UpdateAssetInput;
};

export type MutationUpdateChannelArgs = {
    input: UpdateChannelInput;
};

export type MutationUpdateCollectionArgs = {
    input: UpdateCollectionInput;
};

export type MutationUpdateCountryArgs = {
    input: UpdateCountryInput;
};

export type MutationUpdateCustomerArgs = {
    input: UpdateCustomerInput;
};

export type MutationUpdateCustomerAddressArgs = {
    input: UpdateAddressInput;
};

export type MutationUpdateCustomerGroupArgs = {
    input: UpdateCustomerGroupInput;
};

export type MutationUpdateCustomerNoteArgs = {
    input: UpdateCustomerNoteInput;
};

export type MutationUpdateFacetArgs = {
    input: UpdateFacetInput;
};

export type MutationUpdateFacetValuesArgs = {
    input: Array<UpdateFacetValueInput>;
};

export type MutationUpdateGlobalSettingsArgs = {
    input: UpdateGlobalSettingsInput;
};

export type MutationUpdateOrderNoteArgs = {
    input: UpdateOrderNoteInput;
};

export type MutationUpdatePaymentMethodArgs = {
    input: UpdatePaymentMethodInput;
};

export type MutationUpdateProductArgs = {
    input: UpdateProductInput;
};

export type MutationUpdateProductOptionArgs = {
    input: UpdateProductOptionInput;
};

export type MutationUpdateProductOptionGroupArgs = {
    input: UpdateProductOptionGroupInput;
};

export type MutationUpdateProductVariantsArgs = {
    input: Array<UpdateProductVariantInput>;
};

export type MutationUpdateProductsArgs = {
    input: Array<UpdateProductInput>;
};

export type MutationUpdatePromotionArgs = {
    input: UpdatePromotionInput;
};

export type MutationUpdateProvinceArgs = {
    input: UpdateProvinceInput;
};

export type MutationUpdateRoleArgs = {
    input: UpdateRoleInput;
};

export type MutationUpdateSellerArgs = {
    input: UpdateSellerInput;
};

export type MutationUpdateShippingMethodArgs = {
    input: UpdateShippingMethodInput;
};

export type MutationUpdateStockLocationArgs = {
    input: UpdateStockLocationInput;
};

export type MutationUpdateTagArgs = {
    input: UpdateTagInput;
};

export type MutationUpdateTaxCategoryArgs = {
    input: UpdateTaxCategoryInput;
};

export type MutationUpdateTaxRateArgs = {
    input: UpdateTaxRateInput;
};

export type MutationUpdateZoneArgs = {
    input: UpdateZoneInput;
};

export type NativeAuthInput = {
    password: Scalars['String']['input'];
    username: Scalars['String']['input'];
};

/** Returned when attempting an operation that relies on the NativeAuthStrategy, if that strategy is not configured. */
export type NativeAuthStrategyError = ErrorResult & {
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
};

export type NativeAuthenticationResult = CurrentUser | InvalidCredentialsError | NativeAuthStrategyError;

/** Returned when attempting to set a negative OrderLine quantity. */
export type NegativeQuantityError = ErrorResult & {
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
};

/**
 * Returned when invoking a mutation which depends on there being an active Order on the
 * current session.
 */
export type NoActiveOrderError = ErrorResult & {
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
};

/** Returned when a call to modifyOrder fails to specify any changes */
export type NoChangesSpecifiedError = ErrorResult & {
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
};

export type Node = {
    id: Scalars['ID']['output'];
};

/** Returned if an attempting to refund an Order but neither items nor shipping refund was specified */
export type NothingToRefundError = ErrorResult & {
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
};

/** Operators for filtering on a list of Number fields */
export type NumberListOperators = {
    inList: Scalars['Float']['input'];
};

/** Operators for filtering on a Int or Float field */
export type NumberOperators = {
    between?: InputMaybe<NumberRange>;
    eq?: InputMaybe<Scalars['Float']['input']>;
    gt?: InputMaybe<Scalars['Float']['input']>;
    gte?: InputMaybe<Scalars['Float']['input']>;
    isNull?: InputMaybe<Scalars['Boolean']['input']>;
    lt?: InputMaybe<Scalars['Float']['input']>;
    lte?: InputMaybe<Scalars['Float']['input']>;
};

export type NumberRange = {
    end: Scalars['Float']['input'];
    start: Scalars['Float']['input'];
};

export type Order = Node & {
    /** An order is active as long as the payment process has not been completed */
    active: Scalars['Boolean']['output'];
    aggregateOrder?: Maybe<Order>;
    aggregateOrderId?: Maybe<Scalars['ID']['output']>;
    billingAddress?: Maybe<OrderAddress>;
    channels: Array<Channel>;
    /** A unique code for the Order */
    code: Scalars['String']['output'];
    /** An array of all coupon codes applied to the Order */
    couponCodes: Array<Scalars['String']['output']>;
    createdAt: Scalars['DateTime']['output'];
    currencyCode: CurrencyCode;
    customFields?: Maybe<Scalars['JSON']['output']>;
    customer?: Maybe<Customer>;
    discounts: Array<Discount>;
    fulfillments?: Maybe<Array<Fulfillment>>;
    history: HistoryEntryList;
    id: Scalars['ID']['output'];
    lines: Array<OrderLine>;
    modifications: Array<OrderModification>;
    nextStates: Array<Scalars['String']['output']>;
    /**
     * The date & time that the Order was placed, i.e. the Customer
     * completed the checkout and the Order is no longer "active"
     */
    orderPlacedAt?: Maybe<Scalars['DateTime']['output']>;
    payments?: Maybe<Array<Payment>>;
    /** Promotions applied to the order. Only gets populated after the payment process has completed. */
    promotions: Array<Promotion>;
    sellerOrders?: Maybe<Array<Order>>;
    shipping: Scalars['Money']['output'];
    shippingAddress?: Maybe<OrderAddress>;
    shippingLines: Array<ShippingLine>;
    shippingWithTax: Scalars['Money']['output'];
    state: Scalars['String']['output'];
    /**
     * The subTotal is the total of all OrderLines in the Order. This figure also includes any Order-level
     * discounts which have been prorated (proportionally distributed) amongst the items of each OrderLine.
     * To get a total of all OrderLines which does not account for prorated discounts, use the
     * sum of `OrderLine.discountedLinePrice` values.
     */
    subTotal: Scalars['Money']['output'];
    /** Same as subTotal, but inclusive of tax */
    subTotalWithTax: Scalars['Money']['output'];
    /**
     * Surcharges are arbitrary modifications to the Order total which are neither
     * ProductVariants nor discounts resulting from applied Promotions. For example,
     * one-off discounts based on customer interaction, or surcharges based on payment
     * methods.
     */
    surcharges: Array<Surcharge>;
    /** A summary of the taxes being applied to this Order */
    taxSummary: Array<OrderTaxSummary>;
    /** Equal to subTotal plus shipping */
    total: Scalars['Money']['output'];
    totalQuantity: Scalars['Int']['output'];
    /** The final payable amount. Equal to subTotalWithTax plus shippingWithTax */
    totalWithTax: Scalars['Money']['output'];
    type: OrderType;
    updatedAt: Scalars['DateTime']['output'];
};

export type OrderHistoryArgs = {
    options?: InputMaybe<HistoryEntryListOptions>;
};

export type OrderAddress = {
    city?: Maybe<Scalars['String']['output']>;
    company?: Maybe<Scalars['String']['output']>;
    country?: Maybe<Scalars['String']['output']>;
    countryCode?: Maybe<Scalars['String']['output']>;
    customFields?: Maybe<Scalars['JSON']['output']>;
    fullName?: Maybe<Scalars['String']['output']>;
    phoneNumber?: Maybe<Scalars['String']['output']>;
    postalCode?: Maybe<Scalars['String']['output']>;
    province?: Maybe<Scalars['String']['output']>;
    streetLine1?: Maybe<Scalars['String']['output']>;
    streetLine2?: Maybe<Scalars['String']['output']>;
};

export type OrderFilterParameter = {
    _and?: InputMaybe<Array<OrderFilterParameter>>;
    _or?: InputMaybe<Array<OrderFilterParameter>>;
    active?: InputMaybe<BooleanOperators>;
    aggregateOrderId?: InputMaybe<IdOperators>;
    code?: InputMaybe<StringOperators>;
    createdAt?: InputMaybe<DateOperators>;
    currencyCode?: InputMaybe<StringOperators>;
    customerLastName?: InputMaybe<StringOperators>;
    id?: InputMaybe<IdOperators>;
    orderPlacedAt?: InputMaybe<DateOperators>;
    shipping?: InputMaybe<NumberOperators>;
    shippingWithTax?: InputMaybe<NumberOperators>;
    state?: InputMaybe<StringOperators>;
    subTotal?: InputMaybe<NumberOperators>;
    subTotalWithTax?: InputMaybe<NumberOperators>;
    total?: InputMaybe<NumberOperators>;
    totalQuantity?: InputMaybe<NumberOperators>;
    totalWithTax?: InputMaybe<NumberOperators>;
    transactionId?: InputMaybe<StringOperators>;
    type?: InputMaybe<StringOperators>;
    updatedAt?: InputMaybe<DateOperators>;
};

/** Returned when the maximum order size limit has been reached. */
export type OrderLimitError = ErrorResult & {
    errorCode: ErrorCode;
    maxItems: Scalars['Int']['output'];
    message: Scalars['String']['output'];
};

export type OrderLine = Node & {
    createdAt: Scalars['DateTime']['output'];
    customFields?: Maybe<Scalars['JSON']['output']>;
    /** The price of the line including discounts, excluding tax */
    discountedLinePrice: Scalars['Money']['output'];
    /** The price of the line including discounts and tax */
    discountedLinePriceWithTax: Scalars['Money']['output'];
    /**
     * The price of a single unit including discounts, excluding tax.
     *
     * If Order-level discounts have been applied, this will not be the
     * actual taxable unit price (see `proratedUnitPrice`), but is generally the
     * correct price to display to customers to avoid confusion
     * about the internal handling of distributed Order-level discounts.
     */
    discountedUnitPrice: Scalars['Money']['output'];
    /** The price of a single unit including discounts and tax */
    discountedUnitPriceWithTax: Scalars['Money']['output'];
    discounts: Array<Discount>;
    featuredAsset?: Maybe<Asset>;
    fulfillmentLines?: Maybe<Array<FulfillmentLine>>;
    id: Scalars['ID']['output'];
    /** The total price of the line excluding tax and discounts. */
    linePrice: Scalars['Money']['output'];
    /** The total price of the line including tax but excluding discounts. */
    linePriceWithTax: Scalars['Money']['output'];
    /** The total tax on this line */
    lineTax: Scalars['Money']['output'];
    order: Order;
    /** The quantity at the time the Order was placed */
    orderPlacedQuantity: Scalars['Int']['output'];
    productVariant: ProductVariant;
    /**
     * The actual line price, taking into account both item discounts _and_ prorated (proportionally-distributed)
     * Order-level discounts. This value is the true economic value of the OrderLine, and is used in tax
     * and refund calculations.
     */
    proratedLinePrice: Scalars['Money']['output'];
    /** The proratedLinePrice including tax */
    proratedLinePriceWithTax: Scalars['Money']['output'];
    /**
     * The actual unit price, taking into account both item discounts _and_ prorated (proportionally-distributed)
     * Order-level discounts. This value is the true economic value of the OrderItem, and is used in tax
     * and refund calculations.
     */
    proratedUnitPrice: Scalars['Money']['output'];
    /** The proratedUnitPrice including tax */
    proratedUnitPriceWithTax: Scalars['Money']['output'];
    /** The quantity of items purchased */
    quantity: Scalars['Int']['output'];
    taxLines: Array<TaxLine>;
    taxRate: Scalars['Float']['output'];
    /** The price of a single unit, excluding tax and discounts */
    unitPrice: Scalars['Money']['output'];
    /** Non-zero if the unitPrice has changed since it was initially added to Order */
    unitPriceChangeSinceAdded: Scalars['Money']['output'];
    /** The price of a single unit, including tax but excluding discounts */
    unitPriceWithTax: Scalars['Money']['output'];
    /** Non-zero if the unitPriceWithTax has changed since it was initially added to Order */
    unitPriceWithTaxChangeSinceAdded: Scalars['Money']['output'];
    updatedAt: Scalars['DateTime']['output'];
};

export type OrderLineInput = {
    orderLineId: Scalars['ID']['input'];
    quantity: Scalars['Int']['input'];
};

export type OrderList = PaginatedList & {
    items: Array<Order>;
    totalItems: Scalars['Int']['output'];
};

export type OrderListOptions = {
    /** Allows the results to be filtered */
    filter?: InputMaybe<OrderFilterParameter>;
    /** Specifies whether multiple top-level "filter" fields should be combined with a logical AND or OR operation. Defaults to AND. */
    filterOperator?: InputMaybe<LogicalOperator>;
    /** Skips the first n results, for use in pagination */
    skip?: InputMaybe<Scalars['Int']['input']>;
    /** Specifies which properties to sort the results by */
    sort?: InputMaybe<OrderSortParameter>;
    /** Takes n results, for use in pagination */
    take?: InputMaybe<Scalars['Int']['input']>;
};

export type OrderModification = Node & {
    createdAt: Scalars['DateTime']['output'];
    id: Scalars['ID']['output'];
    isSettled: Scalars['Boolean']['output'];
    lines: Array<OrderModificationLine>;
    note: Scalars['String']['output'];
    payment?: Maybe<Payment>;
    priceChange: Scalars['Money']['output'];
    refund?: Maybe<Refund>;
    surcharges?: Maybe<Array<Surcharge>>;
    updatedAt: Scalars['DateTime']['output'];
};

/** Returned when attempting to modify the contents of an Order that is not in the `AddingItems` state. */
export type OrderModificationError = ErrorResult & {
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
};

export type OrderModificationLine = {
    modification: OrderModification;
    modificationId: Scalars['ID']['output'];
    orderLine: OrderLine;
    orderLineId: Scalars['ID']['output'];
    quantity: Scalars['Int']['output'];
};

/** Returned when attempting to modify the contents of an Order that is not in the `Modifying` state. */
export type OrderModificationStateError = ErrorResult & {
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
};

export type OrderProcessState = {
    name: Scalars['String']['output'];
    to: Array<Scalars['String']['output']>;
};

export type OrderSortParameter = {
    aggregateOrderId?: InputMaybe<SortOrder>;
    code?: InputMaybe<SortOrder>;
    createdAt?: InputMaybe<SortOrder>;
    customerLastName?: InputMaybe<SortOrder>;
    id?: InputMaybe<SortOrder>;
    orderPlacedAt?: InputMaybe<SortOrder>;
    shipping?: InputMaybe<SortOrder>;
    shippingWithTax?: InputMaybe<SortOrder>;
    state?: InputMaybe<SortOrder>;
    subTotal?: InputMaybe<SortOrder>;
    subTotalWithTax?: InputMaybe<SortOrder>;
    total?: InputMaybe<SortOrder>;
    totalQuantity?: InputMaybe<SortOrder>;
    totalWithTax?: InputMaybe<SortOrder>;
    transactionId?: InputMaybe<SortOrder>;
    updatedAt?: InputMaybe<SortOrder>;
};

/** Returned if there is an error in transitioning the Order state */
export type OrderStateTransitionError = ErrorResult & {
    errorCode: ErrorCode;
    fromState: Scalars['String']['output'];
    message: Scalars['String']['output'];
    toState: Scalars['String']['output'];
    transitionError: Scalars['String']['output'];
};

/**
 * A summary of the taxes being applied to this order, grouped
 * by taxRate.
 */
export type OrderTaxSummary = {
    /** A description of this tax */
    description: Scalars['String']['output'];
    /** The total net price of OrderLines to which this taxRate applies */
    taxBase: Scalars['Money']['output'];
    /** The taxRate as a percentage */
    taxRate: Scalars['Float']['output'];
    /** The total tax being applied to the Order at this taxRate */
    taxTotal: Scalars['Money']['output'];
};

export enum OrderType {
    Aggregate = 'Aggregate',
    Regular = 'Regular',
    Seller = 'Seller',
}

export type PaginatedList = {
    items: Array<Node>;
    totalItems: Scalars['Int']['output'];
};

export type Payment = Node & {
    amount: Scalars['Money']['output'];
    createdAt: Scalars['DateTime']['output'];
    errorMessage?: Maybe<Scalars['String']['output']>;
    id: Scalars['ID']['output'];
    metadata?: Maybe<Scalars['JSON']['output']>;
    method: Scalars['String']['output'];
    nextStates: Array<Scalars['String']['output']>;
    refunds: Array<Refund>;
    state: Scalars['String']['output'];
    transactionId?: Maybe<Scalars['String']['output']>;
    updatedAt: Scalars['DateTime']['output'];
};

export type PaymentMethod = Node & {
    checker?: Maybe<ConfigurableOperation>;
    code: Scalars['String']['output'];
    createdAt: Scalars['DateTime']['output'];
    customFields?: Maybe<Scalars['JSON']['output']>;
    description: Scalars['String']['output'];
    enabled: Scalars['Boolean']['output'];
    handler: ConfigurableOperation;
    id: Scalars['ID']['output'];
    name: Scalars['String']['output'];
    translations: Array<PaymentMethodTranslation>;
    updatedAt: Scalars['DateTime']['output'];
};

export type PaymentMethodFilterParameter = {
    _and?: InputMaybe<Array<PaymentMethodFilterParameter>>;
    _or?: InputMaybe<Array<PaymentMethodFilterParameter>>;
    code?: InputMaybe<StringOperators>;
    createdAt?: InputMaybe<DateOperators>;
    description?: InputMaybe<StringOperators>;
    enabled?: InputMaybe<BooleanOperators>;
    id?: InputMaybe<IdOperators>;
    name?: InputMaybe<StringOperators>;
    updatedAt?: InputMaybe<DateOperators>;
};

export type PaymentMethodList = PaginatedList & {
    items: Array<PaymentMethod>;
    totalItems: Scalars['Int']['output'];
};

export type PaymentMethodListOptions = {
    /** Allows the results to be filtered */
    filter?: InputMaybe<PaymentMethodFilterParameter>;
    /** Specifies whether multiple top-level "filter" fields should be combined with a logical AND or OR operation. Defaults to AND. */
    filterOperator?: InputMaybe<LogicalOperator>;
    /** Skips the first n results, for use in pagination */
    skip?: InputMaybe<Scalars['Int']['input']>;
    /** Specifies which properties to sort the results by */
    sort?: InputMaybe<PaymentMethodSortParameter>;
    /** Takes n results, for use in pagination */
    take?: InputMaybe<Scalars['Int']['input']>;
};

/**
 * Returned when a call to modifyOrder fails to include a paymentMethod even
 * though the price has increased as a result of the changes.
 */
export type PaymentMethodMissingError = ErrorResult & {
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
};

export type PaymentMethodQuote = {
    code: Scalars['String']['output'];
    customFields?: Maybe<Scalars['JSON']['output']>;
    description: Scalars['String']['output'];
    eligibilityMessage?: Maybe<Scalars['String']['output']>;
    id: Scalars['ID']['output'];
    isEligible: Scalars['Boolean']['output'];
    name: Scalars['String']['output'];
};

export type PaymentMethodSortParameter = {
    code?: InputMaybe<SortOrder>;
    createdAt?: InputMaybe<SortOrder>;
    description?: InputMaybe<SortOrder>;
    id?: InputMaybe<SortOrder>;
    name?: InputMaybe<SortOrder>;
    updatedAt?: InputMaybe<SortOrder>;
};

export type PaymentMethodTranslation = {
    createdAt: Scalars['DateTime']['output'];
    description: Scalars['String']['output'];
    id: Scalars['ID']['output'];
    languageCode: LanguageCode;
    name: Scalars['String']['output'];
    updatedAt: Scalars['DateTime']['output'];
};

export type PaymentMethodTranslationInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    description?: InputMaybe<Scalars['String']['input']>;
    id?: InputMaybe<Scalars['ID']['input']>;
    languageCode: LanguageCode;
    name?: InputMaybe<Scalars['String']['input']>;
};

/** Returned if an attempting to refund a Payment against OrderLines from a different Order */
export type PaymentOrderMismatchError = ErrorResult & {
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
};

/** Returned when there is an error in transitioning the Payment state */
export type PaymentStateTransitionError = ErrorResult & {
    errorCode: ErrorCode;
    fromState: Scalars['String']['output'];
    message: Scalars['String']['output'];
    toState: Scalars['String']['output'];
    transitionError: Scalars['String']['output'];
};

/**
 * @description
 * Permissions for administrators and customers. Used to control access to
 * GraphQL resolvers via the {@link Allow} decorator.
 *
 * ## Understanding Permission.Owner
 *
 * `Permission.Owner` is a special permission which is used in some Vendure resolvers to indicate that that resolver should only
 * be accessible to the "owner" of that resource.
 *
 * For example, the Shop API `activeCustomer` query resolver should only return the Customer object for the "owner" of that Customer, i.e.
 * based on the activeUserId of the current session. As a result, the resolver code looks like this:
 *
 * @example
 * ```TypeScript
 * \@Query()
 * \@Allow(Permission.Owner)
 * async activeCustomer(\@Ctx() ctx: RequestContext): Promise<Customer | undefined> {
 *   const userId = ctx.activeUserId;
 *   if (userId) {
 *     return this.customerService.findOneByUserId(ctx, userId);
 *   }
 * }
 * ```
 *
 * Here we can see that the "ownership" must be enforced by custom logic inside the resolver. Since "ownership" cannot be defined generally
 * nor statically encoded at build-time, any resolvers using `Permission.Owner` **must** include logic to enforce that only the owner
 * of the resource has access. If not, then it is the equivalent of using `Permission.Public`.
 *
 *
 * @docsCategory common
 */
export enum Permission {
    /** Authenticated means simply that the user is logged in */
    Authenticated = 'Authenticated',
    /** Grants permission to create Administrator */
    CreateAdministrator = 'CreateAdministrator',
    /** Grants permission to create Asset */
    CreateAsset = 'CreateAsset',
    /** Grants permission to create Products, Facets, Assets, Collections */
    CreateCatalog = 'CreateCatalog',
    /** Grants permission to create Channel */
    CreateChannel = 'CreateChannel',
    /** Grants permission to create Collection */
    CreateCollection = 'CreateCollection',
    /** Grants permission to create Country */
    CreateCountry = 'CreateCountry',
    /** Grants permission to create Customer */
    CreateCustomer = 'CreateCustomer',
    /** Grants permission to create CustomerGroup */
    CreateCustomerGroup = 'CreateCustomerGroup',
    /** Grants permission to create Facet */
    CreateFacet = 'CreateFacet',
    /** Grants permission to create Order */
    CreateOrder = 'CreateOrder',
    /** Grants permission to create PaymentMethod */
    CreatePaymentMethod = 'CreatePaymentMethod',
    /** Grants permission to create Product */
    CreateProduct = 'CreateProduct',
    /** Grants permission to create Promotion */
    CreatePromotion = 'CreatePromotion',
    /** Grants permission to create Seller */
    CreateSeller = 'CreateSeller',
    /** Grants permission to create PaymentMethods, ShippingMethods, TaxCategories, TaxRates, Zones, Countries, System & GlobalSettings */
    CreateSettings = 'CreateSettings',
    /** Grants permission to create ShippingMethod */
    CreateShippingMethod = 'CreateShippingMethod',
    /** Grants permission to create StockLocation */
    CreateStockLocation = 'CreateStockLocation',
    /** Grants permission to create System */
    CreateSystem = 'CreateSystem',
    /** Grants permission to create Tag */
    CreateTag = 'CreateTag',
    /** Grants permission to create TaxCategory */
    CreateTaxCategory = 'CreateTaxCategory',
    /** Grants permission to create TaxRate */
    CreateTaxRate = 'CreateTaxRate',
    /** Grants permission to create Zone */
    CreateZone = 'CreateZone',
    /** Grants permission to delete Administrator */
    DeleteAdministrator = 'DeleteAdministrator',
    /** Grants permission to delete Asset */
    DeleteAsset = 'DeleteAsset',
    /** Grants permission to delete Products, Facets, Assets, Collections */
    DeleteCatalog = 'DeleteCatalog',
    /** Grants permission to delete Channel */
    DeleteChannel = 'DeleteChannel',
    /** Grants permission to delete Collection */
    DeleteCollection = 'DeleteCollection',
    /** Grants permission to delete Country */
    DeleteCountry = 'DeleteCountry',
    /** Grants permission to delete Customer */
    DeleteCustomer = 'DeleteCustomer',
    /** Grants permission to delete CustomerGroup */
    DeleteCustomerGroup = 'DeleteCustomerGroup',
    /** Grants permission to delete Facet */
    DeleteFacet = 'DeleteFacet',
    /** Grants permission to delete Order */
    DeleteOrder = 'DeleteOrder',
    /** Grants permission to delete PaymentMethod */
    DeletePaymentMethod = 'DeletePaymentMethod',
    /** Grants permission to delete Product */
    DeleteProduct = 'DeleteProduct',
    /** Grants permission to delete Promotion */
    DeletePromotion = 'DeletePromotion',
    /** Grants permission to delete Seller */
    DeleteSeller = 'DeleteSeller',
    /** Grants permission to delete PaymentMethods, ShippingMethods, TaxCategories, TaxRates, Zones, Countries, System & GlobalSettings */
    DeleteSettings = 'DeleteSettings',
    /** Grants permission to delete ShippingMethod */
    DeleteShippingMethod = 'DeleteShippingMethod',
    /** Grants permission to delete StockLocation */
    DeleteStockLocation = 'DeleteStockLocation',
    /** Grants permission to delete System */
    DeleteSystem = 'DeleteSystem',
    /** Grants permission to delete Tag */
    DeleteTag = 'DeleteTag',
    /** Grants permission to delete TaxCategory */
    DeleteTaxCategory = 'DeleteTaxCategory',
    /** Grants permission to delete TaxRate */
    DeleteTaxRate = 'DeleteTaxRate',
    /** Grants permission to delete Zone */
    DeleteZone = 'DeleteZone',
    /** Owner means the user owns this entity, e.g. a Customer's own Order */
    Owner = 'Owner',
    /** Public means any unauthenticated user may perform the operation */
    Public = 'Public',
    /** Grants permission to read Administrator */
    ReadAdministrator = 'ReadAdministrator',
    /** Grants permission to read Asset */
    ReadAsset = 'ReadAsset',
    /** Grants permission to read Products, Facets, Assets, Collections */
    ReadCatalog = 'ReadCatalog',
    /** Grants permission to read Channel */
    ReadChannel = 'ReadChannel',
    /** Grants permission to read Collection */
    ReadCollection = 'ReadCollection',
    /** Grants permission to read Country */
    ReadCountry = 'ReadCountry',
    /** Grants permission to read Customer */
    ReadCustomer = 'ReadCustomer',
    /** Grants permission to read CustomerGroup */
    ReadCustomerGroup = 'ReadCustomerGroup',
    /** Grants permission to read Facet */
    ReadFacet = 'ReadFacet',
    /** Grants permission to read Order */
    ReadOrder = 'ReadOrder',
    /** Grants permission to read PaymentMethod */
    ReadPaymentMethod = 'ReadPaymentMethod',
    /** Grants permission to read Product */
    ReadProduct = 'ReadProduct',
    /** Grants permission to read Promotion */
    ReadPromotion = 'ReadPromotion',
    /** Grants permission to read Seller */
    ReadSeller = 'ReadSeller',
    /** Grants permission to read PaymentMethods, ShippingMethods, TaxCategories, TaxRates, Zones, Countries, System & GlobalSettings */
    ReadSettings = 'ReadSettings',
    /** Grants permission to read ShippingMethod */
    ReadShippingMethod = 'ReadShippingMethod',
    /** Grants permission to read StockLocation */
    ReadStockLocation = 'ReadStockLocation',
    /** Grants permission to read System */
    ReadSystem = 'ReadSystem',
    /** Grants permission to read Tag */
    ReadTag = 'ReadTag',
    /** Grants permission to read TaxCategory */
    ReadTaxCategory = 'ReadTaxCategory',
    /** Grants permission to read TaxRate */
    ReadTaxRate = 'ReadTaxRate',
    /** Grants permission to read Zone */
    ReadZone = 'ReadZone',
    /** SuperAdmin has unrestricted access to all operations */
    SuperAdmin = 'SuperAdmin',
    /** Grants permission to update Administrator */
    UpdateAdministrator = 'UpdateAdministrator',
    /** Grants permission to update Asset */
    UpdateAsset = 'UpdateAsset',
    /** Grants permission to update Products, Facets, Assets, Collections */
    UpdateCatalog = 'UpdateCatalog',
    /** Grants permission to update Channel */
    UpdateChannel = 'UpdateChannel',
    /** Grants permission to update Collection */
    UpdateCollection = 'UpdateCollection',
    /** Grants permission to update Country */
    UpdateCountry = 'UpdateCountry',
    /** Grants permission to update Customer */
    UpdateCustomer = 'UpdateCustomer',
    /** Grants permission to update CustomerGroup */
    UpdateCustomerGroup = 'UpdateCustomerGroup',
    /** Grants permission to update Facet */
    UpdateFacet = 'UpdateFacet',
    /** Grants permission to update GlobalSettings */
    UpdateGlobalSettings = 'UpdateGlobalSettings',
    /** Grants permission to update Order */
    UpdateOrder = 'UpdateOrder',
    /** Grants permission to update PaymentMethod */
    UpdatePaymentMethod = 'UpdatePaymentMethod',
    /** Grants permission to update Product */
    UpdateProduct = 'UpdateProduct',
    /** Grants permission to update Promotion */
    UpdatePromotion = 'UpdatePromotion',
    /** Grants permission to update Seller */
    UpdateSeller = 'UpdateSeller',
    /** Grants permission to update PaymentMethods, ShippingMethods, TaxCategories, TaxRates, Zones, Countries, System & GlobalSettings */
    UpdateSettings = 'UpdateSettings',
    /** Grants permission to update ShippingMethod */
    UpdateShippingMethod = 'UpdateShippingMethod',
    /** Grants permission to update StockLocation */
    UpdateStockLocation = 'UpdateStockLocation',
    /** Grants permission to update System */
    UpdateSystem = 'UpdateSystem',
    /** Grants permission to update Tag */
    UpdateTag = 'UpdateTag',
    /** Grants permission to update TaxCategory */
    UpdateTaxCategory = 'UpdateTaxCategory',
    /** Grants permission to update TaxRate */
    UpdateTaxRate = 'UpdateTaxRate',
    /** Grants permission to update Zone */
    UpdateZone = 'UpdateZone',
}

export type PermissionDefinition = {
    assignable: Scalars['Boolean']['output'];
    description: Scalars['String']['output'];
    name: Scalars['String']['output'];
};

export type PreviewCollectionVariantsInput = {
    filters: Array<ConfigurableOperationInput>;
    inheritFilters: Scalars['Boolean']['input'];
    parentId?: InputMaybe<Scalars['ID']['input']>;
};

/** The price range where the result has more than one price */
export type PriceRange = {
    max: Scalars['Money']['output'];
    min: Scalars['Money']['output'];
};

export type Product = Node & {
    assets: Array<Asset>;
    channels: Array<Channel>;
    collections: Array<Collection>;
    createdAt: Scalars['DateTime']['output'];
    customFields?: Maybe<Scalars['JSON']['output']>;
    description: Scalars['String']['output'];
    enabled: Scalars['Boolean']['output'];
    facetValues: Array<FacetValue>;
    featuredAsset?: Maybe<Asset>;
    id: Scalars['ID']['output'];
    languageCode: LanguageCode;
    name: Scalars['String']['output'];
    optionGroups: Array<ProductOptionGroup>;
    slug: Scalars['String']['output'];
    translations: Array<ProductTranslation>;
    updatedAt: Scalars['DateTime']['output'];
    /** Returns a paginated, sortable, filterable list of ProductVariants */
    variantList: ProductVariantList;
    /** Returns all ProductVariants */
    variants: Array<ProductVariant>;
};

export type ProductVariantListArgs = {
    options?: InputMaybe<ProductVariantListOptions>;
};

export type ProductFilterParameter = {
    _and?: InputMaybe<Array<ProductFilterParameter>>;
    _or?: InputMaybe<Array<ProductFilterParameter>>;
    createdAt?: InputMaybe<DateOperators>;
    description?: InputMaybe<StringOperators>;
    enabled?: InputMaybe<BooleanOperators>;
    facetValueId?: InputMaybe<IdOperators>;
    id?: InputMaybe<IdOperators>;
    languageCode?: InputMaybe<StringOperators>;
    name?: InputMaybe<StringOperators>;
    sku?: InputMaybe<StringOperators>;
    slug?: InputMaybe<StringOperators>;
    updatedAt?: InputMaybe<DateOperators>;
};

export type ProductList = PaginatedList & {
    items: Array<Product>;
    totalItems: Scalars['Int']['output'];
};

export type ProductListOptions = {
    /** Allows the results to be filtered */
    filter?: InputMaybe<ProductFilterParameter>;
    /** Specifies whether multiple top-level "filter" fields should be combined with a logical AND or OR operation. Defaults to AND. */
    filterOperator?: InputMaybe<LogicalOperator>;
    /** Skips the first n results, for use in pagination */
    skip?: InputMaybe<Scalars['Int']['input']>;
    /** Specifies which properties to sort the results by */
    sort?: InputMaybe<ProductSortParameter>;
    /** Takes n results, for use in pagination */
    take?: InputMaybe<Scalars['Int']['input']>;
};

export type ProductOption = Node & {
    code: Scalars['String']['output'];
    createdAt: Scalars['DateTime']['output'];
    customFields?: Maybe<Scalars['JSON']['output']>;
    group: ProductOptionGroup;
    groupId: Scalars['ID']['output'];
    id: Scalars['ID']['output'];
    languageCode: LanguageCode;
    name: Scalars['String']['output'];
    translations: Array<ProductOptionTranslation>;
    updatedAt: Scalars['DateTime']['output'];
};

export type ProductOptionGroup = Node & {
    code: Scalars['String']['output'];
    createdAt: Scalars['DateTime']['output'];
    customFields?: Maybe<Scalars['JSON']['output']>;
    id: Scalars['ID']['output'];
    languageCode: LanguageCode;
    name: Scalars['String']['output'];
    options: Array<ProductOption>;
    translations: Array<ProductOptionGroupTranslation>;
    updatedAt: Scalars['DateTime']['output'];
};

export type ProductOptionGroupTranslation = {
    createdAt: Scalars['DateTime']['output'];
    id: Scalars['ID']['output'];
    languageCode: LanguageCode;
    name: Scalars['String']['output'];
    updatedAt: Scalars['DateTime']['output'];
};

export type ProductOptionGroupTranslationInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    id?: InputMaybe<Scalars['ID']['input']>;
    languageCode: LanguageCode;
    name?: InputMaybe<Scalars['String']['input']>;
};

export type ProductOptionInUseError = ErrorResult & {
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
    optionGroupCode: Scalars['String']['output'];
    productVariantCount: Scalars['Int']['output'];
};

export type ProductOptionTranslation = {
    createdAt: Scalars['DateTime']['output'];
    id: Scalars['ID']['output'];
    languageCode: LanguageCode;
    name: Scalars['String']['output'];
    updatedAt: Scalars['DateTime']['output'];
};

export type ProductOptionTranslationInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    id?: InputMaybe<Scalars['ID']['input']>;
    languageCode: LanguageCode;
    name?: InputMaybe<Scalars['String']['input']>;
};

export type ProductSortParameter = {
    createdAt?: InputMaybe<SortOrder>;
    description?: InputMaybe<SortOrder>;
    id?: InputMaybe<SortOrder>;
    name?: InputMaybe<SortOrder>;
    slug?: InputMaybe<SortOrder>;
    updatedAt?: InputMaybe<SortOrder>;
};

export type ProductTranslation = {
    createdAt: Scalars['DateTime']['output'];
    description: Scalars['String']['output'];
    id: Scalars['ID']['output'];
    languageCode: LanguageCode;
    name: Scalars['String']['output'];
    slug: Scalars['String']['output'];
    updatedAt: Scalars['DateTime']['output'];
};

export type ProductTranslationInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    description?: InputMaybe<Scalars['String']['input']>;
    id?: InputMaybe<Scalars['ID']['input']>;
    languageCode: LanguageCode;
    name?: InputMaybe<Scalars['String']['input']>;
    slug?: InputMaybe<Scalars['String']['input']>;
};

export type ProductVariant = Node & {
    assets: Array<Asset>;
    channels: Array<Channel>;
    createdAt: Scalars['DateTime']['output'];
    currencyCode: CurrencyCode;
    customFields?: Maybe<Scalars['JSON']['output']>;
    enabled: Scalars['Boolean']['output'];
    facetValues: Array<FacetValue>;
    featuredAsset?: Maybe<Asset>;
    id: Scalars['ID']['output'];
    languageCode: LanguageCode;
    name: Scalars['String']['output'];
    options: Array<ProductOption>;
    outOfStockThreshold: Scalars['Int']['output'];
    price: Scalars['Money']['output'];
    priceWithTax: Scalars['Money']['output'];
    prices: Array<ProductVariantPrice>;
    product: Product;
    productId: Scalars['ID']['output'];
    sku: Scalars['String']['output'];
    /** @deprecated use stockLevels */
    stockAllocated: Scalars['Int']['output'];
    stockLevel: Scalars['String']['output'];
    stockLevels: Array<StockLevel>;
    stockMovements: StockMovementList;
    /** @deprecated use stockLevels */
    stockOnHand: Scalars['Int']['output'];
    taxCategory: TaxCategory;
    taxRateApplied: TaxRate;
    trackInventory: GlobalFlag;
    translations: Array<ProductVariantTranslation>;
    updatedAt: Scalars['DateTime']['output'];
    useGlobalOutOfStockThreshold: Scalars['Boolean']['output'];
};

export type ProductVariantStockMovementsArgs = {
    options?: InputMaybe<StockMovementListOptions>;
};

export type ProductVariantFilterParameter = {
    _and?: InputMaybe<Array<ProductVariantFilterParameter>>;
    _or?: InputMaybe<Array<ProductVariantFilterParameter>>;
    createdAt?: InputMaybe<DateOperators>;
    currencyCode?: InputMaybe<StringOperators>;
    enabled?: InputMaybe<BooleanOperators>;
    facetValueId?: InputMaybe<IdOperators>;
    id?: InputMaybe<IdOperators>;
    languageCode?: InputMaybe<StringOperators>;
    name?: InputMaybe<StringOperators>;
    outOfStockThreshold?: InputMaybe<NumberOperators>;
    price?: InputMaybe<NumberOperators>;
    priceWithTax?: InputMaybe<NumberOperators>;
    productId?: InputMaybe<IdOperators>;
    sku?: InputMaybe<StringOperators>;
    stockAllocated?: InputMaybe<NumberOperators>;
    stockLevel?: InputMaybe<StringOperators>;
    stockOnHand?: InputMaybe<NumberOperators>;
    trackInventory?: InputMaybe<StringOperators>;
    updatedAt?: InputMaybe<DateOperators>;
    useGlobalOutOfStockThreshold?: InputMaybe<BooleanOperators>;
};

export type ProductVariantList = PaginatedList & {
    items: Array<ProductVariant>;
    totalItems: Scalars['Int']['output'];
};

export type ProductVariantListOptions = {
    /** Allows the results to be filtered */
    filter?: InputMaybe<ProductVariantFilterParameter>;
    /** Specifies whether multiple top-level "filter" fields should be combined with a logical AND or OR operation. Defaults to AND. */
    filterOperator?: InputMaybe<LogicalOperator>;
    /** Skips the first n results, for use in pagination */
    skip?: InputMaybe<Scalars['Int']['input']>;
    /** Specifies which properties to sort the results by */
    sort?: InputMaybe<ProductVariantSortParameter>;
    /** Takes n results, for use in pagination */
    take?: InputMaybe<Scalars['Int']['input']>;
};

export type ProductVariantPrice = {
    currencyCode: CurrencyCode;
    customFields?: Maybe<Scalars['JSON']['output']>;
    price: Scalars['Money']['output'];
};

/**
 * Used to set up update the price of a ProductVariant in a particular Channel.
 * If the `delete` flag is `true`, the price will be deleted for the given Channel.
 */
export type ProductVariantPriceInput = {
    currencyCode: CurrencyCode;
    delete?: InputMaybe<Scalars['Boolean']['input']>;
    price: Scalars['Money']['input'];
};

export type ProductVariantSortParameter = {
    createdAt?: InputMaybe<SortOrder>;
    id?: InputMaybe<SortOrder>;
    name?: InputMaybe<SortOrder>;
    outOfStockThreshold?: InputMaybe<SortOrder>;
    price?: InputMaybe<SortOrder>;
    priceWithTax?: InputMaybe<SortOrder>;
    productId?: InputMaybe<SortOrder>;
    sku?: InputMaybe<SortOrder>;
    stockAllocated?: InputMaybe<SortOrder>;
    stockLevel?: InputMaybe<SortOrder>;
    stockOnHand?: InputMaybe<SortOrder>;
    updatedAt?: InputMaybe<SortOrder>;
};

export type ProductVariantTranslation = {
    createdAt: Scalars['DateTime']['output'];
    id: Scalars['ID']['output'];
    languageCode: LanguageCode;
    name: Scalars['String']['output'];
    updatedAt: Scalars['DateTime']['output'];
};

export type ProductVariantTranslationInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    id?: InputMaybe<Scalars['ID']['input']>;
    languageCode: LanguageCode;
    name?: InputMaybe<Scalars['String']['input']>;
};

export type Promotion = Node & {
    actions: Array<ConfigurableOperation>;
    conditions: Array<ConfigurableOperation>;
    couponCode?: Maybe<Scalars['String']['output']>;
    createdAt: Scalars['DateTime']['output'];
    customFields?: Maybe<Scalars['JSON']['output']>;
    description: Scalars['String']['output'];
    enabled: Scalars['Boolean']['output'];
    endsAt?: Maybe<Scalars['DateTime']['output']>;
    id: Scalars['ID']['output'];
    name: Scalars['String']['output'];
    perCustomerUsageLimit?: Maybe<Scalars['Int']['output']>;
    startsAt?: Maybe<Scalars['DateTime']['output']>;
    translations: Array<PromotionTranslation>;
    updatedAt: Scalars['DateTime']['output'];
    usageLimit?: Maybe<Scalars['Int']['output']>;
};

export type PromotionFilterParameter = {
    _and?: InputMaybe<Array<PromotionFilterParameter>>;
    _or?: InputMaybe<Array<PromotionFilterParameter>>;
    couponCode?: InputMaybe<StringOperators>;
    createdAt?: InputMaybe<DateOperators>;
    description?: InputMaybe<StringOperators>;
    enabled?: InputMaybe<BooleanOperators>;
    endsAt?: InputMaybe<DateOperators>;
    id?: InputMaybe<IdOperators>;
    name?: InputMaybe<StringOperators>;
    perCustomerUsageLimit?: InputMaybe<NumberOperators>;
    startsAt?: InputMaybe<DateOperators>;
    updatedAt?: InputMaybe<DateOperators>;
    usageLimit?: InputMaybe<NumberOperators>;
};

export type PromotionList = PaginatedList & {
    items: Array<Promotion>;
    totalItems: Scalars['Int']['output'];
};

export type PromotionListOptions = {
    /** Allows the results to be filtered */
    filter?: InputMaybe<PromotionFilterParameter>;
    /** Specifies whether multiple top-level "filter" fields should be combined with a logical AND or OR operation. Defaults to AND. */
    filterOperator?: InputMaybe<LogicalOperator>;
    /** Skips the first n results, for use in pagination */
    skip?: InputMaybe<Scalars['Int']['input']>;
    /** Specifies which properties to sort the results by */
    sort?: InputMaybe<PromotionSortParameter>;
    /** Takes n results, for use in pagination */
    take?: InputMaybe<Scalars['Int']['input']>;
};

export type PromotionSortParameter = {
    couponCode?: InputMaybe<SortOrder>;
    createdAt?: InputMaybe<SortOrder>;
    description?: InputMaybe<SortOrder>;
    endsAt?: InputMaybe<SortOrder>;
    id?: InputMaybe<SortOrder>;
    name?: InputMaybe<SortOrder>;
    perCustomerUsageLimit?: InputMaybe<SortOrder>;
    startsAt?: InputMaybe<SortOrder>;
    updatedAt?: InputMaybe<SortOrder>;
    usageLimit?: InputMaybe<SortOrder>;
};

export type PromotionTranslation = {
    createdAt: Scalars['DateTime']['output'];
    description: Scalars['String']['output'];
    id: Scalars['ID']['output'];
    languageCode: LanguageCode;
    name: Scalars['String']['output'];
    updatedAt: Scalars['DateTime']['output'];
};

export type PromotionTranslationInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    description?: InputMaybe<Scalars['String']['input']>;
    id?: InputMaybe<Scalars['ID']['input']>;
    languageCode: LanguageCode;
    name?: InputMaybe<Scalars['String']['input']>;
};

export type Province = Node &
    Region & {
        code: Scalars['String']['output'];
        createdAt: Scalars['DateTime']['output'];
        customFields?: Maybe<Scalars['JSON']['output']>;
        enabled: Scalars['Boolean']['output'];
        id: Scalars['ID']['output'];
        languageCode: LanguageCode;
        name: Scalars['String']['output'];
        parent?: Maybe<Region>;
        parentId?: Maybe<Scalars['ID']['output']>;
        translations: Array<RegionTranslation>;
        type: Scalars['String']['output'];
        updatedAt: Scalars['DateTime']['output'];
    };

export type ProvinceFilterParameter = {
    _and?: InputMaybe<Array<ProvinceFilterParameter>>;
    _or?: InputMaybe<Array<ProvinceFilterParameter>>;
    code?: InputMaybe<StringOperators>;
    createdAt?: InputMaybe<DateOperators>;
    enabled?: InputMaybe<BooleanOperators>;
    id?: InputMaybe<IdOperators>;
    languageCode?: InputMaybe<StringOperators>;
    name?: InputMaybe<StringOperators>;
    parentId?: InputMaybe<IdOperators>;
    type?: InputMaybe<StringOperators>;
    updatedAt?: InputMaybe<DateOperators>;
};

export type ProvinceList = PaginatedList & {
    items: Array<Province>;
    totalItems: Scalars['Int']['output'];
};

export type ProvinceListOptions = {
    /** Allows the results to be filtered */
    filter?: InputMaybe<ProvinceFilterParameter>;
    /** Specifies whether multiple top-level "filter" fields should be combined with a logical AND or OR operation. Defaults to AND. */
    filterOperator?: InputMaybe<LogicalOperator>;
    /** Skips the first n results, for use in pagination */
    skip?: InputMaybe<Scalars['Int']['input']>;
    /** Specifies which properties to sort the results by */
    sort?: InputMaybe<ProvinceSortParameter>;
    /** Takes n results, for use in pagination */
    take?: InputMaybe<Scalars['Int']['input']>;
};

export type ProvinceSortParameter = {
    code?: InputMaybe<SortOrder>;
    createdAt?: InputMaybe<SortOrder>;
    id?: InputMaybe<SortOrder>;
    name?: InputMaybe<SortOrder>;
    parentId?: InputMaybe<SortOrder>;
    type?: InputMaybe<SortOrder>;
    updatedAt?: InputMaybe<SortOrder>;
};

export type ProvinceTranslationInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    id?: InputMaybe<Scalars['ID']['input']>;
    languageCode: LanguageCode;
    name?: InputMaybe<Scalars['String']['input']>;
};

/** Returned if the specified quantity of an OrderLine is greater than the number of items in that line */
export type QuantityTooGreatError = ErrorResult & {
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
};

export type Query = {
    activeAdministrator?: Maybe<Administrator>;
    activeChannel: Channel;
    administrator?: Maybe<Administrator>;
    administrators: AdministratorList;
    /** Get a single Asset by id */
    asset?: Maybe<Asset>;
    /** Get a list of Assets */
    assets: AssetList;
    channel?: Maybe<Channel>;
    channels: ChannelList;
    /** Get a Collection either by id or slug. If neither id nor slug is specified, an error will result. */
    collection?: Maybe<Collection>;
    collectionFilters: Array<ConfigurableOperationDefinition>;
    collections: CollectionList;
    countries: CountryList;
    country?: Maybe<Country>;
    customer?: Maybe<Customer>;
    customerGroup?: Maybe<CustomerGroup>;
    customerGroups: CustomerGroupList;
    customers: CustomerList;
    /** Returns a list of eligible shipping methods for the draft Order */
    eligibleShippingMethodsForDraftOrder: Array<ShippingMethodQuote>;
    /** Returns all configured EntityDuplicators. */
    entityDuplicators: Array<EntityDuplicatorDefinition>;
    facet?: Maybe<Facet>;
    facetValues: FacetValueList;
    facets: FacetList;
    fulfillmentHandlers: Array<ConfigurableOperationDefinition>;
    globalSettings: GlobalSettings;
    job?: Maybe<Job>;
    jobBufferSize: Array<JobBufferSize>;
    jobQueues: Array<JobQueue>;
    jobs: JobList;
    jobsById: Array<Job>;
    me?: Maybe<CurrentUser>;
    /** Get metrics for the given interval and metric types. */
    metricSummary: Array<MetricSummary>;
    order?: Maybe<Order>;
    orders: OrderList;
    paymentMethod?: Maybe<PaymentMethod>;
    paymentMethodEligibilityCheckers: Array<ConfigurableOperationDefinition>;
    paymentMethodHandlers: Array<ConfigurableOperationDefinition>;
    paymentMethods: PaymentMethodList;
    pendingSearchIndexUpdates: Scalars['Int']['output'];
    /** Used for real-time previews of the contents of a Collection */
    previewCollectionVariants: ProductVariantList;
    /** Get a Product either by id or slug. If neither id nor slug is specified, an error will result. */
    product?: Maybe<Product>;
    productOptionGroup?: Maybe<ProductOptionGroup>;
    productOptionGroups: Array<ProductOptionGroup>;
    /** Get a ProductVariant by id */
    productVariant?: Maybe<ProductVariant>;
    /** List ProductVariants either all or for the specific product. */
    productVariants: ProductVariantList;
    /** List Products */
    products: ProductList;
    promotion?: Maybe<Promotion>;
    promotionActions: Array<ConfigurableOperationDefinition>;
    promotionConditions: Array<ConfigurableOperationDefinition>;
    promotions: PromotionList;
    province?: Maybe<Province>;
    provinces: ProvinceList;
    role?: Maybe<Role>;
    roles: RoleList;
    search: SearchResponse;
    seller?: Maybe<Seller>;
    sellers: SellerList;
    shippingCalculators: Array<ConfigurableOperationDefinition>;
    shippingEligibilityCheckers: Array<ConfigurableOperationDefinition>;
    shippingMethod?: Maybe<ShippingMethod>;
    shippingMethods: ShippingMethodList;
    stockLocation?: Maybe<StockLocation>;
    stockLocations: StockLocationList;
    tag: Tag;
    tags: TagList;
    taxCategories: TaxCategoryList;
    taxCategory?: Maybe<TaxCategory>;
    taxRate?: Maybe<TaxRate>;
    taxRates: TaxRateList;
    testEligibleShippingMethods: Array<ShippingMethodQuote>;
    testShippingMethod: TestShippingMethodResult;
    zone?: Maybe<Zone>;
    zones: ZoneList;
};

export type QueryAdministratorArgs = {
    id: Scalars['ID']['input'];
};

export type QueryAdministratorsArgs = {
    options?: InputMaybe<AdministratorListOptions>;
};

export type QueryAssetArgs = {
    id: Scalars['ID']['input'];
};

export type QueryAssetsArgs = {
    options?: InputMaybe<AssetListOptions>;
};

export type QueryChannelArgs = {
    id: Scalars['ID']['input'];
};

export type QueryChannelsArgs = {
    options?: InputMaybe<ChannelListOptions>;
};

export type QueryCollectionArgs = {
    id?: InputMaybe<Scalars['ID']['input']>;
    slug?: InputMaybe<Scalars['String']['input']>;
};

export type QueryCollectionsArgs = {
    options?: InputMaybe<CollectionListOptions>;
};

export type QueryCountriesArgs = {
    options?: InputMaybe<CountryListOptions>;
};

export type QueryCountryArgs = {
    id: Scalars['ID']['input'];
};

export type QueryCustomerArgs = {
    id: Scalars['ID']['input'];
};

export type QueryCustomerGroupArgs = {
    id: Scalars['ID']['input'];
};

export type QueryCustomerGroupsArgs = {
    options?: InputMaybe<CustomerGroupListOptions>;
};

export type QueryCustomersArgs = {
    options?: InputMaybe<CustomerListOptions>;
};

export type QueryEligibleShippingMethodsForDraftOrderArgs = {
    orderId: Scalars['ID']['input'];
};

export type QueryFacetArgs = {
    id: Scalars['ID']['input'];
};

export type QueryFacetValuesArgs = {
    options?: InputMaybe<FacetValueListOptions>;
};

export type QueryFacetsArgs = {
    options?: InputMaybe<FacetListOptions>;
};

export type QueryJobArgs = {
    jobId: Scalars['ID']['input'];
};

export type QueryJobBufferSizeArgs = {
    bufferIds?: InputMaybe<Array<Scalars['String']['input']>>;
};

export type QueryJobsArgs = {
    options?: InputMaybe<JobListOptions>;
};

export type QueryJobsByIdArgs = {
    jobIds: Array<Scalars['ID']['input']>;
};

export type QueryMetricSummaryArgs = {
    input?: InputMaybe<MetricSummaryInput>;
};

export type QueryOrderArgs = {
    id: Scalars['ID']['input'];
};

export type QueryOrdersArgs = {
    options?: InputMaybe<OrderListOptions>;
};

export type QueryPaymentMethodArgs = {
    id: Scalars['ID']['input'];
};

export type QueryPaymentMethodsArgs = {
    options?: InputMaybe<PaymentMethodListOptions>;
};

export type QueryPreviewCollectionVariantsArgs = {
    input: PreviewCollectionVariantsInput;
    options?: InputMaybe<ProductVariantListOptions>;
};

export type QueryProductArgs = {
    id?: InputMaybe<Scalars['ID']['input']>;
    slug?: InputMaybe<Scalars['String']['input']>;
};

export type QueryProductOptionGroupArgs = {
    id: Scalars['ID']['input'];
};

export type QueryProductOptionGroupsArgs = {
    filterTerm?: InputMaybe<Scalars['String']['input']>;
};

export type QueryProductVariantArgs = {
    id: Scalars['ID']['input'];
};

export type QueryProductVariantsArgs = {
    options?: InputMaybe<ProductVariantListOptions>;
    productId?: InputMaybe<Scalars['ID']['input']>;
};

export type QueryProductsArgs = {
    options?: InputMaybe<ProductListOptions>;
};

export type QueryPromotionArgs = {
    id: Scalars['ID']['input'];
};

export type QueryPromotionsArgs = {
    options?: InputMaybe<PromotionListOptions>;
};

export type QueryProvinceArgs = {
    id: Scalars['ID']['input'];
};

export type QueryProvincesArgs = {
    options?: InputMaybe<ProvinceListOptions>;
};

export type QueryRoleArgs = {
    id: Scalars['ID']['input'];
};

export type QueryRolesArgs = {
    options?: InputMaybe<RoleListOptions>;
};

export type QuerySearchArgs = {
    input: SearchInput;
};

export type QuerySellerArgs = {
    id: Scalars['ID']['input'];
};

export type QuerySellersArgs = {
    options?: InputMaybe<SellerListOptions>;
};

export type QueryShippingMethodArgs = {
    id: Scalars['ID']['input'];
};

export type QueryShippingMethodsArgs = {
    options?: InputMaybe<ShippingMethodListOptions>;
};

export type QueryStockLocationArgs = {
    id: Scalars['ID']['input'];
};

export type QueryStockLocationsArgs = {
    options?: InputMaybe<StockLocationListOptions>;
};

export type QueryTagArgs = {
    id: Scalars['ID']['input'];
};

export type QueryTagsArgs = {
    options?: InputMaybe<TagListOptions>;
};

export type QueryTaxCategoriesArgs = {
    options?: InputMaybe<TaxCategoryListOptions>;
};

export type QueryTaxCategoryArgs = {
    id: Scalars['ID']['input'];
};

export type QueryTaxRateArgs = {
    id: Scalars['ID']['input'];
};

export type QueryTaxRatesArgs = {
    options?: InputMaybe<TaxRateListOptions>;
};

export type QueryTestEligibleShippingMethodsArgs = {
    input: TestEligibleShippingMethodsInput;
};

export type QueryTestShippingMethodArgs = {
    input: TestShippingMethodInput;
};

export type QueryZoneArgs = {
    id: Scalars['ID']['input'];
};

export type QueryZonesArgs = {
    options?: InputMaybe<ZoneListOptions>;
};

export type Refund = Node & {
    adjustment: Scalars['Money']['output'];
    createdAt: Scalars['DateTime']['output'];
    id: Scalars['ID']['output'];
    items: Scalars['Money']['output'];
    lines: Array<RefundLine>;
    metadata?: Maybe<Scalars['JSON']['output']>;
    method?: Maybe<Scalars['String']['output']>;
    paymentId: Scalars['ID']['output'];
    reason?: Maybe<Scalars['String']['output']>;
    shipping: Scalars['Money']['output'];
    state: Scalars['String']['output'];
    total: Scalars['Money']['output'];
    transactionId?: Maybe<Scalars['String']['output']>;
    updatedAt: Scalars['DateTime']['output'];
};

/** Returned if `amount` is greater than the maximum un-refunded amount of the Payment */
export type RefundAmountError = ErrorResult & {
    errorCode: ErrorCode;
    maximumRefundable: Scalars['Int']['output'];
    message: Scalars['String']['output'];
};

export type RefundLine = {
    orderLine: OrderLine;
    orderLineId: Scalars['ID']['output'];
    quantity: Scalars['Int']['output'];
    refund: Refund;
    refundId: Scalars['ID']['output'];
};

export type RefundOrderInput = {
    adjustment: Scalars['Money']['input'];
    /**
     * If an amount is specified, this value will be used to create a Refund rather than calculating the
     * amount automatically. This was added in v2.2 and will be the preferred way to specify the refund
     * amount in the future. The `lines`, `shipping` and `adjustment` fields will likely be removed in a future
     * version.
     */
    amount?: InputMaybe<Scalars['Money']['input']>;
    lines: Array<OrderLineInput>;
    paymentId: Scalars['ID']['input'];
    reason?: InputMaybe<Scalars['String']['input']>;
    shipping: Scalars['Money']['input'];
};

export type RefundOrderResult =
    | AlreadyRefundedError
    | MultipleOrderError
    | NothingToRefundError
    | OrderStateTransitionError
    | PaymentOrderMismatchError
    | QuantityTooGreatError
    | Refund
    | RefundAmountError
    | RefundOrderStateError
    | RefundStateTransitionError;

/** Returned if an attempting to refund an Order which is not in the expected state */
export type RefundOrderStateError = ErrorResult & {
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
    orderState: Scalars['String']['output'];
};

/**
 * Returned when a call to modifyOrder fails to include a refundPaymentId even
 * though the price has decreased as a result of the changes.
 */
export type RefundPaymentIdMissingError = ErrorResult & {
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
};

/** Returned when there is an error in transitioning the Refund state */
export type RefundStateTransitionError = ErrorResult & {
    errorCode: ErrorCode;
    fromState: Scalars['String']['output'];
    message: Scalars['String']['output'];
    toState: Scalars['String']['output'];
    transitionError: Scalars['String']['output'];
};

export type Region = {
    code: Scalars['String']['output'];
    createdAt: Scalars['DateTime']['output'];
    enabled: Scalars['Boolean']['output'];
    id: Scalars['ID']['output'];
    languageCode: LanguageCode;
    name: Scalars['String']['output'];
    parent?: Maybe<Region>;
    parentId?: Maybe<Scalars['ID']['output']>;
    translations: Array<RegionTranslation>;
    type: Scalars['String']['output'];
    updatedAt: Scalars['DateTime']['output'];
};

export type RegionTranslation = {
    createdAt: Scalars['DateTime']['output'];
    id: Scalars['ID']['output'];
    languageCode: LanguageCode;
    name: Scalars['String']['output'];
    updatedAt: Scalars['DateTime']['output'];
};

export type RelationCustomFieldConfig = CustomField & {
    description?: Maybe<Array<LocalizedString>>;
    entity: Scalars['String']['output'];
    internal?: Maybe<Scalars['Boolean']['output']>;
    label?: Maybe<Array<LocalizedString>>;
    list: Scalars['Boolean']['output'];
    name: Scalars['String']['output'];
    nullable?: Maybe<Scalars['Boolean']['output']>;
    readonly?: Maybe<Scalars['Boolean']['output']>;
    requiresPermission?: Maybe<Array<Permission>>;
    scalarFields: Array<Scalars['String']['output']>;
    type: Scalars['String']['output'];
    ui?: Maybe<Scalars['JSON']['output']>;
};

export type Release = Node &
    StockMovement & {
        createdAt: Scalars['DateTime']['output'];
        id: Scalars['ID']['output'];
        productVariant: ProductVariant;
        quantity: Scalars['Int']['output'];
        type: StockMovementType;
        updatedAt: Scalars['DateTime']['output'];
    };

export type RemoveCollectionsFromChannelInput = {
    channelId: Scalars['ID']['input'];
    collectionIds: Array<Scalars['ID']['input']>;
};

export type RemoveFacetFromChannelResult = Facet | FacetInUseError;

export type RemoveFacetsFromChannelInput = {
    channelId: Scalars['ID']['input'];
    facetIds: Array<Scalars['ID']['input']>;
    force?: InputMaybe<Scalars['Boolean']['input']>;
};

export type RemoveOptionGroupFromProductResult = Product | ProductOptionInUseError;

export type RemoveOrderItemsResult = Order | OrderModificationError;

export type RemovePaymentMethodsFromChannelInput = {
    channelId: Scalars['ID']['input'];
    paymentMethodIds: Array<Scalars['ID']['input']>;
};

export type RemoveProductVariantsFromChannelInput = {
    channelId: Scalars['ID']['input'];
    productVariantIds: Array<Scalars['ID']['input']>;
};

export type RemoveProductsFromChannelInput = {
    channelId: Scalars['ID']['input'];
    productIds: Array<Scalars['ID']['input']>;
};

export type RemovePromotionsFromChannelInput = {
    channelId: Scalars['ID']['input'];
    promotionIds: Array<Scalars['ID']['input']>;
};

export type RemoveShippingMethodsFromChannelInput = {
    channelId: Scalars['ID']['input'];
    shippingMethodIds: Array<Scalars['ID']['input']>;
};

export type RemoveStockLocationsFromChannelInput = {
    channelId: Scalars['ID']['input'];
    stockLocationIds: Array<Scalars['ID']['input']>;
};

export type Return = Node &
    StockMovement & {
        createdAt: Scalars['DateTime']['output'];
        id: Scalars['ID']['output'];
        productVariant: ProductVariant;
        quantity: Scalars['Int']['output'];
        type: StockMovementType;
        updatedAt: Scalars['DateTime']['output'];
    };

export type Role = Node & {
    channels: Array<Channel>;
    code: Scalars['String']['output'];
    createdAt: Scalars['DateTime']['output'];
    description: Scalars['String']['output'];
    id: Scalars['ID']['output'];
    permissions: Array<Permission>;
    updatedAt: Scalars['DateTime']['output'];
};

export type RoleFilterParameter = {
    _and?: InputMaybe<Array<RoleFilterParameter>>;
    _or?: InputMaybe<Array<RoleFilterParameter>>;
    code?: InputMaybe<StringOperators>;
    createdAt?: InputMaybe<DateOperators>;
    description?: InputMaybe<StringOperators>;
    id?: InputMaybe<IdOperators>;
    updatedAt?: InputMaybe<DateOperators>;
};

export type RoleList = PaginatedList & {
    items: Array<Role>;
    totalItems: Scalars['Int']['output'];
};

export type RoleListOptions = {
    /** Allows the results to be filtered */
    filter?: InputMaybe<RoleFilterParameter>;
    /** Specifies whether multiple top-level "filter" fields should be combined with a logical AND or OR operation. Defaults to AND. */
    filterOperator?: InputMaybe<LogicalOperator>;
    /** Skips the first n results, for use in pagination */
    skip?: InputMaybe<Scalars['Int']['input']>;
    /** Specifies which properties to sort the results by */
    sort?: InputMaybe<RoleSortParameter>;
    /** Takes n results, for use in pagination */
    take?: InputMaybe<Scalars['Int']['input']>;
};

export type RoleSortParameter = {
    code?: InputMaybe<SortOrder>;
    createdAt?: InputMaybe<SortOrder>;
    description?: InputMaybe<SortOrder>;
    id?: InputMaybe<SortOrder>;
    updatedAt?: InputMaybe<SortOrder>;
};

export type Sale = Node &
    StockMovement & {
        createdAt: Scalars['DateTime']['output'];
        id: Scalars['ID']['output'];
        productVariant: ProductVariant;
        quantity: Scalars['Int']['output'];
        type: StockMovementType;
        updatedAt: Scalars['DateTime']['output'];
    };

export type SearchInput = {
    collectionId?: InputMaybe<Scalars['ID']['input']>;
    collectionSlug?: InputMaybe<Scalars['String']['input']>;
    facetValueFilters?: InputMaybe<Array<FacetValueFilterInput>>;
    /** @deprecated Use `facetValueFilters` instead */
    facetValueIds?: InputMaybe<Array<Scalars['ID']['input']>>;
    /** @deprecated Use `facetValueFilters` instead */
    facetValueOperator?: InputMaybe<LogicalOperator>;
    groupByProduct?: InputMaybe<Scalars['Boolean']['input']>;
    skip?: InputMaybe<Scalars['Int']['input']>;
    sort?: InputMaybe<SearchResultSortParameter>;
    take?: InputMaybe<Scalars['Int']['input']>;
    term?: InputMaybe<Scalars['String']['input']>;
};

export type SearchReindexResponse = {
    success: Scalars['Boolean']['output'];
};

export type SearchResponse = {
    collections: Array<CollectionResult>;
    facetValues: Array<FacetValueResult>;
    items: Array<SearchResult>;
    totalItems: Scalars['Int']['output'];
};

export type SearchResult = {
    /** An array of ids of the Channels in which this result appears */
    channelIds: Array<Scalars['ID']['output']>;
    /** An array of ids of the Collections in which this result appears */
    collectionIds: Array<Scalars['ID']['output']>;
    currencyCode: CurrencyCode;
    description: Scalars['String']['output'];
    enabled: Scalars['Boolean']['output'];
    facetIds: Array<Scalars['ID']['output']>;
    facetValueIds: Array<Scalars['ID']['output']>;
    price: SearchResultPrice;
    priceWithTax: SearchResultPrice;
    productAsset?: Maybe<SearchResultAsset>;
    productId: Scalars['ID']['output'];
    productName: Scalars['String']['output'];
    productVariantAsset?: Maybe<SearchResultAsset>;
    productVariantId: Scalars['ID']['output'];
    productVariantName: Scalars['String']['output'];
    /** A relevance score for the result. Differs between database implementations */
    score: Scalars['Float']['output'];
    sku: Scalars['String']['output'];
    slug: Scalars['String']['output'];
};

export type SearchResultAsset = {
    focalPoint?: Maybe<Coordinate>;
    id: Scalars['ID']['output'];
    preview: Scalars['String']['output'];
};

/** The price of a search result product, either as a range or as a single price */
export type SearchResultPrice = PriceRange | SinglePrice;

export type SearchResultSortParameter = {
    name?: InputMaybe<SortOrder>;
    price?: InputMaybe<SortOrder>;
};

export type Seller = Node & {
    createdAt: Scalars['DateTime']['output'];
    customFields?: Maybe<Scalars['JSON']['output']>;
    id: Scalars['ID']['output'];
    name: Scalars['String']['output'];
    updatedAt: Scalars['DateTime']['output'];
};

export type SellerFilterParameter = {
    _and?: InputMaybe<Array<SellerFilterParameter>>;
    _or?: InputMaybe<Array<SellerFilterParameter>>;
    createdAt?: InputMaybe<DateOperators>;
    id?: InputMaybe<IdOperators>;
    name?: InputMaybe<StringOperators>;
    updatedAt?: InputMaybe<DateOperators>;
};

export type SellerList = PaginatedList & {
    items: Array<Seller>;
    totalItems: Scalars['Int']['output'];
};

export type SellerListOptions = {
    /** Allows the results to be filtered */
    filter?: InputMaybe<SellerFilterParameter>;
    /** Specifies whether multiple top-level "filter" fields should be combined with a logical AND or OR operation. Defaults to AND. */
    filterOperator?: InputMaybe<LogicalOperator>;
    /** Skips the first n results, for use in pagination */
    skip?: InputMaybe<Scalars['Int']['input']>;
    /** Specifies which properties to sort the results by */
    sort?: InputMaybe<SellerSortParameter>;
    /** Takes n results, for use in pagination */
    take?: InputMaybe<Scalars['Int']['input']>;
};

export type SellerSortParameter = {
    createdAt?: InputMaybe<SortOrder>;
    id?: InputMaybe<SortOrder>;
    name?: InputMaybe<SortOrder>;
    updatedAt?: InputMaybe<SortOrder>;
};

export type ServerConfig = {
    /**
     * This field is deprecated in v2.2 in favor of the entityCustomFields field,
     * which allows custom fields to be defined on user-supplies entities.
     */
    customFieldConfig: CustomFields;
    entityCustomFields: Array<EntityCustomFields>;
    moneyStrategyPrecision: Scalars['Int']['output'];
    orderProcess: Array<OrderProcessState>;
    permissions: Array<PermissionDefinition>;
    permittedAssetTypes: Array<Scalars['String']['output']>;
};

export type SetCustomerForDraftOrderResult = EmailAddressConflictError | Order;

export type SetOrderCustomerInput = {
    customerId: Scalars['ID']['input'];
    note?: InputMaybe<Scalars['String']['input']>;
    orderId: Scalars['ID']['input'];
};

export type SetOrderShippingMethodResult =
    | IneligibleShippingMethodError
    | NoActiveOrderError
    | Order
    | OrderModificationError;

/** Returned if the Payment settlement fails */
export type SettlePaymentError = ErrorResult & {
    errorCode: ErrorCode;
    message: Scalars['String']['output'];
    paymentErrorMessage: Scalars['String']['output'];
};

export type SettlePaymentResult =
    | OrderStateTransitionError
    | Payment
    | PaymentStateTransitionError
    | SettlePaymentError;

export type SettleRefundInput = {
    id: Scalars['ID']['input'];
    transactionId: Scalars['String']['input'];
};

export type SettleRefundResult = Refund | RefundStateTransitionError;

export type ShippingLine = {
    discountedPrice: Scalars['Money']['output'];
    discountedPriceWithTax: Scalars['Money']['output'];
    discounts: Array<Discount>;
    id: Scalars['ID']['output'];
    price: Scalars['Money']['output'];
    priceWithTax: Scalars['Money']['output'];
    shippingMethod: ShippingMethod;
};

export type ShippingMethod = Node & {
    calculator: ConfigurableOperation;
    checker: ConfigurableOperation;
    code: Scalars['String']['output'];
    createdAt: Scalars['DateTime']['output'];
    customFields?: Maybe<Scalars['JSON']['output']>;
    description: Scalars['String']['output'];
    fulfillmentHandlerCode: Scalars['String']['output'];
    id: Scalars['ID']['output'];
    languageCode: LanguageCode;
    name: Scalars['String']['output'];
    translations: Array<ShippingMethodTranslation>;
    updatedAt: Scalars['DateTime']['output'];
};

export type ShippingMethodFilterParameter = {
    _and?: InputMaybe<Array<ShippingMethodFilterParameter>>;
    _or?: InputMaybe<Array<ShippingMethodFilterParameter>>;
    code?: InputMaybe<StringOperators>;
    createdAt?: InputMaybe<DateOperators>;
    description?: InputMaybe<StringOperators>;
    fulfillmentHandlerCode?: InputMaybe<StringOperators>;
    id?: InputMaybe<IdOperators>;
    languageCode?: InputMaybe<StringOperators>;
    name?: InputMaybe<StringOperators>;
    updatedAt?: InputMaybe<DateOperators>;
};

export type ShippingMethodList = PaginatedList & {
    items: Array<ShippingMethod>;
    totalItems: Scalars['Int']['output'];
};

export type ShippingMethodListOptions = {
    /** Allows the results to be filtered */
    filter?: InputMaybe<ShippingMethodFilterParameter>;
    /** Specifies whether multiple top-level "filter" fields should be combined with a logical AND or OR operation. Defaults to AND. */
    filterOperator?: InputMaybe<LogicalOperator>;
    /** Skips the first n results, for use in pagination */
    skip?: InputMaybe<Scalars['Int']['input']>;
    /** Specifies which properties to sort the results by */
    sort?: InputMaybe<ShippingMethodSortParameter>;
    /** Takes n results, for use in pagination */
    take?: InputMaybe<Scalars['Int']['input']>;
};

export type ShippingMethodQuote = {
    code: Scalars['String']['output'];
    customFields?: Maybe<Scalars['JSON']['output']>;
    description: Scalars['String']['output'];
    id: Scalars['ID']['output'];
    /** Any optional metadata returned by the ShippingCalculator in the ShippingCalculationResult */
    metadata?: Maybe<Scalars['JSON']['output']>;
    name: Scalars['String']['output'];
    price: Scalars['Money']['output'];
    priceWithTax: Scalars['Money']['output'];
};

export type ShippingMethodSortParameter = {
    code?: InputMaybe<SortOrder>;
    createdAt?: InputMaybe<SortOrder>;
    description?: InputMaybe<SortOrder>;
    fulfillmentHandlerCode?: InputMaybe<SortOrder>;
    id?: InputMaybe<SortOrder>;
    name?: InputMaybe<SortOrder>;
    updatedAt?: InputMaybe<SortOrder>;
};

export type ShippingMethodTranslation = {
    createdAt: Scalars['DateTime']['output'];
    description: Scalars['String']['output'];
    id: Scalars['ID']['output'];
    languageCode: LanguageCode;
    name: Scalars['String']['output'];
    updatedAt: Scalars['DateTime']['output'];
};

export type ShippingMethodTranslationInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    description?: InputMaybe<Scalars['String']['input']>;
    id?: InputMaybe<Scalars['ID']['input']>;
    languageCode: LanguageCode;
    name?: InputMaybe<Scalars['String']['input']>;
};

/** The price value where the result has a single price */
export type SinglePrice = {
    value: Scalars['Money']['output'];
};

export enum SortOrder {
    ASC = 'ASC',
    DESC = 'DESC',
}

export type StockAdjustment = Node &
    StockMovement & {
        createdAt: Scalars['DateTime']['output'];
        id: Scalars['ID']['output'];
        productVariant: ProductVariant;
        quantity: Scalars['Int']['output'];
        type: StockMovementType;
        updatedAt: Scalars['DateTime']['output'];
    };

export type StockLevel = Node & {
    createdAt: Scalars['DateTime']['output'];
    id: Scalars['ID']['output'];
    stockAllocated: Scalars['Int']['output'];
    stockLocation: StockLocation;
    stockLocationId: Scalars['ID']['output'];
    stockOnHand: Scalars['Int']['output'];
    updatedAt: Scalars['DateTime']['output'];
};

export type StockLevelInput = {
    stockLocationId: Scalars['ID']['input'];
    stockOnHand: Scalars['Int']['input'];
};

export type StockLocation = Node & {
    createdAt: Scalars['DateTime']['output'];
    customFields?: Maybe<Scalars['JSON']['output']>;
    description: Scalars['String']['output'];
    id: Scalars['ID']['output'];
    name: Scalars['String']['output'];
    updatedAt: Scalars['DateTime']['output'];
};

export type StockLocationFilterParameter = {
    _and?: InputMaybe<Array<StockLocationFilterParameter>>;
    _or?: InputMaybe<Array<StockLocationFilterParameter>>;
    createdAt?: InputMaybe<DateOperators>;
    description?: InputMaybe<StringOperators>;
    id?: InputMaybe<IdOperators>;
    name?: InputMaybe<StringOperators>;
    updatedAt?: InputMaybe<DateOperators>;
};

export type StockLocationList = PaginatedList & {
    items: Array<StockLocation>;
    totalItems: Scalars['Int']['output'];
};

export type StockLocationListOptions = {
    /** Allows the results to be filtered */
    filter?: InputMaybe<StockLocationFilterParameter>;
    /** Specifies whether multiple top-level "filter" fields should be combined with a logical AND or OR operation. Defaults to AND. */
    filterOperator?: InputMaybe<LogicalOperator>;
    /** Skips the first n results, for use in pagination */
    skip?: InputMaybe<Scalars['Int']['input']>;
    /** Specifies which properties to sort the results by */
    sort?: InputMaybe<StockLocationSortParameter>;
    /** Takes n results, for use in pagination */
    take?: InputMaybe<Scalars['Int']['input']>;
};

export type StockLocationSortParameter = {
    createdAt?: InputMaybe<SortOrder>;
    description?: InputMaybe<SortOrder>;
    id?: InputMaybe<SortOrder>;
    name?: InputMaybe<SortOrder>;
    updatedAt?: InputMaybe<SortOrder>;
};

export type StockMovement = {
    createdAt: Scalars['DateTime']['output'];
    id: Scalars['ID']['output'];
    productVariant: ProductVariant;
    quantity: Scalars['Int']['output'];
    type: StockMovementType;
    updatedAt: Scalars['DateTime']['output'];
};

export type StockMovementItem = Allocation | Cancellation | Release | Return | Sale | StockAdjustment;

export type StockMovementList = {
    items: Array<StockMovementItem>;
    totalItems: Scalars['Int']['output'];
};

export type StockMovementListOptions = {
    skip?: InputMaybe<Scalars['Int']['input']>;
    take?: InputMaybe<Scalars['Int']['input']>;
    type?: InputMaybe<StockMovementType>;
};

export enum StockMovementType {
    ADJUSTMENT = 'ADJUSTMENT',
    ALLOCATION = 'ALLOCATION',
    CANCELLATION = 'CANCELLATION',
    RELEASE = 'RELEASE',
    RETURN = 'RETURN',
    SALE = 'SALE',
}

export type StringCustomFieldConfig = CustomField & {
    description?: Maybe<Array<LocalizedString>>;
    internal?: Maybe<Scalars['Boolean']['output']>;
    label?: Maybe<Array<LocalizedString>>;
    length?: Maybe<Scalars['Int']['output']>;
    list: Scalars['Boolean']['output'];
    name: Scalars['String']['output'];
    nullable?: Maybe<Scalars['Boolean']['output']>;
    options?: Maybe<Array<StringFieldOption>>;
    pattern?: Maybe<Scalars['String']['output']>;
    readonly?: Maybe<Scalars['Boolean']['output']>;
    requiresPermission?: Maybe<Array<Permission>>;
    type: Scalars['String']['output'];
    ui?: Maybe<Scalars['JSON']['output']>;
};

export type StringFieldOption = {
    label?: Maybe<Array<LocalizedString>>;
    value: Scalars['String']['output'];
};

/** Operators for filtering on a list of String fields */
export type StringListOperators = {
    inList: Scalars['String']['input'];
};

/** Operators for filtering on a String field */
export type StringOperators = {
    contains?: InputMaybe<Scalars['String']['input']>;
    eq?: InputMaybe<Scalars['String']['input']>;
    in?: InputMaybe<Array<Scalars['String']['input']>>;
    isNull?: InputMaybe<Scalars['Boolean']['input']>;
    notContains?: InputMaybe<Scalars['String']['input']>;
    notEq?: InputMaybe<Scalars['String']['input']>;
    notIn?: InputMaybe<Array<Scalars['String']['input']>>;
    regex?: InputMaybe<Scalars['String']['input']>;
};

/** Indicates that an operation succeeded, where we do not want to return any more specific information. */
export type Success = {
    success: Scalars['Boolean']['output'];
};

export type Surcharge = Node & {
    createdAt: Scalars['DateTime']['output'];
    description: Scalars['String']['output'];
    id: Scalars['ID']['output'];
    price: Scalars['Money']['output'];
    priceWithTax: Scalars['Money']['output'];
    sku?: Maybe<Scalars['String']['output']>;
    taxLines: Array<TaxLine>;
    taxRate: Scalars['Float']['output'];
    updatedAt: Scalars['DateTime']['output'];
};

export type SurchargeInput = {
    description: Scalars['String']['input'];
    price: Scalars['Money']['input'];
    priceIncludesTax: Scalars['Boolean']['input'];
    sku?: InputMaybe<Scalars['String']['input']>;
    taxDescription?: InputMaybe<Scalars['String']['input']>;
    taxRate?: InputMaybe<Scalars['Float']['input']>;
};

export type Tag = Node & {
    createdAt: Scalars['DateTime']['output'];
    id: Scalars['ID']['output'];
    updatedAt: Scalars['DateTime']['output'];
    value: Scalars['String']['output'];
};

export type TagFilterParameter = {
    _and?: InputMaybe<Array<TagFilterParameter>>;
    _or?: InputMaybe<Array<TagFilterParameter>>;
    createdAt?: InputMaybe<DateOperators>;
    id?: InputMaybe<IdOperators>;
    updatedAt?: InputMaybe<DateOperators>;
    value?: InputMaybe<StringOperators>;
};

export type TagList = PaginatedList & {
    items: Array<Tag>;
    totalItems: Scalars['Int']['output'];
};

export type TagListOptions = {
    /** Allows the results to be filtered */
    filter?: InputMaybe<TagFilterParameter>;
    /** Specifies whether multiple top-level "filter" fields should be combined with a logical AND or OR operation. Defaults to AND. */
    filterOperator?: InputMaybe<LogicalOperator>;
    /** Skips the first n results, for use in pagination */
    skip?: InputMaybe<Scalars['Int']['input']>;
    /** Specifies which properties to sort the results by */
    sort?: InputMaybe<TagSortParameter>;
    /** Takes n results, for use in pagination */
    take?: InputMaybe<Scalars['Int']['input']>;
};

export type TagSortParameter = {
    createdAt?: InputMaybe<SortOrder>;
    id?: InputMaybe<SortOrder>;
    updatedAt?: InputMaybe<SortOrder>;
    value?: InputMaybe<SortOrder>;
};

export type TaxCategory = Node & {
    createdAt: Scalars['DateTime']['output'];
    customFields?: Maybe<Scalars['JSON']['output']>;
    id: Scalars['ID']['output'];
    isDefault: Scalars['Boolean']['output'];
    name: Scalars['String']['output'];
    updatedAt: Scalars['DateTime']['output'];
};

export type TaxCategoryFilterParameter = {
    _and?: InputMaybe<Array<TaxCategoryFilterParameter>>;
    _or?: InputMaybe<Array<TaxCategoryFilterParameter>>;
    createdAt?: InputMaybe<DateOperators>;
    id?: InputMaybe<IdOperators>;
    isDefault?: InputMaybe<BooleanOperators>;
    name?: InputMaybe<StringOperators>;
    updatedAt?: InputMaybe<DateOperators>;
};

export type TaxCategoryList = PaginatedList & {
    items: Array<TaxCategory>;
    totalItems: Scalars['Int']['output'];
};

export type TaxCategoryListOptions = {
    /** Allows the results to be filtered */
    filter?: InputMaybe<TaxCategoryFilterParameter>;
    /** Specifies whether multiple top-level "filter" fields should be combined with a logical AND or OR operation. Defaults to AND. */
    filterOperator?: InputMaybe<LogicalOperator>;
    /** Skips the first n results, for use in pagination */
    skip?: InputMaybe<Scalars['Int']['input']>;
    /** Specifies which properties to sort the results by */
    sort?: InputMaybe<TaxCategorySortParameter>;
    /** Takes n results, for use in pagination */
    take?: InputMaybe<Scalars['Int']['input']>;
};

export type TaxCategorySortParameter = {
    createdAt?: InputMaybe<SortOrder>;
    id?: InputMaybe<SortOrder>;
    name?: InputMaybe<SortOrder>;
    updatedAt?: InputMaybe<SortOrder>;
};

export type TaxLine = {
    description: Scalars['String']['output'];
    taxRate: Scalars['Float']['output'];
};

export type TaxRate = Node & {
    category: TaxCategory;
    createdAt: Scalars['DateTime']['output'];
    customFields?: Maybe<Scalars['JSON']['output']>;
    customerGroup?: Maybe<CustomerGroup>;
    enabled: Scalars['Boolean']['output'];
    id: Scalars['ID']['output'];
    name: Scalars['String']['output'];
    updatedAt: Scalars['DateTime']['output'];
    value: Scalars['Float']['output'];
    zone: Zone;
};

export type TaxRateFilterParameter = {
    _and?: InputMaybe<Array<TaxRateFilterParameter>>;
    _or?: InputMaybe<Array<TaxRateFilterParameter>>;
    createdAt?: InputMaybe<DateOperators>;
    enabled?: InputMaybe<BooleanOperators>;
    id?: InputMaybe<IdOperators>;
    name?: InputMaybe<StringOperators>;
    updatedAt?: InputMaybe<DateOperators>;
    value?: InputMaybe<NumberOperators>;
};

export type TaxRateList = PaginatedList & {
    items: Array<TaxRate>;
    totalItems: Scalars['Int']['output'];
};

export type TaxRateListOptions = {
    /** Allows the results to be filtered */
    filter?: InputMaybe<TaxRateFilterParameter>;
    /** Specifies whether multiple top-level "filter" fields should be combined with a logical AND or OR operation. Defaults to AND. */
    filterOperator?: InputMaybe<LogicalOperator>;
    /** Skips the first n results, for use in pagination */
    skip?: InputMaybe<Scalars['Int']['input']>;
    /** Specifies which properties to sort the results by */
    sort?: InputMaybe<TaxRateSortParameter>;
    /** Takes n results, for use in pagination */
    take?: InputMaybe<Scalars['Int']['input']>;
};

export type TaxRateSortParameter = {
    createdAt?: InputMaybe<SortOrder>;
    id?: InputMaybe<SortOrder>;
    name?: InputMaybe<SortOrder>;
    updatedAt?: InputMaybe<SortOrder>;
    value?: InputMaybe<SortOrder>;
};

export type TestEligibleShippingMethodsInput = {
    lines: Array<TestShippingMethodOrderLineInput>;
    shippingAddress: CreateAddressInput;
};

export type TestShippingMethodInput = {
    calculator: ConfigurableOperationInput;
    checker: ConfigurableOperationInput;
    lines: Array<TestShippingMethodOrderLineInput>;
    shippingAddress: CreateAddressInput;
};

export type TestShippingMethodOrderLineInput = {
    productVariantId: Scalars['ID']['input'];
    quantity: Scalars['Int']['input'];
};

export type TestShippingMethodQuote = {
    metadata?: Maybe<Scalars['JSON']['output']>;
    price: Scalars['Money']['output'];
    priceWithTax: Scalars['Money']['output'];
};

export type TestShippingMethodResult = {
    eligible: Scalars['Boolean']['output'];
    quote?: Maybe<TestShippingMethodQuote>;
};

export type TextCustomFieldConfig = CustomField & {
    description?: Maybe<Array<LocalizedString>>;
    internal?: Maybe<Scalars['Boolean']['output']>;
    label?: Maybe<Array<LocalizedString>>;
    list: Scalars['Boolean']['output'];
    name: Scalars['String']['output'];
    nullable?: Maybe<Scalars['Boolean']['output']>;
    readonly?: Maybe<Scalars['Boolean']['output']>;
    requiresPermission?: Maybe<Array<Permission>>;
    type: Scalars['String']['output'];
    ui?: Maybe<Scalars['JSON']['output']>;
};

export type TransitionFulfillmentToStateResult = Fulfillment | FulfillmentStateTransitionError;

export type TransitionOrderToStateResult = Order | OrderStateTransitionError;

export type TransitionPaymentToStateResult = Payment | PaymentStateTransitionError;

export type UpdateActiveAdministratorInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    emailAddress?: InputMaybe<Scalars['String']['input']>;
    firstName?: InputMaybe<Scalars['String']['input']>;
    lastName?: InputMaybe<Scalars['String']['input']>;
    password?: InputMaybe<Scalars['String']['input']>;
};

/**
 * Input used to update an Address.
 *
 * The countryCode must correspond to a `code` property of a Country that has been defined in the
 * Vendure server. The `code` property is typically a 2-character ISO code such as "GB", "US", "DE" etc.
 * If an invalid code is passed, the mutation will fail.
 */
export type UpdateAddressInput = {
    city?: InputMaybe<Scalars['String']['input']>;
    company?: InputMaybe<Scalars['String']['input']>;
    countryCode?: InputMaybe<Scalars['String']['input']>;
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    defaultBillingAddress?: InputMaybe<Scalars['Boolean']['input']>;
    defaultShippingAddress?: InputMaybe<Scalars['Boolean']['input']>;
    fullName?: InputMaybe<Scalars['String']['input']>;
    id: Scalars['ID']['input'];
    phoneNumber?: InputMaybe<Scalars['String']['input']>;
    postalCode?: InputMaybe<Scalars['String']['input']>;
    province?: InputMaybe<Scalars['String']['input']>;
    streetLine1?: InputMaybe<Scalars['String']['input']>;
    streetLine2?: InputMaybe<Scalars['String']['input']>;
};

export type UpdateAdministratorInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    emailAddress?: InputMaybe<Scalars['String']['input']>;
    firstName?: InputMaybe<Scalars['String']['input']>;
    id: Scalars['ID']['input'];
    lastName?: InputMaybe<Scalars['String']['input']>;
    password?: InputMaybe<Scalars['String']['input']>;
    roleIds?: InputMaybe<Array<Scalars['ID']['input']>>;
};

export type UpdateAssetInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    focalPoint?: InputMaybe<CoordinateInput>;
    id: Scalars['ID']['input'];
    name?: InputMaybe<Scalars['String']['input']>;
    tags?: InputMaybe<Array<Scalars['String']['input']>>;
};

export type UpdateChannelInput = {
    availableCurrencyCodes?: InputMaybe<Array<CurrencyCode>>;
    availableLanguageCodes?: InputMaybe<Array<LanguageCode>>;
    code?: InputMaybe<Scalars['String']['input']>;
    /** @deprecated Use defaultCurrencyCode instead */
    currencyCode?: InputMaybe<CurrencyCode>;
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    defaultCurrencyCode?: InputMaybe<CurrencyCode>;
    defaultLanguageCode?: InputMaybe<LanguageCode>;
    defaultShippingZoneId?: InputMaybe<Scalars['ID']['input']>;
    defaultTaxZoneId?: InputMaybe<Scalars['ID']['input']>;
    id: Scalars['ID']['input'];
    outOfStockThreshold?: InputMaybe<Scalars['Int']['input']>;
    pricesIncludeTax?: InputMaybe<Scalars['Boolean']['input']>;
    sellerId?: InputMaybe<Scalars['ID']['input']>;
    token?: InputMaybe<Scalars['String']['input']>;
    trackInventory?: InputMaybe<Scalars['Boolean']['input']>;
};

export type UpdateChannelResult = Channel | LanguageNotAvailableError;

export type UpdateCollectionInput = {
    assetIds?: InputMaybe<Array<Scalars['ID']['input']>>;
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    featuredAssetId?: InputMaybe<Scalars['ID']['input']>;
    filters?: InputMaybe<Array<ConfigurableOperationInput>>;
    id: Scalars['ID']['input'];
    inheritFilters?: InputMaybe<Scalars['Boolean']['input']>;
    isPrivate?: InputMaybe<Scalars['Boolean']['input']>;
    parentId?: InputMaybe<Scalars['ID']['input']>;
    translations?: InputMaybe<Array<UpdateCollectionTranslationInput>>;
};

export type UpdateCollectionTranslationInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    description?: InputMaybe<Scalars['String']['input']>;
    id?: InputMaybe<Scalars['ID']['input']>;
    languageCode: LanguageCode;
    name?: InputMaybe<Scalars['String']['input']>;
    slug?: InputMaybe<Scalars['String']['input']>;
};

export type UpdateCountryInput = {
    code?: InputMaybe<Scalars['String']['input']>;
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    enabled?: InputMaybe<Scalars['Boolean']['input']>;
    id: Scalars['ID']['input'];
    translations?: InputMaybe<Array<CountryTranslationInput>>;
};

export type UpdateCustomerGroupInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    id: Scalars['ID']['input'];
    name?: InputMaybe<Scalars['String']['input']>;
};

export type UpdateCustomerInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    emailAddress?: InputMaybe<Scalars['String']['input']>;
    firstName?: InputMaybe<Scalars['String']['input']>;
    id: Scalars['ID']['input'];
    lastName?: InputMaybe<Scalars['String']['input']>;
    phoneNumber?: InputMaybe<Scalars['String']['input']>;
    title?: InputMaybe<Scalars['String']['input']>;
};

export type UpdateCustomerNoteInput = {
    note: Scalars['String']['input'];
    noteId: Scalars['ID']['input'];
};

export type UpdateCustomerResult = Customer | EmailAddressConflictError;

export type UpdateFacetInput = {
    code?: InputMaybe<Scalars['String']['input']>;
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    id: Scalars['ID']['input'];
    isPrivate?: InputMaybe<Scalars['Boolean']['input']>;
    translations?: InputMaybe<Array<FacetTranslationInput>>;
};

export type UpdateFacetValueInput = {
    code?: InputMaybe<Scalars['String']['input']>;
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    id: Scalars['ID']['input'];
    translations?: InputMaybe<Array<FacetValueTranslationInput>>;
};

export type UpdateGlobalSettingsInput = {
    availableLanguages?: InputMaybe<Array<LanguageCode>>;
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    outOfStockThreshold?: InputMaybe<Scalars['Int']['input']>;
    trackInventory?: InputMaybe<Scalars['Boolean']['input']>;
};

export type UpdateGlobalSettingsResult = ChannelDefaultLanguageError | GlobalSettings;

export type UpdateOrderAddressInput = {
    city?: InputMaybe<Scalars['String']['input']>;
    company?: InputMaybe<Scalars['String']['input']>;
    countryCode?: InputMaybe<Scalars['String']['input']>;
    fullName?: InputMaybe<Scalars['String']['input']>;
    phoneNumber?: InputMaybe<Scalars['String']['input']>;
    postalCode?: InputMaybe<Scalars['String']['input']>;
    province?: InputMaybe<Scalars['String']['input']>;
    streetLine1?: InputMaybe<Scalars['String']['input']>;
    streetLine2?: InputMaybe<Scalars['String']['input']>;
};

export type UpdateOrderInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    id: Scalars['ID']['input'];
};

export type UpdateOrderItemsResult =
    | InsufficientStockError
    | NegativeQuantityError
    | Order
    | OrderLimitError
    | OrderModificationError;

export type UpdateOrderNoteInput = {
    isPublic?: InputMaybe<Scalars['Boolean']['input']>;
    note?: InputMaybe<Scalars['String']['input']>;
    noteId: Scalars['ID']['input'];
};

export type UpdatePaymentMethodInput = {
    checker?: InputMaybe<ConfigurableOperationInput>;
    code?: InputMaybe<Scalars['String']['input']>;
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    enabled?: InputMaybe<Scalars['Boolean']['input']>;
    handler?: InputMaybe<ConfigurableOperationInput>;
    id: Scalars['ID']['input'];
    translations?: InputMaybe<Array<PaymentMethodTranslationInput>>;
};

export type UpdateProductInput = {
    assetIds?: InputMaybe<Array<Scalars['ID']['input']>>;
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    enabled?: InputMaybe<Scalars['Boolean']['input']>;
    facetValueIds?: InputMaybe<Array<Scalars['ID']['input']>>;
    featuredAssetId?: InputMaybe<Scalars['ID']['input']>;
    id: Scalars['ID']['input'];
    translations?: InputMaybe<Array<ProductTranslationInput>>;
};

export type UpdateProductOptionGroupInput = {
    code?: InputMaybe<Scalars['String']['input']>;
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    id: Scalars['ID']['input'];
    translations?: InputMaybe<Array<ProductOptionGroupTranslationInput>>;
};

export type UpdateProductOptionInput = {
    code?: InputMaybe<Scalars['String']['input']>;
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    id: Scalars['ID']['input'];
    translations?: InputMaybe<Array<ProductOptionGroupTranslationInput>>;
};

export type UpdateProductVariantInput = {
    assetIds?: InputMaybe<Array<Scalars['ID']['input']>>;
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    enabled?: InputMaybe<Scalars['Boolean']['input']>;
    facetValueIds?: InputMaybe<Array<Scalars['ID']['input']>>;
    featuredAssetId?: InputMaybe<Scalars['ID']['input']>;
    id: Scalars['ID']['input'];
    optionIds?: InputMaybe<Array<Scalars['ID']['input']>>;
    outOfStockThreshold?: InputMaybe<Scalars['Int']['input']>;
    /** Sets the price for the ProductVariant in the Channel's default currency */
    price?: InputMaybe<Scalars['Money']['input']>;
    /** Allows multiple prices to be set for the ProductVariant in different currencies. */
    prices?: InputMaybe<Array<ProductVariantPriceInput>>;
    sku?: InputMaybe<Scalars['String']['input']>;
    stockLevels?: InputMaybe<Array<StockLevelInput>>;
    stockOnHand?: InputMaybe<Scalars['Int']['input']>;
    taxCategoryId?: InputMaybe<Scalars['ID']['input']>;
    trackInventory?: InputMaybe<GlobalFlag>;
    translations?: InputMaybe<Array<ProductVariantTranslationInput>>;
    useGlobalOutOfStockThreshold?: InputMaybe<Scalars['Boolean']['input']>;
};

export type UpdatePromotionInput = {
    actions?: InputMaybe<Array<ConfigurableOperationInput>>;
    conditions?: InputMaybe<Array<ConfigurableOperationInput>>;
    couponCode?: InputMaybe<Scalars['String']['input']>;
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    enabled?: InputMaybe<Scalars['Boolean']['input']>;
    endsAt?: InputMaybe<Scalars['DateTime']['input']>;
    id: Scalars['ID']['input'];
    perCustomerUsageLimit?: InputMaybe<Scalars['Int']['input']>;
    startsAt?: InputMaybe<Scalars['DateTime']['input']>;
    translations?: InputMaybe<Array<PromotionTranslationInput>>;
    usageLimit?: InputMaybe<Scalars['Int']['input']>;
};

export type UpdatePromotionResult = MissingConditionsError | Promotion;

export type UpdateProvinceInput = {
    code?: InputMaybe<Scalars['String']['input']>;
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    enabled?: InputMaybe<Scalars['Boolean']['input']>;
    id: Scalars['ID']['input'];
    translations?: InputMaybe<Array<ProvinceTranslationInput>>;
};

export type UpdateRoleInput = {
    channelIds?: InputMaybe<Array<Scalars['ID']['input']>>;
    code?: InputMaybe<Scalars['String']['input']>;
    description?: InputMaybe<Scalars['String']['input']>;
    id: Scalars['ID']['input'];
    permissions?: InputMaybe<Array<Permission>>;
};

export type UpdateSellerInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    id: Scalars['ID']['input'];
    name?: InputMaybe<Scalars['String']['input']>;
};

export type UpdateShippingMethodInput = {
    calculator?: InputMaybe<ConfigurableOperationInput>;
    checker?: InputMaybe<ConfigurableOperationInput>;
    code?: InputMaybe<Scalars['String']['input']>;
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    fulfillmentHandler?: InputMaybe<Scalars['String']['input']>;
    id: Scalars['ID']['input'];
    translations: Array<ShippingMethodTranslationInput>;
};

export type UpdateStockLocationInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    description?: InputMaybe<Scalars['String']['input']>;
    id: Scalars['ID']['input'];
    name?: InputMaybe<Scalars['String']['input']>;
};

export type UpdateTagInput = {
    id: Scalars['ID']['input'];
    value?: InputMaybe<Scalars['String']['input']>;
};

export type UpdateTaxCategoryInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    id: Scalars['ID']['input'];
    isDefault?: InputMaybe<Scalars['Boolean']['input']>;
    name?: InputMaybe<Scalars['String']['input']>;
};

export type UpdateTaxRateInput = {
    categoryId?: InputMaybe<Scalars['ID']['input']>;
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    customerGroupId?: InputMaybe<Scalars['ID']['input']>;
    enabled?: InputMaybe<Scalars['Boolean']['input']>;
    id: Scalars['ID']['input'];
    name?: InputMaybe<Scalars['String']['input']>;
    value?: InputMaybe<Scalars['Float']['input']>;
    zoneId?: InputMaybe<Scalars['ID']['input']>;
};

export type UpdateZoneInput = {
    customFields?: InputMaybe<Scalars['JSON']['input']>;
    id: Scalars['ID']['input'];
    name?: InputMaybe<Scalars['String']['input']>;
};

export type User = Node & {
    authenticationMethods: Array<AuthenticationMethod>;
    createdAt: Scalars['DateTime']['output'];
    customFields?: Maybe<Scalars['JSON']['output']>;
    id: Scalars['ID']['output'];
    identifier: Scalars['String']['output'];
    lastLogin?: Maybe<Scalars['DateTime']['output']>;
    roles: Array<Role>;
    updatedAt: Scalars['DateTime']['output'];
    verified: Scalars['Boolean']['output'];
};

export type Zone = Node & {
    createdAt: Scalars['DateTime']['output'];
    customFields?: Maybe<Scalars['JSON']['output']>;
    id: Scalars['ID']['output'];
    members: Array<Region>;
    name: Scalars['String']['output'];
    updatedAt: Scalars['DateTime']['output'];
};

export type ZoneFilterParameter = {
    _and?: InputMaybe<Array<ZoneFilterParameter>>;
    _or?: InputMaybe<Array<ZoneFilterParameter>>;
    createdAt?: InputMaybe<DateOperators>;
    id?: InputMaybe<IdOperators>;
    name?: InputMaybe<StringOperators>;
    updatedAt?: InputMaybe<DateOperators>;
};

export type ZoneList = PaginatedList & {
    items: Array<Zone>;
    totalItems: Scalars['Int']['output'];
};

export type ZoneListOptions = {
    /** Allows the results to be filtered */
    filter?: InputMaybe<ZoneFilterParameter>;
    /** Specifies whether multiple top-level "filter" fields should be combined with a logical AND or OR operation. Defaults to AND. */
    filterOperator?: InputMaybe<LogicalOperator>;
    /** Skips the first n results, for use in pagination */
    skip?: InputMaybe<Scalars['Int']['input']>;
    /** Specifies which properties to sort the results by */
    sort?: InputMaybe<ZoneSortParameter>;
    /** Takes n results, for use in pagination */
    take?: InputMaybe<Scalars['Int']['input']>;
};

export type ZoneSortParameter = {
    createdAt?: InputMaybe<SortOrder>;
    id?: InputMaybe<SortOrder>;
    name?: InputMaybe<SortOrder>;
    updatedAt?: InputMaybe<SortOrder>;
};

export type GetAdministratorsQueryVariables = Exact<{
    options?: InputMaybe<AdministratorListOptions>;
}>;

export type GetAdministratorsQuery = {
    administrators: {
        totalItems: number;
        items: Array<{
            id: string;
            firstName: string;
            lastName: string;
            emailAddress: string;
            user: {
                id: string;
                identifier: string;
                lastLogin?: any | null;
                roles: Array<{
                    id: string;
                    code: string;
                    description: string;
                    permissions: Array<Permission>;
                }>;
            };
        }>;
    };
};

export type GetAdministratorQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetAdministratorQuery = {
    administrator?: {
        id: string;
        firstName: string;
        lastName: string;
        emailAddress: string;
        user: {
            id: string;
            identifier: string;
            lastLogin?: any | null;
            roles: Array<{ id: string; code: string; description: string; permissions: Array<Permission> }>;
        };
    } | null;
};

export type ActiveAdministratorQueryVariables = Exact<{ [key: string]: never }>;

export type ActiveAdministratorQuery = {
    activeAdministrator?: {
        id: string;
        firstName: string;
        lastName: string;
        emailAddress: string;
        user: {
            id: string;
            identifier: string;
            lastLogin?: any | null;
            roles: Array<{ id: string; code: string; description: string; permissions: Array<Permission> }>;
        };
    } | null;
};

export type UpdateActiveAdministratorMutationVariables = Exact<{
    input: UpdateActiveAdministratorInput;
}>;

export type UpdateActiveAdministratorMutation = {
    updateActiveAdministrator: {
        id: string;
        firstName: string;
        lastName: string;
        emailAddress: string;
        user: {
            id: string;
            identifier: string;
            lastLogin?: any | null;
            roles: Array<{ id: string; code: string; description: string; permissions: Array<Permission> }>;
        };
    };
};

export type DeleteAdministratorMutationVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type DeleteAdministratorMutation = {
    deleteAdministrator: { message?: string | null; result: DeletionResult };
};

export type Q1QueryVariables = Exact<{ [key: string]: never }>;

export type Q1Query = { product?: { id: string; name: string } | null };

export type Q2QueryVariables = Exact<{ [key: string]: never }>;

export type Q2Query = { product?: { id: string; name: string } | null };

export type GetCollectionWithAssetsQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetCollectionWithAssetsQuery = {
    collection?: {
        id: string;
        name: string;
        featuredAsset?: {
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        } | null;
        assets: Array<{
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        }>;
    } | null;
};

export type AssignAssetsToChannelMutationVariables = Exact<{
    input: AssignAssetsToChannelInput;
}>;

export type AssignAssetsToChannelMutation = {
    assignAssetsToChannel: Array<{
        id: string;
        name: string;
        fileSize: number;
        mimeType: string;
        type: AssetType;
        preview: string;
        source: string;
    }>;
};

export type CanCreateCustomerMutationVariables = Exact<{
    input: CreateCustomerInput;
}>;

export type CanCreateCustomerMutation = { createCustomer: { id: string } | {} };

export type GetCustomerCountQueryVariables = Exact<{ [key: string]: never }>;

export type GetCustomerCountQuery = { customers: { totalItems: number } };

export type DeepFieldResolutionTestQueryQueryVariables = Exact<{ [key: string]: never }>;

export type DeepFieldResolutionTestQueryQuery = {
    product?: {
        variants: Array<{
            taxRateApplied: {
                customerGroup?: { customers: { items: Array<{ id: string; emailAddress: string }> } } | null;
            };
        }>;
    } | null;
};

export type AuthenticateMutationVariables = Exact<{
    input: AuthenticationInput;
}>;

export type AuthenticateMutation = {
    authenticate:
        | {
              id: string;
              identifier: string;
              channels: Array<{ code: string; token: string; permissions: Array<Permission> }>;
          }
        | { authenticationError: string; errorCode: ErrorCode; message: string };
};

export type GetCustomersQueryVariables = Exact<{ [key: string]: never }>;

export type GetCustomersQuery = {
    customers: { totalItems: number; items: Array<{ id: string; emailAddress: string }> };
};

export type GetCustomerUserAuthQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetCustomerUserAuthQuery = {
    customer?: {
        id: string;
        user?: {
            id: string;
            verified: boolean;
            authenticationMethods: Array<{ id: string; strategy: string }>;
        } | null;
    } | null;
};

export type DeleteChannelMutationVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type DeleteChannelMutation = { deleteChannel: { message?: string | null; result: DeletionResult } };

export type GetChannelQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetChannelQuery = {
    channel?: {
        id: string;
        code: string;
        token: string;
        defaultCurrencyCode: CurrencyCode;
        availableCurrencyCodes: Array<CurrencyCode>;
        defaultLanguageCode: LanguageCode;
        availableLanguageCodes?: Array<LanguageCode> | null;
        outOfStockThreshold?: number | null;
        pricesIncludeTax: boolean;
    } | null;
};

export type UpdateGlobalLanguagesMutationVariables = Exact<{
    input: UpdateGlobalSettingsInput;
}>;

export type UpdateGlobalLanguagesMutation = {
    updateGlobalSettings: { id: string; availableLanguages: Array<LanguageCode> } | {};
};

export type GetCollectionsWithAssetsQueryVariables = Exact<{ [key: string]: never }>;

export type GetCollectionsWithAssetsQuery = {
    collections: { items: Array<{ assets: Array<{ name: string }> }> };
};

export type GetProductsWithVariantIdsQueryVariables = Exact<{ [key: string]: never }>;

export type GetProductsWithVariantIdsQuery = {
    products: { items: Array<{ id: string; name: string; variants: Array<{ id: string; name: string }> }> };
};

export type GetCollectionListAdminQueryVariables = Exact<{
    options?: InputMaybe<CollectionListOptions>;
}>;

export type GetCollectionListAdminQuery = {
    collections: {
        totalItems: number;
        items: Array<{
            id: string;
            name: string;
            slug: string;
            description: string;
            isPrivate: boolean;
            languageCode?: LanguageCode | null;
            featuredAsset?: {
                id: string;
                name: string;
                fileSize: number;
                mimeType: string;
                type: AssetType;
                preview: string;
                source: string;
            } | null;
            assets: Array<{
                id: string;
                name: string;
                fileSize: number;
                mimeType: string;
                type: AssetType;
                preview: string;
                source: string;
            }>;
            filters: Array<{ code: string; args: Array<{ name: string; value: string }> }>;
            translations: Array<{
                id: string;
                languageCode: LanguageCode;
                name: string;
                slug: string;
                description: string;
            }>;
            parent?: { id: string; name: string } | null;
            children?: Array<{ id: string; name: string; position: number }> | null;
        }>;
    };
};

export type MoveCollectionMutationVariables = Exact<{
    input: MoveCollectionInput;
}>;

export type MoveCollectionMutation = {
    moveCollection: {
        id: string;
        name: string;
        slug: string;
        description: string;
        isPrivate: boolean;
        languageCode?: LanguageCode | null;
        featuredAsset?: {
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        } | null;
        assets: Array<{
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        }>;
        filters: Array<{ code: string; args: Array<{ name: string; value: string }> }>;
        translations: Array<{
            id: string;
            languageCode: LanguageCode;
            name: string;
            slug: string;
            description: string;
        }>;
        parent?: { id: string; name: string } | null;
        children?: Array<{ id: string; name: string; position: number }> | null;
    };
};

export type GetFacetValuesQueryVariables = Exact<{ [key: string]: never }>;

export type GetFacetValuesQuery = {
    facets: {
        items: Array<{
            values: Array<{
                id: string;
                languageCode: LanguageCode;
                code: string;
                name: string;
                translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
                facet: { id: string; name: string };
            }>;
        }>;
    };
};

export type GetCollectionProductsQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetCollectionProductsQuery = {
    collection?: {
        productVariants: {
            items: Array<{
                id: string;
                name: string;
                productId: string;
                facetValues: Array<{ code: string }>;
            }>;
        };
    } | null;
};

export type CreateCollectionSelectVariantsMutationVariables = Exact<{
    input: CreateCollectionInput;
}>;

export type CreateCollectionSelectVariantsMutation = {
    createCollection: { id: string; productVariants: { totalItems: number; items: Array<{ name: string }> } };
};

export type GetCollectionBreadcrumbsQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetCollectionBreadcrumbsQuery = {
    collection?: { breadcrumbs: Array<{ id: string; name: string; slug: string }> } | null;
};

export type GetCollectionsForProductsQueryVariables = Exact<{
    term: Scalars['String']['input'];
}>;

export type GetCollectionsForProductsQuery = {
    products: {
        items: Array<{ id: string; name: string; collections: Array<{ id: string; name: string }> }>;
    };
};

export type DeleteCollectionMutationVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type DeleteCollectionMutation = {
    deleteCollection: { result: DeletionResult; message?: string | null };
};

export type GetProductCollectionsQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetProductCollectionsQuery = {
    product?: { id: string; collections: Array<{ id: string; name: string }> } | null;
};

export type GetProductCollectionsWithParentQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetProductCollectionsWithParentQuery = {
    product?: {
        id: string;
        collections: Array<{ id: string; name: string; parent?: { id: string; name: string } | null }>;
    } | null;
};

export type GetCollectionNestedParentsQueryVariables = Exact<{ [key: string]: never }>;

export type GetCollectionNestedParentsQuery = {
    collections: {
        items: Array<{
            id: string;
            name: string;
            parent?: {
                name: string;
                parent?: { name: string; parent?: { name: string } | null } | null;
            } | null;
        }>;
    };
};

export type PreviewCollectionVariantsQueryVariables = Exact<{
    input: PreviewCollectionVariantsInput;
    options?: InputMaybe<ProductVariantListOptions>;
}>;

export type PreviewCollectionVariantsQuery = {
    previewCollectionVariants: { totalItems: number; items: Array<{ id: string; name: string }> };
};

export type RemoveCollectionsFromChannelMutationVariables = Exact<{
    input: RemoveCollectionsFromChannelInput;
}>;

export type RemoveCollectionsFromChannelMutation = {
    removeCollectionsFromChannel: Array<{
        id: string;
        name: string;
        slug: string;
        description: string;
        isPrivate: boolean;
        languageCode?: LanguageCode | null;
        featuredAsset?: {
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        } | null;
        assets: Array<{
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        }>;
        filters: Array<{ code: string; args: Array<{ name: string; value: string }> }>;
        translations: Array<{
            id: string;
            languageCode: LanguageCode;
            name: string;
            slug: string;
            description: string;
        }>;
        parent?: { id: string; name: string } | null;
        children?: Array<{ id: string; name: string; position: number }> | null;
    }>;
};

export type DeleteCollectionsBulkMutationVariables = Exact<{
    ids: Array<Scalars['ID']['input']> | Scalars['ID']['input'];
}>;

export type DeleteCollectionsBulkMutation = {
    deleteCollections: Array<{ message?: string | null; result: DeletionResult }>;
};

export type GetCheckersQueryVariables = Exact<{ [key: string]: never }>;

export type GetCheckersQuery = {
    shippingEligibilityCheckers: Array<{
        code: string;
        args: Array<{
            defaultValue?: any | null;
            description?: string | null;
            label?: string | null;
            list: boolean;
            name: string;
            required: boolean;
            type: string;
        }>;
    }>;
};

export type DeleteCountryMutationVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type DeleteCountryMutation = { deleteCountry: { result: DeletionResult; message?: string | null } };

export type GetCountryQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetCountryQuery = {
    country?: {
        id: string;
        code: string;
        name: string;
        enabled: boolean;
        translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
    } | null;
};

export type CreateCountryMutationVariables = Exact<{
    input: CreateCountryInput;
}>;

export type CreateCountryMutation = {
    createCountry: {
        id: string;
        code: string;
        name: string;
        enabled: boolean;
        translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
    };
};

export type DeleteCustomerAddressMutationVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type DeleteCustomerAddressMutation = { deleteCustomerAddress: { success: boolean } };

export type GetCustomerWithUserQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetCustomerWithUserQuery = {
    customer?: { id: string; user?: { id: string; identifier: string; verified: boolean } | null } | null;
};

export type GetCustomerOrdersQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetCustomerOrdersQuery = {
    customer?: { orders: { totalItems: number; items: Array<{ id: string }> } } | null;
};

export type AddNoteToCustomerMutationVariables = Exact<{
    input: AddNoteToCustomerInput;
}>;

export type AddNoteToCustomerMutation = {
    addNoteToCustomer: {
        id: string;
        title?: string | null;
        firstName: string;
        lastName: string;
        phoneNumber?: string | null;
        emailAddress: string;
        user?: { id: string; identifier: string; verified: boolean; lastLogin?: any | null } | null;
        addresses?: Array<{
            id: string;
            fullName?: string | null;
            company?: string | null;
            streetLine1: string;
            streetLine2?: string | null;
            city?: string | null;
            province?: string | null;
            postalCode?: string | null;
            phoneNumber?: string | null;
            defaultShippingAddress?: boolean | null;
            defaultBillingAddress?: boolean | null;
            country: { id: string; code: string; name: string };
        }> | null;
    };
};

export type ReindexMutationVariables = Exact<{ [key: string]: never }>;

export type ReindexMutation = { reindex: { id: string } };

export type SearchFacetValuesQueryVariables = Exact<{
    input: SearchInput;
}>;

export type SearchFacetValuesQuery = {
    search: {
        totalItems: number;
        facetValues: Array<{ count: number; facetValue: { id: string; name: string } }>;
    };
};

export type SearchCollectionsQueryVariables = Exact<{
    input: SearchInput;
}>;

export type SearchCollectionsQuery = {
    search: {
        totalItems: number;
        collections: Array<{ count: number; collection: { id: string; name: string } }>;
    };
};

export type SearchGetAssetsQueryVariables = Exact<{
    input: SearchInput;
}>;

export type SearchGetAssetsQuery = {
    search: {
        totalItems: number;
        items: Array<{
            productId: string;
            productVariantId: string;
            productName: string;
            productVariantName: string;
            productAsset?: {
                id: string;
                preview: string;
                focalPoint?: { x: number; y: number } | null;
            } | null;
            productVariantAsset?: {
                id: string;
                preview: string;
                focalPoint?: { x: number; y: number } | null;
            } | null;
        }>;
    };
};

export type SearchGetPricesQueryVariables = Exact<{
    input: SearchInput;
}>;

export type SearchGetPricesQuery = {
    search: {
        items: Array<{
            price: { min: number; max: number } | { value: number };
            priceWithTax: { min: number; max: number } | { value: number };
        }>;
    };
};

export type CreateDraftOrderMutationVariables = Exact<{ [key: string]: never }>;

export type CreateDraftOrderMutation = {
    createDraftOrder: {
        id: string;
        createdAt: any;
        updatedAt: any;
        code: string;
        state: string;
        active: boolean;
        subTotal: number;
        subTotalWithTax: number;
        total: number;
        totalWithTax: number;
        totalQuantity: number;
        currencyCode: CurrencyCode;
        shipping: number;
        shippingWithTax: number;
        customer?: { id: string; firstName: string; lastName: string } | null;
        lines: Array<{
            id: string;
            unitPrice: number;
            unitPriceWithTax: number;
            quantity: number;
            taxRate: number;
            linePriceWithTax: number;
            featuredAsset?: { preview: string } | null;
            productVariant: { id: string; name: string; sku: string };
            taxLines: Array<{ description: string; taxRate: number }>;
        }>;
        surcharges: Array<{
            id: string;
            description: string;
            sku?: string | null;
            price: number;
            priceWithTax: number;
        }>;
        shippingLines: Array<{
            priceWithTax: number;
            shippingMethod: { id: string; code: string; name: string; description: string };
        }>;
        shippingAddress?: {
            fullName?: string | null;
            company?: string | null;
            streetLine1?: string | null;
            streetLine2?: string | null;
            city?: string | null;
            province?: string | null;
            postalCode?: string | null;
            country?: string | null;
            phoneNumber?: string | null;
        } | null;
        payments?: Array<{
            id: string;
            transactionId?: string | null;
            amount: number;
            method: string;
            state: string;
            nextStates: Array<string>;
            metadata?: any | null;
            refunds: Array<{ id: string; total: number; reason?: string | null }>;
        }> | null;
        fulfillments?: Array<{
            id: string;
            state: string;
            method: string;
            trackingCode?: string | null;
            lines: Array<{ orderLineId: string; quantity: number }>;
        }> | null;
    };
};

export type AddItemToDraftOrderMutationVariables = Exact<{
    orderId: Scalars['ID']['input'];
    input: AddItemToDraftOrderInput;
}>;

export type AddItemToDraftOrderMutation = {
    addItemToDraftOrder:
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string }
        | {
              id: string;
              createdAt: any;
              updatedAt: any;
              code: string;
              state: string;
              active: boolean;
              subTotal: number;
              subTotalWithTax: number;
              total: number;
              totalWithTax: number;
              totalQuantity: number;
              currencyCode: CurrencyCode;
              shipping: number;
              shippingWithTax: number;
              customer?: { id: string; firstName: string; lastName: string } | null;
              lines: Array<{
                  id: string;
                  unitPrice: number;
                  unitPriceWithTax: number;
                  quantity: number;
                  taxRate: number;
                  linePriceWithTax: number;
                  featuredAsset?: { preview: string } | null;
                  productVariant: { id: string; name: string; sku: string };
                  taxLines: Array<{ description: string; taxRate: number }>;
              }>;
              surcharges: Array<{
                  id: string;
                  description: string;
                  sku?: string | null;
                  price: number;
                  priceWithTax: number;
              }>;
              shippingLines: Array<{
                  priceWithTax: number;
                  shippingMethod: { id: string; code: string; name: string; description: string };
              }>;
              shippingAddress?: {
                  fullName?: string | null;
                  company?: string | null;
                  streetLine1?: string | null;
                  streetLine2?: string | null;
                  city?: string | null;
                  province?: string | null;
                  postalCode?: string | null;
                  country?: string | null;
                  phoneNumber?: string | null;
              } | null;
              payments?: Array<{
                  id: string;
                  transactionId?: string | null;
                  amount: number;
                  method: string;
                  state: string;
                  nextStates: Array<string>;
                  metadata?: any | null;
                  refunds: Array<{ id: string; total: number; reason?: string | null }>;
              }> | null;
              fulfillments?: Array<{
                  id: string;
                  state: string;
                  method: string;
                  trackingCode?: string | null;
                  lines: Array<{ orderLineId: string; quantity: number }>;
              }> | null;
          }
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string };
};

export type AdjustDraftOrderLineMutationVariables = Exact<{
    orderId: Scalars['ID']['input'];
    input: AdjustDraftOrderLineInput;
}>;

export type AdjustDraftOrderLineMutation = {
    adjustDraftOrderLine:
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string }
        | {
              id: string;
              createdAt: any;
              updatedAt: any;
              code: string;
              state: string;
              active: boolean;
              subTotal: number;
              subTotalWithTax: number;
              total: number;
              totalWithTax: number;
              totalQuantity: number;
              currencyCode: CurrencyCode;
              shipping: number;
              shippingWithTax: number;
              customer?: { id: string; firstName: string; lastName: string } | null;
              lines: Array<{
                  id: string;
                  unitPrice: number;
                  unitPriceWithTax: number;
                  quantity: number;
                  taxRate: number;
                  linePriceWithTax: number;
                  featuredAsset?: { preview: string } | null;
                  productVariant: { id: string; name: string; sku: string };
                  taxLines: Array<{ description: string; taxRate: number }>;
              }>;
              surcharges: Array<{
                  id: string;
                  description: string;
                  sku?: string | null;
                  price: number;
                  priceWithTax: number;
              }>;
              shippingLines: Array<{
                  priceWithTax: number;
                  shippingMethod: { id: string; code: string; name: string; description: string };
              }>;
              shippingAddress?: {
                  fullName?: string | null;
                  company?: string | null;
                  streetLine1?: string | null;
                  streetLine2?: string | null;
                  city?: string | null;
                  province?: string | null;
                  postalCode?: string | null;
                  country?: string | null;
                  phoneNumber?: string | null;
              } | null;
              payments?: Array<{
                  id: string;
                  transactionId?: string | null;
                  amount: number;
                  method: string;
                  state: string;
                  nextStates: Array<string>;
                  metadata?: any | null;
                  refunds: Array<{ id: string; total: number; reason?: string | null }>;
              }> | null;
              fulfillments?: Array<{
                  id: string;
                  state: string;
                  method: string;
                  trackingCode?: string | null;
                  lines: Array<{ orderLineId: string; quantity: number }>;
              }> | null;
          }
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string };
};

export type RemoveDraftOrderLineMutationVariables = Exact<{
    orderId: Scalars['ID']['input'];
    orderLineId: Scalars['ID']['input'];
}>;

export type RemoveDraftOrderLineMutation = {
    removeDraftOrderLine:
        | {
              id: string;
              createdAt: any;
              updatedAt: any;
              code: string;
              state: string;
              active: boolean;
              subTotal: number;
              subTotalWithTax: number;
              total: number;
              totalWithTax: number;
              totalQuantity: number;
              currencyCode: CurrencyCode;
              shipping: number;
              shippingWithTax: number;
              customer?: { id: string; firstName: string; lastName: string } | null;
              lines: Array<{
                  id: string;
                  unitPrice: number;
                  unitPriceWithTax: number;
                  quantity: number;
                  taxRate: number;
                  linePriceWithTax: number;
                  featuredAsset?: { preview: string } | null;
                  productVariant: { id: string; name: string; sku: string };
                  taxLines: Array<{ description: string; taxRate: number }>;
              }>;
              surcharges: Array<{
                  id: string;
                  description: string;
                  sku?: string | null;
                  price: number;
                  priceWithTax: number;
              }>;
              shippingLines: Array<{
                  priceWithTax: number;
                  shippingMethod: { id: string; code: string; name: string; description: string };
              }>;
              shippingAddress?: {
                  fullName?: string | null;
                  company?: string | null;
                  streetLine1?: string | null;
                  streetLine2?: string | null;
                  city?: string | null;
                  province?: string | null;
                  postalCode?: string | null;
                  country?: string | null;
                  phoneNumber?: string | null;
              } | null;
              payments?: Array<{
                  id: string;
                  transactionId?: string | null;
                  amount: number;
                  method: string;
                  state: string;
                  nextStates: Array<string>;
                  metadata?: any | null;
                  refunds: Array<{ id: string; total: number; reason?: string | null }>;
              }> | null;
              fulfillments?: Array<{
                  id: string;
                  state: string;
                  method: string;
                  trackingCode?: string | null;
                  lines: Array<{ orderLineId: string; quantity: number }>;
              }> | null;
          }
        | { errorCode: ErrorCode; message: string };
};

export type SetCustomerForDraftOrderMutationVariables = Exact<{
    orderId: Scalars['ID']['input'];
    customerId?: InputMaybe<Scalars['ID']['input']>;
    input?: InputMaybe<CreateCustomerInput>;
}>;

export type SetCustomerForDraftOrderMutation = {
    setCustomerForDraftOrder:
        | { errorCode: ErrorCode; message: string }
        | {
              id: string;
              createdAt: any;
              updatedAt: any;
              code: string;
              state: string;
              active: boolean;
              subTotal: number;
              subTotalWithTax: number;
              total: number;
              totalWithTax: number;
              totalQuantity: number;
              currencyCode: CurrencyCode;
              shipping: number;
              shippingWithTax: number;
              customer?: { id: string; firstName: string; lastName: string } | null;
              lines: Array<{
                  id: string;
                  unitPrice: number;
                  unitPriceWithTax: number;
                  quantity: number;
                  taxRate: number;
                  linePriceWithTax: number;
                  featuredAsset?: { preview: string } | null;
                  productVariant: { id: string; name: string; sku: string };
                  taxLines: Array<{ description: string; taxRate: number }>;
              }>;
              surcharges: Array<{
                  id: string;
                  description: string;
                  sku?: string | null;
                  price: number;
                  priceWithTax: number;
              }>;
              shippingLines: Array<{
                  priceWithTax: number;
                  shippingMethod: { id: string; code: string; name: string; description: string };
              }>;
              shippingAddress?: {
                  fullName?: string | null;
                  company?: string | null;
                  streetLine1?: string | null;
                  streetLine2?: string | null;
                  city?: string | null;
                  province?: string | null;
                  postalCode?: string | null;
                  country?: string | null;
                  phoneNumber?: string | null;
              } | null;
              payments?: Array<{
                  id: string;
                  transactionId?: string | null;
                  amount: number;
                  method: string;
                  state: string;
                  nextStates: Array<string>;
                  metadata?: any | null;
                  refunds: Array<{ id: string; total: number; reason?: string | null }>;
              }> | null;
              fulfillments?: Array<{
                  id: string;
                  state: string;
                  method: string;
                  trackingCode?: string | null;
                  lines: Array<{ orderLineId: string; quantity: number }>;
              }> | null;
          };
};

export type SetDraftOrderShippingAddressMutationVariables = Exact<{
    orderId: Scalars['ID']['input'];
    input: CreateAddressInput;
}>;

export type SetDraftOrderShippingAddressMutation = {
    setDraftOrderShippingAddress: {
        id: string;
        createdAt: any;
        updatedAt: any;
        code: string;
        state: string;
        active: boolean;
        subTotal: number;
        subTotalWithTax: number;
        total: number;
        totalWithTax: number;
        totalQuantity: number;
        currencyCode: CurrencyCode;
        shipping: number;
        shippingWithTax: number;
        customer?: { id: string; firstName: string; lastName: string } | null;
        lines: Array<{
            id: string;
            unitPrice: number;
            unitPriceWithTax: number;
            quantity: number;
            taxRate: number;
            linePriceWithTax: number;
            featuredAsset?: { preview: string } | null;
            productVariant: { id: string; name: string; sku: string };
            taxLines: Array<{ description: string; taxRate: number }>;
        }>;
        surcharges: Array<{
            id: string;
            description: string;
            sku?: string | null;
            price: number;
            priceWithTax: number;
        }>;
        shippingLines: Array<{
            priceWithTax: number;
            shippingMethod: { id: string; code: string; name: string; description: string };
        }>;
        shippingAddress?: {
            fullName?: string | null;
            company?: string | null;
            streetLine1?: string | null;
            streetLine2?: string | null;
            city?: string | null;
            province?: string | null;
            postalCode?: string | null;
            country?: string | null;
            phoneNumber?: string | null;
        } | null;
        payments?: Array<{
            id: string;
            transactionId?: string | null;
            amount: number;
            method: string;
            state: string;
            nextStates: Array<string>;
            metadata?: any | null;
            refunds: Array<{ id: string; total: number; reason?: string | null }>;
        }> | null;
        fulfillments?: Array<{
            id: string;
            state: string;
            method: string;
            trackingCode?: string | null;
            lines: Array<{ orderLineId: string; quantity: number }>;
        }> | null;
    };
};

export type SetDraftOrderBillingAddressMutationVariables = Exact<{
    orderId: Scalars['ID']['input'];
    input: CreateAddressInput;
}>;

export type SetDraftOrderBillingAddressMutation = {
    setDraftOrderBillingAddress: {
        id: string;
        createdAt: any;
        updatedAt: any;
        code: string;
        state: string;
        active: boolean;
        subTotal: number;
        subTotalWithTax: number;
        total: number;
        totalWithTax: number;
        totalQuantity: number;
        currencyCode: CurrencyCode;
        shipping: number;
        shippingWithTax: number;
        billingAddress?: {
            fullName?: string | null;
            company?: string | null;
            streetLine1?: string | null;
            streetLine2?: string | null;
            city?: string | null;
            province?: string | null;
            postalCode?: string | null;
            country?: string | null;
            phoneNumber?: string | null;
        } | null;
        customer?: { id: string; firstName: string; lastName: string } | null;
        lines: Array<{
            id: string;
            unitPrice: number;
            unitPriceWithTax: number;
            quantity: number;
            taxRate: number;
            linePriceWithTax: number;
            featuredAsset?: { preview: string } | null;
            productVariant: { id: string; name: string; sku: string };
            taxLines: Array<{ description: string; taxRate: number }>;
        }>;
        surcharges: Array<{
            id: string;
            description: string;
            sku?: string | null;
            price: number;
            priceWithTax: number;
        }>;
        shippingLines: Array<{
            priceWithTax: number;
            shippingMethod: { id: string; code: string; name: string; description: string };
        }>;
        shippingAddress?: {
            fullName?: string | null;
            company?: string | null;
            streetLine1?: string | null;
            streetLine2?: string | null;
            city?: string | null;
            province?: string | null;
            postalCode?: string | null;
            country?: string | null;
            phoneNumber?: string | null;
        } | null;
        payments?: Array<{
            id: string;
            transactionId?: string | null;
            amount: number;
            method: string;
            state: string;
            nextStates: Array<string>;
            metadata?: any | null;
            refunds: Array<{ id: string; total: number; reason?: string | null }>;
        }> | null;
        fulfillments?: Array<{
            id: string;
            state: string;
            method: string;
            trackingCode?: string | null;
            lines: Array<{ orderLineId: string; quantity: number }>;
        }> | null;
    };
};

export type ApplyCouponCodeToDraftOrderMutationVariables = Exact<{
    orderId: Scalars['ID']['input'];
    couponCode: Scalars['String']['input'];
}>;

export type ApplyCouponCodeToDraftOrderMutation = {
    applyCouponCodeToDraftOrder:
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string }
        | {
              couponCodes: Array<string>;
              id: string;
              createdAt: any;
              updatedAt: any;
              code: string;
              state: string;
              active: boolean;
              subTotal: number;
              subTotalWithTax: number;
              total: number;
              totalWithTax: number;
              totalQuantity: number;
              currencyCode: CurrencyCode;
              shipping: number;
              shippingWithTax: number;
              customer?: { id: string; firstName: string; lastName: string } | null;
              lines: Array<{
                  id: string;
                  unitPrice: number;
                  unitPriceWithTax: number;
                  quantity: number;
                  taxRate: number;
                  linePriceWithTax: number;
                  featuredAsset?: { preview: string } | null;
                  productVariant: { id: string; name: string; sku: string };
                  taxLines: Array<{ description: string; taxRate: number }>;
              }>;
              surcharges: Array<{
                  id: string;
                  description: string;
                  sku?: string | null;
                  price: number;
                  priceWithTax: number;
              }>;
              shippingLines: Array<{
                  priceWithTax: number;
                  shippingMethod: { id: string; code: string; name: string; description: string };
              }>;
              shippingAddress?: {
                  fullName?: string | null;
                  company?: string | null;
                  streetLine1?: string | null;
                  streetLine2?: string | null;
                  city?: string | null;
                  province?: string | null;
                  postalCode?: string | null;
                  country?: string | null;
                  phoneNumber?: string | null;
              } | null;
              payments?: Array<{
                  id: string;
                  transactionId?: string | null;
                  amount: number;
                  method: string;
                  state: string;
                  nextStates: Array<string>;
                  metadata?: any | null;
                  refunds: Array<{ id: string; total: number; reason?: string | null }>;
              }> | null;
              fulfillments?: Array<{
                  id: string;
                  state: string;
                  method: string;
                  trackingCode?: string | null;
                  lines: Array<{ orderLineId: string; quantity: number }>;
              }> | null;
          };
};

export type RemoveCouponCodeFromDraftOrderMutationVariables = Exact<{
    orderId: Scalars['ID']['input'];
    couponCode: Scalars['String']['input'];
}>;

export type RemoveCouponCodeFromDraftOrderMutation = {
    removeCouponCodeFromDraftOrder?: {
        couponCodes: Array<string>;
        id: string;
        createdAt: any;
        updatedAt: any;
        code: string;
        state: string;
        active: boolean;
        subTotal: number;
        subTotalWithTax: number;
        total: number;
        totalWithTax: number;
        totalQuantity: number;
        currencyCode: CurrencyCode;
        shipping: number;
        shippingWithTax: number;
        customer?: { id: string; firstName: string; lastName: string } | null;
        lines: Array<{
            id: string;
            unitPrice: number;
            unitPriceWithTax: number;
            quantity: number;
            taxRate: number;
            linePriceWithTax: number;
            featuredAsset?: { preview: string } | null;
            productVariant: { id: string; name: string; sku: string };
            taxLines: Array<{ description: string; taxRate: number }>;
        }>;
        surcharges: Array<{
            id: string;
            description: string;
            sku?: string | null;
            price: number;
            priceWithTax: number;
        }>;
        shippingLines: Array<{
            priceWithTax: number;
            shippingMethod: { id: string; code: string; name: string; description: string };
        }>;
        shippingAddress?: {
            fullName?: string | null;
            company?: string | null;
            streetLine1?: string | null;
            streetLine2?: string | null;
            city?: string | null;
            province?: string | null;
            postalCode?: string | null;
            country?: string | null;
            phoneNumber?: string | null;
        } | null;
        payments?: Array<{
            id: string;
            transactionId?: string | null;
            amount: number;
            method: string;
            state: string;
            nextStates: Array<string>;
            metadata?: any | null;
            refunds: Array<{ id: string; total: number; reason?: string | null }>;
        }> | null;
        fulfillments?: Array<{
            id: string;
            state: string;
            method: string;
            trackingCode?: string | null;
            lines: Array<{ orderLineId: string; quantity: number }>;
        }> | null;
    } | null;
};

export type DraftOrderEligibleShippingMethodsQueryVariables = Exact<{
    orderId: Scalars['ID']['input'];
}>;

export type DraftOrderEligibleShippingMethodsQuery = {
    eligibleShippingMethodsForDraftOrder: Array<{
        id: string;
        name: string;
        code: string;
        description: string;
        price: number;
        priceWithTax: number;
        metadata?: any | null;
    }>;
};

export type SetDraftOrderShippingMethodMutationVariables = Exact<{
    orderId: Scalars['ID']['input'];
    shippingMethodId: Scalars['ID']['input'];
}>;

export type SetDraftOrderShippingMethodMutation = {
    setDraftOrderShippingMethod:
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string }
        | {
              id: string;
              createdAt: any;
              updatedAt: any;
              code: string;
              state: string;
              active: boolean;
              subTotal: number;
              subTotalWithTax: number;
              total: number;
              totalWithTax: number;
              totalQuantity: number;
              currencyCode: CurrencyCode;
              shipping: number;
              shippingWithTax: number;
              customer?: { id: string; firstName: string; lastName: string } | null;
              lines: Array<{
                  id: string;
                  unitPrice: number;
                  unitPriceWithTax: number;
                  quantity: number;
                  taxRate: number;
                  linePriceWithTax: number;
                  featuredAsset?: { preview: string } | null;
                  productVariant: { id: string; name: string; sku: string };
                  taxLines: Array<{ description: string; taxRate: number }>;
              }>;
              surcharges: Array<{
                  id: string;
                  description: string;
                  sku?: string | null;
                  price: number;
                  priceWithTax: number;
              }>;
              shippingLines: Array<{
                  priceWithTax: number;
                  shippingMethod: { id: string; code: string; name: string; description: string };
              }>;
              shippingAddress?: {
                  fullName?: string | null;
                  company?: string | null;
                  streetLine1?: string | null;
                  streetLine2?: string | null;
                  city?: string | null;
                  province?: string | null;
                  postalCode?: string | null;
                  country?: string | null;
                  phoneNumber?: string | null;
              } | null;
              payments?: Array<{
                  id: string;
                  transactionId?: string | null;
                  amount: number;
                  method: string;
                  state: string;
                  nextStates: Array<string>;
                  metadata?: any | null;
                  refunds: Array<{ id: string; total: number; reason?: string | null }>;
              }> | null;
              fulfillments?: Array<{
                  id: string;
                  state: string;
                  method: string;
                  trackingCode?: string | null;
                  lines: Array<{ orderLineId: string; quantity: number }>;
              }> | null;
          }
        | { errorCode: ErrorCode; message: string };
};

export type GetOrderPlacedAtQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetOrderPlacedAtQuery = {
    order?: { id: string; createdAt: any; updatedAt: any; state: string; orderPlacedAt?: any | null } | null;
};

export type GetEntityDuplicatorsQueryVariables = Exact<{ [key: string]: never }>;

export type GetEntityDuplicatorsQuery = {
    entityDuplicators: Array<{
        code: string;
        description: string;
        requiresPermission: Array<Permission>;
        forEntities: Array<string>;
        args: Array<{ name: string; type: string; defaultValue?: any | null }>;
    }>;
};

export type DuplicateEntityMutationVariables = Exact<{
    input: DuplicateEntityInput;
}>;

export type DuplicateEntityMutation = {
    duplicateEntity: { message: string; duplicationError: string } | { newEntityId: string };
};

export type IdTest1QueryVariables = Exact<{ [key: string]: never }>;

export type IdTest1Query = { products: { items: Array<{ id: string }> } };

export type IdTest2QueryVariables = Exact<{ [key: string]: never }>;

export type IdTest2Query = {
    products: {
        items: Array<{
            id: string;
            variants: Array<{ id: string; options: Array<{ id: string; name: string }> }>;
        }>;
    };
};

export type IdTest3QueryVariables = Exact<{ [key: string]: never }>;

export type IdTest3Query = { product?: { id: string } | null };

export type IdTest4MutationVariables = Exact<{ [key: string]: never }>;

export type IdTest4Mutation = { updateProduct: { id: string; featuredAsset?: { id: string } | null } };

export type IdTest5MutationVariables = Exact<{ [key: string]: never }>;

export type IdTest5Mutation = { updateProduct: { id: string; name: string } };

export type IdTest6QueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type IdTest6Query = { product?: { id: string } | null };

export type IdTest7MutationVariables = Exact<{
    input: UpdateProductInput;
}>;

export type IdTest7Mutation = { updateProduct: { id: string; featuredAsset?: { id: string } | null } };

export type IdTest8MutationVariables = Exact<{
    input: UpdateProductInput;
}>;

export type IdTest8Mutation = { updateProduct: { id: string; name: string } };

export type IdTest9QueryVariables = Exact<{ [key: string]: never }>;

export type IdTest9Query = {
    products: { items: Array<{ id: string; featuredAsset?: { id: string } | null }> };
};

export type ProdFragmentFragment = { id: string; featuredAsset?: { id: string } | null };

export type IdTest10QueryVariables = Exact<{ [key: string]: never }>;

export type IdTest10Query = {
    products: { items: Array<{ id: string; featuredAsset?: { id: string } | null }> };
};

export type ProdFragment1Fragment = { id: string; featuredAsset?: { id: string } | null };

export type ProdFragment2Fragment = { id: string; featuredAsset?: { id: string } | null };

export type IdTest11QueryVariables = Exact<{ [key: string]: never }>;

export type IdTest11Query = {
    products: { items: Array<{ id: string; featuredAsset?: { id: string } | null }> };
};

export type ProdFragment1_1Fragment = { id: string; featuredAsset?: { id: string } | null };

export type ProdFragment2_1Fragment = { id: string; featuredAsset?: { id: string } | null };

export type ProdFragment3_1Fragment = { id: string; featuredAsset?: { id: string } | null };

export type GetFacetWithValueListQueryVariables = Exact<{
    id: Scalars['ID']['input'];
    options?: InputMaybe<FacetValueListOptions>;
}>;

export type GetFacetWithValueListQuery = {
    facet?: {
        id: string;
        languageCode: LanguageCode;
        isPrivate: boolean;
        code: string;
        name: string;
        valueList: {
            totalItems: number;
            items: Array<{
                id: string;
                languageCode: LanguageCode;
                code: string;
                name: string;
                translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
                facet: { id: string; name: string };
            }>;
        };
    } | null;
};

export type DeleteFacetValuesMutationVariables = Exact<{
    ids: Array<Scalars['ID']['input']> | Scalars['ID']['input'];
    force?: InputMaybe<Scalars['Boolean']['input']>;
}>;

export type DeleteFacetValuesMutation = {
    deleteFacetValues: Array<{ result: DeletionResult; message?: string | null }>;
};

export type DeleteFacetMutationVariables = Exact<{
    id: Scalars['ID']['input'];
    force?: InputMaybe<Scalars['Boolean']['input']>;
}>;

export type DeleteFacetMutation = { deleteFacet: { result: DeletionResult; message?: string | null } };

export type GetProductWithFacetValuesQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetProductWithFacetValuesQuery = {
    product?: {
        id: string;
        facetValues: Array<{ id: string; name: string; code: string }>;
        variants: Array<{ id: string; facetValues: Array<{ id: string; name: string; code: string }> }>;
    } | null;
};

export type GetProductListWithVariantsQueryVariables = Exact<{ [key: string]: never }>;

export type GetProductListWithVariantsQuery = {
    products: {
        totalItems: number;
        items: Array<{ id: string; name: string; variants: Array<{ id: string; name: string }> }>;
    };
};

export type CreateFacetValuesMutationVariables = Exact<{
    input: Array<CreateFacetValueInput> | CreateFacetValueInput;
}>;

export type CreateFacetValuesMutation = {
    createFacetValues: Array<{
        id: string;
        languageCode: LanguageCode;
        code: string;
        name: string;
        translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
        facet: { id: string; name: string };
    }>;
};

export type UpdateFacetValuesMutationVariables = Exact<{
    input: Array<UpdateFacetValueInput> | UpdateFacetValueInput;
}>;

export type UpdateFacetValuesMutation = {
    updateFacetValues: Array<{
        id: string;
        languageCode: LanguageCode;
        code: string;
        name: string;
        translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
        facet: { id: string; name: string };
    }>;
};

export type AssignFacetsToChannelMutationVariables = Exact<{
    input: AssignFacetsToChannelInput;
}>;

export type AssignFacetsToChannelMutation = { assignFacetsToChannel: Array<{ id: string; name: string }> };

export type RemoveFacetsFromChannelMutationVariables = Exact<{
    input: RemoveFacetsFromChannelInput;
}>;

export type RemoveFacetsFromChannelMutation = {
    removeFacetsFromChannel: Array<
        | { id: string; name: string }
        | { errorCode: ErrorCode; message: string; productCount: number; variantCount: number }
    >;
};

export type GetGlobalSettingsQueryVariables = Exact<{ [key: string]: never }>;

export type GetGlobalSettingsQuery = {
    globalSettings: {
        id: string;
        availableLanguages: Array<LanguageCode>;
        trackInventory: boolean;
        outOfStockThreshold: number;
        serverConfig: {
            permittedAssetTypes: Array<string>;
            orderProcess: Array<{ name: string; to: Array<string> }>;
            permissions: Array<{ name: string; description: string; assignable: boolean }>;
            customFieldConfig: {
                Customer: Array<
                    | { name: string }
                    | { name: string }
                    | { name: string }
                    | { name: string }
                    | { name: string }
                    | { name: string }
                    | { name: string }
                    | { name: string }
                    | { name: string }
                >;
            };
        };
    };
};

export type SearchProductsAdminQueryVariables = Exact<{
    input: SearchInput;
}>;

export type SearchProductsAdminQuery = {
    search: {
        totalItems: number;
        items: Array<{
            enabled: boolean;
            productId: string;
            productName: string;
            slug: string;
            description: string;
            productVariantId: string;
            productVariantName: string;
            sku: string;
        }>;
    };
};

export type GetOrderWithSellerOrdersQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetOrderWithSellerOrdersQuery = {
    order?: {
        id: string;
        code: string;
        state: string;
        sellerOrders?: Array<{
            id: string;
            aggregateOrderId?: string | null;
            lines: Array<{ id: string; productVariant: { id: string; name: string } }>;
            shippingLines: Array<{ id: string; shippingMethod: { id: string; code: string } }>;
        }> | null;
        lines: Array<{ id: string; productVariant: { id: string; name: string } }>;
        shippingLines: Array<{ id: string; shippingMethod: { id: string; code: string } }>;
    } | null;
};

export type AdministratorFragment = {
    id: string;
    firstName: string;
    lastName: string;
    emailAddress: string;
    user: {
        id: string;
        identifier: string;
        lastLogin?: any | null;
        roles: Array<{ id: string; code: string; description: string; permissions: Array<Permission> }>;
    };
};

export type AssetFragment = {
    id: string;
    name: string;
    fileSize: number;
    mimeType: string;
    type: AssetType;
    preview: string;
    source: string;
};

export type ProductVariantFragment = {
    id: string;
    createdAt: any;
    updatedAt: any;
    enabled: boolean;
    languageCode: LanguageCode;
    name: string;
    currencyCode: CurrencyCode;
    price: number;
    priceWithTax: number;
    stockOnHand: number;
    trackInventory: GlobalFlag;
    sku: string;
    prices: Array<{ currencyCode: CurrencyCode; price: number }>;
    taxRateApplied: { id: string; name: string; value: number };
    taxCategory: { id: string; name: string };
    options: Array<{ id: string; code: string; languageCode: LanguageCode; groupId: string; name: string }>;
    facetValues: Array<{ id: string; code: string; name: string; facet: { id: string; name: string } }>;
    featuredAsset?: {
        id: string;
        name: string;
        fileSize: number;
        mimeType: string;
        type: AssetType;
        preview: string;
        source: string;
    } | null;
    assets: Array<{
        id: string;
        name: string;
        fileSize: number;
        mimeType: string;
        type: AssetType;
        preview: string;
        source: string;
    }>;
    translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
    channels: Array<{ id: string; code: string }>;
};

export type ProductWithVariantsFragment = {
    id: string;
    enabled: boolean;
    languageCode: LanguageCode;
    name: string;
    slug: string;
    description: string;
    featuredAsset?: {
        id: string;
        name: string;
        fileSize: number;
        mimeType: string;
        type: AssetType;
        preview: string;
        source: string;
    } | null;
    assets: Array<{
        id: string;
        name: string;
        fileSize: number;
        mimeType: string;
        type: AssetType;
        preview: string;
        source: string;
    }>;
    translations: Array<{ languageCode: LanguageCode; name: string; slug: string; description: string }>;
    optionGroups: Array<{ id: string; languageCode: LanguageCode; code: string; name: string }>;
    variants: Array<{
        id: string;
        createdAt: any;
        updatedAt: any;
        enabled: boolean;
        languageCode: LanguageCode;
        name: string;
        currencyCode: CurrencyCode;
        price: number;
        priceWithTax: number;
        stockOnHand: number;
        trackInventory: GlobalFlag;
        sku: string;
        prices: Array<{ currencyCode: CurrencyCode; price: number }>;
        taxRateApplied: { id: string; name: string; value: number };
        taxCategory: { id: string; name: string };
        options: Array<{
            id: string;
            code: string;
            languageCode: LanguageCode;
            groupId: string;
            name: string;
        }>;
        facetValues: Array<{ id: string; code: string; name: string; facet: { id: string; name: string } }>;
        featuredAsset?: {
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        } | null;
        assets: Array<{
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        }>;
        translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
        channels: Array<{ id: string; code: string }>;
    }>;
    facetValues: Array<{ id: string; code: string; name: string; facet: { id: string; name: string } }>;
    channels: Array<{ id: string; code: string }>;
};

export type RoleFragment = {
    id: string;
    code: string;
    description: string;
    permissions: Array<Permission>;
    channels: Array<{ id: string; code: string; token: string }>;
};

export type ConfigurableOperationFragment = { code: string; args: Array<{ name: string; value: string }> };

export type CollectionFragment = {
    id: string;
    name: string;
    slug: string;
    description: string;
    isPrivate: boolean;
    languageCode?: LanguageCode | null;
    featuredAsset?: {
        id: string;
        name: string;
        fileSize: number;
        mimeType: string;
        type: AssetType;
        preview: string;
        source: string;
    } | null;
    assets: Array<{
        id: string;
        name: string;
        fileSize: number;
        mimeType: string;
        type: AssetType;
        preview: string;
        source: string;
    }>;
    filters: Array<{ code: string; args: Array<{ name: string; value: string }> }>;
    translations: Array<{
        id: string;
        languageCode: LanguageCode;
        name: string;
        slug: string;
        description: string;
    }>;
    parent?: { id: string; name: string } | null;
    children?: Array<{ id: string; name: string; position: number }> | null;
};

export type FacetValueFragment = {
    id: string;
    languageCode: LanguageCode;
    code: string;
    name: string;
    translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
    facet: { id: string; name: string };
};

export type FacetWithValuesFragment = {
    id: string;
    languageCode: LanguageCode;
    isPrivate: boolean;
    code: string;
    name: string;
    translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
    values: Array<{
        id: string;
        languageCode: LanguageCode;
        code: string;
        name: string;
        translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
        facet: { id: string; name: string };
    }>;
};

type Country_Country_Fragment = {
    id: string;
    code: string;
    name: string;
    enabled: boolean;
    translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
};

type Country_Province_Fragment = {
    id: string;
    code: string;
    name: string;
    enabled: boolean;
    translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
};

export type CountryFragment = Country_Country_Fragment | Country_Province_Fragment;

export type AddressFragment = {
    id: string;
    fullName?: string | null;
    company?: string | null;
    streetLine1: string;
    streetLine2?: string | null;
    city?: string | null;
    province?: string | null;
    postalCode?: string | null;
    phoneNumber?: string | null;
    defaultShippingAddress?: boolean | null;
    defaultBillingAddress?: boolean | null;
    country: { id: string; code: string; name: string };
};

export type CustomerFragment = {
    id: string;
    title?: string | null;
    firstName: string;
    lastName: string;
    phoneNumber?: string | null;
    emailAddress: string;
    user?: { id: string; identifier: string; verified: boolean; lastLogin?: any | null } | null;
    addresses?: Array<{
        id: string;
        fullName?: string | null;
        company?: string | null;
        streetLine1: string;
        streetLine2?: string | null;
        city?: string | null;
        province?: string | null;
        postalCode?: string | null;
        phoneNumber?: string | null;
        defaultShippingAddress?: boolean | null;
        defaultBillingAddress?: boolean | null;
        country: { id: string; code: string; name: string };
    }> | null;
};

export type AdjustmentFragment = {
    adjustmentSource: string;
    amount: number;
    description: string;
    type: AdjustmentType;
};

export type ShippingAddressFragment = {
    fullName?: string | null;
    company?: string | null;
    streetLine1?: string | null;
    streetLine2?: string | null;
    city?: string | null;
    province?: string | null;
    postalCode?: string | null;
    country?: string | null;
    phoneNumber?: string | null;
};

export type OrderFragment = {
    id: string;
    createdAt: any;
    updatedAt: any;
    code: string;
    active: boolean;
    state: string;
    total: number;
    totalWithTax: number;
    totalQuantity: number;
    currencyCode: CurrencyCode;
    customer?: { id: string; firstName: string; lastName: string } | null;
};

export type PaymentFragment = {
    id: string;
    transactionId?: string | null;
    amount: number;
    method: string;
    state: string;
    nextStates: Array<string>;
    metadata?: any | null;
    refunds: Array<{ id: string; total: number; reason?: string | null }>;
};

export type OrderWithLinesFragment = {
    id: string;
    createdAt: any;
    updatedAt: any;
    code: string;
    state: string;
    active: boolean;
    subTotal: number;
    subTotalWithTax: number;
    total: number;
    totalWithTax: number;
    totalQuantity: number;
    currencyCode: CurrencyCode;
    shipping: number;
    shippingWithTax: number;
    customer?: { id: string; firstName: string; lastName: string } | null;
    lines: Array<{
        id: string;
        unitPrice: number;
        unitPriceWithTax: number;
        quantity: number;
        taxRate: number;
        linePriceWithTax: number;
        featuredAsset?: { preview: string } | null;
        productVariant: { id: string; name: string; sku: string };
        taxLines: Array<{ description: string; taxRate: number }>;
    }>;
    surcharges: Array<{
        id: string;
        description: string;
        sku?: string | null;
        price: number;
        priceWithTax: number;
    }>;
    shippingLines: Array<{
        priceWithTax: number;
        shippingMethod: { id: string; code: string; name: string; description: string };
    }>;
    shippingAddress?: {
        fullName?: string | null;
        company?: string | null;
        streetLine1?: string | null;
        streetLine2?: string | null;
        city?: string | null;
        province?: string | null;
        postalCode?: string | null;
        country?: string | null;
        phoneNumber?: string | null;
    } | null;
    payments?: Array<{
        id: string;
        transactionId?: string | null;
        amount: number;
        method: string;
        state: string;
        nextStates: Array<string>;
        metadata?: any | null;
        refunds: Array<{ id: string; total: number; reason?: string | null }>;
    }> | null;
    fulfillments?: Array<{
        id: string;
        state: string;
        method: string;
        trackingCode?: string | null;
        lines: Array<{ orderLineId: string; quantity: number }>;
    }> | null;
};

export type PromotionFragment = {
    id: string;
    createdAt: any;
    updatedAt: any;
    couponCode?: string | null;
    startsAt?: any | null;
    endsAt?: any | null;
    name: string;
    description: string;
    enabled: boolean;
    perCustomerUsageLimit?: number | null;
    usageLimit?: number | null;
    conditions: Array<{ code: string; args: Array<{ name: string; value: string }> }>;
    actions: Array<{ code: string; args: Array<{ name: string; value: string }> }>;
    translations: Array<{ id: string; languageCode: LanguageCode; name: string; description: string }>;
};

export type ZoneFragment = {
    id: string;
    name: string;
    members: Array<
        | {
              id: string;
              code: string;
              name: string;
              enabled: boolean;
              translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
          }
        | {
              id: string;
              code: string;
              name: string;
              enabled: boolean;
              translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
          }
    >;
};

export type TaxRateFragment = {
    id: string;
    name: string;
    enabled: boolean;
    value: number;
    category: { id: string; name: string };
    zone: { id: string; name: string };
    customerGroup?: { id: string; name: string } | null;
};

export type CurrentUserFragment = {
    id: string;
    identifier: string;
    channels: Array<{ code: string; token: string; permissions: Array<Permission> }>;
};

export type VariantWithStockFragment = {
    id: string;
    stockOnHand: number;
    stockAllocated: number;
    stockMovements: {
        totalItems: number;
        items: Array<
            | { id: string; type: StockMovementType; quantity: number }
            | { id: string; type: StockMovementType; quantity: number }
            | { id: string; type: StockMovementType; quantity: number }
            | { id: string; type: StockMovementType; quantity: number }
            | { id: string; type: StockMovementType; quantity: number }
            | { id: string; type: StockMovementType; quantity: number }
        >;
    };
};

export type FulfillmentFragment = {
    id: string;
    state: string;
    nextStates: Array<string>;
    method: string;
    trackingCode?: string | null;
    lines: Array<{ orderLineId: string; quantity: number }>;
};

export type ChannelFragment = {
    id: string;
    code: string;
    token: string;
    currencyCode: CurrencyCode;
    availableCurrencyCodes: Array<CurrencyCode>;
    defaultCurrencyCode: CurrencyCode;
    defaultLanguageCode: LanguageCode;
    pricesIncludeTax: boolean;
    defaultShippingZone?: { id: string } | null;
    defaultTaxZone?: { id: string } | null;
};

export type GlobalSettingsFragment = {
    id: string;
    availableLanguages: Array<LanguageCode>;
    trackInventory: boolean;
    outOfStockThreshold: number;
    serverConfig: {
        permittedAssetTypes: Array<string>;
        orderProcess: Array<{ name: string; to: Array<string> }>;
        permissions: Array<{ name: string; description: string; assignable: boolean }>;
        customFieldConfig: {
            Customer: Array<
                | { name: string }
                | { name: string }
                | { name: string }
                | { name: string }
                | { name: string }
                | { name: string }
                | { name: string }
                | { name: string }
                | { name: string }
            >;
        };
    };
};

export type CustomerGroupFragment = {
    id: string;
    name: string;
    customers: { totalItems: number; items: Array<{ id: string }> };
};

export type ProductOptionGroupFragment = {
    id: string;
    code: string;
    name: string;
    options: Array<{ id: string; code: string; name: string }>;
    translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
};

export type ProductWithOptionsFragment = {
    id: string;
    optionGroups: Array<{ id: string; code: string; options: Array<{ id: string; code: string }> }>;
};

export type ShippingMethodFragment = {
    id: string;
    code: string;
    name: string;
    description: string;
    calculator: { code: string; args: Array<{ name: string; value: string }> };
    checker: { code: string; args: Array<{ name: string; value: string }> };
};

export type CreateAdministratorMutationVariables = Exact<{
    input: CreateAdministratorInput;
}>;

export type CreateAdministratorMutation = {
    createAdministrator: {
        id: string;
        firstName: string;
        lastName: string;
        emailAddress: string;
        user: {
            id: string;
            identifier: string;
            lastLogin?: any | null;
            roles: Array<{ id: string; code: string; description: string; permissions: Array<Permission> }>;
        };
    };
};

export type UpdateProductMutationVariables = Exact<{
    input: UpdateProductInput;
}>;

export type UpdateProductMutation = {
    updateProduct: {
        id: string;
        enabled: boolean;
        languageCode: LanguageCode;
        name: string;
        slug: string;
        description: string;
        featuredAsset?: {
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        } | null;
        assets: Array<{
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        }>;
        translations: Array<{ languageCode: LanguageCode; name: string; slug: string; description: string }>;
        optionGroups: Array<{ id: string; languageCode: LanguageCode; code: string; name: string }>;
        variants: Array<{
            id: string;
            createdAt: any;
            updatedAt: any;
            enabled: boolean;
            languageCode: LanguageCode;
            name: string;
            currencyCode: CurrencyCode;
            price: number;
            priceWithTax: number;
            stockOnHand: number;
            trackInventory: GlobalFlag;
            sku: string;
            prices: Array<{ currencyCode: CurrencyCode; price: number }>;
            taxRateApplied: { id: string; name: string; value: number };
            taxCategory: { id: string; name: string };
            options: Array<{
                id: string;
                code: string;
                languageCode: LanguageCode;
                groupId: string;
                name: string;
            }>;
            facetValues: Array<{
                id: string;
                code: string;
                name: string;
                facet: { id: string; name: string };
            }>;
            featuredAsset?: {
                id: string;
                name: string;
                fileSize: number;
                mimeType: string;
                type: AssetType;
                preview: string;
                source: string;
            } | null;
            assets: Array<{
                id: string;
                name: string;
                fileSize: number;
                mimeType: string;
                type: AssetType;
                preview: string;
                source: string;
            }>;
            translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
            channels: Array<{ id: string; code: string }>;
        }>;
        facetValues: Array<{ id: string; code: string; name: string; facet: { id: string; name: string } }>;
        channels: Array<{ id: string; code: string }>;
    };
};

export type CreateProductMutationVariables = Exact<{
    input: CreateProductInput;
}>;

export type CreateProductMutation = {
    createProduct: {
        id: string;
        enabled: boolean;
        languageCode: LanguageCode;
        name: string;
        slug: string;
        description: string;
        featuredAsset?: {
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        } | null;
        assets: Array<{
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        }>;
        translations: Array<{ languageCode: LanguageCode; name: string; slug: string; description: string }>;
        optionGroups: Array<{ id: string; languageCode: LanguageCode; code: string; name: string }>;
        variants: Array<{
            id: string;
            createdAt: any;
            updatedAt: any;
            enabled: boolean;
            languageCode: LanguageCode;
            name: string;
            currencyCode: CurrencyCode;
            price: number;
            priceWithTax: number;
            stockOnHand: number;
            trackInventory: GlobalFlag;
            sku: string;
            prices: Array<{ currencyCode: CurrencyCode; price: number }>;
            taxRateApplied: { id: string; name: string; value: number };
            taxCategory: { id: string; name: string };
            options: Array<{
                id: string;
                code: string;
                languageCode: LanguageCode;
                groupId: string;
                name: string;
            }>;
            facetValues: Array<{
                id: string;
                code: string;
                name: string;
                facet: { id: string; name: string };
            }>;
            featuredAsset?: {
                id: string;
                name: string;
                fileSize: number;
                mimeType: string;
                type: AssetType;
                preview: string;
                source: string;
            } | null;
            assets: Array<{
                id: string;
                name: string;
                fileSize: number;
                mimeType: string;
                type: AssetType;
                preview: string;
                source: string;
            }>;
            translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
            channels: Array<{ id: string; code: string }>;
        }>;
        facetValues: Array<{ id: string; code: string; name: string; facet: { id: string; name: string } }>;
        channels: Array<{ id: string; code: string }>;
    };
};

export type GetProductWithVariantsQueryVariables = Exact<{
    id?: InputMaybe<Scalars['ID']['input']>;
    slug?: InputMaybe<Scalars['String']['input']>;
}>;

export type GetProductWithVariantsQuery = {
    product?: {
        id: string;
        enabled: boolean;
        languageCode: LanguageCode;
        name: string;
        slug: string;
        description: string;
        featuredAsset?: {
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        } | null;
        assets: Array<{
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        }>;
        translations: Array<{ languageCode: LanguageCode; name: string; slug: string; description: string }>;
        optionGroups: Array<{ id: string; languageCode: LanguageCode; code: string; name: string }>;
        variants: Array<{
            id: string;
            createdAt: any;
            updatedAt: any;
            enabled: boolean;
            languageCode: LanguageCode;
            name: string;
            currencyCode: CurrencyCode;
            price: number;
            priceWithTax: number;
            stockOnHand: number;
            trackInventory: GlobalFlag;
            sku: string;
            prices: Array<{ currencyCode: CurrencyCode; price: number }>;
            taxRateApplied: { id: string; name: string; value: number };
            taxCategory: { id: string; name: string };
            options: Array<{
                id: string;
                code: string;
                languageCode: LanguageCode;
                groupId: string;
                name: string;
            }>;
            facetValues: Array<{
                id: string;
                code: string;
                name: string;
                facet: { id: string; name: string };
            }>;
            featuredAsset?: {
                id: string;
                name: string;
                fileSize: number;
                mimeType: string;
                type: AssetType;
                preview: string;
                source: string;
            } | null;
            assets: Array<{
                id: string;
                name: string;
                fileSize: number;
                mimeType: string;
                type: AssetType;
                preview: string;
                source: string;
            }>;
            translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
            channels: Array<{ id: string; code: string }>;
        }>;
        facetValues: Array<{ id: string; code: string; name: string; facet: { id: string; name: string } }>;
        channels: Array<{ id: string; code: string }>;
    } | null;
};

export type GetProductListQueryVariables = Exact<{
    options?: InputMaybe<ProductListOptions>;
}>;

export type GetProductListQuery = {
    products: {
        totalItems: number;
        items: Array<{
            id: string;
            languageCode: LanguageCode;
            name: string;
            slug: string;
            featuredAsset?: { id: string; preview: string } | null;
        }>;
    };
};

export type CreateProductVariantsMutationVariables = Exact<{
    input: Array<CreateProductVariantInput> | CreateProductVariantInput;
}>;

export type CreateProductVariantsMutation = {
    createProductVariants: Array<{
        id: string;
        createdAt: any;
        updatedAt: any;
        enabled: boolean;
        languageCode: LanguageCode;
        name: string;
        currencyCode: CurrencyCode;
        price: number;
        priceWithTax: number;
        stockOnHand: number;
        trackInventory: GlobalFlag;
        sku: string;
        prices: Array<{ currencyCode: CurrencyCode; price: number }>;
        taxRateApplied: { id: string; name: string; value: number };
        taxCategory: { id: string; name: string };
        options: Array<{
            id: string;
            code: string;
            languageCode: LanguageCode;
            groupId: string;
            name: string;
        }>;
        facetValues: Array<{ id: string; code: string; name: string; facet: { id: string; name: string } }>;
        featuredAsset?: {
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        } | null;
        assets: Array<{
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        }>;
        translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
        channels: Array<{ id: string; code: string }>;
    } | null>;
};

export type UpdateProductVariantsMutationVariables = Exact<{
    input: Array<UpdateProductVariantInput> | UpdateProductVariantInput;
}>;

export type UpdateProductVariantsMutation = {
    updateProductVariants: Array<{
        id: string;
        createdAt: any;
        updatedAt: any;
        enabled: boolean;
        languageCode: LanguageCode;
        name: string;
        currencyCode: CurrencyCode;
        price: number;
        priceWithTax: number;
        stockOnHand: number;
        trackInventory: GlobalFlag;
        sku: string;
        prices: Array<{ currencyCode: CurrencyCode; price: number }>;
        taxRateApplied: { id: string; name: string; value: number };
        taxCategory: { id: string; name: string };
        options: Array<{
            id: string;
            code: string;
            languageCode: LanguageCode;
            groupId: string;
            name: string;
        }>;
        facetValues: Array<{ id: string; code: string; name: string; facet: { id: string; name: string } }>;
        featuredAsset?: {
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        } | null;
        assets: Array<{
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        }>;
        translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
        channels: Array<{ id: string; code: string }>;
    } | null>;
};

export type UpdateTaxRateMutationVariables = Exact<{
    input: UpdateTaxRateInput;
}>;

export type UpdateTaxRateMutation = {
    updateTaxRate: {
        id: string;
        name: string;
        enabled: boolean;
        value: number;
        category: { id: string; name: string };
        zone: { id: string; name: string };
        customerGroup?: { id: string; name: string } | null;
    };
};

export type CreateFacetMutationVariables = Exact<{
    input: CreateFacetInput;
}>;

export type CreateFacetMutation = {
    createFacet: {
        id: string;
        languageCode: LanguageCode;
        isPrivate: boolean;
        code: string;
        name: string;
        translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
        values: Array<{
            id: string;
            languageCode: LanguageCode;
            code: string;
            name: string;
            translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
            facet: { id: string; name: string };
        }>;
    };
};

export type UpdateFacetMutationVariables = Exact<{
    input: UpdateFacetInput;
}>;

export type UpdateFacetMutation = {
    updateFacet: {
        id: string;
        languageCode: LanguageCode;
        isPrivate: boolean;
        code: string;
        name: string;
        translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
        values: Array<{
            id: string;
            languageCode: LanguageCode;
            code: string;
            name: string;
            translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
            facet: { id: string; name: string };
        }>;
    };
};

export type GetCustomerListQueryVariables = Exact<{
    options?: InputMaybe<CustomerListOptions>;
}>;

export type GetCustomerListQuery = {
    customers: {
        totalItems: number;
        items: Array<{
            id: string;
            title?: string | null;
            firstName: string;
            lastName: string;
            emailAddress: string;
            phoneNumber?: string | null;
            user?: { id: string; identifier: string; verified: boolean } | null;
        }>;
    };
};

export type GetAssetListQueryVariables = Exact<{
    options?: InputMaybe<AssetListOptions>;
}>;

export type GetAssetListQuery = {
    assets: {
        totalItems: number;
        items: Array<{
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        }>;
    };
};

export type CreateRoleMutationVariables = Exact<{
    input: CreateRoleInput;
}>;

export type CreateRoleMutation = {
    createRole: {
        id: string;
        code: string;
        description: string;
        permissions: Array<Permission>;
        channels: Array<{ id: string; code: string; token: string }>;
    };
};

export type CreateCollectionMutationVariables = Exact<{
    input: CreateCollectionInput;
}>;

export type CreateCollectionMutation = {
    createCollection: {
        id: string;
        name: string;
        slug: string;
        description: string;
        isPrivate: boolean;
        languageCode?: LanguageCode | null;
        featuredAsset?: {
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        } | null;
        assets: Array<{
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        }>;
        filters: Array<{ code: string; args: Array<{ name: string; value: string }> }>;
        translations: Array<{
            id: string;
            languageCode: LanguageCode;
            name: string;
            slug: string;
            description: string;
        }>;
        parent?: { id: string; name: string } | null;
        children?: Array<{ id: string; name: string; position: number }> | null;
    };
};

export type UpdateCollectionMutationVariables = Exact<{
    input: UpdateCollectionInput;
}>;

export type UpdateCollectionMutation = {
    updateCollection: {
        id: string;
        name: string;
        slug: string;
        description: string;
        isPrivate: boolean;
        languageCode?: LanguageCode | null;
        featuredAsset?: {
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        } | null;
        assets: Array<{
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        }>;
        filters: Array<{ code: string; args: Array<{ name: string; value: string }> }>;
        translations: Array<{
            id: string;
            languageCode: LanguageCode;
            name: string;
            slug: string;
            description: string;
        }>;
        parent?: { id: string; name: string } | null;
        children?: Array<{ id: string; name: string; position: number }> | null;
    };
};

export type GetCustomerQueryVariables = Exact<{
    id: Scalars['ID']['input'];
    orderListOptions?: InputMaybe<OrderListOptions>;
}>;

export type GetCustomerQuery = {
    customer?: {
        id: string;
        title?: string | null;
        firstName: string;
        lastName: string;
        phoneNumber?: string | null;
        emailAddress: string;
        orders: {
            totalItems: number;
            items: Array<{
                id: string;
                code: string;
                state: string;
                total: number;
                currencyCode: CurrencyCode;
                updatedAt: any;
            }>;
        };
        user?: { id: string; identifier: string; verified: boolean; lastLogin?: any | null } | null;
        addresses?: Array<{
            id: string;
            fullName?: string | null;
            company?: string | null;
            streetLine1: string;
            streetLine2?: string | null;
            city?: string | null;
            province?: string | null;
            postalCode?: string | null;
            phoneNumber?: string | null;
            defaultShippingAddress?: boolean | null;
            defaultBillingAddress?: boolean | null;
            country: { id: string; code: string; name: string };
        }> | null;
    } | null;
};

export type AttemptLoginMutationVariables = Exact<{
    username: Scalars['String']['input'];
    password: Scalars['String']['input'];
    rememberMe?: InputMaybe<Scalars['Boolean']['input']>;
}>;

export type AttemptLoginMutation = {
    login:
        | {
              id: string;
              identifier: string;
              channels: Array<{ code: string; token: string; permissions: Array<Permission> }>;
          }
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string };
};

export type GetCountryListQueryVariables = Exact<{
    options?: InputMaybe<CountryListOptions>;
}>;

export type GetCountryListQuery = {
    countries: {
        totalItems: number;
        items: Array<{ id: string; code: string; name: string; enabled: boolean }>;
    };
};

export type UpdateCountryMutationVariables = Exact<{
    input: UpdateCountryInput;
}>;

export type UpdateCountryMutation = {
    updateCountry: {
        id: string;
        code: string;
        name: string;
        enabled: boolean;
        translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
    };
};

export type GetFacetListQueryVariables = Exact<{
    options?: InputMaybe<FacetListOptions>;
}>;

export type GetFacetListQuery = {
    facets: {
        totalItems: number;
        items: Array<{
            id: string;
            languageCode: LanguageCode;
            isPrivate: boolean;
            code: string;
            name: string;
            translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
            values: Array<{
                id: string;
                languageCode: LanguageCode;
                code: string;
                name: string;
                translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
                facet: { id: string; name: string };
            }>;
        }>;
    };
};

export type GetFacetListSimpleQueryVariables = Exact<{
    options?: InputMaybe<FacetListOptions>;
}>;

export type GetFacetListSimpleQuery = {
    facets: { totalItems: number; items: Array<{ id: string; name: string }> };
};

export type DeleteProductMutationVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type DeleteProductMutation = { deleteProduct: { result: DeletionResult } };

export type GetProductSimpleQueryVariables = Exact<{
    id?: InputMaybe<Scalars['ID']['input']>;
    slug?: InputMaybe<Scalars['String']['input']>;
}>;

export type GetProductSimpleQuery = { product?: { id: string; slug: string } | null };

export type GetStockMovementQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetStockMovementQuery = {
    product?: {
        id: string;
        variants: Array<{
            id: string;
            stockOnHand: number;
            stockAllocated: number;
            stockMovements: {
                totalItems: number;
                items: Array<
                    | { id: string; type: StockMovementType; quantity: number }
                    | { id: string; type: StockMovementType; quantity: number }
                    | { id: string; type: StockMovementType; quantity: number }
                    | { id: string; type: StockMovementType; quantity: number }
                    | { id: string; type: StockMovementType; quantity: number }
                    | { id: string; type: StockMovementType; quantity: number }
                >;
            };
        }>;
    } | null;
};

export type GetRunningJobsQueryVariables = Exact<{
    options?: InputMaybe<JobListOptions>;
}>;

export type GetRunningJobsQuery = {
    jobs: {
        totalItems: number;
        items: Array<{
            id: string;
            queueName: string;
            state: JobState;
            isSettled: boolean;
            duration: number;
        }>;
    };
};

export type CreatePromotionMutationVariables = Exact<{
    input: CreatePromotionInput;
}>;

export type CreatePromotionMutation = {
    createPromotion:
        | { errorCode: ErrorCode; message: string }
        | {
              id: string;
              createdAt: any;
              updatedAt: any;
              couponCode?: string | null;
              startsAt?: any | null;
              endsAt?: any | null;
              name: string;
              description: string;
              enabled: boolean;
              perCustomerUsageLimit?: number | null;
              usageLimit?: number | null;
              conditions: Array<{ code: string; args: Array<{ name: string; value: string }> }>;
              actions: Array<{ code: string; args: Array<{ name: string; value: string }> }>;
              translations: Array<{
                  id: string;
                  languageCode: LanguageCode;
                  name: string;
                  description: string;
              }>;
          };
};

export type MeQueryVariables = Exact<{ [key: string]: never }>;

export type MeQuery = {
    me?: {
        id: string;
        identifier: string;
        channels: Array<{ code: string; token: string; permissions: Array<Permission> }>;
    } | null;
};

export type CreateChannelMutationVariables = Exact<{
    input: CreateChannelInput;
}>;

export type CreateChannelMutation = {
    createChannel:
        | {
              id: string;
              code: string;
              token: string;
              currencyCode: CurrencyCode;
              availableCurrencyCodes: Array<CurrencyCode>;
              defaultCurrencyCode: CurrencyCode;
              defaultLanguageCode: LanguageCode;
              pricesIncludeTax: boolean;
              defaultShippingZone?: { id: string } | null;
              defaultTaxZone?: { id: string } | null;
          }
        | { errorCode: ErrorCode; message: string; languageCode: string };
};

export type DeleteProductVariantMutationVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type DeleteProductVariantMutation = {
    deleteProductVariant: { result: DeletionResult; message?: string | null };
};

export type AssignProductsToChannelMutationVariables = Exact<{
    input: AssignProductsToChannelInput;
}>;

export type AssignProductsToChannelMutation = {
    assignProductsToChannel: Array<{
        id: string;
        enabled: boolean;
        languageCode: LanguageCode;
        name: string;
        slug: string;
        description: string;
        featuredAsset?: {
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        } | null;
        assets: Array<{
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        }>;
        translations: Array<{ languageCode: LanguageCode; name: string; slug: string; description: string }>;
        optionGroups: Array<{ id: string; languageCode: LanguageCode; code: string; name: string }>;
        variants: Array<{
            id: string;
            createdAt: any;
            updatedAt: any;
            enabled: boolean;
            languageCode: LanguageCode;
            name: string;
            currencyCode: CurrencyCode;
            price: number;
            priceWithTax: number;
            stockOnHand: number;
            trackInventory: GlobalFlag;
            sku: string;
            prices: Array<{ currencyCode: CurrencyCode; price: number }>;
            taxRateApplied: { id: string; name: string; value: number };
            taxCategory: { id: string; name: string };
            options: Array<{
                id: string;
                code: string;
                languageCode: LanguageCode;
                groupId: string;
                name: string;
            }>;
            facetValues: Array<{
                id: string;
                code: string;
                name: string;
                facet: { id: string; name: string };
            }>;
            featuredAsset?: {
                id: string;
                name: string;
                fileSize: number;
                mimeType: string;
                type: AssetType;
                preview: string;
                source: string;
            } | null;
            assets: Array<{
                id: string;
                name: string;
                fileSize: number;
                mimeType: string;
                type: AssetType;
                preview: string;
                source: string;
            }>;
            translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
            channels: Array<{ id: string; code: string }>;
        }>;
        facetValues: Array<{ id: string; code: string; name: string; facet: { id: string; name: string } }>;
        channels: Array<{ id: string; code: string }>;
    }>;
};

export type RemoveProductsFromChannelMutationVariables = Exact<{
    input: RemoveProductsFromChannelInput;
}>;

export type RemoveProductsFromChannelMutation = {
    removeProductsFromChannel: Array<{
        id: string;
        enabled: boolean;
        languageCode: LanguageCode;
        name: string;
        slug: string;
        description: string;
        featuredAsset?: {
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        } | null;
        assets: Array<{
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        }>;
        translations: Array<{ languageCode: LanguageCode; name: string; slug: string; description: string }>;
        optionGroups: Array<{ id: string; languageCode: LanguageCode; code: string; name: string }>;
        variants: Array<{
            id: string;
            createdAt: any;
            updatedAt: any;
            enabled: boolean;
            languageCode: LanguageCode;
            name: string;
            currencyCode: CurrencyCode;
            price: number;
            priceWithTax: number;
            stockOnHand: number;
            trackInventory: GlobalFlag;
            sku: string;
            prices: Array<{ currencyCode: CurrencyCode; price: number }>;
            taxRateApplied: { id: string; name: string; value: number };
            taxCategory: { id: string; name: string };
            options: Array<{
                id: string;
                code: string;
                languageCode: LanguageCode;
                groupId: string;
                name: string;
            }>;
            facetValues: Array<{
                id: string;
                code: string;
                name: string;
                facet: { id: string; name: string };
            }>;
            featuredAsset?: {
                id: string;
                name: string;
                fileSize: number;
                mimeType: string;
                type: AssetType;
                preview: string;
                source: string;
            } | null;
            assets: Array<{
                id: string;
                name: string;
                fileSize: number;
                mimeType: string;
                type: AssetType;
                preview: string;
                source: string;
            }>;
            translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
            channels: Array<{ id: string; code: string }>;
        }>;
        facetValues: Array<{ id: string; code: string; name: string; facet: { id: string; name: string } }>;
        channels: Array<{ id: string; code: string }>;
    }>;
};

export type AssignProductVariantsToChannelMutationVariables = Exact<{
    input: AssignProductVariantsToChannelInput;
}>;

export type AssignProductVariantsToChannelMutation = {
    assignProductVariantsToChannel: Array<{
        id: string;
        createdAt: any;
        updatedAt: any;
        enabled: boolean;
        languageCode: LanguageCode;
        name: string;
        currencyCode: CurrencyCode;
        price: number;
        priceWithTax: number;
        stockOnHand: number;
        trackInventory: GlobalFlag;
        sku: string;
        prices: Array<{ currencyCode: CurrencyCode; price: number }>;
        taxRateApplied: { id: string; name: string; value: number };
        taxCategory: { id: string; name: string };
        options: Array<{
            id: string;
            code: string;
            languageCode: LanguageCode;
            groupId: string;
            name: string;
        }>;
        facetValues: Array<{ id: string; code: string; name: string; facet: { id: string; name: string } }>;
        featuredAsset?: {
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        } | null;
        assets: Array<{
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        }>;
        translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
        channels: Array<{ id: string; code: string }>;
    }>;
};

export type RemoveProductVariantsFromChannelMutationVariables = Exact<{
    input: RemoveProductVariantsFromChannelInput;
}>;

export type RemoveProductVariantsFromChannelMutation = {
    removeProductVariantsFromChannel: Array<{
        id: string;
        createdAt: any;
        updatedAt: any;
        enabled: boolean;
        languageCode: LanguageCode;
        name: string;
        currencyCode: CurrencyCode;
        price: number;
        priceWithTax: number;
        stockOnHand: number;
        trackInventory: GlobalFlag;
        sku: string;
        prices: Array<{ currencyCode: CurrencyCode; price: number }>;
        taxRateApplied: { id: string; name: string; value: number };
        taxCategory: { id: string; name: string };
        options: Array<{
            id: string;
            code: string;
            languageCode: LanguageCode;
            groupId: string;
            name: string;
        }>;
        facetValues: Array<{ id: string; code: string; name: string; facet: { id: string; name: string } }>;
        featuredAsset?: {
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        } | null;
        assets: Array<{
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        }>;
        translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
        channels: Array<{ id: string; code: string }>;
    }>;
};

export type UpdateAssetMutationVariables = Exact<{
    input: UpdateAssetInput;
}>;

export type UpdateAssetMutation = {
    updateAsset: {
        id: string;
        name: string;
        fileSize: number;
        mimeType: string;
        type: AssetType;
        preview: string;
        source: string;
        tags: Array<{ id: string; value: string }>;
        focalPoint?: { x: number; y: number } | null;
    };
};

export type DeleteAssetMutationVariables = Exact<{
    input: DeleteAssetInput;
}>;

export type DeleteAssetMutation = { deleteAsset: { result: DeletionResult; message?: string | null } };

export type UpdateChannelMutationVariables = Exact<{
    input: UpdateChannelInput;
}>;

export type UpdateChannelMutation = {
    updateChannel:
        | {
              id: string;
              code: string;
              token: string;
              currencyCode: CurrencyCode;
              availableCurrencyCodes: Array<CurrencyCode>;
              defaultCurrencyCode: CurrencyCode;
              defaultLanguageCode: LanguageCode;
              pricesIncludeTax: boolean;
              defaultShippingZone?: { id: string } | null;
              defaultTaxZone?: { id: string } | null;
          }
        | { errorCode: ErrorCode; message: string; languageCode: string };
};

export type GetCustomerHistoryQueryVariables = Exact<{
    id: Scalars['ID']['input'];
    options?: InputMaybe<HistoryEntryListOptions>;
}>;

export type GetCustomerHistoryQuery = {
    customer?: {
        id: string;
        history: {
            totalItems: number;
            items: Array<{
                id: string;
                type: HistoryEntryType;
                data: any;
                administrator?: { id: string } | null;
            }>;
        };
    } | null;
};

export type GetOrderQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetOrderQuery = {
    order?: {
        id: string;
        createdAt: any;
        updatedAt: any;
        code: string;
        state: string;
        active: boolean;
        subTotal: number;
        subTotalWithTax: number;
        total: number;
        totalWithTax: number;
        totalQuantity: number;
        currencyCode: CurrencyCode;
        shipping: number;
        shippingWithTax: number;
        customer?: { id: string; firstName: string; lastName: string } | null;
        lines: Array<{
            id: string;
            unitPrice: number;
            unitPriceWithTax: number;
            quantity: number;
            taxRate: number;
            linePriceWithTax: number;
            featuredAsset?: { preview: string } | null;
            productVariant: { id: string; name: string; sku: string };
            taxLines: Array<{ description: string; taxRate: number }>;
        }>;
        surcharges: Array<{
            id: string;
            description: string;
            sku?: string | null;
            price: number;
            priceWithTax: number;
        }>;
        shippingLines: Array<{
            priceWithTax: number;
            shippingMethod: { id: string; code: string; name: string; description: string };
        }>;
        shippingAddress?: {
            fullName?: string | null;
            company?: string | null;
            streetLine1?: string | null;
            streetLine2?: string | null;
            city?: string | null;
            province?: string | null;
            postalCode?: string | null;
            country?: string | null;
            phoneNumber?: string | null;
        } | null;
        payments?: Array<{
            id: string;
            transactionId?: string | null;
            amount: number;
            method: string;
            state: string;
            nextStates: Array<string>;
            metadata?: any | null;
            refunds: Array<{ id: string; total: number; reason?: string | null }>;
        }> | null;
        fulfillments?: Array<{
            id: string;
            state: string;
            method: string;
            trackingCode?: string | null;
            lines: Array<{ orderLineId: string; quantity: number }>;
        }> | null;
    } | null;
};

export type CreateCustomerGroupMutationVariables = Exact<{
    input: CreateCustomerGroupInput;
}>;

export type CreateCustomerGroupMutation = {
    createCustomerGroup: {
        id: string;
        name: string;
        customers: { totalItems: number; items: Array<{ id: string }> };
    };
};

export type RemoveCustomersFromGroupMutationVariables = Exact<{
    groupId: Scalars['ID']['input'];
    customerIds: Array<Scalars['ID']['input']> | Scalars['ID']['input'];
}>;

export type RemoveCustomersFromGroupMutation = {
    removeCustomersFromGroup: {
        id: string;
        name: string;
        customers: { totalItems: number; items: Array<{ id: string }> };
    };
};

export type CreateFulfillmentMutationVariables = Exact<{
    input: FulfillOrderInput;
}>;

export type CreateFulfillmentMutation = {
    addFulfillmentToOrder:
        | { errorCode: ErrorCode; message: string; fulfillmentHandlerError: string }
        | { errorCode: ErrorCode; message: string }
        | {
              id: string;
              state: string;
              nextStates: Array<string>;
              method: string;
              trackingCode?: string | null;
              lines: Array<{ orderLineId: string; quantity: number }>;
          }
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string };
};

export type TransitFulfillmentMutationVariables = Exact<{
    id: Scalars['ID']['input'];
    state: Scalars['String']['input'];
}>;

export type TransitFulfillmentMutation = {
    transitionFulfillmentToState:
        | {
              id: string;
              state: string;
              nextStates: Array<string>;
              method: string;
              trackingCode?: string | null;
              lines: Array<{ orderLineId: string; quantity: number }>;
          }
        | {
              errorCode: ErrorCode;
              message: string;
              transitionError: string;
              fromState: string;
              toState: string;
          };
};

export type GetOrderFulfillmentsQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetOrderFulfillmentsQuery = {
    order?: {
        id: string;
        state: string;
        fulfillments?: Array<{
            id: string;
            state: string;
            nextStates: Array<string>;
            method: string;
            summary: Array<{ quantity: number; orderLine: { id: string } }>;
        }> | null;
    } | null;
};

export type GetOrderListQueryVariables = Exact<{
    options?: InputMaybe<OrderListOptions>;
}>;

export type GetOrderListQuery = {
    orders: {
        totalItems: number;
        items: Array<{
            id: string;
            createdAt: any;
            updatedAt: any;
            code: string;
            active: boolean;
            state: string;
            total: number;
            totalWithTax: number;
            totalQuantity: number;
            currencyCode: CurrencyCode;
            customer?: { id: string; firstName: string; lastName: string } | null;
        }>;
    };
};

export type CreateAddressMutationVariables = Exact<{
    id: Scalars['ID']['input'];
    input: CreateAddressInput;
}>;

export type CreateAddressMutation = {
    createCustomerAddress: {
        id: string;
        fullName?: string | null;
        company?: string | null;
        streetLine1: string;
        streetLine2?: string | null;
        city?: string | null;
        province?: string | null;
        postalCode?: string | null;
        phoneNumber?: string | null;
        defaultShippingAddress?: boolean | null;
        defaultBillingAddress?: boolean | null;
        country: { code: string; name: string };
    };
};

export type UpdateAddressMutationVariables = Exact<{
    input: UpdateAddressInput;
}>;

export type UpdateAddressMutation = {
    updateCustomerAddress: {
        id: string;
        defaultShippingAddress?: boolean | null;
        defaultBillingAddress?: boolean | null;
        country: { code: string; name: string };
    };
};

export type CreateCustomerMutationVariables = Exact<{
    input: CreateCustomerInput;
    password?: InputMaybe<Scalars['String']['input']>;
}>;

export type CreateCustomerMutation = {
    createCustomer:
        | {
              id: string;
              title?: string | null;
              firstName: string;
              lastName: string;
              phoneNumber?: string | null;
              emailAddress: string;
              user?: { id: string; identifier: string; verified: boolean; lastLogin?: any | null } | null;
              addresses?: Array<{
                  id: string;
                  fullName?: string | null;
                  company?: string | null;
                  streetLine1: string;
                  streetLine2?: string | null;
                  city?: string | null;
                  province?: string | null;
                  postalCode?: string | null;
                  phoneNumber?: string | null;
                  defaultShippingAddress?: boolean | null;
                  defaultBillingAddress?: boolean | null;
                  country: { id: string; code: string; name: string };
              }> | null;
          }
        | { errorCode: ErrorCode; message: string };
};

export type UpdateCustomerMutationVariables = Exact<{
    input: UpdateCustomerInput;
}>;

export type UpdateCustomerMutation = {
    updateCustomer:
        | {
              id: string;
              title?: string | null;
              firstName: string;
              lastName: string;
              phoneNumber?: string | null;
              emailAddress: string;
              user?: { id: string; identifier: string; verified: boolean; lastLogin?: any | null } | null;
              addresses?: Array<{
                  id: string;
                  fullName?: string | null;
                  company?: string | null;
                  streetLine1: string;
                  streetLine2?: string | null;
                  city?: string | null;
                  province?: string | null;
                  postalCode?: string | null;
                  phoneNumber?: string | null;
                  defaultShippingAddress?: boolean | null;
                  defaultBillingAddress?: boolean | null;
                  country: { id: string; code: string; name: string };
              }> | null;
          }
        | { errorCode: ErrorCode; message: string };
};

export type DeleteCustomerMutationVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type DeleteCustomerMutation = { deleteCustomer: { result: DeletionResult } };

export type UpdateCustomerNoteMutationVariables = Exact<{
    input: UpdateCustomerNoteInput;
}>;

export type UpdateCustomerNoteMutation = { updateCustomerNote: { id: string; data: any; isPublic: boolean } };

export type DeleteCustomerNoteMutationVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type DeleteCustomerNoteMutation = {
    deleteCustomerNote: { result: DeletionResult; message?: string | null };
};

export type UpdateCustomerGroupMutationVariables = Exact<{
    input: UpdateCustomerGroupInput;
}>;

export type UpdateCustomerGroupMutation = {
    updateCustomerGroup: {
        id: string;
        name: string;
        customers: { totalItems: number; items: Array<{ id: string }> };
    };
};

export type DeleteCustomerGroupMutationVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type DeleteCustomerGroupMutation = {
    deleteCustomerGroup: { result: DeletionResult; message?: string | null };
};

export type GetCustomerGroupsQueryVariables = Exact<{
    options?: InputMaybe<CustomerGroupListOptions>;
}>;

export type GetCustomerGroupsQuery = {
    customerGroups: { totalItems: number; items: Array<{ id: string; name: string }> };
};

export type GetCustomerGroupQueryVariables = Exact<{
    id: Scalars['ID']['input'];
    options?: InputMaybe<CustomerListOptions>;
}>;

export type GetCustomerGroupQuery = {
    customerGroup?: {
        id: string;
        name: string;
        customers: { totalItems: number; items: Array<{ id: string }> };
    } | null;
};

export type AddCustomersToGroupMutationVariables = Exact<{
    groupId: Scalars['ID']['input'];
    customerIds: Array<Scalars['ID']['input']> | Scalars['ID']['input'];
}>;

export type AddCustomersToGroupMutation = {
    addCustomersToGroup: {
        id: string;
        name: string;
        customers: { totalItems: number; items: Array<{ id: string }> };
    };
};

export type GetCustomerWithGroupsQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetCustomerWithGroupsQuery = {
    customer?: { id: string; groups: Array<{ id: string; name: string }> } | null;
};

export type AdminTransitionMutationVariables = Exact<{
    id: Scalars['ID']['input'];
    state: Scalars['String']['input'];
}>;

export type AdminTransitionMutation = {
    transitionOrderToState?:
        | {
              id: string;
              createdAt: any;
              updatedAt: any;
              code: string;
              active: boolean;
              state: string;
              total: number;
              totalWithTax: number;
              totalQuantity: number;
              currencyCode: CurrencyCode;
              customer?: { id: string; firstName: string; lastName: string } | null;
          }
        | {
              errorCode: ErrorCode;
              message: string;
              transitionError: string;
              fromState: string;
              toState: string;
          }
        | null;
};

export type CancelOrderMutationVariables = Exact<{
    input: CancelOrderInput;
}>;

export type CancelOrderMutation = {
    cancelOrder:
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string }
        | { id: string; state: string; lines: Array<{ id: string; quantity: number }> }
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string };
};

export type CanceledOrderFragment = {
    id: string;
    state: string;
    lines: Array<{ id: string; quantity: number }>;
};

export type UpdateGlobalSettingsMutationVariables = Exact<{
    input: UpdateGlobalSettingsInput;
}>;

export type UpdateGlobalSettingsMutation = {
    updateGlobalSettings:
        | { errorCode: ErrorCode; message: string }
        | {
              id: string;
              availableLanguages: Array<LanguageCode>;
              trackInventory: boolean;
              outOfStockThreshold: number;
              serverConfig: {
                  permittedAssetTypes: Array<string>;
                  orderProcess: Array<{ name: string; to: Array<string> }>;
                  permissions: Array<{ name: string; description: string; assignable: boolean }>;
                  customFieldConfig: {
                      Customer: Array<
                          | { name: string }
                          | { name: string }
                          | { name: string }
                          | { name: string }
                          | { name: string }
                          | { name: string }
                          | { name: string }
                          | { name: string }
                          | { name: string }
                      >;
                  };
              };
          };
};

export type UpdateRoleMutationVariables = Exact<{
    input: UpdateRoleInput;
}>;

export type UpdateRoleMutation = {
    updateRole: {
        id: string;
        code: string;
        description: string;
        permissions: Array<Permission>;
        channels: Array<{ id: string; code: string; token: string }>;
    };
};

export type GetProductsWithVariantPricesQueryVariables = Exact<{ [key: string]: never }>;

export type GetProductsWithVariantPricesQuery = {
    products: {
        items: Array<{
            id: string;
            slug: string;
            variants: Array<{
                id: string;
                price: number;
                priceWithTax: number;
                currencyCode: CurrencyCode;
                sku: string;
                facetValues: Array<{ id: string; code: string }>;
            }>;
        }>;
    };
};

export type CreateProductOptionGroupMutationVariables = Exact<{
    input: CreateProductOptionGroupInput;
}>;

export type CreateProductOptionGroupMutation = {
    createProductOptionGroup: {
        id: string;
        code: string;
        name: string;
        options: Array<{ id: string; code: string; name: string }>;
        translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
    };
};

export type AddOptionGroupToProductMutationVariables = Exact<{
    productId: Scalars['ID']['input'];
    optionGroupId: Scalars['ID']['input'];
}>;

export type AddOptionGroupToProductMutation = {
    addOptionGroupToProduct: {
        id: string;
        optionGroups: Array<{ id: string; code: string; options: Array<{ id: string; code: string }> }>;
    };
};

export type CreateShippingMethodMutationVariables = Exact<{
    input: CreateShippingMethodInput;
}>;

export type CreateShippingMethodMutation = {
    createShippingMethod: {
        id: string;
        code: string;
        name: string;
        description: string;
        calculator: { code: string; args: Array<{ name: string; value: string }> };
        checker: { code: string; args: Array<{ name: string; value: string }> };
    };
};

export type SettlePaymentMutationVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type SettlePaymentMutation = {
    settlePayment:
        | { errorCode: ErrorCode; message: string }
        | {
              id: string;
              transactionId?: string | null;
              amount: number;
              method: string;
              state: string;
              nextStates: Array<string>;
              metadata?: any | null;
              refunds: Array<{ id: string; total: number; reason?: string | null }>;
          }
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string; paymentErrorMessage: string };
};

export type GetOrderHistoryQueryVariables = Exact<{
    id: Scalars['ID']['input'];
    options?: InputMaybe<HistoryEntryListOptions>;
}>;

export type GetOrderHistoryQuery = {
    order?: {
        id: string;
        history: {
            totalItems: number;
            items: Array<{
                id: string;
                type: HistoryEntryType;
                data: any;
                administrator?: { id: string } | null;
            }>;
        };
    } | null;
};

export type UpdateShippingMethodMutationVariables = Exact<{
    input: UpdateShippingMethodInput;
}>;

export type UpdateShippingMethodMutation = {
    updateShippingMethod: {
        id: string;
        code: string;
        name: string;
        description: string;
        calculator: { code: string; args: Array<{ name: string; value: string }> };
        checker: { code: string; args: Array<{ name: string; value: string }> };
    };
};

export type GetAssetQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetAssetQuery = {
    asset?: {
        width: number;
        height: number;
        id: string;
        name: string;
        fileSize: number;
        mimeType: string;
        type: AssetType;
        preview: string;
        source: string;
    } | null;
};

export type AssetFragFirstFragment = { id: string; preview: string };

export type GetAssetFragmentFirstQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetAssetFragmentFirstQuery = { asset?: { id: string; preview: string } | null };

export type AssetWithTagsAndFocalPointFragment = {
    id: string;
    name: string;
    fileSize: number;
    mimeType: string;
    type: AssetType;
    preview: string;
    source: string;
    focalPoint?: { x: number; y: number } | null;
    tags: Array<{ id: string; value: string }>;
};

export type CreateAssetsMutationVariables = Exact<{
    input: Array<CreateAssetInput> | CreateAssetInput;
}>;

export type CreateAssetsMutation = {
    createAssets: Array<
        | {
              id: string;
              name: string;
              fileSize: number;
              mimeType: string;
              type: AssetType;
              preview: string;
              source: string;
              focalPoint?: { x: number; y: number } | null;
              tags: Array<{ id: string; value: string }>;
          }
        | { message: string; fileName: string; mimeType: string }
    >;
};

export type DeleteShippingMethodMutationVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type DeleteShippingMethodMutation = {
    deleteShippingMethod: { result: DeletionResult; message?: string | null };
};

export type AssignPromotionToChannelMutationVariables = Exact<{
    input: AssignPromotionsToChannelInput;
}>;

export type AssignPromotionToChannelMutation = {
    assignPromotionsToChannel: Array<{ id: string; name: string }>;
};

export type RemovePromotionFromChannelMutationVariables = Exact<{
    input: RemovePromotionsFromChannelInput;
}>;

export type RemovePromotionFromChannelMutation = {
    removePromotionsFromChannel: Array<{ id: string; name: string }>;
};

export type GetTaxRatesQueryVariables = Exact<{
    options?: InputMaybe<TaxRateListOptions>;
}>;

export type GetTaxRatesQuery = {
    taxRates: {
        totalItems: number;
        items: Array<{
            id: string;
            name: string;
            enabled: boolean;
            value: number;
            category: { id: string; name: string };
            zone: { id: string; name: string };
            customerGroup?: { id: string; name: string } | null;
        }>;
    };
};

export type GetShippingMethodListQueryVariables = Exact<{ [key: string]: never }>;

export type GetShippingMethodListQuery = {
    shippingMethods: {
        totalItems: number;
        items: Array<{
            id: string;
            code: string;
            name: string;
            description: string;
            calculator: { code: string; args: Array<{ name: string; value: string }> };
            checker: { code: string; args: Array<{ name: string; value: string }> };
        }>;
    };
};

export type GetCollectionsQueryVariables = Exact<{ [key: string]: never }>;

export type GetCollectionsQuery = {
    collections: {
        items: Array<{
            id: string;
            name: string;
            position: number;
            parent?: { id: string; name: string } | null;
        }>;
    };
};

export type TransitionPaymentToStateMutationVariables = Exact<{
    id: Scalars['ID']['input'];
    state: Scalars['String']['input'];
}>;

export type TransitionPaymentToStateMutation = {
    transitionPaymentToState:
        | {
              id: string;
              transactionId?: string | null;
              amount: number;
              method: string;
              state: string;
              nextStates: Array<string>;
              metadata?: any | null;
              refunds: Array<{ id: string; total: number; reason?: string | null }>;
          }
        | { errorCode: ErrorCode; message: string; transitionError: string };
};

export type GetProductVariantListQueryVariables = Exact<{
    options?: InputMaybe<ProductVariantListOptions>;
    productId?: InputMaybe<Scalars['ID']['input']>;
}>;

export type GetProductVariantListQuery = {
    productVariants: {
        totalItems: number;
        items: Array<{
            id: string;
            name: string;
            sku: string;
            price: number;
            priceWithTax: number;
            currencyCode: CurrencyCode;
            prices: Array<{ currencyCode: CurrencyCode; price: number }>;
        }>;
    };
};

export type DeletePromotionMutationVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type DeletePromotionMutation = { deletePromotion: { result: DeletionResult } };

export type GetChannelsQueryVariables = Exact<{ [key: string]: never }>;

export type GetChannelsQuery = { channels: { items: Array<{ id: string; code: string; token: string }> } };

export type UpdateAdministratorMutationVariables = Exact<{
    input: UpdateAdministratorInput;
}>;

export type UpdateAdministratorMutation = {
    updateAdministrator: {
        id: string;
        firstName: string;
        lastName: string;
        emailAddress: string;
        user: {
            id: string;
            identifier: string;
            lastLogin?: any | null;
            roles: Array<{ id: string; code: string; description: string; permissions: Array<Permission> }>;
        };
    };
};

export type AssignCollectionsToChannelMutationVariables = Exact<{
    input: AssignCollectionsToChannelInput;
}>;

export type AssignCollectionsToChannelMutation = {
    assignCollectionsToChannel: Array<{
        id: string;
        name: string;
        slug: string;
        description: string;
        isPrivate: boolean;
        languageCode?: LanguageCode | null;
        featuredAsset?: {
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        } | null;
        assets: Array<{
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        }>;
        filters: Array<{ code: string; args: Array<{ name: string; value: string }> }>;
        translations: Array<{
            id: string;
            languageCode: LanguageCode;
            name: string;
            slug: string;
            description: string;
        }>;
        parent?: { id: string; name: string } | null;
        children?: Array<{ id: string; name: string; position: number }> | null;
    }>;
};

export type GetCollectionQueryVariables = Exact<{
    id?: InputMaybe<Scalars['ID']['input']>;
    slug?: InputMaybe<Scalars['String']['input']>;
    variantListOptions?: InputMaybe<ProductVariantListOptions>;
}>;

export type GetCollectionQuery = {
    collection?: {
        id: string;
        name: string;
        slug: string;
        description: string;
        isPrivate: boolean;
        languageCode?: LanguageCode | null;
        productVariants: { items: Array<{ id: string; name: string; price: number }> };
        featuredAsset?: {
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        } | null;
        assets: Array<{
            id: string;
            name: string;
            fileSize: number;
            mimeType: string;
            type: AssetType;
            preview: string;
            source: string;
        }>;
        filters: Array<{ code: string; args: Array<{ name: string; value: string }> }>;
        translations: Array<{
            id: string;
            languageCode: LanguageCode;
            name: string;
            slug: string;
            description: string;
        }>;
        parent?: { id: string; name: string } | null;
        children?: Array<{ id: string; name: string; position: number }> | null;
    } | null;
};

export type GetFacetWithValuesQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetFacetWithValuesQuery = {
    facet?: {
        id: string;
        languageCode: LanguageCode;
        isPrivate: boolean;
        code: string;
        name: string;
        translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
        values: Array<{
            id: string;
            languageCode: LanguageCode;
            code: string;
            name: string;
            translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
            facet: { id: string; name: string };
        }>;
    } | null;
};

export type GetPromotionQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetPromotionQuery = {
    promotion?: {
        id: string;
        createdAt: any;
        updatedAt: any;
        couponCode?: string | null;
        startsAt?: any | null;
        endsAt?: any | null;
        name: string;
        description: string;
        enabled: boolean;
        perCustomerUsageLimit?: number | null;
        usageLimit?: number | null;
        conditions: Array<{ code: string; args: Array<{ name: string; value: string }> }>;
        actions: Array<{ code: string; args: Array<{ name: string; value: string }> }>;
        translations: Array<{ id: string; languageCode: LanguageCode; name: string; description: string }>;
    } | null;
};

export type CancelJobMutationVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type CancelJobMutation = {
    cancelJob: { id: string; state: JobState; isSettled: boolean; settledAt?: any | null };
};

export type UpdateOptionGroupMutationVariables = Exact<{
    input: UpdateProductOptionGroupInput;
}>;

export type UpdateOptionGroupMutation = { updateProductOptionGroup: { id: string } };

export type GetFulfillmentHandlersQueryVariables = Exact<{ [key: string]: never }>;

export type GetFulfillmentHandlersQuery = {
    fulfillmentHandlers: Array<{
        code: string;
        description: string;
        args: Array<{
            name: string;
            type: string;
            description?: string | null;
            label?: string | null;
            ui?: any | null;
        }>;
    }>;
};

export type OrderWithModificationsFragment = {
    id: string;
    state: string;
    subTotal: number;
    subTotalWithTax: number;
    shipping: number;
    shippingWithTax: number;
    total: number;
    totalWithTax: number;
    lines: Array<{
        id: string;
        quantity: number;
        orderPlacedQuantity: number;
        linePrice: number;
        linePriceWithTax: number;
        unitPriceWithTax: number;
        discountedLinePriceWithTax: number;
        proratedLinePriceWithTax: number;
        proratedUnitPriceWithTax: number;
        discounts: Array<{ description: string; amountWithTax: number }>;
        productVariant: { id: string; name: string };
    }>;
    surcharges: Array<{
        id: string;
        description: string;
        sku?: string | null;
        price: number;
        priceWithTax: number;
        taxRate: number;
    }>;
    payments?: Array<{
        id: string;
        transactionId?: string | null;
        state: string;
        amount: number;
        method: string;
        metadata?: any | null;
        refunds: Array<{ id: string; state: string; total: number; paymentId: string }>;
    }> | null;
    modifications: Array<{
        id: string;
        note: string;
        priceChange: number;
        isSettled: boolean;
        lines: Array<{ orderLineId: string; quantity: number }>;
        surcharges?: Array<{ id: string }> | null;
        payment?: { id: string; state: string; amount: number; method: string } | null;
        refund?: { id: string; state: string; total: number; paymentId: string } | null;
    }>;
    promotions: Array<{ id: string; name: string; couponCode?: string | null }>;
    discounts: Array<{
        description: string;
        adjustmentSource: string;
        amount: number;
        amountWithTax: number;
    }>;
    shippingAddress?: {
        streetLine1?: string | null;
        city?: string | null;
        postalCode?: string | null;
        province?: string | null;
        countryCode?: string | null;
        country?: string | null;
    } | null;
    billingAddress?: {
        streetLine1?: string | null;
        city?: string | null;
        postalCode?: string | null;
        province?: string | null;
        countryCode?: string | null;
        country?: string | null;
    } | null;
    shippingLines: Array<{
        id: string;
        discountedPriceWithTax: number;
        shippingMethod: { id: string; name: string };
    }>;
};

export type GetOrderWithModificationsQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetOrderWithModificationsQuery = {
    order?: {
        id: string;
        state: string;
        subTotal: number;
        subTotalWithTax: number;
        shipping: number;
        shippingWithTax: number;
        total: number;
        totalWithTax: number;
        lines: Array<{
            id: string;
            quantity: number;
            orderPlacedQuantity: number;
            linePrice: number;
            linePriceWithTax: number;
            unitPriceWithTax: number;
            discountedLinePriceWithTax: number;
            proratedLinePriceWithTax: number;
            proratedUnitPriceWithTax: number;
            discounts: Array<{ description: string; amountWithTax: number }>;
            productVariant: { id: string; name: string };
        }>;
        surcharges: Array<{
            id: string;
            description: string;
            sku?: string | null;
            price: number;
            priceWithTax: number;
            taxRate: number;
        }>;
        payments?: Array<{
            id: string;
            transactionId?: string | null;
            state: string;
            amount: number;
            method: string;
            metadata?: any | null;
            refunds: Array<{ id: string; state: string; total: number; paymentId: string }>;
        }> | null;
        modifications: Array<{
            id: string;
            note: string;
            priceChange: number;
            isSettled: boolean;
            lines: Array<{ orderLineId: string; quantity: number }>;
            surcharges?: Array<{ id: string }> | null;
            payment?: { id: string; state: string; amount: number; method: string } | null;
            refund?: { id: string; state: string; total: number; paymentId: string } | null;
        }>;
        promotions: Array<{ id: string; name: string; couponCode?: string | null }>;
        discounts: Array<{
            description: string;
            adjustmentSource: string;
            amount: number;
            amountWithTax: number;
        }>;
        shippingAddress?: {
            streetLine1?: string | null;
            city?: string | null;
            postalCode?: string | null;
            province?: string | null;
            countryCode?: string | null;
            country?: string | null;
        } | null;
        billingAddress?: {
            streetLine1?: string | null;
            city?: string | null;
            postalCode?: string | null;
            province?: string | null;
            countryCode?: string | null;
            country?: string | null;
        } | null;
        shippingLines: Array<{
            id: string;
            discountedPriceWithTax: number;
            shippingMethod: { id: string; name: string };
        }>;
    } | null;
};

export type ModifyOrderMutationVariables = Exact<{
    input: ModifyOrderInput;
}>;

export type ModifyOrderMutation = {
    modifyOrder:
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string }
        | {
              id: string;
              state: string;
              subTotal: number;
              subTotalWithTax: number;
              shipping: number;
              shippingWithTax: number;
              total: number;
              totalWithTax: number;
              lines: Array<{
                  id: string;
                  quantity: number;
                  orderPlacedQuantity: number;
                  linePrice: number;
                  linePriceWithTax: number;
                  unitPriceWithTax: number;
                  discountedLinePriceWithTax: number;
                  proratedLinePriceWithTax: number;
                  proratedUnitPriceWithTax: number;
                  discounts: Array<{ description: string; amountWithTax: number }>;
                  productVariant: { id: string; name: string };
              }>;
              surcharges: Array<{
                  id: string;
                  description: string;
                  sku?: string | null;
                  price: number;
                  priceWithTax: number;
                  taxRate: number;
              }>;
              payments?: Array<{
                  id: string;
                  transactionId?: string | null;
                  state: string;
                  amount: number;
                  method: string;
                  metadata?: any | null;
                  refunds: Array<{ id: string; state: string; total: number; paymentId: string }>;
              }> | null;
              modifications: Array<{
                  id: string;
                  note: string;
                  priceChange: number;
                  isSettled: boolean;
                  lines: Array<{ orderLineId: string; quantity: number }>;
                  surcharges?: Array<{ id: string }> | null;
                  payment?: { id: string; state: string; amount: number; method: string } | null;
                  refund?: { id: string; state: string; total: number; paymentId: string } | null;
              }>;
              promotions: Array<{ id: string; name: string; couponCode?: string | null }>;
              discounts: Array<{
                  description: string;
                  adjustmentSource: string;
                  amount: number;
                  amountWithTax: number;
              }>;
              shippingAddress?: {
                  streetLine1?: string | null;
                  city?: string | null;
                  postalCode?: string | null;
                  province?: string | null;
                  countryCode?: string | null;
                  country?: string | null;
              } | null;
              billingAddress?: {
                  streetLine1?: string | null;
                  city?: string | null;
                  postalCode?: string | null;
                  province?: string | null;
                  countryCode?: string | null;
                  country?: string | null;
              } | null;
              shippingLines: Array<{
                  id: string;
                  discountedPriceWithTax: number;
                  shippingMethod: { id: string; name: string };
              }>;
          }
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string };
};

export type AddManualPaymentMutationVariables = Exact<{
    input: ManualPaymentInput;
}>;

export type AddManualPaymentMutation = {
    addManualPaymentToOrder:
        | { errorCode: ErrorCode; message: string }
        | {
              id: string;
              state: string;
              subTotal: number;
              subTotalWithTax: number;
              shipping: number;
              shippingWithTax: number;
              total: number;
              totalWithTax: number;
              lines: Array<{
                  id: string;
                  quantity: number;
                  orderPlacedQuantity: number;
                  linePrice: number;
                  linePriceWithTax: number;
                  unitPriceWithTax: number;
                  discountedLinePriceWithTax: number;
                  proratedLinePriceWithTax: number;
                  proratedUnitPriceWithTax: number;
                  discounts: Array<{ description: string; amountWithTax: number }>;
                  productVariant: { id: string; name: string };
              }>;
              surcharges: Array<{
                  id: string;
                  description: string;
                  sku?: string | null;
                  price: number;
                  priceWithTax: number;
                  taxRate: number;
              }>;
              payments?: Array<{
                  id: string;
                  transactionId?: string | null;
                  state: string;
                  amount: number;
                  method: string;
                  metadata?: any | null;
                  refunds: Array<{ id: string; state: string; total: number; paymentId: string }>;
              }> | null;
              modifications: Array<{
                  id: string;
                  note: string;
                  priceChange: number;
                  isSettled: boolean;
                  lines: Array<{ orderLineId: string; quantity: number }>;
                  surcharges?: Array<{ id: string }> | null;
                  payment?: { id: string; state: string; amount: number; method: string } | null;
                  refund?: { id: string; state: string; total: number; paymentId: string } | null;
              }>;
              promotions: Array<{ id: string; name: string; couponCode?: string | null }>;
              discounts: Array<{
                  description: string;
                  adjustmentSource: string;
                  amount: number;
                  amountWithTax: number;
              }>;
              shippingAddress?: {
                  streetLine1?: string | null;
                  city?: string | null;
                  postalCode?: string | null;
                  province?: string | null;
                  countryCode?: string | null;
                  country?: string | null;
              } | null;
              billingAddress?: {
                  streetLine1?: string | null;
                  city?: string | null;
                  postalCode?: string | null;
                  province?: string | null;
                  countryCode?: string | null;
                  country?: string | null;
              } | null;
              shippingLines: Array<{
                  id: string;
                  discountedPriceWithTax: number;
                  shippingMethod: { id: string; name: string };
              }>;
          };
};

export type DeletePromotionAdHoc1MutationVariables = Exact<{ [key: string]: never }>;

export type DeletePromotionAdHoc1Mutation = { deletePromotion: { result: DeletionResult } };

export type GetTaxRateListQueryVariables = Exact<{
    options?: InputMaybe<TaxRateListOptions>;
}>;

export type GetTaxRateListQuery = {
    taxRates: {
        totalItems: number;
        items: Array<{
            id: string;
            name: string;
            enabled: boolean;
            value: number;
            category: { id: string; name: string };
            zone: { id: string; name: string };
        }>;
    };
};

export type GetOrderWithLineCalculatedPropsQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetOrderWithLineCalculatedPropsQuery = {
    order?: { id: string; lines: Array<{ id: string; linePriceWithTax: number; quantity: number }> } | null;
};

export type GetOrderListFulfillmentsQueryVariables = Exact<{ [key: string]: never }>;

export type GetOrderListFulfillmentsQuery = {
    orders: {
        items: Array<{
            id: string;
            state: string;
            fulfillments?: Array<{
                id: string;
                state: string;
                nextStates: Array<string>;
                method: string;
            }> | null;
        }>;
    };
};

export type GetOrderFulfillmentItemsQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetOrderFulfillmentItemsQuery = {
    order?: {
        id: string;
        state: string;
        fulfillments?: Array<{
            id: string;
            state: string;
            nextStates: Array<string>;
            method: string;
            trackingCode?: string | null;
            lines: Array<{ orderLineId: string; quantity: number }>;
        }> | null;
    } | null;
};

export type RefundFragment = {
    id: string;
    state: string;
    items: number;
    transactionId?: string | null;
    shipping: number;
    total: number;
    metadata?: any | null;
};

export type RefundOrderMutationVariables = Exact<{
    input: RefundOrderInput;
}>;

export type RefundOrderMutation = {
    refundOrder:
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string }
        | {
              id: string;
              state: string;
              items: number;
              transactionId?: string | null;
              shipping: number;
              total: number;
              metadata?: any | null;
          }
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string }
        | { errorCode: ErrorCode; message: string };
};

export type SettleRefundMutationVariables = Exact<{
    input: SettleRefundInput;
}>;

export type SettleRefundMutation = {
    settleRefund:
        | {
              id: string;
              state: string;
              items: number;
              transactionId?: string | null;
              shipping: number;
              total: number;
              metadata?: any | null;
          }
        | { errorCode: ErrorCode; message: string };
};

export type AddNoteToOrderMutationVariables = Exact<{
    input: AddNoteToOrderInput;
}>;

export type AddNoteToOrderMutation = { addNoteToOrder: { id: string } };

export type UpdateOrderNoteMutationVariables = Exact<{
    input: UpdateOrderNoteInput;
}>;

export type UpdateOrderNoteMutation = { updateOrderNote: { id: string; data: any; isPublic: boolean } };

export type DeleteOrderNoteMutationVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type DeleteOrderNoteMutation = {
    deleteOrderNote: { result: DeletionResult; message?: string | null };
};

export type GetOrderWithPaymentsQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetOrderWithPaymentsQuery = {
    order?: {
        id: string;
        payments?: Array<{
            id: string;
            errorMessage?: string | null;
            metadata?: any | null;
            refunds: Array<{ id: string; total: number }>;
        }> | null;
    } | null;
};

export type GetOrderLineFulfillmentsQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetOrderLineFulfillmentsQuery = {
    order?: {
        id: string;
        lines: Array<{
            id: string;
            fulfillmentLines?: Array<{
                orderLineId: string;
                quantity: number;
                fulfillment: { id: string; state: string };
            }> | null;
        }>;
    } | null;
};

export type GetOrderListWithQtyQueryVariables = Exact<{
    options?: InputMaybe<OrderListOptions>;
}>;

export type GetOrderListWithQtyQuery = {
    orders: {
        items: Array<{
            id: string;
            code: string;
            totalQuantity: number;
            lines: Array<{ id: string; quantity: number }>;
        }>;
    };
};

export type CancelPaymentMutationVariables = Exact<{
    paymentId: Scalars['ID']['input'];
}>;

export type CancelPaymentMutation = {
    cancelPayment:
        | { errorCode: ErrorCode; message: string; paymentErrorMessage: string }
        | {
              id: string;
              transactionId?: string | null;
              amount: number;
              method: string;
              state: string;
              nextStates: Array<string>;
              metadata?: any | null;
              refunds: Array<{ id: string; total: number; reason?: string | null }>;
          }
        | { errorCode: ErrorCode; message: string; transitionError: string };
};

export type SetOrderCustomerMutationVariables = Exact<{
    input: SetOrderCustomerInput;
}>;

export type SetOrderCustomerMutation = {
    setOrderCustomer?: { id: string; customer?: { id: string } | null } | null;
};

export type PaymentMethodFragment = {
    id: string;
    code: string;
    name: string;
    description: string;
    enabled: boolean;
    checker?: { code: string; args: Array<{ name: string; value: string }> } | null;
    handler: { code: string; args: Array<{ name: string; value: string }> };
    translations: Array<{ id: string; languageCode: LanguageCode; name: string; description: string }>;
};

export type CreatePaymentMethodMutationVariables = Exact<{
    input: CreatePaymentMethodInput;
}>;

export type CreatePaymentMethodMutation = {
    createPaymentMethod: {
        id: string;
        code: string;
        name: string;
        description: string;
        enabled: boolean;
        checker?: { code: string; args: Array<{ name: string; value: string }> } | null;
        handler: { code: string; args: Array<{ name: string; value: string }> };
        translations: Array<{ id: string; languageCode: LanguageCode; name: string; description: string }>;
    };
};

export type UpdatePaymentMethodMutationVariables = Exact<{
    input: UpdatePaymentMethodInput;
}>;

export type UpdatePaymentMethodMutation = {
    updatePaymentMethod: {
        id: string;
        code: string;
        name: string;
        description: string;
        enabled: boolean;
        checker?: { code: string; args: Array<{ name: string; value: string }> } | null;
        handler: { code: string; args: Array<{ name: string; value: string }> };
        translations: Array<{ id: string; languageCode: LanguageCode; name: string; description: string }>;
    };
};

export type GetPaymentMethodHandlersQueryVariables = Exact<{ [key: string]: never }>;

export type GetPaymentMethodHandlersQuery = {
    paymentMethodHandlers: Array<{ code: string; args: Array<{ name: string; type: string }> }>;
};

export type GetPaymentMethodCheckersQueryVariables = Exact<{ [key: string]: never }>;

export type GetPaymentMethodCheckersQuery = {
    paymentMethodEligibilityCheckers: Array<{ code: string; args: Array<{ name: string; type: string }> }>;
};

export type GetPaymentMethodQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetPaymentMethodQuery = {
    paymentMethod?: {
        id: string;
        code: string;
        name: string;
        description: string;
        enabled: boolean;
        checker?: { code: string; args: Array<{ name: string; value: string }> } | null;
        handler: { code: string; args: Array<{ name: string; value: string }> };
        translations: Array<{ id: string; languageCode: LanguageCode; name: string; description: string }>;
    } | null;
};

export type GetPaymentMethodListQueryVariables = Exact<{
    options?: InputMaybe<PaymentMethodListOptions>;
}>;

export type GetPaymentMethodListQuery = {
    paymentMethods: {
        totalItems: number;
        items: Array<{
            id: string;
            code: string;
            name: string;
            description: string;
            enabled: boolean;
            checker?: { code: string; args: Array<{ name: string; value: string }> } | null;
            handler: { code: string; args: Array<{ name: string; value: string }> };
            translations: Array<{
                id: string;
                languageCode: LanguageCode;
                name: string;
                description: string;
            }>;
        }>;
    };
};

export type DeletePaymentMethodMutationVariables = Exact<{
    id: Scalars['ID']['input'];
    force?: InputMaybe<Scalars['Boolean']['input']>;
}>;

export type DeletePaymentMethodMutation = {
    deletePaymentMethod: { message?: string | null; result: DeletionResult };
};

export type AddManualPayment2MutationVariables = Exact<{
    input: ManualPaymentInput;
}>;

export type AddManualPayment2Mutation = {
    addManualPaymentToOrder:
        | { errorCode: ErrorCode; message: string }
        | {
              id: string;
              createdAt: any;
              updatedAt: any;
              code: string;
              state: string;
              active: boolean;
              subTotal: number;
              subTotalWithTax: number;
              total: number;
              totalWithTax: number;
              totalQuantity: number;
              currencyCode: CurrencyCode;
              shipping: number;
              shippingWithTax: number;
              customer?: { id: string; firstName: string; lastName: string } | null;
              lines: Array<{
                  id: string;
                  unitPrice: number;
                  unitPriceWithTax: number;
                  quantity: number;
                  taxRate: number;
                  linePriceWithTax: number;
                  featuredAsset?: { preview: string } | null;
                  productVariant: { id: string; name: string; sku: string };
                  taxLines: Array<{ description: string; taxRate: number }>;
              }>;
              surcharges: Array<{
                  id: string;
                  description: string;
                  sku?: string | null;
                  price: number;
                  priceWithTax: number;
              }>;
              shippingLines: Array<{
                  priceWithTax: number;
                  shippingMethod: { id: string; code: string; name: string; description: string };
              }>;
              shippingAddress?: {
                  fullName?: string | null;
                  company?: string | null;
                  streetLine1?: string | null;
                  streetLine2?: string | null;
                  city?: string | null;
                  province?: string | null;
                  postalCode?: string | null;
                  country?: string | null;
                  phoneNumber?: string | null;
              } | null;
              payments?: Array<{
                  id: string;
                  transactionId?: string | null;
                  amount: number;
                  method: string;
                  state: string;
                  nextStates: Array<string>;
                  metadata?: any | null;
                  refunds: Array<{ id: string; total: number; reason?: string | null }>;
              }> | null;
              fulfillments?: Array<{
                  id: string;
                  state: string;
                  method: string;
                  trackingCode?: string | null;
                  lines: Array<{ orderLineId: string; quantity: number }>;
              }> | null;
          };
};

export type GetProductOptionGroupQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetProductOptionGroupQuery = {
    productOptionGroup?: {
        id: string;
        code: string;
        name: string;
        options: Array<{ id: string; code: string; name: string }>;
    } | null;
};

export type UpdateProductOptionGroupMutationVariables = Exact<{
    input: UpdateProductOptionGroupInput;
}>;

export type UpdateProductOptionGroupMutation = {
    updateProductOptionGroup: {
        id: string;
        code: string;
        name: string;
        options: Array<{ id: string; code: string; name: string }>;
        translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
    };
};

export type CreateProductOptionMutationVariables = Exact<{
    input: CreateProductOptionInput;
}>;

export type CreateProductOptionMutation = {
    createProductOption: {
        id: string;
        code: string;
        name: string;
        groupId: string;
        translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
    };
};

export type UpdateProductOptionMutationVariables = Exact<{
    input: UpdateProductOptionInput;
}>;

export type UpdateProductOptionMutation = {
    updateProductOption: { id: string; code: string; name: string; groupId: string };
};

export type DeleteProductOptionMutationVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type DeleteProductOptionMutation = {
    deleteProductOption: { result: DeletionResult; message?: string | null };
};

export type RemoveOptionGroupFromProductMutationVariables = Exact<{
    productId: Scalars['ID']['input'];
    optionGroupId: Scalars['ID']['input'];
    force?: InputMaybe<Scalars['Boolean']['input']>;
}>;

export type RemoveOptionGroupFromProductMutation = {
    removeOptionGroupFromProduct:
        | {
              id: string;
              optionGroups: Array<{ id: string; code: string; options: Array<{ id: string; code: string }> }>;
          }
        | { errorCode: ErrorCode; message: string; optionGroupCode: string; productVariantCount: number };
};

export type GetOptionGroupQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetOptionGroupQuery = {
    productOptionGroup?: { id: string; code: string; options: Array<{ id: string; code: string }> } | null;
};

export type GetProductVariantQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetProductVariantQuery = { productVariant?: { id: string; name: string } | null };

export type GetProductWithVariantListQueryVariables = Exact<{
    id?: InputMaybe<Scalars['ID']['input']>;
    variantListOptions?: InputMaybe<ProductVariantListOptions>;
}>;

export type GetProductWithVariantListQuery = {
    product?: {
        id: string;
        variantList: {
            totalItems: number;
            items: Array<{
                id: string;
                createdAt: any;
                updatedAt: any;
                enabled: boolean;
                languageCode: LanguageCode;
                name: string;
                currencyCode: CurrencyCode;
                price: number;
                priceWithTax: number;
                stockOnHand: number;
                trackInventory: GlobalFlag;
                sku: string;
                prices: Array<{ currencyCode: CurrencyCode; price: number }>;
                taxRateApplied: { id: string; name: string; value: number };
                taxCategory: { id: string; name: string };
                options: Array<{
                    id: string;
                    code: string;
                    languageCode: LanguageCode;
                    groupId: string;
                    name: string;
                }>;
                facetValues: Array<{
                    id: string;
                    code: string;
                    name: string;
                    facet: { id: string; name: string };
                }>;
                featuredAsset?: {
                    id: string;
                    name: string;
                    fileSize: number;
                    mimeType: string;
                    type: AssetType;
                    preview: string;
                    source: string;
                } | null;
                assets: Array<{
                    id: string;
                    name: string;
                    fileSize: number;
                    mimeType: string;
                    type: AssetType;
                    preview: string;
                    source: string;
                }>;
                translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
                channels: Array<{ id: string; code: string }>;
            }>;
        };
    } | null;
};

export type GetPromotionListQueryVariables = Exact<{
    options?: InputMaybe<PromotionListOptions>;
}>;

export type GetPromotionListQuery = {
    promotions: {
        totalItems: number;
        items: Array<{
            id: string;
            createdAt: any;
            updatedAt: any;
            couponCode?: string | null;
            startsAt?: any | null;
            endsAt?: any | null;
            name: string;
            description: string;
            enabled: boolean;
            perCustomerUsageLimit?: number | null;
            usageLimit?: number | null;
            conditions: Array<{ code: string; args: Array<{ name: string; value: string }> }>;
            actions: Array<{ code: string; args: Array<{ name: string; value: string }> }>;
            translations: Array<{
                id: string;
                languageCode: LanguageCode;
                name: string;
                description: string;
            }>;
        }>;
    };
};

export type UpdatePromotionMutationVariables = Exact<{
    input: UpdatePromotionInput;
}>;

export type UpdatePromotionMutation = {
    updatePromotion:
        | { errorCode: ErrorCode; message: string }
        | {
              id: string;
              createdAt: any;
              updatedAt: any;
              couponCode?: string | null;
              startsAt?: any | null;
              endsAt?: any | null;
              name: string;
              description: string;
              enabled: boolean;
              perCustomerUsageLimit?: number | null;
              usageLimit?: number | null;
              conditions: Array<{ code: string; args: Array<{ name: string; value: string }> }>;
              actions: Array<{ code: string; args: Array<{ name: string; value: string }> }>;
              translations: Array<{
                  id: string;
                  languageCode: LanguageCode;
                  name: string;
                  description: string;
              }>;
          };
};

export type ConfigurableOperationDefFragment = {
    code: string;
    description: string;
    args: Array<{ name: string; type: string; ui?: any | null }>;
};

export type GetAdjustmentOperationsQueryVariables = Exact<{ [key: string]: never }>;

export type GetAdjustmentOperationsQuery = {
    promotionActions: Array<{
        code: string;
        description: string;
        args: Array<{ name: string; type: string; ui?: any | null }>;
    }>;
    promotionConditions: Array<{
        code: string;
        description: string;
        args: Array<{ name: string; type: string; ui?: any | null }>;
    }>;
};

export type GetRolesQueryVariables = Exact<{
    options?: InputMaybe<RoleListOptions>;
}>;

export type GetRolesQuery = {
    roles: {
        totalItems: number;
        items: Array<{
            id: string;
            code: string;
            description: string;
            permissions: Array<Permission>;
            channels: Array<{ id: string; code: string; token: string }>;
        }>;
    };
};

export type GetRoleQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetRoleQuery = {
    role?: {
        id: string;
        code: string;
        description: string;
        permissions: Array<Permission>;
        channels: Array<{ id: string; code: string; token: string }>;
    } | null;
};

export type DeleteRoleMutationVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type DeleteRoleMutation = { deleteRole: { result: DeletionResult; message?: string | null } };

export type LogoutMutationVariables = Exact<{ [key: string]: never }>;

export type LogoutMutation = { logout: { success: boolean } };

export type GetShippingMethodQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetShippingMethodQuery = {
    shippingMethod?: {
        id: string;
        code: string;
        name: string;
        description: string;
        calculator: { code: string; args: Array<{ name: string; value: string }> };
        checker: { code: string; args: Array<{ name: string; value: string }> };
    } | null;
};

export type GetEligibilityCheckersQueryVariables = Exact<{ [key: string]: never }>;

export type GetEligibilityCheckersQuery = {
    shippingEligibilityCheckers: Array<{
        code: string;
        description: string;
        args: Array<{
            name: string;
            type: string;
            description?: string | null;
            label?: string | null;
            ui?: any | null;
        }>;
    }>;
};

export type GetCalculatorsQueryVariables = Exact<{ [key: string]: never }>;

export type GetCalculatorsQuery = {
    shippingCalculators: Array<{
        code: string;
        description: string;
        args: Array<{
            name: string;
            type: string;
            description?: string | null;
            label?: string | null;
            ui?: any | null;
        }>;
    }>;
};

export type TestShippingMethodQueryVariables = Exact<{
    input: TestShippingMethodInput;
}>;

export type TestShippingMethodQuery = {
    testShippingMethod: {
        eligible: boolean;
        quote?: { price: number; priceWithTax: number; metadata?: any | null } | null;
    };
};

export type TestEligibleMethodsQueryVariables = Exact<{
    input: TestEligibleShippingMethodsInput;
}>;

export type TestEligibleMethodsQuery = {
    testEligibleShippingMethods: Array<{
        id: string;
        name: string;
        description: string;
        price: number;
        priceWithTax: number;
        metadata?: any | null;
    }>;
};

export type GetMeQueryVariables = Exact<{ [key: string]: never }>;

export type GetMeQuery = { me?: { identifier: string } | null };

export type GetProductsTake3QueryVariables = Exact<{ [key: string]: never }>;

export type GetProductsTake3Query = { products: { items: Array<{ id: string }> } };

export type GetProduct1QueryVariables = Exact<{ [key: string]: never }>;

export type GetProduct1Query = { product?: { id: string } | null };

export type GetProduct2VariantsQueryVariables = Exact<{ [key: string]: never }>;

export type GetProduct2VariantsQuery = {
    product?: { id: string; variants: Array<{ id: string; name: string }> } | null;
};

export type GetProductCollectionQueryVariables = Exact<{ [key: string]: never }>;

export type GetProductCollectionQuery = {
    product?: { collections: Array<{ id: string; name: string }> } | null;
};

export type GetCollectionShopQueryVariables = Exact<{
    id?: InputMaybe<Scalars['ID']['input']>;
    slug?: InputMaybe<Scalars['String']['input']>;
}>;

export type GetCollectionShopQuery = {
    collection?: {
        id: string;
        name: string;
        slug: string;
        description: string;
        parent?: { id: string; name: string } | null;
        children?: Array<{ id: string; name: string }> | null;
    } | null;
};

export type DisableProductMutationVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type DisableProductMutation = { updateProduct: { id: string } };

export type GetCollectionVariantsQueryVariables = Exact<{
    id?: InputMaybe<Scalars['ID']['input']>;
    slug?: InputMaybe<Scalars['String']['input']>;
}>;

export type GetCollectionVariantsQuery = {
    collection?: { id: string; productVariants: { items: Array<{ id: string; name: string }> } } | null;
};

export type GetCollectionListQueryVariables = Exact<{ [key: string]: never }>;

export type GetCollectionListQuery = { collections: { items: Array<{ id: string; name: string }> } };

export type GetProductFacetValuesQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetProductFacetValuesQuery = {
    product?: { id: string; name: string; facetValues: Array<{ name: string }> } | null;
};

export type GetVariantFacetValuesQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetVariantFacetValuesQuery = {
    product?: {
        id: string;
        name: string;
        variants: Array<{ id: string; facetValues: Array<{ name: string }> }>;
    } | null;
};

export type GetCustomerIdsQueryVariables = Exact<{ [key: string]: never }>;

export type GetCustomerIdsQuery = { customers: { items: Array<{ id: string }> } };

export type StockLocationFragment = { id: string; name: string; description: string };

export type GetStockLocationQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetStockLocationQuery = {
    stockLocation?: { id: string; name: string; description: string } | null;
};

export type GetStockLocationsQueryVariables = Exact<{
    options?: InputMaybe<StockLocationListOptions>;
}>;

export type GetStockLocationsQuery = {
    stockLocations: { totalItems: number; items: Array<{ id: string; name: string; description: string }> };
};

export type CreateStockLocationMutationVariables = Exact<{
    input: CreateStockLocationInput;
}>;

export type CreateStockLocationMutation = {
    createStockLocation: { id: string; name: string; description: string };
};

export type UpdateStockLocationMutationVariables = Exact<{
    input: UpdateStockLocationInput;
}>;

export type UpdateStockLocationMutation = {
    updateStockLocation: { id: string; name: string; description: string };
};

export type GetVariantStockLevelsQueryVariables = Exact<{
    options?: InputMaybe<ProductVariantListOptions>;
}>;

export type GetVariantStockLevelsQuery = {
    productVariants: {
        items: Array<{
            id: string;
            name: string;
            stockOnHand: number;
            stockAllocated: number;
            stockLevels: Array<{ stockLocationId: string; stockOnHand: number; stockAllocated: number }>;
        }>;
    };
};

export type UpdateStockMutationVariables = Exact<{
    input: Array<UpdateProductVariantInput> | UpdateProductVariantInput;
}>;

export type UpdateStockMutation = {
    updateProductVariants: Array<{
        id: string;
        stockOnHand: number;
        stockAllocated: number;
        stockMovements: {
            totalItems: number;
            items: Array<
                | { id: string; type: StockMovementType; quantity: number }
                | { id: string; type: StockMovementType; quantity: number }
                | { id: string; type: StockMovementType; quantity: number }
                | { id: string; type: StockMovementType; quantity: number }
                | { id: string; type: StockMovementType; quantity: number }
                | { id: string; type: StockMovementType; quantity: number }
            >;
        };
    } | null>;
};

export type TransitionFulfillmentToStateMutationVariables = Exact<{
    id: Scalars['ID']['input'];
    state: Scalars['String']['input'];
}>;

export type TransitionFulfillmentToStateMutation = {
    transitionFulfillmentToState:
        | { id: string; state: string; nextStates: Array<string>; createdAt: any }
        | { errorCode: ErrorCode; message: string; transitionError: string };
};

export type UpdateOrderCustomFieldsMutationVariables = Exact<{
    input: UpdateOrderInput;
}>;

export type UpdateOrderCustomFieldsMutation = { setOrderCustomFields?: { id: string } | null };

export type TestGetStockLocationsListQueryVariables = Exact<{
    options?: InputMaybe<StockLocationListOptions>;
}>;

export type TestGetStockLocationsListQuery = {
    stockLocations: { totalItems: number; items: Array<{ id: string; name: string; description: string }> };
};

export type TestGetStockLocationQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type TestGetStockLocationQuery = {
    stockLocation?: { id: string; name: string; description: string } | null;
};

export type TestCreateStockLocationMutationVariables = Exact<{
    input: CreateStockLocationInput;
}>;

export type TestCreateStockLocationMutation = {
    createStockLocation: { id: string; name: string; description: string };
};

export type TestUpdateStockLocationMutationVariables = Exact<{
    input: UpdateStockLocationInput;
}>;

export type TestUpdateStockLocationMutation = {
    updateStockLocation: { id: string; name: string; description: string };
};

export type TestDeleteStockLocationMutationVariables = Exact<{
    input: DeleteStockLocationInput;
}>;

export type TestDeleteStockLocationMutation = {
    deleteStockLocation: { result: DeletionResult; message?: string | null };
};

export type TestGetStockLevelsForVariantQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type TestGetStockLevelsForVariantQuery = {
    productVariant?: {
        id: string;
        stockLevels: Array<{ stockOnHand: number; stockAllocated: number; stockLocationId: string }>;
    } | null;
};

export type TestSetStockLevelInLocationMutationVariables = Exact<{
    input: UpdateProductVariantInput;
}>;

export type TestSetStockLevelInLocationMutation = {
    updateProductVariants: Array<{
        id: string;
        stockLevels: Array<{ stockOnHand: number; stockAllocated: number; stockLocationId: string }>;
    } | null>;
};

export type TestAssignStockLocationToChannelMutationVariables = Exact<{
    input: AssignStockLocationsToChannelInput;
}>;

export type TestAssignStockLocationToChannelMutation = {
    assignStockLocationsToChannel: Array<{ id: string; name: string }>;
};

export type TestRemoveStockLocationsFromChannelMutationVariables = Exact<{
    input: RemoveStockLocationsFromChannelInput;
}>;

export type TestRemoveStockLocationsFromChannelMutation = {
    removeStockLocationsFromChannel: Array<{ id: string; name: string }>;
};

export type GetTagListQueryVariables = Exact<{
    options?: InputMaybe<TagListOptions>;
}>;

export type GetTagListQuery = { tags: { totalItems: number; items: Array<{ id: string; value: string }> } };

export type GetTagQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetTagQuery = { tag: { id: string; value: string } };

export type CreateTagMutationVariables = Exact<{
    input: CreateTagInput;
}>;

export type CreateTagMutation = { createTag: { id: string; value: string } };

export type UpdateTagMutationVariables = Exact<{
    input: UpdateTagInput;
}>;

export type UpdateTagMutation = { updateTag: { id: string; value: string } };

export type DeleteTagMutationVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type DeleteTagMutation = { deleteTag: { message?: string | null; result: DeletionResult } };

export type GetTaxCategoryListQueryVariables = Exact<{ [key: string]: never }>;

export type GetTaxCategoryListQuery = {
    taxCategories: { items: Array<{ id: string; name: string; isDefault: boolean }> };
};

export type GetTaxCategoryQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetTaxCategoryQuery = { taxCategory?: { id: string; name: string; isDefault: boolean } | null };

export type CreateTaxCategoryMutationVariables = Exact<{
    input: CreateTaxCategoryInput;
}>;

export type CreateTaxCategoryMutation = {
    createTaxCategory: { id: string; name: string; isDefault: boolean };
};

export type UpdateTaxCategoryMutationVariables = Exact<{
    input: UpdateTaxCategoryInput;
}>;

export type UpdateTaxCategoryMutation = {
    updateTaxCategory: { id: string; name: string; isDefault: boolean };
};

export type DeleteTaxCategoryMutationVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type DeleteTaxCategoryMutation = {
    deleteTaxCategory: { result: DeletionResult; message?: string | null };
};

export type GetTaxRateQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetTaxRateQuery = {
    taxRate?: {
        id: string;
        name: string;
        enabled: boolean;
        value: number;
        category: { id: string; name: string };
        zone: { id: string; name: string };
        customerGroup?: { id: string; name: string } | null;
    } | null;
};

export type CreateTaxRateMutationVariables = Exact<{
    input: CreateTaxRateInput;
}>;

export type CreateTaxRateMutation = {
    createTaxRate: {
        id: string;
        name: string;
        enabled: boolean;
        value: number;
        category: { id: string; name: string };
        zone: { id: string; name: string };
        customerGroup?: { id: string; name: string } | null;
    };
};

export type DeleteTaxRateMutationVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type DeleteTaxRateMutation = { deleteTaxRate: { result: DeletionResult; message?: string | null } };

export type DeleteZoneMutationVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type DeleteZoneMutation = { deleteZone: { result: DeletionResult; message?: string | null } };

export type GetZonesQueryVariables = Exact<{
    options?: InputMaybe<ZoneListOptions>;
}>;

export type GetZonesQuery = { zones: { totalItems: number; items: Array<{ id: string; name: string }> } };

export type GetZoneQueryVariables = Exact<{
    id: Scalars['ID']['input'];
}>;

export type GetZoneQuery = {
    zone?: {
        id: string;
        name: string;
        members: Array<
            | {
                  id: string;
                  code: string;
                  name: string;
                  enabled: boolean;
                  translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
              }
            | {
                  id: string;
                  code: string;
                  name: string;
                  enabled: boolean;
                  translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
              }
        >;
    } | null;
};

export type GetActiveChannelWithZoneMembersQueryVariables = Exact<{ [key: string]: never }>;

export type GetActiveChannelWithZoneMembersQuery = {
    activeChannel: {
        id: string;
        defaultShippingZone?: { id: string; members: Array<{ name: string } | { name: string }> } | null;
    };
};

export type CreateZoneMutationVariables = Exact<{
    input: CreateZoneInput;
}>;

export type CreateZoneMutation = {
    createZone: {
        id: string;
        name: string;
        members: Array<
            | {
                  id: string;
                  code: string;
                  name: string;
                  enabled: boolean;
                  translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
              }
            | {
                  id: string;
                  code: string;
                  name: string;
                  enabled: boolean;
                  translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
              }
        >;
    };
};

export type UpdateZoneMutationVariables = Exact<{
    input: UpdateZoneInput;
}>;

export type UpdateZoneMutation = {
    updateZone: {
        id: string;
        name: string;
        members: Array<
            | {
                  id: string;
                  code: string;
                  name: string;
                  enabled: boolean;
                  translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
              }
            | {
                  id: string;
                  code: string;
                  name: string;
                  enabled: boolean;
                  translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
              }
        >;
    };
};

export type AddMembersToZoneMutationVariables = Exact<{
    zoneId: Scalars['ID']['input'];
    memberIds: Array<Scalars['ID']['input']> | Scalars['ID']['input'];
}>;

export type AddMembersToZoneMutation = {
    addMembersToZone: {
        id: string;
        name: string;
        members: Array<
            | {
                  id: string;
                  code: string;
                  name: string;
                  enabled: boolean;
                  translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
              }
            | {
                  id: string;
                  code: string;
                  name: string;
                  enabled: boolean;
                  translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
              }
        >;
    };
};

export type RemoveMembersFromZoneMutationVariables = Exact<{
    zoneId: Scalars['ID']['input'];
    memberIds: Array<Scalars['ID']['input']> | Scalars['ID']['input'];
}>;

export type RemoveMembersFromZoneMutation = {
    removeMembersFromZone: {
        id: string;
        name: string;
        members: Array<
            | {
                  id: string;
                  code: string;
                  name: string;
                  enabled: boolean;
                  translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
              }
            | {
                  id: string;
                  code: string;
                  name: string;
                  enabled: boolean;
                  translations: Array<{ id: string; languageCode: LanguageCode; name: string }>;
              }
        >;
    };
};

export const ProdFragmentFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ProdFragment' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Product' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'featuredAsset' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'Field', name: { kind: 'Name', value: 'id' } }],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<ProdFragmentFragment, unknown>;
export const ProdFragment2FragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ProdFragment2' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Product' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'featuredAsset' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'Field', name: { kind: 'Name', value: 'id' } }],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<ProdFragment2Fragment, unknown>;
export const ProdFragment1FragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ProdFragment1' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Product' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'ProdFragment2' } }],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ProdFragment2' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Product' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'featuredAsset' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'Field', name: { kind: 'Name', value: 'id' } }],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<ProdFragment1Fragment, unknown>;
export const ProdFragment3_1FragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ProdFragment3_1' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Product' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'featuredAsset' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'Field', name: { kind: 'Name', value: 'id' } }],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<ProdFragment3_1Fragment, unknown>;
export const ProdFragment2_1FragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ProdFragment2_1' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Product' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'ProdFragment3_1' } }],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ProdFragment3_1' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Product' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'featuredAsset' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'Field', name: { kind: 'Name', value: 'id' } }],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<ProdFragment2_1Fragment, unknown>;
export const ProdFragment1_1FragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ProdFragment1_1' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Product' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'ProdFragment2_1' } }],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ProdFragment3_1' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Product' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'featuredAsset' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'Field', name: { kind: 'Name', value: 'id' } }],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ProdFragment2_1' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Product' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'ProdFragment3_1' } }],
            },
        },
    ],
} as unknown as DocumentNode<ProdFragment1_1Fragment, unknown>;
export const AdministratorFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Administrator' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Administrator' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'firstName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'lastName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'emailAddress' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'user' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'identifier' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'lastLogin' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'roles' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'permissions' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<AdministratorFragment, unknown>;
export const AssetFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Asset' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Asset' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'fileSize' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'mimeType' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'type' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'preview' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'source' } },
                ],
            },
        },
    ],
} as unknown as DocumentNode<AssetFragment, unknown>;
export const ProductVariantFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ProductVariant' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'ProductVariant' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'createdAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'updatedAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'enabled' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'currencyCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'price' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'prices' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'currencyCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'price' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'stockOnHand' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'trackInventory' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'taxRateApplied' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'value' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'taxCategory' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'options' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'groupId' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'facetValues' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'facet' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'featuredAsset' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'assets' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'translations' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'channels' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Asset' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Asset' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'fileSize' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'mimeType' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'type' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'preview' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'source' } },
                ],
            },
        },
    ],
} as unknown as DocumentNode<ProductVariantFragment, unknown>;
export const ProductWithVariantsFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ProductWithVariants' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Product' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'enabled' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'slug' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'featuredAsset' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'assets' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'translations' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'slug' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'optionGroups' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'variants' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'ProductVariant' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'facetValues' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'facet' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'channels' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Asset' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Asset' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'fileSize' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'mimeType' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'type' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'preview' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'source' } },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ProductVariant' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'ProductVariant' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'createdAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'updatedAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'enabled' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'currencyCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'price' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'prices' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'currencyCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'price' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'stockOnHand' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'trackInventory' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'taxRateApplied' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'value' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'taxCategory' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'options' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'groupId' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'facetValues' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'facet' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'featuredAsset' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'assets' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'translations' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'channels' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<ProductWithVariantsFragment, unknown>;
export const RoleFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Role' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Role' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'permissions' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'channels' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'token' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<RoleFragment, unknown>;
export const ConfigurableOperationFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ConfigurableOperation' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'ConfigurableOperation' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'args' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'value' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                ],
            },
        },
    ],
} as unknown as DocumentNode<ConfigurableOperationFragment, unknown>;
export const CollectionFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Collection' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Collection' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'slug' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'isPrivate' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'featuredAsset' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'assets' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'filters' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'FragmentSpread',
                                    name: { kind: 'Name', value: 'ConfigurableOperation' },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'translations' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'slug' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'parent' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'children' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'position' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Asset' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Asset' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'fileSize' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'mimeType' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'type' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'preview' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'source' } },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ConfigurableOperation' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'ConfigurableOperation' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'args' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'value' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                ],
            },
        },
    ],
} as unknown as DocumentNode<CollectionFragment, unknown>;
export const FacetValueFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'FacetValue' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'FacetValue' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'translations' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'facet' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<FacetValueFragment, unknown>;
export const FacetWithValuesFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'FacetWithValues' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Facet' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'isPrivate' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'translations' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'values' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'FacetValue' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'FacetValue' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'FacetValue' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'translations' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'facet' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<FacetWithValuesFragment, unknown>;
export const AddressFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Address' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Address' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'fullName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'company' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine1' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine2' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'city' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'province' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'postalCode' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'country' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'phoneNumber' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'defaultShippingAddress' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'defaultBillingAddress' } },
                ],
            },
        },
    ],
} as unknown as DocumentNode<AddressFragment, unknown>;
export const CustomerFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Customer' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Customer' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'title' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'firstName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'lastName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'phoneNumber' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'emailAddress' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'user' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'identifier' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'verified' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'lastLogin' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'addresses' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'Address' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Address' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Address' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'fullName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'company' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine1' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine2' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'city' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'province' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'postalCode' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'country' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'phoneNumber' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'defaultShippingAddress' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'defaultBillingAddress' } },
                ],
            },
        },
    ],
} as unknown as DocumentNode<CustomerFragment, unknown>;
export const AdjustmentFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Adjustment' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Adjustment' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'adjustmentSource' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'amount' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'type' } },
                ],
            },
        },
    ],
} as unknown as DocumentNode<AdjustmentFragment, unknown>;
export const OrderFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Order' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Order' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'createdAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'updatedAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'active' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'totalWithTax' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'totalQuantity' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'currencyCode' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'customer' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'firstName' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'lastName' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<OrderFragment, unknown>;
export const ShippingAddressFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ShippingAddress' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'OrderAddress' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'fullName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'company' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine1' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine2' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'city' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'province' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'postalCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'country' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'phoneNumber' } },
                ],
            },
        },
    ],
} as unknown as DocumentNode<ShippingAddressFragment, unknown>;
export const PaymentFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Payment' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Payment' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'transactionId' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'amount' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'method' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'nextStates' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'metadata' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'refunds' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'reason' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<PaymentFragment, unknown>;
export const OrderWithLinesFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'OrderWithLines' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Order' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'createdAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'updatedAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'active' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'customer' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'firstName' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'lastName' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'lines' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'featuredAsset' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'preview' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'productVariant' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'taxLines' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'taxRate' } },
                                        ],
                                    },
                                },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPrice' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPriceWithTax' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'quantity' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPrice' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPriceWithTax' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'taxRate' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'linePriceWithTax' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'surcharges' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'price' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'subTotal' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'subTotalWithTax' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'totalWithTax' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'totalQuantity' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'currencyCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'shipping' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'shippingWithTax' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'shippingLines' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'shippingMethod' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'shippingAddress' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'ShippingAddress' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'payments' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'Payment' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'fulfillments' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'method' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'trackingCode' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'lines' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'orderLineId' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'quantity' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ShippingAddress' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'OrderAddress' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'fullName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'company' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine1' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine2' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'city' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'province' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'postalCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'country' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'phoneNumber' } },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Payment' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Payment' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'transactionId' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'amount' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'method' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'nextStates' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'metadata' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'refunds' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'reason' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<OrderWithLinesFragment, unknown>;
export const PromotionFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Promotion' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Promotion' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'createdAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'updatedAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'couponCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'startsAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'endsAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'enabled' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'perCustomerUsageLimit' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'usageLimit' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'conditions' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'FragmentSpread',
                                    name: { kind: 'Name', value: 'ConfigurableOperation' },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'actions' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'FragmentSpread',
                                    name: { kind: 'Name', value: 'ConfigurableOperation' },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'translations' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ConfigurableOperation' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'ConfigurableOperation' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'args' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'value' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                ],
            },
        },
    ],
} as unknown as DocumentNode<PromotionFragment, unknown>;
export const CountryFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Country' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Region' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'enabled' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'translations' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<CountryFragment, unknown>;
export const ZoneFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Zone' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Zone' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'members' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'Country' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Country' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Region' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'enabled' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'translations' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<ZoneFragment, unknown>;
export const TaxRateFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'TaxRate' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'TaxRate' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'enabled' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'value' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'category' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'zone' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'customerGroup' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<TaxRateFragment, unknown>;
export const CurrentUserFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'CurrentUser' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'CurrentUser' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'identifier' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'channels' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'token' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'permissions' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<CurrentUserFragment, unknown>;
export const VariantWithStockFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'VariantWithStock' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'ProductVariant' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'stockOnHand' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'stockAllocated' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'stockMovements' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'items' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            {
                                                kind: 'InlineFragment',
                                                typeCondition: {
                                                    kind: 'NamedType',
                                                    name: { kind: 'Name', value: 'StockMovement' },
                                                },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'id' },
                                                        },
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'type' },
                                                        },
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'quantity' },
                                                        },
                                                    ],
                                                },
                                            },
                                        ],
                                    },
                                },
                                { kind: 'Field', name: { kind: 'Name', value: 'totalItems' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<VariantWithStockFragment, unknown>;
export const FulfillmentFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Fulfillment' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Fulfillment' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'nextStates' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'method' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'trackingCode' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'lines' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'orderLineId' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'quantity' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<FulfillmentFragment, unknown>;
export const ChannelFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Channel' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Channel' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'token' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'currencyCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'availableCurrencyCodes' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'defaultCurrencyCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'defaultLanguageCode' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'defaultShippingZone' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'Field', name: { kind: 'Name', value: 'id' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'defaultTaxZone' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'Field', name: { kind: 'Name', value: 'id' } }],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'pricesIncludeTax' } },
                ],
            },
        },
    ],
} as unknown as DocumentNode<ChannelFragment, unknown>;
export const GlobalSettingsFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'GlobalSettings' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'GlobalSettings' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'availableLanguages' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'trackInventory' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'outOfStockThreshold' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'serverConfig' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'orderProcess' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'to' } },
                                        ],
                                    },
                                },
                                { kind: 'Field', name: { kind: 'Name', value: 'permittedAssetTypes' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'permissions' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'assignable' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'customFieldConfig' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'Customer' },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'InlineFragment',
                                                            typeCondition: {
                                                                kind: 'NamedType',
                                                                name: { kind: 'Name', value: 'CustomField' },
                                                            },
                                                            selectionSet: {
                                                                kind: 'SelectionSet',
                                                                selections: [
                                                                    {
                                                                        kind: 'Field',
                                                                        name: { kind: 'Name', value: 'name' },
                                                                    },
                                                                ],
                                                            },
                                                        },
                                                    ],
                                                },
                                            },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GlobalSettingsFragment, unknown>;
export const CustomerGroupFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'CustomerGroup' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'CustomerGroup' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'customers' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'items' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [{ kind: 'Field', name: { kind: 'Name', value: 'id' } }],
                                    },
                                },
                                { kind: 'Field', name: { kind: 'Name', value: 'totalItems' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<CustomerGroupFragment, unknown>;
export const ProductOptionGroupFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ProductOptionGroup' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'ProductOptionGroup' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'options' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'translations' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<ProductOptionGroupFragment, unknown>;
export const ProductWithOptionsFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ProductWithOptions' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Product' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'optionGroups' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'options' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<ProductWithOptionsFragment, unknown>;
export const ShippingMethodFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ShippingMethod' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'ShippingMethod' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'calculator' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'args' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'value' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'checker' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'args' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'value' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<ShippingMethodFragment, unknown>;
export const CanceledOrderFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'CanceledOrder' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Order' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'lines' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'quantity' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<CanceledOrderFragment, unknown>;
export const AssetFragFirstFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'AssetFragFirst' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Asset' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'preview' } },
                ],
            },
        },
    ],
} as unknown as DocumentNode<AssetFragFirstFragment, unknown>;
export const AssetWithTagsAndFocalPointFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'AssetWithTagsAndFocalPoint' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Asset' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'focalPoint' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'x' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'y' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'tags' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'value' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Asset' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Asset' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'fileSize' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'mimeType' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'type' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'preview' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'source' } },
                ],
            },
        },
    ],
} as unknown as DocumentNode<AssetWithTagsAndFocalPointFragment, unknown>;
export const OrderWithModificationsFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'OrderWithModifications' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Order' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'subTotal' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'subTotalWithTax' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'shipping' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'shippingWithTax' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'totalWithTax' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'lines' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'quantity' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'orderPlacedQuantity' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'linePrice' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'linePriceWithTax' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPriceWithTax' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'discountedLinePriceWithTax' },
                                },
                                { kind: 'Field', name: { kind: 'Name', value: 'proratedLinePriceWithTax' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'proratedUnitPriceWithTax' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'discounts' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'amountWithTax' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'productVariant' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'surcharges' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'price' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'taxRate' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'payments' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'transactionId' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'amount' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'method' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'metadata' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'refunds' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'paymentId' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'modifications' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'note' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'priceChange' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'isSettled' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'lines' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'orderLineId' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'quantity' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'surcharges' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [{ kind: 'Field', name: { kind: 'Name', value: 'id' } }],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'payment' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'amount' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'method' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'refund' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'paymentId' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'promotions' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'couponCode' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'discounts' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'adjustmentSource' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'amount' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'amountWithTax' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'shippingAddress' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'streetLine1' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'city' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'postalCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'province' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'countryCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'country' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'billingAddress' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'streetLine1' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'city' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'postalCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'province' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'countryCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'country' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'shippingLines' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'discountedPriceWithTax' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'shippingMethod' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<OrderWithModificationsFragment, unknown>;
export const RefundFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Refund' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Refund' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'items' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'transactionId' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'shipping' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'metadata' } },
                ],
            },
        },
    ],
} as unknown as DocumentNode<RefundFragment, unknown>;
export const PaymentMethodFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'PaymentMethod' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'PaymentMethod' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'enabled' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'checker' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'args' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'value' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'handler' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'args' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'value' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'translations' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<PaymentMethodFragment, unknown>;
export const ConfigurableOperationDefFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ConfigurableOperationDef' },
            typeCondition: {
                kind: 'NamedType',
                name: { kind: 'Name', value: 'ConfigurableOperationDefinition' },
            },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'args' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'type' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'ui' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                ],
            },
        },
    ],
} as unknown as DocumentNode<ConfigurableOperationDefFragment, unknown>;
export const StockLocationFragmentDoc = {
    kind: 'Document',
    definitions: [
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'StockLocation' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'StockLocation' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                ],
            },
        },
    ],
} as unknown as DocumentNode<StockLocationFragment, unknown>;
export const GetAdministratorsDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetAdministrators' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'options' } },
                    type: { kind: 'NamedType', name: { kind: 'Name', value: 'AdministratorListOptions' } },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'administrators' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'options' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'options' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'items' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            {
                                                kind: 'FragmentSpread',
                                                name: { kind: 'Name', value: 'Administrator' },
                                            },
                                        ],
                                    },
                                },
                                { kind: 'Field', name: { kind: 'Name', value: 'totalItems' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Administrator' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Administrator' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'firstName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'lastName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'emailAddress' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'user' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'identifier' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'lastLogin' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'roles' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'permissions' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetAdministratorsQuery, GetAdministratorsQueryVariables>;
export const GetAdministratorDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetAdministrator' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'administrator' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'id' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'Administrator' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Administrator' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Administrator' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'firstName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'lastName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'emailAddress' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'user' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'identifier' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'lastLogin' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'roles' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'permissions' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetAdministratorQuery, GetAdministratorQueryVariables>;
export const ActiveAdministratorDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'ActiveAdministrator' },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'activeAdministrator' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'Administrator' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Administrator' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Administrator' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'firstName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'lastName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'emailAddress' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'user' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'identifier' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'lastLogin' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'roles' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'permissions' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<ActiveAdministratorQuery, ActiveAdministratorQueryVariables>;
export const UpdateActiveAdministratorDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'UpdateActiveAdministrator' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: {
                            kind: 'NamedType',
                            name: { kind: 'Name', value: 'UpdateActiveAdministratorInput' },
                        },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'updateActiveAdministrator' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'Administrator' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Administrator' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Administrator' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'firstName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'lastName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'emailAddress' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'user' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'identifier' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'lastLogin' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'roles' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'permissions' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<UpdateActiveAdministratorMutation, UpdateActiveAdministratorMutationVariables>;
export const DeleteAdministratorDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'DeleteAdministrator' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'deleteAdministrator' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'id' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'message' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'result' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<DeleteAdministratorMutation, DeleteAdministratorMutationVariables>;
export const Q1Document = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'Q1' },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'product' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'id' },
                                value: { kind: 'StringValue', value: 'T_1', block: false },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<Q1Query, Q1QueryVariables>;
export const Q2Document = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'Q2' },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'product' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'id' },
                                value: { kind: 'StringValue', value: 'T_1', block: false },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<Q2Query, Q2QueryVariables>;
export const GetCollectionWithAssetsDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetCollectionWithAssets' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'collection' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'id' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'featuredAsset' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            {
                                                kind: 'FragmentSpread',
                                                name: { kind: 'Name', value: 'Asset' },
                                            },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'assets' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            {
                                                kind: 'FragmentSpread',
                                                name: { kind: 'Name', value: 'Asset' },
                                            },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Asset' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Asset' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'fileSize' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'mimeType' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'type' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'preview' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'source' } },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetCollectionWithAssetsQuery, GetCollectionWithAssetsQueryVariables>;
export const AssignAssetsToChannelDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'assignAssetsToChannel' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: {
                            kind: 'NamedType',
                            name: { kind: 'Name', value: 'AssignAssetsToChannelInput' },
                        },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'assignAssetsToChannel' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Asset' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Asset' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'fileSize' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'mimeType' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'type' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'preview' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'source' } },
                ],
            },
        },
    ],
} as unknown as DocumentNode<AssignAssetsToChannelMutation, AssignAssetsToChannelMutationVariables>;
export const CanCreateCustomerDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'CanCreateCustomer' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'CreateCustomerInput' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'createCustomer' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'InlineFragment',
                                    typeCondition: {
                                        kind: 'NamedType',
                                        name: { kind: 'Name', value: 'Customer' },
                                    },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [{ kind: 'Field', name: { kind: 'Name', value: 'id' } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<CanCreateCustomerMutation, CanCreateCustomerMutationVariables>;
export const GetCustomerCountDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetCustomerCount' },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'customers' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'Field', name: { kind: 'Name', value: 'totalItems' } }],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetCustomerCountQuery, GetCustomerCountQueryVariables>;
export const DeepFieldResolutionTestQueryDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'DeepFieldResolutionTestQuery' },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'product' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'id' },
                                value: { kind: 'StringValue', value: 'T_1', block: false },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'variants' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'taxRateApplied' },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'customerGroup' },
                                                            selectionSet: {
                                                                kind: 'SelectionSet',
                                                                selections: [
                                                                    {
                                                                        kind: 'Field',
                                                                        name: {
                                                                            kind: 'Name',
                                                                            value: 'customers',
                                                                        },
                                                                        selectionSet: {
                                                                            kind: 'SelectionSet',
                                                                            selections: [
                                                                                {
                                                                                    kind: 'Field',
                                                                                    name: {
                                                                                        kind: 'Name',
                                                                                        value: 'items',
                                                                                    },
                                                                                    selectionSet: {
                                                                                        kind: 'SelectionSet',
                                                                                        selections: [
                                                                                            {
                                                                                                kind: 'Field',
                                                                                                name: {
                                                                                                    kind: 'Name',
                                                                                                    value: 'id',
                                                                                                },
                                                                                            },
                                                                                            {
                                                                                                kind: 'Field',
                                                                                                name: {
                                                                                                    kind: 'Name',
                                                                                                    value: 'emailAddress',
                                                                                                },
                                                                                            },
                                                                                        ],
                                                                                    },
                                                                                },
                                                                            ],
                                                                        },
                                                                    },
                                                                ],
                                                            },
                                                        },
                                                    ],
                                                },
                                            },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<DeepFieldResolutionTestQueryQuery, DeepFieldResolutionTestQueryQueryVariables>;
export const AuthenticateDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'Authenticate' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'AuthenticationInput' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'authenticate' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'CurrentUser' } },
                                {
                                    kind: 'InlineFragment',
                                    typeCondition: {
                                        kind: 'NamedType',
                                        name: { kind: 'Name', value: 'InvalidCredentialsError' },
                                    },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'authenticationError' },
                                            },
                                            { kind: 'Field', name: { kind: 'Name', value: 'errorCode' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'message' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'CurrentUser' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'CurrentUser' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'identifier' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'channels' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'token' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'permissions' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<AuthenticateMutation, AuthenticateMutationVariables>;
export const GetCustomersDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetCustomers' },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'customers' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'totalItems' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'items' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'emailAddress' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetCustomersQuery, GetCustomersQueryVariables>;
export const GetCustomerUserAuthDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetCustomerUserAuth' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'customer' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'id' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'user' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'verified' } },
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'authenticationMethods' },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'id' },
                                                        },
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'strategy' },
                                                        },
                                                    ],
                                                },
                                            },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetCustomerUserAuthQuery, GetCustomerUserAuthQueryVariables>;
export const DeleteChannelDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'DeleteChannel' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'deleteChannel' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'id' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'message' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'result' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<DeleteChannelMutation, DeleteChannelMutationVariables>;
export const GetChannelDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetChannel' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'channel' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'id' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'token' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'defaultCurrencyCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'availableCurrencyCodes' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'defaultLanguageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'availableLanguageCodes' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'outOfStockThreshold' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'pricesIncludeTax' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetChannelQuery, GetChannelQueryVariables>;
export const UpdateGlobalLanguagesDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'UpdateGlobalLanguages' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: {
                            kind: 'NamedType',
                            name: { kind: 'Name', value: 'UpdateGlobalSettingsInput' },
                        },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'updateGlobalSettings' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'InlineFragment',
                                    typeCondition: {
                                        kind: 'NamedType',
                                        name: { kind: 'Name', value: 'GlobalSettings' },
                                    },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'availableLanguages' },
                                            },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<UpdateGlobalLanguagesMutation, UpdateGlobalLanguagesMutationVariables>;
export const GetCollectionsWithAssetsDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetCollectionsWithAssets' },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'collections' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'items' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'assets' },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'name' },
                                                        },
                                                    ],
                                                },
                                            },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetCollectionsWithAssetsQuery, GetCollectionsWithAssetsQueryVariables>;
export const GetProductsWithVariantIdsDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetProductsWithVariantIds' },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'products' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'options' },
                                value: {
                                    kind: 'ObjectValue',
                                    fields: [
                                        {
                                            kind: 'ObjectField',
                                            name: { kind: 'Name', value: 'sort' },
                                            value: {
                                                kind: 'ObjectValue',
                                                fields: [
                                                    {
                                                        kind: 'ObjectField',
                                                        name: { kind: 'Name', value: 'id' },
                                                        value: { kind: 'EnumValue', value: 'ASC' },
                                                    },
                                                ],
                                            },
                                        },
                                    ],
                                },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'items' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'variants' },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'id' },
                                                        },
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'name' },
                                                        },
                                                    ],
                                                },
                                            },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetProductsWithVariantIdsQuery, GetProductsWithVariantIdsQueryVariables>;
export const GetCollectionListAdminDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetCollectionListAdmin' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'options' } },
                    type: { kind: 'NamedType', name: { kind: 'Name', value: 'CollectionListOptions' } },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'collections' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'options' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'options' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'items' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            {
                                                kind: 'FragmentSpread',
                                                name: { kind: 'Name', value: 'Collection' },
                                            },
                                        ],
                                    },
                                },
                                { kind: 'Field', name: { kind: 'Name', value: 'totalItems' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Asset' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Asset' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'fileSize' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'mimeType' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'type' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'preview' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'source' } },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ConfigurableOperation' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'ConfigurableOperation' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'args' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'value' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Collection' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Collection' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'slug' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'isPrivate' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'featuredAsset' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'assets' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'filters' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'FragmentSpread',
                                    name: { kind: 'Name', value: 'ConfigurableOperation' },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'translations' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'slug' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'parent' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'children' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'position' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetCollectionListAdminQuery, GetCollectionListAdminQueryVariables>;
export const MoveCollectionDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'MoveCollection' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'MoveCollectionInput' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'moveCollection' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'Collection' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Asset' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Asset' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'fileSize' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'mimeType' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'type' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'preview' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'source' } },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ConfigurableOperation' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'ConfigurableOperation' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'args' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'value' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Collection' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Collection' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'slug' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'isPrivate' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'featuredAsset' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'assets' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'filters' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'FragmentSpread',
                                    name: { kind: 'Name', value: 'ConfigurableOperation' },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'translations' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'slug' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'parent' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'children' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'position' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<MoveCollectionMutation, MoveCollectionMutationVariables>;
export const GetFacetValuesDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetFacetValues' },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'facets' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'items' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'values' },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'FragmentSpread',
                                                            name: { kind: 'Name', value: 'FacetValue' },
                                                        },
                                                    ],
                                                },
                                            },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'FacetValue' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'FacetValue' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'translations' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'facet' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetFacetValuesQuery, GetFacetValuesQueryVariables>;
export const GetCollectionProductsDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetCollectionProducts' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'collection' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'id' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'productVariants' },
                                    arguments: [
                                        {
                                            kind: 'Argument',
                                            name: { kind: 'Name', value: 'options' },
                                            value: {
                                                kind: 'ObjectValue',
                                                fields: [
                                                    {
                                                        kind: 'ObjectField',
                                                        name: { kind: 'Name', value: 'sort' },
                                                        value: {
                                                            kind: 'ObjectValue',
                                                            fields: [
                                                                {
                                                                    kind: 'ObjectField',
                                                                    name: { kind: 'Name', value: 'id' },
                                                                    value: {
                                                                        kind: 'EnumValue',
                                                                        value: 'ASC',
                                                                    },
                                                                },
                                                            ],
                                                        },
                                                    },
                                                ],
                                            },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'items' },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'id' },
                                                        },
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'name' },
                                                        },
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'facetValues' },
                                                            selectionSet: {
                                                                kind: 'SelectionSet',
                                                                selections: [
                                                                    {
                                                                        kind: 'Field',
                                                                        name: { kind: 'Name', value: 'code' },
                                                                    },
                                                                ],
                                                            },
                                                        },
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'productId' },
                                                        },
                                                    ],
                                                },
                                            },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetCollectionProductsQuery, GetCollectionProductsQueryVariables>;
export const CreateCollectionSelectVariantsDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'CreateCollectionSelectVariants' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'CreateCollectionInput' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'createCollection' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'productVariants' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'items' },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'name' },
                                                        },
                                                    ],
                                                },
                                            },
                                            { kind: 'Field', name: { kind: 'Name', value: 'totalItems' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<
    CreateCollectionSelectVariantsMutation,
    CreateCollectionSelectVariantsMutationVariables
>;
export const GetCollectionBreadcrumbsDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetCollectionBreadcrumbs' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'collection' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'id' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'breadcrumbs' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'slug' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetCollectionBreadcrumbsQuery, GetCollectionBreadcrumbsQueryVariables>;
export const GetCollectionsForProductsDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetCollectionsForProducts' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'term' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'String' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'products' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'options' },
                                value: {
                                    kind: 'ObjectValue',
                                    fields: [
                                        {
                                            kind: 'ObjectField',
                                            name: { kind: 'Name', value: 'filter' },
                                            value: {
                                                kind: 'ObjectValue',
                                                fields: [
                                                    {
                                                        kind: 'ObjectField',
                                                        name: { kind: 'Name', value: 'name' },
                                                        value: {
                                                            kind: 'ObjectValue',
                                                            fields: [
                                                                {
                                                                    kind: 'ObjectField',
                                                                    name: { kind: 'Name', value: 'contains' },
                                                                    value: {
                                                                        kind: 'Variable',
                                                                        name: { kind: 'Name', value: 'term' },
                                                                    },
                                                                },
                                                            ],
                                                        },
                                                    },
                                                ],
                                            },
                                        },
                                    ],
                                },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'items' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'collections' },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'id' },
                                                        },
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'name' },
                                                        },
                                                    ],
                                                },
                                            },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetCollectionsForProductsQuery, GetCollectionsForProductsQueryVariables>;
export const DeleteCollectionDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'DeleteCollection' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'deleteCollection' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'id' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'result' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'message' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<DeleteCollectionMutation, DeleteCollectionMutationVariables>;
export const GetProductCollectionsDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetProductCollections' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'product' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'id' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'collections' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetProductCollectionsQuery, GetProductCollectionsQueryVariables>;
export const GetProductCollectionsWithParentDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetProductCollectionsWithParent' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'product' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'id' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'collections' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'parent' },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'id' },
                                                        },
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'name' },
                                                        },
                                                    ],
                                                },
                                            },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<
    GetProductCollectionsWithParentQuery,
    GetProductCollectionsWithParentQueryVariables
>;
export const GetCollectionNestedParentsDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetCollectionNestedParents' },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'collections' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'items' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'parent' },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'name' },
                                                        },
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'parent' },
                                                            selectionSet: {
                                                                kind: 'SelectionSet',
                                                                selections: [
                                                                    {
                                                                        kind: 'Field',
                                                                        name: { kind: 'Name', value: 'name' },
                                                                    },
                                                                    {
                                                                        kind: 'Field',
                                                                        name: {
                                                                            kind: 'Name',
                                                                            value: 'parent',
                                                                        },
                                                                        selectionSet: {
                                                                            kind: 'SelectionSet',
                                                                            selections: [
                                                                                {
                                                                                    kind: 'Field',
                                                                                    name: {
                                                                                        kind: 'Name',
                                                                                        value: 'name',
                                                                                    },
                                                                                },
                                                                            ],
                                                                        },
                                                                    },
                                                                ],
                                                            },
                                                        },
                                                    ],
                                                },
                                            },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetCollectionNestedParentsQuery, GetCollectionNestedParentsQueryVariables>;
export const PreviewCollectionVariantsDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'PreviewCollectionVariants' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: {
                            kind: 'NamedType',
                            name: { kind: 'Name', value: 'PreviewCollectionVariantsInput' },
                        },
                    },
                },
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'options' } },
                    type: { kind: 'NamedType', name: { kind: 'Name', value: 'ProductVariantListOptions' } },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'previewCollectionVariants' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'options' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'options' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'items' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                        ],
                                    },
                                },
                                { kind: 'Field', name: { kind: 'Name', value: 'totalItems' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<PreviewCollectionVariantsQuery, PreviewCollectionVariantsQueryVariables>;
export const RemoveCollectionsFromChannelDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'RemoveCollectionsFromChannel' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: {
                            kind: 'NamedType',
                            name: { kind: 'Name', value: 'RemoveCollectionsFromChannelInput' },
                        },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'removeCollectionsFromChannel' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'Collection' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Asset' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Asset' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'fileSize' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'mimeType' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'type' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'preview' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'source' } },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ConfigurableOperation' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'ConfigurableOperation' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'args' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'value' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Collection' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Collection' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'slug' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'isPrivate' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'featuredAsset' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'assets' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'filters' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'FragmentSpread',
                                    name: { kind: 'Name', value: 'ConfigurableOperation' },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'translations' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'slug' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'parent' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'children' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'position' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<
    RemoveCollectionsFromChannelMutation,
    RemoveCollectionsFromChannelMutationVariables
>;
export const DeleteCollectionsBulkDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'DeleteCollectionsBulk' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'ids' } },
                    type: {
                        kind: 'NonNullType',
                        type: {
                            kind: 'ListType',
                            type: {
                                kind: 'NonNullType',
                                type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                            },
                        },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'deleteCollections' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'ids' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'ids' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'message' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'result' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<DeleteCollectionsBulkMutation, DeleteCollectionsBulkMutationVariables>;
export const GetCheckersDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetCheckers' },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'shippingEligibilityCheckers' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'args' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'defaultValue' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'label' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'list' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'required' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'type' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetCheckersQuery, GetCheckersQueryVariables>;
export const DeleteCountryDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'DeleteCountry' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'deleteCountry' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'id' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'result' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'message' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<DeleteCountryMutation, DeleteCountryMutationVariables>;
export const GetCountryDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetCountry' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'country' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'id' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'Country' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Country' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Region' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'enabled' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'translations' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetCountryQuery, GetCountryQueryVariables>;
export const CreateCountryDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'CreateCountry' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'CreateCountryInput' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'createCountry' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'Country' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Country' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Region' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'enabled' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'translations' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<CreateCountryMutation, CreateCountryMutationVariables>;
export const DeleteCustomerAddressDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'DeleteCustomerAddress' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'deleteCustomerAddress' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'id' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'Field', name: { kind: 'Name', value: 'success' } }],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<DeleteCustomerAddressMutation, DeleteCustomerAddressMutationVariables>;
export const GetCustomerWithUserDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetCustomerWithUser' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'customer' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'id' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'user' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'identifier' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'verified' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetCustomerWithUserQuery, GetCustomerWithUserQueryVariables>;
export const GetCustomerOrdersDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetCustomerOrders' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'customer' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'id' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'orders' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'items' },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'id' },
                                                        },
                                                    ],
                                                },
                                            },
                                            { kind: 'Field', name: { kind: 'Name', value: 'totalItems' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetCustomerOrdersQuery, GetCustomerOrdersQueryVariables>;
export const AddNoteToCustomerDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'AddNoteToCustomer' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'AddNoteToCustomerInput' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'addNoteToCustomer' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'Customer' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Address' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Address' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'fullName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'company' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine1' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine2' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'city' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'province' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'postalCode' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'country' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'phoneNumber' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'defaultShippingAddress' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'defaultBillingAddress' } },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Customer' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Customer' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'title' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'firstName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'lastName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'phoneNumber' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'emailAddress' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'user' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'identifier' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'verified' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'lastLogin' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'addresses' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'Address' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<AddNoteToCustomerMutation, AddNoteToCustomerMutationVariables>;
export const ReindexDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'Reindex' },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'reindex' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'Field', name: { kind: 'Name', value: 'id' } }],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<ReindexMutation, ReindexMutationVariables>;
export const SearchFacetValuesDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'SearchFacetValues' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'SearchInput' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'search' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'totalItems' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'facetValues' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'count' } },
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'facetValue' },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'id' },
                                                        },
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'name' },
                                                        },
                                                    ],
                                                },
                                            },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<SearchFacetValuesQuery, SearchFacetValuesQueryVariables>;
export const SearchCollectionsDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'SearchCollections' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'SearchInput' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'search' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'totalItems' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'collections' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'count' } },
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'collection' },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'id' },
                                                        },
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'name' },
                                                        },
                                                    ],
                                                },
                                            },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<SearchCollectionsQuery, SearchCollectionsQueryVariables>;
export const SearchGetAssetsDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'SearchGetAssets' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'SearchInput' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'search' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'totalItems' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'items' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'productId' } },
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'productVariantId' },
                                            },
                                            { kind: 'Field', name: { kind: 'Name', value: 'productName' } },
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'productVariantName' },
                                            },
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'productAsset' },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'id' },
                                                        },
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'preview' },
                                                        },
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'focalPoint' },
                                                            selectionSet: {
                                                                kind: 'SelectionSet',
                                                                selections: [
                                                                    {
                                                                        kind: 'Field',
                                                                        name: { kind: 'Name', value: 'x' },
                                                                    },
                                                                    {
                                                                        kind: 'Field',
                                                                        name: { kind: 'Name', value: 'y' },
                                                                    },
                                                                ],
                                                            },
                                                        },
                                                    ],
                                                },
                                            },
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'productVariantAsset' },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'id' },
                                                        },
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'preview' },
                                                        },
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'focalPoint' },
                                                            selectionSet: {
                                                                kind: 'SelectionSet',
                                                                selections: [
                                                                    {
                                                                        kind: 'Field',
                                                                        name: { kind: 'Name', value: 'x' },
                                                                    },
                                                                    {
                                                                        kind: 'Field',
                                                                        name: { kind: 'Name', value: 'y' },
                                                                    },
                                                                ],
                                                            },
                                                        },
                                                    ],
                                                },
                                            },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<SearchGetAssetsQuery, SearchGetAssetsQueryVariables>;
export const SearchGetPricesDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'SearchGetPrices' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'SearchInput' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'search' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'items' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'price' },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'InlineFragment',
                                                            typeCondition: {
                                                                kind: 'NamedType',
                                                                name: { kind: 'Name', value: 'PriceRange' },
                                                            },
                                                            selectionSet: {
                                                                kind: 'SelectionSet',
                                                                selections: [
                                                                    {
                                                                        kind: 'Field',
                                                                        name: { kind: 'Name', value: 'min' },
                                                                    },
                                                                    {
                                                                        kind: 'Field',
                                                                        name: { kind: 'Name', value: 'max' },
                                                                    },
                                                                ],
                                                            },
                                                        },
                                                        {
                                                            kind: 'InlineFragment',
                                                            typeCondition: {
                                                                kind: 'NamedType',
                                                                name: { kind: 'Name', value: 'SinglePrice' },
                                                            },
                                                            selectionSet: {
                                                                kind: 'SelectionSet',
                                                                selections: [
                                                                    {
                                                                        kind: 'Field',
                                                                        name: {
                                                                            kind: 'Name',
                                                                            value: 'value',
                                                                        },
                                                                    },
                                                                ],
                                                            },
                                                        },
                                                    ],
                                                },
                                            },
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'priceWithTax' },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'InlineFragment',
                                                            typeCondition: {
                                                                kind: 'NamedType',
                                                                name: { kind: 'Name', value: 'PriceRange' },
                                                            },
                                                            selectionSet: {
                                                                kind: 'SelectionSet',
                                                                selections: [
                                                                    {
                                                                        kind: 'Field',
                                                                        name: { kind: 'Name', value: 'min' },
                                                                    },
                                                                    {
                                                                        kind: 'Field',
                                                                        name: { kind: 'Name', value: 'max' },
                                                                    },
                                                                ],
                                                            },
                                                        },
                                                        {
                                                            kind: 'InlineFragment',
                                                            typeCondition: {
                                                                kind: 'NamedType',
                                                                name: { kind: 'Name', value: 'SinglePrice' },
                                                            },
                                                            selectionSet: {
                                                                kind: 'SelectionSet',
                                                                selections: [
                                                                    {
                                                                        kind: 'Field',
                                                                        name: {
                                                                            kind: 'Name',
                                                                            value: 'value',
                                                                        },
                                                                    },
                                                                ],
                                                            },
                                                        },
                                                    ],
                                                },
                                            },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<SearchGetPricesQuery, SearchGetPricesQueryVariables>;
export const CreateDraftOrderDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'CreateDraftOrder' },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'createDraftOrder' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'OrderWithLines' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ShippingAddress' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'OrderAddress' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'fullName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'company' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine1' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine2' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'city' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'province' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'postalCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'country' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'phoneNumber' } },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Payment' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Payment' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'transactionId' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'amount' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'method' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'nextStates' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'metadata' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'refunds' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'reason' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'OrderWithLines' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Order' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'createdAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'updatedAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'active' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'customer' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'firstName' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'lastName' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'lines' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'featuredAsset' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'preview' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'productVariant' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'taxLines' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'taxRate' } },
                                        ],
                                    },
                                },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPrice' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPriceWithTax' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'quantity' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPrice' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPriceWithTax' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'taxRate' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'linePriceWithTax' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'surcharges' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'price' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'subTotal' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'subTotalWithTax' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'totalWithTax' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'totalQuantity' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'currencyCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'shipping' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'shippingWithTax' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'shippingLines' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'shippingMethod' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'shippingAddress' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'ShippingAddress' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'payments' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'Payment' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'fulfillments' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'method' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'trackingCode' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'lines' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'orderLineId' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'quantity' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                ],
            },
        },
    ],
} as unknown as DocumentNode<CreateDraftOrderMutation, CreateDraftOrderMutationVariables>;
export const AddItemToDraftOrderDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'AddItemToDraftOrder' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'orderId' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: {
                            kind: 'NamedType',
                            name: { kind: 'Name', value: 'AddItemToDraftOrderInput' },
                        },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'addItemToDraftOrder' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'orderId' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'orderId' } },
                            },
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'OrderWithLines' } },
                                {
                                    kind: 'InlineFragment',
                                    typeCondition: {
                                        kind: 'NamedType',
                                        name: { kind: 'Name', value: 'ErrorResult' },
                                    },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'errorCode' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'message' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ShippingAddress' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'OrderAddress' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'fullName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'company' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine1' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine2' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'city' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'province' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'postalCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'country' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'phoneNumber' } },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Payment' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Payment' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'transactionId' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'amount' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'method' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'nextStates' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'metadata' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'refunds' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'reason' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'OrderWithLines' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Order' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'createdAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'updatedAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'active' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'customer' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'firstName' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'lastName' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'lines' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'featuredAsset' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'preview' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'productVariant' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'taxLines' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'taxRate' } },
                                        ],
                                    },
                                },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPrice' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPriceWithTax' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'quantity' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPrice' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPriceWithTax' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'taxRate' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'linePriceWithTax' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'surcharges' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'price' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'subTotal' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'subTotalWithTax' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'totalWithTax' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'totalQuantity' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'currencyCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'shipping' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'shippingWithTax' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'shippingLines' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'shippingMethod' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'shippingAddress' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'ShippingAddress' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'payments' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'Payment' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'fulfillments' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'method' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'trackingCode' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'lines' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'orderLineId' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'quantity' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                ],
            },
        },
    ],
} as unknown as DocumentNode<AddItemToDraftOrderMutation, AddItemToDraftOrderMutationVariables>;
export const AdjustDraftOrderLineDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'AdjustDraftOrderLine' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'orderId' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: {
                            kind: 'NamedType',
                            name: { kind: 'Name', value: 'AdjustDraftOrderLineInput' },
                        },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'adjustDraftOrderLine' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'orderId' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'orderId' } },
                            },
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'OrderWithLines' } },
                                {
                                    kind: 'InlineFragment',
                                    typeCondition: {
                                        kind: 'NamedType',
                                        name: { kind: 'Name', value: 'ErrorResult' },
                                    },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'errorCode' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'message' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ShippingAddress' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'OrderAddress' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'fullName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'company' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine1' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine2' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'city' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'province' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'postalCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'country' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'phoneNumber' } },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Payment' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Payment' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'transactionId' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'amount' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'method' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'nextStates' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'metadata' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'refunds' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'reason' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'OrderWithLines' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Order' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'createdAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'updatedAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'active' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'customer' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'firstName' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'lastName' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'lines' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'featuredAsset' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'preview' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'productVariant' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'taxLines' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'taxRate' } },
                                        ],
                                    },
                                },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPrice' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPriceWithTax' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'quantity' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPrice' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPriceWithTax' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'taxRate' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'linePriceWithTax' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'surcharges' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'price' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'subTotal' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'subTotalWithTax' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'totalWithTax' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'totalQuantity' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'currencyCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'shipping' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'shippingWithTax' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'shippingLines' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'shippingMethod' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'shippingAddress' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'ShippingAddress' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'payments' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'Payment' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'fulfillments' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'method' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'trackingCode' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'lines' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'orderLineId' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'quantity' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                ],
            },
        },
    ],
} as unknown as DocumentNode<AdjustDraftOrderLineMutation, AdjustDraftOrderLineMutationVariables>;
export const RemoveDraftOrderLineDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'RemoveDraftOrderLine' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'orderId' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'orderLineId' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'removeDraftOrderLine' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'orderId' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'orderId' } },
                            },
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'orderLineId' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'orderLineId' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'OrderWithLines' } },
                                {
                                    kind: 'InlineFragment',
                                    typeCondition: {
                                        kind: 'NamedType',
                                        name: { kind: 'Name', value: 'ErrorResult' },
                                    },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'errorCode' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'message' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ShippingAddress' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'OrderAddress' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'fullName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'company' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine1' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine2' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'city' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'province' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'postalCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'country' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'phoneNumber' } },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Payment' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Payment' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'transactionId' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'amount' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'method' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'nextStates' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'metadata' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'refunds' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'reason' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'OrderWithLines' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Order' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'createdAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'updatedAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'active' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'customer' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'firstName' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'lastName' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'lines' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'featuredAsset' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'preview' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'productVariant' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'taxLines' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'taxRate' } },
                                        ],
                                    },
                                },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPrice' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPriceWithTax' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'quantity' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPrice' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPriceWithTax' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'taxRate' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'linePriceWithTax' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'surcharges' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'price' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'subTotal' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'subTotalWithTax' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'totalWithTax' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'totalQuantity' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'currencyCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'shipping' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'shippingWithTax' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'shippingLines' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'shippingMethod' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'shippingAddress' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'ShippingAddress' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'payments' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'Payment' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'fulfillments' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'method' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'trackingCode' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'lines' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'orderLineId' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'quantity' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                ],
            },
        },
    ],
} as unknown as DocumentNode<RemoveDraftOrderLineMutation, RemoveDraftOrderLineMutationVariables>;
export const SetCustomerForDraftOrderDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'SetCustomerForDraftOrder' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'orderId' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'customerId' } },
                    type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                },
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: { kind: 'NamedType', name: { kind: 'Name', value: 'CreateCustomerInput' } },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'setCustomerForDraftOrder' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'orderId' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'orderId' } },
                            },
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'customerId' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'customerId' } },
                            },
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'OrderWithLines' } },
                                {
                                    kind: 'InlineFragment',
                                    typeCondition: {
                                        kind: 'NamedType',
                                        name: { kind: 'Name', value: 'ErrorResult' },
                                    },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'errorCode' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'message' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ShippingAddress' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'OrderAddress' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'fullName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'company' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine1' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine2' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'city' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'province' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'postalCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'country' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'phoneNumber' } },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Payment' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Payment' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'transactionId' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'amount' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'method' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'nextStates' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'metadata' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'refunds' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'reason' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'OrderWithLines' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Order' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'createdAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'updatedAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'active' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'customer' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'firstName' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'lastName' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'lines' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'featuredAsset' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'preview' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'productVariant' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'taxLines' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'taxRate' } },
                                        ],
                                    },
                                },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPrice' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPriceWithTax' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'quantity' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPrice' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPriceWithTax' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'taxRate' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'linePriceWithTax' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'surcharges' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'price' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'subTotal' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'subTotalWithTax' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'totalWithTax' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'totalQuantity' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'currencyCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'shipping' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'shippingWithTax' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'shippingLines' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'shippingMethod' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'shippingAddress' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'ShippingAddress' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'payments' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'Payment' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'fulfillments' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'method' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'trackingCode' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'lines' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'orderLineId' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'quantity' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                ],
            },
        },
    ],
} as unknown as DocumentNode<SetCustomerForDraftOrderMutation, SetCustomerForDraftOrderMutationVariables>;
export const SetDraftOrderShippingAddressDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'SetDraftOrderShippingAddress' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'orderId' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'CreateAddressInput' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'setDraftOrderShippingAddress' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'orderId' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'orderId' } },
                            },
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'OrderWithLines' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ShippingAddress' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'OrderAddress' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'fullName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'company' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine1' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine2' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'city' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'province' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'postalCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'country' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'phoneNumber' } },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Payment' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Payment' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'transactionId' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'amount' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'method' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'nextStates' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'metadata' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'refunds' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'reason' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'OrderWithLines' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Order' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'createdAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'updatedAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'active' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'customer' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'firstName' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'lastName' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'lines' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'featuredAsset' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'preview' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'productVariant' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'taxLines' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'taxRate' } },
                                        ],
                                    },
                                },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPrice' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPriceWithTax' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'quantity' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPrice' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPriceWithTax' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'taxRate' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'linePriceWithTax' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'surcharges' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'price' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'subTotal' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'subTotalWithTax' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'totalWithTax' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'totalQuantity' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'currencyCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'shipping' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'shippingWithTax' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'shippingLines' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'shippingMethod' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'shippingAddress' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'ShippingAddress' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'payments' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'Payment' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'fulfillments' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'method' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'trackingCode' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'lines' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'orderLineId' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'quantity' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                ],
            },
        },
    ],
} as unknown as DocumentNode<
    SetDraftOrderShippingAddressMutation,
    SetDraftOrderShippingAddressMutationVariables
>;
export const SetDraftOrderBillingAddressDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'SetDraftOrderBillingAddress' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'orderId' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'CreateAddressInput' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'setDraftOrderBillingAddress' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'orderId' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'orderId' } },
                            },
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'OrderWithLines' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'billingAddress' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            {
                                                kind: 'FragmentSpread',
                                                name: { kind: 'Name', value: 'ShippingAddress' },
                                            },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ShippingAddress' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'OrderAddress' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'fullName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'company' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine1' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine2' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'city' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'province' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'postalCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'country' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'phoneNumber' } },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Payment' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Payment' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'transactionId' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'amount' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'method' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'nextStates' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'metadata' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'refunds' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'reason' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'OrderWithLines' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Order' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'createdAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'updatedAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'active' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'customer' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'firstName' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'lastName' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'lines' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'featuredAsset' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'preview' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'productVariant' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'taxLines' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'taxRate' } },
                                        ],
                                    },
                                },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPrice' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPriceWithTax' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'quantity' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPrice' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPriceWithTax' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'taxRate' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'linePriceWithTax' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'surcharges' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'price' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'subTotal' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'subTotalWithTax' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'totalWithTax' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'totalQuantity' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'currencyCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'shipping' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'shippingWithTax' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'shippingLines' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'shippingMethod' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'shippingAddress' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'ShippingAddress' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'payments' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'Payment' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'fulfillments' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'method' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'trackingCode' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'lines' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'orderLineId' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'quantity' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                ],
            },
        },
    ],
} as unknown as DocumentNode<
    SetDraftOrderBillingAddressMutation,
    SetDraftOrderBillingAddressMutationVariables
>;
export const ApplyCouponCodeToDraftOrderDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'ApplyCouponCodeToDraftOrder' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'orderId' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'couponCode' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'String' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'applyCouponCodeToDraftOrder' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'orderId' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'orderId' } },
                            },
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'couponCode' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'couponCode' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'OrderWithLines' } },
                                {
                                    kind: 'InlineFragment',
                                    typeCondition: {
                                        kind: 'NamedType',
                                        name: { kind: 'Name', value: 'Order' },
                                    },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'couponCodes' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'InlineFragment',
                                    typeCondition: {
                                        kind: 'NamedType',
                                        name: { kind: 'Name', value: 'ErrorResult' },
                                    },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'errorCode' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'message' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ShippingAddress' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'OrderAddress' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'fullName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'company' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine1' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine2' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'city' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'province' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'postalCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'country' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'phoneNumber' } },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Payment' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Payment' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'transactionId' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'amount' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'method' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'nextStates' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'metadata' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'refunds' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'reason' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'OrderWithLines' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Order' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'createdAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'updatedAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'active' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'customer' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'firstName' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'lastName' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'lines' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'featuredAsset' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'preview' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'productVariant' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'taxLines' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'taxRate' } },
                                        ],
                                    },
                                },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPrice' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPriceWithTax' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'quantity' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPrice' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPriceWithTax' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'taxRate' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'linePriceWithTax' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'surcharges' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'price' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'subTotal' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'subTotalWithTax' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'totalWithTax' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'totalQuantity' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'currencyCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'shipping' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'shippingWithTax' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'shippingLines' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'shippingMethod' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'shippingAddress' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'ShippingAddress' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'payments' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'Payment' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'fulfillments' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'method' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'trackingCode' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'lines' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'orderLineId' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'quantity' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                ],
            },
        },
    ],
} as unknown as DocumentNode<
    ApplyCouponCodeToDraftOrderMutation,
    ApplyCouponCodeToDraftOrderMutationVariables
>;
export const RemoveCouponCodeFromDraftOrderDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'RemoveCouponCodeFromDraftOrder' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'orderId' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'couponCode' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'String' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'removeCouponCodeFromDraftOrder' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'orderId' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'orderId' } },
                            },
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'couponCode' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'couponCode' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'OrderWithLines' } },
                                {
                                    kind: 'InlineFragment',
                                    typeCondition: {
                                        kind: 'NamedType',
                                        name: { kind: 'Name', value: 'Order' },
                                    },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'couponCodes' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ShippingAddress' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'OrderAddress' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'fullName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'company' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine1' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine2' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'city' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'province' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'postalCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'country' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'phoneNumber' } },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Payment' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Payment' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'transactionId' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'amount' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'method' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'nextStates' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'metadata' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'refunds' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'reason' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'OrderWithLines' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Order' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'createdAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'updatedAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'active' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'customer' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'firstName' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'lastName' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'lines' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'featuredAsset' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'preview' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'productVariant' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'taxLines' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'taxRate' } },
                                        ],
                                    },
                                },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPrice' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPriceWithTax' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'quantity' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPrice' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPriceWithTax' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'taxRate' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'linePriceWithTax' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'surcharges' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'price' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'subTotal' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'subTotalWithTax' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'totalWithTax' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'totalQuantity' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'currencyCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'shipping' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'shippingWithTax' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'shippingLines' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'shippingMethod' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'shippingAddress' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'ShippingAddress' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'payments' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'Payment' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'fulfillments' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'method' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'trackingCode' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'lines' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'orderLineId' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'quantity' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                ],
            },
        },
    ],
} as unknown as DocumentNode<
    RemoveCouponCodeFromDraftOrderMutation,
    RemoveCouponCodeFromDraftOrderMutationVariables
>;
export const DraftOrderEligibleShippingMethodsDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'DraftOrderEligibleShippingMethods' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'orderId' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'eligibleShippingMethodsForDraftOrder' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'orderId' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'orderId' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'price' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'metadata' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<
    DraftOrderEligibleShippingMethodsQuery,
    DraftOrderEligibleShippingMethodsQueryVariables
>;
export const SetDraftOrderShippingMethodDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'SetDraftOrderShippingMethod' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'orderId' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'shippingMethodId' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'setDraftOrderShippingMethod' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'orderId' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'orderId' } },
                            },
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'shippingMethodId' },
                                value: {
                                    kind: 'Variable',
                                    name: { kind: 'Name', value: 'shippingMethodId' },
                                },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'OrderWithLines' } },
                                {
                                    kind: 'InlineFragment',
                                    typeCondition: {
                                        kind: 'NamedType',
                                        name: { kind: 'Name', value: 'ErrorResult' },
                                    },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'errorCode' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'message' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ShippingAddress' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'OrderAddress' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'fullName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'company' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine1' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'streetLine2' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'city' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'province' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'postalCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'country' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'phoneNumber' } },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Payment' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Payment' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'transactionId' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'amount' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'method' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'nextStates' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'metadata' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'refunds' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'reason' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'OrderWithLines' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Order' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'createdAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'updatedAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'active' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'customer' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'firstName' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'lastName' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'lines' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'featuredAsset' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'preview' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'productVariant' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'taxLines' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'taxRate' } },
                                        ],
                                    },
                                },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPrice' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPriceWithTax' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'quantity' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPrice' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'unitPriceWithTax' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'taxRate' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'linePriceWithTax' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'surcharges' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'price' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'subTotal' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'subTotalWithTax' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'totalWithTax' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'totalQuantity' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'currencyCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'shipping' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'shippingWithTax' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'shippingLines' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'shippingMethod' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'shippingAddress' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'ShippingAddress' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'payments' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'Payment' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'fulfillments' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'method' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'trackingCode' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'lines' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'orderLineId' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'quantity' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'total' } },
                ],
            },
        },
    ],
} as unknown as DocumentNode<
    SetDraftOrderShippingMethodMutation,
    SetDraftOrderShippingMethodMutationVariables
>;
export const GetOrderPlacedAtDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetOrderPlacedAt' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'order' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'id' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'createdAt' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'updatedAt' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'orderPlacedAt' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetOrderPlacedAtQuery, GetOrderPlacedAtQueryVariables>;
export const GetEntityDuplicatorsDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetEntityDuplicators' },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'entityDuplicators' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'requiresPermission' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'forEntities' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'args' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'type' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'defaultValue' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetEntityDuplicatorsQuery, GetEntityDuplicatorsQueryVariables>;
export const DuplicateEntityDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'DuplicateEntity' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'DuplicateEntityInput' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'duplicateEntity' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'InlineFragment',
                                    typeCondition: {
                                        kind: 'NamedType',
                                        name: { kind: 'Name', value: 'DuplicateEntitySuccess' },
                                    },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'newEntityId' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'InlineFragment',
                                    typeCondition: {
                                        kind: 'NamedType',
                                        name: { kind: 'Name', value: 'DuplicateEntityError' },
                                    },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'message' } },
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'duplicationError' },
                                            },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<DuplicateEntityMutation, DuplicateEntityMutationVariables>;
export const IdTest1Document = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'IdTest1' },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'products' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'options' },
                                value: {
                                    kind: 'ObjectValue',
                                    fields: [
                                        {
                                            kind: 'ObjectField',
                                            name: { kind: 'Name', value: 'take' },
                                            value: { kind: 'IntValue', value: '5' },
                                        },
                                    ],
                                },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'items' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [{ kind: 'Field', name: { kind: 'Name', value: 'id' } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<IdTest1Query, IdTest1QueryVariables>;
export const IdTest2Document = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'IdTest2' },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'products' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'options' },
                                value: {
                                    kind: 'ObjectValue',
                                    fields: [
                                        {
                                            kind: 'ObjectField',
                                            name: { kind: 'Name', value: 'take' },
                                            value: { kind: 'IntValue', value: '1' },
                                        },
                                    ],
                                },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'items' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'variants' },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'id' },
                                                        },
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'options' },
                                                            selectionSet: {
                                                                kind: 'SelectionSet',
                                                                selections: [
                                                                    {
                                                                        kind: 'Field',
                                                                        name: { kind: 'Name', value: 'id' },
                                                                    },
                                                                    {
                                                                        kind: 'Field',
                                                                        name: { kind: 'Name', value: 'name' },
                                                                    },
                                                                ],
                                                            },
                                                        },
                                                    ],
                                                },
                                            },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<IdTest2Query, IdTest2QueryVariables>;
export const IdTest3Document = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'IdTest3' },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'product' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'id' },
                                value: { kind: 'StringValue', value: 'T_1', block: false },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'Field', name: { kind: 'Name', value: 'id' } }],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<IdTest3Query, IdTest3QueryVariables>;
export const IdTest4Document = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'IdTest4' },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'updateProduct' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: {
                                    kind: 'ObjectValue',
                                    fields: [
                                        {
                                            kind: 'ObjectField',
                                            name: { kind: 'Name', value: 'id' },
                                            value: { kind: 'StringValue', value: 'T_1', block: false },
                                        },
                                        {
                                            kind: 'ObjectField',
                                            name: { kind: 'Name', value: 'featuredAssetId' },
                                            value: { kind: 'StringValue', value: 'T_3', block: false },
                                        },
                                    ],
                                },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'featuredAsset' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [{ kind: 'Field', name: { kind: 'Name', value: 'id' } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<IdTest4Mutation, IdTest4MutationVariables>;
export const IdTest5Document = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'IdTest5' },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'updateProduct' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: {
                                    kind: 'ObjectValue',
                                    fields: [
                                        {
                                            kind: 'ObjectField',
                                            name: { kind: 'Name', value: 'id' },
                                            value: { kind: 'StringValue', value: 'T_1', block: false },
                                        },
                                        {
                                            kind: 'ObjectField',
                                            name: { kind: 'Name', value: 'translations' },
                                            value: {
                                                kind: 'ListValue',
                                                values: [
                                                    {
                                                        kind: 'ObjectValue',
                                                        fields: [
                                                            {
                                                                kind: 'ObjectField',
                                                                name: { kind: 'Name', value: 'id' },
                                                                value: {
                                                                    kind: 'StringValue',
                                                                    value: 'T_1',
                                                                    block: false,
                                                                },
                                                            },
                                                            {
                                                                kind: 'ObjectField',
                                                                name: { kind: 'Name', value: 'languageCode' },
                                                                value: { kind: 'EnumValue', value: 'en' },
                                                            },
                                                            {
                                                                kind: 'ObjectField',
                                                                name: { kind: 'Name', value: 'name' },
                                                                value: {
                                                                    kind: 'StringValue',
                                                                    value: 'changed',
                                                                    block: false,
                                                                },
                                                            },
                                                        ],
                                                    },
                                                ],
                                            },
                                        },
                                    ],
                                },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<IdTest5Mutation, IdTest5MutationVariables>;
export const IdTest6Document = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'IdTest6' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'product' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'id' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'Field', name: { kind: 'Name', value: 'id' } }],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<IdTest6Query, IdTest6QueryVariables>;
export const IdTest7Document = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'IdTest7' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'UpdateProductInput' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'updateProduct' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'featuredAsset' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [{ kind: 'Field', name: { kind: 'Name', value: 'id' } }],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<IdTest7Mutation, IdTest7MutationVariables>;
export const IdTest8Document = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'IdTest8' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'UpdateProductInput' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'updateProduct' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<IdTest8Mutation, IdTest8MutationVariables>;
export const IdTest9Document = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'IdTest9' },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'products' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'options' },
                                value: {
                                    kind: 'ObjectValue',
                                    fields: [
                                        {
                                            kind: 'ObjectField',
                                            name: { kind: 'Name', value: 'take' },
                                            value: { kind: 'IntValue', value: '1' },
                                        },
                                    ],
                                },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'items' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            {
                                                kind: 'FragmentSpread',
                                                name: { kind: 'Name', value: 'ProdFragment' },
                                            },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ProdFragment' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Product' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'featuredAsset' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'Field', name: { kind: 'Name', value: 'id' } }],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<IdTest9Query, IdTest9QueryVariables>;
export const IdTest10Document = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'IdTest10' },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'products' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'options' },
                                value: {
                                    kind: 'ObjectValue',
                                    fields: [
                                        {
                                            kind: 'ObjectField',
                                            name: { kind: 'Name', value: 'take' },
                                            value: { kind: 'IntValue', value: '1' },
                                        },
                                    ],
                                },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'items' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            {
                                                kind: 'FragmentSpread',
                                                name: { kind: 'Name', value: 'ProdFragment1' },
                                            },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ProdFragment2' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Product' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'featuredAsset' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'Field', name: { kind: 'Name', value: 'id' } }],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ProdFragment1' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Product' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'ProdFragment2' } }],
            },
        },
    ],
} as unknown as DocumentNode<IdTest10Query, IdTest10QueryVariables>;
export const IdTest11Document = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'IdTest11' },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'products' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'options' },
                                value: {
                                    kind: 'ObjectValue',
                                    fields: [
                                        {
                                            kind: 'ObjectField',
                                            name: { kind: 'Name', value: 'take' },
                                            value: { kind: 'IntValue', value: '1' },
                                        },
                                    ],
                                },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'items' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            {
                                                kind: 'FragmentSpread',
                                                name: { kind: 'Name', value: 'ProdFragment1_1' },
                                            },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ProdFragment3_1' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Product' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'featuredAsset' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'Field', name: { kind: 'Name', value: 'id' } }],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ProdFragment2_1' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Product' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'ProdFragment3_1' } }],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ProdFragment1_1' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Product' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'ProdFragment2_1' } }],
            },
        },
    ],
} as unknown as DocumentNode<IdTest11Query, IdTest11QueryVariables>;
export const GetFacetWithValueListDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetFacetWithValueList' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'options' } },
                    type: { kind: 'NamedType', name: { kind: 'Name', value: 'FacetValueListOptions' } },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'facet' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'id' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'isPrivate' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'valueList' },
                                    arguments: [
                                        {
                                            kind: 'Argument',
                                            name: { kind: 'Name', value: 'options' },
                                            value: {
                                                kind: 'Variable',
                                                name: { kind: 'Name', value: 'options' },
                                            },
                                        },
                                    ],
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'items' },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'FragmentSpread',
                                                            name: { kind: 'Name', value: 'FacetValue' },
                                                        },
                                                    ],
                                                },
                                            },
                                            { kind: 'Field', name: { kind: 'Name', value: 'totalItems' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'FacetValue' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'FacetValue' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'translations' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'facet' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetFacetWithValueListQuery, GetFacetWithValueListQueryVariables>;
export const DeleteFacetValuesDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'DeleteFacetValues' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'ids' } },
                    type: {
                        kind: 'NonNullType',
                        type: {
                            kind: 'ListType',
                            type: {
                                kind: 'NonNullType',
                                type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                            },
                        },
                    },
                },
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'force' } },
                    type: { kind: 'NamedType', name: { kind: 'Name', value: 'Boolean' } },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'deleteFacetValues' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'ids' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'ids' } },
                            },
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'force' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'force' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'result' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'message' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<DeleteFacetValuesMutation, DeleteFacetValuesMutationVariables>;
export const DeleteFacetDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'DeleteFacet' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'force' } },
                    type: { kind: 'NamedType', name: { kind: 'Name', value: 'Boolean' } },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'deleteFacet' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'id' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                            },
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'force' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'force' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'result' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'message' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<DeleteFacetMutation, DeleteFacetMutationVariables>;
export const GetProductWithFacetValuesDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetProductWithFacetValues' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'product' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'id' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'facetValues' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'variants' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'facetValues' },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'id' },
                                                        },
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'name' },
                                                        },
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'code' },
                                                        },
                                                    ],
                                                },
                                            },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetProductWithFacetValuesQuery, GetProductWithFacetValuesQueryVariables>;
export const GetProductListWithVariantsDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetProductListWithVariants' },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'products' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'items' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'variants' },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'id' },
                                                        },
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'name' },
                                                        },
                                                    ],
                                                },
                                            },
                                        ],
                                    },
                                },
                                { kind: 'Field', name: { kind: 'Name', value: 'totalItems' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetProductListWithVariantsQuery, GetProductListWithVariantsQueryVariables>;
export const CreateFacetValuesDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'CreateFacetValues' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: {
                            kind: 'ListType',
                            type: {
                                kind: 'NonNullType',
                                type: {
                                    kind: 'NamedType',
                                    name: { kind: 'Name', value: 'CreateFacetValueInput' },
                                },
                            },
                        },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'createFacetValues' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'FacetValue' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'FacetValue' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'FacetValue' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'translations' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'facet' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<CreateFacetValuesMutation, CreateFacetValuesMutationVariables>;
export const UpdateFacetValuesDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'UpdateFacetValues' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: {
                            kind: 'ListType',
                            type: {
                                kind: 'NonNullType',
                                type: {
                                    kind: 'NamedType',
                                    name: { kind: 'Name', value: 'UpdateFacetValueInput' },
                                },
                            },
                        },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'updateFacetValues' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'FacetValue' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'FacetValue' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'FacetValue' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'translations' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'facet' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<UpdateFacetValuesMutation, UpdateFacetValuesMutationVariables>;
export const AssignFacetsToChannelDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'AssignFacetsToChannel' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: {
                            kind: 'NamedType',
                            name: { kind: 'Name', value: 'AssignFacetsToChannelInput' },
                        },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'assignFacetsToChannel' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<AssignFacetsToChannelMutation, AssignFacetsToChannelMutationVariables>;
export const RemoveFacetsFromChannelDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'RemoveFacetsFromChannel' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: {
                            kind: 'NamedType',
                            name: { kind: 'Name', value: 'RemoveFacetsFromChannelInput' },
                        },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'removeFacetsFromChannel' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'InlineFragment',
                                    typeCondition: {
                                        kind: 'NamedType',
                                        name: { kind: 'Name', value: 'Facet' },
                                    },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'InlineFragment',
                                    typeCondition: {
                                        kind: 'NamedType',
                                        name: { kind: 'Name', value: 'FacetInUseError' },
                                    },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'errorCode' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'message' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'productCount' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'variantCount' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<RemoveFacetsFromChannelMutation, RemoveFacetsFromChannelMutationVariables>;
export const GetGlobalSettingsDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetGlobalSettings' },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'globalSettings' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'GlobalSettings' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'GlobalSettings' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'GlobalSettings' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'availableLanguages' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'trackInventory' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'outOfStockThreshold' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'serverConfig' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'orderProcess' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'to' } },
                                        ],
                                    },
                                },
                                { kind: 'Field', name: { kind: 'Name', value: 'permittedAssetTypes' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'permissions' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'assignable' } },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'customFieldConfig' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'Customer' },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'InlineFragment',
                                                            typeCondition: {
                                                                kind: 'NamedType',
                                                                name: { kind: 'Name', value: 'CustomField' },
                                                            },
                                                            selectionSet: {
                                                                kind: 'SelectionSet',
                                                                selections: [
                                                                    {
                                                                        kind: 'Field',
                                                                        name: { kind: 'Name', value: 'name' },
                                                                    },
                                                                ],
                                                            },
                                                        },
                                                    ],
                                                },
                                            },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetGlobalSettingsQuery, GetGlobalSettingsQueryVariables>;
export const SearchProductsAdminDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'SearchProductsAdmin' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'SearchInput' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'search' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'totalItems' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'items' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'enabled' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'productId' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'productName' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'slug' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'productVariantId' },
                                            },
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'productVariantName' },
                                            },
                                            { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<SearchProductsAdminQuery, SearchProductsAdminQueryVariables>;
export const GetOrderWithSellerOrdersDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetOrderWithSellerOrders' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'order' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'id' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'state' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'sellerOrders' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'aggregateOrderId' },
                                            },
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'lines' },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'id' },
                                                        },
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'productVariant' },
                                                            selectionSet: {
                                                                kind: 'SelectionSet',
                                                                selections: [
                                                                    {
                                                                        kind: 'Field',
                                                                        name: { kind: 'Name', value: 'id' },
                                                                    },
                                                                    {
                                                                        kind: 'Field',
                                                                        name: { kind: 'Name', value: 'name' },
                                                                    },
                                                                ],
                                                            },
                                                        },
                                                    ],
                                                },
                                            },
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'shippingLines' },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'id' },
                                                        },
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'shippingMethod' },
                                                            selectionSet: {
                                                                kind: 'SelectionSet',
                                                                selections: [
                                                                    {
                                                                        kind: 'Field',
                                                                        name: { kind: 'Name', value: 'id' },
                                                                    },
                                                                    {
                                                                        kind: 'Field',
                                                                        name: { kind: 'Name', value: 'code' },
                                                                    },
                                                                ],
                                                            },
                                                        },
                                                    ],
                                                },
                                            },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'lines' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'productVariant' },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'id' },
                                                        },
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'name' },
                                                        },
                                                    ],
                                                },
                                            },
                                        ],
                                    },
                                },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'shippingLines' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'shippingMethod' },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'id' },
                                                        },
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'code' },
                                                        },
                                                    ],
                                                },
                                            },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetOrderWithSellerOrdersQuery, GetOrderWithSellerOrdersQueryVariables>;
export const CreateAdministratorDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'CreateAdministrator' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: {
                            kind: 'NamedType',
                            name: { kind: 'Name', value: 'CreateAdministratorInput' },
                        },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'createAdministrator' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'Administrator' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Administrator' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Administrator' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'firstName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'lastName' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'emailAddress' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'user' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'identifier' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'lastLogin' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'roles' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'permissions' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<CreateAdministratorMutation, CreateAdministratorMutationVariables>;
export const UpdateProductDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'UpdateProduct' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'UpdateProductInput' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'updateProduct' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'FragmentSpread',
                                    name: { kind: 'Name', value: 'ProductWithVariants' },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Asset' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Asset' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'fileSize' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'mimeType' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'type' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'preview' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'source' } },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ProductVariant' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'ProductVariant' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'createdAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'updatedAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'enabled' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'currencyCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'price' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'prices' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'currencyCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'price' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'stockOnHand' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'trackInventory' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'taxRateApplied' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'value' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'taxCategory' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'options' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'groupId' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'facetValues' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'facet' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'featuredAsset' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'assets' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'translations' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'channels' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ProductWithVariants' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Product' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'enabled' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'slug' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'featuredAsset' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'assets' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'translations' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'slug' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'optionGroups' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'variants' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'ProductVariant' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'facetValues' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'facet' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'channels' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<UpdateProductMutation, UpdateProductMutationVariables>;
export const CreateProductDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'CreateProduct' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: { kind: 'NamedType', name: { kind: 'Name', value: 'CreateProductInput' } },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'createProduct' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'FragmentSpread',
                                    name: { kind: 'Name', value: 'ProductWithVariants' },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Asset' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Asset' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'fileSize' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'mimeType' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'type' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'preview' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'source' } },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ProductVariant' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'ProductVariant' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'createdAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'updatedAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'enabled' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'currencyCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'price' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'prices' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'currencyCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'price' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'stockOnHand' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'trackInventory' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'taxRateApplied' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'value' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'taxCategory' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'options' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'groupId' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'facetValues' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'facet' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'featuredAsset' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'assets' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'translations' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'channels' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ProductWithVariants' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Product' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'enabled' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'slug' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'featuredAsset' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'assets' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'translations' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'slug' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'optionGroups' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'variants' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'ProductVariant' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'facetValues' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'facet' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'channels' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<CreateProductMutation, CreateProductMutationVariables>;
export const GetProductWithVariantsDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetProductWithVariants' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                    type: { kind: 'NamedType', name: { kind: 'Name', value: 'ID' } },
                },
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'slug' } },
                    type: { kind: 'NamedType', name: { kind: 'Name', value: 'String' } },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'product' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'slug' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'slug' } },
                            },
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'id' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'id' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'FragmentSpread',
                                    name: { kind: 'Name', value: 'ProductWithVariants' },
                                },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Asset' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Asset' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'fileSize' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'mimeType' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'type' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'preview' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'source' } },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ProductVariant' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'ProductVariant' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'createdAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'updatedAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'enabled' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'currencyCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'price' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'prices' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'currencyCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'price' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'stockOnHand' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'trackInventory' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'taxRateApplied' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'value' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'taxCategory' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'options' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'groupId' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'facetValues' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'facet' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'featuredAsset' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'assets' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'translations' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'channels' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ProductWithVariants' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Product' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'enabled' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'slug' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'featuredAsset' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'assets' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'translations' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'slug' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'description' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'optionGroups' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'variants' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'ProductVariant' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'facetValues' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'facet' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'channels' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetProductWithVariantsQuery, GetProductWithVariantsQueryVariables>;
export const GetProductListDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'query',
            name: { kind: 'Name', value: 'GetProductList' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'options' } },
                    type: { kind: 'NamedType', name: { kind: 'Name', value: 'ProductListOptions' } },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'products' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'options' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'options' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'items' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'slug' } },
                                            {
                                                kind: 'Field',
                                                name: { kind: 'Name', value: 'featuredAsset' },
                                                selectionSet: {
                                                    kind: 'SelectionSet',
                                                    selections: [
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'id' },
                                                        },
                                                        {
                                                            kind: 'Field',
                                                            name: { kind: 'Name', value: 'preview' },
                                                        },
                                                    ],
                                                },
                                            },
                                        ],
                                    },
                                },
                                { kind: 'Field', name: { kind: 'Name', value: 'totalItems' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<GetProductListQuery, GetProductListQueryVariables>;
export const CreateProductVariantsDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'CreateProductVariants' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: {
                            kind: 'ListType',
                            type: {
                                kind: 'NonNullType',
                                type: {
                                    kind: 'NamedType',
                                    name: { kind: 'Name', value: 'CreateProductVariantInput' },
                                },
                            },
                        },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'createProductVariants' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'ProductVariant' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Asset' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Asset' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'fileSize' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'mimeType' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'type' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'preview' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'source' } },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'ProductVariant' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'ProductVariant' } },
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'createdAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'updatedAt' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'enabled' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'currencyCode' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'price' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'priceWithTax' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'prices' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'currencyCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'price' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'stockOnHand' } },
                    { kind: 'Field', name: { kind: 'Name', value: 'trackInventory' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'taxRateApplied' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'value' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'taxCategory' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    { kind: 'Field', name: { kind: 'Name', value: 'sku' } },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'options' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'groupId' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'facetValues' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                {
                                    kind: 'Field',
                                    name: { kind: 'Name', value: 'facet' },
                                    selectionSet: {
                                        kind: 'SelectionSet',
                                        selections: [
                                            { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                            { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                                        ],
                                    },
                                },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'featuredAsset' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'assets' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [{ kind: 'FragmentSpread', name: { kind: 'Name', value: 'Asset' } }],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'translations' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'languageCode' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'name' } },
                            ],
                        },
                    },
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'channels' },
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'Field', name: { kind: 'Name', value: 'id' } },
                                { kind: 'Field', name: { kind: 'Name', value: 'code' } },
                            ],
                        },
                    },
                ],
            },
        },
    ],
} as unknown as DocumentNode<CreateProductVariantsMutation, CreateProductVariantsMutationVariables>;
export const UpdateProductVariantsDocument = {
    kind: 'Document',
    definitions: [
        {
            kind: 'OperationDefinition',
            operation: 'mutation',
            name: { kind: 'Name', value: 'UpdateProductVariants' },
            variableDefinitions: [
                {
                    kind: 'VariableDefinition',
                    variable: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                    type: {
                        kind: 'NonNullType',
                        type: {
                            kind: 'ListType',
                            type: {
                                kind: 'NonNullType',
                                type: {
                                    kind: 'NamedType',
                                    name: { kind: 'Name', value: 'UpdateProductVariantInput' },
                                },
                            },
                        },
                    },
                },
            ],
            selectionSet: {
                kind: 'SelectionSet',
                selections: [
                    {
                        kind: 'Field',
                        name: { kind: 'Name', value: 'updateProductVariants' },
                        arguments: [
                            {
                                kind: 'Argument',
                                name: { kind: 'Name', value: 'input' },
                                value: { kind: 'Variable', name: { kind: 'Name', value: 'input' } },
                            },
                        ],
                        selectionSet: {
                            kind: 'SelectionSet',
                            selections: [
                                { kind: 'FragmentSpread', name: { kind: 'Name', value: 'ProductVariant' } },
                            ],
                        },
                    },
                ],
            },
        },
        {
            kind: 'FragmentDefinition',
            name: { kind: 'Name', value: 'Asset' },
            typeCondition: { kind: 'NamedType', name: { kind: 'Name', value: 'Asset' } },
            selectionSet: {
                k