/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage.avro;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.pig.piggybank.storage.avro.ASCommons;
import org.apache.pig.piggybank.storage.avro.ASLog;

public class AvroSchemaManager {
    Map<String, Schema> name2Schema = new HashMap<String, Schema>();
    Map<String, Schema> typeName2Schema = new HashMap<String, Schema>();

    public AvroSchemaManager(Schema schema) {
        this.init(null, schema, false);
    }

    private boolean isNamedSchema(Schema schema) {
        Schema.Type type = schema.getType();
        return type.equals((Object)Schema.Type.RECORD) || type.equals((Object)Schema.Type.ENUM) || type.equals((Object)Schema.Type.FIXED);
    }

    protected void init(String namespace, Schema schema, boolean ignoreNameMap) {
        if (this.isNamedSchema(schema)) {
            String typeName = schema.getName();
            if (this.typeName2Schema.containsKey(typeName)) {
                ASLog.warn("Duplicate schemas defined for type:" + typeName + ". will ignore the second one:" + schema);
            } else {
                ASLog.details("add " + schema.getName() + "=" + schema + " to type2Schema");
                this.typeName2Schema.put(schema.getName(), schema);
            }
        }
        if (schema.getType().equals((Object)Schema.Type.RECORD)) {
            List fields = schema.getFields();
            for (Schema.Field field : fields) {
                String name;
                Schema fieldSchema = field.schema();
                String string = name = namespace == null ? field.name() : namespace + "." + field.name();
                if (!ignoreNameMap) {
                    if (this.name2Schema.containsKey(name)) {
                        ASLog.warn("Duplicate schemas defined for alias:" + name + ". Will ignore the second one:" + fieldSchema);
                    } else {
                        ASLog.details("add " + name + "=" + fieldSchema + " to name2Schema");
                        this.name2Schema.put(name, fieldSchema);
                    }
                }
                this.init(name, fieldSchema, ignoreNameMap);
            }
        } else if (schema.getType().equals((Object)Schema.Type.UNION)) {
            if (ASCommons.isAcceptableUnion(schema)) {
                Schema realSchema = ASCommons.getAcceptedType(schema);
                this.init(namespace, realSchema, ignoreNameMap);
            } else {
                List list = schema.getTypes();
                for (Schema s : list) {
                    this.init(namespace, s, true);
                }
            }
        } else if (schema.getType().equals((Object)Schema.Type.ARRAY)) {
            Schema elemSchema = schema.getElementType();
            this.init(namespace, elemSchema, true);
        } else if (schema.getType().equals((Object)Schema.Type.MAP)) {
            Schema valueSchema = schema.getValueType();
            this.init(namespace, valueSchema, true);
        }
    }

    public Schema getSchema(String name) {
        Schema schema = this.typeName2Schema.get(name);
        schema = schema == null ? this.name2Schema.get(name) : schema;
        return schema;
    }
}

