/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage;

import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.pig.FileInputLoadFunc;
import org.apache.pig.LoadPushDown;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigTextInputFormat;
import org.apache.pig.bzip2r.Bzip2TextInputFormat;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.ObjectSerializer;
import org.apache.pig.impl.util.UDFContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVLoader
extends FileInputLoadFunc
implements LoadPushDown {
    protected RecordReader in = null;
    protected static final Log LOG = LogFactory.getLog(CSVLoader.class);
    private static final byte DOUBLE_QUOTE = 34;
    private static final byte FIELD_DEL = 44;
    private static final byte RECORD_DEL = 10;
    long end = Long.MAX_VALUE;
    private ArrayList<Object> mProtoTuple = null;
    private TupleFactory mTupleFactory = TupleFactory.getInstance();
    private String signature;
    private String loadLocation;
    private boolean[] mRequiredColumns = null;
    private boolean mRequiredColumnsInitialized = false;

    public Tuple getNext() throws IOException {
        this.mProtoTuple = new ArrayList();
        boolean inField = false;
        boolean inQuotedField = false;
        boolean evenQuotesSeen = true;
        if (!this.mRequiredColumnsInitialized) {
            if (this.signature != null) {
                Properties p = UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass());
                this.mRequiredColumns = (boolean[])ObjectSerializer.deserialize((String)p.getProperty(this.signature));
            }
            this.mRequiredColumnsInitialized = true;
        }
        try {
            if (!this.in.nextKeyValue()) {
                return null;
            }
            Text value = (Text)this.in.getCurrentValue();
            byte[] buf = value.getBytes();
            int len = value.getLength();
            int fieldID = 0;
            ByteBuffer fieldBuffer = ByteBuffer.allocate(len);
            for (int i = 0; i < len; ++i) {
                byte b = buf[i];
                inField = true;
                if (inQuotedField) {
                    if (b == 34) {
                        boolean bl = evenQuotesSeen = !evenQuotesSeen;
                        if (!evenQuotesSeen) continue;
                        fieldBuffer.put((byte)34);
                        continue;
                    }
                    if (!(evenQuotesSeen || b != 44 && b != 10)) {
                        inQuotedField = false;
                        inField = false;
                        this.readField(fieldBuffer, fieldID++);
                        continue;
                    }
                    fieldBuffer.put(b);
                    continue;
                }
                if (b == 34) {
                    inQuotedField = true;
                    evenQuotesSeen = true;
                    continue;
                }
                if (b == 44) {
                    inField = false;
                    this.readField(fieldBuffer, fieldID++);
                    continue;
                }
                evenQuotesSeen = true;
                fieldBuffer.put(b);
            }
            if (inField) {
                this.readField(fieldBuffer, fieldID++);
            }
        }
        catch (InterruptedException e) {
            int errCode = 6018;
            String errMsg = "Error while reading input";
            throw new ExecException(errMsg, errCode, 16, (Throwable)e);
        }
        Tuple t = this.mTupleFactory.newTupleNoCopy(this.mProtoTuple);
        return t;
    }

    private void readField(ByteBuffer buf, int fieldID) {
        if (this.mRequiredColumns == null || this.mRequiredColumns.length > fieldID && this.mRequiredColumns[fieldID]) {
            byte[] bytes = new byte[buf.position()];
            buf.rewind();
            buf.get(bytes, 0, bytes.length);
            this.mProtoTuple.add(new DataByteArray(bytes));
        }
        buf.clear();
    }

    public void setLocation(String location, Job job) throws IOException {
        this.loadLocation = location;
        FileInputFormat.setInputPaths((Job)job, (String)location);
    }

    public InputFormat getInputFormat() throws IOException {
        if (this.loadLocation.endsWith(".bz2") || this.loadLocation.endsWith(".bz")) {
            return new Bzip2TextInputFormat();
        }
        return new PigTextInputFormat();
    }

    public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        this.in = reader;
    }

    public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
        if (requiredFieldList == null) {
            return null;
        }
        if (requiredFieldList.getFields() != null) {
            int lastColumn = -1;
            for (LoadPushDown.RequiredField rf : requiredFieldList.getFields()) {
                if (rf.getIndex() <= lastColumn) continue;
                lastColumn = rf.getIndex();
            }
            this.mRequiredColumns = new boolean[lastColumn + 1];
            for (LoadPushDown.RequiredField rf : requiredFieldList.getFields()) {
                if (rf.getIndex() == -1) continue;
                this.mRequiredColumns[rf.getIndex()] = true;
            }
            Properties p = UDFContext.getUDFContext().getUDFProperties(((Object)((Object)this)).getClass());
            try {
                p.setProperty(this.signature, ObjectSerializer.serialize((Serializable)this.mRequiredColumns));
            }
            catch (Exception e) {
                throw new RuntimeException("Cannot serialize mRequiredColumns");
            }
        }
        return new LoadPushDown.RequiredFieldResponse(true);
    }

    public void setUDFContextSignature(String signature) {
        this.signature = signature;
    }

    public List<LoadPushDown.OperatorSet> getFeatures() {
        return Arrays.asList(LoadPushDown.OperatorSet.PROJECTION);
    }
}

