/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.evaluation.string;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.hadoop.datastorage.ConfigurationUtil;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigMapReduce;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.io.FileLocalizer;
import org.apache.pig.impl.logicalLayer.schema.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LookupInFiles
extends EvalFunc<Integer> {
    boolean initialized = false;
    ArrayList<String> mFiles = new ArrayList();
    Map<String, Boolean> mKeys = new HashMap<String, Boolean>();
    static Map<ArrayList<String>, Map<String, Boolean>> mTables = new HashMap<ArrayList<String>, Map<String, Boolean>>();

    public Schema outputSchema(Schema input) {
        try {
            return new Schema(new Schema.FieldSchema(this.getSchemaName(((Object)((Object)this)).getClass().getName().toLowerCase(), input), 10));
        }
        catch (Exception e) {
            return null;
        }
    }

    public void init(Tuple tuple) throws IOException {
        for (int count = 1; count < tuple.size(); ++count) {
            if (!(tuple.get(count) instanceof String)) {
                String msg = "LookupInFiles : Filename should be a string.";
                throw new IOException(msg);
            }
            this.mFiles.add((String)tuple.get(count));
        }
        if (mTables.containsKey(this.mFiles)) {
            this.mKeys = mTables.get(this.mFiles);
        } else {
            Properties props = ConfigurationUtil.toProperties((Configuration)PigMapReduce.sJobConf);
            for (int i = 0; i < this.mFiles.size(); ++i) {
                BufferedReader reader = null;
                InputStream is = null;
                try {
                    is = FileLocalizer.openDFSFile((String)this.mFiles.get(i), (Properties)props);
                }
                catch (IOException e) {
                    String msg = "LookupInFiles : Cannot open file " + this.mFiles.get(i);
                    throw new IOException(msg, e);
                }
                try {
                    String line;
                    reader = new BufferedReader(new InputStreamReader(is));
                    while ((line = reader.readLine()) != null) {
                        if (this.mKeys.containsKey(line)) continue;
                        this.mKeys.put(line, true);
                    }
                    is.close();
                    continue;
                }
                catch (IOException e) {
                    String msg = "LookupInFiles : Cannot read file " + this.mFiles.get(i);
                    throw new IOException(msg, e);
                }
            }
            mTables.put(this.mFiles, this.mKeys);
        }
        this.initialized = true;
    }

    public Integer exec(Tuple input) throws IOException {
        if (!this.initialized) {
            this.init(input);
        }
        if (input.get(0) == null) {
            return null;
        }
        if (this.mKeys.containsKey(input.get(0).toString())) {
            return 1;
        }
        return 0;
    }
}

