/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.evaluation;

import java.io.IOException;
import java.util.Iterator;
import org.apache.pig.Algebraic;
import org.apache.pig.EvalFunc;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.PigProgressable;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaxTupleBy1stField
extends EvalFunc<Tuple>
implements Algebraic {
    private static final int PROGRESS_FREQUENCY = 10;

    public Schema outputSchema(Schema input) {
        return input;
    }

    public Tuple exec(Tuple input) throws IOException {
        try {
            return MaxTupleBy1stField.max(input, this.reporter);
        }
        catch (ExecException ee) {
            IOException oughtToBeEE = new IOException();
            oughtToBeEE.initCause(ee);
            throw oughtToBeEE;
        }
    }

    protected static Tuple max(Tuple input, PigProgressable reporter) throws ExecException {
        DataBag values = (DataBag)input.get(0);
        if (values.size() == 0L) {
            return null;
        }
        long curMax = 0L;
        Tuple curMaxTuple = null;
        int n = 0;
        Iterator it = values.iterator();
        while (it.hasNext()) {
            if (reporter != null && ++n % 10 == 0) {
                reporter.progress();
            }
            Tuple t = (Tuple)it.next();
            try {
                long d = (Long)t.get(0);
                if (curMaxTuple != null && d <= curMax) continue;
                curMax = d;
                curMaxTuple = t;
            }
            catch (RuntimeException exp) {
                ExecException newE = new ExecException("Error processing: " + t.toString() + exp.getMessage());
                newE.initCause((Throwable)exp);
                throw newE;
            }
        }
        return curMaxTuple;
    }

    public String getInitial() {
        return Initial.class.getName();
    }

    public String getIntermed() {
        return Intermediate.class.getName();
    }

    public String getFinal() {
        return Final.class.getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Final
    extends EvalFunc<Tuple> {
        public Tuple exec(Tuple input) throws IOException {
            try {
                return MaxTupleBy1stField.max(input, this.reporter);
            }
            catch (ExecException ee) {
                IOException oughtToBeEE = new IOException();
                oughtToBeEE.initCause(ee);
                throw oughtToBeEE;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Intermediate
    extends EvalFunc<Tuple> {
        public Tuple exec(Tuple input) throws IOException {
            try {
                return MaxTupleBy1stField.max(input, this.reporter);
            }
            catch (ExecException ee) {
                IOException oughtToBeEE = new IOException();
                oughtToBeEE.initCause(ee);
                throw oughtToBeEE;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Initial
    extends EvalFunc<Tuple> {
        public Tuple exec(Tuple input) throws IOException {
            try {
                DataBag bg = (DataBag)input.get(0);
                Tuple tp = (Tuple)bg.iterator().next();
                return tp;
            }
            catch (ExecException ee) {
                IOException oughtToBeEE = new IOException();
                oughtToBeEE.initCause(ee);
                throw oughtToBeEE;
            }
        }
    }
}

